#ifndef __SXM_SMS_WEATHERFIDEBUGVISITOR_H__
#define __SXM_SMS_WEATHERFIDEBUGVISITOR_H__

class MY_DECL sxm_sms_weatherfi_tclPrintVisitor : public sxm_sms_weatherfi_tclVisitorBase {

private:
   /* default constructor */ sxm_sms_weatherfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   sxm_sms_weatherfi_tclPrintVisitor(fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_Reserved(sxm_sms_weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s32_Foot(fi_tcl_s32_Foot& o_s32_Foot);
   virtual tVoid vVisit_s32_MilliSecond(fi_tcl_s32_MilliSecond& o_s32_MilliSecond);
   virtual tBool bDoExpand_POSIXTime(sxm_sms_weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s16_Knot(fi_tcl_s16_Knot& o_s16_Knot);
   virtual tVoid vVisit_s32_Pascal(fi_tcl_s32_Pascal& o_s32_Pascal);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tBool bDoExpand_PositionWGS84(sxm_sms_weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s16_Degree(fi_tcl_s16_Degree& o_s16_Degree);
   virtual tBool bDoExpand_BinContainer(sxm_sms_weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_SXMTileType(fi_tcl_e8_SXMTileType& o_e8_SXMTileType);
   virtual tVoid vVisit_e8_SXMShapeType(fi_tcl_e8_SXMShapeType& o_e8_SXMShapeType);
   virtual tVoid vVisit_e8_SXMTileDataType(fi_tcl_e8_SXMTileDataType& o_e8_SXMTileDataType);
   virtual tBool bDoExpand_SXMSharedMemoryDescription(sxm_sms_weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SXMSharedMemoryTile(sxm_sms_weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SXMShape(sxm_sms_weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_FrontType(fi_tcl_e8_FrontType& o_e8_FrontType);
   virtual tVoid vVisit_e8_PressureType(fi_tcl_e8_PressureType& o_e8_PressureType);
   virtual tBool bDoExpand_SXMShapeTypeIsobar(sxm_sms_weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SXMShapeTypeWindRadius(sxm_sms_weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_StormPositionType(fi_tcl_e8_StormPositionType& o_e8_StormPositionType);
   virtual tVoid vVisit_e8_StormType(fi_tcl_e8_StormType& o_e8_StormType);
   virtual tVoid vVisit_b8_StormType(fi_tcl_b8_StormType& o_b8_StormType);
   virtual tBool bDoExpand_SXMShapeTypeStormAttributes(sxm_sms_weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SXMShapeTypeFront(sxm_sms_weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SXMShapeTypePressureCenter(sxm_sms_weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SXMShapeTypeStormPosition(sxm_sms_weatherfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SXMShapeTypeStormTrack(sxm_sms_weatherfi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   fi_tclOutput* poOutput;
};


class MY_DECL sxm_sms_weatherfi_tclRandomInitVisitor : public sxm_sms_weatherfi_tclVisitorBase {
public:

   sxm_sms_weatherfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_s32_Foot(fi_tcl_s32_Foot& o_s32_Foot);
   virtual tVoid vVisit_s32_MilliSecond(fi_tcl_s32_MilliSecond& o_s32_MilliSecond);
   virtual tVoid vVisit_s16_Knot(fi_tcl_s16_Knot& o_s16_Knot);
   virtual tVoid vVisit_s32_Pascal(fi_tcl_s32_Pascal& o_s32_Pascal);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tVoid vVisit_s16_Degree(fi_tcl_s16_Degree& o_s16_Degree);
   virtual tVoid vVisit_e8_SXMTileType(fi_tcl_e8_SXMTileType& o_e8_SXMTileType);
   virtual tVoid vVisit_e8_SXMShapeType(fi_tcl_e8_SXMShapeType& o_e8_SXMShapeType);
   virtual tVoid vVisit_e8_SXMTileDataType(fi_tcl_e8_SXMTileDataType& o_e8_SXMTileDataType);
   virtual tVoid vVisit_e8_FrontType(fi_tcl_e8_FrontType& o_e8_FrontType);
   virtual tVoid vVisit_e8_PressureType(fi_tcl_e8_PressureType& o_e8_PressureType);
   virtual tVoid vVisit_e8_StormPositionType(fi_tcl_e8_StormPositionType& o_e8_StormPositionType);
   virtual tVoid vVisit_e8_StormType(fi_tcl_e8_StormType& o_e8_StormType);
   virtual tVoid vVisit_b8_StormType(fi_tcl_b8_StormType& o_b8_StormType);
	tU32 u32ListSize;
};

#endif
