/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef STATFITYPES_HEADER
#define STATFITYPES_HEADER

// #include <vector>
// 


class statfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class statfi_tclMsgGetRecordedDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgGetRecordedDataMethodStart():NavRectangle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgGetRecordedDataMethodStart& operator=(const statfi_tclMsgGetRecordedDataMethodStart& coRef);
   statfi_tclMsgGetRecordedDataMethodStart(const statfi_tclMsgGetRecordedDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RectangleWGS84 NavRectangle;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgGetRecordedDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_GETRECORDEDDATAMETHODSTART;}
};

class statfi_tclMsgGetRecordedDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgGetRecordedDataMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgGetRecordedDataMethodResult& operator=(const statfi_tclMsgGetRecordedDataMethodResult& coRef);
   statfi_tclMsgGetRecordedDataMethodResult(const statfi_tclMsgGetRecordedDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_OnroadOffroadPositions, std::allocator<fi_tcl_OnroadOffroadPositions> > OnroadOffroadPositionList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgGetRecordedDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_GETRECORDEDDATAMETHODRESULT;}
};

class statfi_tclMsgGetRecordedDataMethodResultFirst : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgGetRecordedDataMethodResultFirst() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgGetRecordedDataMethodResultFirst& operator=(const statfi_tclMsgGetRecordedDataMethodResultFirst& coRef);
   statfi_tclMsgGetRecordedDataMethodResultFirst(const statfi_tclMsgGetRecordedDataMethodResultFirst& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_OnroadOffroadPositions, std::allocator<fi_tcl_OnroadOffroadPositions> > OnroadOffroadPositionList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgGetRecordedDataMethodResultFirst& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_GETRECORDEDDATAMETHODRESULTFIRST;}
};

class statfi_tclMsgGetRecordedDataMethodResultMiddle : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgGetRecordedDataMethodResultMiddle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgGetRecordedDataMethodResultMiddle& operator=(const statfi_tclMsgGetRecordedDataMethodResultMiddle& coRef);
   statfi_tclMsgGetRecordedDataMethodResultMiddle(const statfi_tclMsgGetRecordedDataMethodResultMiddle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_OnroadOffroadPositions, std::allocator<fi_tcl_OnroadOffroadPositions> > OnroadOffroadPositionList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgGetRecordedDataMethodResultMiddle& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_GETRECORDEDDATAMETHODRESULTMIDDLE;}
};

class statfi_tclMsgGetRecordedDataMethodResultLast : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgGetRecordedDataMethodResultLast() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgGetRecordedDataMethodResultLast& operator=(const statfi_tclMsgGetRecordedDataMethodResultLast& coRef);
   statfi_tclMsgGetRecordedDataMethodResultLast(const statfi_tclMsgGetRecordedDataMethodResultLast& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_OnroadOffroadPositions, std::allocator<fi_tcl_OnroadOffroadPositions> > OnroadOffroadPositionList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgGetRecordedDataMethodResultLast& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_GETRECORDEDDATAMETHODRESULTLAST;}
};

class statfi_tclMsgSetRecordingModeAndStartRecordingMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgSetRecordingModeAndStartRecordingMethodStart():RecordedBreadCrumbTypes() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgSetRecordingModeAndStartRecordingMethodStart& operator=(const statfi_tclMsgSetRecordingModeAndStartRecordingMethodStart& coRef);
   statfi_tclMsgSetRecordingModeAndStartRecordingMethodStart(const statfi_tclMsgSetRecordingModeAndStartRecordingMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b8_BreadCrumbTypes RecordedBreadCrumbTypes;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgSetRecordingModeAndStartRecordingMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_SETRECORDINGMODEANDSTARTRECORDINGMETHODSTART;}
};

class statfi_tclMsgSetRecordingModeAndStartRecordingMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgSetRecordingModeAndStartRecordingMethodResult():RecordedBreadCrumbTypes() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgSetRecordingModeAndStartRecordingMethodResult& operator=(const statfi_tclMsgSetRecordingModeAndStartRecordingMethodResult& coRef);
   statfi_tclMsgSetRecordingModeAndStartRecordingMethodResult(const statfi_tclMsgSetRecordingModeAndStartRecordingMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b8_BreadCrumbTypes RecordedBreadCrumbTypes;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgSetRecordingModeAndStartRecordingMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_SETRECORDINGMODEANDSTARTRECORDINGMETHODRESULT;}
};

class statfi_tclMsgDeleteAllBreadCrumbsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgDeleteAllBreadCrumbsMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgDeleteAllBreadCrumbsMethodStart& operator=(const statfi_tclMsgDeleteAllBreadCrumbsMethodStart& coRef);
   statfi_tclMsgDeleteAllBreadCrumbsMethodStart(const statfi_tclMsgDeleteAllBreadCrumbsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgDeleteAllBreadCrumbsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_DELETEALLBREADCRUMBSMETHODSTART;}
};

class statfi_tclMsgDeleteAllBreadCrumbsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgDeleteAllBreadCrumbsMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgDeleteAllBreadCrumbsMethodResult& operator=(const statfi_tclMsgDeleteAllBreadCrumbsMethodResult& coRef);
   statfi_tclMsgDeleteAllBreadCrumbsMethodResult(const statfi_tclMsgDeleteAllBreadCrumbsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgDeleteAllBreadCrumbsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_DELETEALLBREADCRUMBSMETHODRESULT;}
};

class statfi_tclMsgGetDrivenRouteDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgGetDrivenRouteDataMethodStart():NavRectangle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgGetDrivenRouteDataMethodStart& operator=(const statfi_tclMsgGetDrivenRouteDataMethodStart& coRef);
   statfi_tclMsgGetDrivenRouteDataMethodStart(const statfi_tclMsgGetDrivenRouteDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RectangleWGS84 NavRectangle;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgGetDrivenRouteDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_GETDRIVENROUTEDATAMETHODSTART;}
};

class statfi_tclMsgGetDrivenRouteDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgGetDrivenRouteDataMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgGetDrivenRouteDataMethodResult& operator=(const statfi_tclMsgGetDrivenRouteDataMethodResult& coRef);
   statfi_tclMsgGetDrivenRouteDataMethodResult(const statfi_tclMsgGetDrivenRouteDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_OnroadOffroadPositions, std::allocator<fi_tcl_OnroadOffroadPositions> > OnroadOffroadPositionList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgGetDrivenRouteDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_GETDRIVENROUTEDATAMETHODRESULT;}
};

class statfi_tclMsgGetDrivenRouteDataMethodResultFirst : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgGetDrivenRouteDataMethodResultFirst() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgGetDrivenRouteDataMethodResultFirst& operator=(const statfi_tclMsgGetDrivenRouteDataMethodResultFirst& coRef);
   statfi_tclMsgGetDrivenRouteDataMethodResultFirst(const statfi_tclMsgGetDrivenRouteDataMethodResultFirst& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_OnroadOffroadPositions, std::allocator<fi_tcl_OnroadOffroadPositions> > OnroadOffroadPositionList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgGetDrivenRouteDataMethodResultFirst& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_GETDRIVENROUTEDATAMETHODRESULTFIRST;}
};

class statfi_tclMsgGetDrivenRouteDataMethodResultMiddle : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgGetDrivenRouteDataMethodResultMiddle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgGetDrivenRouteDataMethodResultMiddle& operator=(const statfi_tclMsgGetDrivenRouteDataMethodResultMiddle& coRef);
   statfi_tclMsgGetDrivenRouteDataMethodResultMiddle(const statfi_tclMsgGetDrivenRouteDataMethodResultMiddle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_OnroadOffroadPositions, std::allocator<fi_tcl_OnroadOffroadPositions> > OnroadOffroadPositionList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgGetDrivenRouteDataMethodResultMiddle& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_GETDRIVENROUTEDATAMETHODRESULTMIDDLE;}
};

class statfi_tclMsgGetDrivenRouteDataMethodResultLast : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgGetDrivenRouteDataMethodResultLast() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgGetDrivenRouteDataMethodResultLast& operator=(const statfi_tclMsgGetDrivenRouteDataMethodResultLast& coRef);
   statfi_tclMsgGetDrivenRouteDataMethodResultLast(const statfi_tclMsgGetDrivenRouteDataMethodResultLast& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_OnroadOffroadPositions, std::allocator<fi_tcl_OnroadOffroadPositions> > OnroadOffroadPositionList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgGetDrivenRouteDataMethodResultLast& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_GETDRIVENROUTEDATAMETHODRESULTLAST;}
};

class statfi_tclMsgGetProfileDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgGetProfileDataMethodStart():NavDataSetID() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgGetProfileDataMethodStart& operator=(const statfi_tclMsgGetProfileDataMethodStart& coRef);
   statfi_tclMsgGetProfileDataMethodStart(const statfi_tclMsgGetProfileDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId NavDataSetID;
   std::vector<fi_tcl_CountryTimes, std::allocator<fi_tcl_CountryTimes> > CountryTimeList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgGetProfileDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_GETPROFILEDATAMETHODSTART;}
};

class statfi_tclMsgGetProfileDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgGetProfileDataMethodResult():NavDataSetID() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgGetProfileDataMethodResult& operator=(const statfi_tclMsgGetProfileDataMethodResult& coRef);
   statfi_tclMsgGetProfileDataMethodResult(const statfi_tclMsgGetProfileDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId NavDataSetID;
   std::vector<fi_tcl_ProfileDataList, std::allocator<fi_tcl_ProfileDataList> > ProfileDataList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgGetProfileDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_GETPROFILEDATAMETHODRESULT;}
};

class statfi_tclMsgCurrentPositionGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgCurrentPositionGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgCurrentPositionGet& operator=(const statfi_tclMsgCurrentPositionGet& coRef);
   statfi_tclMsgCurrentPositionGet(const statfi_tclMsgCurrentPositionGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgCurrentPositionGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_CURRENTPOSITIONGET;}
};

class statfi_tclMsgCurrentPositionUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgCurrentPositionUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgCurrentPositionUpReg& operator=(const statfi_tclMsgCurrentPositionUpReg& coRef);
   statfi_tclMsgCurrentPositionUpReg(const statfi_tclMsgCurrentPositionUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgCurrentPositionUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_CURRENTPOSITIONUPREG;}
};

class statfi_tclMsgCurrentPositionRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgCurrentPositionRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgCurrentPositionRelUpReg& operator=(const statfi_tclMsgCurrentPositionRelUpReg& coRef);
   statfi_tclMsgCurrentPositionRelUpReg(const statfi_tclMsgCurrentPositionRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgCurrentPositionRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_CURRENTPOSITIONRELUPREG;}
};

class statfi_tclMsgCurrentPositionStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgCurrentPositionStatus():CurrentPosition(),bPositionIsOnroad(0),b8StatusInfoBits(),bConnectedToPreviousPoint(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgCurrentPositionStatus& operator=(const statfi_tclMsgCurrentPositionStatus& coRef);
   statfi_tclMsgCurrentPositionStatus(const statfi_tclMsgCurrentPositionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionWGS84 CurrentPosition;
   tBool bPositionIsOnroad;
   fi_tcl_b8_StatPosStatusInfo b8StatusInfoBits;
   tBool bConnectedToPreviousPoint;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgCurrentPositionStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_CURRENTPOSITIONSTATUS;}
};

class statfi_tclMsgRecordingStatusGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgRecordingStatusGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgRecordingStatusGet& operator=(const statfi_tclMsgRecordingStatusGet& coRef);
   statfi_tclMsgRecordingStatusGet(const statfi_tclMsgRecordingStatusGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgRecordingStatusGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_RECORDINGSTATUSGET;}
};

class statfi_tclMsgRecordingStatusUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgRecordingStatusUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgRecordingStatusUpReg& operator=(const statfi_tclMsgRecordingStatusUpReg& coRef);
   statfi_tclMsgRecordingStatusUpReg(const statfi_tclMsgRecordingStatusUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgRecordingStatusUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_RECORDINGSTATUSUPREG;}
};

class statfi_tclMsgRecordingStatusRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgRecordingStatusRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgRecordingStatusRelUpReg& operator=(const statfi_tclMsgRecordingStatusRelUpReg& coRef);
   statfi_tclMsgRecordingStatusRelUpReg(const statfi_tclMsgRecordingStatusRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgRecordingStatusRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_RECORDINGSTATUSRELUPREG;}
};

class statfi_tclMsgRecordingStatusStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgRecordingStatusStatus():RecordedBreadCrumbTypes() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgRecordingStatusStatus& operator=(const statfi_tclMsgRecordingStatusStatus& coRef);
   statfi_tclMsgRecordingStatusStatus(const statfi_tclMsgRecordingStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b8_BreadCrumbTypes RecordedBreadCrumbTypes;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgRecordingStatusStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_RECORDINGSTATUSSTATUS;}
};

class statfi_tclMsgNbofFreeBreadCrumbsGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgNbofFreeBreadCrumbsGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgNbofFreeBreadCrumbsGet& operator=(const statfi_tclMsgNbofFreeBreadCrumbsGet& coRef);
   statfi_tclMsgNbofFreeBreadCrumbsGet(const statfi_tclMsgNbofFreeBreadCrumbsGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgNbofFreeBreadCrumbsGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_NBOFFREEBREADCRUMBSGET;}
};

class statfi_tclMsgNbofFreeBreadCrumbsUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgNbofFreeBreadCrumbsUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgNbofFreeBreadCrumbsUpReg& operator=(const statfi_tclMsgNbofFreeBreadCrumbsUpReg& coRef);
   statfi_tclMsgNbofFreeBreadCrumbsUpReg(const statfi_tclMsgNbofFreeBreadCrumbsUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgNbofFreeBreadCrumbsUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_NBOFFREEBREADCRUMBSUPREG;}
};

class statfi_tclMsgNbofFreeBreadCrumbsRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgNbofFreeBreadCrumbsRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgNbofFreeBreadCrumbsRelUpReg& operator=(const statfi_tclMsgNbofFreeBreadCrumbsRelUpReg& coRef);
   statfi_tclMsgNbofFreeBreadCrumbsRelUpReg(const statfi_tclMsgNbofFreeBreadCrumbsRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgNbofFreeBreadCrumbsRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_NBOFFREEBREADCRUMBSRELUPREG;}
};

class statfi_tclMsgNbofFreeBreadCrumbsStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgNbofFreeBreadCrumbsStatus():NbofFreeBreadCrumbs(0),RecordableDistance() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgNbofFreeBreadCrumbsStatus& operator=(const statfi_tclMsgNbofFreeBreadCrumbsStatus& coRef);
   statfi_tclMsgNbofFreeBreadCrumbsStatus(const statfi_tclMsgNbofFreeBreadCrumbsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 NbofFreeBreadCrumbs;
   fi_tcl_s32_Meter RecordableDistance;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgNbofFreeBreadCrumbsStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_NBOFFREEBREADCRUMBSSTATUS;}
};

class statfi_tclMsgNbofWrongCurrentPositionsUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgNbofWrongCurrentPositionsUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgNbofWrongCurrentPositionsUpReg& operator=(const statfi_tclMsgNbofWrongCurrentPositionsUpReg& coRef);
   statfi_tclMsgNbofWrongCurrentPositionsUpReg(const statfi_tclMsgNbofWrongCurrentPositionsUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgNbofWrongCurrentPositionsUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_NBOFWRONGCURRENTPOSITIONSUPREG;}
};

class statfi_tclMsgNbofWrongCurrentPositionsRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgNbofWrongCurrentPositionsRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgNbofWrongCurrentPositionsRelUpReg& operator=(const statfi_tclMsgNbofWrongCurrentPositionsRelUpReg& coRef);
   statfi_tclMsgNbofWrongCurrentPositionsRelUpReg(const statfi_tclMsgNbofWrongCurrentPositionsRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgNbofWrongCurrentPositionsRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_NBOFWRONGCURRENTPOSITIONSRELUPREG;}
};

class statfi_tclMsgNbofWrongCurrentPositionsStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgNbofWrongCurrentPositionsStatus():NbofPositionsToDelete(0),CorrectedPositions() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgNbofWrongCurrentPositionsStatus& operator=(const statfi_tclMsgNbofWrongCurrentPositionsStatus& coRef);
   statfi_tclMsgNbofWrongCurrentPositionsStatus(const statfi_tclMsgNbofWrongCurrentPositionsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 NbofPositionsToDelete;
   fi_tcl_OnroadOffroadPositions CorrectedPositions;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgNbofWrongCurrentPositionsStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_NBOFWRONGCURRENTPOSITIONSSTATUS;}
};

class statfi_tclMsgProfileDataAvailableUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgProfileDataAvailableUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgProfileDataAvailableUpReg& operator=(const statfi_tclMsgProfileDataAvailableUpReg& coRef);
   statfi_tclMsgProfileDataAvailableUpReg(const statfi_tclMsgProfileDataAvailableUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgProfileDataAvailableUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_PROFILEDATAAVAILABLEUPREG;}
};

class statfi_tclMsgProfileDataAvailableRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgProfileDataAvailableRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgProfileDataAvailableRelUpReg& operator=(const statfi_tclMsgProfileDataAvailableRelUpReg& coRef);
   statfi_tclMsgProfileDataAvailableRelUpReg(const statfi_tclMsgProfileDataAvailableRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgProfileDataAvailableRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_PROFILEDATAAVAILABLERELUPREG;}
};

class statfi_tclMsgProfileDataAvailableStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgProfileDataAvailableStatus():AvailableProfileData(),NavDataSetID() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgProfileDataAvailableStatus& operator=(const statfi_tclMsgProfileDataAvailableStatus& coRef);
   statfi_tclMsgProfileDataAvailableStatus(const statfi_tclMsgProfileDataAvailableStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b8_ProfileDataType AvailableProfileData;
   fi_tcl_u32_DataSetId NavDataSetID;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgProfileDataAvailableStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_PROFILEDATAAVAILABLESTATUS;}
};

class statfi_tclMsgEngineeringTextGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgEngineeringTextGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgEngineeringTextGet& operator=(const statfi_tclMsgEngineeringTextGet& coRef);
   statfi_tclMsgEngineeringTextGet(const statfi_tclMsgEngineeringTextGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgEngineeringTextGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_ENGINEERINGTEXTGET;}
};

class statfi_tclMsgEngineeringTextUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgEngineeringTextUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgEngineeringTextUpReg& operator=(const statfi_tclMsgEngineeringTextUpReg& coRef);
   statfi_tclMsgEngineeringTextUpReg(const statfi_tclMsgEngineeringTextUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgEngineeringTextUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG;}
};

class statfi_tclMsgEngineeringTextRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgEngineeringTextRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgEngineeringTextRelUpReg& operator=(const statfi_tclMsgEngineeringTextRelUpReg& coRef);
   statfi_tclMsgEngineeringTextRelUpReg(const statfi_tclMsgEngineeringTextRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgEngineeringTextRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG;}
};

class statfi_tclMsgEngineeringTextStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   statfi_tclMsgEngineeringTextStatus():Message() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   statfi_tclMsgEngineeringTextStatus& operator=(const statfi_tclMsgEngineeringTextStatus& coRef);
   statfi_tclMsgEngineeringTextStatus(const statfi_tclMsgEngineeringTextStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString Message;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const statfi_tclMsgEngineeringTextStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return statfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS;}
};


#endif
