#include "precompiled.hh"

tBool statfi_tclDescription::bInitMessage(statfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case statfi_tclToken::EN_LAST_TOKEN:
   case statfi_tclToken::EN_LIST:
   case statfi_tclToken::EN_END_OF_STRUCT:
   case statfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case statfi_tclToken::EN_MSG_GETRECORDEDDATAMETHODSTART:
   {
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_RECTANGLEWGS84,statfi_tclSemanticDomain::EN_MSG_NAVRECTANGLE));
   } break;
   case statfi_tclToken::EN_MSG_GETRECORDEDDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_ONROADOFFROADPOSITIONS,statfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_LIST,statfi_tclSemanticDomain::EN_MSG_ONROADOFFROADPOSITIONLIST));
   } break;
   case statfi_tclToken::EN_MSG_GETRECORDEDDATAMETHODRESULTFIRST:
   {
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_ONROADOFFROADPOSITIONS,statfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_LIST,statfi_tclSemanticDomain::EN_MSG_ONROADOFFROADPOSITIONLIST));
   } break;
   case statfi_tclToken::EN_MSG_GETRECORDEDDATAMETHODRESULTMIDDLE:
   {
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_ONROADOFFROADPOSITIONS,statfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_LIST,statfi_tclSemanticDomain::EN_MSG_ONROADOFFROADPOSITIONLIST));
   } break;
   case statfi_tclToken::EN_MSG_GETRECORDEDDATAMETHODRESULTLAST:
   {
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_ONROADOFFROADPOSITIONS,statfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_LIST,statfi_tclSemanticDomain::EN_MSG_ONROADOFFROADPOSITIONLIST));
   } break;
   case statfi_tclToken::EN_MSG_SETRECORDINGMODEANDSTARTRECORDINGMETHODSTART:
   {
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_B8_BREADCRUMBTYPES,statfi_tclSemanticDomain::EN_MSG_RECORDEDBREADCRUMBTYPES));
   } break;
   case statfi_tclToken::EN_MSG_SETRECORDINGMODEANDSTARTRECORDINGMETHODRESULT:
   {
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_B8_BREADCRUMBTYPES,statfi_tclSemanticDomain::EN_MSG_RECORDEDBREADCRUMBTYPES));
   } break;
   case statfi_tclToken::EN_MSG_GETDRIVENROUTEDATAMETHODSTART:
   {
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_RECTANGLEWGS84,statfi_tclSemanticDomain::EN_MSG_NAVRECTANGLE));
   } break;
   case statfi_tclToken::EN_MSG_GETDRIVENROUTEDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_ONROADOFFROADPOSITIONS,statfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_LIST,statfi_tclSemanticDomain::EN_MSG_ONROADOFFROADPOSITIONLIST));
   } break;
   case statfi_tclToken::EN_MSG_GETDRIVENROUTEDATAMETHODRESULTFIRST:
   {
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_ONROADOFFROADPOSITIONS,statfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_LIST,statfi_tclSemanticDomain::EN_MSG_ONROADOFFROADPOSITIONLIST));
   } break;
   case statfi_tclToken::EN_MSG_GETDRIVENROUTEDATAMETHODRESULTMIDDLE:
   {
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_ONROADOFFROADPOSITIONS,statfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_LIST,statfi_tclSemanticDomain::EN_MSG_ONROADOFFROADPOSITIONLIST));
   } break;
   case statfi_tclToken::EN_MSG_GETDRIVENROUTEDATAMETHODRESULTLAST:
   {
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_ONROADOFFROADPOSITIONS,statfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_LIST,statfi_tclSemanticDomain::EN_MSG_ONROADOFFROADPOSITIONLIST));
   } break;
   case statfi_tclToken::EN_MSG_GETPROFILEDATAMETHODSTART:
   {
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_COUNTRYTIMES,statfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_LIST,statfi_tclSemanticDomain::EN_MSG_COUNTRYTIMELIST));
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_U32_DATASETID,statfi_tclSemanticDomain::EN_MSG_NAVDATASETID));
   } break;
   case statfi_tclToken::EN_MSG_GETPROFILEDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_PROFILEDATALIST,statfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_LIST,statfi_tclSemanticDomain::EN_MSG_PROFILEDATALIST));
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_U32_DATASETID,statfi_tclSemanticDomain::EN_MSG_NAVDATASETID));
   } break;
   case statfi_tclToken::EN_MSG_CURRENTPOSITIONSTATUS:
   {
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_BOOL,statfi_tclSemanticDomain::EN_MSG_BCONNECTEDTOPREVIOUSPOINT));
      if (14 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_B8_STATPOSSTATUSINFO,statfi_tclSemanticDomain::EN_MSG_B8STATUSINFOBITS));
      }
      if (poOutContext->u16GetMajorVersion() <= 13)
      {
         bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_BOOL,statfi_tclSemanticDomain::EN_MSG_BPOSITIONISONROAD));
      }
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_POSITIONWGS84,statfi_tclSemanticDomain::EN_MSG_CURRENTPOSITION));
   } break;
   case statfi_tclToken::EN_MSG_RECORDINGSTATUSSTATUS:
   {
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_B8_BREADCRUMBTYPES,statfi_tclSemanticDomain::EN_MSG_RECORDEDBREADCRUMBTYPES));
   } break;
   case statfi_tclToken::EN_MSG_NBOFFREEBREADCRUMBSSTATUS:
   {
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_S32_METER,statfi_tclSemanticDomain::EN_MSG_RECORDABLEDISTANCE));
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_U32,statfi_tclSemanticDomain::EN_MSG_NBOFFREEBREADCRUMBS));
   } break;
   case statfi_tclToken::EN_MSG_NBOFWRONGCURRENTPOSITIONSSTATUS:
   {
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_ONROADOFFROADPOSITIONS,statfi_tclSemanticDomain::EN_MSG_CORRECTEDPOSITIONS));
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_U16,statfi_tclSemanticDomain::EN_MSG_NBOFPOSITIONSTODELETE));
   } break;
   case statfi_tclToken::EN_MSG_PROFILEDATAAVAILABLESTATUS:
   {
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_U32_DATASETID,statfi_tclSemanticDomain::EN_MSG_NAVDATASETID));
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_B8_PROFILEDATATYPE,statfi_tclSemanticDomain::EN_MSG_AVAILABLEPROFILEDATA));
   } break;
   case statfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
   {
      bResult &= oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_STRING,statfi_tclSemanticDomain::EN_MSG_MESSAGE));
   } break;
   case statfi_tclToken::EN_BINCONTAINER:
   case statfi_tclToken::EN_U8_PERCENT:
   case statfi_tclToken::EN_S32_METER:
   case statfi_tclToken::EN_POSIXTIME:
   case statfi_tclToken::EN_S16_CENTIMETERSECOND:
   case statfi_tclToken::EN_S32_LONGITUDE:
   case statfi_tclToken::EN_S32_LATITUDE:
   case statfi_tclToken::EN_POSITIONWGS84:
   case statfi_tclToken::EN_RECTANGLEWGS84:
   case statfi_tclToken::EN_E16_ISOCOUNTRYCODE:
   case statfi_tclToken::EN_U32_DATASETID:
   case statfi_tclToken::EN_E8_ROADCLASSCODE:
   case statfi_tclToken::EN_ONROADOFFROADPOSITIONS:
   case statfi_tclToken::EN_B8_BREADCRUMBTYPES:
   case statfi_tclToken::EN_B8_PROFILEDATATYPE:
   case statfi_tclToken::EN_B8_PROFILESTATUS:
   case statfi_tclToken::EN_COUNTRYTIMES:
   case statfi_tclToken::EN_B8_STATPOSSTATUSINFO:
   case statfi_tclToken::EN_PROFILEDATA:
   case statfi_tclToken::EN_PROFILEDATALIST:
   case statfi_tclToken::EN_U8:   
   case statfi_tclToken::EN_S8:   
   case statfi_tclToken::EN_U16:   
   case statfi_tclToken::EN_S16:   
   case statfi_tclToken::EN_U24:   
   case statfi_tclToken::EN_S24:   
   case statfi_tclToken::EN_U32:   
   case statfi_tclToken::EN_S32:   
   case statfi_tclToken::EN_U64:   
   case statfi_tclToken::EN_S64:   
   case statfi_tclToken::EN_F32:   
   case statfi_tclToken::EN_F64:   
   case statfi_tclToken::EN_BOOL:   
   case statfi_tclToken::EN_STRING:   
   case statfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(statfi_tclKnot(enMsgToken,statfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool statfi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool statfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      statfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      statfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      statfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == statfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(statfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(statfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(statfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case statfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == statfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case statfi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            statfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(statfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            statfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(statfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case statfi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case statfi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case statfi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case statfi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case statfi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case statfi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case statfi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case statfi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case statfi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case statfi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case statfi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case statfi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case statfi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case statfi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case statfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case statfi_tclToken::EN_MSG_GETRECORDEDDATAMETHODSTART:
   case statfi_tclToken::EN_MSG_GETRECORDEDDATAMETHODRESULT:
   case statfi_tclToken::EN_MSG_GETRECORDEDDATAMETHODRESULTFIRST:
   case statfi_tclToken::EN_MSG_GETRECORDEDDATAMETHODRESULTMIDDLE:
   case statfi_tclToken::EN_MSG_GETRECORDEDDATAMETHODRESULTLAST:
   case statfi_tclToken::EN_MSG_SETRECORDINGMODEANDSTARTRECORDINGMETHODSTART:
   case statfi_tclToken::EN_MSG_SETRECORDINGMODEANDSTARTRECORDINGMETHODRESULT:
   case statfi_tclToken::EN_MSG_DELETEALLBREADCRUMBSMETHODSTART:
   case statfi_tclToken::EN_MSG_DELETEALLBREADCRUMBSMETHODRESULT:
   case statfi_tclToken::EN_MSG_GETDRIVENROUTEDATAMETHODSTART:
   case statfi_tclToken::EN_MSG_GETDRIVENROUTEDATAMETHODRESULT:
   case statfi_tclToken::EN_MSG_GETDRIVENROUTEDATAMETHODRESULTFIRST:
   case statfi_tclToken::EN_MSG_GETDRIVENROUTEDATAMETHODRESULTMIDDLE:
   case statfi_tclToken::EN_MSG_GETDRIVENROUTEDATAMETHODRESULTLAST:
   case statfi_tclToken::EN_MSG_GETPROFILEDATAMETHODSTART:
   case statfi_tclToken::EN_MSG_GETPROFILEDATAMETHODRESULT:
   case statfi_tclToken::EN_MSG_CURRENTPOSITIONGET:
   case statfi_tclToken::EN_MSG_CURRENTPOSITIONUPREG:
   case statfi_tclToken::EN_MSG_CURRENTPOSITIONRELUPREG:
   case statfi_tclToken::EN_MSG_CURRENTPOSITIONSTATUS:
   case statfi_tclToken::EN_MSG_RECORDINGSTATUSGET:
   case statfi_tclToken::EN_MSG_RECORDINGSTATUSUPREG:
   case statfi_tclToken::EN_MSG_RECORDINGSTATUSRELUPREG:
   case statfi_tclToken::EN_MSG_RECORDINGSTATUSSTATUS:
   case statfi_tclToken::EN_MSG_NBOFFREEBREADCRUMBSGET:
   case statfi_tclToken::EN_MSG_NBOFFREEBREADCRUMBSUPREG:
   case statfi_tclToken::EN_MSG_NBOFFREEBREADCRUMBSRELUPREG:
   case statfi_tclToken::EN_MSG_NBOFFREEBREADCRUMBSSTATUS:
   case statfi_tclToken::EN_MSG_NBOFWRONGCURRENTPOSITIONSUPREG:
   case statfi_tclToken::EN_MSG_NBOFWRONGCURRENTPOSITIONSRELUPREG:
   case statfi_tclToken::EN_MSG_NBOFWRONGCURRENTPOSITIONSSTATUS:
   case statfi_tclToken::EN_MSG_PROFILEDATAAVAILABLEUPREG:
   case statfi_tclToken::EN_MSG_PROFILEDATAAVAILABLERELUPREG:
   case statfi_tclToken::EN_MSG_PROFILEDATAAVAILABLESTATUS:
   case statfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
   case statfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
   case statfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
   case statfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
      bInitMessage(enToken);
      break;
   case statfi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_END_OF_STRUCT,statfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_U8,statfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_LIST,statfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case statfi_tclToken::EN_U8_PERCENT:
   {
      fi_tcl_u8_Percent o_u8_Percent;
      if (!bDoIt(o_u8_Percent))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case statfi_tclToken::EN_S32_METER:
   {
      fi_tcl_s32_Meter o_s32_Meter;
      if (!bDoIt(o_s32_Meter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case statfi_tclToken::EN_POSIXTIME:
   {
      if (poVisitor->bDoExpand_POSIXTime(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_END_OF_STRUCT,statfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_S32,statfi_tclSemanticDomain::EN_TIME));
      }
      else
      {
         fi_tcl_POSIXTime o_POSIXTime;
         if (!bDoIt(o_POSIXTime))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POSIXTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POSIXTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case statfi_tclToken::EN_S16_CENTIMETERSECOND:
   {
      fi_tcl_s16_CentimeterSecond o_s16_CentimeterSecond;
      if (!bDoIt(o_s16_CentimeterSecond))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case statfi_tclToken::EN_S32_LONGITUDE:
   {
      fi_tcl_s32_Longitude o_s32_Longitude;
      if (!bDoIt(o_s32_Longitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case statfi_tclToken::EN_S32_LATITUDE:
   {
      fi_tcl_s32_Latitude o_s32_Latitude;
      if (!bDoIt(o_s32_Latitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case statfi_tclToken::EN_POSITIONWGS84:
   {
      if (poVisitor->bDoExpand_PositionWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_END_OF_STRUCT,statfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_S32_LATITUDE,statfi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_S32_LONGITUDE,statfi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_PositionWGS84 o_PositionWGS84;
         if (!bDoIt(o_PositionWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case statfi_tclToken::EN_RECTANGLEWGS84:
   {
      if (poVisitor->bDoExpand_RectangleWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_END_OF_STRUCT,statfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_S32_LATITUDE,statfi_tclSemanticDomain::EN_LATITUDEMAX));
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_S32_LONGITUDE,statfi_tclSemanticDomain::EN_LONGITUDEMAX));
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_S32_LATITUDE,statfi_tclSemanticDomain::EN_LATITUDEMIN));
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_S32_LONGITUDE,statfi_tclSemanticDomain::EN_LONGITUDEMIN));
      }
      else
      {
         fi_tcl_RectangleWGS84 o_RectangleWGS84;
         if (!bDoIt(o_RectangleWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RectangleWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RectangleWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case statfi_tclToken::EN_E16_ISOCOUNTRYCODE:
   {
      fi_tcl_e16_ISOCountryCode o_e16_ISOCountryCode;
      if (!bDoIt(o_e16_ISOCountryCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case statfi_tclToken::EN_U32_DATASETID:
   {
      fi_tcl_u32_DataSetId o_u32_DataSetId;
      if (!bDoIt(o_u32_DataSetId))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case statfi_tclToken::EN_E8_ROADCLASSCODE:
   {
      fi_tcl_e8_RoadClassCode o_e8_RoadClassCode;
      if (!bDoIt(o_e8_RoadClassCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case statfi_tclToken::EN_ONROADOFFROADPOSITIONS:
   {
      if (poVisitor->bDoExpand_OnroadOffroadPositions(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_END_OF_STRUCT,statfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_U16,statfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_LIST,statfi_tclSemanticDomain::EN_OFFROADONROADINDEXLIST));
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_POSITIONWGS84,statfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_LIST,statfi_tclSemanticDomain::EN_POSITIONLIST));
      }
      else
      {
         fi_tcl_OnroadOffroadPositions o_OnroadOffroadPositions;
         if (!bDoIt(o_OnroadOffroadPositions))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_OnroadOffroadPositions.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_OnroadOffroadPositions.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case statfi_tclToken::EN_B8_BREADCRUMBTYPES:
   {
      fi_tcl_b8_BreadCrumbTypes o_b8_BreadCrumbTypes;
      if (!bDoIt(o_b8_BreadCrumbTypes))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case statfi_tclToken::EN_B8_PROFILEDATATYPE:
   {
      fi_tcl_b8_ProfileDataType o_b8_ProfileDataType;
      if (!bDoIt(o_b8_ProfileDataType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case statfi_tclToken::EN_B8_PROFILESTATUS:
   {
      fi_tcl_b8_ProfileStatus o_b8_ProfileStatus;
      if (!bDoIt(o_b8_ProfileStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case statfi_tclToken::EN_COUNTRYTIMES:
   {
      if (poVisitor->bDoExpand_CountryTimes(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_END_OF_STRUCT,statfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_POSIXTIME,statfi_tclSemanticDomain::EN_POSIXEND));
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_POSIXTIME,statfi_tclSemanticDomain::EN_POSIXSTART));
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_E16_ISOCOUNTRYCODE,statfi_tclSemanticDomain::EN_COUNTRYCODE));
      }
      else
      {
         fi_tcl_CountryTimes o_CountryTimes;
         if (!bDoIt(o_CountryTimes))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryTimes.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryTimes.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case statfi_tclToken::EN_B8_STATPOSSTATUSINFO:
   {
      fi_tcl_b8_StatPosStatusInfo o_b8_StatPosStatusInfo;
      if (!bDoIt(o_b8_StatPosStatusInfo))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case statfi_tclToken::EN_PROFILEDATA:
   {
      if (poVisitor->bDoExpand_ProfileData(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_END_OF_STRUCT,statfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_U8_PERCENT,statfi_tclSemanticDomain::EN_RELIABILITY));
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_S16_CENTIMETERSECOND,statfi_tclSemanticDomain::EN_AVERAGESPEED));
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_B8_PROFILESTATUS,statfi_tclSemanticDomain::EN_PROFILESTATUS));
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_E8_ROADCLASSCODE,statfi_tclSemanticDomain::EN_ROADCLASS));
      }
      else
      {
         fi_tcl_ProfileData o_ProfileData;
         if (!bDoIt(o_ProfileData))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ProfileData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ProfileData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case statfi_tclToken::EN_PROFILEDATALIST:
   {
      if (poVisitor->bDoExpand_ProfileDataList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_END_OF_STRUCT,statfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_PROFILEDATA,statfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_LIST,statfi_tclSemanticDomain::EN_PROFILEDATA));
         oPath.bGoDown(statfi_tclKnot(statfi_tclToken::EN_COUNTRYTIMES,statfi_tclSemanticDomain::EN_COUNTRYTIMES));
      }
      else
      {
         fi_tcl_ProfileDataList o_ProfileDataList;
         if (!bDoIt(o_ProfileDataList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ProfileDataList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ProfileDataList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case statfi_tclToken::EN_UNKNOWN:
      case statfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

