#ifndef __STATFIDEBUGVISITOR_H__
#define __STATFIDEBUGVISITOR_H__

class MY_DECL statfi_tclPrintVisitor : public statfi_tclVisitorBase {

private:
   /* default constructor */ statfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   statfi_tclPrintVisitor(fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(statfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u8_Percent(fi_tcl_u8_Percent& o_u8_Percent);
   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& o_s32_Meter);
   virtual tBool bDoExpand_POSIXTime(statfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s16_CentimeterSecond(fi_tcl_s16_CentimeterSecond& o_s16_CentimeterSecond);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tBool bDoExpand_PositionWGS84(statfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RectangleWGS84(statfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_u32_DataSetId(fi_tcl_u32_DataSetId& o_u32_DataSetId);
   virtual tVoid vVisit_e8_RoadClassCode(fi_tcl_e8_RoadClassCode& o_e8_RoadClassCode);
   virtual tBool bDoExpand_OnroadOffroadPositions(statfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_BreadCrumbTypes(fi_tcl_b8_BreadCrumbTypes& o_b8_BreadCrumbTypes);
   virtual tVoid vVisit_b8_ProfileDataType(fi_tcl_b8_ProfileDataType& o_b8_ProfileDataType);
   virtual tVoid vVisit_b8_ProfileStatus(fi_tcl_b8_ProfileStatus& o_b8_ProfileStatus);
   virtual tBool bDoExpand_CountryTimes(statfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_StatPosStatusInfo(fi_tcl_b8_StatPosStatusInfo& o_b8_StatPosStatusInfo);
   virtual tBool bDoExpand_ProfileData(statfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ProfileDataList(statfi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   fi_tclOutput* poOutput;
};


class MY_DECL statfi_tclRandomInitVisitor : public statfi_tclVisitorBase {
public:

   statfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_u8_Percent(fi_tcl_u8_Percent& o_u8_Percent);
   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& o_s32_Meter);
   virtual tVoid vVisit_s16_CentimeterSecond(fi_tcl_s16_CentimeterSecond& o_s16_CentimeterSecond);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_u32_DataSetId(fi_tcl_u32_DataSetId& o_u32_DataSetId);
   virtual tVoid vVisit_e8_RoadClassCode(fi_tcl_e8_RoadClassCode& o_e8_RoadClassCode);
   virtual tVoid vVisit_b8_BreadCrumbTypes(fi_tcl_b8_BreadCrumbTypes& o_b8_BreadCrumbTypes);
   virtual tVoid vVisit_b8_ProfileDataType(fi_tcl_b8_ProfileDataType& o_b8_ProfileDataType);
   virtual tVoid vVisit_b8_ProfileStatus(fi_tcl_b8_ProfileStatus& o_b8_ProfileStatus);
   virtual tVoid vVisit_b8_StatPosStatusInfo(fi_tcl_b8_StatPosStatusInfo& o_b8_StatPosStatusInfo);
	tU32 u32ListSize;
};

#endif
