/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef RTFFITYPES_HEADER
#define RTFFITYPES_HEADER

// #include <vector>
// 


class rtffi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class rtffi_tclMsgConnectTaskMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rtffi_tclMsgConnectTaskMethodStart():ThreadID(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rtffi_tclMsgConnectTaskMethodStart& operator=(const rtffi_tclMsgConnectTaskMethodStart& coRef);
   rtffi_tclMsgConnectTaskMethodStart(const rtffi_tclMsgConnectTaskMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ThreadID;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rtffi_tclMsgConnectTaskMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rtffi_tclToken::EN_MSG_CONNECTTASKMETHODSTART;}
};

class rtffi_tclMsgConnectTaskMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rtffi_tclMsgConnectTaskMethodResult():StateManagerHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rtffi_tclMsgConnectTaskMethodResult& operator=(const rtffi_tclMsgConnectTaskMethodResult& coRef);
   rtffi_tclMsgConnectTaskMethodResult(const rtffi_tclMsgConnectTaskMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_StateManagerHandle StateManagerHandle;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rtffi_tclMsgConnectTaskMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rtffi_tclToken::EN_MSG_CONNECTTASKMETHODRESULT;}
};

class rtffi_tclMsgDisconnectTaskMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rtffi_tclMsgDisconnectTaskMethodStart():StateManagerHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rtffi_tclMsgDisconnectTaskMethodStart& operator=(const rtffi_tclMsgDisconnectTaskMethodStart& coRef);
   rtffi_tclMsgDisconnectTaskMethodStart(const rtffi_tclMsgDisconnectTaskMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_StateManagerHandle StateManagerHandle;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rtffi_tclMsgDisconnectTaskMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rtffi_tclToken::EN_MSG_DISCONNECTTASKMETHODSTART;}
};

class rtffi_tclMsgDisconnectTaskMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rtffi_tclMsgDisconnectTaskMethodResult():ThreadID(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rtffi_tclMsgDisconnectTaskMethodResult& operator=(const rtffi_tclMsgDisconnectTaskMethodResult& coRef);
   rtffi_tclMsgDisconnectTaskMethodResult(const rtffi_tclMsgDisconnectTaskMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ThreadID;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rtffi_tclMsgDisconnectTaskMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rtffi_tclToken::EN_MSG_DISCONNECTTASKMETHODRESULT;}
};

class rtffi_tclMsgConfirmStateReachedMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rtffi_tclMsgConfirmStateReachedMethodStart():StateManagerHandle(),NewAppState(),OldAppState() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rtffi_tclMsgConfirmStateReachedMethodStart& operator=(const rtffi_tclMsgConfirmStateReachedMethodStart& coRef);
   rtffi_tclMsgConfirmStateReachedMethodStart(const rtffi_tclMsgConfirmStateReachedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_StateManagerHandle StateManagerHandle;
   fi_tcl_e32_SystemState NewAppState;
   fi_tcl_e32_SystemState OldAppState;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rtffi_tclMsgConfirmStateReachedMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rtffi_tclToken::EN_MSG_CONFIRMSTATEREACHEDMETHODSTART;}
};

class rtffi_tclMsgConfirmStateReachedMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rtffi_tclMsgConfirmStateReachedMethodResult():NewAppState() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rtffi_tclMsgConfirmStateReachedMethodResult& operator=(const rtffi_tclMsgConfirmStateReachedMethodResult& coRef);
   rtffi_tclMsgConfirmStateReachedMethodResult(const rtffi_tclMsgConfirmStateReachedMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e32_SystemState NewAppState;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rtffi_tclMsgConfirmStateReachedMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rtffi_tclToken::EN_MSG_CONFIRMSTATEREACHEDMETHODRESULT;}
};

class rtffi_tclMsgRequestShutdownMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rtffi_tclMsgRequestShutdownMethodStart():StateManagerHandle(),ShutdownLevel() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rtffi_tclMsgRequestShutdownMethodStart& operator=(const rtffi_tclMsgRequestShutdownMethodStart& coRef);
   rtffi_tclMsgRequestShutdownMethodStart(const rtffi_tclMsgRequestShutdownMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_StateManagerHandle StateManagerHandle;
   fi_tcl_e32_ShutdownLevel ShutdownLevel;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rtffi_tclMsgRequestShutdownMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rtffi_tclToken::EN_MSG_REQUESTSHUTDOWNMETHODSTART;}
};

class rtffi_tclMsgRequestShutdownMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rtffi_tclMsgRequestShutdownMethodResult():StateManagerHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rtffi_tclMsgRequestShutdownMethodResult& operator=(const rtffi_tclMsgRequestShutdownMethodResult& coRef);
   rtffi_tclMsgRequestShutdownMethodResult(const rtffi_tclMsgRequestShutdownMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_StateManagerHandle StateManagerHandle;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rtffi_tclMsgRequestShutdownMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rtffi_tclToken::EN_MSG_REQUESTSHUTDOWNMETHODRESULT;}
};

class rtffi_tclMsgInternalMessageMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rtffi_tclMsgInternalMessageMethodStart():DataType(0),DataPointer(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rtffi_tclMsgInternalMessageMethodStart& operator=(const rtffi_tclMsgInternalMessageMethodStart& coRef);
   rtffi_tclMsgInternalMessageMethodStart(const rtffi_tclMsgInternalMessageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 DataType;
   tU64 DataPointer;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rtffi_tclMsgInternalMessageMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rtffi_tclToken::EN_MSG_INTERNALMESSAGEMETHODSTART;}
};

class rtffi_tclMsgInternalMessageMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rtffi_tclMsgInternalMessageMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rtffi_tclMsgInternalMessageMethodResult& operator=(const rtffi_tclMsgInternalMessageMethodResult& coRef);
   rtffi_tclMsgInternalMessageMethodResult(const rtffi_tclMsgInternalMessageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rtffi_tclMsgInternalMessageMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rtffi_tclToken::EN_MSG_INTERNALMESSAGEMETHODRESULT;}
};

class rtffi_tclMsgTransitionRequestGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rtffi_tclMsgTransitionRequestGet():StateManagerHandle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rtffi_tclMsgTransitionRequestGet& operator=(const rtffi_tclMsgTransitionRequestGet& coRef);
   rtffi_tclMsgTransitionRequestGet(const rtffi_tclMsgTransitionRequestGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_StateManagerHandle StateManagerHandle;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rtffi_tclMsgTransitionRequestGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rtffi_tclToken::EN_MSG_TRANSITIONREQUESTGET;}
};

class rtffi_tclMsgTransitionRequestStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rtffi_tclMsgTransitionRequestStatus():ApplicationState() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rtffi_tclMsgTransitionRequestStatus& operator=(const rtffi_tclMsgTransitionRequestStatus& coRef);
   rtffi_tclMsgTransitionRequestStatus(const rtffi_tclMsgTransitionRequestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_NavAppState ApplicationState;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rtffi_tclMsgTransitionRequestStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rtffi_tclToken::EN_MSG_TRANSITIONREQUESTSTATUS;}
};


#endif
