#ifndef RTFFILANGUAGE_HEADER
#define RTFFILANGUAGE_HEADER

class rtffi_tclInContext;
class rtffi_tclOutContext;
class rtffi_tclVisitorBase;

class MY_DECL rtffi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  rtffi_tclDescription(fi_tclInContext* poIn, rtffi_tclVisitorBase* poVisit);
  rtffi_tclDescription(fi_tclOutContext* poOut, rtffi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(rtffi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ rtffi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  rtffi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<rtffi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<rtffi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline rtffi_tclDescription::rtffi_tclDescription(fi_tclInContext* poIn, rtffi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline rtffi_tclDescription::rtffi_tclDescription(fi_tclOutContext* poOut, rtffi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

