/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgStartGuidanceMethodStart::rgfi_tclMsgStartGuidanceMethodStart(const rgfi_tclMsgStartGuidanceMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   UserProfiles = coRef.UserProfiles;
   DestinationInfoTexts = coRef.DestinationInfoTexts;
   DestinationInfoLanguageID = coRef.DestinationInfoLanguageID;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgStartGuidanceMethodStart& rgfi_tclMsgStartGuidanceMethodStart::operator=(const rgfi_tclMsgStartGuidanceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   UserProfiles = coRef.UserProfiles;
   DestinationInfoTexts = coRef.DestinationInfoTexts;
   DestinationInfoLanguageID = coRef.DestinationInfoLanguageID;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgStartGuidanceMethodStart::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgStartGuidanceMethodStart::u16GetFunctionID() const {return RGFI_C_U16_STARTGUIDANCE;}
tU8 rgfi_tclMsgStartGuidanceMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rgfi_tclMsgStartGuidanceMethodStart::vDestroy()
{
   UserProfiles.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < DestinationInfoTexts.size(); ++u32Idx)
         DestinationInfoTexts[u32Idx].vDestroy();
   }
   DestinationInfoTexts.clear();
   DestinationInfoLanguageID.vDestroy(); 
}

tU32 rgfi_tclMsgStartGuidanceMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (7 <= u16MajorVersion)
   {
      u32DynamicSize += UserProfiles.u32GetSize(u16MajorVersion);
   }
   tU32 u32ListIdx;
   if ((29 <= u16MajorVersion) && (u16MajorVersion <= 32))
   {
      u32DynamicSize += 4;
      for (u32ListIdx = 0; u32ListIdx < DestinationInfoTexts.size(); ++u32ListIdx)
         u32DynamicSize += DestinationInfoTexts[u32ListIdx].u32GetSize(u16MajorVersion);
   }
   if ((29 <= u16MajorVersion) && (u16MajorVersion <= 32))
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+4;
}

tBool rgfi_tclMsgStartGuidanceMethodStart::operator==(const rgfi_tclMsgStartGuidanceMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (UserProfiles == rfoCmp.UserProfiles);
      bResult = bResult && (DestinationInfoTexts.size() == rfoCmp.DestinationInfoTexts.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DestinationInfoTexts.size()); ++u32Idx)
            bResult = bResult && (DestinationInfoTexts[u32Idx] == rfoCmp.DestinationInfoTexts[u32Idx]);
      }
      bResult = bResult && (DestinationInfoLanguageID == rfoCmp.DestinationInfoLanguageID);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgStartGuidanceMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   if (7 <= oIn.u16GetMajorVersion())
   {
      oIn >> UserProfiles;
   }
   if ((29 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 32))
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < DestinationInfoTexts.size(); ++u32Idx)
         {
            DestinationInfoTexts[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         DestinationInfoTexts.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> DestinationInfoTexts[u32Idx];
         }
      }
   }
   if ((29 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 32))
   {
      oIn >> DestinationInfoLanguageID;
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgStartGuidanceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   if (7 <= oOut.u16GetMajorVersion())
   {
      oOut << UserProfiles;
   }
   if ((29 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 32))
   {
      oOut << (tU32)DestinationInfoTexts.size();
      {
         for (tU32 u32Idx = 0; u32Idx < DestinationInfoTexts.size(); ++u32Idx)
            oOut << DestinationInfoTexts[u32Idx];
      }
   }
   if ((29 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 32))
   {
      oOut << DestinationInfoLanguageID;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgStartGuidanceMethodResult::rgfi_tclMsgStartGuidanceMethodResult(const rgfi_tclMsgStartGuidanceMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgStartGuidanceMethodResult& rgfi_tclMsgStartGuidanceMethodResult::operator=(const rgfi_tclMsgStartGuidanceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgStartGuidanceMethodResult::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgStartGuidanceMethodResult::u16GetFunctionID() const {return RGFI_C_U16_STARTGUIDANCE;}
tU8 rgfi_tclMsgStartGuidanceMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rgfi_tclMsgStartGuidanceMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool rgfi_tclMsgStartGuidanceMethodResult::operator==(const rgfi_tclMsgStartGuidanceMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgStartGuidanceMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgStartGuidanceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgStopGuidanceMethodStart::rgfi_tclMsgStopGuidanceMethodStart(const rgfi_tclMsgStopGuidanceMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgStopGuidanceMethodStart& rgfi_tclMsgStopGuidanceMethodStart::operator=(const rgfi_tclMsgStopGuidanceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgStopGuidanceMethodStart::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgStopGuidanceMethodStart::u16GetFunctionID() const {return RGFI_C_U16_STOPGUIDANCE;}
tU8 rgfi_tclMsgStopGuidanceMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rgfi_tclMsgStopGuidanceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgStopGuidanceMethodStart::operator==(const rgfi_tclMsgStopGuidanceMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgStopGuidanceMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgStopGuidanceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgStopGuidanceMethodResult::rgfi_tclMsgStopGuidanceMethodResult(const rgfi_tclMsgStopGuidanceMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgStopGuidanceMethodResult& rgfi_tclMsgStopGuidanceMethodResult::operator=(const rgfi_tclMsgStopGuidanceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgStopGuidanceMethodResult::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgStopGuidanceMethodResult::u16GetFunctionID() const {return RGFI_C_U16_STOPGUIDANCE;}
tU8 rgfi_tclMsgStopGuidanceMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rgfi_tclMsgStopGuidanceMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgStopGuidanceMethodResult::operator==(const rgfi_tclMsgStopGuidanceMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgStopGuidanceMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgStopGuidanceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgChangeGuidanceModeMethodStart::rgfi_tclMsgChangeGuidanceModeMethodStart(const rgfi_tclMsgChangeGuidanceModeMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   GuidanceMode = coRef.GuidanceMode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgChangeGuidanceModeMethodStart& rgfi_tclMsgChangeGuidanceModeMethodStart::operator=(const rgfi_tclMsgChangeGuidanceModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   GuidanceMode = coRef.GuidanceMode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgChangeGuidanceModeMethodStart::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgChangeGuidanceModeMethodStart::u16GetFunctionID() const {return RGFI_C_U16_CHANGEGUIDANCEMODE;}
tU8 rgfi_tclMsgChangeGuidanceModeMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rgfi_tclMsgChangeGuidanceModeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool rgfi_tclMsgChangeGuidanceModeMethodStart::operator==(const rgfi_tclMsgChangeGuidanceModeMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (GuidanceMode == rfoCmp.GuidanceMode);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgChangeGuidanceModeMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> GuidanceMode;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgChangeGuidanceModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << GuidanceMode;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgChangeGuidanceModeMethodResult::rgfi_tclMsgChangeGuidanceModeMethodResult(const rgfi_tclMsgChangeGuidanceModeMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   GuidanceMode = coRef.GuidanceMode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgChangeGuidanceModeMethodResult& rgfi_tclMsgChangeGuidanceModeMethodResult::operator=(const rgfi_tclMsgChangeGuidanceModeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   GuidanceMode = coRef.GuidanceMode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgChangeGuidanceModeMethodResult::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgChangeGuidanceModeMethodResult::u16GetFunctionID() const {return RGFI_C_U16_CHANGEGUIDANCEMODE;}
tU8 rgfi_tclMsgChangeGuidanceModeMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rgfi_tclMsgChangeGuidanceModeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool rgfi_tclMsgChangeGuidanceModeMethodResult::operator==(const rgfi_tclMsgChangeGuidanceModeMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (GuidanceMode == rfoCmp.GuidanceMode);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgChangeGuidanceModeMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> GuidanceMode;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgChangeGuidanceModeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << GuidanceMode;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSetUserProfilesMethodStart::rgfi_tclMsgSetUserProfilesMethodStart(const rgfi_tclMsgSetUserProfilesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   UserProfiles = coRef.UserProfiles;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSetUserProfilesMethodStart& rgfi_tclMsgSetUserProfilesMethodStart::operator=(const rgfi_tclMsgSetUserProfilesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   UserProfiles = coRef.UserProfiles;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSetUserProfilesMethodStart::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSetUserProfilesMethodStart::u16GetFunctionID() const {return RGFI_C_U16_SETUSERPROFILES;}
tU8 rgfi_tclMsgSetUserProfilesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rgfi_tclMsgSetUserProfilesMethodStart::vDestroy()
{
   UserProfiles.vDestroy(); 
}

tU32 rgfi_tclMsgSetUserProfilesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+UserProfiles.u32GetSize(u16MajorVersion);
}

tBool rgfi_tclMsgSetUserProfilesMethodStart::operator==(const rgfi_tclMsgSetUserProfilesMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UserProfiles == rfoCmp.UserProfiles);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSetUserProfilesMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> UserProfiles;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSetUserProfilesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UserProfiles;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSetUserProfilesMethodResult::rgfi_tclMsgSetUserProfilesMethodResult(const rgfi_tclMsgSetUserProfilesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSetUserProfilesMethodResult& rgfi_tclMsgSetUserProfilesMethodResult::operator=(const rgfi_tclMsgSetUserProfilesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSetUserProfilesMethodResult::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSetUserProfilesMethodResult::u16GetFunctionID() const {return RGFI_C_U16_SETUSERPROFILES;}
tU8 rgfi_tclMsgSetUserProfilesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rgfi_tclMsgSetUserProfilesMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgSetUserProfilesMethodResult::operator==(const rgfi_tclMsgSetUserProfilesMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSetUserProfilesMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSetUserProfilesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgRetriggerAcousticOutputMethodStart::rgfi_tclMsgRetriggerAcousticOutputMethodStart(const rgfi_tclMsgRetriggerAcousticOutputMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   MessageClasses = coRef.MessageClasses;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgRetriggerAcousticOutputMethodStart& rgfi_tclMsgRetriggerAcousticOutputMethodStart::operator=(const rgfi_tclMsgRetriggerAcousticOutputMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MessageClasses = coRef.MessageClasses;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgRetriggerAcousticOutputMethodStart::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgRetriggerAcousticOutputMethodStart::u16GetFunctionID() const {return RGFI_C_U16_RETRIGGERACOUSTICOUTPUT;}
tU8 rgfi_tclMsgRetriggerAcousticOutputMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rgfi_tclMsgRetriggerAcousticOutputMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool rgfi_tclMsgRetriggerAcousticOutputMethodStart::operator==(const rgfi_tclMsgRetriggerAcousticOutputMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MessageClasses == rfoCmp.MessageClasses);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgRetriggerAcousticOutputMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> MessageClasses;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgRetriggerAcousticOutputMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MessageClasses;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgRetriggerAcousticOutputMethodResult::rgfi_tclMsgRetriggerAcousticOutputMethodResult(const rgfi_tclMsgRetriggerAcousticOutputMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgRetriggerAcousticOutputMethodResult& rgfi_tclMsgRetriggerAcousticOutputMethodResult::operator=(const rgfi_tclMsgRetriggerAcousticOutputMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgRetriggerAcousticOutputMethodResult::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgRetriggerAcousticOutputMethodResult::u16GetFunctionID() const {return RGFI_C_U16_RETRIGGERACOUSTICOUTPUT;}
tU8 rgfi_tclMsgRetriggerAcousticOutputMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rgfi_tclMsgRetriggerAcousticOutputMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgRetriggerAcousticOutputMethodResult::operator==(const rgfi_tclMsgRetriggerAcousticOutputMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgRetriggerAcousticOutputMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgRetriggerAcousticOutputMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgChangeWarningsOnHorizonModeMethodStart::rgfi_tclMsgChangeWarningsOnHorizonModeMethodStart(const rgfi_tclMsgChangeWarningsOnHorizonModeMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   WarningsOnHorizonMode = coRef.WarningsOnHorizonMode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgChangeWarningsOnHorizonModeMethodStart& rgfi_tclMsgChangeWarningsOnHorizonModeMethodStart::operator=(const rgfi_tclMsgChangeWarningsOnHorizonModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   WarningsOnHorizonMode = coRef.WarningsOnHorizonMode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgChangeWarningsOnHorizonModeMethodStart::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgChangeWarningsOnHorizonModeMethodStart::u16GetFunctionID() const {return RGFI_C_U16_CHANGEWARNINGSONHORIZONMODE;}
tU8 rgfi_tclMsgChangeWarningsOnHorizonModeMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rgfi_tclMsgChangeWarningsOnHorizonModeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool rgfi_tclMsgChangeWarningsOnHorizonModeMethodStart::operator==(const rgfi_tclMsgChangeWarningsOnHorizonModeMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (WarningsOnHorizonMode == rfoCmp.WarningsOnHorizonMode);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgChangeWarningsOnHorizonModeMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> WarningsOnHorizonMode;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgChangeWarningsOnHorizonModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << WarningsOnHorizonMode;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgChangeWarningsOnHorizonModeMethodResult::rgfi_tclMsgChangeWarningsOnHorizonModeMethodResult(const rgfi_tclMsgChangeWarningsOnHorizonModeMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   WarningsOnHorizonMode = coRef.WarningsOnHorizonMode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgChangeWarningsOnHorizonModeMethodResult& rgfi_tclMsgChangeWarningsOnHorizonModeMethodResult::operator=(const rgfi_tclMsgChangeWarningsOnHorizonModeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   WarningsOnHorizonMode = coRef.WarningsOnHorizonMode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgChangeWarningsOnHorizonModeMethodResult::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgChangeWarningsOnHorizonModeMethodResult::u16GetFunctionID() const {return RGFI_C_U16_CHANGEWARNINGSONHORIZONMODE;}
tU8 rgfi_tclMsgChangeWarningsOnHorizonModeMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rgfi_tclMsgChangeWarningsOnHorizonModeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool rgfi_tclMsgChangeWarningsOnHorizonModeMethodResult::operator==(const rgfi_tclMsgChangeWarningsOnHorizonModeMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (WarningsOnHorizonMode == rfoCmp.WarningsOnHorizonMode);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgChangeWarningsOnHorizonModeMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> WarningsOnHorizonMode;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgChangeWarningsOnHorizonModeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << WarningsOnHorizonMode;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgGetSupportedFunctionalityStatesMethodStart::rgfi_tclMsgGetSupportedFunctionalityStatesMethodStart(const rgfi_tclMsgGetSupportedFunctionalityStatesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgGetSupportedFunctionalityStatesMethodStart& rgfi_tclMsgGetSupportedFunctionalityStatesMethodStart::operator=(const rgfi_tclMsgGetSupportedFunctionalityStatesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgGetSupportedFunctionalityStatesMethodStart::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgGetSupportedFunctionalityStatesMethodStart::u16GetFunctionID() const {return RGFI_C_U16_GETSUPPORTEDFUNCTIONALITYSTATES;}
tU8 rgfi_tclMsgGetSupportedFunctionalityStatesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rgfi_tclMsgGetSupportedFunctionalityStatesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgGetSupportedFunctionalityStatesMethodStart::operator==(const rgfi_tclMsgGetSupportedFunctionalityStatesMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgGetSupportedFunctionalityStatesMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgGetSupportedFunctionalityStatesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgGetSupportedFunctionalityStatesMethodResult::rgfi_tclMsgGetSupportedFunctionalityStatesMethodResult(const rgfi_tclMsgGetSupportedFunctionalityStatesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   RouteInfoAcoustic = coRef.RouteInfoAcoustic;
   RouteInfoSymbolic = coRef.RouteInfoSymbolic;
   DestinationInfoAcoustic = coRef.DestinationInfoAcoustic;
   DestinationInfoSymbolic = coRef.DestinationInfoSymbolic;
   DrivingRecommendationAcoustic = coRef.DrivingRecommendationAcoustic;
   DrivingRecommendationSymbolic = coRef.DrivingRecommendationSymbolic;
   CorridorInfoAcoustic = coRef.CorridorInfoAcoustic;
   CorridorInfoSymbolic = coRef.CorridorInfoSymbolic;
   HorizonInfoTrafficMessageAcoustic = coRef.HorizonInfoTrafficMessageAcoustic;
   HorizonInfoTrafficMessageSymbolic = coRef.HorizonInfoTrafficMessageSymbolic;
   HorizonInfoSpeedLimitAcoustic = coRef.HorizonInfoSpeedLimitAcoustic;
   HorizonInfoSpeedLimitSymbolic = coRef.HorizonInfoSpeedLimitSymbolic;
   HorizonInfoWarningSignAcoustic = coRef.HorizonInfoWarningSignAcoustic;
   HorizonInfoWarningSignSymbolic = coRef.HorizonInfoWarningSignSymbolic;
   HorizonInfoPOIAcoustic = coRef.HorizonInfoPOIAcoustic;
   HorizonInfoPOISymbolic = coRef.HorizonInfoPOISymbolic;
   HorizonInfoRoadAttributeAcoustic = coRef.HorizonInfoRoadAttributeAcoustic;
   HorizonInfoRoadAttributeSymbolic = coRef.HorizonInfoRoadAttributeSymbolic;
   HorizonInfoCurveAcoustic = coRef.HorizonInfoCurveAcoustic;
   HorizonInfoCurveSymbolic = coRef.HorizonInfoCurveSymbolic;
   HorizonInfoUPOI = coRef.HorizonInfoUPOI;
   DriverSpeedAdvice = coRef.DriverSpeedAdvice;
   HorizonEvents = coRef.HorizonEvents;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgGetSupportedFunctionalityStatesMethodResult& rgfi_tclMsgGetSupportedFunctionalityStatesMethodResult::operator=(const rgfi_tclMsgGetSupportedFunctionalityStatesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   RouteInfoAcoustic = coRef.RouteInfoAcoustic;
   RouteInfoSymbolic = coRef.RouteInfoSymbolic;
   DestinationInfoAcoustic = coRef.DestinationInfoAcoustic;
   DestinationInfoSymbolic = coRef.DestinationInfoSymbolic;
   DrivingRecommendationAcoustic = coRef.DrivingRecommendationAcoustic;
   DrivingRecommendationSymbolic = coRef.DrivingRecommendationSymbolic;
   CorridorInfoAcoustic = coRef.CorridorInfoAcoustic;
   CorridorInfoSymbolic = coRef.CorridorInfoSymbolic;
   HorizonInfoTrafficMessageAcoustic = coRef.HorizonInfoTrafficMessageAcoustic;
   HorizonInfoTrafficMessageSymbolic = coRef.HorizonInfoTrafficMessageSymbolic;
   HorizonInfoSpeedLimitAcoustic = coRef.HorizonInfoSpeedLimitAcoustic;
   HorizonInfoSpeedLimitSymbolic = coRef.HorizonInfoSpeedLimitSymbolic;
   HorizonInfoWarningSignAcoustic = coRef.HorizonInfoWarningSignAcoustic;
   HorizonInfoWarningSignSymbolic = coRef.HorizonInfoWarningSignSymbolic;
   HorizonInfoPOIAcoustic = coRef.HorizonInfoPOIAcoustic;
   HorizonInfoPOISymbolic = coRef.HorizonInfoPOISymbolic;
   HorizonInfoRoadAttributeAcoustic = coRef.HorizonInfoRoadAttributeAcoustic;
   HorizonInfoRoadAttributeSymbolic = coRef.HorizonInfoRoadAttributeSymbolic;
   HorizonInfoCurveAcoustic = coRef.HorizonInfoCurveAcoustic;
   HorizonInfoCurveSymbolic = coRef.HorizonInfoCurveSymbolic;
   HorizonInfoUPOI = coRef.HorizonInfoUPOI;
   DriverSpeedAdvice = coRef.DriverSpeedAdvice;
   HorizonEvents = coRef.HorizonEvents;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgGetSupportedFunctionalityStatesMethodResult::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgGetSupportedFunctionalityStatesMethodResult::u16GetFunctionID() const {return RGFI_C_U16_GETSUPPORTEDFUNCTIONALITYSTATES;}
tU8 rgfi_tclMsgGetSupportedFunctionalityStatesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rgfi_tclMsgGetSupportedFunctionalityStatesMethodResult::vDestroy()
{
   HorizonInfoUPOI.vDestroy(); 
   DriverSpeedAdvice.vDestroy(); 
   HorizonEvents.vDestroy(); 
}

tU32 rgfi_tclMsgGetSupportedFunctionalityStatesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 16)
   {
      u32DynamicSize += 2;
   }
   if (u16MajorVersion <= 16)
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((13 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((13 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if (u16MajorVersion <= 1)
   {
      u32DynamicSize += HorizonInfoUPOI.u32GetSize(u16MajorVersion);
   }
   if (17 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (17 <= u16MajorVersion)
   {
      u32DynamicSize += HorizonEvents.u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+12;
}

tBool rgfi_tclMsgGetSupportedFunctionalityStatesMethodResult::operator==(const rgfi_tclMsgGetSupportedFunctionalityStatesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RouteInfoAcoustic == rfoCmp.RouteInfoAcoustic);
      bResult = bResult && (RouteInfoSymbolic == rfoCmp.RouteInfoSymbolic);
      bResult = bResult && (DestinationInfoAcoustic == rfoCmp.DestinationInfoAcoustic);
      bResult = bResult && (DestinationInfoSymbolic == rfoCmp.DestinationInfoSymbolic);
      bResult = bResult && (DrivingRecommendationAcoustic == rfoCmp.DrivingRecommendationAcoustic);
      bResult = bResult && (DrivingRecommendationSymbolic == rfoCmp.DrivingRecommendationSymbolic);
      bResult = bResult && (CorridorInfoAcoustic == rfoCmp.CorridorInfoAcoustic);
      bResult = bResult && (CorridorInfoSymbolic == rfoCmp.CorridorInfoSymbolic);
      bResult = bResult && (HorizonInfoTrafficMessageAcoustic == rfoCmp.HorizonInfoTrafficMessageAcoustic);
      bResult = bResult && (HorizonInfoTrafficMessageSymbolic == rfoCmp.HorizonInfoTrafficMessageSymbolic);
      bResult = bResult && (HorizonInfoSpeedLimitAcoustic == rfoCmp.HorizonInfoSpeedLimitAcoustic);
      bResult = bResult && (HorizonInfoSpeedLimitSymbolic == rfoCmp.HorizonInfoSpeedLimitSymbolic);
      bResult = bResult && (HorizonInfoWarningSignAcoustic == rfoCmp.HorizonInfoWarningSignAcoustic);
      bResult = bResult && (HorizonInfoWarningSignSymbolic == rfoCmp.HorizonInfoWarningSignSymbolic);
      bResult = bResult && (HorizonInfoPOIAcoustic == rfoCmp.HorizonInfoPOIAcoustic);
      bResult = bResult && (HorizonInfoPOISymbolic == rfoCmp.HorizonInfoPOISymbolic);
      bResult = bResult && (HorizonInfoRoadAttributeAcoustic == rfoCmp.HorizonInfoRoadAttributeAcoustic);
      bResult = bResult && (HorizonInfoRoadAttributeSymbolic == rfoCmp.HorizonInfoRoadAttributeSymbolic);
      bResult = bResult && (HorizonInfoCurveAcoustic == rfoCmp.HorizonInfoCurveAcoustic);
      bResult = bResult && (HorizonInfoCurveSymbolic == rfoCmp.HorizonInfoCurveSymbolic);
      bResult = bResult && (HorizonInfoUPOI == rfoCmp.HorizonInfoUPOI);
      bResult = bResult && (DriverSpeedAdvice == rfoCmp.DriverSpeedAdvice);
      bResult = bResult && (HorizonEvents == rfoCmp.HorizonEvents);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgGetSupportedFunctionalityStatesMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> RouteInfoAcoustic;
   oIn >> RouteInfoSymbolic;
   oIn >> DestinationInfoAcoustic;
   oIn >> DestinationInfoSymbolic;
   oIn >> DrivingRecommendationAcoustic;
   oIn >> DrivingRecommendationSymbolic;
   if (oIn.u16GetMajorVersion() <= 16)
   {
      oIn >> CorridorInfoAcoustic;
   }
   if (oIn.u16GetMajorVersion() <= 16)
   {
      oIn >> CorridorInfoSymbolic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoTrafficMessageAcoustic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoTrafficMessageSymbolic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoSpeedLimitAcoustic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoSpeedLimitSymbolic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoWarningSignAcoustic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoWarningSignSymbolic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoPOIAcoustic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoPOISymbolic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoRoadAttributeAcoustic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoRoadAttributeSymbolic;
   }
   if ((13 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoCurveAcoustic;
   }
   if ((13 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoCurveSymbolic;
   }
   if (oIn.u16GetMajorVersion() <= 1)
   {
      oIn >> HorizonInfoUPOI;
   }
   if (17 <= oIn.u16GetMajorVersion())
   {
      oIn >> DriverSpeedAdvice;
   }
   if (17 <= oIn.u16GetMajorVersion())
   {
      oIn >> HorizonEvents;
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgGetSupportedFunctionalityStatesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RouteInfoAcoustic;
   oOut << RouteInfoSymbolic;
   oOut << DestinationInfoAcoustic;
   oOut << DestinationInfoSymbolic;
   oOut << DrivingRecommendationAcoustic;
   oOut << DrivingRecommendationSymbolic;
   if (oOut.u16GetMajorVersion() <= 16)
   {
      oOut << CorridorInfoAcoustic;
   }
   if (oOut.u16GetMajorVersion() <= 16)
   {
      oOut << CorridorInfoSymbolic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoTrafficMessageAcoustic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoTrafficMessageSymbolic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoSpeedLimitAcoustic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoSpeedLimitSymbolic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoWarningSignAcoustic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoWarningSignSymbolic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoPOIAcoustic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoPOISymbolic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoRoadAttributeAcoustic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoRoadAttributeSymbolic;
   }
   if ((13 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoCurveAcoustic;
   }
   if ((13 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoCurveSymbolic;
   }
   if (oOut.u16GetMajorVersion() <= 1)
   {
      oOut << HorizonInfoUPOI;
   }
   if (17 <= oOut.u16GetMajorVersion())
   {
      oOut << DriverSpeedAdvice;
   }
   if (17 <= oOut.u16GetMajorVersion())
   {
      oOut << HorizonEvents;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgGetAvailableSpeechLanguagesMethodStart::rgfi_tclMsgGetAvailableSpeechLanguagesMethodStart(const rgfi_tclMsgGetAvailableSpeechLanguagesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgGetAvailableSpeechLanguagesMethodStart& rgfi_tclMsgGetAvailableSpeechLanguagesMethodStart::operator=(const rgfi_tclMsgGetAvailableSpeechLanguagesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgGetAvailableSpeechLanguagesMethodStart::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgGetAvailableSpeechLanguagesMethodStart::u16GetFunctionID() const {return RGFI_C_U16_GETAVAILABLESPEECHLANGUAGES;}
tU8 rgfi_tclMsgGetAvailableSpeechLanguagesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rgfi_tclMsgGetAvailableSpeechLanguagesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgGetAvailableSpeechLanguagesMethodStart::operator==(const rgfi_tclMsgGetAvailableSpeechLanguagesMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgGetAvailableSpeechLanguagesMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgGetAvailableSpeechLanguagesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgGetAvailableSpeechLanguagesMethodResult::rgfi_tclMsgGetAvailableSpeechLanguagesMethodResult(const rgfi_tclMsgGetAvailableSpeechLanguagesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   AvailableLanguages = coRef.AvailableLanguages;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgGetAvailableSpeechLanguagesMethodResult& rgfi_tclMsgGetAvailableSpeechLanguagesMethodResult::operator=(const rgfi_tclMsgGetAvailableSpeechLanguagesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   AvailableLanguages = coRef.AvailableLanguages;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgGetAvailableSpeechLanguagesMethodResult::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgGetAvailableSpeechLanguagesMethodResult::u16GetFunctionID() const {return RGFI_C_U16_GETAVAILABLESPEECHLANGUAGES;}
tU8 rgfi_tclMsgGetAvailableSpeechLanguagesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rgfi_tclMsgGetAvailableSpeechLanguagesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AvailableLanguages.size(); ++u32Idx)
         AvailableLanguages[u32Idx].vDestroy();
   }
   AvailableLanguages.clear();
}

tU32 rgfi_tclMsgGetAvailableSpeechLanguagesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < AvailableLanguages.size(); ++u32ListIdx)
      u32DynamicSize += AvailableLanguages[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool rgfi_tclMsgGetAvailableSpeechLanguagesMethodResult::operator==(const rgfi_tclMsgGetAvailableSpeechLanguagesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AvailableLanguages.size() == rfoCmp.AvailableLanguages.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AvailableLanguages.size()); ++u32Idx)
            bResult = bResult && (AvailableLanguages[u32Idx] == rfoCmp.AvailableLanguages[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rgfi_tclMsgGetAvailableSpeechLanguagesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AvailableLanguages.size(); ++u32Idx)
      {
         AvailableLanguages[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      AvailableLanguages.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AvailableLanguages[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgGetAvailableSpeechLanguagesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)AvailableLanguages.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AvailableLanguages.size(); ++u32Idx)
         oOut << AvailableLanguages[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgChangeSpeechLanguageMethodStart::rgfi_tclMsgChangeSpeechLanguageMethodStart(const rgfi_tclMsgChangeSpeechLanguageMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   LanguageID = coRef.LanguageID;
   SpeakerName = coRef.SpeakerName;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgChangeSpeechLanguageMethodStart& rgfi_tclMsgChangeSpeechLanguageMethodStart::operator=(const rgfi_tclMsgChangeSpeechLanguageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   SpeakerName = coRef.SpeakerName;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgChangeSpeechLanguageMethodStart::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgChangeSpeechLanguageMethodStart::u16GetFunctionID() const {return RGFI_C_U16_CHANGESPEECHLANGUAGE;}
tU8 rgfi_tclMsgChangeSpeechLanguageMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rgfi_tclMsgChangeSpeechLanguageMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
   SpeakerName.vDestroy();
}

tU32 rgfi_tclMsgChangeSpeechLanguageMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (25 <= u16MajorVersion)
   {
      u32DynamicSize += SpeakerName.u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+4;
}

tBool rgfi_tclMsgChangeSpeechLanguageMethodStart::operator==(const rgfi_tclMsgChangeSpeechLanguageMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LanguageID == rfoCmp.LanguageID);
      bResult = bResult && (SpeakerName == rfoCmp.SpeakerName);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgChangeSpeechLanguageMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> LanguageID;
   if (25 <= oIn.u16GetMajorVersion())
   {
      oIn >> SpeakerName;
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgChangeSpeechLanguageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << LanguageID;
   if (25 <= oOut.u16GetMajorVersion())
   {
      oOut << SpeakerName;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgChangeSpeechLanguageMethodResult::rgfi_tclMsgChangeSpeechLanguageMethodResult(const rgfi_tclMsgChangeSpeechLanguageMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   LanguageID = coRef.LanguageID;
   SpeakerName = coRef.SpeakerName;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgChangeSpeechLanguageMethodResult& rgfi_tclMsgChangeSpeechLanguageMethodResult::operator=(const rgfi_tclMsgChangeSpeechLanguageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   SpeakerName = coRef.SpeakerName;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgChangeSpeechLanguageMethodResult::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgChangeSpeechLanguageMethodResult::u16GetFunctionID() const {return RGFI_C_U16_CHANGESPEECHLANGUAGE;}
tU8 rgfi_tclMsgChangeSpeechLanguageMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rgfi_tclMsgChangeSpeechLanguageMethodResult::vDestroy()
{
   LanguageID.vDestroy(); 
   SpeakerName.vDestroy();
}

tU32 rgfi_tclMsgChangeSpeechLanguageMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (25 <= u16MajorVersion)
   {
      u32DynamicSize += SpeakerName.u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+4;
}

tBool rgfi_tclMsgChangeSpeechLanguageMethodResult::operator==(const rgfi_tclMsgChangeSpeechLanguageMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LanguageID == rfoCmp.LanguageID);
      bResult = bResult && (SpeakerName == rfoCmp.SpeakerName);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgChangeSpeechLanguageMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> LanguageID;
   if (25 <= oIn.u16GetMajorVersion())
   {
      oIn >> SpeakerName;
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgChangeSpeechLanguageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << LanguageID;
   if (25 <= oOut.u16GetMajorVersion())
   {
      oOut << SpeakerName;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodStart::rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodStart(const rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   LanguageID = coRef.LanguageID;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodStart& rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodStart::operator=(const rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodStart::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodStart::u16GetFunctionID() const {return RGFI_C_U16_GETAVAILABLESPEECHMETRICSYSTEMS;}
tU8 rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
}

tU32 rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodStart::operator==(const rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LanguageID == rfoCmp.LanguageID);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> LanguageID;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << LanguageID;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodResult::rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodResult(const rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   AvailableMetricSystems = coRef.AvailableMetricSystems;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodResult& rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodResult::operator=(const rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   AvailableMetricSystems = coRef.AvailableMetricSystems;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodResult::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodResult::u16GetFunctionID() const {return RGFI_C_U16_GETAVAILABLESPEECHMETRICSYSTEMS;}
tU8 rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodResult::vDestroy()
{
   AvailableMetricSystems.clear();
}

tU32 rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+AvailableMetricSystems.size()*1;
}

tBool rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodResult::operator==(const rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AvailableMetricSystems.size() == rfoCmp.AvailableMetricSystems.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AvailableMetricSystems.size()); ++u32Idx)
            bResult = bResult && (AvailableMetricSystems[u32Idx] == rfoCmp.AvailableMetricSystems[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      AvailableMetricSystems.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AvailableMetricSystems[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgGetAvailableSpeechMetricSystemsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)AvailableMetricSystems.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AvailableMetricSystems.size(); ++u32Idx)
         oOut << AvailableMetricSystems[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgChangeSpeechMetricSystemMethodStart::rgfi_tclMsgChangeSpeechMetricSystemMethodStart(const rgfi_tclMsgChangeSpeechMetricSystemMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   MetricSystem = coRef.MetricSystem;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgChangeSpeechMetricSystemMethodStart& rgfi_tclMsgChangeSpeechMetricSystemMethodStart::operator=(const rgfi_tclMsgChangeSpeechMetricSystemMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MetricSystem = coRef.MetricSystem;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgChangeSpeechMetricSystemMethodStart::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgChangeSpeechMetricSystemMethodStart::u16GetFunctionID() const {return RGFI_C_U16_CHANGESPEECHMETRICSYSTEM;}
tU8 rgfi_tclMsgChangeSpeechMetricSystemMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rgfi_tclMsgChangeSpeechMetricSystemMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool rgfi_tclMsgChangeSpeechMetricSystemMethodStart::operator==(const rgfi_tclMsgChangeSpeechMetricSystemMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MetricSystem == rfoCmp.MetricSystem);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgChangeSpeechMetricSystemMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> MetricSystem;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgChangeSpeechMetricSystemMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MetricSystem;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgChangeSpeechMetricSystemMethodResult::rgfi_tclMsgChangeSpeechMetricSystemMethodResult(const rgfi_tclMsgChangeSpeechMetricSystemMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   MetricSystem = coRef.MetricSystem;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgChangeSpeechMetricSystemMethodResult& rgfi_tclMsgChangeSpeechMetricSystemMethodResult::operator=(const rgfi_tclMsgChangeSpeechMetricSystemMethodResult& coRef)
{
   if (this == &coRef) return *this;
   MetricSystem = coRef.MetricSystem;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgChangeSpeechMetricSystemMethodResult::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgChangeSpeechMetricSystemMethodResult::u16GetFunctionID() const {return RGFI_C_U16_CHANGESPEECHMETRICSYSTEM;}
tU8 rgfi_tclMsgChangeSpeechMetricSystemMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rgfi_tclMsgChangeSpeechMetricSystemMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool rgfi_tclMsgChangeSpeechMetricSystemMethodResult::operator==(const rgfi_tclMsgChangeSpeechMetricSystemMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MetricSystem == rfoCmp.MetricSystem);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgChangeSpeechMetricSystemMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> MetricSystem;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgChangeSpeechMetricSystemMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MetricSystem;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgGetAvailableSpeechFeatureMethodStart::rgfi_tclMsgGetAvailableSpeechFeatureMethodStart(const rgfi_tclMsgGetAvailableSpeechFeatureMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgGetAvailableSpeechFeatureMethodStart& rgfi_tclMsgGetAvailableSpeechFeatureMethodStart::operator=(const rgfi_tclMsgGetAvailableSpeechFeatureMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgGetAvailableSpeechFeatureMethodStart::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgGetAvailableSpeechFeatureMethodStart::u16GetFunctionID() const {return RGFI_C_U16_GETAVAILABLESPEECHFEATURE;}
tU8 rgfi_tclMsgGetAvailableSpeechFeatureMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rgfi_tclMsgGetAvailableSpeechFeatureMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgGetAvailableSpeechFeatureMethodStart::operator==(const rgfi_tclMsgGetAvailableSpeechFeatureMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgGetAvailableSpeechFeatureMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgGetAvailableSpeechFeatureMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgGetAvailableSpeechFeatureMethodResult::rgfi_tclMsgGetAvailableSpeechFeatureMethodResult(const rgfi_tclMsgGetAvailableSpeechFeatureMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   AvailableFeature = coRef.AvailableFeature;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgGetAvailableSpeechFeatureMethodResult& rgfi_tclMsgGetAvailableSpeechFeatureMethodResult::operator=(const rgfi_tclMsgGetAvailableSpeechFeatureMethodResult& coRef)
{
   if (this == &coRef) return *this;
   AvailableFeature = coRef.AvailableFeature;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgGetAvailableSpeechFeatureMethodResult::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgGetAvailableSpeechFeatureMethodResult::u16GetFunctionID() const {return RGFI_C_U16_GETAVAILABLESPEECHFEATURE;}
tU8 rgfi_tclMsgGetAvailableSpeechFeatureMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rgfi_tclMsgGetAvailableSpeechFeatureMethodResult::vDestroy()
{
   AvailableFeature.clear();
}

tU32 rgfi_tclMsgGetAvailableSpeechFeatureMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+AvailableFeature.size()*1;
}

tBool rgfi_tclMsgGetAvailableSpeechFeatureMethodResult::operator==(const rgfi_tclMsgGetAvailableSpeechFeatureMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AvailableFeature.size() == rfoCmp.AvailableFeature.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AvailableFeature.size()); ++u32Idx)
            bResult = bResult && (AvailableFeature[u32Idx] == rfoCmp.AvailableFeature[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rgfi_tclMsgGetAvailableSpeechFeatureMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      AvailableFeature.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AvailableFeature[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgGetAvailableSpeechFeatureMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)AvailableFeature.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AvailableFeature.size(); ++u32Idx)
         oOut << AvailableFeature[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgChangeSpeechFeatureMethodStart::rgfi_tclMsgChangeSpeechFeatureMethodStart(const rgfi_tclMsgChangeSpeechFeatureMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   SpeechFeature = coRef.SpeechFeature;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgChangeSpeechFeatureMethodStart& rgfi_tclMsgChangeSpeechFeatureMethodStart::operator=(const rgfi_tclMsgChangeSpeechFeatureMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SpeechFeature = coRef.SpeechFeature;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgChangeSpeechFeatureMethodStart::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgChangeSpeechFeatureMethodStart::u16GetFunctionID() const {return RGFI_C_U16_CHANGESPEECHFEATURE;}
tU8 rgfi_tclMsgChangeSpeechFeatureMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rgfi_tclMsgChangeSpeechFeatureMethodStart::vDestroy()
{
   SpeechFeature.clear();
}

tU32 rgfi_tclMsgChangeSpeechFeatureMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+SpeechFeature.size()*1;
}

tBool rgfi_tclMsgChangeSpeechFeatureMethodStart::operator==(const rgfi_tclMsgChangeSpeechFeatureMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SpeechFeature.size() == rfoCmp.SpeechFeature.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SpeechFeature.size()); ++u32Idx)
            bResult = bResult && (SpeechFeature[u32Idx] == rfoCmp.SpeechFeature[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rgfi_tclMsgChangeSpeechFeatureMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      SpeechFeature.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SpeechFeature[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgChangeSpeechFeatureMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)SpeechFeature.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SpeechFeature.size(); ++u32Idx)
         oOut << SpeechFeature[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgChangeSpeechFeatureMethodResult::rgfi_tclMsgChangeSpeechFeatureMethodResult(const rgfi_tclMsgChangeSpeechFeatureMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   SpeechFeature = coRef.SpeechFeature;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgChangeSpeechFeatureMethodResult& rgfi_tclMsgChangeSpeechFeatureMethodResult::operator=(const rgfi_tclMsgChangeSpeechFeatureMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SpeechFeature = coRef.SpeechFeature;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgChangeSpeechFeatureMethodResult::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgChangeSpeechFeatureMethodResult::u16GetFunctionID() const {return RGFI_C_U16_CHANGESPEECHFEATURE;}
tU8 rgfi_tclMsgChangeSpeechFeatureMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rgfi_tclMsgChangeSpeechFeatureMethodResult::vDestroy()
{
   SpeechFeature.clear();
}

tU32 rgfi_tclMsgChangeSpeechFeatureMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+SpeechFeature.size()*1;
}

tBool rgfi_tclMsgChangeSpeechFeatureMethodResult::operator==(const rgfi_tclMsgChangeSpeechFeatureMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SpeechFeature.size() == rfoCmp.SpeechFeature.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SpeechFeature.size()); ++u32Idx)
            bResult = bResult && (SpeechFeature[u32Idx] == rfoCmp.SpeechFeature[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rgfi_tclMsgChangeSpeechFeatureMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      SpeechFeature.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SpeechFeature[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgChangeSpeechFeatureMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)SpeechFeature.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SpeechFeature.size(); ++u32Idx)
         oOut << SpeechFeature[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeakSentenceMethodStart::rgfi_tclMsgSpeakSentenceMethodStart(const rgfi_tclMsgSpeakSentenceMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   SentenceId = coRef.SentenceId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeakSentenceMethodStart& rgfi_tclMsgSpeakSentenceMethodStart::operator=(const rgfi_tclMsgSpeakSentenceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SentenceId = coRef.SentenceId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSpeakSentenceMethodStart::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSpeakSentenceMethodStart::u16GetFunctionID() const {return RGFI_C_U16_SPEAKSENTENCE;}
tU8 rgfi_tclMsgSpeakSentenceMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rgfi_tclMsgSpeakSentenceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool rgfi_tclMsgSpeakSentenceMethodStart::operator==(const rgfi_tclMsgSpeakSentenceMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SentenceId == rfoCmp.SentenceId);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSpeakSentenceMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> SentenceId;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSpeakSentenceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << SentenceId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeakSentenceMethodResult::rgfi_tclMsgSpeakSentenceMethodResult(const rgfi_tclMsgSpeakSentenceMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeakSentenceMethodResult& rgfi_tclMsgSpeakSentenceMethodResult::operator=(const rgfi_tclMsgSpeakSentenceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSpeakSentenceMethodResult::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSpeakSentenceMethodResult::u16GetFunctionID() const {return RGFI_C_U16_SPEAKSENTENCE;}
tU8 rgfi_tclMsgSpeakSentenceMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rgfi_tclMsgSpeakSentenceMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgSpeakSentenceMethodResult::operator==(const rgfi_tclMsgSpeakSentenceMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSpeakSentenceMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSpeakSentenceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeakTMInfoMethodStart::rgfi_tclMsgSpeakTMInfoMethodStart(const rgfi_tclMsgSpeakTMInfoMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TMInfo = coRef.TMInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeakTMInfoMethodStart& rgfi_tclMsgSpeakTMInfoMethodStart::operator=(const rgfi_tclMsgSpeakTMInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TMInfo = coRef.TMInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSpeakTMInfoMethodStart::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSpeakTMInfoMethodStart::u16GetFunctionID() const {return RGFI_C_U16_SPEAKTMINFO;}
tU8 rgfi_tclMsgSpeakTMInfoMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rgfi_tclMsgSpeakTMInfoMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TMInfo.size(); ++u32Idx)
         TMInfo[u32Idx].vDestroy();
   }
   TMInfo.clear();
}

tU32 rgfi_tclMsgSpeakTMInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TMInfo.size(); ++u32ListIdx)
      u32DynamicSize += TMInfo[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool rgfi_tclMsgSpeakTMInfoMethodStart::operator==(const rgfi_tclMsgSpeakTMInfoMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TMInfo.size() == rfoCmp.TMInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TMInfo.size()); ++u32Idx)
            bResult = bResult && (TMInfo[u32Idx] == rfoCmp.TMInfo[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSpeakTMInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TMInfo.size(); ++u32Idx)
      {
         TMInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TMInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TMInfo[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSpeakTMInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)TMInfo.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TMInfo.size(); ++u32Idx)
         oOut << TMInfo[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeakTMInfoMethodResult::rgfi_tclMsgSpeakTMInfoMethodResult(const rgfi_tclMsgSpeakTMInfoMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeakTMInfoMethodResult& rgfi_tclMsgSpeakTMInfoMethodResult::operator=(const rgfi_tclMsgSpeakTMInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSpeakTMInfoMethodResult::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSpeakTMInfoMethodResult::u16GetFunctionID() const {return RGFI_C_U16_SPEAKTMINFO;}
tU8 rgfi_tclMsgSpeakTMInfoMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rgfi_tclMsgSpeakTMInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgSpeakTMInfoMethodResult::operator==(const rgfi_tclMsgSpeakTMInfoMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSpeakTMInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSpeakTMInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeakTMInfoMethodAbort::rgfi_tclMsgSpeakTMInfoMethodAbort(const rgfi_tclMsgSpeakTMInfoMethodAbort& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeakTMInfoMethodAbort& rgfi_tclMsgSpeakTMInfoMethodAbort::operator=(const rgfi_tclMsgSpeakTMInfoMethodAbort& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSpeakTMInfoMethodAbort::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSpeakTMInfoMethodAbort::u16GetFunctionID() const {return RGFI_C_U16_SPEAKTMINFO;}
tU8 rgfi_tclMsgSpeakTMInfoMethodAbort::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODABORT;}

tU32 rgfi_tclMsgSpeakTMInfoMethodAbort::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgSpeakTMInfoMethodAbort::operator==(const rgfi_tclMsgSpeakTMInfoMethodAbort& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSpeakTMInfoMethodAbort::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSpeakTMInfoMethodAbort::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeakTMInfoAbortResult::rgfi_tclMsgSpeakTMInfoAbortResult(const rgfi_tclMsgSpeakTMInfoAbortResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeakTMInfoAbortResult& rgfi_tclMsgSpeakTMInfoAbortResult::operator=(const rgfi_tclMsgSpeakTMInfoAbortResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSpeakTMInfoAbortResult::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSpeakTMInfoAbortResult::u16GetFunctionID() const {return RGFI_C_U16_SPEAKTMINFO;}
tU8 rgfi_tclMsgSpeakTMInfoAbortResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_ABORTRESULT;}

tU32 rgfi_tclMsgSpeakTMInfoAbortResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgSpeakTMInfoAbortResult::operator==(const rgfi_tclMsgSpeakTMInfoAbortResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSpeakTMInfoAbortResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSpeakTMInfoAbortResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgPlayDebugSoundMethodStart::rgfi_tclMsgPlayDebugSoundMethodStart(const rgfi_tclMsgPlayDebugSoundMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   SentenceId = coRef.SentenceId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgPlayDebugSoundMethodStart& rgfi_tclMsgPlayDebugSoundMethodStart::operator=(const rgfi_tclMsgPlayDebugSoundMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SentenceId = coRef.SentenceId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgPlayDebugSoundMethodStart::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgPlayDebugSoundMethodStart::u16GetFunctionID() const {return RGFI_C_U16_PLAYDEBUGSOUND;}
tU8 rgfi_tclMsgPlayDebugSoundMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rgfi_tclMsgPlayDebugSoundMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool rgfi_tclMsgPlayDebugSoundMethodStart::operator==(const rgfi_tclMsgPlayDebugSoundMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SentenceId == rfoCmp.SentenceId);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgPlayDebugSoundMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> SentenceId;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgPlayDebugSoundMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << SentenceId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSetPredictiveCCModeMethodStart::rgfi_tclMsgSetPredictiveCCModeMethodStart(const rgfi_tclMsgSetPredictiveCCModeMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   OperationMode = coRef.OperationMode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSetPredictiveCCModeMethodStart& rgfi_tclMsgSetPredictiveCCModeMethodStart::operator=(const rgfi_tclMsgSetPredictiveCCModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   OperationMode = coRef.OperationMode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSetPredictiveCCModeMethodStart::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSetPredictiveCCModeMethodStart::u16GetFunctionID() const {return RGFI_C_U16_SETPREDICTIVECCMODE;}
tU8 rgfi_tclMsgSetPredictiveCCModeMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rgfi_tclMsgSetPredictiveCCModeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool rgfi_tclMsgSetPredictiveCCModeMethodStart::operator==(const rgfi_tclMsgSetPredictiveCCModeMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OperationMode == rfoCmp.OperationMode);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSetPredictiveCCModeMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> OperationMode;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSetPredictiveCCModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << OperationMode;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSetPredictiveCCModeMethodResult::rgfi_tclMsgSetPredictiveCCModeMethodResult(const rgfi_tclMsgSetPredictiveCCModeMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSetPredictiveCCModeMethodResult& rgfi_tclMsgSetPredictiveCCModeMethodResult::operator=(const rgfi_tclMsgSetPredictiveCCModeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSetPredictiveCCModeMethodResult::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSetPredictiveCCModeMethodResult::u16GetFunctionID() const {return RGFI_C_U16_SETPREDICTIVECCMODE;}
tU8 rgfi_tclMsgSetPredictiveCCModeMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rgfi_tclMsgSetPredictiveCCModeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgSetPredictiveCCModeMethodResult::operator==(const rgfi_tclMsgSetPredictiveCCModeMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSetPredictiveCCModeMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSetPredictiveCCModeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgGuidanceModeGet::rgfi_tclMsgGuidanceModeGet(const rgfi_tclMsgGuidanceModeGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgGuidanceModeGet& rgfi_tclMsgGuidanceModeGet::operator=(const rgfi_tclMsgGuidanceModeGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgGuidanceModeGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgGuidanceModeGet::u16GetFunctionID() const {return RGFI_C_U16_GUIDANCEMODE;}
tU8 rgfi_tclMsgGuidanceModeGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgGuidanceModeGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgGuidanceModeGet::operator==(const rgfi_tclMsgGuidanceModeGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgGuidanceModeGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgGuidanceModeGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgGuidanceModeStatus::rgfi_tclMsgGuidanceModeStatus(const rgfi_tclMsgGuidanceModeStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   GuidanceMode = coRef.GuidanceMode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgGuidanceModeStatus& rgfi_tclMsgGuidanceModeStatus::operator=(const rgfi_tclMsgGuidanceModeStatus& coRef)
{
   if (this == &coRef) return *this;
   GuidanceMode = coRef.GuidanceMode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgGuidanceModeStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgGuidanceModeStatus::u16GetFunctionID() const {return RGFI_C_U16_GUIDANCEMODE;}
tU8 rgfi_tclMsgGuidanceModeStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 rgfi_tclMsgGuidanceModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool rgfi_tclMsgGuidanceModeStatus::operator==(const rgfi_tclMsgGuidanceModeStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (GuidanceMode == rfoCmp.GuidanceMode);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgGuidanceModeStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> GuidanceMode;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgGuidanceModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << GuidanceMode;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgGuidanceStatusGet::rgfi_tclMsgGuidanceStatusGet(const rgfi_tclMsgGuidanceStatusGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgGuidanceStatusGet& rgfi_tclMsgGuidanceStatusGet::operator=(const rgfi_tclMsgGuidanceStatusGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgGuidanceStatusGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgGuidanceStatusGet::u16GetFunctionID() const {return RGFI_C_U16_GUIDANCESTATUS;}
tU8 rgfi_tclMsgGuidanceStatusGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgGuidanceStatusGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgGuidanceStatusGet::operator==(const rgfi_tclMsgGuidanceStatusGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgGuidanceStatusGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgGuidanceStatusGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgGuidanceStatusStatus::rgfi_tclMsgGuidanceStatusStatus(const rgfi_tclMsgGuidanceStatusStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   GuidanceStatus = coRef.GuidanceStatus;
   GuidedTripHandle = coRef.GuidedTripHandle;
   GuidedRouteHandle = coRef.GuidedRouteHandle;
   CurrentTripSegment = coRef.CurrentTripSegment;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgGuidanceStatusStatus& rgfi_tclMsgGuidanceStatusStatus::operator=(const rgfi_tclMsgGuidanceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   GuidanceStatus = coRef.GuidanceStatus;
   GuidedTripHandle = coRef.GuidedTripHandle;
   GuidedRouteHandle = coRef.GuidedRouteHandle;
   CurrentTripSegment = coRef.CurrentTripSegment;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgGuidanceStatusStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgGuidanceStatusStatus::u16GetFunctionID() const {return RGFI_C_U16_GUIDANCESTATUS;}
tU8 rgfi_tclMsgGuidanceStatusStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 rgfi_tclMsgGuidanceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

tBool rgfi_tclMsgGuidanceStatusStatus::operator==(const rgfi_tclMsgGuidanceStatusStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (GuidanceStatus == rfoCmp.GuidanceStatus);
      bResult = bResult && (GuidedTripHandle == rfoCmp.GuidedTripHandle);
      bResult = bResult && (GuidedRouteHandle == rfoCmp.GuidedRouteHandle);
      bResult = bResult && (CurrentTripSegment == rfoCmp.CurrentTripSegment);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgGuidanceStatusStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> GuidanceStatus;
   oIn >> GuidedTripHandle;
   oIn >> GuidedRouteHandle;
   oIn >> CurrentTripSegment;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgGuidanceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << GuidanceStatus;
   oOut << GuidedTripHandle;
   oOut << GuidedRouteHandle;
   oOut << CurrentTripSegment;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDataCarrierRequestGet::rgfi_tclMsgDataCarrierRequestGet(const rgfi_tclMsgDataCarrierRequestGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDataCarrierRequestGet& rgfi_tclMsgDataCarrierRequestGet::operator=(const rgfi_tclMsgDataCarrierRequestGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgDataCarrierRequestGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgDataCarrierRequestGet::u16GetFunctionID() const {return RGFI_C_U16_DATACARRIERREQUEST;}
tU8 rgfi_tclMsgDataCarrierRequestGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgDataCarrierRequestGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgDataCarrierRequestGet::operator==(const rgfi_tclMsgDataCarrierRequestGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgDataCarrierRequestGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgDataCarrierRequestGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDataCarrierRequestStatus::rgfi_tclMsgDataCarrierRequestStatus(const rgfi_tclMsgDataCarrierRequestStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   DataCarrierRequestStatus = coRef.DataCarrierRequestStatus;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDataCarrierRequestStatus& rgfi_tclMsgDataCarrierRequestStatus::operator=(const rgfi_tclMsgDataCarrierRequestStatus& coRef)
{
   if (this == &coRef) return *this;
   DataCarrierRequestStatus = coRef.DataCarrierRequestStatus;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgDataCarrierRequestStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgDataCarrierRequestStatus::u16GetFunctionID() const {return RGFI_C_U16_DATACARRIERREQUEST;}
tU8 rgfi_tclMsgDataCarrierRequestStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 rgfi_tclMsgDataCarrierRequestStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool rgfi_tclMsgDataCarrierRequestStatus::operator==(const rgfi_tclMsgDataCarrierRequestStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DataCarrierRequestStatus == rfoCmp.DataCarrierRequestStatus);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgDataCarrierRequestStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> DataCarrierRequestStatus;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgDataCarrierRequestStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DataCarrierRequestStatus;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDistanceToNextManeuverGet::rgfi_tclMsgDistanceToNextManeuverGet(const rgfi_tclMsgDistanceToNextManeuverGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDistanceToNextManeuverGet& rgfi_tclMsgDistanceToNextManeuverGet::operator=(const rgfi_tclMsgDistanceToNextManeuverGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgDistanceToNextManeuverGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgDistanceToNextManeuverGet::u16GetFunctionID() const {return RGFI_C_U16_DISTANCETONEXTMANEUVER;}
tU8 rgfi_tclMsgDistanceToNextManeuverGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgDistanceToNextManeuverGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgDistanceToNextManeuverGet::operator==(const rgfi_tclMsgDistanceToNextManeuverGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgDistanceToNextManeuverGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgDistanceToNextManeuverGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDistanceToNextManeuverStatus::rgfi_tclMsgDistanceToNextManeuverStatus(const rgfi_tclMsgDistanceToNextManeuverStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ReleaseNumber = coRef.ReleaseNumber;
   Distance = coRef.Distance;
   BargraphFlag = coRef.BargraphFlag;
   Bargraph = coRef.Bargraph;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDistanceToNextManeuverStatus& rgfi_tclMsgDistanceToNextManeuverStatus::operator=(const rgfi_tclMsgDistanceToNextManeuverStatus& coRef)
{
   if (this == &coRef) return *this;
   ReleaseNumber = coRef.ReleaseNumber;
   Distance = coRef.Distance;
   BargraphFlag = coRef.BargraphFlag;
   Bargraph = coRef.Bargraph;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgDistanceToNextManeuverStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgDistanceToNextManeuverStatus::u16GetFunctionID() const {return RGFI_C_U16_DISTANCETONEXTMANEUVER;}
tU8 rgfi_tclMsgDistanceToNextManeuverStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 rgfi_tclMsgDistanceToNextManeuverStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

tBool rgfi_tclMsgDistanceToNextManeuverStatus::operator==(const rgfi_tclMsgDistanceToNextManeuverStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ReleaseNumber == rfoCmp.ReleaseNumber);
      bResult = bResult && (Distance == rfoCmp.Distance);
      bResult = bResult && (BargraphFlag == rfoCmp.BargraphFlag);
      bResult = bResult && (Bargraph == rfoCmp.Bargraph);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgDistanceToNextManeuverStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ReleaseNumber;
   oIn >> Distance;
   oIn >> BargraphFlag;
   oIn >> Bargraph;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgDistanceToNextManeuverStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ReleaseNumber;
   oOut << Distance;
   oOut << BargraphFlag;
   oOut << Bargraph;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgTurnToInfoGet::rgfi_tclMsgTurnToInfoGet(const rgfi_tclMsgTurnToInfoGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgTurnToInfoGet& rgfi_tclMsgTurnToInfoGet::operator=(const rgfi_tclMsgTurnToInfoGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgTurnToInfoGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgTurnToInfoGet::u16GetFunctionID() const {return RGFI_C_U16_TURNTOINFO;}
tU8 rgfi_tclMsgTurnToInfoGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgTurnToInfoGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgTurnToInfoGet::operator==(const rgfi_tclMsgTurnToInfoGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgTurnToInfoGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgTurnToInfoGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgTurnToInfoStatus::rgfi_tclMsgTurnToInfoStatus(const rgfi_tclMsgTurnToInfoStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ReleaseNumber = coRef.ReleaseNumber;
   TurnToInfo = coRef.TurnToInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgTurnToInfoStatus& rgfi_tclMsgTurnToInfoStatus::operator=(const rgfi_tclMsgTurnToInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   ReleaseNumber = coRef.ReleaseNumber;
   TurnToInfo = coRef.TurnToInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgTurnToInfoStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgTurnToInfoStatus::u16GetFunctionID() const {return RGFI_C_U16_TURNTOINFO;}
tU8 rgfi_tclMsgTurnToInfoStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rgfi_tclMsgTurnToInfoStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TurnToInfo.size(); ++u32Idx)
         TurnToInfo[u32Idx].vDestroy();
   }
   TurnToInfo.clear();
}

tU32 rgfi_tclMsgTurnToInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TurnToInfo.size(); ++u32ListIdx)
      u32DynamicSize += TurnToInfo[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool rgfi_tclMsgTurnToInfoStatus::operator==(const rgfi_tclMsgTurnToInfoStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ReleaseNumber == rfoCmp.ReleaseNumber);
      bResult = bResult && (TurnToInfo.size() == rfoCmp.TurnToInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TurnToInfo.size()); ++u32Idx)
            bResult = bResult && (TurnToInfo[u32Idx] == rfoCmp.TurnToInfo[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rgfi_tclMsgTurnToInfoStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ReleaseNumber;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TurnToInfo.size(); ++u32Idx)
      {
         TurnToInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TurnToInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TurnToInfo[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgTurnToInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ReleaseNumber;
   oOut << (tU32)TurnToInfo.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TurnToInfo.size(); ++u32Idx)
         oOut << TurnToInfo[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgCurrentGuidanceDescriptorGet::rgfi_tclMsgCurrentGuidanceDescriptorGet(const rgfi_tclMsgCurrentGuidanceDescriptorGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgCurrentGuidanceDescriptorGet& rgfi_tclMsgCurrentGuidanceDescriptorGet::operator=(const rgfi_tclMsgCurrentGuidanceDescriptorGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgCurrentGuidanceDescriptorGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgCurrentGuidanceDescriptorGet::u16GetFunctionID() const {return RGFI_C_U16_CURRENTGUIDANCEDESCRIPTOR;}
tU8 rgfi_tclMsgCurrentGuidanceDescriptorGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgCurrentGuidanceDescriptorGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgCurrentGuidanceDescriptorGet::operator==(const rgfi_tclMsgCurrentGuidanceDescriptorGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgCurrentGuidanceDescriptorGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgCurrentGuidanceDescriptorGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgCurrentGuidanceDescriptorStatus::rgfi_tclMsgCurrentGuidanceDescriptorStatus(const rgfi_tclMsgCurrentGuidanceDescriptorStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ReleaseNumber = coRef.ReleaseNumber;
   GuidanceElement = coRef.GuidanceElement;
   GuidanceDescriptorInfoCategoryList = coRef.GuidanceDescriptorInfoCategoryList;
   DatasetId = coRef.DatasetId;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   RouteInfoId = coRef.RouteInfoId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgCurrentGuidanceDescriptorStatus& rgfi_tclMsgCurrentGuidanceDescriptorStatus::operator=(const rgfi_tclMsgCurrentGuidanceDescriptorStatus& coRef)
{
   if (this == &coRef) return *this;
   ReleaseNumber = coRef.ReleaseNumber;
   GuidanceElement = coRef.GuidanceElement;
   GuidanceDescriptorInfoCategoryList = coRef.GuidanceDescriptorInfoCategoryList;
   DatasetId = coRef.DatasetId;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   RouteInfoId = coRef.RouteInfoId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgCurrentGuidanceDescriptorStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgCurrentGuidanceDescriptorStatus::u16GetFunctionID() const {return RGFI_C_U16_CURRENTGUIDANCEDESCRIPTOR;}
tU8 rgfi_tclMsgCurrentGuidanceDescriptorStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rgfi_tclMsgCurrentGuidanceDescriptorStatus::vDestroy()
{
   GuidanceElement.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < GuidanceDescriptorInfoCategoryList.size(); ++u32Idx)
         GuidanceDescriptorInfoCategoryList[u32Idx].vDestroy();
   }
   GuidanceDescriptorInfoCategoryList.clear();
}

tU32 rgfi_tclMsgCurrentGuidanceDescriptorStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   if (13 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      for (u32ListIdx = 0; u32ListIdx < GuidanceDescriptorInfoCategoryList.size(); ++u32ListIdx)
         u32DynamicSize += GuidanceDescriptorInfoCategoryList[u32ListIdx].u32GetSize(u16MajorVersion);
   }
   if (17 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (35 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (35 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (35 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+4+GuidanceElement.u32GetSize(u16MajorVersion);
}

tBool rgfi_tclMsgCurrentGuidanceDescriptorStatus::operator==(const rgfi_tclMsgCurrentGuidanceDescriptorStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ReleaseNumber == rfoCmp.ReleaseNumber);
      bResult = bResult && (GuidanceElement == rfoCmp.GuidanceElement);
      bResult = bResult && (GuidanceDescriptorInfoCategoryList.size() == rfoCmp.GuidanceDescriptorInfoCategoryList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < GuidanceDescriptorInfoCategoryList.size()); ++u32Idx)
            bResult = bResult && (GuidanceDescriptorInfoCategoryList[u32Idx] == rfoCmp.GuidanceDescriptorInfoCategoryList[u32Idx]);
      }
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (RouteInfoId == rfoCmp.RouteInfoId);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgCurrentGuidanceDescriptorStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ReleaseNumber;
   oIn >> GuidanceElement;
   if (13 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < GuidanceDescriptorInfoCategoryList.size(); ++u32Idx)
         {
            GuidanceDescriptorInfoCategoryList[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         GuidanceDescriptorInfoCategoryList.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> GuidanceDescriptorInfoCategoryList[u32Idx];
         }
      }
   }
   if (17 <= oIn.u16GetMajorVersion())
   {
      oIn >> DatasetId;
   }
   if (35 <= oIn.u16GetMajorVersion())
   {
      oIn >> TripHandle;
   }
   if (35 <= oIn.u16GetMajorVersion())
   {
      oIn >> RouteHandle;
   }
   if (35 <= oIn.u16GetMajorVersion())
   {
      oIn >> RouteInfoId;
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgCurrentGuidanceDescriptorStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ReleaseNumber;
   oOut << GuidanceElement;
   if (13 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)GuidanceDescriptorInfoCategoryList.size();
      {
         for (tU32 u32Idx = 0; u32Idx < GuidanceDescriptorInfoCategoryList.size(); ++u32Idx)
            oOut << GuidanceDescriptorInfoCategoryList[u32Idx];
      }
   }
   if (17 <= oOut.u16GetMajorVersion())
   {
      oOut << DatasetId;
   }
   if (35 <= oOut.u16GetMajorVersion())
   {
      oOut << TripHandle;
   }
   if (35 <= oOut.u16GetMajorVersion())
   {
      oOut << RouteHandle;
   }
   if (35 <= oOut.u16GetMajorVersion())
   {
      oOut << RouteInfoId;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgNextGuidanceDescriptorsGet::rgfi_tclMsgNextGuidanceDescriptorsGet(const rgfi_tclMsgNextGuidanceDescriptorsGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgNextGuidanceDescriptorsGet& rgfi_tclMsgNextGuidanceDescriptorsGet::operator=(const rgfi_tclMsgNextGuidanceDescriptorsGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgNextGuidanceDescriptorsGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgNextGuidanceDescriptorsGet::u16GetFunctionID() const {return RGFI_C_U16_NEXTGUIDANCEDESCRIPTORS;}
tU8 rgfi_tclMsgNextGuidanceDescriptorsGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgNextGuidanceDescriptorsGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgNextGuidanceDescriptorsGet::operator==(const rgfi_tclMsgNextGuidanceDescriptorsGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgNextGuidanceDescriptorsGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgNextGuidanceDescriptorsGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgNextGuidanceDescriptorsStatus::rgfi_tclMsgNextGuidanceDescriptorsStatus(const rgfi_tclMsgNextGuidanceDescriptorsStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ReleaseNumber = coRef.ReleaseNumber;
   GuidanceManoeuvreSymbolList = coRef.GuidanceManoeuvreSymbolList;
   GuidanceDescriptorInfoCategoryList = coRef.GuidanceDescriptorInfoCategoryList;
   DatasetId = coRef.DatasetId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgNextGuidanceDescriptorsStatus& rgfi_tclMsgNextGuidanceDescriptorsStatus::operator=(const rgfi_tclMsgNextGuidanceDescriptorsStatus& coRef)
{
   if (this == &coRef) return *this;
   ReleaseNumber = coRef.ReleaseNumber;
   GuidanceManoeuvreSymbolList = coRef.GuidanceManoeuvreSymbolList;
   GuidanceDescriptorInfoCategoryList = coRef.GuidanceDescriptorInfoCategoryList;
   DatasetId = coRef.DatasetId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgNextGuidanceDescriptorsStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgNextGuidanceDescriptorsStatus::u16GetFunctionID() const {return RGFI_C_U16_NEXTGUIDANCEDESCRIPTORS;}
tU8 rgfi_tclMsgNextGuidanceDescriptorsStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rgfi_tclMsgNextGuidanceDescriptorsStatus::vDestroy()
{
   GuidanceManoeuvreSymbolList.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < GuidanceDescriptorInfoCategoryList.size(); ++u32Idx)
         GuidanceDescriptorInfoCategoryList[u32Idx].vDestroy();
   }
   GuidanceDescriptorInfoCategoryList.clear();
}

tU32 rgfi_tclMsgNextGuidanceDescriptorsStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   if (13 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      for (u32ListIdx = 0; u32ListIdx < GuidanceDescriptorInfoCategoryList.size(); ++u32ListIdx)
         u32DynamicSize += GuidanceDescriptorInfoCategoryList[u32ListIdx].u32GetSize(u16MajorVersion);
   }
   if (17 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+4+GuidanceManoeuvreSymbolList.u32GetSize(u16MajorVersion);
}

tBool rgfi_tclMsgNextGuidanceDescriptorsStatus::operator==(const rgfi_tclMsgNextGuidanceDescriptorsStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ReleaseNumber == rfoCmp.ReleaseNumber);
      bResult = bResult && (GuidanceManoeuvreSymbolList == rfoCmp.GuidanceManoeuvreSymbolList);
      bResult = bResult && (GuidanceDescriptorInfoCategoryList.size() == rfoCmp.GuidanceDescriptorInfoCategoryList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < GuidanceDescriptorInfoCategoryList.size()); ++u32Idx)
            bResult = bResult && (GuidanceDescriptorInfoCategoryList[u32Idx] == rfoCmp.GuidanceDescriptorInfoCategoryList[u32Idx]);
      }
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgNextGuidanceDescriptorsStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ReleaseNumber;
   oIn >> GuidanceManoeuvreSymbolList;
   if (13 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < GuidanceDescriptorInfoCategoryList.size(); ++u32Idx)
         {
            GuidanceDescriptorInfoCategoryList[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         GuidanceDescriptorInfoCategoryList.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> GuidanceDescriptorInfoCategoryList[u32Idx];
         }
      }
   }
   if (17 <= oIn.u16GetMajorVersion())
   {
      oIn >> DatasetId;
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgNextGuidanceDescriptorsStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ReleaseNumber;
   oOut << GuidanceManoeuvreSymbolList;
   if (13 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)GuidanceDescriptorInfoCategoryList.size();
      {
         for (tU32 u32Idx = 0; u32Idx < GuidanceDescriptorInfoCategoryList.size(); ++u32Idx)
            oOut << GuidanceDescriptorInfoCategoryList[u32Idx];
      }
   }
   if (17 <= oOut.u16GetMajorVersion())
   {
      oOut << DatasetId;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDistanceToCurrentManoeuvreGet::rgfi_tclMsgDistanceToCurrentManoeuvreGet(const rgfi_tclMsgDistanceToCurrentManoeuvreGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDistanceToCurrentManoeuvreGet& rgfi_tclMsgDistanceToCurrentManoeuvreGet::operator=(const rgfi_tclMsgDistanceToCurrentManoeuvreGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgDistanceToCurrentManoeuvreGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgDistanceToCurrentManoeuvreGet::u16GetFunctionID() const {return RGFI_C_U16_DISTANCETOCURRENTMANOEUVRE;}
tU8 rgfi_tclMsgDistanceToCurrentManoeuvreGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgDistanceToCurrentManoeuvreGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgDistanceToCurrentManoeuvreGet::operator==(const rgfi_tclMsgDistanceToCurrentManoeuvreGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgDistanceToCurrentManoeuvreGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgDistanceToCurrentManoeuvreGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDistanceToCurrentManoeuvreStatus::rgfi_tclMsgDistanceToCurrentManoeuvreStatus(const rgfi_tclMsgDistanceToCurrentManoeuvreStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ReleaseNumber = coRef.ReleaseNumber;
   DistanceToDecisionPoint = coRef.DistanceToDecisionPoint;
   DistanceToTrafficNodeBegin = coRef.DistanceToTrafficNodeBegin;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDistanceToCurrentManoeuvreStatus& rgfi_tclMsgDistanceToCurrentManoeuvreStatus::operator=(const rgfi_tclMsgDistanceToCurrentManoeuvreStatus& coRef)
{
   if (this == &coRef) return *this;
   ReleaseNumber = coRef.ReleaseNumber;
   DistanceToDecisionPoint = coRef.DistanceToDecisionPoint;
   DistanceToTrafficNodeBegin = coRef.DistanceToTrafficNodeBegin;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgDistanceToCurrentManoeuvreStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgDistanceToCurrentManoeuvreStatus::u16GetFunctionID() const {return RGFI_C_U16_DISTANCETOCURRENTMANOEUVRE;}
tU8 rgfi_tclMsgDistanceToCurrentManoeuvreStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rgfi_tclMsgDistanceToCurrentManoeuvreStatus::vDestroy()
{
   DistanceToDecisionPoint.vDestroy(); 
   DistanceToTrafficNodeBegin.vDestroy(); 
}

tU32 rgfi_tclMsgDistanceToCurrentManoeuvreStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+DistanceToDecisionPoint.u32GetSize(u16MajorVersion)+DistanceToTrafficNodeBegin.u32GetSize(u16MajorVersion);
}

tBool rgfi_tclMsgDistanceToCurrentManoeuvreStatus::operator==(const rgfi_tclMsgDistanceToCurrentManoeuvreStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ReleaseNumber == rfoCmp.ReleaseNumber);
      bResult = bResult && (DistanceToDecisionPoint == rfoCmp.DistanceToDecisionPoint);
      bResult = bResult && (DistanceToTrafficNodeBegin == rfoCmp.DistanceToTrafficNodeBegin);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgDistanceToCurrentManoeuvreStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ReleaseNumber;
   oIn >> DistanceToDecisionPoint;
   oIn >> DistanceToTrafficNodeBegin;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgDistanceToCurrentManoeuvreStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ReleaseNumber;
   oOut << DistanceToDecisionPoint;
   oOut << DistanceToTrafficNodeBegin;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgNextManeuverDescriptorGet::rgfi_tclMsgNextManeuverDescriptorGet(const rgfi_tclMsgNextManeuverDescriptorGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgNextManeuverDescriptorGet& rgfi_tclMsgNextManeuverDescriptorGet::operator=(const rgfi_tclMsgNextManeuverDescriptorGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgNextManeuverDescriptorGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgNextManeuverDescriptorGet::u16GetFunctionID() const {return RGFI_C_U16_NEXTMANEUVERDESCRIPTOR;}
tU8 rgfi_tclMsgNextManeuverDescriptorGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgNextManeuverDescriptorGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgNextManeuverDescriptorGet::operator==(const rgfi_tclMsgNextManeuverDescriptorGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgNextManeuverDescriptorGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgNextManeuverDescriptorGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgNextManeuverDescriptorStatus::rgfi_tclMsgNextManeuverDescriptorStatus(const rgfi_tclMsgNextManeuverDescriptorStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ReleaseNumber = coRef.ReleaseNumber;
   StartPosition = coRef.StartPosition;
   ManeuverDescription = coRef.ManeuverDescription;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgNextManeuverDescriptorStatus& rgfi_tclMsgNextManeuverDescriptorStatus::operator=(const rgfi_tclMsgNextManeuverDescriptorStatus& coRef)
{
   if (this == &coRef) return *this;
   ReleaseNumber = coRef.ReleaseNumber;
   StartPosition = coRef.StartPosition;
   ManeuverDescription = coRef.ManeuverDescription;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgNextManeuverDescriptorStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgNextManeuverDescriptorStatus::u16GetFunctionID() const {return RGFI_C_U16_NEXTMANEUVERDESCRIPTOR;}
tU8 rgfi_tclMsgNextManeuverDescriptorStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rgfi_tclMsgNextManeuverDescriptorStatus::vDestroy()
{
   StartPosition.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < ManeuverDescription.size(); ++u32Idx)
         ManeuverDescription[u32Idx].vDestroy();
   }
   ManeuverDescription.clear();
}

tU32 rgfi_tclMsgNextManeuverDescriptorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16+ManeuverDescription.size()*11;
}

tBool rgfi_tclMsgNextManeuverDescriptorStatus::operator==(const rgfi_tclMsgNextManeuverDescriptorStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ReleaseNumber == rfoCmp.ReleaseNumber);
      bResult = bResult && (StartPosition == rfoCmp.StartPosition);
      bResult = bResult && (ManeuverDescription.size() == rfoCmp.ManeuverDescription.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ManeuverDescription.size()); ++u32Idx)
            bResult = bResult && (ManeuverDescription[u32Idx] == rfoCmp.ManeuverDescription[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rgfi_tclMsgNextManeuverDescriptorStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ReleaseNumber;
   oIn >> StartPosition;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ManeuverDescription.size(); ++u32Idx)
      {
         ManeuverDescription[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ManeuverDescription.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ManeuverDescription[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgNextManeuverDescriptorStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ReleaseNumber;
   oOut << StartPosition;
   oOut << (tU32)ManeuverDescription.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ManeuverDescription.size(); ++u32Idx)
         oOut << ManeuverDescription[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgNextMapManeuverDescriptorGet::rgfi_tclMsgNextMapManeuverDescriptorGet(const rgfi_tclMsgNextMapManeuverDescriptorGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgNextMapManeuverDescriptorGet& rgfi_tclMsgNextMapManeuverDescriptorGet::operator=(const rgfi_tclMsgNextMapManeuverDescriptorGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgNextMapManeuverDescriptorGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgNextMapManeuverDescriptorGet::u16GetFunctionID() const {return RGFI_C_U16_NEXTMAPMANEUVERDESCRIPTOR;}
tU8 rgfi_tclMsgNextMapManeuverDescriptorGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgNextMapManeuverDescriptorGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgNextMapManeuverDescriptorGet::operator==(const rgfi_tclMsgNextMapManeuverDescriptorGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgNextMapManeuverDescriptorGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgNextMapManeuverDescriptorGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgNextMapManeuverDescriptorStatus::rgfi_tclMsgNextMapManeuverDescriptorStatus(const rgfi_tclMsgNextMapManeuverDescriptorStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ReleaseNumber = coRef.ReleaseNumber;
   MapManeuverDescription = coRef.MapManeuverDescription;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgNextMapManeuverDescriptorStatus& rgfi_tclMsgNextMapManeuverDescriptorStatus::operator=(const rgfi_tclMsgNextMapManeuverDescriptorStatus& coRef)
{
   if (this == &coRef) return *this;
   ReleaseNumber = coRef.ReleaseNumber;
   MapManeuverDescription = coRef.MapManeuverDescription;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgNextMapManeuverDescriptorStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgNextMapManeuverDescriptorStatus::u16GetFunctionID() const {return RGFI_C_U16_NEXTMAPMANEUVERDESCRIPTOR;}
tU8 rgfi_tclMsgNextMapManeuverDescriptorStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rgfi_tclMsgNextMapManeuverDescriptorStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < MapManeuverDescription.size(); ++u32Idx)
         MapManeuverDescription[u32Idx].vDestroy();
   }
   MapManeuverDescription.clear();
}

tU32 rgfi_tclMsgNextMapManeuverDescriptorStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < MapManeuverDescription.size(); ++u32ListIdx)
      u32DynamicSize += MapManeuverDescription[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool rgfi_tclMsgNextMapManeuverDescriptorStatus::operator==(const rgfi_tclMsgNextMapManeuverDescriptorStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ReleaseNumber == rfoCmp.ReleaseNumber);
      bResult = bResult && (MapManeuverDescription.size() == rfoCmp.MapManeuverDescription.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MapManeuverDescription.size()); ++u32Idx)
            bResult = bResult && (MapManeuverDescription[u32Idx] == rfoCmp.MapManeuverDescription[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rgfi_tclMsgNextMapManeuverDescriptorStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ReleaseNumber;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < MapManeuverDescription.size(); ++u32Idx)
      {
         MapManeuverDescription[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      MapManeuverDescription.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> MapManeuverDescription[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgNextMapManeuverDescriptorStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ReleaseNumber;
   oOut << (tU32)MapManeuverDescription.size();
   {
      for (tU32 u32Idx = 0; u32Idx < MapManeuverDescription.size(); ++u32Idx)
         oOut << MapManeuverDescription[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSignPostAndLaneInfoGet::rgfi_tclMsgSignPostAndLaneInfoGet(const rgfi_tclMsgSignPostAndLaneInfoGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSignPostAndLaneInfoGet& rgfi_tclMsgSignPostAndLaneInfoGet::operator=(const rgfi_tclMsgSignPostAndLaneInfoGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSignPostAndLaneInfoGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSignPostAndLaneInfoGet::u16GetFunctionID() const {return RGFI_C_U16_SIGNPOSTANDLANEINFO;}
tU8 rgfi_tclMsgSignPostAndLaneInfoGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgSignPostAndLaneInfoGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgSignPostAndLaneInfoGet::operator==(const rgfi_tclMsgSignPostAndLaneInfoGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSignPostAndLaneInfoGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSignPostAndLaneInfoGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSignPostAndLaneInfoStatus::rgfi_tclMsgSignPostAndLaneInfoStatus(const rgfi_tclMsgSignPostAndLaneInfoStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   SignPostInfoList = coRef.SignPostInfoList;
   SignPostInfoStatus = coRef.SignPostInfoStatus;
   ReleaseNumber = coRef.ReleaseNumber;
   LaneInfoElement = coRef.LaneInfoElement;
   NextLaneInfoElementList = coRef.NextLaneInfoElementList;
   TrafficSense = coRef.TrafficSense;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSignPostAndLaneInfoStatus& rgfi_tclMsgSignPostAndLaneInfoStatus::operator=(const rgfi_tclMsgSignPostAndLaneInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   SignPostInfoList = coRef.SignPostInfoList;
   SignPostInfoStatus = coRef.SignPostInfoStatus;
   ReleaseNumber = coRef.ReleaseNumber;
   LaneInfoElement = coRef.LaneInfoElement;
   NextLaneInfoElementList = coRef.NextLaneInfoElementList;
   TrafficSense = coRef.TrafficSense;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSignPostAndLaneInfoStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSignPostAndLaneInfoStatus::u16GetFunctionID() const {return RGFI_C_U16_SIGNPOSTANDLANEINFO;}
tU8 rgfi_tclMsgSignPostAndLaneInfoStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rgfi_tclMsgSignPostAndLaneInfoStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SignPostInfoList.size(); ++u32Idx)
         SignPostInfoList[u32Idx].vDestroy();
   }
   SignPostInfoList.clear();
   LaneInfoElement.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < NextLaneInfoElementList.size(); ++u32Idx)
         NextLaneInfoElementList[u32Idx].vDestroy();
   }
   NextLaneInfoElementList.clear();
}

tU32 rgfi_tclMsgSignPostAndLaneInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SignPostInfoList.size(); ++u32ListIdx)
      u32DynamicSize += SignPostInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < NextLaneInfoElementList.size(); ++u32ListIdx)
      u32DynamicSize += NextLaneInfoElementList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+14+LaneInfoElement.u32GetSize(u16MajorVersion);
}

tBool rgfi_tclMsgSignPostAndLaneInfoStatus::operator==(const rgfi_tclMsgSignPostAndLaneInfoStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SignPostInfoList.size() == rfoCmp.SignPostInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SignPostInfoList.size()); ++u32Idx)
            bResult = bResult && (SignPostInfoList[u32Idx] == rfoCmp.SignPostInfoList[u32Idx]);
      }
      bResult = bResult && (SignPostInfoStatus == rfoCmp.SignPostInfoStatus);
      bResult = bResult && (ReleaseNumber == rfoCmp.ReleaseNumber);
      bResult = bResult && (LaneInfoElement == rfoCmp.LaneInfoElement);
      bResult = bResult && (NextLaneInfoElementList.size() == rfoCmp.NextLaneInfoElementList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < NextLaneInfoElementList.size()); ++u32Idx)
            bResult = bResult && (NextLaneInfoElementList[u32Idx] == rfoCmp.NextLaneInfoElementList[u32Idx]);
      }
      bResult = bResult && (TrafficSense == rfoCmp.TrafficSense);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSignPostAndLaneInfoStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SignPostInfoList.size(); ++u32Idx)
      {
         SignPostInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SignPostInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SignPostInfoList[u32Idx];
      }
   }
   oIn >> SignPostInfoStatus;
   oIn >> ReleaseNumber;
   oIn >> LaneInfoElement;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < NextLaneInfoElementList.size(); ++u32Idx)
      {
         NextLaneInfoElementList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      NextLaneInfoElementList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> NextLaneInfoElementList[u32Idx];
      }
   }
   oIn >> TrafficSense;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSignPostAndLaneInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)SignPostInfoList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SignPostInfoList.size(); ++u32Idx)
         oOut << SignPostInfoList[u32Idx];
   }
   oOut << SignPostInfoStatus;
   oOut << ReleaseNumber;
   oOut << LaneInfoElement;
   oOut << (tU32)NextLaneInfoElementList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < NextLaneInfoElementList.size(); ++u32Idx)
         oOut << NextLaneInfoElementList[u32Idx];
   }
   oOut << TrafficSense;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgNextWarningPointDeltaGet::rgfi_tclMsgNextWarningPointDeltaGet(const rgfi_tclMsgNextWarningPointDeltaGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgNextWarningPointDeltaGet& rgfi_tclMsgNextWarningPointDeltaGet::operator=(const rgfi_tclMsgNextWarningPointDeltaGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgNextWarningPointDeltaGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgNextWarningPointDeltaGet::u16GetFunctionID() const {return RGFI_C_U16_NEXTWARNINGPOINTDELTA;}
tU8 rgfi_tclMsgNextWarningPointDeltaGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgNextWarningPointDeltaGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgNextWarningPointDeltaGet::operator==(const rgfi_tclMsgNextWarningPointDeltaGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgNextWarningPointDeltaGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgNextWarningPointDeltaGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgNextWarningPointDeltaStatus::rgfi_tclMsgNextWarningPointDeltaStatus(const rgfi_tclMsgNextWarningPointDeltaStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ReleaseId = coRef.ReleaseId;
   DeltaDistanceFromFirstOutput = coRef.DeltaDistanceFromFirstOutput;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgNextWarningPointDeltaStatus& rgfi_tclMsgNextWarningPointDeltaStatus::operator=(const rgfi_tclMsgNextWarningPointDeltaStatus& coRef)
{
   if (this == &coRef) return *this;
   ReleaseId = coRef.ReleaseId;
   DeltaDistanceFromFirstOutput = coRef.DeltaDistanceFromFirstOutput;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgNextWarningPointDeltaStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgNextWarningPointDeltaStatus::u16GetFunctionID() const {return RGFI_C_U16_NEXTWARNINGPOINTDELTA;}
tU8 rgfi_tclMsgNextWarningPointDeltaStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 rgfi_tclMsgNextWarningPointDeltaStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool rgfi_tclMsgNextWarningPointDeltaStatus::operator==(const rgfi_tclMsgNextWarningPointDeltaStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ReleaseId == rfoCmp.ReleaseId);
      bResult = bResult && (DeltaDistanceFromFirstOutput == rfoCmp.DeltaDistanceFromFirstOutput);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgNextWarningPointDeltaStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ReleaseId;
   oIn >> DeltaDistanceFromFirstOutput;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgNextWarningPointDeltaStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ReleaseId;
   oOut << DeltaDistanceFromFirstOutput;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgNextWarningPointGet::rgfi_tclMsgNextWarningPointGet(const rgfi_tclMsgNextWarningPointGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgNextWarningPointGet& rgfi_tclMsgNextWarningPointGet::operator=(const rgfi_tclMsgNextWarningPointGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgNextWarningPointGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgNextWarningPointGet::u16GetFunctionID() const {return RGFI_C_U16_NEXTWARNINGPOINT;}
tU8 rgfi_tclMsgNextWarningPointGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgNextWarningPointGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgNextWarningPointGet::operator==(const rgfi_tclMsgNextWarningPointGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgNextWarningPointGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgNextWarningPointGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgNextWarningPointStatus::rgfi_tclMsgNextWarningPointStatus(const rgfi_tclMsgNextWarningPointStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ReleaseId = coRef.ReleaseId;
   NextWarningPoint = coRef.NextWarningPoint;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgNextWarningPointStatus& rgfi_tclMsgNextWarningPointStatus::operator=(const rgfi_tclMsgNextWarningPointStatus& coRef)
{
   if (this == &coRef) return *this;
   ReleaseId = coRef.ReleaseId;
   NextWarningPoint = coRef.NextWarningPoint;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgNextWarningPointStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgNextWarningPointStatus::u16GetFunctionID() const {return RGFI_C_U16_NEXTWARNINGPOINT;}
tU8 rgfi_tclMsgNextWarningPointStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rgfi_tclMsgNextWarningPointStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < NextWarningPoint.size(); ++u32Idx)
         NextWarningPoint[u32Idx].vDestroy();
   }
   NextWarningPoint.clear();
}

tU32 rgfi_tclMsgNextWarningPointStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < NextWarningPoint.size(); ++u32ListIdx)
      u32DynamicSize += NextWarningPoint[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool rgfi_tclMsgNextWarningPointStatus::operator==(const rgfi_tclMsgNextWarningPointStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ReleaseId == rfoCmp.ReleaseId);
      bResult = bResult && (NextWarningPoint.size() == rfoCmp.NextWarningPoint.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < NextWarningPoint.size()); ++u32Idx)
            bResult = bResult && (NextWarningPoint[u32Idx] == rfoCmp.NextWarningPoint[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rgfi_tclMsgNextWarningPointStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ReleaseId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < NextWarningPoint.size(); ++u32Idx)
      {
         NextWarningPoint[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      NextWarningPoint.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> NextWarningPoint[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgNextWarningPointStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ReleaseId;
   oOut << (tU32)NextWarningPoint.size();
   {
      for (tU32 u32Idx = 0; u32Idx < NextWarningPoint.size(); ++u32Idx)
         oOut << NextWarningPoint[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgHorizonDeltaDistanceGet::rgfi_tclMsgHorizonDeltaDistanceGet(const rgfi_tclMsgHorizonDeltaDistanceGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgHorizonDeltaDistanceGet& rgfi_tclMsgHorizonDeltaDistanceGet::operator=(const rgfi_tclMsgHorizonDeltaDistanceGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgHorizonDeltaDistanceGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgHorizonDeltaDistanceGet::u16GetFunctionID() const {return RGFI_C_U16_HORIZONDELTADISTANCE;}
tU8 rgfi_tclMsgHorizonDeltaDistanceGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgHorizonDeltaDistanceGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgHorizonDeltaDistanceGet::operator==(const rgfi_tclMsgHorizonDeltaDistanceGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgHorizonDeltaDistanceGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgHorizonDeltaDistanceGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgHorizonDeltaDistanceStatus::rgfi_tclMsgHorizonDeltaDistanceStatus(const rgfi_tclMsgHorizonDeltaDistanceStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ReleaseId = coRef.ReleaseId;
   DeltaDistance = coRef.DeltaDistance;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgHorizonDeltaDistanceStatus& rgfi_tclMsgHorizonDeltaDistanceStatus::operator=(const rgfi_tclMsgHorizonDeltaDistanceStatus& coRef)
{
   if (this == &coRef) return *this;
   ReleaseId = coRef.ReleaseId;
   DeltaDistance = coRef.DeltaDistance;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgHorizonDeltaDistanceStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgHorizonDeltaDistanceStatus::u16GetFunctionID() const {return RGFI_C_U16_HORIZONDELTADISTANCE;}
tU8 rgfi_tclMsgHorizonDeltaDistanceStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 rgfi_tclMsgHorizonDeltaDistanceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool rgfi_tclMsgHorizonDeltaDistanceStatus::operator==(const rgfi_tclMsgHorizonDeltaDistanceStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ReleaseId == rfoCmp.ReleaseId);
      bResult = bResult && (DeltaDistance == rfoCmp.DeltaDistance);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgHorizonDeltaDistanceStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ReleaseId;
   oIn >> DeltaDistance;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgHorizonDeltaDistanceStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ReleaseId;
   oOut << DeltaDistance;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgHorizonEventsGet::rgfi_tclMsgHorizonEventsGet(const rgfi_tclMsgHorizonEventsGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgHorizonEventsGet& rgfi_tclMsgHorizonEventsGet::operator=(const rgfi_tclMsgHorizonEventsGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgHorizonEventsGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgHorizonEventsGet::u16GetFunctionID() const {return RGFI_C_U16_HORIZONEVENTS;}
tU8 rgfi_tclMsgHorizonEventsGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgHorizonEventsGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgHorizonEventsGet::operator==(const rgfi_tclMsgHorizonEventsGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgHorizonEventsGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgHorizonEventsGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgHorizonEventsStatus::rgfi_tclMsgHorizonEventsStatus(const rgfi_tclMsgHorizonEventsStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ReleaseId = coRef.ReleaseId;
   HorizonEventList = coRef.HorizonEventList;
   ProgramServiceList = coRef.ProgramServiceList;
   ServiceProviderList = coRef.ServiceProviderList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgHorizonEventsStatus& rgfi_tclMsgHorizonEventsStatus::operator=(const rgfi_tclMsgHorizonEventsStatus& coRef)
{
   if (this == &coRef) return *this;
   ReleaseId = coRef.ReleaseId;
   HorizonEventList = coRef.HorizonEventList;
   ProgramServiceList = coRef.ProgramServiceList;
   ServiceProviderList = coRef.ServiceProviderList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgHorizonEventsStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgHorizonEventsStatus::u16GetFunctionID() const {return RGFI_C_U16_HORIZONEVENTS;}
tU8 rgfi_tclMsgHorizonEventsStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rgfi_tclMsgHorizonEventsStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < HorizonEventList.size(); ++u32Idx)
         HorizonEventList[u32Idx].vDestroy();
   }
   HorizonEventList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < ProgramServiceList.size(); ++u32Idx)
         ProgramServiceList[u32Idx].vDestroy();
   }
   ProgramServiceList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < ServiceProviderList.size(); ++u32Idx)
         ServiceProviderList[u32Idx].vDestroy();
   }
   ServiceProviderList.clear();
}

tU32 rgfi_tclMsgHorizonEventsStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < HorizonEventList.size(); ++u32ListIdx)
      u32DynamicSize += HorizonEventList[u32ListIdx].u32GetSize(u16MajorVersion);
   if (15 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      for (u32ListIdx = 0; u32ListIdx < ProgramServiceList.size(); ++u32ListIdx)
         u32DynamicSize += ProgramServiceList[u32ListIdx].u32GetSize(u16MajorVersion);
   }
   if (15 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      for (u32ListIdx = 0; u32ListIdx < ServiceProviderList.size(); ++u32ListIdx)
         u32DynamicSize += ServiceProviderList[u32ListIdx].u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+8;
}

tBool rgfi_tclMsgHorizonEventsStatus::operator==(const rgfi_tclMsgHorizonEventsStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ReleaseId == rfoCmp.ReleaseId);
      bResult = bResult && (HorizonEventList.size() == rfoCmp.HorizonEventList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < HorizonEventList.size()); ++u32Idx)
            bResult = bResult && (HorizonEventList[u32Idx] == rfoCmp.HorizonEventList[u32Idx]);
      }
      bResult = bResult && (ProgramServiceList.size() == rfoCmp.ProgramServiceList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ProgramServiceList.size()); ++u32Idx)
            bResult = bResult && (ProgramServiceList[u32Idx] == rfoCmp.ProgramServiceList[u32Idx]);
      }
      bResult = bResult && (ServiceProviderList.size() == rfoCmp.ServiceProviderList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ServiceProviderList.size()); ++u32Idx)
            bResult = bResult && (ServiceProviderList[u32Idx] == rfoCmp.ServiceProviderList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rgfi_tclMsgHorizonEventsStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ReleaseId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < HorizonEventList.size(); ++u32Idx)
      {
         HorizonEventList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      HorizonEventList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> HorizonEventList[u32Idx];
      }
   }
   if (15 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < ProgramServiceList.size(); ++u32Idx)
         {
            ProgramServiceList[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         ProgramServiceList.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> ProgramServiceList[u32Idx];
         }
      }
   }
   if (15 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < ServiceProviderList.size(); ++u32Idx)
         {
            ServiceProviderList[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         ServiceProviderList.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> ServiceProviderList[u32Idx];
         }
      }
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgHorizonEventsStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ReleaseId;
   oOut << (tU32)HorizonEventList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < HorizonEventList.size(); ++u32Idx)
         oOut << HorizonEventList[u32Idx];
   }
   if (15 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)ProgramServiceList.size();
      {
         for (tU32 u32Idx = 0; u32Idx < ProgramServiceList.size(); ++u32Idx)
            oOut << ProgramServiceList[u32Idx];
      }
   }
   if (15 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)ServiceProviderList.size();
      {
         for (tU32 u32Idx = 0; u32Idx < ServiceProviderList.size(); ++u32Idx)
            oOut << ServiceProviderList[u32Idx];
      }
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgWarningsOnHorizonModeGet::rgfi_tclMsgWarningsOnHorizonModeGet(const rgfi_tclMsgWarningsOnHorizonModeGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgWarningsOnHorizonModeGet& rgfi_tclMsgWarningsOnHorizonModeGet::operator=(const rgfi_tclMsgWarningsOnHorizonModeGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgWarningsOnHorizonModeGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgWarningsOnHorizonModeGet::u16GetFunctionID() const {return RGFI_C_U16_WARNINGSONHORIZONMODE;}
tU8 rgfi_tclMsgWarningsOnHorizonModeGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgWarningsOnHorizonModeGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgWarningsOnHorizonModeGet::operator==(const rgfi_tclMsgWarningsOnHorizonModeGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgWarningsOnHorizonModeGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgWarningsOnHorizonModeGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgWarningsOnHorizonModeStatus::rgfi_tclMsgWarningsOnHorizonModeStatus(const rgfi_tclMsgWarningsOnHorizonModeStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   WarningsOnHorizonMode = coRef.WarningsOnHorizonMode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgWarningsOnHorizonModeStatus& rgfi_tclMsgWarningsOnHorizonModeStatus::operator=(const rgfi_tclMsgWarningsOnHorizonModeStatus& coRef)
{
   if (this == &coRef) return *this;
   WarningsOnHorizonMode = coRef.WarningsOnHorizonMode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgWarningsOnHorizonModeStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgWarningsOnHorizonModeStatus::u16GetFunctionID() const {return RGFI_C_U16_WARNINGSONHORIZONMODE;}
tU8 rgfi_tclMsgWarningsOnHorizonModeStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 rgfi_tclMsgWarningsOnHorizonModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool rgfi_tclMsgWarningsOnHorizonModeStatus::operator==(const rgfi_tclMsgWarningsOnHorizonModeStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (WarningsOnHorizonMode == rfoCmp.WarningsOnHorizonMode);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgWarningsOnHorizonModeStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> WarningsOnHorizonMode;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgWarningsOnHorizonModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << WarningsOnHorizonMode;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDriverSpeedAdviceGet::rgfi_tclMsgDriverSpeedAdviceGet(const rgfi_tclMsgDriverSpeedAdviceGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDriverSpeedAdviceGet& rgfi_tclMsgDriverSpeedAdviceGet::operator=(const rgfi_tclMsgDriverSpeedAdviceGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgDriverSpeedAdviceGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgDriverSpeedAdviceGet::u16GetFunctionID() const {return RGFI_C_U16_DRIVERSPEEDADVICE;}
tU8 rgfi_tclMsgDriverSpeedAdviceGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgDriverSpeedAdviceGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgDriverSpeedAdviceGet::operator==(const rgfi_tclMsgDriverSpeedAdviceGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgDriverSpeedAdviceGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgDriverSpeedAdviceGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDriverSpeedAdviceUpReg::rgfi_tclMsgDriverSpeedAdviceUpReg(const rgfi_tclMsgDriverSpeedAdviceUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDriverSpeedAdviceUpReg& rgfi_tclMsgDriverSpeedAdviceUpReg::operator=(const rgfi_tclMsgDriverSpeedAdviceUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgDriverSpeedAdviceUpReg::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgDriverSpeedAdviceUpReg::u16GetFunctionID() const {return RGFI_C_U16_DRIVERSPEEDADVICE;}
tU8 rgfi_tclMsgDriverSpeedAdviceUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 rgfi_tclMsgDriverSpeedAdviceUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgDriverSpeedAdviceUpReg::operator==(const rgfi_tclMsgDriverSpeedAdviceUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgDriverSpeedAdviceUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgDriverSpeedAdviceUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDriverSpeedAdviceRelUpReg::rgfi_tclMsgDriverSpeedAdviceRelUpReg(const rgfi_tclMsgDriverSpeedAdviceRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDriverSpeedAdviceRelUpReg& rgfi_tclMsgDriverSpeedAdviceRelUpReg::operator=(const rgfi_tclMsgDriverSpeedAdviceRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgDriverSpeedAdviceRelUpReg::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgDriverSpeedAdviceRelUpReg::u16GetFunctionID() const {return RGFI_C_U16_DRIVERSPEEDADVICE;}
tU8 rgfi_tclMsgDriverSpeedAdviceRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 rgfi_tclMsgDriverSpeedAdviceRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgDriverSpeedAdviceRelUpReg::operator==(const rgfi_tclMsgDriverSpeedAdviceRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgDriverSpeedAdviceRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgDriverSpeedAdviceRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDriverSpeedAdviceStatus::rgfi_tclMsgDriverSpeedAdviceStatus(const rgfi_tclMsgDriverSpeedAdviceStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   AdviceType = coRef.AdviceType;
   DriverActionFeedback = coRef.DriverActionFeedback;
   EcoProfit = coRef.EcoProfit;
   TargetSpeed = coRef.TargetSpeed;
   CausingEvent = coRef.CausingEvent;
   EventId = coRef.EventId;
   DistanceToStartOfEvent = coRef.DistanceToStartOfEvent;
   DistanceToEndOfEvent = coRef.DistanceToEndOfEvent;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDriverSpeedAdviceStatus& rgfi_tclMsgDriverSpeedAdviceStatus::operator=(const rgfi_tclMsgDriverSpeedAdviceStatus& coRef)
{
   if (this == &coRef) return *this;
   AdviceType = coRef.AdviceType;
   DriverActionFeedback = coRef.DriverActionFeedback;
   EcoProfit = coRef.EcoProfit;
   TargetSpeed = coRef.TargetSpeed;
   CausingEvent = coRef.CausingEvent;
   EventId = coRef.EventId;
   DistanceToStartOfEvent = coRef.DistanceToStartOfEvent;
   DistanceToEndOfEvent = coRef.DistanceToEndOfEvent;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgDriverSpeedAdviceStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgDriverSpeedAdviceStatus::u16GetFunctionID() const {return RGFI_C_U16_DRIVERSPEEDADVICE;}
tU8 rgfi_tclMsgDriverSpeedAdviceStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rgfi_tclMsgDriverSpeedAdviceStatus::vDestroy()
{
   CausingEvent.vDestroy(); 
   EventId.vDestroy(); 
}

tU32 rgfi_tclMsgDriverSpeedAdviceStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 18+CausingEvent.u32GetSize(u16MajorVersion);
}

tBool rgfi_tclMsgDriverSpeedAdviceStatus::operator==(const rgfi_tclMsgDriverSpeedAdviceStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AdviceType == rfoCmp.AdviceType);
      bResult = bResult && (DriverActionFeedback == rfoCmp.DriverActionFeedback);
      bResult = bResult && (EcoProfit == rfoCmp.EcoProfit);
      bResult = bResult && (TargetSpeed == rfoCmp.TargetSpeed);
      bResult = bResult && (CausingEvent == rfoCmp.CausingEvent);
      bResult = bResult && (EventId == rfoCmp.EventId);
      bResult = bResult && (DistanceToStartOfEvent == rfoCmp.DistanceToStartOfEvent);
      bResult = bResult && (DistanceToEndOfEvent == rfoCmp.DistanceToEndOfEvent);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgDriverSpeedAdviceStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> AdviceType;
   oIn >> DriverActionFeedback;
   oIn >> EcoProfit;
   oIn >> TargetSpeed;
   oIn >> CausingEvent;
   oIn >> EventId;
   oIn >> DistanceToStartOfEvent;
   oIn >> DistanceToEndOfEvent;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgDriverSpeedAdviceStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << AdviceType;
   oOut << DriverActionFeedback;
   oOut << EcoProfit;
   oOut << TargetSpeed;
   oOut << CausingEvent;
   oOut << EventId;
   oOut << DistanceToStartOfEvent;
   oOut << DistanceToEndOfEvent;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgMultiMediaInformationGet::rgfi_tclMsgMultiMediaInformationGet(const rgfi_tclMsgMultiMediaInformationGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgMultiMediaInformationGet& rgfi_tclMsgMultiMediaInformationGet::operator=(const rgfi_tclMsgMultiMediaInformationGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgMultiMediaInformationGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgMultiMediaInformationGet::u16GetFunctionID() const {return RGFI_C_U16_MULTIMEDIAINFORMATION;}
tU8 rgfi_tclMsgMultiMediaInformationGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgMultiMediaInformationGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgMultiMediaInformationGet::operator==(const rgfi_tclMsgMultiMediaInformationGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgMultiMediaInformationGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgMultiMediaInformationGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgMultiMediaInformationStatus::rgfi_tclMsgMultiMediaInformationStatus(const rgfi_tclMsgMultiMediaInformationStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ReleaseNumber = coRef.ReleaseNumber;
   MultiMediaElementList = coRef.MultiMediaElementList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgMultiMediaInformationStatus& rgfi_tclMsgMultiMediaInformationStatus::operator=(const rgfi_tclMsgMultiMediaInformationStatus& coRef)
{
   if (this == &coRef) return *this;
   ReleaseNumber = coRef.ReleaseNumber;
   MultiMediaElementList = coRef.MultiMediaElementList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgMultiMediaInformationStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgMultiMediaInformationStatus::u16GetFunctionID() const {return RGFI_C_U16_MULTIMEDIAINFORMATION;}
tU8 rgfi_tclMsgMultiMediaInformationStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rgfi_tclMsgMultiMediaInformationStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < MultiMediaElementList.size(); ++u32Idx)
         MultiMediaElementList[u32Idx].vDestroy();
   }
   MultiMediaElementList.clear();
}

tU32 rgfi_tclMsgMultiMediaInformationStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < MultiMediaElementList.size(); ++u32ListIdx)
      u32DynamicSize += MultiMediaElementList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool rgfi_tclMsgMultiMediaInformationStatus::operator==(const rgfi_tclMsgMultiMediaInformationStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ReleaseNumber == rfoCmp.ReleaseNumber);
      bResult = bResult && (MultiMediaElementList.size() == rfoCmp.MultiMediaElementList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MultiMediaElementList.size()); ++u32Idx)
            bResult = bResult && (MultiMediaElementList[u32Idx] == rfoCmp.MultiMediaElementList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rgfi_tclMsgMultiMediaInformationStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ReleaseNumber;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < MultiMediaElementList.size(); ++u32Idx)
      {
         MultiMediaElementList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      MultiMediaElementList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> MultiMediaElementList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgMultiMediaInformationStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ReleaseNumber;
   oOut << (tU32)MultiMediaElementList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < MultiMediaElementList.size(); ++u32Idx)
         oOut << MultiMediaElementList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgFunctionalityStatesGet::rgfi_tclMsgFunctionalityStatesGet(const rgfi_tclMsgFunctionalityStatesGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgFunctionalityStatesGet& rgfi_tclMsgFunctionalityStatesGet::operator=(const rgfi_tclMsgFunctionalityStatesGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgFunctionalityStatesGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgFunctionalityStatesGet::u16GetFunctionID() const {return RGFI_C_U16_FUNCTIONALITYSTATES;}
tU8 rgfi_tclMsgFunctionalityStatesGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgFunctionalityStatesGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgFunctionalityStatesGet::operator==(const rgfi_tclMsgFunctionalityStatesGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgFunctionalityStatesGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgFunctionalityStatesGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgFunctionalityStatesSet::rgfi_tclMsgFunctionalityStatesSet(const rgfi_tclMsgFunctionalityStatesSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   RouteInfoAcoustic = coRef.RouteInfoAcoustic;
   RouteInfoSymbolic = coRef.RouteInfoSymbolic;
   DestinationInfoAcoustic = coRef.DestinationInfoAcoustic;
   DestinationInfoSymbolic = coRef.DestinationInfoSymbolic;
   DrivingRecommendationAcoustic = coRef.DrivingRecommendationAcoustic;
   DrivingRecommendationSymbolic = coRef.DrivingRecommendationSymbolic;
   CorridorInfoAcoustic = coRef.CorridorInfoAcoustic;
   CorridorInfoSymbolic = coRef.CorridorInfoSymbolic;
   HorizonInfoTrafficMessageAcoustic = coRef.HorizonInfoTrafficMessageAcoustic;
   HorizonInfoTrafficMessageSymbolic = coRef.HorizonInfoTrafficMessageSymbolic;
   HorizonInfoSpeedLimitAcoustic = coRef.HorizonInfoSpeedLimitAcoustic;
   HorizonInfoSpeedLimitSymbolic = coRef.HorizonInfoSpeedLimitSymbolic;
   HorizonInfoWarningSignAcoustic = coRef.HorizonInfoWarningSignAcoustic;
   HorizonInfoWarningSignSymbolic = coRef.HorizonInfoWarningSignSymbolic;
   HorizonInfoPOIAcoustic = coRef.HorizonInfoPOIAcoustic;
   HorizonInfoPOISymbolic = coRef.HorizonInfoPOISymbolic;
   HorizonInfoRoadAttributeAcoustic = coRef.HorizonInfoRoadAttributeAcoustic;
   HorizonInfoRoadAttributeSymbolic = coRef.HorizonInfoRoadAttributeSymbolic;
   HorizonInfoCurveAcoustic = coRef.HorizonInfoCurveAcoustic;
   HorizonInfoCurveSymbolic = coRef.HorizonInfoCurveSymbolic;
   HorizonInfoUPOI = coRef.HorizonInfoUPOI;
   DriverSpeedAdvice = coRef.DriverSpeedAdvice;
   HorizonEvents = coRef.HorizonEvents;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgFunctionalityStatesSet& rgfi_tclMsgFunctionalityStatesSet::operator=(const rgfi_tclMsgFunctionalityStatesSet& coRef)
{
   if (this == &coRef) return *this;
   RouteInfoAcoustic = coRef.RouteInfoAcoustic;
   RouteInfoSymbolic = coRef.RouteInfoSymbolic;
   DestinationInfoAcoustic = coRef.DestinationInfoAcoustic;
   DestinationInfoSymbolic = coRef.DestinationInfoSymbolic;
   DrivingRecommendationAcoustic = coRef.DrivingRecommendationAcoustic;
   DrivingRecommendationSymbolic = coRef.DrivingRecommendationSymbolic;
   CorridorInfoAcoustic = coRef.CorridorInfoAcoustic;
   CorridorInfoSymbolic = coRef.CorridorInfoSymbolic;
   HorizonInfoTrafficMessageAcoustic = coRef.HorizonInfoTrafficMessageAcoustic;
   HorizonInfoTrafficMessageSymbolic = coRef.HorizonInfoTrafficMessageSymbolic;
   HorizonInfoSpeedLimitAcoustic = coRef.HorizonInfoSpeedLimitAcoustic;
   HorizonInfoSpeedLimitSymbolic = coRef.HorizonInfoSpeedLimitSymbolic;
   HorizonInfoWarningSignAcoustic = coRef.HorizonInfoWarningSignAcoustic;
   HorizonInfoWarningSignSymbolic = coRef.HorizonInfoWarningSignSymbolic;
   HorizonInfoPOIAcoustic = coRef.HorizonInfoPOIAcoustic;
   HorizonInfoPOISymbolic = coRef.HorizonInfoPOISymbolic;
   HorizonInfoRoadAttributeAcoustic = coRef.HorizonInfoRoadAttributeAcoustic;
   HorizonInfoRoadAttributeSymbolic = coRef.HorizonInfoRoadAttributeSymbolic;
   HorizonInfoCurveAcoustic = coRef.HorizonInfoCurveAcoustic;
   HorizonInfoCurveSymbolic = coRef.HorizonInfoCurveSymbolic;
   HorizonInfoUPOI = coRef.HorizonInfoUPOI;
   DriverSpeedAdvice = coRef.DriverSpeedAdvice;
   HorizonEvents = coRef.HorizonEvents;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgFunctionalityStatesSet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgFunctionalityStatesSet::u16GetFunctionID() const {return RGFI_C_U16_FUNCTIONALITYSTATES;}
tU8 rgfi_tclMsgFunctionalityStatesSet::u8GetOpCode() const {return CCA_C_U8_OPCODE_SET;}

tVoid rgfi_tclMsgFunctionalityStatesSet::vDestroy()
{
   HorizonInfoUPOI.vDestroy(); 
   DriverSpeedAdvice.vDestroy(); 
   HorizonEvents.vDestroy(); 
}

tU32 rgfi_tclMsgFunctionalityStatesSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 16)
   {
      u32DynamicSize += 2;
   }
   if (u16MajorVersion <= 16)
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((13 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((13 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((15 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += HorizonInfoUPOI.u32GetSize(u16MajorVersion);
   }
   if (17 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (17 <= u16MajorVersion)
   {
      u32DynamicSize += HorizonEvents.u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+12;
}

tBool rgfi_tclMsgFunctionalityStatesSet::operator==(const rgfi_tclMsgFunctionalityStatesSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RouteInfoAcoustic == rfoCmp.RouteInfoAcoustic);
      bResult = bResult && (RouteInfoSymbolic == rfoCmp.RouteInfoSymbolic);
      bResult = bResult && (DestinationInfoAcoustic == rfoCmp.DestinationInfoAcoustic);
      bResult = bResult && (DestinationInfoSymbolic == rfoCmp.DestinationInfoSymbolic);
      bResult = bResult && (DrivingRecommendationAcoustic == rfoCmp.DrivingRecommendationAcoustic);
      bResult = bResult && (DrivingRecommendationSymbolic == rfoCmp.DrivingRecommendationSymbolic);
      bResult = bResult && (CorridorInfoAcoustic == rfoCmp.CorridorInfoAcoustic);
      bResult = bResult && (CorridorInfoSymbolic == rfoCmp.CorridorInfoSymbolic);
      bResult = bResult && (HorizonInfoTrafficMessageAcoustic == rfoCmp.HorizonInfoTrafficMessageAcoustic);
      bResult = bResult && (HorizonInfoTrafficMessageSymbolic == rfoCmp.HorizonInfoTrafficMessageSymbolic);
      bResult = bResult && (HorizonInfoSpeedLimitAcoustic == rfoCmp.HorizonInfoSpeedLimitAcoustic);
      bResult = bResult && (HorizonInfoSpeedLimitSymbolic == rfoCmp.HorizonInfoSpeedLimitSymbolic);
      bResult = bResult && (HorizonInfoWarningSignAcoustic == rfoCmp.HorizonInfoWarningSignAcoustic);
      bResult = bResult && (HorizonInfoWarningSignSymbolic == rfoCmp.HorizonInfoWarningSignSymbolic);
      bResult = bResult && (HorizonInfoPOIAcoustic == rfoCmp.HorizonInfoPOIAcoustic);
      bResult = bResult && (HorizonInfoPOISymbolic == rfoCmp.HorizonInfoPOISymbolic);
      bResult = bResult && (HorizonInfoRoadAttributeAcoustic == rfoCmp.HorizonInfoRoadAttributeAcoustic);
      bResult = bResult && (HorizonInfoRoadAttributeSymbolic == rfoCmp.HorizonInfoRoadAttributeSymbolic);
      bResult = bResult && (HorizonInfoCurveAcoustic == rfoCmp.HorizonInfoCurveAcoustic);
      bResult = bResult && (HorizonInfoCurveSymbolic == rfoCmp.HorizonInfoCurveSymbolic);
      bResult = bResult && (HorizonInfoUPOI == rfoCmp.HorizonInfoUPOI);
      bResult = bResult && (DriverSpeedAdvice == rfoCmp.DriverSpeedAdvice);
      bResult = bResult && (HorizonEvents == rfoCmp.HorizonEvents);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgFunctionalityStatesSet::oRead(fi_tclInContext& oIn)
{
   oIn >> RouteInfoAcoustic;
   oIn >> RouteInfoSymbolic;
   oIn >> DestinationInfoAcoustic;
   oIn >> DestinationInfoSymbolic;
   oIn >> DrivingRecommendationAcoustic;
   oIn >> DrivingRecommendationSymbolic;
   if (oIn.u16GetMajorVersion() <= 16)
   {
      oIn >> CorridorInfoAcoustic;
   }
   if (oIn.u16GetMajorVersion() <= 16)
   {
      oIn >> CorridorInfoSymbolic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoTrafficMessageAcoustic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoTrafficMessageSymbolic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoSpeedLimitAcoustic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoSpeedLimitSymbolic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoWarningSignAcoustic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoWarningSignSymbolic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoPOIAcoustic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoPOISymbolic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoRoadAttributeAcoustic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoRoadAttributeSymbolic;
   }
   if ((13 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoCurveAcoustic;
   }
   if ((13 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoCurveSymbolic;
   }
   if ((15 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoUPOI;
   }
   if (17 <= oIn.u16GetMajorVersion())
   {
      oIn >> DriverSpeedAdvice;
   }
   if (17 <= oIn.u16GetMajorVersion())
   {
      oIn >> HorizonEvents;
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgFunctionalityStatesSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RouteInfoAcoustic;
   oOut << RouteInfoSymbolic;
   oOut << DestinationInfoAcoustic;
   oOut << DestinationInfoSymbolic;
   oOut << DrivingRecommendationAcoustic;
   oOut << DrivingRecommendationSymbolic;
   if (oOut.u16GetMajorVersion() <= 16)
   {
      oOut << CorridorInfoAcoustic;
   }
   if (oOut.u16GetMajorVersion() <= 16)
   {
      oOut << CorridorInfoSymbolic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoTrafficMessageAcoustic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoTrafficMessageSymbolic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoSpeedLimitAcoustic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoSpeedLimitSymbolic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoWarningSignAcoustic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoWarningSignSymbolic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoPOIAcoustic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoPOISymbolic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoRoadAttributeAcoustic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoRoadAttributeSymbolic;
   }
   if ((13 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoCurveAcoustic;
   }
   if ((13 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoCurveSymbolic;
   }
   if ((15 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoUPOI;
   }
   if (17 <= oOut.u16GetMajorVersion())
   {
      oOut << DriverSpeedAdvice;
   }
   if (17 <= oOut.u16GetMajorVersion())
   {
      oOut << HorizonEvents;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgFunctionalityStatesStatus::rgfi_tclMsgFunctionalityStatesStatus(const rgfi_tclMsgFunctionalityStatesStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   RouteInfoAcoustic = coRef.RouteInfoAcoustic;
   RouteInfoSymbolic = coRef.RouteInfoSymbolic;
   DestinationInfoAcoustic = coRef.DestinationInfoAcoustic;
   DestinationInfoSymbolic = coRef.DestinationInfoSymbolic;
   DrivingRecommendationAcoustic = coRef.DrivingRecommendationAcoustic;
   DrivingRecommendationSymbolic = coRef.DrivingRecommendationSymbolic;
   CorridorInfoAcoustic = coRef.CorridorInfoAcoustic;
   CorridorInfoSymbolic = coRef.CorridorInfoSymbolic;
   HorizonInfoTrafficMessageAcoustic = coRef.HorizonInfoTrafficMessageAcoustic;
   HorizonInfoTrafficMessageSymbolic = coRef.HorizonInfoTrafficMessageSymbolic;
   HorizonInfoSpeedLimitAcoustic = coRef.HorizonInfoSpeedLimitAcoustic;
   HorizonInfoSpeedLimitSymbolic = coRef.HorizonInfoSpeedLimitSymbolic;
   HorizonInfoWarningSignAcoustic = coRef.HorizonInfoWarningSignAcoustic;
   HorizonInfoWarningSignSymbolic = coRef.HorizonInfoWarningSignSymbolic;
   HorizonInfoPOIAcoustic = coRef.HorizonInfoPOIAcoustic;
   HorizonInfoPOISymbolic = coRef.HorizonInfoPOISymbolic;
   HorizonInfoRoadAttributeAcoustic = coRef.HorizonInfoRoadAttributeAcoustic;
   HorizonInfoRoadAttributeSymbolic = coRef.HorizonInfoRoadAttributeSymbolic;
   HorizonInfoCurveAcoustic = coRef.HorizonInfoCurveAcoustic;
   HorizonInfoCurveSymbolic = coRef.HorizonInfoCurveSymbolic;
   HorizonInfoUPOI = coRef.HorizonInfoUPOI;
   DriverSpeedAdvice = coRef.DriverSpeedAdvice;
   HorizonEvents = coRef.HorizonEvents;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgFunctionalityStatesStatus& rgfi_tclMsgFunctionalityStatesStatus::operator=(const rgfi_tclMsgFunctionalityStatesStatus& coRef)
{
   if (this == &coRef) return *this;
   RouteInfoAcoustic = coRef.RouteInfoAcoustic;
   RouteInfoSymbolic = coRef.RouteInfoSymbolic;
   DestinationInfoAcoustic = coRef.DestinationInfoAcoustic;
   DestinationInfoSymbolic = coRef.DestinationInfoSymbolic;
   DrivingRecommendationAcoustic = coRef.DrivingRecommendationAcoustic;
   DrivingRecommendationSymbolic = coRef.DrivingRecommendationSymbolic;
   CorridorInfoAcoustic = coRef.CorridorInfoAcoustic;
   CorridorInfoSymbolic = coRef.CorridorInfoSymbolic;
   HorizonInfoTrafficMessageAcoustic = coRef.HorizonInfoTrafficMessageAcoustic;
   HorizonInfoTrafficMessageSymbolic = coRef.HorizonInfoTrafficMessageSymbolic;
   HorizonInfoSpeedLimitAcoustic = coRef.HorizonInfoSpeedLimitAcoustic;
   HorizonInfoSpeedLimitSymbolic = coRef.HorizonInfoSpeedLimitSymbolic;
   HorizonInfoWarningSignAcoustic = coRef.HorizonInfoWarningSignAcoustic;
   HorizonInfoWarningSignSymbolic = coRef.HorizonInfoWarningSignSymbolic;
   HorizonInfoPOIAcoustic = coRef.HorizonInfoPOIAcoustic;
   HorizonInfoPOISymbolic = coRef.HorizonInfoPOISymbolic;
   HorizonInfoRoadAttributeAcoustic = coRef.HorizonInfoRoadAttributeAcoustic;
   HorizonInfoRoadAttributeSymbolic = coRef.HorizonInfoRoadAttributeSymbolic;
   HorizonInfoCurveAcoustic = coRef.HorizonInfoCurveAcoustic;
   HorizonInfoCurveSymbolic = coRef.HorizonInfoCurveSymbolic;
   HorizonInfoUPOI = coRef.HorizonInfoUPOI;
   DriverSpeedAdvice = coRef.DriverSpeedAdvice;
   HorizonEvents = coRef.HorizonEvents;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgFunctionalityStatesStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgFunctionalityStatesStatus::u16GetFunctionID() const {return RGFI_C_U16_FUNCTIONALITYSTATES;}
tU8 rgfi_tclMsgFunctionalityStatesStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rgfi_tclMsgFunctionalityStatesStatus::vDestroy()
{
   HorizonInfoUPOI.vDestroy(); 
   DriverSpeedAdvice.vDestroy(); 
   HorizonEvents.vDestroy(); 
}

tU32 rgfi_tclMsgFunctionalityStatesStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 16)
   {
      u32DynamicSize += 2;
   }
   if (u16MajorVersion <= 16)
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((9 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((13 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((13 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += 2;
   }
   if ((15 <= u16MajorVersion) && (u16MajorVersion <= 16))
   {
      u32DynamicSize += HorizonInfoUPOI.u32GetSize(u16MajorVersion);
   }
   if (17 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (17 <= u16MajorVersion)
   {
      u32DynamicSize += HorizonEvents.u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+12;
}

tBool rgfi_tclMsgFunctionalityStatesStatus::operator==(const rgfi_tclMsgFunctionalityStatesStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RouteInfoAcoustic == rfoCmp.RouteInfoAcoustic);
      bResult = bResult && (RouteInfoSymbolic == rfoCmp.RouteInfoSymbolic);
      bResult = bResult && (DestinationInfoAcoustic == rfoCmp.DestinationInfoAcoustic);
      bResult = bResult && (DestinationInfoSymbolic == rfoCmp.DestinationInfoSymbolic);
      bResult = bResult && (DrivingRecommendationAcoustic == rfoCmp.DrivingRecommendationAcoustic);
      bResult = bResult && (DrivingRecommendationSymbolic == rfoCmp.DrivingRecommendationSymbolic);
      bResult = bResult && (CorridorInfoAcoustic == rfoCmp.CorridorInfoAcoustic);
      bResult = bResult && (CorridorInfoSymbolic == rfoCmp.CorridorInfoSymbolic);
      bResult = bResult && (HorizonInfoTrafficMessageAcoustic == rfoCmp.HorizonInfoTrafficMessageAcoustic);
      bResult = bResult && (HorizonInfoTrafficMessageSymbolic == rfoCmp.HorizonInfoTrafficMessageSymbolic);
      bResult = bResult && (HorizonInfoSpeedLimitAcoustic == rfoCmp.HorizonInfoSpeedLimitAcoustic);
      bResult = bResult && (HorizonInfoSpeedLimitSymbolic == rfoCmp.HorizonInfoSpeedLimitSymbolic);
      bResult = bResult && (HorizonInfoWarningSignAcoustic == rfoCmp.HorizonInfoWarningSignAcoustic);
      bResult = bResult && (HorizonInfoWarningSignSymbolic == rfoCmp.HorizonInfoWarningSignSymbolic);
      bResult = bResult && (HorizonInfoPOIAcoustic == rfoCmp.HorizonInfoPOIAcoustic);
      bResult = bResult && (HorizonInfoPOISymbolic == rfoCmp.HorizonInfoPOISymbolic);
      bResult = bResult && (HorizonInfoRoadAttributeAcoustic == rfoCmp.HorizonInfoRoadAttributeAcoustic);
      bResult = bResult && (HorizonInfoRoadAttributeSymbolic == rfoCmp.HorizonInfoRoadAttributeSymbolic);
      bResult = bResult && (HorizonInfoCurveAcoustic == rfoCmp.HorizonInfoCurveAcoustic);
      bResult = bResult && (HorizonInfoCurveSymbolic == rfoCmp.HorizonInfoCurveSymbolic);
      bResult = bResult && (HorizonInfoUPOI == rfoCmp.HorizonInfoUPOI);
      bResult = bResult && (DriverSpeedAdvice == rfoCmp.DriverSpeedAdvice);
      bResult = bResult && (HorizonEvents == rfoCmp.HorizonEvents);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgFunctionalityStatesStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> RouteInfoAcoustic;
   oIn >> RouteInfoSymbolic;
   oIn >> DestinationInfoAcoustic;
   oIn >> DestinationInfoSymbolic;
   oIn >> DrivingRecommendationAcoustic;
   oIn >> DrivingRecommendationSymbolic;
   if (oIn.u16GetMajorVersion() <= 16)
   {
      oIn >> CorridorInfoAcoustic;
   }
   if (oIn.u16GetMajorVersion() <= 16)
   {
      oIn >> CorridorInfoSymbolic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoTrafficMessageAcoustic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoTrafficMessageSymbolic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoSpeedLimitAcoustic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoSpeedLimitSymbolic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoWarningSignAcoustic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoWarningSignSymbolic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoPOIAcoustic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoPOISymbolic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoRoadAttributeAcoustic;
   }
   if ((9 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoRoadAttributeSymbolic;
   }
   if ((13 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoCurveAcoustic;
   }
   if ((13 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoCurveSymbolic;
   }
   if ((15 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 16))
   {
      oIn >> HorizonInfoUPOI;
   }
   if (17 <= oIn.u16GetMajorVersion())
   {
      oIn >> DriverSpeedAdvice;
   }
   if (17 <= oIn.u16GetMajorVersion())
   {
      oIn >> HorizonEvents;
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgFunctionalityStatesStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RouteInfoAcoustic;
   oOut << RouteInfoSymbolic;
   oOut << DestinationInfoAcoustic;
   oOut << DestinationInfoSymbolic;
   oOut << DrivingRecommendationAcoustic;
   oOut << DrivingRecommendationSymbolic;
   if (oOut.u16GetMajorVersion() <= 16)
   {
      oOut << CorridorInfoAcoustic;
   }
   if (oOut.u16GetMajorVersion() <= 16)
   {
      oOut << CorridorInfoSymbolic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoTrafficMessageAcoustic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoTrafficMessageSymbolic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoSpeedLimitAcoustic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoSpeedLimitSymbolic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoWarningSignAcoustic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoWarningSignSymbolic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoPOIAcoustic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoPOISymbolic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoRoadAttributeAcoustic;
   }
   if ((9 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoRoadAttributeSymbolic;
   }
   if ((13 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoCurveAcoustic;
   }
   if ((13 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoCurveSymbolic;
   }
   if ((15 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 16))
   {
      oOut << HorizonInfoUPOI;
   }
   if (17 <= oOut.u16GetMajorVersion())
   {
      oOut << DriverSpeedAdvice;
   }
   if (17 <= oOut.u16GetMajorVersion())
   {
      oOut << HorizonEvents;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeedLimitExceedingConfigurationGet::rgfi_tclMsgSpeedLimitExceedingConfigurationGet(const rgfi_tclMsgSpeedLimitExceedingConfigurationGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeedLimitExceedingConfigurationGet& rgfi_tclMsgSpeedLimitExceedingConfigurationGet::operator=(const rgfi_tclMsgSpeedLimitExceedingConfigurationGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSpeedLimitExceedingConfigurationGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSpeedLimitExceedingConfigurationGet::u16GetFunctionID() const {return RGFI_C_U16_SPEEDLIMITEXCEEDINGCONFIGURATION;}
tU8 rgfi_tclMsgSpeedLimitExceedingConfigurationGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgSpeedLimitExceedingConfigurationGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgSpeedLimitExceedingConfigurationGet::operator==(const rgfi_tclMsgSpeedLimitExceedingConfigurationGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSpeedLimitExceedingConfigurationGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSpeedLimitExceedingConfigurationGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeedLimitExceedingConfigurationSet::rgfi_tclMsgSpeedLimitExceedingConfigurationSet(const rgfi_tclMsgSpeedLimitExceedingConfigurationSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   AcceptedSpeedLimitExceedingBuiltUp = coRef.AcceptedSpeedLimitExceedingBuiltUp;
   AcceptedSpeedLimitExceedingNonBuiltUp = coRef.AcceptedSpeedLimitExceedingNonBuiltUp;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeedLimitExceedingConfigurationSet& rgfi_tclMsgSpeedLimitExceedingConfigurationSet::operator=(const rgfi_tclMsgSpeedLimitExceedingConfigurationSet& coRef)
{
   if (this == &coRef) return *this;
   AcceptedSpeedLimitExceedingBuiltUp = coRef.AcceptedSpeedLimitExceedingBuiltUp;
   AcceptedSpeedLimitExceedingNonBuiltUp = coRef.AcceptedSpeedLimitExceedingNonBuiltUp;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSpeedLimitExceedingConfigurationSet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSpeedLimitExceedingConfigurationSet::u16GetFunctionID() const {return RGFI_C_U16_SPEEDLIMITEXCEEDINGCONFIGURATION;}
tU8 rgfi_tclMsgSpeedLimitExceedingConfigurationSet::u8GetOpCode() const {return CCA_C_U8_OPCODE_SET;}

tVoid rgfi_tclMsgSpeedLimitExceedingConfigurationSet::vDestroy()
{
   AcceptedSpeedLimitExceedingBuiltUp.vDestroy(); 
   AcceptedSpeedLimitExceedingNonBuiltUp.vDestroy(); 
}

tU32 rgfi_tclMsgSpeedLimitExceedingConfigurationSet::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+AcceptedSpeedLimitExceedingBuiltUp.u32GetSize(u16MajorVersion)+AcceptedSpeedLimitExceedingNonBuiltUp.u32GetSize(u16MajorVersion);
}

tBool rgfi_tclMsgSpeedLimitExceedingConfigurationSet::operator==(const rgfi_tclMsgSpeedLimitExceedingConfigurationSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AcceptedSpeedLimitExceedingBuiltUp == rfoCmp.AcceptedSpeedLimitExceedingBuiltUp);
      bResult = bResult && (AcceptedSpeedLimitExceedingNonBuiltUp == rfoCmp.AcceptedSpeedLimitExceedingNonBuiltUp);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSpeedLimitExceedingConfigurationSet::oRead(fi_tclInContext& oIn)
{
   oIn >> AcceptedSpeedLimitExceedingBuiltUp;
   oIn >> AcceptedSpeedLimitExceedingNonBuiltUp;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSpeedLimitExceedingConfigurationSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << AcceptedSpeedLimitExceedingBuiltUp;
   oOut << AcceptedSpeedLimitExceedingNonBuiltUp;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeedLimitExceedingConfigurationStatus::rgfi_tclMsgSpeedLimitExceedingConfigurationStatus(const rgfi_tclMsgSpeedLimitExceedingConfigurationStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   AcceptedSpeedLimitExceedingBuiltUp = coRef.AcceptedSpeedLimitExceedingBuiltUp;
   AcceptedSpeedLimitExceedingNonBuiltUp = coRef.AcceptedSpeedLimitExceedingNonBuiltUp;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeedLimitExceedingConfigurationStatus& rgfi_tclMsgSpeedLimitExceedingConfigurationStatus::operator=(const rgfi_tclMsgSpeedLimitExceedingConfigurationStatus& coRef)
{
   if (this == &coRef) return *this;
   AcceptedSpeedLimitExceedingBuiltUp = coRef.AcceptedSpeedLimitExceedingBuiltUp;
   AcceptedSpeedLimitExceedingNonBuiltUp = coRef.AcceptedSpeedLimitExceedingNonBuiltUp;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSpeedLimitExceedingConfigurationStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSpeedLimitExceedingConfigurationStatus::u16GetFunctionID() const {return RGFI_C_U16_SPEEDLIMITEXCEEDINGCONFIGURATION;}
tU8 rgfi_tclMsgSpeedLimitExceedingConfigurationStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rgfi_tclMsgSpeedLimitExceedingConfigurationStatus::vDestroy()
{
   AcceptedSpeedLimitExceedingBuiltUp.vDestroy(); 
   AcceptedSpeedLimitExceedingNonBuiltUp.vDestroy(); 
}

tU32 rgfi_tclMsgSpeedLimitExceedingConfigurationStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+AcceptedSpeedLimitExceedingBuiltUp.u32GetSize(u16MajorVersion)+AcceptedSpeedLimitExceedingNonBuiltUp.u32GetSize(u16MajorVersion);
}

tBool rgfi_tclMsgSpeedLimitExceedingConfigurationStatus::operator==(const rgfi_tclMsgSpeedLimitExceedingConfigurationStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AcceptedSpeedLimitExceedingBuiltUp == rfoCmp.AcceptedSpeedLimitExceedingBuiltUp);
      bResult = bResult && (AcceptedSpeedLimitExceedingNonBuiltUp == rfoCmp.AcceptedSpeedLimitExceedingNonBuiltUp);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSpeedLimitExceedingConfigurationStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> AcceptedSpeedLimitExceedingBuiltUp;
   oIn >> AcceptedSpeedLimitExceedingNonBuiltUp;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSpeedLimitExceedingConfigurationStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << AcceptedSpeedLimitExceedingBuiltUp;
   oOut << AcceptedSpeedLimitExceedingNonBuiltUp;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgCoastingAdviceConfigurationGet::rgfi_tclMsgCoastingAdviceConfigurationGet(const rgfi_tclMsgCoastingAdviceConfigurationGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgCoastingAdviceConfigurationGet& rgfi_tclMsgCoastingAdviceConfigurationGet::operator=(const rgfi_tclMsgCoastingAdviceConfigurationGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgCoastingAdviceConfigurationGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgCoastingAdviceConfigurationGet::u16GetFunctionID() const {return RGFI_C_U16_COASTINGADVICECONFIGURATION;}
tU8 rgfi_tclMsgCoastingAdviceConfigurationGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgCoastingAdviceConfigurationGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgCoastingAdviceConfigurationGet::operator==(const rgfi_tclMsgCoastingAdviceConfigurationGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgCoastingAdviceConfigurationGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgCoastingAdviceConfigurationGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgCoastingAdviceConfigurationUpReg::rgfi_tclMsgCoastingAdviceConfigurationUpReg(const rgfi_tclMsgCoastingAdviceConfigurationUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgCoastingAdviceConfigurationUpReg& rgfi_tclMsgCoastingAdviceConfigurationUpReg::operator=(const rgfi_tclMsgCoastingAdviceConfigurationUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgCoastingAdviceConfigurationUpReg::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgCoastingAdviceConfigurationUpReg::u16GetFunctionID() const {return RGFI_C_U16_COASTINGADVICECONFIGURATION;}
tU8 rgfi_tclMsgCoastingAdviceConfigurationUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 rgfi_tclMsgCoastingAdviceConfigurationUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgCoastingAdviceConfigurationUpReg::operator==(const rgfi_tclMsgCoastingAdviceConfigurationUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgCoastingAdviceConfigurationUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgCoastingAdviceConfigurationUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgCoastingAdviceConfigurationRelUpReg::rgfi_tclMsgCoastingAdviceConfigurationRelUpReg(const rgfi_tclMsgCoastingAdviceConfigurationRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgCoastingAdviceConfigurationRelUpReg& rgfi_tclMsgCoastingAdviceConfigurationRelUpReg::operator=(const rgfi_tclMsgCoastingAdviceConfigurationRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgCoastingAdviceConfigurationRelUpReg::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgCoastingAdviceConfigurationRelUpReg::u16GetFunctionID() const {return RGFI_C_U16_COASTINGADVICECONFIGURATION;}
tU8 rgfi_tclMsgCoastingAdviceConfigurationRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 rgfi_tclMsgCoastingAdviceConfigurationRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgCoastingAdviceConfigurationRelUpReg::operator==(const rgfi_tclMsgCoastingAdviceConfigurationRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgCoastingAdviceConfigurationRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgCoastingAdviceConfigurationRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgCoastingAdviceConfigurationSet::rgfi_tclMsgCoastingAdviceConfigurationSet(const rgfi_tclMsgCoastingAdviceConfigurationSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   AcceptableTimeLoss = coRef.AcceptableTimeLoss;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgCoastingAdviceConfigurationSet& rgfi_tclMsgCoastingAdviceConfigurationSet::operator=(const rgfi_tclMsgCoastingAdviceConfigurationSet& coRef)
{
   if (this == &coRef) return *this;
   AcceptableTimeLoss = coRef.AcceptableTimeLoss;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgCoastingAdviceConfigurationSet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgCoastingAdviceConfigurationSet::u16GetFunctionID() const {return RGFI_C_U16_COASTINGADVICECONFIGURATION;}
tU8 rgfi_tclMsgCoastingAdviceConfigurationSet::u8GetOpCode() const {return CCA_C_U8_OPCODE_SET;}

tU32 rgfi_tclMsgCoastingAdviceConfigurationSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool rgfi_tclMsgCoastingAdviceConfigurationSet::operator==(const rgfi_tclMsgCoastingAdviceConfigurationSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AcceptableTimeLoss == rfoCmp.AcceptableTimeLoss);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgCoastingAdviceConfigurationSet::oRead(fi_tclInContext& oIn)
{
   oIn >> AcceptableTimeLoss;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgCoastingAdviceConfigurationSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << AcceptableTimeLoss;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgCoastingAdviceConfigurationStatus::rgfi_tclMsgCoastingAdviceConfigurationStatus(const rgfi_tclMsgCoastingAdviceConfigurationStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   AcceptableTimeLoss = coRef.AcceptableTimeLoss;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgCoastingAdviceConfigurationStatus& rgfi_tclMsgCoastingAdviceConfigurationStatus::operator=(const rgfi_tclMsgCoastingAdviceConfigurationStatus& coRef)
{
   if (this == &coRef) return *this;
   AcceptableTimeLoss = coRef.AcceptableTimeLoss;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgCoastingAdviceConfigurationStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgCoastingAdviceConfigurationStatus::u16GetFunctionID() const {return RGFI_C_U16_COASTINGADVICECONFIGURATION;}
tU8 rgfi_tclMsgCoastingAdviceConfigurationStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 rgfi_tclMsgCoastingAdviceConfigurationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool rgfi_tclMsgCoastingAdviceConfigurationStatus::operator==(const rgfi_tclMsgCoastingAdviceConfigurationStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AcceptableTimeLoss == rfoCmp.AcceptableTimeLoss);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgCoastingAdviceConfigurationStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> AcceptableTimeLoss;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgCoastingAdviceConfigurationStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << AcceptableTimeLoss;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeedAdviceConfigurationGet::rgfi_tclMsgSpeedAdviceConfigurationGet(const rgfi_tclMsgSpeedAdviceConfigurationGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeedAdviceConfigurationGet& rgfi_tclMsgSpeedAdviceConfigurationGet::operator=(const rgfi_tclMsgSpeedAdviceConfigurationGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSpeedAdviceConfigurationGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSpeedAdviceConfigurationGet::u16GetFunctionID() const {return RGFI_C_U16_SPEEDADVICECONFIGURATION;}
tU8 rgfi_tclMsgSpeedAdviceConfigurationGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgSpeedAdviceConfigurationGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgSpeedAdviceConfigurationGet::operator==(const rgfi_tclMsgSpeedAdviceConfigurationGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSpeedAdviceConfigurationGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSpeedAdviceConfigurationGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeedAdviceConfigurationUpReg::rgfi_tclMsgSpeedAdviceConfigurationUpReg(const rgfi_tclMsgSpeedAdviceConfigurationUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeedAdviceConfigurationUpReg& rgfi_tclMsgSpeedAdviceConfigurationUpReg::operator=(const rgfi_tclMsgSpeedAdviceConfigurationUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSpeedAdviceConfigurationUpReg::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSpeedAdviceConfigurationUpReg::u16GetFunctionID() const {return RGFI_C_U16_SPEEDADVICECONFIGURATION;}
tU8 rgfi_tclMsgSpeedAdviceConfigurationUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 rgfi_tclMsgSpeedAdviceConfigurationUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgSpeedAdviceConfigurationUpReg::operator==(const rgfi_tclMsgSpeedAdviceConfigurationUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSpeedAdviceConfigurationUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSpeedAdviceConfigurationUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeedAdviceConfigurationRelUpReg::rgfi_tclMsgSpeedAdviceConfigurationRelUpReg(const rgfi_tclMsgSpeedAdviceConfigurationRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeedAdviceConfigurationRelUpReg& rgfi_tclMsgSpeedAdviceConfigurationRelUpReg::operator=(const rgfi_tclMsgSpeedAdviceConfigurationRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSpeedAdviceConfigurationRelUpReg::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSpeedAdviceConfigurationRelUpReg::u16GetFunctionID() const {return RGFI_C_U16_SPEEDADVICECONFIGURATION;}
tU8 rgfi_tclMsgSpeedAdviceConfigurationRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 rgfi_tclMsgSpeedAdviceConfigurationRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgSpeedAdviceConfigurationRelUpReg::operator==(const rgfi_tclMsgSpeedAdviceConfigurationRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSpeedAdviceConfigurationRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSpeedAdviceConfigurationRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeedAdviceConfigurationSet::rgfi_tclMsgSpeedAdviceConfigurationSet(const rgfi_tclMsgSpeedAdviceConfigurationSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   AcceptedSpeedLimitExceedingList = coRef.AcceptedSpeedLimitExceedingList;
   CurveSensitivity = coRef.CurveSensitivity;
   BrakeTiming = coRef.BrakeTiming;
   AcceptedCoastingTimeLoss = coRef.AcceptedCoastingTimeLoss;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeedAdviceConfigurationSet& rgfi_tclMsgSpeedAdviceConfigurationSet::operator=(const rgfi_tclMsgSpeedAdviceConfigurationSet& coRef)
{
   if (this == &coRef) return *this;
   AcceptedSpeedLimitExceedingList = coRef.AcceptedSpeedLimitExceedingList;
   CurveSensitivity = coRef.CurveSensitivity;
   BrakeTiming = coRef.BrakeTiming;
   AcceptedCoastingTimeLoss = coRef.AcceptedCoastingTimeLoss;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSpeedAdviceConfigurationSet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSpeedAdviceConfigurationSet::u16GetFunctionID() const {return RGFI_C_U16_SPEEDADVICECONFIGURATION;}
tU8 rgfi_tclMsgSpeedAdviceConfigurationSet::u8GetOpCode() const {return CCA_C_U8_OPCODE_SET;}

tVoid rgfi_tclMsgSpeedAdviceConfigurationSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AcceptedSpeedLimitExceedingList.size(); ++u32Idx)
         AcceptedSpeedLimitExceedingList[u32Idx].vDestroy();
   }
   AcceptedSpeedLimitExceedingList.clear();
}

tU32 rgfi_tclMsgSpeedAdviceConfigurationSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7+AcceptedSpeedLimitExceedingList.size()*4;
}

tBool rgfi_tclMsgSpeedAdviceConfigurationSet::operator==(const rgfi_tclMsgSpeedAdviceConfigurationSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AcceptedSpeedLimitExceedingList.size() == rfoCmp.AcceptedSpeedLimitExceedingList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AcceptedSpeedLimitExceedingList.size()); ++u32Idx)
            bResult = bResult && (AcceptedSpeedLimitExceedingList[u32Idx] == rfoCmp.AcceptedSpeedLimitExceedingList[u32Idx]);
      }
      bResult = bResult && (CurveSensitivity == rfoCmp.CurveSensitivity);
      bResult = bResult && (BrakeTiming == rfoCmp.BrakeTiming);
      bResult = bResult && (AcceptedCoastingTimeLoss == rfoCmp.AcceptedCoastingTimeLoss);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSpeedAdviceConfigurationSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AcceptedSpeedLimitExceedingList.size(); ++u32Idx)
      {
         AcceptedSpeedLimitExceedingList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      AcceptedSpeedLimitExceedingList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AcceptedSpeedLimitExceedingList[u32Idx];
      }
   }
   oIn >> CurveSensitivity;
   oIn >> BrakeTiming;
   oIn >> AcceptedCoastingTimeLoss;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSpeedAdviceConfigurationSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)AcceptedSpeedLimitExceedingList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AcceptedSpeedLimitExceedingList.size(); ++u32Idx)
         oOut << AcceptedSpeedLimitExceedingList[u32Idx];
   }
   oOut << CurveSensitivity;
   oOut << BrakeTiming;
   oOut << AcceptedCoastingTimeLoss;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeedAdviceConfigurationStatus::rgfi_tclMsgSpeedAdviceConfigurationStatus(const rgfi_tclMsgSpeedAdviceConfigurationStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   AcceptedSpeedLimitExceedingList = coRef.AcceptedSpeedLimitExceedingList;
   CurveSensitivity = coRef.CurveSensitivity;
   BrakeTiming = coRef.BrakeTiming;
   AcceptedCoastingTimeLoss = coRef.AcceptedCoastingTimeLoss;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeedAdviceConfigurationStatus& rgfi_tclMsgSpeedAdviceConfigurationStatus::operator=(const rgfi_tclMsgSpeedAdviceConfigurationStatus& coRef)
{
   if (this == &coRef) return *this;
   AcceptedSpeedLimitExceedingList = coRef.AcceptedSpeedLimitExceedingList;
   CurveSensitivity = coRef.CurveSensitivity;
   BrakeTiming = coRef.BrakeTiming;
   AcceptedCoastingTimeLoss = coRef.AcceptedCoastingTimeLoss;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSpeedAdviceConfigurationStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSpeedAdviceConfigurationStatus::u16GetFunctionID() const {return RGFI_C_U16_SPEEDADVICECONFIGURATION;}
tU8 rgfi_tclMsgSpeedAdviceConfigurationStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rgfi_tclMsgSpeedAdviceConfigurationStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AcceptedSpeedLimitExceedingList.size(); ++u32Idx)
         AcceptedSpeedLimitExceedingList[u32Idx].vDestroy();
   }
   AcceptedSpeedLimitExceedingList.clear();
}

tU32 rgfi_tclMsgSpeedAdviceConfigurationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7+AcceptedSpeedLimitExceedingList.size()*4;
}

tBool rgfi_tclMsgSpeedAdviceConfigurationStatus::operator==(const rgfi_tclMsgSpeedAdviceConfigurationStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AcceptedSpeedLimitExceedingList.size() == rfoCmp.AcceptedSpeedLimitExceedingList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AcceptedSpeedLimitExceedingList.size()); ++u32Idx)
            bResult = bResult && (AcceptedSpeedLimitExceedingList[u32Idx] == rfoCmp.AcceptedSpeedLimitExceedingList[u32Idx]);
      }
      bResult = bResult && (CurveSensitivity == rfoCmp.CurveSensitivity);
      bResult = bResult && (BrakeTiming == rfoCmp.BrakeTiming);
      bResult = bResult && (AcceptedCoastingTimeLoss == rfoCmp.AcceptedCoastingTimeLoss);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSpeedAdviceConfigurationStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AcceptedSpeedLimitExceedingList.size(); ++u32Idx)
      {
         AcceptedSpeedLimitExceedingList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      AcceptedSpeedLimitExceedingList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AcceptedSpeedLimitExceedingList[u32Idx];
      }
   }
   oIn >> CurveSensitivity;
   oIn >> BrakeTiming;
   oIn >> AcceptedCoastingTimeLoss;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSpeedAdviceConfigurationStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)AcceptedSpeedLimitExceedingList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AcceptedSpeedLimitExceedingList.size(); ++u32Idx)
         oOut << AcceptedSpeedLimitExceedingList[u32Idx];
   }
   oOut << CurveSensitivity;
   oOut << BrakeTiming;
   oOut << AcceptedCoastingTimeLoss;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgCurrentLaneInfoGet::rgfi_tclMsgCurrentLaneInfoGet(const rgfi_tclMsgCurrentLaneInfoGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgCurrentLaneInfoGet& rgfi_tclMsgCurrentLaneInfoGet::operator=(const rgfi_tclMsgCurrentLaneInfoGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgCurrentLaneInfoGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgCurrentLaneInfoGet::u16GetFunctionID() const {return RGFI_C_U16_CURRENTLANEINFO;}
tU8 rgfi_tclMsgCurrentLaneInfoGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgCurrentLaneInfoGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgCurrentLaneInfoGet::operator==(const rgfi_tclMsgCurrentLaneInfoGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgCurrentLaneInfoGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgCurrentLaneInfoGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgCurrentLaneInfoStatus::rgfi_tclMsgCurrentLaneInfoStatus(const rgfi_tclMsgCurrentLaneInfoStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ReleaseNumber = coRef.ReleaseNumber;
   TrafficSense = coRef.TrafficSense;
   LaneInfoElement = coRef.LaneInfoElement;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgCurrentLaneInfoStatus& rgfi_tclMsgCurrentLaneInfoStatus::operator=(const rgfi_tclMsgCurrentLaneInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   ReleaseNumber = coRef.ReleaseNumber;
   TrafficSense = coRef.TrafficSense;
   LaneInfoElement = coRef.LaneInfoElement;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgCurrentLaneInfoStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgCurrentLaneInfoStatus::u16GetFunctionID() const {return RGFI_C_U16_CURRENTLANEINFO;}
tU8 rgfi_tclMsgCurrentLaneInfoStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rgfi_tclMsgCurrentLaneInfoStatus::vDestroy()
{
   LaneInfoElement.vDestroy(); 
}

tU32 rgfi_tclMsgCurrentLaneInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+LaneInfoElement.u32GetSize(u16MajorVersion);
}

tBool rgfi_tclMsgCurrentLaneInfoStatus::operator==(const rgfi_tclMsgCurrentLaneInfoStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ReleaseNumber == rfoCmp.ReleaseNumber);
      bResult = bResult && (TrafficSense == rfoCmp.TrafficSense);
      bResult = bResult && (LaneInfoElement == rfoCmp.LaneInfoElement);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgCurrentLaneInfoStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ReleaseNumber;
   oIn >> TrafficSense;
   oIn >> LaneInfoElement;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgCurrentLaneInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ReleaseNumber;
   oOut << TrafficSense;
   oOut << LaneInfoElement;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgCurveWarningConfigurationGet::rgfi_tclMsgCurveWarningConfigurationGet(const rgfi_tclMsgCurveWarningConfigurationGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgCurveWarningConfigurationGet& rgfi_tclMsgCurveWarningConfigurationGet::operator=(const rgfi_tclMsgCurveWarningConfigurationGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgCurveWarningConfigurationGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgCurveWarningConfigurationGet::u16GetFunctionID() const {return RGFI_C_U16_CURVEWARNINGCONFIGURATION;}
tU8 rgfi_tclMsgCurveWarningConfigurationGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgCurveWarningConfigurationGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgCurveWarningConfigurationGet::operator==(const rgfi_tclMsgCurveWarningConfigurationGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgCurveWarningConfigurationGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgCurveWarningConfigurationGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgCurveWarningConfigurationSet::rgfi_tclMsgCurveWarningConfigurationSet(const rgfi_tclMsgCurveWarningConfigurationSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   Sensitivity = coRef.Sensitivity;
   Timing = coRef.Timing;
   AcousticalInformationAcceleration = coRef.AcousticalInformationAcceleration;
   AcousticalWarningAcceleration = coRef.AcousticalWarningAcceleration;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgCurveWarningConfigurationSet& rgfi_tclMsgCurveWarningConfigurationSet::operator=(const rgfi_tclMsgCurveWarningConfigurationSet& coRef)
{
   if (this == &coRef) return *this;
   Sensitivity = coRef.Sensitivity;
   Timing = coRef.Timing;
   AcousticalInformationAcceleration = coRef.AcousticalInformationAcceleration;
   AcousticalWarningAcceleration = coRef.AcousticalWarningAcceleration;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgCurveWarningConfigurationSet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgCurveWarningConfigurationSet::u16GetFunctionID() const {return RGFI_C_U16_CURVEWARNINGCONFIGURATION;}
tU8 rgfi_tclMsgCurveWarningConfigurationSet::u8GetOpCode() const {return CCA_C_U8_OPCODE_SET;}

tU32 rgfi_tclMsgCurveWarningConfigurationSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (17 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (u16MajorVersion <= 16)
   {
      u32DynamicSize += 4;
   }
   if (u16MajorVersion <= 16)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+1;
}

tBool rgfi_tclMsgCurveWarningConfigurationSet::operator==(const rgfi_tclMsgCurveWarningConfigurationSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Sensitivity == rfoCmp.Sensitivity);
      bResult = bResult && (Timing == rfoCmp.Timing);
      bResult = bResult && (AcousticalInformationAcceleration == rfoCmp.AcousticalInformationAcceleration);
      bResult = bResult && (AcousticalWarningAcceleration == rfoCmp.AcousticalWarningAcceleration);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgCurveWarningConfigurationSet::oRead(fi_tclInContext& oIn)
{
   oIn >> Sensitivity;
   if (17 <= oIn.u16GetMajorVersion())
   {
      oIn >> Timing;
   }
   if (oIn.u16GetMajorVersion() <= 16)
   {
      oIn >> AcousticalInformationAcceleration;
   }
   if (oIn.u16GetMajorVersion() <= 16)
   {
      oIn >> AcousticalWarningAcceleration;
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgCurveWarningConfigurationSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Sensitivity;
   if (17 <= oOut.u16GetMajorVersion())
   {
      oOut << Timing;
   }
   if (oOut.u16GetMajorVersion() <= 16)
   {
      oOut << AcousticalInformationAcceleration;
   }
   if (oOut.u16GetMajorVersion() <= 16)
   {
      oOut << AcousticalWarningAcceleration;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgCurveWarningConfigurationStatus::rgfi_tclMsgCurveWarningConfigurationStatus(const rgfi_tclMsgCurveWarningConfigurationStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Sensitivity = coRef.Sensitivity;
   Timing = coRef.Timing;
   AcousticalInformationAcceleration = coRef.AcousticalInformationAcceleration;
   AcousticalWarningAcceleration = coRef.AcousticalWarningAcceleration;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgCurveWarningConfigurationStatus& rgfi_tclMsgCurveWarningConfigurationStatus::operator=(const rgfi_tclMsgCurveWarningConfigurationStatus& coRef)
{
   if (this == &coRef) return *this;
   Sensitivity = coRef.Sensitivity;
   Timing = coRef.Timing;
   AcousticalInformationAcceleration = coRef.AcousticalInformationAcceleration;
   AcousticalWarningAcceleration = coRef.AcousticalWarningAcceleration;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgCurveWarningConfigurationStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgCurveWarningConfigurationStatus::u16GetFunctionID() const {return RGFI_C_U16_CURVEWARNINGCONFIGURATION;}
tU8 rgfi_tclMsgCurveWarningConfigurationStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 rgfi_tclMsgCurveWarningConfigurationStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (17 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (u16MajorVersion <= 16)
   {
      u32DynamicSize += 4;
   }
   if (u16MajorVersion <= 16)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+1;
}

tBool rgfi_tclMsgCurveWarningConfigurationStatus::operator==(const rgfi_tclMsgCurveWarningConfigurationStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Sensitivity == rfoCmp.Sensitivity);
      bResult = bResult && (Timing == rfoCmp.Timing);
      bResult = bResult && (AcousticalInformationAcceleration == rfoCmp.AcousticalInformationAcceleration);
      bResult = bResult && (AcousticalWarningAcceleration == rfoCmp.AcousticalWarningAcceleration);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgCurveWarningConfigurationStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Sensitivity;
   if (17 <= oIn.u16GetMajorVersion())
   {
      oIn >> Timing;
   }
   if (oIn.u16GetMajorVersion() <= 16)
   {
      oIn >> AcousticalInformationAcceleration;
   }
   if (oIn.u16GetMajorVersion() <= 16)
   {
      oIn >> AcousticalWarningAcceleration;
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgCurveWarningConfigurationStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Sensitivity;
   if (17 <= oOut.u16GetMajorVersion())
   {
      oOut << Timing;
   }
   if (oOut.u16GetMajorVersion() <= 16)
   {
      oOut << AcousticalInformationAcceleration;
   }
   if (oOut.u16GetMajorVersion() <= 16)
   {
      oOut << AcousticalWarningAcceleration;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgUPOIAnnouncementCategoriesGet::rgfi_tclMsgUPOIAnnouncementCategoriesGet(const rgfi_tclMsgUPOIAnnouncementCategoriesGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgUPOIAnnouncementCategoriesGet& rgfi_tclMsgUPOIAnnouncementCategoriesGet::operator=(const rgfi_tclMsgUPOIAnnouncementCategoriesGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgUPOIAnnouncementCategoriesGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgUPOIAnnouncementCategoriesGet::u16GetFunctionID() const {return RGFI_C_U16_UPOIANNOUNCEMENTCATEGORIES;}
tU8 rgfi_tclMsgUPOIAnnouncementCategoriesGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgUPOIAnnouncementCategoriesGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgUPOIAnnouncementCategoriesGet::operator==(const rgfi_tclMsgUPOIAnnouncementCategoriesGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgUPOIAnnouncementCategoriesGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgUPOIAnnouncementCategoriesGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgUPOIAnnouncementCategoriesStatus::rgfi_tclMsgUPOIAnnouncementCategoriesStatus(const rgfi_tclMsgUPOIAnnouncementCategoriesStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Categories = coRef.Categories;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgUPOIAnnouncementCategoriesStatus& rgfi_tclMsgUPOIAnnouncementCategoriesStatus::operator=(const rgfi_tclMsgUPOIAnnouncementCategoriesStatus& coRef)
{
   if (this == &coRef) return *this;
   Categories = coRef.Categories;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgUPOIAnnouncementCategoriesStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgUPOIAnnouncementCategoriesStatus::u16GetFunctionID() const {return RGFI_C_U16_UPOIANNOUNCEMENTCATEGORIES;}
tU8 rgfi_tclMsgUPOIAnnouncementCategoriesStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rgfi_tclMsgUPOIAnnouncementCategoriesStatus::vDestroy()
{
   Categories.vDestroy(); 
}

tU32 rgfi_tclMsgUPOIAnnouncementCategoriesStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Categories.u32GetSize(u16MajorVersion);
}

tBool rgfi_tclMsgUPOIAnnouncementCategoriesStatus::operator==(const rgfi_tclMsgUPOIAnnouncementCategoriesStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Categories == rfoCmp.Categories);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgUPOIAnnouncementCategoriesStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Categories;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgUPOIAnnouncementCategoriesStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Categories;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastProcessedRouteInfoListUpReg::rgfi_tclMsgLastProcessedRouteInfoListUpReg(const rgfi_tclMsgLastProcessedRouteInfoListUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastProcessedRouteInfoListUpReg& rgfi_tclMsgLastProcessedRouteInfoListUpReg::operator=(const rgfi_tclMsgLastProcessedRouteInfoListUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgLastProcessedRouteInfoListUpReg::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgLastProcessedRouteInfoListUpReg::u16GetFunctionID() const {return RGFI_C_U16_LASTPROCESSEDROUTEINFOLIST;}
tU8 rgfi_tclMsgLastProcessedRouteInfoListUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 rgfi_tclMsgLastProcessedRouteInfoListUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgLastProcessedRouteInfoListUpReg::operator==(const rgfi_tclMsgLastProcessedRouteInfoListUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgLastProcessedRouteInfoListUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgLastProcessedRouteInfoListUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastProcessedRouteInfoListRelUpReg::rgfi_tclMsgLastProcessedRouteInfoListRelUpReg(const rgfi_tclMsgLastProcessedRouteInfoListRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastProcessedRouteInfoListRelUpReg& rgfi_tclMsgLastProcessedRouteInfoListRelUpReg::operator=(const rgfi_tclMsgLastProcessedRouteInfoListRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgLastProcessedRouteInfoListRelUpReg::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgLastProcessedRouteInfoListRelUpReg::u16GetFunctionID() const {return RGFI_C_U16_LASTPROCESSEDROUTEINFOLIST;}
tU8 rgfi_tclMsgLastProcessedRouteInfoListRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 rgfi_tclMsgLastProcessedRouteInfoListRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgLastProcessedRouteInfoListRelUpReg::operator==(const rgfi_tclMsgLastProcessedRouteInfoListRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgLastProcessedRouteInfoListRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgLastProcessedRouteInfoListRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastProcessedRouteInfoListGet::rgfi_tclMsgLastProcessedRouteInfoListGet(const rgfi_tclMsgLastProcessedRouteInfoListGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastProcessedRouteInfoListGet& rgfi_tclMsgLastProcessedRouteInfoListGet::operator=(const rgfi_tclMsgLastProcessedRouteInfoListGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgLastProcessedRouteInfoListGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgLastProcessedRouteInfoListGet::u16GetFunctionID() const {return RGFI_C_U16_LASTPROCESSEDROUTEINFOLIST;}
tU8 rgfi_tclMsgLastProcessedRouteInfoListGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgLastProcessedRouteInfoListGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgLastProcessedRouteInfoListGet::operator==(const rgfi_tclMsgLastProcessedRouteInfoListGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgLastProcessedRouteInfoListGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgLastProcessedRouteInfoListGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastProcessedRouteInfoListStatus::rgfi_tclMsgLastProcessedRouteInfoListStatus(const rgfi_tclMsgLastProcessedRouteInfoListStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   RouteInfoId = coRef.RouteInfoId;
   RouteInfoCounter = coRef.RouteInfoCounter;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastProcessedRouteInfoListStatus& rgfi_tclMsgLastProcessedRouteInfoListStatus::operator=(const rgfi_tclMsgLastProcessedRouteInfoListStatus& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   RouteInfoId = coRef.RouteInfoId;
   RouteInfoCounter = coRef.RouteInfoCounter;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgLastProcessedRouteInfoListStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgLastProcessedRouteInfoListStatus::u16GetFunctionID() const {return RGFI_C_U16_LASTPROCESSEDROUTEINFOLIST;}
tU8 rgfi_tclMsgLastProcessedRouteInfoListStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 rgfi_tclMsgLastProcessedRouteInfoListStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

tBool rgfi_tclMsgLastProcessedRouteInfoListStatus::operator==(const rgfi_tclMsgLastProcessedRouteInfoListStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (RouteInfoId == rfoCmp.RouteInfoId);
      bResult = bResult && (RouteInfoCounter == rfoCmp.RouteInfoCounter);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgLastProcessedRouteInfoListStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> RouteInfoId;
   oIn >> RouteInfoCounter;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgLastProcessedRouteInfoListStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << RouteInfoId;
   oOut << RouteInfoCounter;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastProcessedTEAHorizonUpReg::rgfi_tclMsgLastProcessedTEAHorizonUpReg(const rgfi_tclMsgLastProcessedTEAHorizonUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastProcessedTEAHorizonUpReg& rgfi_tclMsgLastProcessedTEAHorizonUpReg::operator=(const rgfi_tclMsgLastProcessedTEAHorizonUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgLastProcessedTEAHorizonUpReg::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgLastProcessedTEAHorizonUpReg::u16GetFunctionID() const {return RGFI_C_U16_LASTPROCESSEDTEAHORIZON;}
tU8 rgfi_tclMsgLastProcessedTEAHorizonUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 rgfi_tclMsgLastProcessedTEAHorizonUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgLastProcessedTEAHorizonUpReg::operator==(const rgfi_tclMsgLastProcessedTEAHorizonUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgLastProcessedTEAHorizonUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgLastProcessedTEAHorizonUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastProcessedTEAHorizonRelUpReg::rgfi_tclMsgLastProcessedTEAHorizonRelUpReg(const rgfi_tclMsgLastProcessedTEAHorizonRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastProcessedTEAHorizonRelUpReg& rgfi_tclMsgLastProcessedTEAHorizonRelUpReg::operator=(const rgfi_tclMsgLastProcessedTEAHorizonRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgLastProcessedTEAHorizonRelUpReg::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgLastProcessedTEAHorizonRelUpReg::u16GetFunctionID() const {return RGFI_C_U16_LASTPROCESSEDTEAHORIZON;}
tU8 rgfi_tclMsgLastProcessedTEAHorizonRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 rgfi_tclMsgLastProcessedTEAHorizonRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgLastProcessedTEAHorizonRelUpReg::operator==(const rgfi_tclMsgLastProcessedTEAHorizonRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgLastProcessedTEAHorizonRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgLastProcessedTEAHorizonRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastProcessedTEAHorizonGet::rgfi_tclMsgLastProcessedTEAHorizonGet(const rgfi_tclMsgLastProcessedTEAHorizonGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastProcessedTEAHorizonGet& rgfi_tclMsgLastProcessedTEAHorizonGet::operator=(const rgfi_tclMsgLastProcessedTEAHorizonGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgLastProcessedTEAHorizonGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgLastProcessedTEAHorizonGet::u16GetFunctionID() const {return RGFI_C_U16_LASTPROCESSEDTEAHORIZON;}
tU8 rgfi_tclMsgLastProcessedTEAHorizonGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgLastProcessedTEAHorizonGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgLastProcessedTEAHorizonGet::operator==(const rgfi_tclMsgLastProcessedTEAHorizonGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgLastProcessedTEAHorizonGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgLastProcessedTEAHorizonGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastProcessedTEAHorizonStatus::rgfi_tclMsgLastProcessedTEAHorizonStatus(const rgfi_tclMsgLastProcessedTEAHorizonStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   TEAHorizonReleaseId = coRef.TEAHorizonReleaseId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastProcessedTEAHorizonStatus& rgfi_tclMsgLastProcessedTEAHorizonStatus::operator=(const rgfi_tclMsgLastProcessedTEAHorizonStatus& coRef)
{
   if (this == &coRef) return *this;
   TEAHorizonReleaseId = coRef.TEAHorizonReleaseId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgLastProcessedTEAHorizonStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgLastProcessedTEAHorizonStatus::u16GetFunctionID() const {return RGFI_C_U16_LASTPROCESSEDTEAHORIZON;}
tU8 rgfi_tclMsgLastProcessedTEAHorizonStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 rgfi_tclMsgLastProcessedTEAHorizonStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool rgfi_tclMsgLastProcessedTEAHorizonStatus::operator==(const rgfi_tclMsgLastProcessedTEAHorizonStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TEAHorizonReleaseId == rfoCmp.TEAHorizonReleaseId);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgLastProcessedTEAHorizonStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> TEAHorizonReleaseId;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgLastProcessedTEAHorizonStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TEAHorizonReleaseId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastProcessedTEAMPPUpReg::rgfi_tclMsgLastProcessedTEAMPPUpReg(const rgfi_tclMsgLastProcessedTEAMPPUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastProcessedTEAMPPUpReg& rgfi_tclMsgLastProcessedTEAMPPUpReg::operator=(const rgfi_tclMsgLastProcessedTEAMPPUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgLastProcessedTEAMPPUpReg::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgLastProcessedTEAMPPUpReg::u16GetFunctionID() const {return RGFI_C_U16_LASTPROCESSEDTEAMPP;}
tU8 rgfi_tclMsgLastProcessedTEAMPPUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 rgfi_tclMsgLastProcessedTEAMPPUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgLastProcessedTEAMPPUpReg::operator==(const rgfi_tclMsgLastProcessedTEAMPPUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgLastProcessedTEAMPPUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgLastProcessedTEAMPPUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastProcessedTEAMPPRelUpReg::rgfi_tclMsgLastProcessedTEAMPPRelUpReg(const rgfi_tclMsgLastProcessedTEAMPPRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastProcessedTEAMPPRelUpReg& rgfi_tclMsgLastProcessedTEAMPPRelUpReg::operator=(const rgfi_tclMsgLastProcessedTEAMPPRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgLastProcessedTEAMPPRelUpReg::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgLastProcessedTEAMPPRelUpReg::u16GetFunctionID() const {return RGFI_C_U16_LASTPROCESSEDTEAMPP;}
tU8 rgfi_tclMsgLastProcessedTEAMPPRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 rgfi_tclMsgLastProcessedTEAMPPRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgLastProcessedTEAMPPRelUpReg::operator==(const rgfi_tclMsgLastProcessedTEAMPPRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgLastProcessedTEAMPPRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgLastProcessedTEAMPPRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastProcessedTEAMPPGet::rgfi_tclMsgLastProcessedTEAMPPGet(const rgfi_tclMsgLastProcessedTEAMPPGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastProcessedTEAMPPGet& rgfi_tclMsgLastProcessedTEAMPPGet::operator=(const rgfi_tclMsgLastProcessedTEAMPPGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgLastProcessedTEAMPPGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgLastProcessedTEAMPPGet::u16GetFunctionID() const {return RGFI_C_U16_LASTPROCESSEDTEAMPP;}
tU8 rgfi_tclMsgLastProcessedTEAMPPGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgLastProcessedTEAMPPGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgLastProcessedTEAMPPGet::operator==(const rgfi_tclMsgLastProcessedTEAMPPGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgLastProcessedTEAMPPGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgLastProcessedTEAMPPGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastProcessedTEAMPPStatus::rgfi_tclMsgLastProcessedTEAMPPStatus(const rgfi_tclMsgLastProcessedTEAMPPStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   TEAMPPReleaseId = coRef.TEAMPPReleaseId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastProcessedTEAMPPStatus& rgfi_tclMsgLastProcessedTEAMPPStatus::operator=(const rgfi_tclMsgLastProcessedTEAMPPStatus& coRef)
{
   if (this == &coRef) return *this;
   TEAMPPReleaseId = coRef.TEAMPPReleaseId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgLastProcessedTEAMPPStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgLastProcessedTEAMPPStatus::u16GetFunctionID() const {return RGFI_C_U16_LASTPROCESSEDTEAMPP;}
tU8 rgfi_tclMsgLastProcessedTEAMPPStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 rgfi_tclMsgLastProcessedTEAMPPStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool rgfi_tclMsgLastProcessedTEAMPPStatus::operator==(const rgfi_tclMsgLastProcessedTEAMPPStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TEAMPPReleaseId == rfoCmp.TEAMPPReleaseId);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgLastProcessedTEAMPPStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> TEAMPPReleaseId;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgLastProcessedTEAMPPStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TEAMPPReleaseId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeechLanguageGet::rgfi_tclMsgSpeechLanguageGet(const rgfi_tclMsgSpeechLanguageGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeechLanguageGet& rgfi_tclMsgSpeechLanguageGet::operator=(const rgfi_tclMsgSpeechLanguageGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSpeechLanguageGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSpeechLanguageGet::u16GetFunctionID() const {return RGFI_C_U16_SPEECHLANGUAGE;}
tU8 rgfi_tclMsgSpeechLanguageGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgSpeechLanguageGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgSpeechLanguageGet::operator==(const rgfi_tclMsgSpeechLanguageGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSpeechLanguageGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSpeechLanguageGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeechLanguageStatus::rgfi_tclMsgSpeechLanguageStatus(const rgfi_tclMsgSpeechLanguageStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   LanguageID = coRef.LanguageID;
   Status = coRef.Status;
   SpeakerName = coRef.SpeakerName;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeechLanguageStatus& rgfi_tclMsgSpeechLanguageStatus::operator=(const rgfi_tclMsgSpeechLanguageStatus& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   Status = coRef.Status;
   SpeakerName = coRef.SpeakerName;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSpeechLanguageStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSpeechLanguageStatus::u16GetFunctionID() const {return RGFI_C_U16_SPEECHLANGUAGE;}
tU8 rgfi_tclMsgSpeechLanguageStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rgfi_tclMsgSpeechLanguageStatus::vDestroy()
{
   LanguageID.vDestroy(); 
   SpeakerName.vDestroy();
}

tU32 rgfi_tclMsgSpeechLanguageStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (25 <= u16MajorVersion)
   {
      u32DynamicSize += SpeakerName.u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+4;
}

tBool rgfi_tclMsgSpeechLanguageStatus::operator==(const rgfi_tclMsgSpeechLanguageStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LanguageID == rfoCmp.LanguageID);
      bResult = bResult && (Status == rfoCmp.Status);
      bResult = bResult && (SpeakerName == rfoCmp.SpeakerName);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSpeechLanguageStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> LanguageID;
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> Status;
   }
   if (25 <= oIn.u16GetMajorVersion())
   {
      oIn >> SpeakerName;
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSpeechLanguageStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << LanguageID;
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << Status;
   }
   if (25 <= oOut.u16GetMajorVersion())
   {
      oOut << SpeakerName;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeechMetricSystemGet::rgfi_tclMsgSpeechMetricSystemGet(const rgfi_tclMsgSpeechMetricSystemGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeechMetricSystemGet& rgfi_tclMsgSpeechMetricSystemGet::operator=(const rgfi_tclMsgSpeechMetricSystemGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSpeechMetricSystemGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSpeechMetricSystemGet::u16GetFunctionID() const {return RGFI_C_U16_SPEECHMETRICSYSTEM;}
tU8 rgfi_tclMsgSpeechMetricSystemGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgSpeechMetricSystemGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgSpeechMetricSystemGet::operator==(const rgfi_tclMsgSpeechMetricSystemGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSpeechMetricSystemGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSpeechMetricSystemGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeechMetricSystemStatus::rgfi_tclMsgSpeechMetricSystemStatus(const rgfi_tclMsgSpeechMetricSystemStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   MetricSystem_Nav = coRef.MetricSystem_Nav;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeechMetricSystemStatus& rgfi_tclMsgSpeechMetricSystemStatus::operator=(const rgfi_tclMsgSpeechMetricSystemStatus& coRef)
{
   if (this == &coRef) return *this;
   MetricSystem_Nav = coRef.MetricSystem_Nav;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSpeechMetricSystemStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSpeechMetricSystemStatus::u16GetFunctionID() const {return RGFI_C_U16_SPEECHMETRICSYSTEM;}
tU8 rgfi_tclMsgSpeechMetricSystemStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 rgfi_tclMsgSpeechMetricSystemStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool rgfi_tclMsgSpeechMetricSystemStatus::operator==(const rgfi_tclMsgSpeechMetricSystemStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MetricSystem_Nav == rfoCmp.MetricSystem_Nav);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSpeechMetricSystemStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> MetricSystem_Nav;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSpeechMetricSystemStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MetricSystem_Nav;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeechFeatureGet::rgfi_tclMsgSpeechFeatureGet(const rgfi_tclMsgSpeechFeatureGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeechFeatureGet& rgfi_tclMsgSpeechFeatureGet::operator=(const rgfi_tclMsgSpeechFeatureGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSpeechFeatureGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSpeechFeatureGet::u16GetFunctionID() const {return RGFI_C_U16_SPEECHFEATURE;}
tU8 rgfi_tclMsgSpeechFeatureGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgSpeechFeatureGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgSpeechFeatureGet::operator==(const rgfi_tclMsgSpeechFeatureGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSpeechFeatureGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSpeechFeatureGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeechFeatureStatus::rgfi_tclMsgSpeechFeatureStatus(const rgfi_tclMsgSpeechFeatureStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   CurrentSpeechFeature = coRef.CurrentSpeechFeature;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgSpeechFeatureStatus& rgfi_tclMsgSpeechFeatureStatus::operator=(const rgfi_tclMsgSpeechFeatureStatus& coRef)
{
   if (this == &coRef) return *this;
   CurrentSpeechFeature = coRef.CurrentSpeechFeature;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgSpeechFeatureStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgSpeechFeatureStatus::u16GetFunctionID() const {return RGFI_C_U16_SPEECHFEATURE;}
tU8 rgfi_tclMsgSpeechFeatureStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rgfi_tclMsgSpeechFeatureStatus::vDestroy()
{
   CurrentSpeechFeature.clear();
}

tU32 rgfi_tclMsgSpeechFeatureStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+CurrentSpeechFeature.size()*1;
}

tBool rgfi_tclMsgSpeechFeatureStatus::operator==(const rgfi_tclMsgSpeechFeatureStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CurrentSpeechFeature.size() == rfoCmp.CurrentSpeechFeature.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CurrentSpeechFeature.size()); ++u32Idx)
            bResult = bResult && (CurrentSpeechFeature[u32Idx] == rfoCmp.CurrentSpeechFeature[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rgfi_tclMsgSpeechFeatureStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      CurrentSpeechFeature.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CurrentSpeechFeature[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgSpeechFeatureStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)CurrentSpeechFeature.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CurrentSpeechFeature.size(); ++u32Idx)
         oOut << CurrentSpeechFeature[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastDrivingRecommendationGet::rgfi_tclMsgLastDrivingRecommendationGet(const rgfi_tclMsgLastDrivingRecommendationGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastDrivingRecommendationGet& rgfi_tclMsgLastDrivingRecommendationGet::operator=(const rgfi_tclMsgLastDrivingRecommendationGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgLastDrivingRecommendationGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgLastDrivingRecommendationGet::u16GetFunctionID() const {return RGFI_C_U16_LASTDRIVINGRECOMMENDATION;}
tU8 rgfi_tclMsgLastDrivingRecommendationGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgLastDrivingRecommendationGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgLastDrivingRecommendationGet::operator==(const rgfi_tclMsgLastDrivingRecommendationGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgLastDrivingRecommendationGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgLastDrivingRecommendationGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastDrivingRecommendationStatus::rgfi_tclMsgLastDrivingRecommendationStatus(const rgfi_tclMsgLastDrivingRecommendationStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   SpeechLanguage = coRef.SpeechLanguage;
   DrivingRecommendation = coRef.DrivingRecommendation;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgLastDrivingRecommendationStatus& rgfi_tclMsgLastDrivingRecommendationStatus::operator=(const rgfi_tclMsgLastDrivingRecommendationStatus& coRef)
{
   if (this == &coRef) return *this;
   SpeechLanguage = coRef.SpeechLanguage;
   DrivingRecommendation = coRef.DrivingRecommendation;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgLastDrivingRecommendationStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgLastDrivingRecommendationStatus::u16GetFunctionID() const {return RGFI_C_U16_LASTDRIVINGRECOMMENDATION;}
tU8 rgfi_tclMsgLastDrivingRecommendationStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rgfi_tclMsgLastDrivingRecommendationStatus::vDestroy()
{
   SpeechLanguage.vDestroy(); 
   DrivingRecommendation.vDestroy();
}

tU32 rgfi_tclMsgLastDrivingRecommendationStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+DrivingRecommendation.u32GetSize(u16MajorVersion);
}

tBool rgfi_tclMsgLastDrivingRecommendationStatus::operator==(const rgfi_tclMsgLastDrivingRecommendationStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SpeechLanguage == rfoCmp.SpeechLanguage);
      bResult = bResult && (DrivingRecommendation == rfoCmp.DrivingRecommendation);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgLastDrivingRecommendationStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> SpeechLanguage;
   oIn >> DrivingRecommendation;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgLastDrivingRecommendationStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << SpeechLanguage;
   oOut << DrivingRecommendation;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDataProcessedUpReg::rgfi_tclMsgDataProcessedUpReg(const rgfi_tclMsgDataProcessedUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDataProcessedUpReg& rgfi_tclMsgDataProcessedUpReg::operator=(const rgfi_tclMsgDataProcessedUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgDataProcessedUpReg::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgDataProcessedUpReg::u16GetFunctionID() const {return RGFI_C_U16_DATAPROCESSED;}
tU8 rgfi_tclMsgDataProcessedUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 rgfi_tclMsgDataProcessedUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgDataProcessedUpReg::operator==(const rgfi_tclMsgDataProcessedUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgDataProcessedUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgDataProcessedUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDataProcessedRelUpReg::rgfi_tclMsgDataProcessedRelUpReg(const rgfi_tclMsgDataProcessedRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDataProcessedRelUpReg& rgfi_tclMsgDataProcessedRelUpReg::operator=(const rgfi_tclMsgDataProcessedRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgDataProcessedRelUpReg::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgDataProcessedRelUpReg::u16GetFunctionID() const {return RGFI_C_U16_DATAPROCESSED;}
tU8 rgfi_tclMsgDataProcessedRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 rgfi_tclMsgDataProcessedRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgDataProcessedRelUpReg::operator==(const rgfi_tclMsgDataProcessedRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgDataProcessedRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgDataProcessedRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDataProcessedStatus::rgfi_tclMsgDataProcessedStatus(const rgfi_tclMsgDataProcessedStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgDataProcessedStatus& rgfi_tclMsgDataProcessedStatus::operator=(const rgfi_tclMsgDataProcessedStatus& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgDataProcessedStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgDataProcessedStatus::u16GetFunctionID() const {return RGFI_C_U16_DATAPROCESSED;}
tU8 rgfi_tclMsgDataProcessedStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 rgfi_tclMsgDataProcessedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgDataProcessedStatus::operator==(const rgfi_tclMsgDataProcessedStatus& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgDataProcessedStatus::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgDataProcessedStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgPredictiveCCStateGet::rgfi_tclMsgPredictiveCCStateGet(const rgfi_tclMsgPredictiveCCStateGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgPredictiveCCStateGet& rgfi_tclMsgPredictiveCCStateGet::operator=(const rgfi_tclMsgPredictiveCCStateGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgPredictiveCCStateGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgPredictiveCCStateGet::u16GetFunctionID() const {return RGFI_C_U16_PREDICTIVECCSTATE;}
tU8 rgfi_tclMsgPredictiveCCStateGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgPredictiveCCStateGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgPredictiveCCStateGet::operator==(const rgfi_tclMsgPredictiveCCStateGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgPredictiveCCStateGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgPredictiveCCStateGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgPredictiveCCStateUpReg::rgfi_tclMsgPredictiveCCStateUpReg(const rgfi_tclMsgPredictiveCCStateUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgPredictiveCCStateUpReg& rgfi_tclMsgPredictiveCCStateUpReg::operator=(const rgfi_tclMsgPredictiveCCStateUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgPredictiveCCStateUpReg::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgPredictiveCCStateUpReg::u16GetFunctionID() const {return RGFI_C_U16_PREDICTIVECCSTATE;}
tU8 rgfi_tclMsgPredictiveCCStateUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 rgfi_tclMsgPredictiveCCStateUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgPredictiveCCStateUpReg::operator==(const rgfi_tclMsgPredictiveCCStateUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgPredictiveCCStateUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgPredictiveCCStateUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgPredictiveCCStateRelUpReg::rgfi_tclMsgPredictiveCCStateRelUpReg(const rgfi_tclMsgPredictiveCCStateRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgPredictiveCCStateRelUpReg& rgfi_tclMsgPredictiveCCStateRelUpReg::operator=(const rgfi_tclMsgPredictiveCCStateRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgPredictiveCCStateRelUpReg::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgPredictiveCCStateRelUpReg::u16GetFunctionID() const {return RGFI_C_U16_PREDICTIVECCSTATE;}
tU8 rgfi_tclMsgPredictiveCCStateRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 rgfi_tclMsgPredictiveCCStateRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgPredictiveCCStateRelUpReg::operator==(const rgfi_tclMsgPredictiveCCStateRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgPredictiveCCStateRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgPredictiveCCStateRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgPredictiveCCStateStatus::rgfi_tclMsgPredictiveCCStateStatus(const rgfi_tclMsgPredictiveCCStateStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   IsCruiseControlActive = coRef.IsCruiseControlActive;
   OperationMode = coRef.OperationMode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgPredictiveCCStateStatus& rgfi_tclMsgPredictiveCCStateStatus::operator=(const rgfi_tclMsgPredictiveCCStateStatus& coRef)
{
   if (this == &coRef) return *this;
   IsCruiseControlActive = coRef.IsCruiseControlActive;
   OperationMode = coRef.OperationMode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgPredictiveCCStateStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgPredictiveCCStateStatus::u16GetFunctionID() const {return RGFI_C_U16_PREDICTIVECCSTATE;}
tU8 rgfi_tclMsgPredictiveCCStateStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 rgfi_tclMsgPredictiveCCStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool rgfi_tclMsgPredictiveCCStateStatus::operator==(const rgfi_tclMsgPredictiveCCStateStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (IsCruiseControlActive == rfoCmp.IsCruiseControlActive);
      bResult = bResult && (OperationMode == rfoCmp.OperationMode);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgPredictiveCCStateStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> IsCruiseControlActive;
   oIn >> OperationMode;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgPredictiveCCStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << IsCruiseControlActive;
   oOut << OperationMode;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgPredictiveCCSpeedRecommendationUpReg::rgfi_tclMsgPredictiveCCSpeedRecommendationUpReg(const rgfi_tclMsgPredictiveCCSpeedRecommendationUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgPredictiveCCSpeedRecommendationUpReg& rgfi_tclMsgPredictiveCCSpeedRecommendationUpReg::operator=(const rgfi_tclMsgPredictiveCCSpeedRecommendationUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgPredictiveCCSpeedRecommendationUpReg::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgPredictiveCCSpeedRecommendationUpReg::u16GetFunctionID() const {return RGFI_C_U16_PREDICTIVECCSPEEDRECOMMENDATION;}
tU8 rgfi_tclMsgPredictiveCCSpeedRecommendationUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 rgfi_tclMsgPredictiveCCSpeedRecommendationUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgPredictiveCCSpeedRecommendationUpReg::operator==(const rgfi_tclMsgPredictiveCCSpeedRecommendationUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgPredictiveCCSpeedRecommendationUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgPredictiveCCSpeedRecommendationUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgPredictiveCCSpeedRecommendationRelUpReg::rgfi_tclMsgPredictiveCCSpeedRecommendationRelUpReg(const rgfi_tclMsgPredictiveCCSpeedRecommendationRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgPredictiveCCSpeedRecommendationRelUpReg& rgfi_tclMsgPredictiveCCSpeedRecommendationRelUpReg::operator=(const rgfi_tclMsgPredictiveCCSpeedRecommendationRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgPredictiveCCSpeedRecommendationRelUpReg::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgPredictiveCCSpeedRecommendationRelUpReg::u16GetFunctionID() const {return RGFI_C_U16_PREDICTIVECCSPEEDRECOMMENDATION;}
tU8 rgfi_tclMsgPredictiveCCSpeedRecommendationRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 rgfi_tclMsgPredictiveCCSpeedRecommendationRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgPredictiveCCSpeedRecommendationRelUpReg::operator==(const rgfi_tclMsgPredictiveCCSpeedRecommendationRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgPredictiveCCSpeedRecommendationRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgPredictiveCCSpeedRecommendationRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgPredictiveCCSpeedRecommendationStatus::rgfi_tclMsgPredictiveCCSpeedRecommendationStatus(const rgfi_tclMsgPredictiveCCSpeedRecommendationStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ControlBits = coRef.ControlBits;
   TargetSpeed = coRef.TargetSpeed;
   Distance = coRef.Distance;
   RecuperationPower = coRef.RecuperationPower;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgPredictiveCCSpeedRecommendationStatus& rgfi_tclMsgPredictiveCCSpeedRecommendationStatus::operator=(const rgfi_tclMsgPredictiveCCSpeedRecommendationStatus& coRef)
{
   if (this == &coRef) return *this;
   ControlBits = coRef.ControlBits;
   TargetSpeed = coRef.TargetSpeed;
   Distance = coRef.Distance;
   RecuperationPower = coRef.RecuperationPower;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgPredictiveCCSpeedRecommendationStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgPredictiveCCSpeedRecommendationStatus::u16GetFunctionID() const {return RGFI_C_U16_PREDICTIVECCSPEEDRECOMMENDATION;}
tU8 rgfi_tclMsgPredictiveCCSpeedRecommendationStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 rgfi_tclMsgPredictiveCCSpeedRecommendationStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (34 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+10;
}

tBool rgfi_tclMsgPredictiveCCSpeedRecommendationStatus::operator==(const rgfi_tclMsgPredictiveCCSpeedRecommendationStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ControlBits == rfoCmp.ControlBits);
      bResult = bResult && (TargetSpeed == rfoCmp.TargetSpeed);
      bResult = bResult && (Distance == rfoCmp.Distance);
      bResult = bResult && (RecuperationPower == rfoCmp.RecuperationPower);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgPredictiveCCSpeedRecommendationStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ControlBits;
   oIn >> TargetSpeed;
   oIn >> Distance;
   if (34 <= oIn.u16GetMajorVersion())
   {
      oIn >> RecuperationPower;
   }
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgPredictiveCCSpeedRecommendationStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ControlBits;
   oOut << TargetSpeed;
   oOut << Distance;
   if (34 <= oOut.u16GetMajorVersion())
   {
      oOut << RecuperationPower;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgTrafficAnnouncementConfigurationUpReg::rgfi_tclMsgTrafficAnnouncementConfigurationUpReg(const rgfi_tclMsgTrafficAnnouncementConfigurationUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgTrafficAnnouncementConfigurationUpReg& rgfi_tclMsgTrafficAnnouncementConfigurationUpReg::operator=(const rgfi_tclMsgTrafficAnnouncementConfigurationUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgTrafficAnnouncementConfigurationUpReg::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgTrafficAnnouncementConfigurationUpReg::u16GetFunctionID() const {return RGFI_C_U16_TRAFFICANNOUNCEMENTCONFIGURATION;}
tU8 rgfi_tclMsgTrafficAnnouncementConfigurationUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 rgfi_tclMsgTrafficAnnouncementConfigurationUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgTrafficAnnouncementConfigurationUpReg::operator==(const rgfi_tclMsgTrafficAnnouncementConfigurationUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgTrafficAnnouncementConfigurationUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgTrafficAnnouncementConfigurationUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgTrafficAnnouncementConfigurationRelUpReg::rgfi_tclMsgTrafficAnnouncementConfigurationRelUpReg(const rgfi_tclMsgTrafficAnnouncementConfigurationRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgTrafficAnnouncementConfigurationRelUpReg& rgfi_tclMsgTrafficAnnouncementConfigurationRelUpReg::operator=(const rgfi_tclMsgTrafficAnnouncementConfigurationRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgTrafficAnnouncementConfigurationRelUpReg::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgTrafficAnnouncementConfigurationRelUpReg::u16GetFunctionID() const {return RGFI_C_U16_TRAFFICANNOUNCEMENTCONFIGURATION;}
tU8 rgfi_tclMsgTrafficAnnouncementConfigurationRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 rgfi_tclMsgTrafficAnnouncementConfigurationRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgTrafficAnnouncementConfigurationRelUpReg::operator==(const rgfi_tclMsgTrafficAnnouncementConfigurationRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgTrafficAnnouncementConfigurationRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgTrafficAnnouncementConfigurationRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgTrafficAnnouncementConfigurationGet::rgfi_tclMsgTrafficAnnouncementConfigurationGet(const rgfi_tclMsgTrafficAnnouncementConfigurationGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgTrafficAnnouncementConfigurationGet& rgfi_tclMsgTrafficAnnouncementConfigurationGet::operator=(const rgfi_tclMsgTrafficAnnouncementConfigurationGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgTrafficAnnouncementConfigurationGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgTrafficAnnouncementConfigurationGet::u16GetFunctionID() const {return RGFI_C_U16_TRAFFICANNOUNCEMENTCONFIGURATION;}
tU8 rgfi_tclMsgTrafficAnnouncementConfigurationGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgTrafficAnnouncementConfigurationGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgTrafficAnnouncementConfigurationGet::operator==(const rgfi_tclMsgTrafficAnnouncementConfigurationGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgTrafficAnnouncementConfigurationGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgTrafficAnnouncementConfigurationGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgTrafficAnnouncementConfigurationSet::rgfi_tclMsgTrafficAnnouncementConfigurationSet(const rgfi_tclMsgTrafficAnnouncementConfigurationSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   WarningDistanceThreshold = coRef.WarningDistanceThreshold;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgTrafficAnnouncementConfigurationSet& rgfi_tclMsgTrafficAnnouncementConfigurationSet::operator=(const rgfi_tclMsgTrafficAnnouncementConfigurationSet& coRef)
{
   if (this == &coRef) return *this;
   WarningDistanceThreshold = coRef.WarningDistanceThreshold;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgTrafficAnnouncementConfigurationSet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgTrafficAnnouncementConfigurationSet::u16GetFunctionID() const {return RGFI_C_U16_TRAFFICANNOUNCEMENTCONFIGURATION;}
tU8 rgfi_tclMsgTrafficAnnouncementConfigurationSet::u8GetOpCode() const {return CCA_C_U8_OPCODE_SET;}

tU32 rgfi_tclMsgTrafficAnnouncementConfigurationSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool rgfi_tclMsgTrafficAnnouncementConfigurationSet::operator==(const rgfi_tclMsgTrafficAnnouncementConfigurationSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (WarningDistanceThreshold == rfoCmp.WarningDistanceThreshold);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgTrafficAnnouncementConfigurationSet::oRead(fi_tclInContext& oIn)
{
   oIn >> WarningDistanceThreshold;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgTrafficAnnouncementConfigurationSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << WarningDistanceThreshold;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgTrafficAnnouncementConfigurationStatus::rgfi_tclMsgTrafficAnnouncementConfigurationStatus(const rgfi_tclMsgTrafficAnnouncementConfigurationStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   WarningDistanceThreshold = coRef.WarningDistanceThreshold;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgTrafficAnnouncementConfigurationStatus& rgfi_tclMsgTrafficAnnouncementConfigurationStatus::operator=(const rgfi_tclMsgTrafficAnnouncementConfigurationStatus& coRef)
{
   if (this == &coRef) return *this;
   WarningDistanceThreshold = coRef.WarningDistanceThreshold;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgTrafficAnnouncementConfigurationStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgTrafficAnnouncementConfigurationStatus::u16GetFunctionID() const {return RGFI_C_U16_TRAFFICANNOUNCEMENTCONFIGURATION;}
tU8 rgfi_tclMsgTrafficAnnouncementConfigurationStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 rgfi_tclMsgTrafficAnnouncementConfigurationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool rgfi_tclMsgTrafficAnnouncementConfigurationStatus::operator==(const rgfi_tclMsgTrafficAnnouncementConfigurationStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (WarningDistanceThreshold == rfoCmp.WarningDistanceThreshold);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgTrafficAnnouncementConfigurationStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> WarningDistanceThreshold;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgTrafficAnnouncementConfigurationStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << WarningDistanceThreshold;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgTM_HorizonEvents_FilterUpReg::rgfi_tclMsgTM_HorizonEvents_FilterUpReg(const rgfi_tclMsgTM_HorizonEvents_FilterUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgTM_HorizonEvents_FilterUpReg& rgfi_tclMsgTM_HorizonEvents_FilterUpReg::operator=(const rgfi_tclMsgTM_HorizonEvents_FilterUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgTM_HorizonEvents_FilterUpReg::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgTM_HorizonEvents_FilterUpReg::u16GetFunctionID() const {return RGFI_C_U16_TM_HORIZONEVENTS_FILTER;}
tU8 rgfi_tclMsgTM_HorizonEvents_FilterUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 rgfi_tclMsgTM_HorizonEvents_FilterUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgTM_HorizonEvents_FilterUpReg::operator==(const rgfi_tclMsgTM_HorizonEvents_FilterUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgTM_HorizonEvents_FilterUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgTM_HorizonEvents_FilterUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgTM_HorizonEvents_FilterRelUpReg::rgfi_tclMsgTM_HorizonEvents_FilterRelUpReg(const rgfi_tclMsgTM_HorizonEvents_FilterRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgTM_HorizonEvents_FilterRelUpReg& rgfi_tclMsgTM_HorizonEvents_FilterRelUpReg::operator=(const rgfi_tclMsgTM_HorizonEvents_FilterRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgTM_HorizonEvents_FilterRelUpReg::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgTM_HorizonEvents_FilterRelUpReg::u16GetFunctionID() const {return RGFI_C_U16_TM_HORIZONEVENTS_FILTER;}
tU8 rgfi_tclMsgTM_HorizonEvents_FilterRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 rgfi_tclMsgTM_HorizonEvents_FilterRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgTM_HorizonEvents_FilterRelUpReg::operator==(const rgfi_tclMsgTM_HorizonEvents_FilterRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgTM_HorizonEvents_FilterRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgTM_HorizonEvents_FilterRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgTM_HorizonEvents_FilterGet::rgfi_tclMsgTM_HorizonEvents_FilterGet(const rgfi_tclMsgTM_HorizonEvents_FilterGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgTM_HorizonEvents_FilterGet& rgfi_tclMsgTM_HorizonEvents_FilterGet::operator=(const rgfi_tclMsgTM_HorizonEvents_FilterGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgTM_HorizonEvents_FilterGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgTM_HorizonEvents_FilterGet::u16GetFunctionID() const {return RGFI_C_U16_TM_HORIZONEVENTS_FILTER;}
tU8 rgfi_tclMsgTM_HorizonEvents_FilterGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgTM_HorizonEvents_FilterGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgTM_HorizonEvents_FilterGet::operator==(const rgfi_tclMsgTM_HorizonEvents_FilterGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgTM_HorizonEvents_FilterGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgTM_HorizonEvents_FilterGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgTM_HorizonEvents_FilterSet::rgfi_tclMsgTM_HorizonEvents_FilterSet(const rgfi_tclMsgTM_HorizonEvents_FilterSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   ReleaseId = coRef.ReleaseId;
   NEVList = coRef.NEVList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgTM_HorizonEvents_FilterSet& rgfi_tclMsgTM_HorizonEvents_FilterSet::operator=(const rgfi_tclMsgTM_HorizonEvents_FilterSet& coRef)
{
   if (this == &coRef) return *this;
   ReleaseId = coRef.ReleaseId;
   NEVList = coRef.NEVList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgTM_HorizonEvents_FilterSet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgTM_HorizonEvents_FilterSet::u16GetFunctionID() const {return RGFI_C_U16_TM_HORIZONEVENTS_FILTER;}
tU8 rgfi_tclMsgTM_HorizonEvents_FilterSet::u8GetOpCode() const {return CCA_C_U8_OPCODE_SET;}

tVoid rgfi_tclMsgTM_HorizonEvents_FilterSet::vDestroy()
{
   NEVList.vDestroy(); 
}

tU32 rgfi_tclMsgTM_HorizonEvents_FilterSet::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+NEVList.u32GetSize(u16MajorVersion);
}

tBool rgfi_tclMsgTM_HorizonEvents_FilterSet::operator==(const rgfi_tclMsgTM_HorizonEvents_FilterSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ReleaseId == rfoCmp.ReleaseId);
      bResult = bResult && (NEVList == rfoCmp.NEVList);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgTM_HorizonEvents_FilterSet::oRead(fi_tclInContext& oIn)
{
   oIn >> ReleaseId;
   oIn >> NEVList;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgTM_HorizonEvents_FilterSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ReleaseId;
   oOut << NEVList;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgTM_HorizonEvents_FilterStatus::rgfi_tclMsgTM_HorizonEvents_FilterStatus(const rgfi_tclMsgTM_HorizonEvents_FilterStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ReleaseId = coRef.ReleaseId;
   NEVList = coRef.NEVList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgTM_HorizonEvents_FilterStatus& rgfi_tclMsgTM_HorizonEvents_FilterStatus::operator=(const rgfi_tclMsgTM_HorizonEvents_FilterStatus& coRef)
{
   if (this == &coRef) return *this;
   ReleaseId = coRef.ReleaseId;
   NEVList = coRef.NEVList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgTM_HorizonEvents_FilterStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgTM_HorizonEvents_FilterStatus::u16GetFunctionID() const {return RGFI_C_U16_TM_HORIZONEVENTS_FILTER;}
tU8 rgfi_tclMsgTM_HorizonEvents_FilterStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rgfi_tclMsgTM_HorizonEvents_FilterStatus::vDestroy()
{
   NEVList.vDestroy(); 
}

tU32 rgfi_tclMsgTM_HorizonEvents_FilterStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+NEVList.u32GetSize(u16MajorVersion);
}

tBool rgfi_tclMsgTM_HorizonEvents_FilterStatus::operator==(const rgfi_tclMsgTM_HorizonEvents_FilterStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ReleaseId == rfoCmp.ReleaseId);
      bResult = bResult && (NEVList == rfoCmp.NEVList);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgTM_HorizonEvents_FilterStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ReleaseId;
   oIn >> NEVList;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgTM_HorizonEvents_FilterStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ReleaseId;
   oOut << NEVList;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgEngineeringTextGet::rgfi_tclMsgEngineeringTextGet(const rgfi_tclMsgEngineeringTextGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgEngineeringTextGet& rgfi_tclMsgEngineeringTextGet::operator=(const rgfi_tclMsgEngineeringTextGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgEngineeringTextGet::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgEngineeringTextGet::u16GetFunctionID() const {return RGFI_C_U16_ENGINEERINGTEXT;}
tU8 rgfi_tclMsgEngineeringTextGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rgfi_tclMsgEngineeringTextGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgEngineeringTextGet::operator==(const rgfi_tclMsgEngineeringTextGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgEngineeringTextGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgEngineeringTextGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgEngineeringTextUpReg::rgfi_tclMsgEngineeringTextUpReg(const rgfi_tclMsgEngineeringTextUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgEngineeringTextUpReg& rgfi_tclMsgEngineeringTextUpReg::operator=(const rgfi_tclMsgEngineeringTextUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgEngineeringTextUpReg::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgEngineeringTextUpReg::u16GetFunctionID() const {return RGFI_C_U16_ENGINEERINGTEXT;}
tU8 rgfi_tclMsgEngineeringTextUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 rgfi_tclMsgEngineeringTextUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgEngineeringTextUpReg::operator==(const rgfi_tclMsgEngineeringTextUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgEngineeringTextUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgEngineeringTextUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgEngineeringTextRelUpReg::rgfi_tclMsgEngineeringTextRelUpReg(const rgfi_tclMsgEngineeringTextRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgEngineeringTextRelUpReg& rgfi_tclMsgEngineeringTextRelUpReg::operator=(const rgfi_tclMsgEngineeringTextRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgEngineeringTextRelUpReg::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgEngineeringTextRelUpReg::u16GetFunctionID() const {return RGFI_C_U16_ENGINEERINGTEXT;}
tU8 rgfi_tclMsgEngineeringTextRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 rgfi_tclMsgEngineeringTextRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rgfi_tclMsgEngineeringTextRelUpReg::operator==(const rgfi_tclMsgEngineeringTextRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rgfi_tclMsgEngineeringTextRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgEngineeringTextRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgEngineeringTextStatus::rgfi_tclMsgEngineeringTextStatus(const rgfi_tclMsgEngineeringTextStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Message = coRef.Message;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rgfi_tclMsgEngineeringTextStatus& rgfi_tclMsgEngineeringTextStatus::operator=(const rgfi_tclMsgEngineeringTextStatus& coRef)
{
   if (this == &coRef) return *this;
   Message = coRef.Message;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rgfi_tclMsgEngineeringTextStatus::u16GetServiceID() const {return RGFI_C_U16_SERVICE_ID;}
tU16 rgfi_tclMsgEngineeringTextStatus::u16GetFunctionID() const {return RGFI_C_U16_ENGINEERINGTEXT;}
tU8 rgfi_tclMsgEngineeringTextStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rgfi_tclMsgEngineeringTextStatus::vDestroy()
{
   Message.vDestroy();
}

tU32 rgfi_tclMsgEngineeringTextStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Message.u32GetSize(u16MajorVersion);
}

tBool rgfi_tclMsgEngineeringTextStatus::operator==(const rgfi_tclMsgEngineeringTextStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Message == rfoCmp.Message);
   return bResult;
}

fi_tclInContext& rgfi_tclMsgEngineeringTextStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Message;
   return oIn;
}

fi_tclOutContext& rgfi_tclMsgEngineeringTextStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Message;
   return oOut;
}

