#ifndef __RGFIDEBUGVISITOR_H__
#define __RGFIDEBUGVISITOR_H__

class MY_DECL rgfi_tclPrintVisitor : public rgfi_tclVisitorBase {

private:
   /* default constructor */ rgfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   rgfi_tclPrintVisitor(fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Reserved(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u8_Percent(fi_tcl_u8_Percent& o_u8_Percent);
   virtual tVoid vVisit_s16_PerThousand(fi_tcl_s16_PerThousand& o_s16_PerThousand);
   virtual tVoid vVisit_u16_IndexInReferenceList(fi_tcl_u16_IndexInReferenceList& o_u16_IndexInReferenceList);
   virtual tVoid vVisit_s32_Kilogram(fi_tcl_s32_Kilogram& o_s32_Kilogram);
   virtual tVoid vVisit_s32_Pound(fi_tcl_s32_Pound& o_s32_Pound);
   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& o_s32_Meter);
   virtual tVoid vVisit_s32_Yards(fi_tcl_s32_Yards& o_s32_Yards);
   virtual tVoid vVisit_s32_Centimeter(fi_tcl_s32_Centimeter& o_s32_Centimeter);
   virtual tVoid vVisit_s32_Inch(fi_tcl_s32_Inch& o_s32_Inch);
   virtual tVoid vVisit_s32_Microliter(fi_tcl_s32_Microliter& o_s32_Microliter);
   virtual tVoid vVisit_s32_Second(fi_tcl_s32_Second& o_s32_Second);
   virtual tBool bDoExpand_POSIXTime(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DST_State(fi_tcl_e8_DST_State& o_e8_DST_State);
   virtual tBool bDoExpand_TimeZoneElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s16_KmPerHour(fi_tcl_s16_KmPerHour& o_s16_KmPerHour);
   virtual tVoid vVisit_s16_MilesPerHour(fi_tcl_s16_MilesPerHour& o_s16_MilesPerHour);
   virtual tVoid vVisit_s16_CentimeterSecond(fi_tcl_s16_CentimeterSecond& o_s16_CentimeterSecond);
   virtual tVoid vVisit_s32_Watt(fi_tcl_s32_Watt& o_s32_Watt);
   virtual tBool bDoExpand_FIVersion(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tBool bDoExpand_PositionWGS84(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_e16_ISOLanguageCode(fi_tcl_e16_ISOLanguageCode& o_e16_ISOLanguageCode);
   virtual tBool bDoExpand_LanguageID(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u8_DirectionAbsolute(fi_tcl_u8_DirectionAbsolute& o_u8_DirectionAbsolute);
   virtual tVoid vVisit_u8_DirectionRelative(fi_tcl_u8_DirectionRelative& o_u8_DirectionRelative);
   virtual tVoid vVisit_e8_FuelType(fi_tcl_e8_FuelType& o_e8_FuelType);
   virtual tBool bDoExpand_DistTimeFuel(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_ShapeType(fi_tcl_e8_ShapeType& o_e8_ShapeType);
   virtual tBool bDoExpand_Shape(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RDBId(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMProgramService(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMServiceProvider(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TMCategory(fi_tcl_e8_TMCategory& o_e8_TMCategory);
   virtual tVoid vVisit_b8_TMMappingPossibility(fi_tcl_b8_TMMappingPossibility& o_b8_TMMappingPossibility);
   virtual tVoid vVisit_b8_TMMappingStatus(fi_tcl_b8_TMMappingStatus& o_b8_TMMappingStatus);
   virtual tVoid vVisit_e8_TMValueStatus(fi_tcl_e8_TMValueStatus& o_e8_TMValueStatus);
   virtual tVoid vVisit_e8_TMGeometricMessageType(fi_tcl_e8_TMGeometricMessageType& o_e8_TMGeometricMessageType);
   virtual tVoid vVisit_e8_TMFlowImpact(fi_tcl_e8_TMFlowImpact& o_e8_TMFlowImpact);
   virtual tVoid vVisit_e8_TMUrgency(fi_tcl_e8_TMUrgency& o_e8_TMUrgency);
   virtual tVoid vVisit_e8_TMGeographicalPathRelationType(fi_tcl_e8_TMGeographicalPathRelationType& o_e8_TMGeographicalPathRelationType);
   virtual tVoid vVisit_b8_TMRelevance(fi_tcl_b8_TMRelevance& o_b8_TMRelevance);
   virtual tBool bDoExpand_TMCStructuredText(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TrafficMsgType(fi_tcl_e8_TrafficMsgType& o_e8_TrafficMsgType);
   virtual tVoid vVisit_e16_NaviEventValue(fi_tcl_e16_NaviEventValue& o_e16_NaviEventValue);
   virtual tVoid vVisit_e8_MetricSystem(fi_tcl_e8_MetricSystem& o_e8_MetricSystem);
   virtual tVoid vVisit_b8_GuidanceMode(fi_tcl_b8_GuidanceMode& o_b8_GuidanceMode);
   virtual tVoid vVisit_b8_GuidanceStatus(fi_tcl_b8_GuidanceStatus& o_b8_GuidanceStatus);
   virtual tVoid vVisit_e8_DataCarrierRequestStatus(fi_tcl_e8_DataCarrierRequestStatus& o_e8_DataCarrierRequestStatus);
   virtual tVoid vVisit_e8_GuidanceElement(fi_tcl_e8_GuidanceElement& o_e8_GuidanceElement);
   virtual tVoid vVisit_b8_GuidanceElementAttribute(fi_tcl_b8_GuidanceElementAttribute& o_b8_GuidanceElementAttribute);
   virtual tBool bDoExpand_RoadNameList(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_RoadNumberStatus(fi_tcl_b8_RoadNumberStatus& o_b8_RoadNumberStatus);
   virtual tVoid vVisit_e8_SignPostDestType(fi_tcl_e8_SignPostDestType& o_e8_SignPostDestType);
   virtual tVoid vVisit_e8_BaseTrafficSignCategory(fi_tcl_e8_BaseTrafficSignCategory& o_e8_BaseTrafficSignCategory);
   virtual tVoid vVisit_s32_EMU(fi_tcl_s32_EMU& o_s32_EMU);
   virtual tVoid vVisit_e8_GuidanceDescriptorInfoCategory(fi_tcl_e8_GuidanceDescriptorInfoCategory& o_e8_GuidanceDescriptorInfoCategory);
   virtual tBool bDoExpand_GuidanceDescriptorInfoCategory(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_GuidanceDescriptorInfoCategoryRefElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_GuidanceSymbol(fi_tcl_e8_GuidanceSymbol& o_e8_GuidanceSymbol);
   virtual tBool bDoExpand_GuidanceElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_GuidanceStatusSymbol(fi_tcl_e8_GuidanceStatusSymbol& o_e8_GuidanceStatusSymbol);
   virtual tBool bDoExpand_RoadNameElementList(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CombinedStatus(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_SingleRoadInfoCategory(fi_tcl_e8_SingleRoadInfoCategory& o_e8_SingleRoadInfoCategory);
   virtual tVoid vVisit_b8_GuidanceSymbolAttributes(fi_tcl_b8_GuidanceSymbolAttributes& o_b8_GuidanceSymbolAttributes);
   virtual tBool bDoExpand_CompassDirection(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_GuidanceManoeuvreSymbol(fi_tcl_e8_GuidanceManoeuvreSymbol& o_e8_GuidanceManoeuvreSymbol);
   virtual tVoid vVisit_e8_IntersectionType(fi_tcl_e8_IntersectionType& o_e8_IntersectionType);
   virtual tVoid vVisit_e8_GuidanceManoeuvreType(fi_tcl_e8_GuidanceManoeuvreType& o_e8_GuidanceManoeuvreType);
   virtual tBool bDoExpand_SingleRoadInfo(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_GuidanceSymbolStatus(fi_tcl_b8_GuidanceSymbolStatus& o_b8_GuidanceSymbolStatus);
   virtual tBool bDoExpand_SingleRoadInfoElementList(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_EntryPointState(fi_tcl_e8_EntryPointState& o_e8_EntryPointState);
   virtual tVoid vVisit_e8_GuidanceDestinationType(fi_tcl_e8_GuidanceDestinationType& o_e8_GuidanceDestinationType);
   virtual tVoid vVisit_e8_SideInfo(fi_tcl_e8_SideInfo& o_e8_SideInfo);
   virtual tVoid vVisit_e8_RoundaboutSymbolType(fi_tcl_e8_RoundaboutSymbolType& o_e8_RoundaboutSymbolType);
   virtual tBool bDoExpand_RoadNumber(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_RoadClassCode(fi_tcl_e8_RoadClassCode& o_e8_RoadClassCode);
   virtual tBool bDoExpand_SectionCharacteristics(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TurnToSymbol(fi_tcl_e8_TurnToSymbol& o_e8_TurnToSymbol);
   virtual tVoid vVisit_u8_DrivingDirection(fi_tcl_u8_DrivingDirection& o_u8_DrivingDirection);
   virtual tBool bDoExpand_LaneChangeSymbol(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadNumberElementList(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_BargraphDistance(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_GuidanceManeuverElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b32_RoadProperty(fi_tcl_b32_RoadProperty& o_b32_RoadProperty);
   virtual tVoid vVisit_e8_NavStreetType(fi_tcl_e8_NavStreetType& o_e8_NavStreetType);
   virtual tVoid vVisit_b8_GuidanceMessageCategory(fi_tcl_b8_GuidanceMessageCategory& o_b8_GuidanceMessageCategory);
   virtual tVoid vVisit_b8_WarningPointStatus(fi_tcl_b8_WarningPointStatus& o_b8_WarningPointStatus);
   virtual tVoid vVisit_b8_HorizonEventStatus(fi_tcl_b8_HorizonEventStatus& o_b8_HorizonEventStatus);
   virtual tVoid vVisit_b32_TrafficMessageSource(fi_tcl_b32_TrafficMessageSource& o_b32_TrafficMessageSource);
   virtual tVoid vVisit_u16_UserTrafficMessageHandle(fi_tcl_u16_UserTrafficMessageHandle& o_u16_UserTrafficMessageHandle);
   virtual tVoid vVisit_e8_SpeedLimitExceedingStatus(fi_tcl_e8_SpeedLimitExceedingStatus& o_e8_SpeedLimitExceedingStatus);
   virtual tVoid vVisit_e8_TrafficSignQuantifier(fi_tcl_e8_TrafficSignQuantifier& o_e8_TrafficSignQuantifier);
   virtual tVoid vVisit_e8_WarningSignCriticality(fi_tcl_e8_WarningSignCriticality& o_e8_WarningSignCriticality);
   virtual tVoid vVisit_e16_AdditionalTrafficSign(fi_tcl_e16_AdditionalTrafficSign& o_e16_AdditionalTrafficSign);
   virtual tVoid vVisit_b32_POICategory(fi_tcl_b32_POICategory& o_b32_POICategory);
   virtual tVoid vVisit_e8_RoadAttriuteInfo(fi_tcl_e8_RoadAttriuteInfo& o_e8_RoadAttriuteInfo);
   virtual tBool bDoExpand_RoadAttributeInfo(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_RequiredPermission(fi_tcl_e8_RequiredPermission& o_e8_RequiredPermission);
   virtual tVoid vVisit_e8_WarningPointDataType(fi_tcl_e8_WarningPointDataType& o_e8_WarningPointDataType);
   virtual tVoid vVisit_e8_HorizonEventDataType(fi_tcl_e8_HorizonEventDataType& o_e8_HorizonEventDataType);
   virtual tBool bDoExpand_UPOI_Category(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NextWarningPoint(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TEAEventType(fi_tcl_e8_TEAEventType& o_e8_TEAEventType);
   virtual tVoid vVisit_b8_WarningsOnHorizonMode(fi_tcl_b8_WarningsOnHorizonMode& o_b8_WarningsOnHorizonMode);
   virtual tVoid vVisit_e8_MultiMediaFunction(fi_tcl_e8_MultiMediaFunction& o_e8_MultiMediaFunction);
   virtual tVoid vVisit_e8_MultiMediaType(fi_tcl_e8_MultiMediaType& o_e8_MultiMediaType);
   virtual tVoid vVisit_e8_MultiMediaStatus(fi_tcl_e8_MultiMediaStatus& o_e8_MultiMediaStatus);
   virtual tBool bDoExpand_MultiMediaDescriptor(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MultiMediaElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NEVList(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b16_FunctionalityGroupRouteInfo(fi_tcl_b16_FunctionalityGroupRouteInfo& o_b16_FunctionalityGroupRouteInfo);
   virtual tVoid vVisit_b16_FunctionalityGroupDestinationInfo(fi_tcl_b16_FunctionalityGroupDestinationInfo& o_b16_FunctionalityGroupDestinationInfo);
   virtual tVoid vVisit_b16_FunctionalityGroupDrivingRecommendation(fi_tcl_b16_FunctionalityGroupDrivingRecommendation& o_b16_FunctionalityGroupDrivingRecommendation);
   virtual tVoid vVisit_b16_FunctionalityGroupCorridorInfo(fi_tcl_b16_FunctionalityGroupCorridorInfo& o_b16_FunctionalityGroupCorridorInfo);
   virtual tVoid vVisit_b16_FunctionalityGroupHorizonInfoTrafficMessage(fi_tcl_b16_FunctionalityGroupHorizonInfoTrafficMessage& o_b16_FunctionalityGroupHorizonInfoTrafficMessage);
   virtual tVoid vVisit_b16_FunctionalityGroupHorizonInfoSpeedLimit(fi_tcl_b16_FunctionalityGroupHorizonInfoSpeedLimit& o_b16_FunctionalityGroupHorizonInfoSpeedLimit);
   virtual tVoid vVisit_b16_FunctionalityGroupHorizonInfoWarningSign(fi_tcl_b16_FunctionalityGroupHorizonInfoWarningSign& o_b16_FunctionalityGroupHorizonInfoWarningSign);
   virtual tVoid vVisit_b16_FunctionalityGroupHorizonInfoPOI(fi_tcl_b16_FunctionalityGroupHorizonInfoPOI& o_b16_FunctionalityGroupHorizonInfoPOI);
   virtual tVoid vVisit_b16_FunctionalityGroupHorizonInfoRoadAttribute(fi_tcl_b16_FunctionalityGroupHorizonInfoRoadAttribute& o_b16_FunctionalityGroupHorizonInfoRoadAttribute);
   virtual tVoid vVisit_b16_FunctionalityGroupHorizonInfoCurve(fi_tcl_b16_FunctionalityGroupHorizonInfoCurve& o_b16_FunctionalityGroupHorizonInfoCurve);
   virtual tVoid vVisit_b16_FunctionalityGroupDriverSpeedAdvice(fi_tcl_b16_FunctionalityGroupDriverSpeedAdvice& o_b16_FunctionalityGroupDriverSpeedAdvice);
   virtual tVoid vVisit_b16_HorizonEventTrafficSignSettings(fi_tcl_b16_HorizonEventTrafficSignSettings& o_b16_HorizonEventTrafficSignSettings);
   virtual tBool bDoExpand_HorizonEventsFilter_TrafficSign(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b16_FunctionalityGroupHorizonInfoTollBooth(fi_tcl_b16_FunctionalityGroupHorizonInfoTollBooth& o_b16_FunctionalityGroupHorizonInfoTollBooth);
   virtual tVoid vVisit_b32_HorizonEventFilterPOI(fi_tcl_b32_HorizonEventFilterPOI& o_b32_HorizonEventFilterPOI);
   virtual tVoid vVisit_b8_TrafficMessageSettings(fi_tcl_b8_TrafficMessageSettings& o_b8_TrafficMessageSettings);
   virtual tBool bDoExpand_HorizonEvent_TMConfiguration(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_HorizonEventsFilter_TrafficMessage(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_HorizonEventsFilter_POI(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_HorizonEventsFilter_TollBooth(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_HorizonEventsFilter_RoadAttribute(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DriverSpeedAdviceConfiguration(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_UPOI_AnnouncementDistance(fi_tcl_e8_UPOI_AnnouncementDistance& o_e8_UPOI_AnnouncementDistance);
   virtual tBool bDoExpand_SpeedLimitParameter(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DriverAdviceType(fi_tcl_e8_DriverAdviceType& o_e8_DriverAdviceType);
   virtual tVoid vVisit_e8_DriverActionFeedback(fi_tcl_e8_DriverActionFeedback& o_e8_DriverActionFeedback);
   virtual tVoid vVisit_b32_PredictiveCCMode(fi_tcl_b32_PredictiveCCMode& o_b32_PredictiveCCMode);
   virtual tVoid vVisit_b32_PredictiveCC_ControlBits(fi_tcl_b32_PredictiveCC_ControlBits& o_b32_PredictiveCC_ControlBits);
   virtual tVoid vVisit_e8_SpeedLimitLocation(fi_tcl_e8_SpeedLimitLocation& o_e8_SpeedLimitLocation);
   virtual tBool bDoExpand_LocDepSpeedLimitExceeding(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_VoiceGender(fi_tcl_e8_VoiceGender& o_e8_VoiceGender);
   virtual tBool bDoExpand_Language(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Sentence(fi_tcl_e8_Sentence& o_e8_Sentence);
   virtual tVoid vVisit_e8_SpeechFeature(fi_tcl_e8_SpeechFeature& o_e8_SpeechFeature);
   virtual tVoid vVisit_e8_SpeechStatus(fi_tcl_e8_SpeechStatus& o_e8_SpeechStatus);
   virtual tVoid vVisit_e8_DebugSound(fi_tcl_e8_DebugSound& o_e8_DebugSound);
   virtual tVoid vVisit_e8_EventType(fi_tcl_e8_EventType& o_e8_EventType);
   virtual tVoid vVisit_e8_TMLocationType(fi_tcl_e8_TMLocationType& o_e8_TMLocationType);
   virtual tVoid vVisit_e16_EffectCode(fi_tcl_e16_EffectCode& o_e16_EffectCode);
   virtual tVoid vVisit_e16_CauseCode(fi_tcl_e16_CauseCode& o_e16_CauseCode);
   virtual tVoid vVisit_e8_Tendency(fi_tcl_e8_Tendency& o_e8_Tendency);
   virtual tBool bDoExpand_TMEvent(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMCodedMessage(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMInfo(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_BinContainerTypes(fi_tcl_e8_BinContainerTypes& o_e8_BinContainerTypes);
#ifndef FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_TMCodedMessageBinContainer(rgfi_tclSemanticDomain::tenType enSemantic);
#endif // FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_ReferenceElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_RoadNetworkClass(fi_tcl_e8_RoadNetworkClass& o_e8_RoadNetworkClass);
   virtual tBool bDoExpand_RoadAttributes(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StateNameElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CountyNameElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CityDistrictNameElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_BuildUpAreaNameElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SideRoad(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoundaboutSideRoad(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RequiredTaxDisc(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_RequiredPermissionType(fi_tcl_e8_RequiredPermissionType& o_e8_RequiredPermissionType);
   virtual tBool bDoExpand_RequiredPermission(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_GenericRequiredPermission(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RequiredPermissionInfo(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RequiredPermissionList(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CountryNameElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CityNameElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadNameListSet(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadNumberListSet(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IntersectionNameElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_LaneStatus(fi_tcl_e8_LaneStatus& o_e8_LaneStatus);
   virtual tBool bDoExpand_RoadNameElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IntersectionNumberElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SignPostDestDirection(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_LaneType(fi_tcl_b8_LaneType& o_b8_LaneType);
   virtual tBool bDoExpand_RoadNumberList(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoundaboutSymbol(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u32_DataSetId(fi_tcl_u32_DataSetId& o_u32_DataSetId);
   virtual tBool bDoExpand_RoadId(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_NavOneCellDirection(fi_tcl_e8_NavOneCellDirection& o_e8_NavOneCellDirection);
   virtual tVoid vVisit_b8_LaneChangeRestriction(fi_tcl_b8_LaneChangeRestriction& o_b8_LaneChangeRestriction);
   virtual tVoid vVisit_e8_ManoeuvreCriticality(fi_tcl_e8_ManoeuvreCriticality& o_e8_ManoeuvreCriticality);
   virtual tBool bDoExpand_RoadDescription(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_ExtraDescElementType(fi_tcl_e8_ExtraDescElementType& o_e8_ExtraDescElementType);
   virtual tBool bDoExpand_ExtraDescElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b32_DataProperties(fi_tcl_b32_DataProperties& o_b32_DataProperties);
   virtual tBool bDoExpand_DataDescElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_CrossroadProperties(fi_tcl_b8_CrossroadProperties& o_b8_CrossroadProperties);
   virtual tBool bDoExpand_CrossroadDesc(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_CrossroadInfoCategory(fi_tcl_e8_CrossroadInfoCategory& o_e8_CrossroadInfoCategory);
   virtual tBool bDoExpand_CrossroadInfo(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IntersectionDenotation(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IntersectionDescElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_AdditionalTrafficSign(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_SpeedSign(fi_tcl_e8_SpeedSign& o_e8_SpeedSign);
   virtual tVoid vVisit_e16_WarningSign(fi_tcl_e16_WarningSign& o_e16_WarningSign);
   virtual tVoid vVisit_e16_RegulatorySign(fi_tcl_e16_RegulatorySign& o_e16_RegulatorySign);
   virtual tBool bDoExpand_TrafficSignElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_TimeDependentString(fi_tcl_TimeDependentString& o_TimeDependentString);
   virtual tVoid vVisit_b8_LaneDependentValidity(fi_tcl_b8_LaneDependentValidity& o_b8_LaneDependentValidity);
   virtual tBool bDoExpand_WarningSign(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SpeedLimitSign(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TrafficSignElementList(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TrafficSignList(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_POIElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_POI(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_RouteProperties(fi_tcl_b8_RouteProperties& o_b8_RouteProperties);
   virtual tBool bDoExpand_MostWorseManoeuvreInfo(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CriticalManoeuvreInfo(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TurnToSymbol(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TollBoothElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PointOfInterestElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UnspecifiedText(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_GuidanceMapManeuverElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavOneCell(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DestinationReachedSymbol(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IntersectionDescElementList(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneDirection(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_NavOneCellCategory(fi_tcl_e8_NavOneCellCategory& o_e8_NavOneCellCategory);
   virtual tVoid vVisit_e8_SignPostDestinationCategory(fi_tcl_e8_SignPostDestinationCategory& o_e8_SignPostDestinationCategory);
   virtual tVoid vVisit_e8_SignPostDestStatus(fi_tcl_e8_SignPostDestStatus& o_e8_SignPostDestStatus);
   virtual tVoid vVisit_e8_DirectionStatus(fi_tcl_e8_DirectionStatus& o_e8_DirectionStatus);
   virtual tVoid vVisit_e8_DirectionCategory(fi_tcl_e8_DirectionCategory& o_e8_DirectionCategory);
   virtual tVoid vVisit_b8_DirectionInfoStatus(fi_tcl_b8_DirectionInfoStatus& o_b8_DirectionInfoStatus);
   virtual tBool bDoExpand_DirectionCategory(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DirectionInfo(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SignPostDestination(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SignPostElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SignPostElementList(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DirectionInfoList(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_SignPostInfoStatus(fi_tcl_b8_SignPostInfoStatus& o_b8_SignPostInfoStatus);
   virtual tBool bDoExpand_TrafficMessage(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_EntryPointSymbol(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u32_SquareDecimeter(fi_tcl_u32_SquareDecimeter& o_u32_SquareDecimeter);
   virtual tVoid vVisit_u32_Milliliter(fi_tcl_u32_Milliliter& o_u32_Milliliter);
   virtual tVoid vVisit_u32_Microliter(fi_tcl_u32_Microliter& o_u32_Microliter);
   virtual tBool bDoExpand_AvailablePermission(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u16_RouteHandle(fi_tcl_u16_RouteHandle& o_u16_RouteHandle);
   virtual tVoid vVisit_u16_TripSegmentNumber(fi_tcl_u16_TripSegmentNumber& o_u16_TripSegmentNumber);
   virtual tBool bDoExpand_UserPermissionProfile(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_NavAreaType(fi_tcl_e8_NavAreaType& o_e8_NavAreaType);
   virtual tVoid vVisit_e8_VehicleType(fi_tcl_e8_VehicleType& o_e8_VehicleType);
   virtual tBool bDoExpand_Speedvector(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_CargoInfo(fi_tcl_b8_CargoInfo& o_b8_CargoInfo);
   virtual tBool bDoExpand_VehicleProfile(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UserSpeedProfile(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_FuelConsumptionProfile(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_ThresholdDefinitionProfile(fi_tcl_b8_ThresholdDefinitionProfile& o_b8_ThresholdDefinitionProfile);
   virtual tBool bDoExpand_ThresholdDefinitionProfile(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_UserProfiles(fi_tcl_b8_UserProfiles& o_b8_UserProfiles);
   virtual tVoid vVisit_e8_VehicleClass(fi_tcl_e8_VehicleClass& o_e8_VehicleClass);
   virtual tVoid vVisit_e8_Gearbox(fi_tcl_e8_Gearbox& o_e8_Gearbox);
   virtual tVoid vVisit_e8_DriveMode(fi_tcl_e8_DriveMode& o_e8_DriveMode);
   virtual tBool bDoExpand_VehicleParameter(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DriverType(fi_tcl_e8_DriverType& o_e8_DriverType);
   virtual tBool bDoExpand_DriverParameter(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_GreenProfile(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UserProfiles(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NextTrafficEvent(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_LaneReferenceCategory(fi_tcl_e8_LaneReferenceCategory& o_e8_LaneReferenceCategory);
   virtual tBool bDoExpand_LaneReference(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfo(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u8_IndexInLaneInfoSegmentList(fi_tcl_u8_IndexInLaneInfoSegmentList& o_u8_IndexInLaneInfoSegmentList);
   virtual tVoid vVisit_u8_IndexInLaneInfoList(fi_tcl_u8_IndexInLaneInfoList& o_u8_IndexInLaneInfoList);
   virtual tBool bDoExpand_AbstractTurnSymbol(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_GuidanceManoeuvreBaseSymbol(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfoOneCellReference(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfoOneCellIndexReference(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfoPathSectionIndexReference(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfoElementReference(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Crossing(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_GuidanceManoeuvreSymbol(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_GuidanceManoeuvreSymbolList(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfoElement(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_UPOI_Source(fi_tcl_e8_UPOI_Source& o_e8_UPOI_Source);
   virtual tBool bDoExpand_UPOI_Element(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_UPOI_FilterSetStatus(fi_tcl_b8_UPOI_FilterSetStatus& o_b8_UPOI_FilterSetStatus);
   virtual tVoid vVisit_b8_UPOI_AnnouncementStatus(fi_tcl_b8_UPOI_AnnouncementStatus& o_b8_UPOI_AnnouncementStatus);
   virtual tVoid vVisit_b8_UPOI_FilterSet_FieldRelevance(fi_tcl_b8_UPOI_FilterSet_FieldRelevance& o_b8_UPOI_FilterSet_FieldRelevance);
   virtual tBool bDoExpand_UPOI(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UPOI_FilterSet(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UPOI_CategoryConfiguration(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UPOI_FilterList(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UPOI_CategoryConfigurationList(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_HorizonEventsFilter(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u16_TripHandle(fi_tcl_u16_TripHandle& o_u16_TripHandle);
   virtual tBool bDoExpand_TEAEventID(rgfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_HorizonEvent(rgfi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   fi_tclOutput* poOutput;
};


class MY_DECL rgfi_tclRandomInitVisitor : public rgfi_tclVisitorBase {
public:

   rgfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_u8_Percent(fi_tcl_u8_Percent& o_u8_Percent);
   virtual tVoid vVisit_s16_PerThousand(fi_tcl_s16_PerThousand& o_s16_PerThousand);
   virtual tVoid vVisit_u16_IndexInReferenceList(fi_tcl_u16_IndexInReferenceList& o_u16_IndexInReferenceList);
   virtual tVoid vVisit_s32_Kilogram(fi_tcl_s32_Kilogram& o_s32_Kilogram);
   virtual tVoid vVisit_s32_Pound(fi_tcl_s32_Pound& o_s32_Pound);
   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& o_s32_Meter);
   virtual tVoid vVisit_s32_Yards(fi_tcl_s32_Yards& o_s32_Yards);
   virtual tVoid vVisit_s32_Centimeter(fi_tcl_s32_Centimeter& o_s32_Centimeter);
   virtual tVoid vVisit_s32_Inch(fi_tcl_s32_Inch& o_s32_Inch);
   virtual tVoid vVisit_s32_Microliter(fi_tcl_s32_Microliter& o_s32_Microliter);
   virtual tVoid vVisit_s32_Second(fi_tcl_s32_Second& o_s32_Second);
   virtual tVoid vVisit_e8_DST_State(fi_tcl_e8_DST_State& o_e8_DST_State);
   virtual tVoid vVisit_s16_KmPerHour(fi_tcl_s16_KmPerHour& o_s16_KmPerHour);
   virtual tVoid vVisit_s16_MilesPerHour(fi_tcl_s16_MilesPerHour& o_s16_MilesPerHour);
   virtual tVoid vVisit_s16_CentimeterSecond(fi_tcl_s16_CentimeterSecond& o_s16_CentimeterSecond);
   virtual tVoid vVisit_s32_Watt(fi_tcl_s32_Watt& o_s32_Watt);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_e16_ISOLanguageCode(fi_tcl_e16_ISOLanguageCode& o_e16_ISOLanguageCode);
   virtual tVoid vVisit_u8_DirectionAbsolute(fi_tcl_u8_DirectionAbsolute& o_u8_DirectionAbsolute);
   virtual tVoid vVisit_u8_DirectionRelative(fi_tcl_u8_DirectionRelative& o_u8_DirectionRelative);
   virtual tVoid vVisit_e8_FuelType(fi_tcl_e8_FuelType& o_e8_FuelType);
   virtual tVoid vVisit_e8_ShapeType(fi_tcl_e8_ShapeType& o_e8_ShapeType);
   virtual tVoid vVisit_e8_TMCategory(fi_tcl_e8_TMCategory& o_e8_TMCategory);
   virtual tVoid vVisit_b8_TMMappingPossibility(fi_tcl_b8_TMMappingPossibility& o_b8_TMMappingPossibility);
   virtual tVoid vVisit_b8_TMMappingStatus(fi_tcl_b8_TMMappingStatus& o_b8_TMMappingStatus);
   virtual tVoid vVisit_e8_TMValueStatus(fi_tcl_e8_TMValueStatus& o_e8_TMValueStatus);
   virtual tVoid vVisit_e8_TMGeometricMessageType(fi_tcl_e8_TMGeometricMessageType& o_e8_TMGeometricMessageType);
   virtual tVoid vVisit_e8_TMFlowImpact(fi_tcl_e8_TMFlowImpact& o_e8_TMFlowImpact);
   virtual tVoid vVisit_e8_TMUrgency(fi_tcl_e8_TMUrgency& o_e8_TMUrgency);
   virtual tVoid vVisit_e8_TMGeographicalPathRelationType(fi_tcl_e8_TMGeographicalPathRelationType& o_e8_TMGeographicalPathRelationType);
   virtual tVoid vVisit_b8_TMRelevance(fi_tcl_b8_TMRelevance& o_b8_TMRelevance);
   virtual tVoid vVisit_e8_TrafficMsgType(fi_tcl_e8_TrafficMsgType& o_e8_TrafficMsgType);
   virtual tVoid vVisit_e16_NaviEventValue(fi_tcl_e16_NaviEventValue& o_e16_NaviEventValue);
   virtual tVoid vVisit_e8_MetricSystem(fi_tcl_e8_MetricSystem& o_e8_MetricSystem);
   virtual tVoid vVisit_b8_GuidanceMode(fi_tcl_b8_GuidanceMode& o_b8_GuidanceMode);
   virtual tVoid vVisit_b8_GuidanceStatus(fi_tcl_b8_GuidanceStatus& o_b8_GuidanceStatus);
   virtual tVoid vVisit_e8_DataCarrierRequestStatus(fi_tcl_e8_DataCarrierRequestStatus& o_e8_DataCarrierRequestStatus);
   virtual tVoid vVisit_e8_GuidanceElement(fi_tcl_e8_GuidanceElement& o_e8_GuidanceElement);
   virtual tVoid vVisit_b8_GuidanceElementAttribute(fi_tcl_b8_GuidanceElementAttribute& o_b8_GuidanceElementAttribute);
   virtual tVoid vVisit_b8_RoadNumberStatus(fi_tcl_b8_RoadNumberStatus& o_b8_RoadNumberStatus);
   virtual tVoid vVisit_e8_SignPostDestType(fi_tcl_e8_SignPostDestType& o_e8_SignPostDestType);
   virtual tVoid vVisit_e8_BaseTrafficSignCategory(fi_tcl_e8_BaseTrafficSignCategory& o_e8_BaseTrafficSignCategory);
   virtual tVoid vVisit_s32_EMU(fi_tcl_s32_EMU& o_s32_EMU);
   virtual tVoid vVisit_e8_GuidanceDescriptorInfoCategory(fi_tcl_e8_GuidanceDescriptorInfoCategory& o_e8_GuidanceDescriptorInfoCategory);
   virtual tVoid vVisit_e8_GuidanceSymbol(fi_tcl_e8_GuidanceSymbol& o_e8_GuidanceSymbol);
   virtual tVoid vVisit_e8_GuidanceStatusSymbol(fi_tcl_e8_GuidanceStatusSymbol& o_e8_GuidanceStatusSymbol);
   virtual tVoid vVisit_e8_SingleRoadInfoCategory(fi_tcl_e8_SingleRoadInfoCategory& o_e8_SingleRoadInfoCategory);
   virtual tVoid vVisit_b8_GuidanceSymbolAttributes(fi_tcl_b8_GuidanceSymbolAttributes& o_b8_GuidanceSymbolAttributes);
   virtual tVoid vVisit_e8_GuidanceManoeuvreSymbol(fi_tcl_e8_GuidanceManoeuvreSymbol& o_e8_GuidanceManoeuvreSymbol);
   virtual tVoid vVisit_e8_IntersectionType(fi_tcl_e8_IntersectionType& o_e8_IntersectionType);
   virtual tVoid vVisit_e8_GuidanceManoeuvreType(fi_tcl_e8_GuidanceManoeuvreType& o_e8_GuidanceManoeuvreType);
   virtual tVoid vVisit_b8_GuidanceSymbolStatus(fi_tcl_b8_GuidanceSymbolStatus& o_b8_GuidanceSymbolStatus);
   virtual tVoid vVisit_e8_EntryPointState(fi_tcl_e8_EntryPointState& o_e8_EntryPointState);
   virtual tVoid vVisit_e8_GuidanceDestinationType(fi_tcl_e8_GuidanceDestinationType& o_e8_GuidanceDestinationType);
   virtual tVoid vVisit_e8_SideInfo(fi_tcl_e8_SideInfo& o_e8_SideInfo);
   virtual tVoid vVisit_e8_RoundaboutSymbolType(fi_tcl_e8_RoundaboutSymbolType& o_e8_RoundaboutSymbolType);
   virtual tVoid vVisit_e8_RoadClassCode(fi_tcl_e8_RoadClassCode& o_e8_RoadClassCode);
   virtual tVoid vVisit_e8_TurnToSymbol(fi_tcl_e8_TurnToSymbol& o_e8_TurnToSymbol);
   virtual tVoid vVisit_u8_DrivingDirection(fi_tcl_u8_DrivingDirection& o_u8_DrivingDirection);
   virtual tVoid vVisit_b32_RoadProperty(fi_tcl_b32_RoadProperty& o_b32_RoadProperty);
   virtual tVoid vVisit_e8_NavStreetType(fi_tcl_e8_NavStreetType& o_e8_NavStreetType);
   virtual tVoid vVisit_b8_GuidanceMessageCategory(fi_tcl_b8_GuidanceMessageCategory& o_b8_GuidanceMessageCategory);
   virtual tVoid vVisit_b8_WarningPointStatus(fi_tcl_b8_WarningPointStatus& o_b8_WarningPointStatus);
   virtual tVoid vVisit_b8_HorizonEventStatus(fi_tcl_b8_HorizonEventStatus& o_b8_HorizonEventStatus);
   virtual tVoid vVisit_b32_TrafficMessageSource(fi_tcl_b32_TrafficMessageSource& o_b32_TrafficMessageSource);
   virtual tVoid vVisit_u16_UserTrafficMessageHandle(fi_tcl_u16_UserTrafficMessageHandle& o_u16_UserTrafficMessageHandle);
   virtual tVoid vVisit_e8_SpeedLimitExceedingStatus(fi_tcl_e8_SpeedLimitExceedingStatus& o_e8_SpeedLimitExceedingStatus);
   virtual tVoid vVisit_e8_TrafficSignQuantifier(fi_tcl_e8_TrafficSignQuantifier& o_e8_TrafficSignQuantifier);
   virtual tVoid vVisit_e8_WarningSignCriticality(fi_tcl_e8_WarningSignCriticality& o_e8_WarningSignCriticality);
   virtual tVoid vVisit_e16_AdditionalTrafficSign(fi_tcl_e16_AdditionalTrafficSign& o_e16_AdditionalTrafficSign);
   virtual tVoid vVisit_b32_POICategory(fi_tcl_b32_POICategory& o_b32_POICategory);
   virtual tVoid vVisit_e8_RoadAttriuteInfo(fi_tcl_e8_RoadAttriuteInfo& o_e8_RoadAttriuteInfo);
   virtual tVoid vVisit_e8_RequiredPermission(fi_tcl_e8_RequiredPermission& o_e8_RequiredPermission);
   virtual tVoid vVisit_e8_WarningPointDataType(fi_tcl_e8_WarningPointDataType& o_e8_WarningPointDataType);
   virtual tVoid vVisit_e8_HorizonEventDataType(fi_tcl_e8_HorizonEventDataType& o_e8_HorizonEventDataType);
   virtual tVoid vVisit_e8_TEAEventType(fi_tcl_e8_TEAEventType& o_e8_TEAEventType);
   virtual tVoid vVisit_b8_WarningsOnHorizonMode(fi_tcl_b8_WarningsOnHorizonMode& o_b8_WarningsOnHorizonMode);
   virtual tVoid vVisit_e8_MultiMediaFunction(fi_tcl_e8_MultiMediaFunction& o_e8_MultiMediaFunction);
   virtual tVoid vVisit_e8_MultiMediaType(fi_tcl_e8_MultiMediaType& o_e8_MultiMediaType);
   virtual tVoid vVisit_e8_MultiMediaStatus(fi_tcl_e8_MultiMediaStatus& o_e8_MultiMediaStatus);
   virtual tVoid vVisit_b16_FunctionalityGroupRouteInfo(fi_tcl_b16_FunctionalityGroupRouteInfo& o_b16_FunctionalityGroupRouteInfo);
   virtual tVoid vVisit_b16_FunctionalityGroupDestinationInfo(fi_tcl_b16_FunctionalityGroupDestinationInfo& o_b16_FunctionalityGroupDestinationInfo);
   virtual tVoid vVisit_b16_FunctionalityGroupDrivingRecommendation(fi_tcl_b16_FunctionalityGroupDrivingRecommendation& o_b16_FunctionalityGroupDrivingRecommendation);
   virtual tVoid vVisit_b16_FunctionalityGroupCorridorInfo(fi_tcl_b16_FunctionalityGroupCorridorInfo& o_b16_FunctionalityGroupCorridorInfo);
   virtual tVoid vVisit_b16_FunctionalityGroupHorizonInfoTrafficMessage(fi_tcl_b16_FunctionalityGroupHorizonInfoTrafficMessage& o_b16_FunctionalityGroupHorizonInfoTrafficMessage);
   virtual tVoid vVisit_b16_FunctionalityGroupHorizonInfoSpeedLimit(fi_tcl_b16_FunctionalityGroupHorizonInfoSpeedLimit& o_b16_FunctionalityGroupHorizonInfoSpeedLimit);
   virtual tVoid vVisit_b16_FunctionalityGroupHorizonInfoWarningSign(fi_tcl_b16_FunctionalityGroupHorizonInfoWarningSign& o_b16_FunctionalityGroupHorizonInfoWarningSign);
   virtual tVoid vVisit_b16_FunctionalityGroupHorizonInfoPOI(fi_tcl_b16_FunctionalityGroupHorizonInfoPOI& o_b16_FunctionalityGroupHorizonInfoPOI);
   virtual tVoid vVisit_b16_FunctionalityGroupHorizonInfoRoadAttribute(fi_tcl_b16_FunctionalityGroupHorizonInfoRoadAttribute& o_b16_FunctionalityGroupHorizonInfoRoadAttribute);
   virtual tVoid vVisit_b16_FunctionalityGroupHorizonInfoCurve(fi_tcl_b16_FunctionalityGroupHorizonInfoCurve& o_b16_FunctionalityGroupHorizonInfoCurve);
   virtual tVoid vVisit_b16_FunctionalityGroupDriverSpeedAdvice(fi_tcl_b16_FunctionalityGroupDriverSpeedAdvice& o_b16_FunctionalityGroupDriverSpeedAdvice);
   virtual tVoid vVisit_b16_HorizonEventTrafficSignSettings(fi_tcl_b16_HorizonEventTrafficSignSettings& o_b16_HorizonEventTrafficSignSettings);
   virtual tVoid vVisit_b16_FunctionalityGroupHorizonInfoTollBooth(fi_tcl_b16_FunctionalityGroupHorizonInfoTollBooth& o_b16_FunctionalityGroupHorizonInfoTollBooth);
   virtual tVoid vVisit_b32_HorizonEventFilterPOI(fi_tcl_b32_HorizonEventFilterPOI& o_b32_HorizonEventFilterPOI);
   virtual tVoid vVisit_b8_TrafficMessageSettings(fi_tcl_b8_TrafficMessageSettings& o_b8_TrafficMessageSettings);
   virtual tVoid vVisit_e8_UPOI_AnnouncementDistance(fi_tcl_e8_UPOI_AnnouncementDistance& o_e8_UPOI_AnnouncementDistance);
   virtual tVoid vVisit_e8_DriverAdviceType(fi_tcl_e8_DriverAdviceType& o_e8_DriverAdviceType);
   virtual tVoid vVisit_e8_DriverActionFeedback(fi_tcl_e8_DriverActionFeedback& o_e8_DriverActionFeedback);
   virtual tVoid vVisit_b32_PredictiveCCMode(fi_tcl_b32_PredictiveCCMode& o_b32_PredictiveCCMode);
   virtual tVoid vVisit_b32_PredictiveCC_ControlBits(fi_tcl_b32_PredictiveCC_ControlBits& o_b32_PredictiveCC_ControlBits);
   virtual tVoid vVisit_e8_SpeedLimitLocation(fi_tcl_e8_SpeedLimitLocation& o_e8_SpeedLimitLocation);
   virtual tVoid vVisit_e8_VoiceGender(fi_tcl_e8_VoiceGender& o_e8_VoiceGender);
   virtual tVoid vVisit_e8_Sentence(fi_tcl_e8_Sentence& o_e8_Sentence);
   virtual tVoid vVisit_e8_SpeechFeature(fi_tcl_e8_SpeechFeature& o_e8_SpeechFeature);
   virtual tVoid vVisit_e8_SpeechStatus(fi_tcl_e8_SpeechStatus& o_e8_SpeechStatus);
   virtual tVoid vVisit_e8_DebugSound(fi_tcl_e8_DebugSound& o_e8_DebugSound);
   virtual tVoid vVisit_e8_EventType(fi_tcl_e8_EventType& o_e8_EventType);
   virtual tVoid vVisit_e8_TMLocationType(fi_tcl_e8_TMLocationType& o_e8_TMLocationType);
   virtual tVoid vVisit_e16_EffectCode(fi_tcl_e16_EffectCode& o_e16_EffectCode);
   virtual tVoid vVisit_e16_CauseCode(fi_tcl_e16_CauseCode& o_e16_CauseCode);
   virtual tVoid vVisit_e8_Tendency(fi_tcl_e8_Tendency& o_e8_Tendency);
   virtual tVoid vVisit_e8_BinContainerTypes(fi_tcl_e8_BinContainerTypes& o_e8_BinContainerTypes);
#ifndef FI_S_EXTERNAL_FI
#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_e8_RoadNetworkClass(fi_tcl_e8_RoadNetworkClass& o_e8_RoadNetworkClass);
   virtual tVoid vVisit_e8_RequiredPermissionType(fi_tcl_e8_RequiredPermissionType& o_e8_RequiredPermissionType);
   virtual tVoid vVisit_e8_LaneStatus(fi_tcl_e8_LaneStatus& o_e8_LaneStatus);
   virtual tVoid vVisit_b8_LaneType(fi_tcl_b8_LaneType& o_b8_LaneType);
   virtual tVoid vVisit_u32_DataSetId(fi_tcl_u32_DataSetId& o_u32_DataSetId);
   virtual tVoid vVisit_e8_NavOneCellDirection(fi_tcl_e8_NavOneCellDirection& o_e8_NavOneCellDirection);
   virtual tVoid vVisit_b8_LaneChangeRestriction(fi_tcl_b8_LaneChangeRestriction& o_b8_LaneChangeRestriction);
   virtual tVoid vVisit_e8_ManoeuvreCriticality(fi_tcl_e8_ManoeuvreCriticality& o_e8_ManoeuvreCriticality);
   virtual tVoid vVisit_e8_ExtraDescElementType(fi_tcl_e8_ExtraDescElementType& o_e8_ExtraDescElementType);
   virtual tVoid vVisit_b32_DataProperties(fi_tcl_b32_DataProperties& o_b32_DataProperties);
   virtual tVoid vVisit_b8_CrossroadProperties(fi_tcl_b8_CrossroadProperties& o_b8_CrossroadProperties);
   virtual tVoid vVisit_e8_CrossroadInfoCategory(fi_tcl_e8_CrossroadInfoCategory& o_e8_CrossroadInfoCategory);
   virtual tVoid vVisit_e8_SpeedSign(fi_tcl_e8_SpeedSign& o_e8_SpeedSign);
   virtual tVoid vVisit_e16_WarningSign(fi_tcl_e16_WarningSign& o_e16_WarningSign);
   virtual tVoid vVisit_e16_RegulatorySign(fi_tcl_e16_RegulatorySign& o_e16_RegulatorySign);
   virtual tVoid vVisit_TimeDependentString(fi_tcl_TimeDependentString& o_TimeDependentString);
   virtual tVoid vVisit_b8_LaneDependentValidity(fi_tcl_b8_LaneDependentValidity& o_b8_LaneDependentValidity);
   virtual tVoid vVisit_b8_RouteProperties(fi_tcl_b8_RouteProperties& o_b8_RouteProperties);
   virtual tVoid vVisit_e8_NavOneCellCategory(fi_tcl_e8_NavOneCellCategory& o_e8_NavOneCellCategory);
   virtual tVoid vVisit_e8_SignPostDestinationCategory(fi_tcl_e8_SignPostDestinationCategory& o_e8_SignPostDestinationCategory);
   virtual tVoid vVisit_e8_SignPostDestStatus(fi_tcl_e8_SignPostDestStatus& o_e8_SignPostDestStatus);
   virtual tVoid vVisit_e8_DirectionStatus(fi_tcl_e8_DirectionStatus& o_e8_DirectionStatus);
   virtual tVoid vVisit_e8_DirectionCategory(fi_tcl_e8_DirectionCategory& o_e8_DirectionCategory);
   virtual tVoid vVisit_b8_DirectionInfoStatus(fi_tcl_b8_DirectionInfoStatus& o_b8_DirectionInfoStatus);
   virtual tVoid vVisit_b8_SignPostInfoStatus(fi_tcl_b8_SignPostInfoStatus& o_b8_SignPostInfoStatus);
   virtual tVoid vVisit_u32_SquareDecimeter(fi_tcl_u32_SquareDecimeter& o_u32_SquareDecimeter);
   virtual tVoid vVisit_u32_Milliliter(fi_tcl_u32_Milliliter& o_u32_Milliliter);
   virtual tVoid vVisit_u32_Microliter(fi_tcl_u32_Microliter& o_u32_Microliter);
   virtual tVoid vVisit_u16_RouteHandle(fi_tcl_u16_RouteHandle& o_u16_RouteHandle);
   virtual tVoid vVisit_u16_TripSegmentNumber(fi_tcl_u16_TripSegmentNumber& o_u16_TripSegmentNumber);
   virtual tVoid vVisit_e8_NavAreaType(fi_tcl_e8_NavAreaType& o_e8_NavAreaType);
   virtual tVoid vVisit_e8_VehicleType(fi_tcl_e8_VehicleType& o_e8_VehicleType);
   virtual tVoid vVisit_b8_CargoInfo(fi_tcl_b8_CargoInfo& o_b8_CargoInfo);
   virtual tVoid vVisit_b8_ThresholdDefinitionProfile(fi_tcl_b8_ThresholdDefinitionProfile& o_b8_ThresholdDefinitionProfile);
   virtual tVoid vVisit_b8_UserProfiles(fi_tcl_b8_UserProfiles& o_b8_UserProfiles);
   virtual tVoid vVisit_e8_VehicleClass(fi_tcl_e8_VehicleClass& o_e8_VehicleClass);
   virtual tVoid vVisit_e8_Gearbox(fi_tcl_e8_Gearbox& o_e8_Gearbox);
   virtual tVoid vVisit_e8_DriveMode(fi_tcl_e8_DriveMode& o_e8_DriveMode);
   virtual tVoid vVisit_e8_DriverType(fi_tcl_e8_DriverType& o_e8_DriverType);
   virtual tVoid vVisit_e8_LaneReferenceCategory(fi_tcl_e8_LaneReferenceCategory& o_e8_LaneReferenceCategory);
   virtual tVoid vVisit_u8_IndexInLaneInfoSegmentList(fi_tcl_u8_IndexInLaneInfoSegmentList& o_u8_IndexInLaneInfoSegmentList);
   virtual tVoid vVisit_u8_IndexInLaneInfoList(fi_tcl_u8_IndexInLaneInfoList& o_u8_IndexInLaneInfoList);
   virtual tVoid vVisit_e8_UPOI_Source(fi_tcl_e8_UPOI_Source& o_e8_UPOI_Source);
   virtual tVoid vVisit_b8_UPOI_FilterSetStatus(fi_tcl_b8_UPOI_FilterSetStatus& o_b8_UPOI_FilterSetStatus);
   virtual tVoid vVisit_b8_UPOI_AnnouncementStatus(fi_tcl_b8_UPOI_AnnouncementStatus& o_b8_UPOI_AnnouncementStatus);
   virtual tVoid vVisit_b8_UPOI_FilterSet_FieldRelevance(fi_tcl_b8_UPOI_FilterSet_FieldRelevance& o_b8_UPOI_FilterSet_FieldRelevance);
   virtual tVoid vVisit_u16_TripHandle(fi_tcl_u16_TripHandle& o_u16_TripHandle);
	tU32 u32ListSize;
};

#endif
