/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef RFDFITYPES_HEADER
#define RFDFITYPES_HEADER

// #include <vector>
// 


class rfdfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class rfdfi_tclMsgCurrTabWeatherDBInfoMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rfdfi_tclMsgCurrTabWeatherDBInfoMethodStart():BaselineFileVersion(0),ProtocolVersion(0),CurrentBaselinePath() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rfdfi_tclMsgCurrTabWeatherDBInfoMethodStart& operator=(const rfdfi_tclMsgCurrTabWeatherDBInfoMethodStart& coRef);
   rfdfi_tclMsgCurrTabWeatherDBInfoMethodStart(const rfdfi_tclMsgCurrTabWeatherDBInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 BaselineFileVersion;
   tU8 ProtocolVersion;
   fi_tclString CurrentBaselinePath;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rfdfi_tclMsgCurrTabWeatherDBInfoMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rfdfi_tclToken::EN_MSG_CURRTABWEATHERDBINFOMETHODSTART;}
};

class rfdfi_tclMsgCurrTabWeatherDBInfoMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rfdfi_tclMsgCurrTabWeatherDBInfoMethodResult():ServiceStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rfdfi_tclMsgCurrTabWeatherDBInfoMethodResult& operator=(const rfdfi_tclMsgCurrTabWeatherDBInfoMethodResult& coRef);
   rfdfi_tclMsgCurrTabWeatherDBInfoMethodResult(const rfdfi_tclMsgCurrTabWeatherDBInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_Rfd_ServiceStatus ServiceStatus;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rfdfi_tclMsgCurrTabWeatherDBInfoMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rfdfi_tclToken::EN_MSG_CURRTABWEATHERDBINFOMETHODRESULT;}
};

class rfdfi_tclMsgDeleteTabWeatherDBFileMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rfdfi_tclMsgDeleteTabWeatherDBFileMethodStart():UpdateStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rfdfi_tclMsgDeleteTabWeatherDBFileMethodStart& operator=(const rfdfi_tclMsgDeleteTabWeatherDBFileMethodStart& coRef);
   rfdfi_tclMsgDeleteTabWeatherDBFileMethodStart(const rfdfi_tclMsgDeleteTabWeatherDBFileMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_UpdateState UpdateStatus;
   std::vector<fi_tcl_Rfd_BaselineFiles, std::allocator<fi_tcl_Rfd_BaselineFiles> > oListOfBaseLineFiles;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rfdfi_tclMsgDeleteTabWeatherDBFileMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rfdfi_tclToken::EN_MSG_DELETETABWEATHERDBFILEMETHODSTART;}
};

class rfdfi_tclMsgDeleteTabWeatherDBFileMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rfdfi_tclMsgDeleteTabWeatherDBFileMethodResult():ServiceStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rfdfi_tclMsgDeleteTabWeatherDBFileMethodResult& operator=(const rfdfi_tclMsgDeleteTabWeatherDBFileMethodResult& coRef);
   rfdfi_tclMsgDeleteTabWeatherDBFileMethodResult(const rfdfi_tclMsgDeleteTabWeatherDBFileMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_Rfd_ServiceStatus ServiceStatus;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rfdfi_tclMsgDeleteTabWeatherDBFileMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rfdfi_tclToken::EN_MSG_DELETETABWEATHERDBFILEMETHODRESULT;}
};

class rfdfi_tclMsgAcquireDataAccessMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rfdfi_tclMsgAcquireDataAccessMethodStart():Protocol() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rfdfi_tclMsgAcquireDataAccessMethodStart& operator=(const rfdfi_tclMsgAcquireDataAccessMethodStart& coRef);
   rfdfi_tclMsgAcquireDataAccessMethodStart(const rfdfi_tclMsgAcquireDataAccessMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_SxmProtocol Protocol;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rfdfi_tclMsgAcquireDataAccessMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rfdfi_tclToken::EN_MSG_ACQUIREDATAACCESSMETHODSTART;}
};

class rfdfi_tclMsgAcquireDataAccessMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rfdfi_tclMsgAcquireDataAccessMethodResult():Protocol(),AccessGiven(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rfdfi_tclMsgAcquireDataAccessMethodResult& operator=(const rfdfi_tclMsgAcquireDataAccessMethodResult& coRef);
   rfdfi_tclMsgAcquireDataAccessMethodResult(const rfdfi_tclMsgAcquireDataAccessMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_SxmProtocol Protocol;
   tBool AccessGiven;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rfdfi_tclMsgAcquireDataAccessMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rfdfi_tclToken::EN_MSG_ACQUIREDATAACCESSMETHODRESULT;}
};

class rfdfi_tclMsgReleaseDataAccessMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rfdfi_tclMsgReleaseDataAccessMethodStart():Protocol() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rfdfi_tclMsgReleaseDataAccessMethodStart& operator=(const rfdfi_tclMsgReleaseDataAccessMethodStart& coRef);
   rfdfi_tclMsgReleaseDataAccessMethodStart(const rfdfi_tclMsgReleaseDataAccessMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_SxmProtocol Protocol;
   std::vector<fi_tcl_SxmFile, std::allocator<fi_tcl_SxmFile> > CorruptFiles;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rfdfi_tclMsgReleaseDataAccessMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rfdfi_tclToken::EN_MSG_RELEASEDATAACCESSMETHODSTART;}
};

class rfdfi_tclMsgReleaseDataAccessMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rfdfi_tclMsgReleaseDataAccessMethodResult():Protocol() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rfdfi_tclMsgReleaseDataAccessMethodResult& operator=(const rfdfi_tclMsgReleaseDataAccessMethodResult& coRef);
   rfdfi_tclMsgReleaseDataAccessMethodResult(const rfdfi_tclMsgReleaseDataAccessMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_SxmProtocol Protocol;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rfdfi_tclMsgReleaseDataAccessMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rfdfi_tclToken::EN_MSG_RELEASEDATAACCESSMETHODRESULT;}
};

class rfdfi_tclMsgRevertExistingDataBaseMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rfdfi_tclMsgRevertExistingDataBaseMethodStart():Protocol() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rfdfi_tclMsgRevertExistingDataBaseMethodStart& operator=(const rfdfi_tclMsgRevertExistingDataBaseMethodStart& coRef);
   rfdfi_tclMsgRevertExistingDataBaseMethodStart(const rfdfi_tclMsgRevertExistingDataBaseMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_SxmProtocol Protocol;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rfdfi_tclMsgRevertExistingDataBaseMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rfdfi_tclToken::EN_MSG_REVERTEXISTINGDATABASEMETHODSTART;}
};

class rfdfi_tclMsgRevertExistingDataBaseMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rfdfi_tclMsgRevertExistingDataBaseMethodResult():Protocol(),DataBaseReverted(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rfdfi_tclMsgRevertExistingDataBaseMethodResult& operator=(const rfdfi_tclMsgRevertExistingDataBaseMethodResult& coRef);
   rfdfi_tclMsgRevertExistingDataBaseMethodResult(const rfdfi_tclMsgRevertExistingDataBaseMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_SxmProtocol Protocol;
   tBool DataBaseReverted;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rfdfi_tclMsgRevertExistingDataBaseMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rfdfi_tclToken::EN_MSG_REVERTEXISTINGDATABASEMETHODRESULT;}
};

class rfdfi_tclMsgTabWeatherDBUpdatedUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rfdfi_tclMsgTabWeatherDBUpdatedUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rfdfi_tclMsgTabWeatherDBUpdatedUpReg& operator=(const rfdfi_tclMsgTabWeatherDBUpdatedUpReg& coRef);
   rfdfi_tclMsgTabWeatherDBUpdatedUpReg(const rfdfi_tclMsgTabWeatherDBUpdatedUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rfdfi_tclMsgTabWeatherDBUpdatedUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rfdfi_tclToken::EN_MSG_TABWEATHERDBUPDATEDUPREG;}
};

class rfdfi_tclMsgTabWeatherDBUpdatedRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rfdfi_tclMsgTabWeatherDBUpdatedRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rfdfi_tclMsgTabWeatherDBUpdatedRelUpReg& operator=(const rfdfi_tclMsgTabWeatherDBUpdatedRelUpReg& coRef);
   rfdfi_tclMsgTabWeatherDBUpdatedRelUpReg(const rfdfi_tclMsgTabWeatherDBUpdatedRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rfdfi_tclMsgTabWeatherDBUpdatedRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rfdfi_tclToken::EN_MSG_TABWEATHERDBUPDATEDRELUPREG;}
};

class rfdfi_tclMsgTabWeatherDBUpdatedGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rfdfi_tclMsgTabWeatherDBUpdatedGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rfdfi_tclMsgTabWeatherDBUpdatedGet& operator=(const rfdfi_tclMsgTabWeatherDBUpdatedGet& coRef);
   rfdfi_tclMsgTabWeatherDBUpdatedGet(const rfdfi_tclMsgTabWeatherDBUpdatedGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rfdfi_tclMsgTabWeatherDBUpdatedGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rfdfi_tclToken::EN_MSG_TABWEATHERDBUPDATEDGET;}
};

class rfdfi_tclMsgTabWeatherDBUpdatedStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rfdfi_tclMsgTabWeatherDBUpdatedStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rfdfi_tclMsgTabWeatherDBUpdatedStatus& operator=(const rfdfi_tclMsgTabWeatherDBUpdatedStatus& coRef);
   rfdfi_tclMsgTabWeatherDBUpdatedStatus(const rfdfi_tclMsgTabWeatherDBUpdatedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_Rfd_BaselineFiles, std::allocator<fi_tcl_Rfd_BaselineFiles> > oListOfBaseLineFiles;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rfdfi_tclMsgTabWeatherDBUpdatedStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rfdfi_tclToken::EN_MSG_TABWEATHERDBUPDATEDSTATUS;}
};

class rfdfi_tclMsgExchangeDirectoryContentUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rfdfi_tclMsgExchangeDirectoryContentUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rfdfi_tclMsgExchangeDirectoryContentUpReg& operator=(const rfdfi_tclMsgExchangeDirectoryContentUpReg& coRef);
   rfdfi_tclMsgExchangeDirectoryContentUpReg(const rfdfi_tclMsgExchangeDirectoryContentUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rfdfi_tclMsgExchangeDirectoryContentUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rfdfi_tclToken::EN_MSG_EXCHANGEDIRECTORYCONTENTUPREG;}
};

class rfdfi_tclMsgExchangeDirectoryContentRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rfdfi_tclMsgExchangeDirectoryContentRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rfdfi_tclMsgExchangeDirectoryContentRelUpReg& operator=(const rfdfi_tclMsgExchangeDirectoryContentRelUpReg& coRef);
   rfdfi_tclMsgExchangeDirectoryContentRelUpReg(const rfdfi_tclMsgExchangeDirectoryContentRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rfdfi_tclMsgExchangeDirectoryContentRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rfdfi_tclToken::EN_MSG_EXCHANGEDIRECTORYCONTENTRELUPREG;}
};

class rfdfi_tclMsgExchangeDirectoryContentGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rfdfi_tclMsgExchangeDirectoryContentGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rfdfi_tclMsgExchangeDirectoryContentGet& operator=(const rfdfi_tclMsgExchangeDirectoryContentGet& coRef);
   rfdfi_tclMsgExchangeDirectoryContentGet(const rfdfi_tclMsgExchangeDirectoryContentGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rfdfi_tclMsgExchangeDirectoryContentGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rfdfi_tclToken::EN_MSG_EXCHANGEDIRECTORYCONTENTGET;}
};

class rfdfi_tclMsgExchangeDirectoryContentStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   rfdfi_tclMsgExchangeDirectoryContentStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rfdfi_tclMsgExchangeDirectoryContentStatus& operator=(const rfdfi_tclMsgExchangeDirectoryContentStatus& coRef);
   rfdfi_tclMsgExchangeDirectoryContentStatus(const rfdfi_tclMsgExchangeDirectoryContentStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_FilesForProtocol, std::allocator<fi_tcl_FilesForProtocol> > ListOfFilesPerProtocol;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const rfdfi_tclMsgExchangeDirectoryContentStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return rfdfi_tclToken::EN_MSG_EXCHANGEDIRECTORYCONTENTSTATUS;}
};


#endif
