/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgCurrTabWeatherDBInfoMethodStart::rfdfi_tclMsgCurrTabWeatherDBInfoMethodStart(const rfdfi_tclMsgCurrTabWeatherDBInfoMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   BaselineFileVersion = coRef.BaselineFileVersion;
   ProtocolVersion = coRef.ProtocolVersion;
   CurrentBaselinePath = coRef.CurrentBaselinePath;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgCurrTabWeatherDBInfoMethodStart& rfdfi_tclMsgCurrTabWeatherDBInfoMethodStart::operator=(const rfdfi_tclMsgCurrTabWeatherDBInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   BaselineFileVersion = coRef.BaselineFileVersion;
   ProtocolVersion = coRef.ProtocolVersion;
   CurrentBaselinePath = coRef.CurrentBaselinePath;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rfdfi_tclMsgCurrTabWeatherDBInfoMethodStart::u16GetServiceID() const {return RFDFI_C_U16_SERVICE_ID;}
tU16 rfdfi_tclMsgCurrTabWeatherDBInfoMethodStart::u16GetFunctionID() const {return RFDFI_C_U16_CURRTABWEATHERDBINFO;}
tU8 rfdfi_tclMsgCurrTabWeatherDBInfoMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rfdfi_tclMsgCurrTabWeatherDBInfoMethodStart::vDestroy()
{
   CurrentBaselinePath.vDestroy();
}

tU32 rfdfi_tclMsgCurrTabWeatherDBInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+CurrentBaselinePath.u32GetSize(u16MajorVersion);
}

tBool rfdfi_tclMsgCurrTabWeatherDBInfoMethodStart::operator==(const rfdfi_tclMsgCurrTabWeatherDBInfoMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (BaselineFileVersion == rfoCmp.BaselineFileVersion);
      bResult = bResult && (ProtocolVersion == rfoCmp.ProtocolVersion);
      bResult = bResult && (CurrentBaselinePath == rfoCmp.CurrentBaselinePath);
   return bResult;
}

fi_tclInContext& rfdfi_tclMsgCurrTabWeatherDBInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> BaselineFileVersion;
   oIn >> ProtocolVersion;
   oIn >> CurrentBaselinePath;
   return oIn;
}

fi_tclOutContext& rfdfi_tclMsgCurrTabWeatherDBInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << BaselineFileVersion;
   oOut << ProtocolVersion;
   oOut << CurrentBaselinePath;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgCurrTabWeatherDBInfoMethodResult::rfdfi_tclMsgCurrTabWeatherDBInfoMethodResult(const rfdfi_tclMsgCurrTabWeatherDBInfoMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgCurrTabWeatherDBInfoMethodResult& rfdfi_tclMsgCurrTabWeatherDBInfoMethodResult::operator=(const rfdfi_tclMsgCurrTabWeatherDBInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rfdfi_tclMsgCurrTabWeatherDBInfoMethodResult::u16GetServiceID() const {return RFDFI_C_U16_SERVICE_ID;}
tU16 rfdfi_tclMsgCurrTabWeatherDBInfoMethodResult::u16GetFunctionID() const {return RFDFI_C_U16_CURRTABWEATHERDBINFO;}
tU8 rfdfi_tclMsgCurrTabWeatherDBInfoMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rfdfi_tclMsgCurrTabWeatherDBInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool rfdfi_tclMsgCurrTabWeatherDBInfoMethodResult::operator==(const rfdfi_tclMsgCurrTabWeatherDBInfoMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ServiceStatus == rfoCmp.ServiceStatus);
   return bResult;
}

fi_tclInContext& rfdfi_tclMsgCurrTabWeatherDBInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> ServiceStatus;
   return oIn;
}

fi_tclOutContext& rfdfi_tclMsgCurrTabWeatherDBInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ServiceStatus;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgDeleteTabWeatherDBFileMethodStart::rfdfi_tclMsgDeleteTabWeatherDBFileMethodStart(const rfdfi_tclMsgDeleteTabWeatherDBFileMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateStatus = coRef.UpdateStatus;
   oListOfBaseLineFiles = coRef.oListOfBaseLineFiles;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgDeleteTabWeatherDBFileMethodStart& rfdfi_tclMsgDeleteTabWeatherDBFileMethodStart::operator=(const rfdfi_tclMsgDeleteTabWeatherDBFileMethodStart& coRef)
{
   if (this == &coRef) return *this;
   UpdateStatus = coRef.UpdateStatus;
   oListOfBaseLineFiles = coRef.oListOfBaseLineFiles;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rfdfi_tclMsgDeleteTabWeatherDBFileMethodStart::u16GetServiceID() const {return RFDFI_C_U16_SERVICE_ID;}
tU16 rfdfi_tclMsgDeleteTabWeatherDBFileMethodStart::u16GetFunctionID() const {return RFDFI_C_U16_DELETETABWEATHERDBFILE;}
tU8 rfdfi_tclMsgDeleteTabWeatherDBFileMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rfdfi_tclMsgDeleteTabWeatherDBFileMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oListOfBaseLineFiles.size(); ++u32Idx)
         oListOfBaseLineFiles[u32Idx].vDestroy();
   }
   oListOfBaseLineFiles.clear();
}

tU32 rfdfi_tclMsgDeleteTabWeatherDBFileMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oListOfBaseLineFiles.size(); ++u32ListIdx)
      u32DynamicSize += oListOfBaseLineFiles[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5;
}

tBool rfdfi_tclMsgDeleteTabWeatherDBFileMethodStart::operator==(const rfdfi_tclMsgDeleteTabWeatherDBFileMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateStatus == rfoCmp.UpdateStatus);
      bResult = bResult && (oListOfBaseLineFiles.size() == rfoCmp.oListOfBaseLineFiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oListOfBaseLineFiles.size()); ++u32Idx)
            bResult = bResult && (oListOfBaseLineFiles[u32Idx] == rfoCmp.oListOfBaseLineFiles[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rfdfi_tclMsgDeleteTabWeatherDBFileMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> UpdateStatus;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oListOfBaseLineFiles.size(); ++u32Idx)
      {
         oListOfBaseLineFiles[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      oListOfBaseLineFiles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> oListOfBaseLineFiles[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rfdfi_tclMsgDeleteTabWeatherDBFileMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UpdateStatus;
   oOut << (tU32)oListOfBaseLineFiles.size();
   {
      for (tU32 u32Idx = 0; u32Idx < oListOfBaseLineFiles.size(); ++u32Idx)
         oOut << oListOfBaseLineFiles[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgDeleteTabWeatherDBFileMethodResult::rfdfi_tclMsgDeleteTabWeatherDBFileMethodResult(const rfdfi_tclMsgDeleteTabWeatherDBFileMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgDeleteTabWeatherDBFileMethodResult& rfdfi_tclMsgDeleteTabWeatherDBFileMethodResult::operator=(const rfdfi_tclMsgDeleteTabWeatherDBFileMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rfdfi_tclMsgDeleteTabWeatherDBFileMethodResult::u16GetServiceID() const {return RFDFI_C_U16_SERVICE_ID;}
tU16 rfdfi_tclMsgDeleteTabWeatherDBFileMethodResult::u16GetFunctionID() const {return RFDFI_C_U16_DELETETABWEATHERDBFILE;}
tU8 rfdfi_tclMsgDeleteTabWeatherDBFileMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rfdfi_tclMsgDeleteTabWeatherDBFileMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool rfdfi_tclMsgDeleteTabWeatherDBFileMethodResult::operator==(const rfdfi_tclMsgDeleteTabWeatherDBFileMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ServiceStatus == rfoCmp.ServiceStatus);
   return bResult;
}

fi_tclInContext& rfdfi_tclMsgDeleteTabWeatherDBFileMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> ServiceStatus;
   return oIn;
}

fi_tclOutContext& rfdfi_tclMsgDeleteTabWeatherDBFileMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ServiceStatus;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgAcquireDataAccessMethodStart::rfdfi_tclMsgAcquireDataAccessMethodStart(const rfdfi_tclMsgAcquireDataAccessMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   Protocol = coRef.Protocol;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgAcquireDataAccessMethodStart& rfdfi_tclMsgAcquireDataAccessMethodStart::operator=(const rfdfi_tclMsgAcquireDataAccessMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Protocol = coRef.Protocol;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rfdfi_tclMsgAcquireDataAccessMethodStart::u16GetServiceID() const {return RFDFI_C_U16_SERVICE_ID;}
tU16 rfdfi_tclMsgAcquireDataAccessMethodStart::u16GetFunctionID() const {return RFDFI_C_U16_ACQUIREDATAACCESS;}
tU8 rfdfi_tclMsgAcquireDataAccessMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rfdfi_tclMsgAcquireDataAccessMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool rfdfi_tclMsgAcquireDataAccessMethodStart::operator==(const rfdfi_tclMsgAcquireDataAccessMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Protocol == rfoCmp.Protocol);
   return bResult;
}

fi_tclInContext& rfdfi_tclMsgAcquireDataAccessMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> Protocol;
   return oIn;
}

fi_tclOutContext& rfdfi_tclMsgAcquireDataAccessMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Protocol;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgAcquireDataAccessMethodResult::rfdfi_tclMsgAcquireDataAccessMethodResult(const rfdfi_tclMsgAcquireDataAccessMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Protocol = coRef.Protocol;
   AccessGiven = coRef.AccessGiven;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgAcquireDataAccessMethodResult& rfdfi_tclMsgAcquireDataAccessMethodResult::operator=(const rfdfi_tclMsgAcquireDataAccessMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Protocol = coRef.Protocol;
   AccessGiven = coRef.AccessGiven;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rfdfi_tclMsgAcquireDataAccessMethodResult::u16GetServiceID() const {return RFDFI_C_U16_SERVICE_ID;}
tU16 rfdfi_tclMsgAcquireDataAccessMethodResult::u16GetFunctionID() const {return RFDFI_C_U16_ACQUIREDATAACCESS;}
tU8 rfdfi_tclMsgAcquireDataAccessMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rfdfi_tclMsgAcquireDataAccessMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool rfdfi_tclMsgAcquireDataAccessMethodResult::operator==(const rfdfi_tclMsgAcquireDataAccessMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Protocol == rfoCmp.Protocol);
      bResult = bResult && (AccessGiven == rfoCmp.AccessGiven);
   return bResult;
}

fi_tclInContext& rfdfi_tclMsgAcquireDataAccessMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> Protocol;
   oIn >> AccessGiven;
   return oIn;
}

fi_tclOutContext& rfdfi_tclMsgAcquireDataAccessMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Protocol;
   oOut << AccessGiven;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgReleaseDataAccessMethodStart::rfdfi_tclMsgReleaseDataAccessMethodStart(const rfdfi_tclMsgReleaseDataAccessMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   Protocol = coRef.Protocol;
   CorruptFiles = coRef.CorruptFiles;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgReleaseDataAccessMethodStart& rfdfi_tclMsgReleaseDataAccessMethodStart::operator=(const rfdfi_tclMsgReleaseDataAccessMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Protocol = coRef.Protocol;
   CorruptFiles = coRef.CorruptFiles;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rfdfi_tclMsgReleaseDataAccessMethodStart::u16GetServiceID() const {return RFDFI_C_U16_SERVICE_ID;}
tU16 rfdfi_tclMsgReleaseDataAccessMethodStart::u16GetFunctionID() const {return RFDFI_C_U16_RELEASEDATAACCESS;}
tU8 rfdfi_tclMsgReleaseDataAccessMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rfdfi_tclMsgReleaseDataAccessMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < CorruptFiles.size(); ++u32Idx)
         CorruptFiles[u32Idx].vDestroy();
   }
   CorruptFiles.clear();
}

tU32 rfdfi_tclMsgReleaseDataAccessMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < CorruptFiles.size(); ++u32ListIdx)
      u32DynamicSize += CorruptFiles[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5;
}

tBool rfdfi_tclMsgReleaseDataAccessMethodStart::operator==(const rfdfi_tclMsgReleaseDataAccessMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Protocol == rfoCmp.Protocol);
      bResult = bResult && (CorruptFiles.size() == rfoCmp.CorruptFiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CorruptFiles.size()); ++u32Idx)
            bResult = bResult && (CorruptFiles[u32Idx] == rfoCmp.CorruptFiles[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rfdfi_tclMsgReleaseDataAccessMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> Protocol;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CorruptFiles.size(); ++u32Idx)
      {
         CorruptFiles[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      CorruptFiles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CorruptFiles[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rfdfi_tclMsgReleaseDataAccessMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Protocol;
   oOut << (tU32)CorruptFiles.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CorruptFiles.size(); ++u32Idx)
         oOut << CorruptFiles[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgReleaseDataAccessMethodResult::rfdfi_tclMsgReleaseDataAccessMethodResult(const rfdfi_tclMsgReleaseDataAccessMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Protocol = coRef.Protocol;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgReleaseDataAccessMethodResult& rfdfi_tclMsgReleaseDataAccessMethodResult::operator=(const rfdfi_tclMsgReleaseDataAccessMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Protocol = coRef.Protocol;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rfdfi_tclMsgReleaseDataAccessMethodResult::u16GetServiceID() const {return RFDFI_C_U16_SERVICE_ID;}
tU16 rfdfi_tclMsgReleaseDataAccessMethodResult::u16GetFunctionID() const {return RFDFI_C_U16_RELEASEDATAACCESS;}
tU8 rfdfi_tclMsgReleaseDataAccessMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rfdfi_tclMsgReleaseDataAccessMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool rfdfi_tclMsgReleaseDataAccessMethodResult::operator==(const rfdfi_tclMsgReleaseDataAccessMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Protocol == rfoCmp.Protocol);
   return bResult;
}

fi_tclInContext& rfdfi_tclMsgReleaseDataAccessMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> Protocol;
   return oIn;
}

fi_tclOutContext& rfdfi_tclMsgReleaseDataAccessMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Protocol;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgRevertExistingDataBaseMethodStart::rfdfi_tclMsgRevertExistingDataBaseMethodStart(const rfdfi_tclMsgRevertExistingDataBaseMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   Protocol = coRef.Protocol;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgRevertExistingDataBaseMethodStart& rfdfi_tclMsgRevertExistingDataBaseMethodStart::operator=(const rfdfi_tclMsgRevertExistingDataBaseMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Protocol = coRef.Protocol;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rfdfi_tclMsgRevertExistingDataBaseMethodStart::u16GetServiceID() const {return RFDFI_C_U16_SERVICE_ID;}
tU16 rfdfi_tclMsgRevertExistingDataBaseMethodStart::u16GetFunctionID() const {return RFDFI_C_U16_REVERTEXISTINGDATABASE;}
tU8 rfdfi_tclMsgRevertExistingDataBaseMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rfdfi_tclMsgRevertExistingDataBaseMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool rfdfi_tclMsgRevertExistingDataBaseMethodStart::operator==(const rfdfi_tclMsgRevertExistingDataBaseMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Protocol == rfoCmp.Protocol);
   return bResult;
}

fi_tclInContext& rfdfi_tclMsgRevertExistingDataBaseMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> Protocol;
   return oIn;
}

fi_tclOutContext& rfdfi_tclMsgRevertExistingDataBaseMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Protocol;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgRevertExistingDataBaseMethodResult::rfdfi_tclMsgRevertExistingDataBaseMethodResult(const rfdfi_tclMsgRevertExistingDataBaseMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Protocol = coRef.Protocol;
   DataBaseReverted = coRef.DataBaseReverted;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgRevertExistingDataBaseMethodResult& rfdfi_tclMsgRevertExistingDataBaseMethodResult::operator=(const rfdfi_tclMsgRevertExistingDataBaseMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Protocol = coRef.Protocol;
   DataBaseReverted = coRef.DataBaseReverted;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rfdfi_tclMsgRevertExistingDataBaseMethodResult::u16GetServiceID() const {return RFDFI_C_U16_SERVICE_ID;}
tU16 rfdfi_tclMsgRevertExistingDataBaseMethodResult::u16GetFunctionID() const {return RFDFI_C_U16_REVERTEXISTINGDATABASE;}
tU8 rfdfi_tclMsgRevertExistingDataBaseMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rfdfi_tclMsgRevertExistingDataBaseMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool rfdfi_tclMsgRevertExistingDataBaseMethodResult::operator==(const rfdfi_tclMsgRevertExistingDataBaseMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Protocol == rfoCmp.Protocol);
      bResult = bResult && (DataBaseReverted == rfoCmp.DataBaseReverted);
   return bResult;
}

fi_tclInContext& rfdfi_tclMsgRevertExistingDataBaseMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> Protocol;
   oIn >> DataBaseReverted;
   return oIn;
}

fi_tclOutContext& rfdfi_tclMsgRevertExistingDataBaseMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Protocol;
   oOut << DataBaseReverted;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgTabWeatherDBUpdatedUpReg::rfdfi_tclMsgTabWeatherDBUpdatedUpReg(const rfdfi_tclMsgTabWeatherDBUpdatedUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgTabWeatherDBUpdatedUpReg& rfdfi_tclMsgTabWeatherDBUpdatedUpReg::operator=(const rfdfi_tclMsgTabWeatherDBUpdatedUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rfdfi_tclMsgTabWeatherDBUpdatedUpReg::u16GetServiceID() const {return RFDFI_C_U16_SERVICE_ID;}
tU16 rfdfi_tclMsgTabWeatherDBUpdatedUpReg::u16GetFunctionID() const {return RFDFI_C_U16_TABWEATHERDBUPDATED;}
tU8 rfdfi_tclMsgTabWeatherDBUpdatedUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 rfdfi_tclMsgTabWeatherDBUpdatedUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rfdfi_tclMsgTabWeatherDBUpdatedUpReg::operator==(const rfdfi_tclMsgTabWeatherDBUpdatedUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rfdfi_tclMsgTabWeatherDBUpdatedUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rfdfi_tclMsgTabWeatherDBUpdatedUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgTabWeatherDBUpdatedRelUpReg::rfdfi_tclMsgTabWeatherDBUpdatedRelUpReg(const rfdfi_tclMsgTabWeatherDBUpdatedRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgTabWeatherDBUpdatedRelUpReg& rfdfi_tclMsgTabWeatherDBUpdatedRelUpReg::operator=(const rfdfi_tclMsgTabWeatherDBUpdatedRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rfdfi_tclMsgTabWeatherDBUpdatedRelUpReg::u16GetServiceID() const {return RFDFI_C_U16_SERVICE_ID;}
tU16 rfdfi_tclMsgTabWeatherDBUpdatedRelUpReg::u16GetFunctionID() const {return RFDFI_C_U16_TABWEATHERDBUPDATED;}
tU8 rfdfi_tclMsgTabWeatherDBUpdatedRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 rfdfi_tclMsgTabWeatherDBUpdatedRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rfdfi_tclMsgTabWeatherDBUpdatedRelUpReg::operator==(const rfdfi_tclMsgTabWeatherDBUpdatedRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rfdfi_tclMsgTabWeatherDBUpdatedRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rfdfi_tclMsgTabWeatherDBUpdatedRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgTabWeatherDBUpdatedGet::rfdfi_tclMsgTabWeatherDBUpdatedGet(const rfdfi_tclMsgTabWeatherDBUpdatedGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgTabWeatherDBUpdatedGet& rfdfi_tclMsgTabWeatherDBUpdatedGet::operator=(const rfdfi_tclMsgTabWeatherDBUpdatedGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rfdfi_tclMsgTabWeatherDBUpdatedGet::u16GetServiceID() const {return RFDFI_C_U16_SERVICE_ID;}
tU16 rfdfi_tclMsgTabWeatherDBUpdatedGet::u16GetFunctionID() const {return RFDFI_C_U16_TABWEATHERDBUPDATED;}
tU8 rfdfi_tclMsgTabWeatherDBUpdatedGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rfdfi_tclMsgTabWeatherDBUpdatedGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rfdfi_tclMsgTabWeatherDBUpdatedGet::operator==(const rfdfi_tclMsgTabWeatherDBUpdatedGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rfdfi_tclMsgTabWeatherDBUpdatedGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rfdfi_tclMsgTabWeatherDBUpdatedGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgTabWeatherDBUpdatedStatus::rfdfi_tclMsgTabWeatherDBUpdatedStatus(const rfdfi_tclMsgTabWeatherDBUpdatedStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   oListOfBaseLineFiles = coRef.oListOfBaseLineFiles;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgTabWeatherDBUpdatedStatus& rfdfi_tclMsgTabWeatherDBUpdatedStatus::operator=(const rfdfi_tclMsgTabWeatherDBUpdatedStatus& coRef)
{
   if (this == &coRef) return *this;
   oListOfBaseLineFiles = coRef.oListOfBaseLineFiles;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rfdfi_tclMsgTabWeatherDBUpdatedStatus::u16GetServiceID() const {return RFDFI_C_U16_SERVICE_ID;}
tU16 rfdfi_tclMsgTabWeatherDBUpdatedStatus::u16GetFunctionID() const {return RFDFI_C_U16_TABWEATHERDBUPDATED;}
tU8 rfdfi_tclMsgTabWeatherDBUpdatedStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rfdfi_tclMsgTabWeatherDBUpdatedStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oListOfBaseLineFiles.size(); ++u32Idx)
         oListOfBaseLineFiles[u32Idx].vDestroy();
   }
   oListOfBaseLineFiles.clear();
}

tU32 rfdfi_tclMsgTabWeatherDBUpdatedStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oListOfBaseLineFiles.size(); ++u32ListIdx)
      u32DynamicSize += oListOfBaseLineFiles[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool rfdfi_tclMsgTabWeatherDBUpdatedStatus::operator==(const rfdfi_tclMsgTabWeatherDBUpdatedStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (oListOfBaseLineFiles.size() == rfoCmp.oListOfBaseLineFiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oListOfBaseLineFiles.size()); ++u32Idx)
            bResult = bResult && (oListOfBaseLineFiles[u32Idx] == rfoCmp.oListOfBaseLineFiles[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rfdfi_tclMsgTabWeatherDBUpdatedStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oListOfBaseLineFiles.size(); ++u32Idx)
      {
         oListOfBaseLineFiles[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      oListOfBaseLineFiles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> oListOfBaseLineFiles[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rfdfi_tclMsgTabWeatherDBUpdatedStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)oListOfBaseLineFiles.size();
   {
      for (tU32 u32Idx = 0; u32Idx < oListOfBaseLineFiles.size(); ++u32Idx)
         oOut << oListOfBaseLineFiles[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgExchangeDirectoryContentUpReg::rfdfi_tclMsgExchangeDirectoryContentUpReg(const rfdfi_tclMsgExchangeDirectoryContentUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgExchangeDirectoryContentUpReg& rfdfi_tclMsgExchangeDirectoryContentUpReg::operator=(const rfdfi_tclMsgExchangeDirectoryContentUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rfdfi_tclMsgExchangeDirectoryContentUpReg::u16GetServiceID() const {return RFDFI_C_U16_SERVICE_ID;}
tU16 rfdfi_tclMsgExchangeDirectoryContentUpReg::u16GetFunctionID() const {return RFDFI_C_U16_EXCHANGEDIRECTORYCONTENT;}
tU8 rfdfi_tclMsgExchangeDirectoryContentUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 rfdfi_tclMsgExchangeDirectoryContentUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rfdfi_tclMsgExchangeDirectoryContentUpReg::operator==(const rfdfi_tclMsgExchangeDirectoryContentUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rfdfi_tclMsgExchangeDirectoryContentUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rfdfi_tclMsgExchangeDirectoryContentUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgExchangeDirectoryContentRelUpReg::rfdfi_tclMsgExchangeDirectoryContentRelUpReg(const rfdfi_tclMsgExchangeDirectoryContentRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgExchangeDirectoryContentRelUpReg& rfdfi_tclMsgExchangeDirectoryContentRelUpReg::operator=(const rfdfi_tclMsgExchangeDirectoryContentRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rfdfi_tclMsgExchangeDirectoryContentRelUpReg::u16GetServiceID() const {return RFDFI_C_U16_SERVICE_ID;}
tU16 rfdfi_tclMsgExchangeDirectoryContentRelUpReg::u16GetFunctionID() const {return RFDFI_C_U16_EXCHANGEDIRECTORYCONTENT;}
tU8 rfdfi_tclMsgExchangeDirectoryContentRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 rfdfi_tclMsgExchangeDirectoryContentRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rfdfi_tclMsgExchangeDirectoryContentRelUpReg::operator==(const rfdfi_tclMsgExchangeDirectoryContentRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rfdfi_tclMsgExchangeDirectoryContentRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rfdfi_tclMsgExchangeDirectoryContentRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgExchangeDirectoryContentGet::rfdfi_tclMsgExchangeDirectoryContentGet(const rfdfi_tclMsgExchangeDirectoryContentGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgExchangeDirectoryContentGet& rfdfi_tclMsgExchangeDirectoryContentGet::operator=(const rfdfi_tclMsgExchangeDirectoryContentGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rfdfi_tclMsgExchangeDirectoryContentGet::u16GetServiceID() const {return RFDFI_C_U16_SERVICE_ID;}
tU16 rfdfi_tclMsgExchangeDirectoryContentGet::u16GetFunctionID() const {return RFDFI_C_U16_EXCHANGEDIRECTORYCONTENT;}
tU8 rfdfi_tclMsgExchangeDirectoryContentGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rfdfi_tclMsgExchangeDirectoryContentGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rfdfi_tclMsgExchangeDirectoryContentGet::operator==(const rfdfi_tclMsgExchangeDirectoryContentGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rfdfi_tclMsgExchangeDirectoryContentGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rfdfi_tclMsgExchangeDirectoryContentGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgExchangeDirectoryContentStatus::rfdfi_tclMsgExchangeDirectoryContentStatus(const rfdfi_tclMsgExchangeDirectoryContentStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ListOfFilesPerProtocol = coRef.ListOfFilesPerProtocol;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rfdfi_tclMsgExchangeDirectoryContentStatus& rfdfi_tclMsgExchangeDirectoryContentStatus::operator=(const rfdfi_tclMsgExchangeDirectoryContentStatus& coRef)
{
   if (this == &coRef) return *this;
   ListOfFilesPerProtocol = coRef.ListOfFilesPerProtocol;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rfdfi_tclMsgExchangeDirectoryContentStatus::u16GetServiceID() const {return RFDFI_C_U16_SERVICE_ID;}
tU16 rfdfi_tclMsgExchangeDirectoryContentStatus::u16GetFunctionID() const {return RFDFI_C_U16_EXCHANGEDIRECTORYCONTENT;}
tU8 rfdfi_tclMsgExchangeDirectoryContentStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rfdfi_tclMsgExchangeDirectoryContentStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfFilesPerProtocol.size(); ++u32Idx)
         ListOfFilesPerProtocol[u32Idx].vDestroy();
   }
   ListOfFilesPerProtocol.clear();
}

tU32 rfdfi_tclMsgExchangeDirectoryContentStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ListOfFilesPerProtocol.size(); ++u32ListIdx)
      u32DynamicSize += ListOfFilesPerProtocol[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool rfdfi_tclMsgExchangeDirectoryContentStatus::operator==(const rfdfi_tclMsgExchangeDirectoryContentStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ListOfFilesPerProtocol.size() == rfoCmp.ListOfFilesPerProtocol.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfFilesPerProtocol.size()); ++u32Idx)
            bResult = bResult && (ListOfFilesPerProtocol[u32Idx] == rfoCmp.ListOfFilesPerProtocol[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rfdfi_tclMsgExchangeDirectoryContentStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfFilesPerProtocol.size(); ++u32Idx)
      {
         ListOfFilesPerProtocol[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ListOfFilesPerProtocol.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfFilesPerProtocol[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rfdfi_tclMsgExchangeDirectoryContentStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ListOfFilesPerProtocol.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfFilesPerProtocol.size(); ++u32Idx)
         oOut << ListOfFilesPerProtocol[u32Idx];
   }
   return oOut;
}

