/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef REGIONKNITTERFITYPES_HEADER
#define REGIONKNITTERFITYPES_HEADER

// #include <vector>
// 


class regionknitterfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class regionknitterfi_tclMsgKnitRegionMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   regionknitterfi_tclMsgKnitRegionMethodStart():KnitMediumId(0),KnitDevice(),RegionProductionDate(0),OriginSourceMediumId(0),SourceMediumId(0),SourceDevice(),KnitRegion(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   regionknitterfi_tclMsgKnitRegionMethodStart& operator=(const regionknitterfi_tclMsgKnitRegionMethodStart& coRef);
   regionknitterfi_tclMsgKnitRegionMethodStart(const regionknitterfi_tclMsgKnitRegionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 KnitMediumId;
   fi_tclString KnitDevice;
   tU32 RegionProductionDate;
   tU32 OriginSourceMediumId;
   tU32 SourceMediumId;
   fi_tclString SourceDevice;
   tU16 KnitRegion;
   std::vector<tU16, std::allocator<tU16> > NeighbourRegions;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const regionknitterfi_tclMsgKnitRegionMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return regionknitterfi_tclToken::EN_MSG_KNITREGIONMETHODSTART;}
};

class regionknitterfi_tclMsgKnitRegionMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   regionknitterfi_tclMsgKnitRegionMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   regionknitterfi_tclMsgKnitRegionMethodResult& operator=(const regionknitterfi_tclMsgKnitRegionMethodResult& coRef);
   regionknitterfi_tclMsgKnitRegionMethodResult(const regionknitterfi_tclMsgKnitRegionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const regionknitterfi_tclMsgKnitRegionMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return regionknitterfi_tclToken::EN_MSG_KNITREGIONMETHODRESULT;}
};

class regionknitterfi_tclMsgUnknitRegionsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   regionknitterfi_tclMsgUnknitRegionsMethodStart():KnitMediumId(0),KnitDevice() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   regionknitterfi_tclMsgUnknitRegionsMethodStart& operator=(const regionknitterfi_tclMsgUnknitRegionsMethodStart& coRef);
   regionknitterfi_tclMsgUnknitRegionsMethodStart(const regionknitterfi_tclMsgUnknitRegionsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 KnitMediumId;
   fi_tclString KnitDevice;
   std::vector<tU16, std::allocator<tU16> > RemoveRegions;
   std::vector<tU16, std::allocator<tU16> > NeighbourRegions;
   std::vector<tU32, std::allocator<tU32> > RegionProductionDates;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const regionknitterfi_tclMsgUnknitRegionsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return regionknitterfi_tclToken::EN_MSG_UNKNITREGIONSMETHODSTART;}
};

class regionknitterfi_tclMsgUnknitRegionsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   regionknitterfi_tclMsgUnknitRegionsMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   regionknitterfi_tclMsgUnknitRegionsMethodResult& operator=(const regionknitterfi_tclMsgUnknitRegionsMethodResult& coRef);
   regionknitterfi_tclMsgUnknitRegionsMethodResult(const regionknitterfi_tclMsgUnknitRegionsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_RegionStatus, std::allocator<fi_tcl_RegionStatus> > Status;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const regionknitterfi_tclMsgUnknitRegionsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return regionknitterfi_tclToken::EN_MSG_UNKNITREGIONSMETHODRESULT;}
};

class regionknitterfi_tclMsgResumeMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   regionknitterfi_tclMsgResumeMethodStart():enMode(),enOperation(),KnitMediumId(0),KnitDevice(),RegionProductionDate(0),OriginSourceMediumId(0),SourceMediumId(0),SourceDevice() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   regionknitterfi_tclMsgResumeMethodStart& operator=(const regionknitterfi_tclMsgResumeMethodStart& coRef);
   regionknitterfi_tclMsgResumeMethodStart(const regionknitterfi_tclMsgResumeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_ResumeMode enMode;
   fi_tcl_e8_ResumedOperation enOperation;
   tU32 KnitMediumId;
   fi_tclString KnitDevice;
   tU32 RegionProductionDate;
   tU32 OriginSourceMediumId;
   tU32 SourceMediumId;
   fi_tclString SourceDevice;
   std::vector<tU16, std::allocator<tU16> > Regions;
   std::vector<tU16, std::allocator<tU16> > NeighbourRegions;
   std::vector<tU32, std::allocator<tU32> > RegionProductionDates;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const regionknitterfi_tclMsgResumeMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return regionknitterfi_tclToken::EN_MSG_RESUMEMETHODSTART;}
};

class regionknitterfi_tclMsgResumeMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   regionknitterfi_tclMsgResumeMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   regionknitterfi_tclMsgResumeMethodResult& operator=(const regionknitterfi_tclMsgResumeMethodResult& coRef);
   regionknitterfi_tclMsgResumeMethodResult(const regionknitterfi_tclMsgResumeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_RegionStatus, std::allocator<fi_tcl_RegionStatus> > Status;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const regionknitterfi_tclMsgResumeMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return regionknitterfi_tclToken::EN_MSG_RESUMEMETHODRESULT;}
};

class regionknitterfi_tclMsgPreKnitRegionMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   regionknitterfi_tclMsgPreKnitRegionMethodStart():KnitMediumId(0),KnitDevice(),RegionProductionDate(0),OriginSourceMediumId(0),SourceMediumId(0),SourceDevice(),KnitRegion(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   regionknitterfi_tclMsgPreKnitRegionMethodStart& operator=(const regionknitterfi_tclMsgPreKnitRegionMethodStart& coRef);
   regionknitterfi_tclMsgPreKnitRegionMethodStart(const regionknitterfi_tclMsgPreKnitRegionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 KnitMediumId;
   fi_tclString KnitDevice;
   tU32 RegionProductionDate;
   tU32 OriginSourceMediumId;
   tU32 SourceMediumId;
   fi_tclString SourceDevice;
   tU16 KnitRegion;
   std::vector<tU16, std::allocator<tU16> > NeighbourRegions;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const regionknitterfi_tclMsgPreKnitRegionMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return regionknitterfi_tclToken::EN_MSG_PREKNITREGIONMETHODSTART;}
};

class regionknitterfi_tclMsgPreKnitRegionMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   regionknitterfi_tclMsgPreKnitRegionMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   regionknitterfi_tclMsgPreKnitRegionMethodResult& operator=(const regionknitterfi_tclMsgPreKnitRegionMethodResult& coRef);
   regionknitterfi_tclMsgPreKnitRegionMethodResult(const regionknitterfi_tclMsgPreKnitRegionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const regionknitterfi_tclMsgPreKnitRegionMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return regionknitterfi_tclToken::EN_MSG_PREKNITREGIONMETHODRESULT;}
};

class regionknitterfi_tclMsgPostUnknitRegionsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   regionknitterfi_tclMsgPostUnknitRegionsMethodStart():KnitMediumId(0),KnitDevice() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   regionknitterfi_tclMsgPostUnknitRegionsMethodStart& operator=(const regionknitterfi_tclMsgPostUnknitRegionsMethodStart& coRef);
   regionknitterfi_tclMsgPostUnknitRegionsMethodStart(const regionknitterfi_tclMsgPostUnknitRegionsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 KnitMediumId;
   fi_tclString KnitDevice;
   std::vector<tU16, std::allocator<tU16> > RemoveRegions;
   std::vector<tU16, std::allocator<tU16> > NeighbourRegions;
   std::vector<tU32, std::allocator<tU32> > RegionProductionDates;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const regionknitterfi_tclMsgPostUnknitRegionsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return regionknitterfi_tclToken::EN_MSG_POSTUNKNITREGIONSMETHODSTART;}
};

class regionknitterfi_tclMsgPostUnknitRegionsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   regionknitterfi_tclMsgPostUnknitRegionsMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   regionknitterfi_tclMsgPostUnknitRegionsMethodResult& operator=(const regionknitterfi_tclMsgPostUnknitRegionsMethodResult& coRef);
   regionknitterfi_tclMsgPostUnknitRegionsMethodResult(const regionknitterfi_tclMsgPostUnknitRegionsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_RegionStatus, std::allocator<fi_tcl_RegionStatus> > Status;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const regionknitterfi_tclMsgPostUnknitRegionsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return regionknitterfi_tclToken::EN_MSG_POSTUNKNITREGIONSMETHODRESULT;}
};


#endif
