#ifndef REGIONKNITTERFILANGUAGE_HEADER
#define REGIONKNITTERFILANGUAGE_HEADER

class regionknitterfi_tclInContext;
class regionknitterfi_tclOutContext;
class regionknitterfi_tclVisitorBase;

class MY_DECL regionknitterfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  regionknitterfi_tclDescription(fi_tclInContext* poIn, regionknitterfi_tclVisitorBase* poVisit);
  regionknitterfi_tclDescription(fi_tclOutContext* poOut, regionknitterfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(regionknitterfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ regionknitterfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  regionknitterfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<regionknitterfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<regionknitterfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline regionknitterfi_tclDescription::regionknitterfi_tclDescription(fi_tclInContext* poIn, regionknitterfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline regionknitterfi_tclDescription::regionknitterfi_tclDescription(fi_tclOutContext* poOut, regionknitterfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

