/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetRouteCapabilitiesMethodStart::rcfi_tclMsgGetRouteCapabilitiesMethodStart(const rcfi_tclMsgGetRouteCapabilitiesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetRouteCapabilitiesMethodStart& rcfi_tclMsgGetRouteCapabilitiesMethodStart::operator=(const rcfi_tclMsgGetRouteCapabilitiesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgGetRouteCapabilitiesMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgGetRouteCapabilitiesMethodStart::u16GetFunctionID() const {return RCFI_C_U16_GETROUTECAPABILITIES;}
tU8 rcfi_tclMsgGetRouteCapabilitiesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rcfi_tclMsgGetRouteCapabilitiesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgGetRouteCapabilitiesMethodStart::operator==(const rcfi_tclMsgGetRouteCapabilitiesMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgGetRouteCapabilitiesMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgGetRouteCapabilitiesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetRouteCapabilitiesMethodResult::rcfi_tclMsgGetRouteCapabilitiesMethodResult(const rcfi_tclMsgGetRouteCapabilitiesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   CapabilityList = coRef.CapabilityList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetRouteCapabilitiesMethodResult& rcfi_tclMsgGetRouteCapabilitiesMethodResult::operator=(const rcfi_tclMsgGetRouteCapabilitiesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   CapabilityList = coRef.CapabilityList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgGetRouteCapabilitiesMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgGetRouteCapabilitiesMethodResult::u16GetFunctionID() const {return RCFI_C_U16_GETROUTECAPABILITIES;}
tU8 rcfi_tclMsgGetRouteCapabilitiesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rcfi_tclMsgGetRouteCapabilitiesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < CapabilityList.size(); ++u32Idx)
         CapabilityList[u32Idx].vDestroy();
   }
   CapabilityList.clear();
}

tU32 rcfi_tclMsgGetRouteCapabilitiesMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+CapabilityList.size()*2;
}

tBool rcfi_tclMsgGetRouteCapabilitiesMethodResult::operator==(const rcfi_tclMsgGetRouteCapabilitiesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CapabilityList.size() == rfoCmp.CapabilityList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CapabilityList.size()); ++u32Idx)
            bResult = bResult && (CapabilityList[u32Idx] == rfoCmp.CapabilityList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgGetRouteCapabilitiesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CapabilityList.size(); ++u32Idx)
      {
         CapabilityList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      CapabilityList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CapabilityList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgGetRouteCapabilitiesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)CapabilityList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CapabilityList.size(); ++u32Idx)
         oOut << CapabilityList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetRouteCalcOptionsMethodStart::rcfi_tclMsgGetRouteCalcOptionsMethodStart(const rcfi_tclMsgGetRouteCalcOptionsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   CurrentRouteOptions = coRef.CurrentRouteOptions;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetRouteCalcOptionsMethodStart& rcfi_tclMsgGetRouteCalcOptionsMethodStart::operator=(const rcfi_tclMsgGetRouteCalcOptionsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CurrentRouteOptions = coRef.CurrentRouteOptions;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgGetRouteCalcOptionsMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgGetRouteCalcOptionsMethodStart::u16GetFunctionID() const {return RCFI_C_U16_GETROUTECALCOPTIONS;}
tU8 rcfi_tclMsgGetRouteCalcOptionsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rcfi_tclMsgGetRouteCalcOptionsMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < CurrentRouteOptions.size(); ++u32Idx)
         CurrentRouteOptions[u32Idx].vDestroy();
   }
   CurrentRouteOptions.clear();
}

tU32 rcfi_tclMsgGetRouteCalcOptionsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < CurrentRouteOptions.size(); ++u32ListIdx)
      u32DynamicSize += CurrentRouteOptions[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool rcfi_tclMsgGetRouteCalcOptionsMethodStart::operator==(const rcfi_tclMsgGetRouteCalcOptionsMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CurrentRouteOptions.size() == rfoCmp.CurrentRouteOptions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CurrentRouteOptions.size()); ++u32Idx)
            bResult = bResult && (CurrentRouteOptions[u32Idx] == rfoCmp.CurrentRouteOptions[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgGetRouteCalcOptionsMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CurrentRouteOptions.size(); ++u32Idx)
      {
         CurrentRouteOptions[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      CurrentRouteOptions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CurrentRouteOptions[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgGetRouteCalcOptionsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)CurrentRouteOptions.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CurrentRouteOptions.size(); ++u32Idx)
         oOut << CurrentRouteOptions[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetRouteCalcOptionsMethodResult::rcfi_tclMsgGetRouteCalcOptionsMethodResult(const rcfi_tclMsgGetRouteCalcOptionsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   MinSumValue = coRef.MinSumValue;
   MaxSumValue = coRef.MaxSumValue;
   AvailableRouteOptions = coRef.AvailableRouteOptions;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetRouteCalcOptionsMethodResult& rcfi_tclMsgGetRouteCalcOptionsMethodResult::operator=(const rcfi_tclMsgGetRouteCalcOptionsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   MinSumValue = coRef.MinSumValue;
   MaxSumValue = coRef.MaxSumValue;
   AvailableRouteOptions = coRef.AvailableRouteOptions;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgGetRouteCalcOptionsMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgGetRouteCalcOptionsMethodResult::u16GetFunctionID() const {return RCFI_C_U16_GETROUTECALCOPTIONS;}
tU8 rcfi_tclMsgGetRouteCalcOptionsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rcfi_tclMsgGetRouteCalcOptionsMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AvailableRouteOptions.size(); ++u32Idx)
         AvailableRouteOptions[u32Idx].vDestroy();
   }
   AvailableRouteOptions.clear();
}

tU32 rcfi_tclMsgGetRouteCalcOptionsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+AvailableRouteOptions.size()*3;
}

tBool rcfi_tclMsgGetRouteCalcOptionsMethodResult::operator==(const rcfi_tclMsgGetRouteCalcOptionsMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MinSumValue == rfoCmp.MinSumValue);
      bResult = bResult && (MaxSumValue == rfoCmp.MaxSumValue);
      bResult = bResult && (AvailableRouteOptions.size() == rfoCmp.AvailableRouteOptions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AvailableRouteOptions.size()); ++u32Idx)
            bResult = bResult && (AvailableRouteOptions[u32Idx] == rfoCmp.AvailableRouteOptions[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgGetRouteCalcOptionsMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> MinSumValue;
   oIn >> MaxSumValue;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AvailableRouteOptions.size(); ++u32Idx)
      {
         AvailableRouteOptions[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      AvailableRouteOptions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AvailableRouteOptions[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgGetRouteCalcOptionsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MinSumValue;
   oOut << MaxSumValue;
   oOut << (tU32)AvailableRouteOptions.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AvailableRouteOptions.size(); ++u32Idx)
         oOut << AvailableRouteOptions[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgCheckProfileValidityMethodStart::rcfi_tclMsgCheckProfileValidityMethodStart(const rcfi_tclMsgCheckProfileValidityMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   SpeedProfiles = coRef.SpeedProfiles;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgCheckProfileValidityMethodStart& rcfi_tclMsgCheckProfileValidityMethodStart::operator=(const rcfi_tclMsgCheckProfileValidityMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SpeedProfiles = coRef.SpeedProfiles;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgCheckProfileValidityMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgCheckProfileValidityMethodStart::u16GetFunctionID() const {return RCFI_C_U16_CHECKPROFILEVALIDITY;}
tU8 rcfi_tclMsgCheckProfileValidityMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rcfi_tclMsgCheckProfileValidityMethodStart::vDestroy()
{
   SpeedProfiles.vDestroy(); 
}

tU32 rcfi_tclMsgCheckProfileValidityMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+SpeedProfiles.u32GetSize(u16MajorVersion);
}

tBool rcfi_tclMsgCheckProfileValidityMethodStart::operator==(const rcfi_tclMsgCheckProfileValidityMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SpeedProfiles == rfoCmp.SpeedProfiles);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgCheckProfileValidityMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> SpeedProfiles;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgCheckProfileValidityMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << SpeedProfiles;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgCheckProfileValidityMethodResult::rcfi_tclMsgCheckProfileValidityMethodResult(const rcfi_tclMsgCheckProfileValidityMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgCheckProfileValidityMethodResult& rcfi_tclMsgCheckProfileValidityMethodResult::operator=(const rcfi_tclMsgCheckProfileValidityMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgCheckProfileValidityMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgCheckProfileValidityMethodResult::u16GetFunctionID() const {return RCFI_C_U16_CHECKPROFILEVALIDITY;}
tU8 rcfi_tclMsgCheckProfileValidityMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rcfi_tclMsgCheckProfileValidityMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgCheckProfileValidityMethodResult::operator==(const rcfi_tclMsgCheckProfileValidityMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgCheckProfileValidityMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgCheckProfileValidityMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetStandardSpeedHistogramMethodStart::rcfi_tclMsgGetStandardSpeedHistogramMethodStart(const rcfi_tclMsgGetStandardSpeedHistogramMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavDataSetID = coRef.NavDataSetID;
   ProfileType = coRef.ProfileType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetStandardSpeedHistogramMethodStart& rcfi_tclMsgGetStandardSpeedHistogramMethodStart::operator=(const rcfi_tclMsgGetStandardSpeedHistogramMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NavDataSetID = coRef.NavDataSetID;
   ProfileType = coRef.ProfileType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgGetStandardSpeedHistogramMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgGetStandardSpeedHistogramMethodStart::u16GetFunctionID() const {return RCFI_C_U16_GETSTANDARDSPEEDHISTOGRAM;}
tU8 rcfi_tclMsgGetStandardSpeedHistogramMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rcfi_tclMsgGetStandardSpeedHistogramMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+1;
}

tBool rcfi_tclMsgGetStandardSpeedHistogramMethodStart::operator==(const rcfi_tclMsgGetStandardSpeedHistogramMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (ProfileType == rfoCmp.ProfileType);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgGetStandardSpeedHistogramMethodStart::oRead(fi_tclInContext& oIn)
{
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> NavDataSetID;
   }
   oIn >> ProfileType;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgGetStandardSpeedHistogramMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << NavDataSetID;
   }
   oOut << ProfileType;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetStandardSpeedHistogramMethodResult::rcfi_tclMsgGetStandardSpeedHistogramMethodResult(const rcfi_tclMsgGetStandardSpeedHistogramMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavDataSetID = coRef.NavDataSetID;
   UserProfile = coRef.UserProfile;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetStandardSpeedHistogramMethodResult& rcfi_tclMsgGetStandardSpeedHistogramMethodResult::operator=(const rcfi_tclMsgGetStandardSpeedHistogramMethodResult& coRef)
{
   if (this == &coRef) return *this;
   NavDataSetID = coRef.NavDataSetID;
   UserProfile = coRef.UserProfile;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgGetStandardSpeedHistogramMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgGetStandardSpeedHistogramMethodResult::u16GetFunctionID() const {return RCFI_C_U16_GETSTANDARDSPEEDHISTOGRAM;}
tU8 rcfi_tclMsgGetStandardSpeedHistogramMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rcfi_tclMsgGetStandardSpeedHistogramMethodResult::vDestroy()
{
   UserProfile.vDestroy(); 
}

tU32 rcfi_tclMsgGetStandardSpeedHistogramMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+0+UserProfile.u32GetSize(u16MajorVersion);
}

tBool rcfi_tclMsgGetStandardSpeedHistogramMethodResult::operator==(const rcfi_tclMsgGetStandardSpeedHistogramMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (UserProfile == rfoCmp.UserProfile);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgGetStandardSpeedHistogramMethodResult::oRead(fi_tclInContext& oIn)
{
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> NavDataSetID;
   }
   oIn >> UserProfile;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgGetStandardSpeedHistogramMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << NavDataSetID;
   }
   oOut << UserProfile;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetDefaultVehicleParameterMethodStart::rcfi_tclMsgGetDefaultVehicleParameterMethodStart(const rcfi_tclMsgGetDefaultVehicleParameterMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   VehicleClass = coRef.VehicleClass;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetDefaultVehicleParameterMethodStart& rcfi_tclMsgGetDefaultVehicleParameterMethodStart::operator=(const rcfi_tclMsgGetDefaultVehicleParameterMethodStart& coRef)
{
   if (this == &coRef) return *this;
   VehicleClass = coRef.VehicleClass;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgGetDefaultVehicleParameterMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgGetDefaultVehicleParameterMethodStart::u16GetFunctionID() const {return RCFI_C_U16_GETDEFAULTVEHICLEPARAMETER;}
tU8 rcfi_tclMsgGetDefaultVehicleParameterMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rcfi_tclMsgGetDefaultVehicleParameterMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool rcfi_tclMsgGetDefaultVehicleParameterMethodStart::operator==(const rcfi_tclMsgGetDefaultVehicleParameterMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (VehicleClass == rfoCmp.VehicleClass);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgGetDefaultVehicleParameterMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> VehicleClass;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgGetDefaultVehicleParameterMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << VehicleClass;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetDefaultVehicleParameterMethodResult::rcfi_tclMsgGetDefaultVehicleParameterMethodResult(const rcfi_tclMsgGetDefaultVehicleParameterMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   VehicleParameter = coRef.VehicleParameter;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetDefaultVehicleParameterMethodResult& rcfi_tclMsgGetDefaultVehicleParameterMethodResult::operator=(const rcfi_tclMsgGetDefaultVehicleParameterMethodResult& coRef)
{
   if (this == &coRef) return *this;
   VehicleParameter = coRef.VehicleParameter;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgGetDefaultVehicleParameterMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgGetDefaultVehicleParameterMethodResult::u16GetFunctionID() const {return RCFI_C_U16_GETDEFAULTVEHICLEPARAMETER;}
tU8 rcfi_tclMsgGetDefaultVehicleParameterMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rcfi_tclMsgGetDefaultVehicleParameterMethodResult::vDestroy()
{
   VehicleParameter.vDestroy(); 
}

tU32 rcfi_tclMsgGetDefaultVehicleParameterMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 20;
}

tBool rcfi_tclMsgGetDefaultVehicleParameterMethodResult::operator==(const rcfi_tclMsgGetDefaultVehicleParameterMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (VehicleParameter == rfoCmp.VehicleParameter);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgGetDefaultVehicleParameterMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> VehicleParameter;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgGetDefaultVehicleParameterMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << VehicleParameter;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetTravelAdvantageThresholdsMethodStart::rcfi_tclMsgSetTravelAdvantageThresholdsMethodStart(const rcfi_tclMsgSetTravelAdvantageThresholdsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   AutomaticDynamizationThresholdTTA = coRef.AutomaticDynamizationThresholdTTA;
   AutomaticDynamizationThresholdTFA = coRef.AutomaticDynamizationThresholdTFA;
   UserConfirmedDynamizationThresholdTTA = coRef.UserConfirmedDynamizationThresholdTTA;
   UserConfirmedDynamizationThresholdTFA = coRef.UserConfirmedDynamizationThresholdTFA;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetTravelAdvantageThresholdsMethodStart& rcfi_tclMsgSetTravelAdvantageThresholdsMethodStart::operator=(const rcfi_tclMsgSetTravelAdvantageThresholdsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   AutomaticDynamizationThresholdTTA = coRef.AutomaticDynamizationThresholdTTA;
   AutomaticDynamizationThresholdTFA = coRef.AutomaticDynamizationThresholdTFA;
   UserConfirmedDynamizationThresholdTTA = coRef.UserConfirmedDynamizationThresholdTTA;
   UserConfirmedDynamizationThresholdTFA = coRef.UserConfirmedDynamizationThresholdTFA;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgSetTravelAdvantageThresholdsMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgSetTravelAdvantageThresholdsMethodStart::u16GetFunctionID() const {return RCFI_C_U16_SETTRAVELADVANTAGETHRESHOLDS;}
tU8 rcfi_tclMsgSetTravelAdvantageThresholdsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rcfi_tclMsgSetTravelAdvantageThresholdsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

tBool rcfi_tclMsgSetTravelAdvantageThresholdsMethodStart::operator==(const rcfi_tclMsgSetTravelAdvantageThresholdsMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AutomaticDynamizationThresholdTTA == rfoCmp.AutomaticDynamizationThresholdTTA);
      bResult = bResult && (AutomaticDynamizationThresholdTFA == rfoCmp.AutomaticDynamizationThresholdTFA);
      bResult = bResult && (UserConfirmedDynamizationThresholdTTA == rfoCmp.UserConfirmedDynamizationThresholdTTA);
      bResult = bResult && (UserConfirmedDynamizationThresholdTFA == rfoCmp.UserConfirmedDynamizationThresholdTFA);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgSetTravelAdvantageThresholdsMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> AutomaticDynamizationThresholdTTA;
   oIn >> AutomaticDynamizationThresholdTFA;
   oIn >> UserConfirmedDynamizationThresholdTTA;
   oIn >> UserConfirmedDynamizationThresholdTFA;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgSetTravelAdvantageThresholdsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << AutomaticDynamizationThresholdTTA;
   oOut << AutomaticDynamizationThresholdTFA;
   oOut << UserConfirmedDynamizationThresholdTTA;
   oOut << UserConfirmedDynamizationThresholdTFA;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetTravelAdvantageThresholdsMethodResult::rcfi_tclMsgSetTravelAdvantageThresholdsMethodResult(const rcfi_tclMsgSetTravelAdvantageThresholdsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetTravelAdvantageThresholdsMethodResult& rcfi_tclMsgSetTravelAdvantageThresholdsMethodResult::operator=(const rcfi_tclMsgSetTravelAdvantageThresholdsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgSetTravelAdvantageThresholdsMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgSetTravelAdvantageThresholdsMethodResult::u16GetFunctionID() const {return RCFI_C_U16_SETTRAVELADVANTAGETHRESHOLDS;}
tU8 rcfi_tclMsgSetTravelAdvantageThresholdsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rcfi_tclMsgSetTravelAdvantageThresholdsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgSetTravelAdvantageThresholdsMethodResult::operator==(const rcfi_tclMsgSetTravelAdvantageThresholdsMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgSetTravelAdvantageThresholdsMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgSetTravelAdvantageThresholdsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetThresholdDefinitionProfileMethodStart::rcfi_tclMsgSetThresholdDefinitionProfileMethodStart(const rcfi_tclMsgSetThresholdDefinitionProfileMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   ThresholdDefinitionProfile = coRef.ThresholdDefinitionProfile;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetThresholdDefinitionProfileMethodStart& rcfi_tclMsgSetThresholdDefinitionProfileMethodStart::operator=(const rcfi_tclMsgSetThresholdDefinitionProfileMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ThresholdDefinitionProfile = coRef.ThresholdDefinitionProfile;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgSetThresholdDefinitionProfileMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgSetThresholdDefinitionProfileMethodStart::u16GetFunctionID() const {return RCFI_C_U16_SETTHRESHOLDDEFINITIONPROFILE;}
tU8 rcfi_tclMsgSetThresholdDefinitionProfileMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rcfi_tclMsgSetThresholdDefinitionProfileMethodStart::vDestroy()
{
   ThresholdDefinitionProfile.vDestroy(); 
}

tU32 rcfi_tclMsgSetThresholdDefinitionProfileMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 37;
}

tBool rcfi_tclMsgSetThresholdDefinitionProfileMethodStart::operator==(const rcfi_tclMsgSetThresholdDefinitionProfileMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ThresholdDefinitionProfile == rfoCmp.ThresholdDefinitionProfile);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgSetThresholdDefinitionProfileMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> ThresholdDefinitionProfile;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgSetThresholdDefinitionProfileMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ThresholdDefinitionProfile;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetThresholdDefinitionProfileMethodResult::rcfi_tclMsgSetThresholdDefinitionProfileMethodResult(const rcfi_tclMsgSetThresholdDefinitionProfileMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetThresholdDefinitionProfileMethodResult& rcfi_tclMsgSetThresholdDefinitionProfileMethodResult::operator=(const rcfi_tclMsgSetThresholdDefinitionProfileMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgSetThresholdDefinitionProfileMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgSetThresholdDefinitionProfileMethodResult::u16GetFunctionID() const {return RCFI_C_U16_SETTHRESHOLDDEFINITIONPROFILE;}
tU8 rcfi_tclMsgSetThresholdDefinitionProfileMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rcfi_tclMsgSetThresholdDefinitionProfileMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgSetThresholdDefinitionProfileMethodResult::operator==(const rcfi_tclMsgSetThresholdDefinitionProfileMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgSetThresholdDefinitionProfileMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgSetThresholdDefinitionProfileMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgCreateTripMethodStart::rcfi_tclMsgCreateTripMethodStart(const rcfi_tclMsgCreateTripMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TrackedFlag = coRef.TrackedFlag;
   StartPosition = coRef.StartPosition;
   SpeedProfiles = coRef.SpeedProfiles;
   UserProfiles = coRef.UserProfiles;
   TripDefinition = coRef.TripDefinition;
   RouteDefinition = coRef.RouteDefinition;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgCreateTripMethodStart& rcfi_tclMsgCreateTripMethodStart::operator=(const rcfi_tclMsgCreateTripMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TrackedFlag = coRef.TrackedFlag;
   StartPosition = coRef.StartPosition;
   SpeedProfiles = coRef.SpeedProfiles;
   UserProfiles = coRef.UserProfiles;
   TripDefinition = coRef.TripDefinition;
   RouteDefinition = coRef.RouteDefinition;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgCreateTripMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgCreateTripMethodStart::u16GetFunctionID() const {return RCFI_C_U16_CREATETRIP;}
tU8 rcfi_tclMsgCreateTripMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rcfi_tclMsgCreateTripMethodStart::vDestroy()
{
   StartPosition.vDestroy(); 
   SpeedProfiles.vDestroy(); 
   UserProfiles.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < TripDefinition.size(); ++u32Idx)
         TripDefinition[u32Idx].vDestroy();
   }
   TripDefinition.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < RouteDefinition.size(); ++u32Idx)
         RouteDefinition[u32Idx].vDestroy();
   }
   RouteDefinition.clear();
}

tU32 rcfi_tclMsgCreateTripMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 6)
   {
      u32DynamicSize += SpeedProfiles.u32GetSize(u16MajorVersion);
   }
   if (7 <= u16MajorVersion)
   {
      u32DynamicSize += UserProfiles.u32GetSize(u16MajorVersion);
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TripDefinition.size(); ++u32ListIdx)
      u32DynamicSize += TripDefinition[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < RouteDefinition.size(); ++u32ListIdx)
      u32DynamicSize += RouteDefinition[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+9+StartPosition.u32GetSize(u16MajorVersion);
}

tBool rcfi_tclMsgCreateTripMethodStart::operator==(const rcfi_tclMsgCreateTripMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TrackedFlag == rfoCmp.TrackedFlag);
      bResult = bResult && (StartPosition == rfoCmp.StartPosition);
      bResult = bResult && (SpeedProfiles == rfoCmp.SpeedProfiles);
      bResult = bResult && (UserProfiles == rfoCmp.UserProfiles);
      bResult = bResult && (TripDefinition.size() == rfoCmp.TripDefinition.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TripDefinition.size()); ++u32Idx)
            bResult = bResult && (TripDefinition[u32Idx] == rfoCmp.TripDefinition[u32Idx]);
      }
      bResult = bResult && (RouteDefinition.size() == rfoCmp.RouteDefinition.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RouteDefinition.size()); ++u32Idx)
            bResult = bResult && (RouteDefinition[u32Idx] == rfoCmp.RouteDefinition[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgCreateTripMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TrackedFlag;
   oIn >> StartPosition;
   if (oIn.u16GetMajorVersion() <= 6)
   {
      oIn >> SpeedProfiles;
   }
   if (7 <= oIn.u16GetMajorVersion())
   {
      oIn >> UserProfiles;
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TripDefinition.size(); ++u32Idx)
      {
         TripDefinition[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TripDefinition.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TripDefinition[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RouteDefinition.size(); ++u32Idx)
      {
         RouteDefinition[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RouteDefinition.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RouteDefinition[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgCreateTripMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TrackedFlag;
   oOut << StartPosition;
   if (oOut.u16GetMajorVersion() <= 6)
   {
      oOut << SpeedProfiles;
   }
   if (7 <= oOut.u16GetMajorVersion())
   {
      oOut << UserProfiles;
   }
   oOut << (tU32)TripDefinition.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TripDefinition.size(); ++u32Idx)
         oOut << TripDefinition[u32Idx];
   }
   oOut << (tU32)RouteDefinition.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RouteDefinition.size(); ++u32Idx)
         oOut << RouteDefinition[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgCreateTripMethodResult::rcfi_tclMsgCreateTripMethodResult(const rcfi_tclMsgCreateTripMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandleDescription = coRef.RouteHandleDescription;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgCreateTripMethodResult& rcfi_tclMsgCreateTripMethodResult::operator=(const rcfi_tclMsgCreateTripMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandleDescription = coRef.RouteHandleDescription;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgCreateTripMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgCreateTripMethodResult::u16GetFunctionID() const {return RCFI_C_U16_CREATETRIP;}
tU8 rcfi_tclMsgCreateTripMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rcfi_tclMsgCreateTripMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RouteHandleDescription.size(); ++u32Idx)
         RouteHandleDescription[u32Idx].vDestroy();
   }
   RouteHandleDescription.clear();
}

tU32 rcfi_tclMsgCreateTripMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RouteHandleDescription.size(); ++u32ListIdx)
      u32DynamicSize += RouteHandleDescription[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

tBool rcfi_tclMsgCreateTripMethodResult::operator==(const rcfi_tclMsgCreateTripMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandleDescription.size() == rfoCmp.RouteHandleDescription.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RouteHandleDescription.size()); ++u32Idx)
            bResult = bResult && (RouteHandleDescription[u32Idx] == rfoCmp.RouteHandleDescription[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgCreateTripMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RouteHandleDescription.size(); ++u32Idx)
      {
         RouteHandleDescription[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RouteHandleDescription.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RouteHandleDescription[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgCreateTripMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << (tU32)RouteHandleDescription.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RouteHandleDescription.size(); ++u32Idx)
         oOut << RouteHandleDescription[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetTripMethodStart::rcfi_tclMsgGetTripMethodStart(const rcfi_tclMsgGetTripMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetTripMethodStart& rcfi_tclMsgGetTripMethodStart::operator=(const rcfi_tclMsgGetTripMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgGetTripMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgGetTripMethodStart::u16GetFunctionID() const {return RCFI_C_U16_GETTRIP;}
tU8 rcfi_tclMsgGetTripMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rcfi_tclMsgGetTripMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool rcfi_tclMsgGetTripMethodStart::operator==(const rcfi_tclMsgGetTripMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgGetTripMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgGetTripMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetTripMethodResult::rcfi_tclMsgGetTripMethodResult(const rcfi_tclMsgGetTripMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   TrackedFlag = coRef.TrackedFlag;
   StartPosition = coRef.StartPosition;
   SpeedProfiles = coRef.SpeedProfiles;
   UserProfiles = coRef.UserProfiles;
   TripDefinition = coRef.TripDefinition;
   RouteDefinition = coRef.RouteDefinition;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetTripMethodResult& rcfi_tclMsgGetTripMethodResult::operator=(const rcfi_tclMsgGetTripMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   TrackedFlag = coRef.TrackedFlag;
   StartPosition = coRef.StartPosition;
   SpeedProfiles = coRef.SpeedProfiles;
   UserProfiles = coRef.UserProfiles;
   TripDefinition = coRef.TripDefinition;
   RouteDefinition = coRef.RouteDefinition;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgGetTripMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgGetTripMethodResult::u16GetFunctionID() const {return RCFI_C_U16_GETTRIP;}
tU8 rcfi_tclMsgGetTripMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rcfi_tclMsgGetTripMethodResult::vDestroy()
{
   StartPosition.vDestroy(); 
   SpeedProfiles.vDestroy(); 
   UserProfiles.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < TripDefinition.size(); ++u32Idx)
         TripDefinition[u32Idx].vDestroy();
   }
   TripDefinition.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < RouteDefinition.size(); ++u32Idx)
         RouteDefinition[u32Idx].vDestroy();
   }
   RouteDefinition.clear();
}

tU32 rcfi_tclMsgGetTripMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 6)
   {
      u32DynamicSize += SpeedProfiles.u32GetSize(u16MajorVersion);
   }
   if (7 <= u16MajorVersion)
   {
      u32DynamicSize += UserProfiles.u32GetSize(u16MajorVersion);
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TripDefinition.size(); ++u32ListIdx)
      u32DynamicSize += TripDefinition[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < RouteDefinition.size(); ++u32ListIdx)
      u32DynamicSize += RouteDefinition[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+11+StartPosition.u32GetSize(u16MajorVersion);
}

tBool rcfi_tclMsgGetTripMethodResult::operator==(const rcfi_tclMsgGetTripMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (TrackedFlag == rfoCmp.TrackedFlag);
      bResult = bResult && (StartPosition == rfoCmp.StartPosition);
      bResult = bResult && (SpeedProfiles == rfoCmp.SpeedProfiles);
      bResult = bResult && (UserProfiles == rfoCmp.UserProfiles);
      bResult = bResult && (TripDefinition.size() == rfoCmp.TripDefinition.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TripDefinition.size()); ++u32Idx)
            bResult = bResult && (TripDefinition[u32Idx] == rfoCmp.TripDefinition[u32Idx]);
      }
      bResult = bResult && (RouteDefinition.size() == rfoCmp.RouteDefinition.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RouteDefinition.size()); ++u32Idx)
            bResult = bResult && (RouteDefinition[u32Idx] == rfoCmp.RouteDefinition[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgGetTripMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> TrackedFlag;
   oIn >> StartPosition;
   if (oIn.u16GetMajorVersion() <= 6)
   {
      oIn >> SpeedProfiles;
   }
   if (7 <= oIn.u16GetMajorVersion())
   {
      oIn >> UserProfiles;
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TripDefinition.size(); ++u32Idx)
      {
         TripDefinition[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TripDefinition.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TripDefinition[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RouteDefinition.size(); ++u32Idx)
      {
         RouteDefinition[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RouteDefinition.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RouteDefinition[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgGetTripMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << TrackedFlag;
   oOut << StartPosition;
   if (oOut.u16GetMajorVersion() <= 6)
   {
      oOut << SpeedProfiles;
   }
   if (7 <= oOut.u16GetMajorVersion())
   {
      oOut << UserProfiles;
   }
   oOut << (tU32)TripDefinition.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TripDefinition.size(); ++u32Idx)
         oOut << TripDefinition[u32Idx];
   }
   oOut << (tU32)RouteDefinition.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RouteDefinition.size(); ++u32Idx)
         oOut << RouteDefinition[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgKillTripMethodStart::rcfi_tclMsgKillTripMethodStart(const rcfi_tclMsgKillTripMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgKillTripMethodStart& rcfi_tclMsgKillTripMethodStart::operator=(const rcfi_tclMsgKillTripMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgKillTripMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgKillTripMethodStart::u16GetFunctionID() const {return RCFI_C_U16_KILLTRIP;}
tU8 rcfi_tclMsgKillTripMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rcfi_tclMsgKillTripMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool rcfi_tclMsgKillTripMethodStart::operator==(const rcfi_tclMsgKillTripMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgKillTripMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgKillTripMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgKillTripMethodResult::rcfi_tclMsgKillTripMethodResult(const rcfi_tclMsgKillTripMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   KilledTripHandle = coRef.KilledTripHandle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgKillTripMethodResult& rcfi_tclMsgKillTripMethodResult::operator=(const rcfi_tclMsgKillTripMethodResult& coRef)
{
   if (this == &coRef) return *this;
   KilledTripHandle = coRef.KilledTripHandle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgKillTripMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgKillTripMethodResult::u16GetFunctionID() const {return RCFI_C_U16_KILLTRIP;}
tU8 rcfi_tclMsgKillTripMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rcfi_tclMsgKillTripMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool rcfi_tclMsgKillTripMethodResult::operator==(const rcfi_tclMsgKillTripMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (KilledTripHandle == rfoCmp.KilledTripHandle);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgKillTripMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> KilledTripHandle;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgKillTripMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << KilledTripHandle;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetExistingTripHandlesMethodStart::rcfi_tclMsgGetExistingTripHandlesMethodStart(const rcfi_tclMsgGetExistingTripHandlesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetExistingTripHandlesMethodStart& rcfi_tclMsgGetExistingTripHandlesMethodStart::operator=(const rcfi_tclMsgGetExistingTripHandlesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgGetExistingTripHandlesMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgGetExistingTripHandlesMethodStart::u16GetFunctionID() const {return RCFI_C_U16_GETEXISTINGTRIPHANDLES;}
tU8 rcfi_tclMsgGetExistingTripHandlesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rcfi_tclMsgGetExistingTripHandlesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgGetExistingTripHandlesMethodStart::operator==(const rcfi_tclMsgGetExistingTripHandlesMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgGetExistingTripHandlesMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgGetExistingTripHandlesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetExistingTripHandlesMethodResult::rcfi_tclMsgGetExistingTripHandlesMethodResult(const rcfi_tclMsgGetExistingTripHandlesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   ExistingTripHandles = coRef.ExistingTripHandles;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetExistingTripHandlesMethodResult& rcfi_tclMsgGetExistingTripHandlesMethodResult::operator=(const rcfi_tclMsgGetExistingTripHandlesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ExistingTripHandles = coRef.ExistingTripHandles;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgGetExistingTripHandlesMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgGetExistingTripHandlesMethodResult::u16GetFunctionID() const {return RCFI_C_U16_GETEXISTINGTRIPHANDLES;}
tU8 rcfi_tclMsgGetExistingTripHandlesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rcfi_tclMsgGetExistingTripHandlesMethodResult::vDestroy()
{
   ExistingTripHandles.clear();
}

tU32 rcfi_tclMsgGetExistingTripHandlesMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ExistingTripHandles.size()*2;
}

tBool rcfi_tclMsgGetExistingTripHandlesMethodResult::operator==(const rcfi_tclMsgGetExistingTripHandlesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ExistingTripHandles.size() == rfoCmp.ExistingTripHandles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ExistingTripHandles.size()); ++u32Idx)
            bResult = bResult && (ExistingTripHandles[u32Idx] == rfoCmp.ExistingTripHandles[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgGetExistingTripHandlesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      ExistingTripHandles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ExistingTripHandles[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgGetExistingTripHandlesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ExistingTripHandles.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ExistingTripHandles.size(); ++u32Idx)
         oOut << ExistingTripHandles[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgAddTripSegmentToTripMethodStart::rcfi_tclMsgAddTripSegmentToTripMethodStart(const rcfi_tclMsgAddTripSegmentToTripMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   SourceTripHandle = coRef.SourceTripHandle;
   SegmentNumber = coRef.SegmentNumber;
   TripSegmentDefinition = coRef.TripSegmentDefinition;
   RouteHandleDescription = coRef.RouteHandleDescription;
   AddTripSegmentParameters = coRef.AddTripSegmentParameters;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgAddTripSegmentToTripMethodStart& rcfi_tclMsgAddTripSegmentToTripMethodStart::operator=(const rcfi_tclMsgAddTripSegmentToTripMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SourceTripHandle = coRef.SourceTripHandle;
   SegmentNumber = coRef.SegmentNumber;
   TripSegmentDefinition = coRef.TripSegmentDefinition;
   RouteHandleDescription = coRef.RouteHandleDescription;
   AddTripSegmentParameters = coRef.AddTripSegmentParameters;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgAddTripSegmentToTripMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgAddTripSegmentToTripMethodStart::u16GetFunctionID() const {return RCFI_C_U16_ADDTRIPSEGMENTTOTRIP;}
tU8 rcfi_tclMsgAddTripSegmentToTripMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rcfi_tclMsgAddTripSegmentToTripMethodStart::vDestroy()
{
   TripSegmentDefinition.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < RouteHandleDescription.size(); ++u32Idx)
         RouteHandleDescription[u32Idx].vDestroy();
   }
   RouteHandleDescription.clear();
}

tU32 rcfi_tclMsgAddTripSegmentToTripMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RouteHandleDescription.size(); ++u32ListIdx)
      u32DynamicSize += RouteHandleDescription[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+9+TripSegmentDefinition.u32GetSize(u16MajorVersion);
}

tBool rcfi_tclMsgAddTripSegmentToTripMethodStart::operator==(const rcfi_tclMsgAddTripSegmentToTripMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SourceTripHandle == rfoCmp.SourceTripHandle);
      bResult = bResult && (SegmentNumber == rfoCmp.SegmentNumber);
      bResult = bResult && (TripSegmentDefinition == rfoCmp.TripSegmentDefinition);
      bResult = bResult && (RouteHandleDescription.size() == rfoCmp.RouteHandleDescription.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RouteHandleDescription.size()); ++u32Idx)
            bResult = bResult && (RouteHandleDescription[u32Idx] == rfoCmp.RouteHandleDescription[u32Idx]);
      }
      bResult = bResult && (AddTripSegmentParameters == rfoCmp.AddTripSegmentParameters);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgAddTripSegmentToTripMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> SourceTripHandle;
   oIn >> SegmentNumber;
   oIn >> TripSegmentDefinition;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RouteHandleDescription.size(); ++u32Idx)
      {
         RouteHandleDescription[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RouteHandleDescription.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RouteHandleDescription[u32Idx];
      }
   }
   oIn >> AddTripSegmentParameters;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgAddTripSegmentToTripMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << SourceTripHandle;
   oOut << SegmentNumber;
   oOut << TripSegmentDefinition;
   oOut << (tU32)RouteHandleDescription.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RouteHandleDescription.size(); ++u32Idx)
         oOut << RouteHandleDescription[u32Idx];
   }
   oOut << AddTripSegmentParameters;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgAddTripSegmentToTripMethodResult::rcfi_tclMsgAddTripSegmentToTripMethodResult(const rcfi_tclMsgAddTripSegmentToTripMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgAddTripSegmentToTripMethodResult& rcfi_tclMsgAddTripSegmentToTripMethodResult::operator=(const rcfi_tclMsgAddTripSegmentToTripMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgAddTripSegmentToTripMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgAddTripSegmentToTripMethodResult::u16GetFunctionID() const {return RCFI_C_U16_ADDTRIPSEGMENTTOTRIP;}
tU8 rcfi_tclMsgAddTripSegmentToTripMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rcfi_tclMsgAddTripSegmentToTripMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool rcfi_tclMsgAddTripSegmentToTripMethodResult::operator==(const rcfi_tclMsgAddTripSegmentToTripMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgAddTripSegmentToTripMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgAddTripSegmentToTripMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgStartRouteCalculationMethodStart::rcfi_tclMsgStartRouteCalculationMethodStart(const rcfi_tclMsgStartRouteCalculationMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandleDescription = coRef.RouteHandleDescription;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgStartRouteCalculationMethodStart& rcfi_tclMsgStartRouteCalculationMethodStart::operator=(const rcfi_tclMsgStartRouteCalculationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandleDescription = coRef.RouteHandleDescription;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgStartRouteCalculationMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgStartRouteCalculationMethodStart::u16GetFunctionID() const {return RCFI_C_U16_STARTROUTECALCULATION;}
tU8 rcfi_tclMsgStartRouteCalculationMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rcfi_tclMsgStartRouteCalculationMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RouteHandleDescription.size(); ++u32Idx)
         RouteHandleDescription[u32Idx].vDestroy();
   }
   RouteHandleDescription.clear();
}

tU32 rcfi_tclMsgStartRouteCalculationMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RouteHandleDescription.size(); ++u32ListIdx)
      u32DynamicSize += RouteHandleDescription[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

tBool rcfi_tclMsgStartRouteCalculationMethodStart::operator==(const rcfi_tclMsgStartRouteCalculationMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandleDescription.size() == rfoCmp.RouteHandleDescription.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RouteHandleDescription.size()); ++u32Idx)
            bResult = bResult && (RouteHandleDescription[u32Idx] == rfoCmp.RouteHandleDescription[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgStartRouteCalculationMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RouteHandleDescription.size(); ++u32Idx)
      {
         RouteHandleDescription[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RouteHandleDescription.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RouteHandleDescription[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgStartRouteCalculationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << (tU32)RouteHandleDescription.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RouteHandleDescription.size(); ++u32Idx)
         oOut << RouteHandleDescription[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgStartRouteCalculationMethodResult::rcfi_tclMsgStartRouteCalculationMethodResult(const rcfi_tclMsgStartRouteCalculationMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgStartRouteCalculationMethodResult& rcfi_tclMsgStartRouteCalculationMethodResult::operator=(const rcfi_tclMsgStartRouteCalculationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgStartRouteCalculationMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgStartRouteCalculationMethodResult::u16GetFunctionID() const {return RCFI_C_U16_STARTROUTECALCULATION;}
tU8 rcfi_tclMsgStartRouteCalculationMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rcfi_tclMsgStartRouteCalculationMethodResult::vDestroy()
{
   RouteHandle.clear();
}

tU32 rcfi_tclMsgStartRouteCalculationMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+RouteHandle.size()*2;
}

tBool rcfi_tclMsgStartRouteCalculationMethodResult::operator==(const rcfi_tclMsgStartRouteCalculationMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle.size() == rfoCmp.RouteHandle.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RouteHandle.size()); ++u32Idx)
            bResult = bResult && (RouteHandle[u32Idx] == rfoCmp.RouteHandle[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgStartRouteCalculationMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      RouteHandle.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RouteHandle[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgStartRouteCalculationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << (tU32)RouteHandle.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RouteHandle.size(); ++u32Idx)
         oOut << RouteHandle[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgStopRouteCalculationMethodStart::rcfi_tclMsgStopRouteCalculationMethodStart(const rcfi_tclMsgStopRouteCalculationMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgStopRouteCalculationMethodStart& rcfi_tclMsgStopRouteCalculationMethodStart::operator=(const rcfi_tclMsgStopRouteCalculationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgStopRouteCalculationMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgStopRouteCalculationMethodStart::u16GetFunctionID() const {return RCFI_C_U16_STOPROUTECALCULATION;}
tU8 rcfi_tclMsgStopRouteCalculationMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rcfi_tclMsgStopRouteCalculationMethodStart::vDestroy()
{
   RouteHandle.clear();
}

tU32 rcfi_tclMsgStopRouteCalculationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+RouteHandle.size()*2;
}

tBool rcfi_tclMsgStopRouteCalculationMethodStart::operator==(const rcfi_tclMsgStopRouteCalculationMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle.size() == rfoCmp.RouteHandle.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RouteHandle.size()); ++u32Idx)
            bResult = bResult && (RouteHandle[u32Idx] == rfoCmp.RouteHandle[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgStopRouteCalculationMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      RouteHandle.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RouteHandle[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgStopRouteCalculationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << (tU32)RouteHandle.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RouteHandle.size(); ++u32Idx)
         oOut << RouteHandle[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgStopRouteCalculationMethodResult::rcfi_tclMsgStopRouteCalculationMethodResult(const rcfi_tclMsgStopRouteCalculationMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgStopRouteCalculationMethodResult& rcfi_tclMsgStopRouteCalculationMethodResult::operator=(const rcfi_tclMsgStopRouteCalculationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgStopRouteCalculationMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgStopRouteCalculationMethodResult::u16GetFunctionID() const {return RCFI_C_U16_STOPROUTECALCULATION;}
tU8 rcfi_tclMsgStopRouteCalculationMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rcfi_tclMsgStopRouteCalculationMethodResult::vDestroy()
{
   RouteHandle.clear();
}

tU32 rcfi_tclMsgStopRouteCalculationMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+RouteHandle.size()*2;
}

tBool rcfi_tclMsgStopRouteCalculationMethodResult::operator==(const rcfi_tclMsgStopRouteCalculationMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle.size() == rfoCmp.RouteHandle.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RouteHandle.size()); ++u32Idx)
            bResult = bResult && (RouteHandle[u32Idx] == rfoCmp.RouteHandle[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgStopRouteCalculationMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      RouteHandle.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RouteHandle[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgStopRouteCalculationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << (tU32)RouteHandle.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RouteHandle.size(); ++u32Idx)
         oOut << RouteHandle[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetTrackedSegmentMethodStart::rcfi_tclMsgSetTrackedSegmentMethodStart(const rcfi_tclMsgSetTrackedSegmentMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   SegmentSkippingMode = coRef.SegmentSkippingMode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetTrackedSegmentMethodStart& rcfi_tclMsgSetTrackedSegmentMethodStart::operator=(const rcfi_tclMsgSetTrackedSegmentMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   SegmentSkippingMode = coRef.SegmentSkippingMode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgSetTrackedSegmentMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgSetTrackedSegmentMethodStart::u16GetFunctionID() const {return RCFI_C_U16_SETTRACKEDSEGMENT;}
tU8 rcfi_tclMsgSetTrackedSegmentMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rcfi_tclMsgSetTrackedSegmentMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (35 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+4;
}

tBool rcfi_tclMsgSetTrackedSegmentMethodStart::operator==(const rcfi_tclMsgSetTrackedSegmentMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (TripSegmentNumber == rfoCmp.TripSegmentNumber);
      bResult = bResult && (SegmentSkippingMode == rfoCmp.SegmentSkippingMode);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgSetTrackedSegmentMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> TripSegmentNumber;
   if (35 <= oIn.u16GetMajorVersion())
   {
      oIn >> SegmentSkippingMode;
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgSetTrackedSegmentMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << TripSegmentNumber;
   if (35 <= oOut.u16GetMajorVersion())
   {
      oOut << SegmentSkippingMode;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetTrackedSegmentMethodResult::rcfi_tclMsgSetTrackedSegmentMethodResult(const rcfi_tclMsgSetTrackedSegmentMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetTrackedSegmentMethodResult& rcfi_tclMsgSetTrackedSegmentMethodResult::operator=(const rcfi_tclMsgSetTrackedSegmentMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgSetTrackedSegmentMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgSetTrackedSegmentMethodResult::u16GetFunctionID() const {return RCFI_C_U16_SETTRACKEDSEGMENT;}
tU8 rcfi_tclMsgSetTrackedSegmentMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rcfi_tclMsgSetTrackedSegmentMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool rcfi_tclMsgSetTrackedSegmentMethodResult::operator==(const rcfi_tclMsgSetTrackedSegmentMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (TripSegmentNumber == rfoCmp.TripSegmentNumber);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgSetTrackedSegmentMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> TripSegmentNumber;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgSetTrackedSegmentMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << TripSegmentNumber;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgChangeDynamicRouteCalcModeMethodStart::rcfi_tclMsgChangeDynamicRouteCalcModeMethodStart(const rcfi_tclMsgChangeDynamicRouteCalcModeMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   ActiveManipSourcesOfRoute = coRef.ActiveManipSourcesOfRoute;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgChangeDynamicRouteCalcModeMethodStart& rcfi_tclMsgChangeDynamicRouteCalcModeMethodStart::operator=(const rcfi_tclMsgChangeDynamicRouteCalcModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   ActiveManipSourcesOfRoute = coRef.ActiveManipSourcesOfRoute;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgChangeDynamicRouteCalcModeMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgChangeDynamicRouteCalcModeMethodStart::u16GetFunctionID() const {return RCFI_C_U16_CHANGEDYNAMICROUTECALCMODE;}
tU8 rcfi_tclMsgChangeDynamicRouteCalcModeMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rcfi_tclMsgChangeDynamicRouteCalcModeMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ActiveManipSourcesOfRoute.size(); ++u32Idx)
         ActiveManipSourcesOfRoute[u32Idx].vDestroy();
   }
   ActiveManipSourcesOfRoute.clear();
}

tU32 rcfi_tclMsgChangeDynamicRouteCalcModeMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ActiveManipSourcesOfRoute.size(); ++u32ListIdx)
      u32DynamicSize += ActiveManipSourcesOfRoute[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

tBool rcfi_tclMsgChangeDynamicRouteCalcModeMethodStart::operator==(const rcfi_tclMsgChangeDynamicRouteCalcModeMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (ActiveManipSourcesOfRoute.size() == rfoCmp.ActiveManipSourcesOfRoute.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ActiveManipSourcesOfRoute.size()); ++u32Idx)
            bResult = bResult && (ActiveManipSourcesOfRoute[u32Idx] == rfoCmp.ActiveManipSourcesOfRoute[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgChangeDynamicRouteCalcModeMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ActiveManipSourcesOfRoute.size(); ++u32Idx)
      {
         ActiveManipSourcesOfRoute[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ActiveManipSourcesOfRoute.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ActiveManipSourcesOfRoute[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgChangeDynamicRouteCalcModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << (tU32)ActiveManipSourcesOfRoute.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ActiveManipSourcesOfRoute.size(); ++u32Idx)
         oOut << ActiveManipSourcesOfRoute[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgChangeDynamicRouteCalcModeMethodResult::rcfi_tclMsgChangeDynamicRouteCalcModeMethodResult(const rcfi_tclMsgChangeDynamicRouteCalcModeMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgChangeDynamicRouteCalcModeMethodResult& rcfi_tclMsgChangeDynamicRouteCalcModeMethodResult::operator=(const rcfi_tclMsgChangeDynamicRouteCalcModeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgChangeDynamicRouteCalcModeMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgChangeDynamicRouteCalcModeMethodResult::u16GetFunctionID() const {return RCFI_C_U16_CHANGEDYNAMICROUTECALCMODE;}
tU8 rcfi_tclMsgChangeDynamicRouteCalcModeMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rcfi_tclMsgChangeDynamicRouteCalcModeMethodResult::vDestroy()
{
   RouteHandle.clear();
}

tU32 rcfi_tclMsgChangeDynamicRouteCalcModeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+RouteHandle.size()*2;
}

tBool rcfi_tclMsgChangeDynamicRouteCalcModeMethodResult::operator==(const rcfi_tclMsgChangeDynamicRouteCalcModeMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle.size() == rfoCmp.RouteHandle.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RouteHandle.size()); ++u32Idx)
            bResult = bResult && (RouteHandle[u32Idx] == rfoCmp.RouteHandle[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgChangeDynamicRouteCalcModeMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      RouteHandle.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RouteHandle[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgChangeDynamicRouteCalcModeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << (tU32)RouteHandle.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RouteHandle.size(); ++u32Idx)
         oOut << RouteHandle[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSelectTrafficScenarioMethodStart::rcfi_tclMsgSelectTrafficScenarioMethodStart(const rcfi_tclMsgSelectTrafficScenarioMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TrafficMessageRevision = coRef.TrafficMessageRevision;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSelectTrafficScenarioMethodStart& rcfi_tclMsgSelectTrafficScenarioMethodStart::operator=(const rcfi_tclMsgSelectTrafficScenarioMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TrafficMessageRevision = coRef.TrafficMessageRevision;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgSelectTrafficScenarioMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgSelectTrafficScenarioMethodStart::u16GetFunctionID() const {return RCFI_C_U16_SELECTTRAFFICSCENARIO;}
tU8 rcfi_tclMsgSelectTrafficScenarioMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rcfi_tclMsgSelectTrafficScenarioMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool rcfi_tclMsgSelectTrafficScenarioMethodStart::operator==(const rcfi_tclMsgSelectTrafficScenarioMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (TrafficMessageRevision == rfoCmp.TrafficMessageRevision);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgSelectTrafficScenarioMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> TrafficMessageRevision;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgSelectTrafficScenarioMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << TrafficMessageRevision;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSelectTrafficScenarioMethodResult::rcfi_tclMsgSelectTrafficScenarioMethodResult(const rcfi_tclMsgSelectTrafficScenarioMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TrafficMessageRevision = coRef.TrafficMessageRevision;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSelectTrafficScenarioMethodResult& rcfi_tclMsgSelectTrafficScenarioMethodResult::operator=(const rcfi_tclMsgSelectTrafficScenarioMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TrafficMessageRevision = coRef.TrafficMessageRevision;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgSelectTrafficScenarioMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgSelectTrafficScenarioMethodResult::u16GetFunctionID() const {return RCFI_C_U16_SELECTTRAFFICSCENARIO;}
tU8 rcfi_tclMsgSelectTrafficScenarioMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rcfi_tclMsgSelectTrafficScenarioMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool rcfi_tclMsgSelectTrafficScenarioMethodResult::operator==(const rcfi_tclMsgSelectTrafficScenarioMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TrafficMessageRevision == rfoCmp.TrafficMessageRevision);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgSelectTrafficScenarioMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TrafficMessageRevision;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgSelectTrafficScenarioMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TrafficMessageRevision;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetCalculationModeMethodStart::rcfi_tclMsgSetCalculationModeMethodStart(const rcfi_tclMsgSetCalculationModeMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   CalculationModes = coRef.CalculationModes;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetCalculationModeMethodStart& rcfi_tclMsgSetCalculationModeMethodStart::operator=(const rcfi_tclMsgSetCalculationModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   CalculationModes = coRef.CalculationModes;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgSetCalculationModeMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgSetCalculationModeMethodStart::u16GetFunctionID() const {return RCFI_C_U16_SETCALCULATIONMODE;}
tU8 rcfi_tclMsgSetCalculationModeMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rcfi_tclMsgSetCalculationModeMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < CalculationModes.size(); ++u32Idx)
         CalculationModes[u32Idx].vDestroy();
   }
   CalculationModes.clear();
}

tU32 rcfi_tclMsgSetCalculationModeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+CalculationModes.size()*3;
}

tBool rcfi_tclMsgSetCalculationModeMethodStart::operator==(const rcfi_tclMsgSetCalculationModeMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (CalculationModes.size() == rfoCmp.CalculationModes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CalculationModes.size()); ++u32Idx)
            bResult = bResult && (CalculationModes[u32Idx] == rfoCmp.CalculationModes[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgSetCalculationModeMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CalculationModes.size(); ++u32Idx)
      {
         CalculationModes[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      CalculationModes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CalculationModes[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgSetCalculationModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << (tU32)CalculationModes.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CalculationModes.size(); ++u32Idx)
         oOut << CalculationModes[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetCalculationModeMethodResult::rcfi_tclMsgSetCalculationModeMethodResult(const rcfi_tclMsgSetCalculationModeMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetCalculationModeMethodResult& rcfi_tclMsgSetCalculationModeMethodResult::operator=(const rcfi_tclMsgSetCalculationModeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgSetCalculationModeMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgSetCalculationModeMethodResult::u16GetFunctionID() const {return RCFI_C_U16_SETCALCULATIONMODE;}
tU8 rcfi_tclMsgSetCalculationModeMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rcfi_tclMsgSetCalculationModeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool rcfi_tclMsgSetCalculationModeMethodResult::operator==(const rcfi_tclMsgSetCalculationModeMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgSetCalculationModeMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgSetCalculationModeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetCalculationModeMethodStart::rcfi_tclMsgGetCalculationModeMethodStart(const rcfi_tclMsgGetCalculationModeMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetCalculationModeMethodStart& rcfi_tclMsgGetCalculationModeMethodStart::operator=(const rcfi_tclMsgGetCalculationModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgGetCalculationModeMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgGetCalculationModeMethodStart::u16GetFunctionID() const {return RCFI_C_U16_GETCALCULATIONMODE;}
tU8 rcfi_tclMsgGetCalculationModeMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rcfi_tclMsgGetCalculationModeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool rcfi_tclMsgGetCalculationModeMethodStart::operator==(const rcfi_tclMsgGetCalculationModeMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgGetCalculationModeMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgGetCalculationModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetCalculationModeMethodResult::rcfi_tclMsgGetCalculationModeMethodResult(const rcfi_tclMsgGetCalculationModeMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   CalculationModes = coRef.CalculationModes;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetCalculationModeMethodResult& rcfi_tclMsgGetCalculationModeMethodResult::operator=(const rcfi_tclMsgGetCalculationModeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   CalculationModes = coRef.CalculationModes;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgGetCalculationModeMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgGetCalculationModeMethodResult::u16GetFunctionID() const {return RCFI_C_U16_GETCALCULATIONMODE;}
tU8 rcfi_tclMsgGetCalculationModeMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rcfi_tclMsgGetCalculationModeMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < CalculationModes.size(); ++u32Idx)
         CalculationModes[u32Idx].vDestroy();
   }
   CalculationModes.clear();
}

tU32 rcfi_tclMsgGetCalculationModeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+CalculationModes.size()*3;
}

tBool rcfi_tclMsgGetCalculationModeMethodResult::operator==(const rcfi_tclMsgGetCalculationModeMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (CalculationModes.size() == rfoCmp.CalculationModes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CalculationModes.size()); ++u32Idx)
            bResult = bResult && (CalculationModes[u32Idx] == rfoCmp.CalculationModes[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgGetCalculationModeMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CalculationModes.size(); ++u32Idx)
      {
         CalculationModes[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      CalculationModes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CalculationModes[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgGetCalculationModeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << (tU32)CalculationModes.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CalculationModes.size(); ++u32Idx)
         oOut << CalculationModes[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetAvailableRouteInfoMethodStart::rcfi_tclMsgGetAvailableRouteInfoMethodStart(const rcfi_tclMsgGetAvailableRouteInfoMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetAvailableRouteInfoMethodStart& rcfi_tclMsgGetAvailableRouteInfoMethodStart::operator=(const rcfi_tclMsgGetAvailableRouteInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgGetAvailableRouteInfoMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgGetAvailableRouteInfoMethodStart::u16GetFunctionID() const {return RCFI_C_U16_GETAVAILABLEROUTEINFO;}
tU8 rcfi_tclMsgGetAvailableRouteInfoMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rcfi_tclMsgGetAvailableRouteInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgGetAvailableRouteInfoMethodStart::operator==(const rcfi_tclMsgGetAvailableRouteInfoMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgGetAvailableRouteInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgGetAvailableRouteInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetAvailableRouteInfoMethodResult::rcfi_tclMsgGetAvailableRouteInfoMethodResult(const rcfi_tclMsgGetAvailableRouteInfoMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   RouteInfoCategory = coRef.RouteInfoCategory;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetAvailableRouteInfoMethodResult& rcfi_tclMsgGetAvailableRouteInfoMethodResult::operator=(const rcfi_tclMsgGetAvailableRouteInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   RouteInfoCategory = coRef.RouteInfoCategory;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgGetAvailableRouteInfoMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgGetAvailableRouteInfoMethodResult::u16GetFunctionID() const {return RCFI_C_U16_GETAVAILABLEROUTEINFO;}
tU8 rcfi_tclMsgGetAvailableRouteInfoMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rcfi_tclMsgGetAvailableRouteInfoMethodResult::vDestroy()
{
   RouteInfoCategory.clear();
}

tU32 rcfi_tclMsgGetAvailableRouteInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+RouteInfoCategory.size()*1;
}

tBool rcfi_tclMsgGetAvailableRouteInfoMethodResult::operator==(const rcfi_tclMsgGetAvailableRouteInfoMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RouteInfoCategory.size() == rfoCmp.RouteInfoCategory.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RouteInfoCategory.size()); ++u32Idx)
            bResult = bResult && (RouteInfoCategory[u32Idx] == rfoCmp.RouteInfoCategory[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgGetAvailableRouteInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      RouteInfoCategory.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RouteInfoCategory[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgGetAvailableRouteInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)RouteInfoCategory.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RouteInfoCategory.size(); ++u32Idx)
         oOut << RouteInfoCategory[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetRouteInfoMethodStart::rcfi_tclMsgGetRouteInfoMethodStart(const rcfi_tclMsgGetRouteInfoMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   LastRequiredTripSegment = coRef.LastRequiredTripSegment;
   NavUTMBinContainerMajorVersion = coRef.NavUTMBinContainerMajorVersion;
   MapRouteBinContainerMajorVersion = coRef.MapRouteBinContainerMajorVersion;
   RouteInfoCategory = coRef.RouteInfoCategory;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetRouteInfoMethodStart& rcfi_tclMsgGetRouteInfoMethodStart::operator=(const rcfi_tclMsgGetRouteInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   LastRequiredTripSegment = coRef.LastRequiredTripSegment;
   NavUTMBinContainerMajorVersion = coRef.NavUTMBinContainerMajorVersion;
   MapRouteBinContainerMajorVersion = coRef.MapRouteBinContainerMajorVersion;
   RouteInfoCategory = coRef.RouteInfoCategory;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgGetRouteInfoMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgGetRouteInfoMethodStart::u16GetFunctionID() const {return RCFI_C_U16_GETROUTEINFO;}
tU8 rcfi_tclMsgGetRouteInfoMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rcfi_tclMsgGetRouteInfoMethodStart::vDestroy()
{
   RouteInfoCategory.clear();
}

tU32 rcfi_tclMsgGetRouteInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (25 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+10+RouteInfoCategory.size()*1;
}

tBool rcfi_tclMsgGetRouteInfoMethodStart::operator==(const rcfi_tclMsgGetRouteInfoMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (LastRequiredTripSegment == rfoCmp.LastRequiredTripSegment);
      bResult = bResult && (NavUTMBinContainerMajorVersion == rfoCmp.NavUTMBinContainerMajorVersion);
      bResult = bResult && (MapRouteBinContainerMajorVersion == rfoCmp.MapRouteBinContainerMajorVersion);
      bResult = bResult && (RouteInfoCategory.size() == rfoCmp.RouteInfoCategory.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RouteInfoCategory.size()); ++u32Idx)
            bResult = bResult && (RouteInfoCategory[u32Idx] == rfoCmp.RouteInfoCategory[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgGetRouteInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> LastRequiredTripSegment;
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> NavUTMBinContainerMajorVersion;
   }
   if (25 <= oIn.u16GetMajorVersion())
   {
      oIn >> MapRouteBinContainerMajorVersion;
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      RouteInfoCategory.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RouteInfoCategory[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgGetRouteInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << LastRequiredTripSegment;
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << NavUTMBinContainerMajorVersion;
   }
   if (25 <= oOut.u16GetMajorVersion())
   {
      oOut << MapRouteBinContainerMajorVersion;
   }
   oOut << (tU32)RouteInfoCategory.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RouteInfoCategory.size(); ++u32Idx)
         oOut << RouteInfoCategory[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetRouteInfoMethodResult::rcfi_tclMsgGetRouteInfoMethodResult(const rcfi_tclMsgGetRouteInfoMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   RouteInfoId = coRef.RouteInfoId;
   RouteInfoCounter = coRef.RouteInfoCounter;
   FirstElement = coRef.FirstElement;
   RouteInfoStatus = coRef.RouteInfoStatus;
   RouteInfoElementList = coRef.RouteInfoElementList;
   RouteInfoCategoryList = coRef.RouteInfoCategoryList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetRouteInfoMethodResult& rcfi_tclMsgGetRouteInfoMethodResult::operator=(const rcfi_tclMsgGetRouteInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   RouteInfoId = coRef.RouteInfoId;
   RouteInfoCounter = coRef.RouteInfoCounter;
   FirstElement = coRef.FirstElement;
   RouteInfoStatus = coRef.RouteInfoStatus;
   RouteInfoElementList = coRef.RouteInfoElementList;
   RouteInfoCategoryList = coRef.RouteInfoCategoryList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgGetRouteInfoMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgGetRouteInfoMethodResult::u16GetFunctionID() const {return RCFI_C_U16_GETROUTEINFO;}
tU8 rcfi_tclMsgGetRouteInfoMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rcfi_tclMsgGetRouteInfoMethodResult::vDestroy()
{
   FirstElement.vDestroy(); 
   RouteInfoStatus.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < RouteInfoElementList.size(); ++u32Idx)
         RouteInfoElementList[u32Idx].vDestroy();
   }
   RouteInfoElementList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < RouteInfoCategoryList.size(); ++u32Idx)
         RouteInfoCategoryList[u32Idx].vDestroy();
   }
   RouteInfoCategoryList.clear();
}

tU32 rcfi_tclMsgGetRouteInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += RouteInfoStatus.u32GetSize(u16MajorVersion);
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RouteInfoElementList.size(); ++u32ListIdx)
      u32DynamicSize += RouteInfoElementList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < RouteInfoCategoryList.size(); ++u32ListIdx)
      u32DynamicSize += RouteInfoCategoryList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+18+FirstElement.u32GetSize(u16MajorVersion);
}

tBool rcfi_tclMsgGetRouteInfoMethodResult::operator==(const rcfi_tclMsgGetRouteInfoMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (RouteInfoId == rfoCmp.RouteInfoId);
      bResult = bResult && (RouteInfoCounter == rfoCmp.RouteInfoCounter);
      bResult = bResult && (FirstElement == rfoCmp.FirstElement);
      bResult = bResult && (RouteInfoStatus == rfoCmp.RouteInfoStatus);
      bResult = bResult && (RouteInfoElementList.size() == rfoCmp.RouteInfoElementList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RouteInfoElementList.size()); ++u32Idx)
            bResult = bResult && (RouteInfoElementList[u32Idx] == rfoCmp.RouteInfoElementList[u32Idx]);
      }
      bResult = bResult && (RouteInfoCategoryList.size() == rfoCmp.RouteInfoCategoryList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RouteInfoCategoryList.size()); ++u32Idx)
            bResult = bResult && (RouteInfoCategoryList[u32Idx] == rfoCmp.RouteInfoCategoryList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgGetRouteInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> RouteInfoId;
   oIn >> RouteInfoCounter;
   oIn >> FirstElement;
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> RouteInfoStatus;
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RouteInfoElementList.size(); ++u32Idx)
      {
         RouteInfoElementList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RouteInfoElementList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RouteInfoElementList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RouteInfoCategoryList.size(); ++u32Idx)
      {
         RouteInfoCategoryList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RouteInfoCategoryList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RouteInfoCategoryList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgGetRouteInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << RouteInfoId;
   oOut << RouteInfoCounter;
   oOut << FirstElement;
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << RouteInfoStatus;
   }
   oOut << (tU32)RouteInfoElementList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RouteInfoElementList.size(); ++u32Idx)
         oOut << RouteInfoElementList[u32Idx];
   }
   oOut << (tU32)RouteInfoCategoryList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RouteInfoCategoryList.size(); ++u32Idx)
         oOut << RouteInfoCategoryList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetNavRouteListDepictionMethodStart::rcfi_tclMsgGetNavRouteListDepictionMethodStart(const rcfi_tclMsgGetNavRouteListDepictionMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   RouteListId = coRef.RouteListId;
   TripSegmentListToDepict = coRef.TripSegmentListToDepict;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetNavRouteListDepictionMethodStart& rcfi_tclMsgGetNavRouteListDepictionMethodStart::operator=(const rcfi_tclMsgGetNavRouteListDepictionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   RouteListId = coRef.RouteListId;
   TripSegmentListToDepict = coRef.TripSegmentListToDepict;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgGetNavRouteListDepictionMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgGetNavRouteListDepictionMethodStart::u16GetFunctionID() const {return RCFI_C_U16_GETNAVROUTELISTDEPICTION;}
tU8 rcfi_tclMsgGetNavRouteListDepictionMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rcfi_tclMsgGetNavRouteListDepictionMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TripSegmentListToDepict.size(); ++u32Idx)
         TripSegmentListToDepict[u32Idx].vDestroy();
   }
   TripSegmentListToDepict.clear();
}

tU32 rcfi_tclMsgGetNavRouteListDepictionMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TripSegmentListToDepict.size(); ++u32ListIdx)
      u32DynamicSize += TripSegmentListToDepict[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+12;
}

tBool rcfi_tclMsgGetNavRouteListDepictionMethodStart::operator==(const rcfi_tclMsgGetNavRouteListDepictionMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (RouteListId == rfoCmp.RouteListId);
      bResult = bResult && (TripSegmentListToDepict.size() == rfoCmp.TripSegmentListToDepict.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TripSegmentListToDepict.size()); ++u32Idx)
            bResult = bResult && (TripSegmentListToDepict[u32Idx] == rfoCmp.TripSegmentListToDepict[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgGetNavRouteListDepictionMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> RouteListId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TripSegmentListToDepict.size(); ++u32Idx)
      {
         TripSegmentListToDepict[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TripSegmentListToDepict.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TripSegmentListToDepict[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgGetNavRouteListDepictionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << RouteListId;
   oOut << (tU32)TripSegmentListToDepict.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TripSegmentListToDepict.size(); ++u32Idx)
         oOut << TripSegmentListToDepict[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetNavRouteListDepictionMethodResult::rcfi_tclMsgGetNavRouteListDepictionMethodResult(const rcfi_tclMsgGetNavRouteListDepictionMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   RouteListId = coRef.RouteListId;
   NavDataSetID = coRef.NavDataSetID;
   DepictedTripSegmentList = coRef.DepictedTripSegmentList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetNavRouteListDepictionMethodResult& rcfi_tclMsgGetNavRouteListDepictionMethodResult::operator=(const rcfi_tclMsgGetNavRouteListDepictionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   RouteListId = coRef.RouteListId;
   NavDataSetID = coRef.NavDataSetID;
   DepictedTripSegmentList = coRef.DepictedTripSegmentList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgGetNavRouteListDepictionMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgGetNavRouteListDepictionMethodResult::u16GetFunctionID() const {return RCFI_C_U16_GETNAVROUTELISTDEPICTION;}
tU8 rcfi_tclMsgGetNavRouteListDepictionMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rcfi_tclMsgGetNavRouteListDepictionMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DepictedTripSegmentList.size(); ++u32Idx)
         DepictedTripSegmentList[u32Idx].vDestroy();
   }
   DepictedTripSegmentList.clear();
}

tU32 rcfi_tclMsgGetNavRouteListDepictionMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DepictedTripSegmentList.size(); ++u32ListIdx)
      u32DynamicSize += DepictedTripSegmentList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+16;
}

tBool rcfi_tclMsgGetNavRouteListDepictionMethodResult::operator==(const rcfi_tclMsgGetNavRouteListDepictionMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (RouteListId == rfoCmp.RouteListId);
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (DepictedTripSegmentList.size() == rfoCmp.DepictedTripSegmentList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DepictedTripSegmentList.size()); ++u32Idx)
            bResult = bResult && (DepictedTripSegmentList[u32Idx] == rfoCmp.DepictedTripSegmentList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgGetNavRouteListDepictionMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> RouteListId;
   oIn >> NavDataSetID;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DepictedTripSegmentList.size(); ++u32Idx)
      {
         DepictedTripSegmentList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      DepictedTripSegmentList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> DepictedTripSegmentList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgGetNavRouteListDepictionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << RouteListId;
   oOut << NavDataSetID;
   oOut << (tU32)DepictedTripSegmentList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < DepictedTripSegmentList.size(); ++u32Idx)
         oOut << DepictedTripSegmentList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetClusterListsMethodStart::rcfi_tclMsgGetClusterListsMethodStart(const rcfi_tclMsgGetClusterListsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumberList = coRef.TripSegmentNumberList;
   ClusterListTypes = coRef.ClusterListTypes;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetClusterListsMethodStart& rcfi_tclMsgGetClusterListsMethodStart::operator=(const rcfi_tclMsgGetClusterListsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumberList = coRef.TripSegmentNumberList;
   ClusterListTypes = coRef.ClusterListTypes;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgGetClusterListsMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgGetClusterListsMethodStart::u16GetFunctionID() const {return RCFI_C_U16_GETCLUSTERLISTS;}
tU8 rcfi_tclMsgGetClusterListsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rcfi_tclMsgGetClusterListsMethodStart::vDestroy()
{
   TripSegmentNumberList.clear();
}

tU32 rcfi_tclMsgGetClusterListsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9+TripSegmentNumberList.size()*2;
}

tBool rcfi_tclMsgGetClusterListsMethodStart::operator==(const rcfi_tclMsgGetClusterListsMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (TripSegmentNumberList.size() == rfoCmp.TripSegmentNumberList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TripSegmentNumberList.size()); ++u32Idx)
            bResult = bResult && (TripSegmentNumberList[u32Idx] == rfoCmp.TripSegmentNumberList[u32Idx]);
      }
      bResult = bResult && (ClusterListTypes == rfoCmp.ClusterListTypes);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgGetClusterListsMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      TripSegmentNumberList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TripSegmentNumberList[u32Idx];
      }
   }
   oIn >> ClusterListTypes;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgGetClusterListsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << (tU32)TripSegmentNumberList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TripSegmentNumberList.size(); ++u32Idx)
         oOut << TripSegmentNumberList[u32Idx];
   }
   oOut << ClusterListTypes;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetClusterListsMethodResult::rcfi_tclMsgGetClusterListsMethodResult(const rcfi_tclMsgGetClusterListsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   NavDataSetID = coRef.NavDataSetID;
   RouteSegmentClusterLists = coRef.RouteSegmentClusterLists;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetClusterListsMethodResult& rcfi_tclMsgGetClusterListsMethodResult::operator=(const rcfi_tclMsgGetClusterListsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   NavDataSetID = coRef.NavDataSetID;
   RouteSegmentClusterLists = coRef.RouteSegmentClusterLists;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgGetClusterListsMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgGetClusterListsMethodResult::u16GetFunctionID() const {return RCFI_C_U16_GETCLUSTERLISTS;}
tU8 rcfi_tclMsgGetClusterListsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rcfi_tclMsgGetClusterListsMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RouteSegmentClusterLists.size(); ++u32Idx)
         RouteSegmentClusterLists[u32Idx].vDestroy();
   }
   RouteSegmentClusterLists.clear();
}

tU32 rcfi_tclMsgGetClusterListsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RouteSegmentClusterLists.size(); ++u32ListIdx)
      u32DynamicSize += RouteSegmentClusterLists[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+12;
}

tBool rcfi_tclMsgGetClusterListsMethodResult::operator==(const rcfi_tclMsgGetClusterListsMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (RouteSegmentClusterLists.size() == rfoCmp.RouteSegmentClusterLists.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RouteSegmentClusterLists.size()); ++u32Idx)
            bResult = bResult && (RouteSegmentClusterLists[u32Idx] == rfoCmp.RouteSegmentClusterLists[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgGetClusterListsMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> NavDataSetID;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RouteSegmentClusterLists.size(); ++u32Idx)
      {
         RouteSegmentClusterLists[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RouteSegmentClusterLists.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RouteSegmentClusterLists[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgGetClusterListsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << NavDataSetID;
   oOut << (tU32)RouteSegmentClusterLists.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RouteSegmentClusterLists.size(); ++u32Idx)
         oOut << RouteSegmentClusterLists[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgEvaluatePositionsMethodStart::rcfi_tclMsgEvaluatePositionsMethodStart(const rcfi_tclMsgEvaluatePositionsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   CurrentTripSegment = coRef.CurrentTripSegment;
   Positions = coRef.Positions;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgEvaluatePositionsMethodStart& rcfi_tclMsgEvaluatePositionsMethodStart::operator=(const rcfi_tclMsgEvaluatePositionsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   CurrentTripSegment = coRef.CurrentTripSegment;
   Positions = coRef.Positions;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgEvaluatePositionsMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgEvaluatePositionsMethodStart::u16GetFunctionID() const {return RCFI_C_U16_EVALUATEPOSITIONS;}
tU8 rcfi_tclMsgEvaluatePositionsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rcfi_tclMsgEvaluatePositionsMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Positions.size(); ++u32Idx)
         Positions[u32Idx].vDestroy();
   }
   Positions.clear();
}

tU32 rcfi_tclMsgEvaluatePositionsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Positions.size(); ++u32ListIdx)
      u32DynamicSize += Positions[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+10;
}

tBool rcfi_tclMsgEvaluatePositionsMethodStart::operator==(const rcfi_tclMsgEvaluatePositionsMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (CurrentTripSegment == rfoCmp.CurrentTripSegment);
      bResult = bResult && (Positions.size() == rfoCmp.Positions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Positions.size()); ++u32Idx)
            bResult = bResult && (Positions[u32Idx] == rfoCmp.Positions[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgEvaluatePositionsMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> CurrentTripSegment;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Positions.size(); ++u32Idx)
      {
         Positions[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Positions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Positions[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgEvaluatePositionsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << CurrentTripSegment;
   oOut << (tU32)Positions.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Positions.size(); ++u32Idx)
         oOut << Positions[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgEvaluatePositionsMethodResult::rcfi_tclMsgEvaluatePositionsMethodResult(const rcfi_tclMsgEvaluatePositionsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   CurrentTripSegment = coRef.CurrentTripSegment;
   EvaluatedPositions = coRef.EvaluatedPositions;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgEvaluatePositionsMethodResult& rcfi_tclMsgEvaluatePositionsMethodResult::operator=(const rcfi_tclMsgEvaluatePositionsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   CurrentTripSegment = coRef.CurrentTripSegment;
   EvaluatedPositions = coRef.EvaluatedPositions;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgEvaluatePositionsMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgEvaluatePositionsMethodResult::u16GetFunctionID() const {return RCFI_C_U16_EVALUATEPOSITIONS;}
tU8 rcfi_tclMsgEvaluatePositionsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rcfi_tclMsgEvaluatePositionsMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < EvaluatedPositions.size(); ++u32Idx)
         EvaluatedPositions[u32Idx].vDestroy();
   }
   EvaluatedPositions.clear();
}

tU32 rcfi_tclMsgEvaluatePositionsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < EvaluatedPositions.size(); ++u32ListIdx)
      u32DynamicSize += EvaluatedPositions[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+10;
}

tBool rcfi_tclMsgEvaluatePositionsMethodResult::operator==(const rcfi_tclMsgEvaluatePositionsMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (CurrentTripSegment == rfoCmp.CurrentTripSegment);
      bResult = bResult && (EvaluatedPositions.size() == rfoCmp.EvaluatedPositions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < EvaluatedPositions.size()); ++u32Idx)
            bResult = bResult && (EvaluatedPositions[u32Idx] == rfoCmp.EvaluatedPositions[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgEvaluatePositionsMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> CurrentTripSegment;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < EvaluatedPositions.size(); ++u32Idx)
      {
         EvaluatedPositions[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      EvaluatedPositions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> EvaluatedPositions[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgEvaluatePositionsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << CurrentTripSegment;
   oOut << (tU32)EvaluatedPositions.size();
   {
      for (tU32 u32Idx = 0; u32Idx < EvaluatedPositions.size(); ++u32Idx)
         oOut << EvaluatedPositions[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgVerifyNewTrafficMessagesMethodStart::rcfi_tclMsgVerifyNewTrafficMessagesMethodStart(const rcfi_tclMsgVerifyNewTrafficMessagesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TrafficMessageStatus = coRef.TrafficMessageStatus;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgVerifyNewTrafficMessagesMethodStart& rcfi_tclMsgVerifyNewTrafficMessagesMethodStart::operator=(const rcfi_tclMsgVerifyNewTrafficMessagesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TrafficMessageStatus = coRef.TrafficMessageStatus;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgVerifyNewTrafficMessagesMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgVerifyNewTrafficMessagesMethodStart::u16GetFunctionID() const {return RCFI_C_U16_VERIFYNEWTRAFFICMESSAGES;}
tU8 rcfi_tclMsgVerifyNewTrafficMessagesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rcfi_tclMsgVerifyNewTrafficMessagesMethodStart::vDestroy()
{
   TrafficMessageStatus.vDestroy(); 
}

tU32 rcfi_tclMsgVerifyNewTrafficMessagesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += TrafficMessageStatus.u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+0;
}

tBool rcfi_tclMsgVerifyNewTrafficMessagesMethodStart::operator==(const rcfi_tclMsgVerifyNewTrafficMessagesMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TrafficMessageStatus == rfoCmp.TrafficMessageStatus);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgVerifyNewTrafficMessagesMethodStart::oRead(fi_tclInContext& oIn)
{
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> TrafficMessageStatus;
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgVerifyNewTrafficMessagesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << TrafficMessageStatus;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgVerifyNewTrafficMessagesMethodResult::rcfi_tclMsgVerifyNewTrafficMessagesMethodResult(const rcfi_tclMsgVerifyNewTrafficMessagesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgVerifyNewTrafficMessagesMethodResult& rcfi_tclMsgVerifyNewTrafficMessagesMethodResult::operator=(const rcfi_tclMsgVerifyNewTrafficMessagesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgVerifyNewTrafficMessagesMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgVerifyNewTrafficMessagesMethodResult::u16GetFunctionID() const {return RCFI_C_U16_VERIFYNEWTRAFFICMESSAGES;}
tU8 rcfi_tclMsgVerifyNewTrafficMessagesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rcfi_tclMsgVerifyNewTrafficMessagesMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgVerifyNewTrafficMessagesMethodResult::operator==(const rcfi_tclMsgVerifyNewTrafficMessagesMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgVerifyNewTrafficMessagesMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgVerifyNewTrafficMessagesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgActivateRouteCalculationMethodStart::rcfi_tclMsgActivateRouteCalculationMethodStart(const rcfi_tclMsgActivateRouteCalculationMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   RouteCalcProperty = coRef.RouteCalcProperty;
   SpeedProfiles = coRef.SpeedProfiles;
   UserProfiles = coRef.UserProfiles;
   SegmentStartPoint = coRef.SegmentStartPoint;
   SegmentDestinationList = coRef.SegmentDestinationList;
   TripStartTime = coRef.TripStartTime;
   TrackedSegment = coRef.TrackedSegment;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgActivateRouteCalculationMethodStart& rcfi_tclMsgActivateRouteCalculationMethodStart::operator=(const rcfi_tclMsgActivateRouteCalculationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   RouteCalcProperty = coRef.RouteCalcProperty;
   SpeedProfiles = coRef.SpeedProfiles;
   UserProfiles = coRef.UserProfiles;
   SegmentStartPoint = coRef.SegmentStartPoint;
   SegmentDestinationList = coRef.SegmentDestinationList;
   TripStartTime = coRef.TripStartTime;
   TrackedSegment = coRef.TrackedSegment;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgActivateRouteCalculationMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgActivateRouteCalculationMethodStart::u16GetFunctionID() const {return RCFI_C_U16_ACTIVATEROUTECALCULATION;}
tU8 rcfi_tclMsgActivateRouteCalculationMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rcfi_tclMsgActivateRouteCalculationMethodStart::vDestroy()
{
   RouteCalcProperty.vDestroy(); 
   SpeedProfiles.vDestroy(); 
   UserProfiles.vDestroy(); 
   SegmentStartPoint.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < SegmentDestinationList.size(); ++u32Idx)
         SegmentDestinationList[u32Idx].vDestroy();
   }
   SegmentDestinationList.clear();
   TripStartTime.vDestroy(); 
}

tU32 rcfi_tclMsgActivateRouteCalculationMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 6)
   {
      u32DynamicSize += SpeedProfiles.u32GetSize(u16MajorVersion);
   }
   if (7 <= u16MajorVersion)
   {
      u32DynamicSize += UserProfiles.u32GetSize(u16MajorVersion);
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SegmentDestinationList.size(); ++u32ListIdx)
      u32DynamicSize += SegmentDestinationList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+15+RouteCalcProperty.u32GetSize(u16MajorVersion)+SegmentStartPoint.u32GetSize(u16MajorVersion);
}

tBool rcfi_tclMsgActivateRouteCalculationMethodStart::operator==(const rcfi_tclMsgActivateRouteCalculationMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (TripSegmentNumber == rfoCmp.TripSegmentNumber);
      bResult = bResult && (RouteCalcProperty == rfoCmp.RouteCalcProperty);
      bResult = bResult && (SpeedProfiles == rfoCmp.SpeedProfiles);
      bResult = bResult && (UserProfiles == rfoCmp.UserProfiles);
      bResult = bResult && (SegmentStartPoint == rfoCmp.SegmentStartPoint);
      bResult = bResult && (SegmentDestinationList.size() == rfoCmp.SegmentDestinationList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SegmentDestinationList.size()); ++u32Idx)
            bResult = bResult && (SegmentDestinationList[u32Idx] == rfoCmp.SegmentDestinationList[u32Idx]);
      }
      bResult = bResult && (TripStartTime == rfoCmp.TripStartTime);
      bResult = bResult && (TrackedSegment == rfoCmp.TrackedSegment);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgActivateRouteCalculationMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> TripSegmentNumber;
   oIn >> RouteCalcProperty;
   if (oIn.u16GetMajorVersion() <= 6)
   {
      oIn >> SpeedProfiles;
   }
   if (7 <= oIn.u16GetMajorVersion())
   {
      oIn >> UserProfiles;
   }
   oIn >> SegmentStartPoint;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SegmentDestinationList.size(); ++u32Idx)
      {
         SegmentDestinationList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SegmentDestinationList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SegmentDestinationList[u32Idx];
      }
   }
   oIn >> TripStartTime;
   oIn >> TrackedSegment;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgActivateRouteCalculationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << TripSegmentNumber;
   oOut << RouteCalcProperty;
   if (oOut.u16GetMajorVersion() <= 6)
   {
      oOut << SpeedProfiles;
   }
   if (7 <= oOut.u16GetMajorVersion())
   {
      oOut << UserProfiles;
   }
   oOut << SegmentStartPoint;
   oOut << (tU32)SegmentDestinationList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SegmentDestinationList.size(); ++u32Idx)
         oOut << SegmentDestinationList[u32Idx];
   }
   oOut << TripStartTime;
   oOut << TrackedSegment;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgActivateRouteCalculationMethodResult::rcfi_tclMsgActivateRouteCalculationMethodResult(const rcfi_tclMsgActivateRouteCalculationMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   JobId = coRef.JobId;
   GlueAreaDescription = coRef.GlueAreaDescription;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgActivateRouteCalculationMethodResult& rcfi_tclMsgActivateRouteCalculationMethodResult::operator=(const rcfi_tclMsgActivateRouteCalculationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   JobId = coRef.JobId;
   GlueAreaDescription = coRef.GlueAreaDescription;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgActivateRouteCalculationMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgActivateRouteCalculationMethodResult::u16GetFunctionID() const {return RCFI_C_U16_ACTIVATEROUTECALCULATION;}
tU8 rcfi_tclMsgActivateRouteCalculationMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rcfi_tclMsgActivateRouteCalculationMethodResult::vDestroy()
{
   GlueAreaDescription.vDestroy(); 
}

tU32 rcfi_tclMsgActivateRouteCalculationMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 18;
}

tBool rcfi_tclMsgActivateRouteCalculationMethodResult::operator==(const rcfi_tclMsgActivateRouteCalculationMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (TripSegmentNumber == rfoCmp.TripSegmentNumber);
      bResult = bResult && (JobId == rfoCmp.JobId);
      bResult = bResult && (GlueAreaDescription == rfoCmp.GlueAreaDescription);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgActivateRouteCalculationMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> TripSegmentNumber;
   oIn >> JobId;
   oIn >> GlueAreaDescription;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgActivateRouteCalculationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << TripSegmentNumber;
   oOut << JobId;
   oOut << GlueAreaDescription;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgDeactivateRouteCalculationMethodStart::rcfi_tclMsgDeactivateRouteCalculationMethodStart(const rcfi_tclMsgDeactivateRouteCalculationMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgDeactivateRouteCalculationMethodStart& rcfi_tclMsgDeactivateRouteCalculationMethodStart::operator=(const rcfi_tclMsgDeactivateRouteCalculationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgDeactivateRouteCalculationMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgDeactivateRouteCalculationMethodStart::u16GetFunctionID() const {return RCFI_C_U16_DEACTIVATEROUTECALCULATION;}
tU8 rcfi_tclMsgDeactivateRouteCalculationMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rcfi_tclMsgDeactivateRouteCalculationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgDeactivateRouteCalculationMethodStart::operator==(const rcfi_tclMsgDeactivateRouteCalculationMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgDeactivateRouteCalculationMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgDeactivateRouteCalculationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgDeactivateRouteCalculationMethodResult::rcfi_tclMsgDeactivateRouteCalculationMethodResult(const rcfi_tclMsgDeactivateRouteCalculationMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   JobId = coRef.JobId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgDeactivateRouteCalculationMethodResult& rcfi_tclMsgDeactivateRouteCalculationMethodResult::operator=(const rcfi_tclMsgDeactivateRouteCalculationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   JobId = coRef.JobId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgDeactivateRouteCalculationMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgDeactivateRouteCalculationMethodResult::u16GetFunctionID() const {return RCFI_C_U16_DEACTIVATEROUTECALCULATION;}
tU8 rcfi_tclMsgDeactivateRouteCalculationMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rcfi_tclMsgDeactivateRouteCalculationMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

tBool rcfi_tclMsgDeactivateRouteCalculationMethodResult::operator==(const rcfi_tclMsgDeactivateRouteCalculationMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (TripSegmentNumber == rfoCmp.TripSegmentNumber);
      bResult = bResult && (JobId == rfoCmp.JobId);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgDeactivateRouteCalculationMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> TripSegmentNumber;
   oIn >> JobId;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgDeactivateRouteCalculationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << TripSegmentNumber;
   oOut << JobId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetPositionAndUpdateRouteMethodStart::rcfi_tclMsgSetPositionAndUpdateRouteMethodStart(const rcfi_tclMsgSetPositionAndUpdateRouteMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavDataSetID = coRef.NavDataSetID;
   CalcCarPosition = coRef.CalcCarPosition;
   RealCarPosition = coRef.RealCarPosition;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetPositionAndUpdateRouteMethodStart& rcfi_tclMsgSetPositionAndUpdateRouteMethodStart::operator=(const rcfi_tclMsgSetPositionAndUpdateRouteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NavDataSetID = coRef.NavDataSetID;
   CalcCarPosition = coRef.CalcCarPosition;
   RealCarPosition = coRef.RealCarPosition;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgSetPositionAndUpdateRouteMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgSetPositionAndUpdateRouteMethodStart::u16GetFunctionID() const {return RCFI_C_U16_SETPOSITIONANDUPDATEROUTE;}
tU8 rcfi_tclMsgSetPositionAndUpdateRouteMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rcfi_tclMsgSetPositionAndUpdateRouteMethodStart::vDestroy()
{
   CalcCarPosition.vDestroy(); 
   RealCarPosition.vDestroy(); 
}

tU32 rcfi_tclMsgSetPositionAndUpdateRouteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 44;
}

tBool rcfi_tclMsgSetPositionAndUpdateRouteMethodStart::operator==(const rcfi_tclMsgSetPositionAndUpdateRouteMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (CalcCarPosition == rfoCmp.CalcCarPosition);
      bResult = bResult && (RealCarPosition == rfoCmp.RealCarPosition);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgSetPositionAndUpdateRouteMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> NavDataSetID;
   oIn >> CalcCarPosition;
   oIn >> RealCarPosition;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgSetPositionAndUpdateRouteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavDataSetID;
   oOut << CalcCarPosition;
   oOut << RealCarPosition;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetPositionAndUpdateRouteMethodResult::rcfi_tclMsgSetPositionAndUpdateRouteMethodResult(const rcfi_tclMsgSetPositionAndUpdateRouteMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetPositionAndUpdateRouteMethodResult& rcfi_tclMsgSetPositionAndUpdateRouteMethodResult::operator=(const rcfi_tclMsgSetPositionAndUpdateRouteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgSetPositionAndUpdateRouteMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgSetPositionAndUpdateRouteMethodResult::u16GetFunctionID() const {return RCFI_C_U16_SETPOSITIONANDUPDATEROUTE;}
tU8 rcfi_tclMsgSetPositionAndUpdateRouteMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rcfi_tclMsgSetPositionAndUpdateRouteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

tBool rcfi_tclMsgSetPositionAndUpdateRouteMethodResult::operator==(const rcfi_tclMsgSetPositionAndUpdateRouteMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (TripSegmentNumber == rfoCmp.TripSegmentNumber);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgSetPositionAndUpdateRouteMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> TripSegmentNumber;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgSetPositionAndUpdateRouteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << TripSegmentNumber;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetCriterionAndUpdateRouteMethodStart::rcfi_tclMsgSetCriterionAndUpdateRouteMethodStart(const rcfi_tclMsgSetCriterionAndUpdateRouteMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   RouteCalcProperty = coRef.RouteCalcProperty;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetCriterionAndUpdateRouteMethodStart& rcfi_tclMsgSetCriterionAndUpdateRouteMethodStart::operator=(const rcfi_tclMsgSetCriterionAndUpdateRouteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RouteCalcProperty = coRef.RouteCalcProperty;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgSetCriterionAndUpdateRouteMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgSetCriterionAndUpdateRouteMethodStart::u16GetFunctionID() const {return RCFI_C_U16_SETCRITERIONANDUPDATEROUTE;}
tU8 rcfi_tclMsgSetCriterionAndUpdateRouteMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rcfi_tclMsgSetCriterionAndUpdateRouteMethodStart::vDestroy()
{
   RouteCalcProperty.vDestroy(); 
}

tU32 rcfi_tclMsgSetCriterionAndUpdateRouteMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+RouteCalcProperty.u32GetSize(u16MajorVersion);
}

tBool rcfi_tclMsgSetCriterionAndUpdateRouteMethodStart::operator==(const rcfi_tclMsgSetCriterionAndUpdateRouteMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RouteCalcProperty == rfoCmp.RouteCalcProperty);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgSetCriterionAndUpdateRouteMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> RouteCalcProperty;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgSetCriterionAndUpdateRouteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RouteCalcProperty;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetCriterionAndUpdateRouteMethodResult::rcfi_tclMsgSetCriterionAndUpdateRouteMethodResult(const rcfi_tclMsgSetCriterionAndUpdateRouteMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   JobId = coRef.JobId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetCriterionAndUpdateRouteMethodResult& rcfi_tclMsgSetCriterionAndUpdateRouteMethodResult::operator=(const rcfi_tclMsgSetCriterionAndUpdateRouteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   JobId = coRef.JobId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgSetCriterionAndUpdateRouteMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgSetCriterionAndUpdateRouteMethodResult::u16GetFunctionID() const {return RCFI_C_U16_SETCRITERIONANDUPDATEROUTE;}
tU8 rcfi_tclMsgSetCriterionAndUpdateRouteMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rcfi_tclMsgSetCriterionAndUpdateRouteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

tBool rcfi_tclMsgSetCriterionAndUpdateRouteMethodResult::operator==(const rcfi_tclMsgSetCriterionAndUpdateRouteMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (TripSegmentNumber == rfoCmp.TripSegmentNumber);
      bResult = bResult && (JobId == rfoCmp.JobId);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgSetCriterionAndUpdateRouteMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> TripSegmentNumber;
   oIn >> JobId;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgSetCriterionAndUpdateRouteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << TripSegmentNumber;
   oOut << JobId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodStart::rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodStart(const rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TrafficMessageStatus = coRef.TrafficMessageStatus;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodStart& rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodStart::operator=(const rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TrafficMessageStatus = coRef.TrafficMessageStatus;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodStart::u16GetFunctionID() const {return RCFI_C_U16_SETTRAFFICMESSAGESANDUPDATEROUTE;}
tU8 rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodStart::vDestroy()
{
   TrafficMessageStatus.vDestroy(); 
}

tU32 rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TrafficMessageStatus.u32GetSize(u16MajorVersion);
}

tBool rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodStart::operator==(const rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TrafficMessageStatus == rfoCmp.TrafficMessageStatus);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TrafficMessageStatus;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TrafficMessageStatus;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodResult::rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodResult(const rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   JobId = coRef.JobId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodResult& rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodResult::operator=(const rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   JobId = coRef.JobId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodResult::u16GetFunctionID() const {return RCFI_C_U16_SETTRAFFICMESSAGESANDUPDATEROUTE;}
tU8 rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

tBool rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodResult::operator==(const rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (TripSegmentNumber == rfoCmp.TripSegmentNumber);
      bResult = bResult && (JobId == rfoCmp.JobId);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> TripSegmentNumber;
   oIn >> JobId;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgSetTrafficMessagesAndUpdateRouteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << TripSegmentNumber;
   oOut << JobId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgCopyCalculationJobMethodStart::rcfi_tclMsgCopyCalculationJobMethodStart(const rcfi_tclMsgCopyCalculationJobMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgCopyCalculationJobMethodStart& rcfi_tclMsgCopyCalculationJobMethodStart::operator=(const rcfi_tclMsgCopyCalculationJobMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgCopyCalculationJobMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgCopyCalculationJobMethodStart::u16GetFunctionID() const {return RCFI_C_U16_COPYCALCULATIONJOB;}
tU8 rcfi_tclMsgCopyCalculationJobMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rcfi_tclMsgCopyCalculationJobMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgCopyCalculationJobMethodStart::operator==(const rcfi_tclMsgCopyCalculationJobMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgCopyCalculationJobMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgCopyCalculationJobMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgCopyCalculationJobMethodResult::rcfi_tclMsgCopyCalculationJobMethodResult(const rcfi_tclMsgCopyCalculationJobMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   GlueAreaTree = coRef.GlueAreaTree;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgCopyCalculationJobMethodResult& rcfi_tclMsgCopyCalculationJobMethodResult::operator=(const rcfi_tclMsgCopyCalculationJobMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   GlueAreaTree = coRef.GlueAreaTree;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgCopyCalculationJobMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgCopyCalculationJobMethodResult::u16GetFunctionID() const {return RCFI_C_U16_COPYCALCULATIONJOB;}
tU8 rcfi_tclMsgCopyCalculationJobMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rcfi_tclMsgCopyCalculationJobMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

tBool rcfi_tclMsgCopyCalculationJobMethodResult::operator==(const rcfi_tclMsgCopyCalculationJobMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (TripSegmentNumber == rfoCmp.TripSegmentNumber);
      bResult = bResult && (GlueAreaTree == rfoCmp.GlueAreaTree);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgCopyCalculationJobMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> TripSegmentNumber;
   oIn >> GlueAreaTree;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgCopyCalculationJobMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << TripSegmentNumber;
   oOut << GlueAreaTree;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetCalculationJobAndActivateRouteMethodStart::rcfi_tclMsgSetCalculationJobAndActivateRouteMethodStart(const rcfi_tclMsgSetCalculationJobAndActivateRouteMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   RouteCalcProperty = coRef.RouteCalcProperty;
   UserProfiles = coRef.UserProfiles;
   SegmentStartPoint = coRef.SegmentStartPoint;
   SegmentDestinationList = coRef.SegmentDestinationList;
   GlueAreaTree = coRef.GlueAreaTree;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetCalculationJobAndActivateRouteMethodStart& rcfi_tclMsgSetCalculationJobAndActivateRouteMethodStart::operator=(const rcfi_tclMsgSetCalculationJobAndActivateRouteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   RouteCalcProperty = coRef.RouteCalcProperty;
   UserProfiles = coRef.UserProfiles;
   SegmentStartPoint = coRef.SegmentStartPoint;
   SegmentDestinationList = coRef.SegmentDestinationList;
   GlueAreaTree = coRef.GlueAreaTree;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgSetCalculationJobAndActivateRouteMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgSetCalculationJobAndActivateRouteMethodStart::u16GetFunctionID() const {return RCFI_C_U16_SETCALCULATIONJOBANDACTIVATEROUTE;}
tU8 rcfi_tclMsgSetCalculationJobAndActivateRouteMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rcfi_tclMsgSetCalculationJobAndActivateRouteMethodStart::vDestroy()
{
   RouteCalcProperty.vDestroy(); 
   UserProfiles.vDestroy(); 
   SegmentStartPoint.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < SegmentDestinationList.size(); ++u32Idx)
         SegmentDestinationList[u32Idx].vDestroy();
   }
   SegmentDestinationList.clear();
}

tU32 rcfi_tclMsgSetCalculationJobAndActivateRouteMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (7 <= u16MajorVersion)
   {
      u32DynamicSize += UserProfiles.u32GetSize(u16MajorVersion);
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SegmentDestinationList.size(); ++u32ListIdx)
      u32DynamicSize += SegmentDestinationList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+14+RouteCalcProperty.u32GetSize(u16MajorVersion)+SegmentStartPoint.u32GetSize(u16MajorVersion);
}

tBool rcfi_tclMsgSetCalculationJobAndActivateRouteMethodStart::operator==(const rcfi_tclMsgSetCalculationJobAndActivateRouteMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (TripSegmentNumber == rfoCmp.TripSegmentNumber);
      bResult = bResult && (RouteCalcProperty == rfoCmp.RouteCalcProperty);
      bResult = bResult && (UserProfiles == rfoCmp.UserProfiles);
      bResult = bResult && (SegmentStartPoint == rfoCmp.SegmentStartPoint);
      bResult = bResult && (SegmentDestinationList.size() == rfoCmp.SegmentDestinationList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SegmentDestinationList.size()); ++u32Idx)
            bResult = bResult && (SegmentDestinationList[u32Idx] == rfoCmp.SegmentDestinationList[u32Idx]);
      }
      bResult = bResult && (GlueAreaTree == rfoCmp.GlueAreaTree);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgSetCalculationJobAndActivateRouteMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> TripSegmentNumber;
   oIn >> RouteCalcProperty;
   if (7 <= oIn.u16GetMajorVersion())
   {
      oIn >> UserProfiles;
   }
   oIn >> SegmentStartPoint;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SegmentDestinationList.size(); ++u32Idx)
      {
         SegmentDestinationList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SegmentDestinationList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SegmentDestinationList[u32Idx];
      }
   }
   oIn >> GlueAreaTree;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgSetCalculationJobAndActivateRouteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << TripSegmentNumber;
   oOut << RouteCalcProperty;
   if (7 <= oOut.u16GetMajorVersion())
   {
      oOut << UserProfiles;
   }
   oOut << SegmentStartPoint;
   oOut << (tU32)SegmentDestinationList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SegmentDestinationList.size(); ++u32Idx)
         oOut << SegmentDestinationList[u32Idx];
   }
   oOut << GlueAreaTree;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetCalculationJobAndActivateRouteMethodResult::rcfi_tclMsgSetCalculationJobAndActivateRouteMethodResult(const rcfi_tclMsgSetCalculationJobAndActivateRouteMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   JobId = coRef.JobId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetCalculationJobAndActivateRouteMethodResult& rcfi_tclMsgSetCalculationJobAndActivateRouteMethodResult::operator=(const rcfi_tclMsgSetCalculationJobAndActivateRouteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   JobId = coRef.JobId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgSetCalculationJobAndActivateRouteMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgSetCalculationJobAndActivateRouteMethodResult::u16GetFunctionID() const {return RCFI_C_U16_SETCALCULATIONJOBANDACTIVATEROUTE;}
tU8 rcfi_tclMsgSetCalculationJobAndActivateRouteMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rcfi_tclMsgSetCalculationJobAndActivateRouteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

tBool rcfi_tclMsgSetCalculationJobAndActivateRouteMethodResult::operator==(const rcfi_tclMsgSetCalculationJobAndActivateRouteMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (TripSegmentNumber == rfoCmp.TripSegmentNumber);
      bResult = bResult && (JobId == rfoCmp.JobId);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgSetCalculationJobAndActivateRouteMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> TripSegmentNumber;
   oIn >> JobId;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgSetCalculationJobAndActivateRouteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << TripSegmentNumber;
   oOut << JobId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetGlueAreaDescriptionMethodStart::rcfi_tclMsgGetGlueAreaDescriptionMethodStart(const rcfi_tclMsgGetGlueAreaDescriptionMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetGlueAreaDescriptionMethodStart& rcfi_tclMsgGetGlueAreaDescriptionMethodStart::operator=(const rcfi_tclMsgGetGlueAreaDescriptionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgGetGlueAreaDescriptionMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgGetGlueAreaDescriptionMethodStart::u16GetFunctionID() const {return RCFI_C_U16_GETGLUEAREADESCRIPTION;}
tU8 rcfi_tclMsgGetGlueAreaDescriptionMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rcfi_tclMsgGetGlueAreaDescriptionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgGetGlueAreaDescriptionMethodStart::operator==(const rcfi_tclMsgGetGlueAreaDescriptionMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgGetGlueAreaDescriptionMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgGetGlueAreaDescriptionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetGlueAreaDescriptionMethodResult::rcfi_tclMsgGetGlueAreaDescriptionMethodResult(const rcfi_tclMsgGetGlueAreaDescriptionMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   GlueAreaTree = coRef.GlueAreaTree;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgGetGlueAreaDescriptionMethodResult& rcfi_tclMsgGetGlueAreaDescriptionMethodResult::operator=(const rcfi_tclMsgGetGlueAreaDescriptionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   GlueAreaTree = coRef.GlueAreaTree;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgGetGlueAreaDescriptionMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgGetGlueAreaDescriptionMethodResult::u16GetFunctionID() const {return RCFI_C_U16_GETGLUEAREADESCRIPTION;}
tU8 rcfi_tclMsgGetGlueAreaDescriptionMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rcfi_tclMsgGetGlueAreaDescriptionMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

tBool rcfi_tclMsgGetGlueAreaDescriptionMethodResult::operator==(const rcfi_tclMsgGetGlueAreaDescriptionMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (TripSegmentNumber == rfoCmp.TripSegmentNumber);
      bResult = bResult && (GlueAreaTree == rfoCmp.GlueAreaTree);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgGetGlueAreaDescriptionMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> TripSegmentNumber;
   oIn >> GlueAreaTree;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgGetGlueAreaDescriptionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << TripSegmentNumber;
   oOut << GlueAreaTree;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodStart::rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodStart(const rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   EntryPointList = coRef.EntryPointList;
   NavDataSetID = coRef.NavDataSetID;
   OffroadCoordinates = coRef.OffroadCoordinates;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodStart& rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodStart::operator=(const rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   EntryPointList = coRef.EntryPointList;
   NavDataSetID = coRef.NavDataSetID;
   OffroadCoordinates = coRef.OffroadCoordinates;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodStart::u16GetFunctionID() const {return RCFI_C_U16_SETENTRYPOINTSANDUPDATEROUTE;}
tU8 rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < EntryPointList.size(); ++u32Idx)
         EntryPointList[u32Idx].vDestroy();
   }
   EntryPointList.clear();
   OffroadCoordinates.vDestroy(); 
}

tU32 rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < EntryPointList.size(); ++u32ListIdx)
      u32DynamicSize += EntryPointList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+16;
}

tBool rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodStart::operator==(const rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (EntryPointList.size() == rfoCmp.EntryPointList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < EntryPointList.size()); ++u32Idx)
            bResult = bResult && (EntryPointList[u32Idx] == rfoCmp.EntryPointList[u32Idx]);
      }
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (OffroadCoordinates == rfoCmp.OffroadCoordinates);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < EntryPointList.size(); ++u32Idx)
      {
         EntryPointList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      EntryPointList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> EntryPointList[u32Idx];
      }
   }
   oIn >> NavDataSetID;
   oIn >> OffroadCoordinates;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)EntryPointList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < EntryPointList.size(); ++u32Idx)
         oOut << EntryPointList[u32Idx];
   }
   oOut << NavDataSetID;
   oOut << OffroadCoordinates;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodResult::rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodResult(const rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   EntryPointInfo = coRef.EntryPointInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodResult& rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodResult::operator=(const rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   EntryPointInfo = coRef.EntryPointInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodResult::u16GetFunctionID() const {return RCFI_C_U16_SETENTRYPOINTSANDUPDATEROUTE;}
tU8 rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodResult::vDestroy()
{
   EntryPointInfo.vDestroy(); 
}

tU32 rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+EntryPointInfo.u32GetSize(u16MajorVersion);
}

tBool rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodResult::operator==(const rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (TripSegmentNumber == rfoCmp.TripSegmentNumber);
      bResult = bResult && (EntryPointInfo == rfoCmp.EntryPointInfo);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> TripSegmentNumber;
   oIn >> EntryPointInfo;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgSetEntryPointsAndUpdateRouteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << TripSegmentNumber;
   oOut << EntryPointInfo;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSwitchMissionMethodStart::rcfi_tclMsgSwitchMissionMethodStart(const rcfi_tclMsgSwitchMissionMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSwitchMissionMethodStart& rcfi_tclMsgSwitchMissionMethodStart::operator=(const rcfi_tclMsgSwitchMissionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgSwitchMissionMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgSwitchMissionMethodStart::u16GetFunctionID() const {return RCFI_C_U16_SWITCHMISSION;}
tU8 rcfi_tclMsgSwitchMissionMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rcfi_tclMsgSwitchMissionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

tBool rcfi_tclMsgSwitchMissionMethodStart::operator==(const rcfi_tclMsgSwitchMissionMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (TripSegmentNumber == rfoCmp.TripSegmentNumber);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgSwitchMissionMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> TripSegmentNumber;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgSwitchMissionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << TripSegmentNumber;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSwitchMissionMethodResult::rcfi_tclMsgSwitchMissionMethodResult(const rcfi_tclMsgSwitchMissionMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   OldTripHandle = coRef.OldTripHandle;
   OldRouteHandle = coRef.OldRouteHandle;
   OldTripSegmentNumber = coRef.OldTripSegmentNumber;
   NewTripHandle = coRef.NewTripHandle;
   NewRouteHandle = coRef.NewRouteHandle;
   NewTripSegmentNumber = coRef.NewTripSegmentNumber;
   JobId = coRef.JobId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgSwitchMissionMethodResult& rcfi_tclMsgSwitchMissionMethodResult::operator=(const rcfi_tclMsgSwitchMissionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   OldTripHandle = coRef.OldTripHandle;
   OldRouteHandle = coRef.OldRouteHandle;
   OldTripSegmentNumber = coRef.OldTripSegmentNumber;
   NewTripHandle = coRef.NewTripHandle;
   NewRouteHandle = coRef.NewRouteHandle;
   NewTripSegmentNumber = coRef.NewTripSegmentNumber;
   JobId = coRef.JobId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgSwitchMissionMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgSwitchMissionMethodResult::u16GetFunctionID() const {return RCFI_C_U16_SWITCHMISSION;}
tU8 rcfi_tclMsgSwitchMissionMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rcfi_tclMsgSwitchMissionMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

tBool rcfi_tclMsgSwitchMissionMethodResult::operator==(const rcfi_tclMsgSwitchMissionMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (OldTripHandle == rfoCmp.OldTripHandle);
      bResult = bResult && (OldRouteHandle == rfoCmp.OldRouteHandle);
      bResult = bResult && (OldTripSegmentNumber == rfoCmp.OldTripSegmentNumber);
      bResult = bResult && (NewTripHandle == rfoCmp.NewTripHandle);
      bResult = bResult && (NewRouteHandle == rfoCmp.NewRouteHandle);
      bResult = bResult && (NewTripSegmentNumber == rfoCmp.NewTripSegmentNumber);
      bResult = bResult && (JobId == rfoCmp.JobId);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgSwitchMissionMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> OldTripHandle;
   oIn >> OldRouteHandle;
   oIn >> OldTripSegmentNumber;
   oIn >> NewTripHandle;
   oIn >> NewRouteHandle;
   oIn >> NewTripSegmentNumber;
   oIn >> JobId;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgSwitchMissionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << OldTripHandle;
   oOut << OldRouteHandle;
   oOut << OldTripSegmentNumber;
   oOut << NewTripHandle;
   oOut << NewRouteHandle;
   oOut << NewTripSegmentNumber;
   oOut << JobId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgUpdateRouteInfoMethodStart::rcfi_tclMsgUpdateRouteInfoMethodStart(const rcfi_tclMsgUpdateRouteInfoMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   RouteList = coRef.RouteList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgUpdateRouteInfoMethodStart& rcfi_tclMsgUpdateRouteInfoMethodStart::operator=(const rcfi_tclMsgUpdateRouteInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   RouteList = coRef.RouteList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgUpdateRouteInfoMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgUpdateRouteInfoMethodStart::u16GetFunctionID() const {return RCFI_C_U16_UPDATEROUTEINFO;}
tU8 rcfi_tclMsgUpdateRouteInfoMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rcfi_tclMsgUpdateRouteInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool rcfi_tclMsgUpdateRouteInfoMethodStart::operator==(const rcfi_tclMsgUpdateRouteInfoMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (RouteList == rfoCmp.RouteList);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgUpdateRouteInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> RouteList;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgUpdateRouteInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << RouteList;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgUpdateRouteInfoMethodResult::rcfi_tclMsgUpdateRouteInfoMethodResult(const rcfi_tclMsgUpdateRouteInfoMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgUpdateRouteInfoMethodResult& rcfi_tclMsgUpdateRouteInfoMethodResult::operator=(const rcfi_tclMsgUpdateRouteInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgUpdateRouteInfoMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgUpdateRouteInfoMethodResult::u16GetFunctionID() const {return RCFI_C_U16_UPDATEROUTEINFO;}
tU8 rcfi_tclMsgUpdateRouteInfoMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rcfi_tclMsgUpdateRouteInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgUpdateRouteInfoMethodResult::operator==(const rcfi_tclMsgUpdateRouteInfoMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgUpdateRouteInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgUpdateRouteInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgDepictNavDataListMethodStart::rcfi_tclMsgDepictNavDataListMethodStart(const rcfi_tclMsgDepictNavDataListMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavDataSetID = coRef.NavDataSetID;
   PathDataListToDepict = coRef.PathDataListToDepict;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgDepictNavDataListMethodStart& rcfi_tclMsgDepictNavDataListMethodStart::operator=(const rcfi_tclMsgDepictNavDataListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NavDataSetID = coRef.NavDataSetID;
   PathDataListToDepict = coRef.PathDataListToDepict;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgDepictNavDataListMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgDepictNavDataListMethodStart::u16GetFunctionID() const {return RCFI_C_U16_DEPICTNAVDATALIST;}
tU8 rcfi_tclMsgDepictNavDataListMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rcfi_tclMsgDepictNavDataListMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PathDataListToDepict.size(); ++u32Idx)
         PathDataListToDepict[u32Idx].vDestroy();
   }
   PathDataListToDepict.clear();
}

tU32 rcfi_tclMsgDepictNavDataListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PathDataListToDepict.size(); ++u32ListIdx)
      u32DynamicSize += PathDataListToDepict[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool rcfi_tclMsgDepictNavDataListMethodStart::operator==(const rcfi_tclMsgDepictNavDataListMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (PathDataListToDepict.size() == rfoCmp.PathDataListToDepict.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PathDataListToDepict.size()); ++u32Idx)
            bResult = bResult && (PathDataListToDepict[u32Idx] == rfoCmp.PathDataListToDepict[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgDepictNavDataListMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> NavDataSetID;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PathDataListToDepict.size(); ++u32Idx)
      {
         PathDataListToDepict[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      PathDataListToDepict.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> PathDataListToDepict[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgDepictNavDataListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavDataSetID;
   oOut << (tU32)PathDataListToDepict.size();
   {
      for (tU32 u32Idx = 0; u32Idx < PathDataListToDepict.size(); ++u32Idx)
         oOut << PathDataListToDepict[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgDepictNavDataListMethodResult::rcfi_tclMsgDepictNavDataListMethodResult(const rcfi_tclMsgDepictNavDataListMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavDataSetID = coRef.NavDataSetID;
   DepictedDataPathList = coRef.DepictedDataPathList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgDepictNavDataListMethodResult& rcfi_tclMsgDepictNavDataListMethodResult::operator=(const rcfi_tclMsgDepictNavDataListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   NavDataSetID = coRef.NavDataSetID;
   DepictedDataPathList = coRef.DepictedDataPathList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgDepictNavDataListMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgDepictNavDataListMethodResult::u16GetFunctionID() const {return RCFI_C_U16_DEPICTNAVDATALIST;}
tU8 rcfi_tclMsgDepictNavDataListMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid rcfi_tclMsgDepictNavDataListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DepictedDataPathList.size(); ++u32Idx)
         DepictedDataPathList[u32Idx].vDestroy();
   }
   DepictedDataPathList.clear();
}

tU32 rcfi_tclMsgDepictNavDataListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DepictedDataPathList.size(); ++u32ListIdx)
      u32DynamicSize += DepictedDataPathList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool rcfi_tclMsgDepictNavDataListMethodResult::operator==(const rcfi_tclMsgDepictNavDataListMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (DepictedDataPathList.size() == rfoCmp.DepictedDataPathList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DepictedDataPathList.size()); ++u32Idx)
            bResult = bResult && (DepictedDataPathList[u32Idx] == rfoCmp.DepictedDataPathList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgDepictNavDataListMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> NavDataSetID;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DepictedDataPathList.size(); ++u32Idx)
      {
         DepictedDataPathList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      DepictedDataPathList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> DepictedDataPathList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgDepictNavDataListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavDataSetID;
   oOut << (tU32)DepictedDataPathList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < DepictedDataPathList.size(); ++u32Idx)
         oOut << DepictedDataPathList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgStartLoadingMethodStart::rcfi_tclMsgStartLoadingMethodStart(const rcfi_tclMsgStartLoadingMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   Strategy = coRef.Strategy;
   NavDataSetID = coRef.NavDataSetID;
   Location = coRef.Location;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgStartLoadingMethodStart& rcfi_tclMsgStartLoadingMethodStart::operator=(const rcfi_tclMsgStartLoadingMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Strategy = coRef.Strategy;
   NavDataSetID = coRef.NavDataSetID;
   Location = coRef.Location;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgStartLoadingMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgStartLoadingMethodStart::u16GetFunctionID() const {return RCFI_C_U16_STARTLOADING;}
tU8 rcfi_tclMsgStartLoadingMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rcfi_tclMsgStartLoadingMethodStart::vDestroy()
{
   Strategy.vDestroy(); 
   Location.vDestroy(); 
}

tU32 rcfi_tclMsgStartLoadingMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+Location.u32GetSize(u16MajorVersion);
}

tBool rcfi_tclMsgStartLoadingMethodStart::operator==(const rcfi_tclMsgStartLoadingMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Strategy == rfoCmp.Strategy);
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (Location == rfoCmp.Location);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgStartLoadingMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> Strategy;
   oIn >> NavDataSetID;
   oIn >> Location;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgStartLoadingMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Strategy;
   oOut << NavDataSetID;
   oOut << Location;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgStartLoadingMethodResult::rcfi_tclMsgStartLoadingMethodResult(const rcfi_tclMsgStartLoadingMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgStartLoadingMethodResult& rcfi_tclMsgStartLoadingMethodResult::operator=(const rcfi_tclMsgStartLoadingMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgStartLoadingMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgStartLoadingMethodResult::u16GetFunctionID() const {return RCFI_C_U16_STARTLOADING;}
tU8 rcfi_tclMsgStartLoadingMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rcfi_tclMsgStartLoadingMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgStartLoadingMethodResult::operator==(const rcfi_tclMsgStartLoadingMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgStartLoadingMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgStartLoadingMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgStopLoadingMethodStart::rcfi_tclMsgStopLoadingMethodStart(const rcfi_tclMsgStopLoadingMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgStopLoadingMethodStart& rcfi_tclMsgStopLoadingMethodStart::operator=(const rcfi_tclMsgStopLoadingMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgStopLoadingMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgStopLoadingMethodStart::u16GetFunctionID() const {return RCFI_C_U16_STOPLOADING;}
tU8 rcfi_tclMsgStopLoadingMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 rcfi_tclMsgStopLoadingMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgStopLoadingMethodStart::operator==(const rcfi_tclMsgStopLoadingMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgStopLoadingMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgStopLoadingMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgStopLoadingMethodResult::rcfi_tclMsgStopLoadingMethodResult(const rcfi_tclMsgStopLoadingMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgStopLoadingMethodResult& rcfi_tclMsgStopLoadingMethodResult::operator=(const rcfi_tclMsgStopLoadingMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgStopLoadingMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgStopLoadingMethodResult::u16GetFunctionID() const {return RCFI_C_U16_STOPLOADING;}
tU8 rcfi_tclMsgStopLoadingMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rcfi_tclMsgStopLoadingMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgStopLoadingMethodResult::operator==(const rcfi_tclMsgStopLoadingMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgStopLoadingMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgStopLoadingMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgUpdatePositionMethodStart::rcfi_tclMsgUpdatePositionMethodStart(const rcfi_tclMsgUpdatePositionMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavDataSetID = coRef.NavDataSetID;
   CalcCarPosition = coRef.CalcCarPosition;
   RealCarPosition = coRef.RealCarPosition;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgUpdatePositionMethodStart& rcfi_tclMsgUpdatePositionMethodStart::operator=(const rcfi_tclMsgUpdatePositionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NavDataSetID = coRef.NavDataSetID;
   CalcCarPosition = coRef.CalcCarPosition;
   RealCarPosition = coRef.RealCarPosition;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgUpdatePositionMethodStart::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgUpdatePositionMethodStart::u16GetFunctionID() const {return RCFI_C_U16_UPDATEPOSITION;}
tU8 rcfi_tclMsgUpdatePositionMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid rcfi_tclMsgUpdatePositionMethodStart::vDestroy()
{
   CalcCarPosition.vDestroy(); 
   RealCarPosition.vDestroy(); 
}

tU32 rcfi_tclMsgUpdatePositionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 44;
}

tBool rcfi_tclMsgUpdatePositionMethodStart::operator==(const rcfi_tclMsgUpdatePositionMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (CalcCarPosition == rfoCmp.CalcCarPosition);
      bResult = bResult && (RealCarPosition == rfoCmp.RealCarPosition);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgUpdatePositionMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> NavDataSetID;
   oIn >> CalcCarPosition;
   oIn >> RealCarPosition;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgUpdatePositionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavDataSetID;
   oOut << CalcCarPosition;
   oOut << RealCarPosition;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgUpdatePositionMethodResult::rcfi_tclMsgUpdatePositionMethodResult(const rcfi_tclMsgUpdatePositionMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgUpdatePositionMethodResult& rcfi_tclMsgUpdatePositionMethodResult::operator=(const rcfi_tclMsgUpdatePositionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgUpdatePositionMethodResult::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgUpdatePositionMethodResult::u16GetFunctionID() const {return RCFI_C_U16_UPDATEPOSITION;}
tU8 rcfi_tclMsgUpdatePositionMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 rcfi_tclMsgUpdatePositionMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgUpdatePositionMethodResult::operator==(const rcfi_tclMsgUpdatePositionMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgUpdatePositionMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgUpdatePositionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgTripStatusGet::rcfi_tclMsgTripStatusGet(const rcfi_tclMsgTripStatusGet& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgTripStatusGet& rcfi_tclMsgTripStatusGet::operator=(const rcfi_tclMsgTripStatusGet& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgTripStatusGet::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgTripStatusGet::u16GetFunctionID() const {return RCFI_C_U16_TRIPSTATUS;}
tU8 rcfi_tclMsgTripStatusGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rcfi_tclMsgTripStatusGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool rcfi_tclMsgTripStatusGet::operator==(const rcfi_tclMsgTripStatusGet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgTripStatusGet::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgTripStatusGet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgTripStatusStatus::rcfi_tclMsgTripStatusStatus(const rcfi_tclMsgTripStatusStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   CurrentTrackedSegment = coRef.CurrentTrackedSegment;
   TrackedTrip = coRef.TrackedTrip;
   RouteStatus = coRef.RouteStatus;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgTripStatusStatus& rcfi_tclMsgTripStatusStatus::operator=(const rcfi_tclMsgTripStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   CurrentTrackedSegment = coRef.CurrentTrackedSegment;
   TrackedTrip = coRef.TrackedTrip;
   RouteStatus = coRef.RouteStatus;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgTripStatusStatus::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgTripStatusStatus::u16GetFunctionID() const {return RCFI_C_U16_TRIPSTATUS;}
tU8 rcfi_tclMsgTripStatusStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rcfi_tclMsgTripStatusStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RouteStatus.size(); ++u32Idx)
         RouteStatus[u32Idx].vDestroy();
   }
   RouteStatus.clear();
}

tU32 rcfi_tclMsgTripStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RouteStatus.size(); ++u32ListIdx)
      u32DynamicSize += RouteStatus[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+9;
}

tBool rcfi_tclMsgTripStatusStatus::operator==(const rcfi_tclMsgTripStatusStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (CurrentTrackedSegment == rfoCmp.CurrentTrackedSegment);
      bResult = bResult && (TrackedTrip == rfoCmp.TrackedTrip);
      bResult = bResult && (RouteStatus.size() == rfoCmp.RouteStatus.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RouteStatus.size()); ++u32Idx)
            bResult = bResult && (RouteStatus[u32Idx] == rfoCmp.RouteStatus[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgTripStatusStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> CurrentTrackedSegment;
   oIn >> TrackedTrip;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RouteStatus.size(); ++u32Idx)
      {
         RouteStatus[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RouteStatus.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RouteStatus[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgTripStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << CurrentTrackedSegment;
   oOut << TrackedTrip;
   oOut << (tU32)RouteStatus.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RouteStatus.size(); ++u32Idx)
         oOut << RouteStatus[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgRouteInfoStatusGet::rcfi_tclMsgRouteInfoStatusGet(const rcfi_tclMsgRouteInfoStatusGet& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgRouteInfoStatusGet& rcfi_tclMsgRouteInfoStatusGet::operator=(const rcfi_tclMsgRouteInfoStatusGet& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgRouteInfoStatusGet::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgRouteInfoStatusGet::u16GetFunctionID() const {return RCFI_C_U16_ROUTEINFOSTATUS;}
tU8 rcfi_tclMsgRouteInfoStatusGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rcfi_tclMsgRouteInfoStatusGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool rcfi_tclMsgRouteInfoStatusGet::operator==(const rcfi_tclMsgRouteInfoStatusGet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgRouteInfoStatusGet::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgRouteInfoStatusGet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgRouteInfoStatusStatus::rcfi_tclMsgRouteInfoStatusStatus(const rcfi_tclMsgRouteInfoStatusStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandleIsValid = coRef.TripHandleIsValid;
   TripHandle = coRef.TripHandle;
   SingleRouteInfoStatus = coRef.SingleRouteInfoStatus;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgRouteInfoStatusStatus& rcfi_tclMsgRouteInfoStatusStatus::operator=(const rcfi_tclMsgRouteInfoStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   TripHandleIsValid = coRef.TripHandleIsValid;
   TripHandle = coRef.TripHandle;
   SingleRouteInfoStatus = coRef.SingleRouteInfoStatus;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgRouteInfoStatusStatus::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgRouteInfoStatusStatus::u16GetFunctionID() const {return RCFI_C_U16_ROUTEINFOSTATUS;}
tU8 rcfi_tclMsgRouteInfoStatusStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rcfi_tclMsgRouteInfoStatusStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SingleRouteInfoStatus.size(); ++u32Idx)
         SingleRouteInfoStatus[u32Idx].vDestroy();
   }
   SingleRouteInfoStatus.clear();
}

tU32 rcfi_tclMsgRouteInfoStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SingleRouteInfoStatus.size(); ++u32ListIdx)
      u32DynamicSize += SingleRouteInfoStatus[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+7;
}

tBool rcfi_tclMsgRouteInfoStatusStatus::operator==(const rcfi_tclMsgRouteInfoStatusStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandleIsValid == rfoCmp.TripHandleIsValid);
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (SingleRouteInfoStatus.size() == rfoCmp.SingleRouteInfoStatus.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SingleRouteInfoStatus.size()); ++u32Idx)
            bResult = bResult && (SingleRouteInfoStatus[u32Idx] == rfoCmp.SingleRouteInfoStatus[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgRouteInfoStatusStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandleIsValid;
   oIn >> TripHandle;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SingleRouteInfoStatus.size(); ++u32Idx)
      {
         SingleRouteInfoStatus[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SingleRouteInfoStatus.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SingleRouteInfoStatus[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgRouteInfoStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandleIsValid;
   oOut << TripHandle;
   oOut << (tU32)SingleRouteInfoStatus.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SingleRouteInfoStatus.size(); ++u32Idx)
         oOut << SingleRouteInfoStatus[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgDistanceTimeInfoGet::rcfi_tclMsgDistanceTimeInfoGet(const rcfi_tclMsgDistanceTimeInfoGet& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgDistanceTimeInfoGet& rcfi_tclMsgDistanceTimeInfoGet::operator=(const rcfi_tclMsgDistanceTimeInfoGet& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgDistanceTimeInfoGet::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgDistanceTimeInfoGet::u16GetFunctionID() const {return RCFI_C_U16_DISTANCETIMEINFO;}
tU8 rcfi_tclMsgDistanceTimeInfoGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rcfi_tclMsgDistanceTimeInfoGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool rcfi_tclMsgDistanceTimeInfoGet::operator==(const rcfi_tclMsgDistanceTimeInfoGet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgDistanceTimeInfoGet::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgDistanceTimeInfoGet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgDistanceTimeInfoStatus::rcfi_tclMsgDistanceTimeInfoStatus(const rcfi_tclMsgDistanceTimeInfoStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandleIsValid = coRef.TripHandleIsValid;
   TripHandle = coRef.TripHandle;
   CurrentTripSegment = coRef.CurrentTripSegment;
   VehicleHeading = coRef.VehicleHeading;
   RouteDistanceTimeInfoList = coRef.RouteDistanceTimeInfoList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgDistanceTimeInfoStatus& rcfi_tclMsgDistanceTimeInfoStatus::operator=(const rcfi_tclMsgDistanceTimeInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   TripHandleIsValid = coRef.TripHandleIsValid;
   TripHandle = coRef.TripHandle;
   CurrentTripSegment = coRef.CurrentTripSegment;
   VehicleHeading = coRef.VehicleHeading;
   RouteDistanceTimeInfoList = coRef.RouteDistanceTimeInfoList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgDistanceTimeInfoStatus::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgDistanceTimeInfoStatus::u16GetFunctionID() const {return RCFI_C_U16_DISTANCETIMEINFO;}
tU8 rcfi_tclMsgDistanceTimeInfoStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rcfi_tclMsgDistanceTimeInfoStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RouteDistanceTimeInfoList.size(); ++u32Idx)
         RouteDistanceTimeInfoList[u32Idx].vDestroy();
   }
   RouteDistanceTimeInfoList.clear();
}

tU32 rcfi_tclMsgDistanceTimeInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RouteDistanceTimeInfoList.size(); ++u32ListIdx)
      u32DynamicSize += RouteDistanceTimeInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+10;
}

tBool rcfi_tclMsgDistanceTimeInfoStatus::operator==(const rcfi_tclMsgDistanceTimeInfoStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandleIsValid == rfoCmp.TripHandleIsValid);
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (CurrentTripSegment == rfoCmp.CurrentTripSegment);
      bResult = bResult && (VehicleHeading == rfoCmp.VehicleHeading);
      bResult = bResult && (RouteDistanceTimeInfoList.size() == rfoCmp.RouteDistanceTimeInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RouteDistanceTimeInfoList.size()); ++u32Idx)
            bResult = bResult && (RouteDistanceTimeInfoList[u32Idx] == rfoCmp.RouteDistanceTimeInfoList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgDistanceTimeInfoStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandleIsValid;
   oIn >> TripHandle;
   oIn >> CurrentTripSegment;
   oIn >> VehicleHeading;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RouteDistanceTimeInfoList.size(); ++u32Idx)
      {
         RouteDistanceTimeInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RouteDistanceTimeInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RouteDistanceTimeInfoList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgDistanceTimeInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandleIsValid;
   oOut << TripHandle;
   oOut << CurrentTripSegment;
   oOut << VehicleHeading;
   oOut << (tU32)RouteDistanceTimeInfoList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RouteDistanceTimeInfoList.size(); ++u32Idx)
         oOut << RouteDistanceTimeInfoList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgTravelValuesChangeUpReg::rcfi_tclMsgTravelValuesChangeUpReg(const rcfi_tclMsgTravelValuesChangeUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgTravelValuesChangeUpReg& rcfi_tclMsgTravelValuesChangeUpReg::operator=(const rcfi_tclMsgTravelValuesChangeUpReg& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgTravelValuesChangeUpReg::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgTravelValuesChangeUpReg::u16GetFunctionID() const {return RCFI_C_U16_TRAVELVALUESCHANGE;}
tU8 rcfi_tclMsgTravelValuesChangeUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 rcfi_tclMsgTravelValuesChangeUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool rcfi_tclMsgTravelValuesChangeUpReg::operator==(const rcfi_tclMsgTravelValuesChangeUpReg& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgTravelValuesChangeUpReg::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgTravelValuesChangeUpReg::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgTravelValuesChangeStatus::rcfi_tclMsgTravelValuesChangeStatus(const rcfi_tclMsgTravelValuesChangeStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandleIsValid = coRef.TripHandleIsValid;
   TripHandle = coRef.TripHandle;
   CurrentTrackedSegment = coRef.CurrentTrackedSegment;
   RouteValuesChange = coRef.RouteValuesChange;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgTravelValuesChangeStatus& rcfi_tclMsgTravelValuesChangeStatus::operator=(const rcfi_tclMsgTravelValuesChangeStatus& coRef)
{
   if (this == &coRef) return *this;
   TripHandleIsValid = coRef.TripHandleIsValid;
   TripHandle = coRef.TripHandle;
   CurrentTrackedSegment = coRef.CurrentTrackedSegment;
   RouteValuesChange = coRef.RouteValuesChange;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgTravelValuesChangeStatus::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgTravelValuesChangeStatus::u16GetFunctionID() const {return RCFI_C_U16_TRAVELVALUESCHANGE;}
tU8 rcfi_tclMsgTravelValuesChangeStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rcfi_tclMsgTravelValuesChangeStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RouteValuesChange.size(); ++u32Idx)
         RouteValuesChange[u32Idx].vDestroy();
   }
   RouteValuesChange.clear();
}

tU32 rcfi_tclMsgTravelValuesChangeStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RouteValuesChange.size(); ++u32ListIdx)
      u32DynamicSize += RouteValuesChange[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+9;
}

tBool rcfi_tclMsgTravelValuesChangeStatus::operator==(const rcfi_tclMsgTravelValuesChangeStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandleIsValid == rfoCmp.TripHandleIsValid);
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (CurrentTrackedSegment == rfoCmp.CurrentTrackedSegment);
      bResult = bResult && (RouteValuesChange.size() == rfoCmp.RouteValuesChange.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RouteValuesChange.size()); ++u32Idx)
            bResult = bResult && (RouteValuesChange[u32Idx] == rfoCmp.RouteValuesChange[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& rcfi_tclMsgTravelValuesChangeStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandleIsValid;
   oIn >> TripHandle;
   oIn >> CurrentTrackedSegment;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RouteValuesChange.size(); ++u32Idx)
      {
         RouteValuesChange[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RouteValuesChange.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RouteValuesChange[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgTravelValuesChangeStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandleIsValid;
   oOut << TripHandle;
   oOut << CurrentTrackedSegment;
   oOut << (tU32)RouteValuesChange.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RouteValuesChange.size(); ++u32Idx)
         oOut << RouteValuesChange[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgRouteCalculationStatusGet::rcfi_tclMsgRouteCalculationStatusGet(const rcfi_tclMsgRouteCalculationStatusGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgRouteCalculationStatusGet& rcfi_tclMsgRouteCalculationStatusGet::operator=(const rcfi_tclMsgRouteCalculationStatusGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgRouteCalculationStatusGet::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgRouteCalculationStatusGet::u16GetFunctionID() const {return RCFI_C_U16_ROUTECALCULATIONSTATUS;}
tU8 rcfi_tclMsgRouteCalculationStatusGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rcfi_tclMsgRouteCalculationStatusGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgRouteCalculationStatusGet::operator==(const rcfi_tclMsgRouteCalculationStatusGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgRouteCalculationStatusGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgRouteCalculationStatusGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgRouteCalculationStatusStatus::rcfi_tclMsgRouteCalculationStatusStatus(const rcfi_tclMsgRouteCalculationStatusStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   JobId = coRef.JobId;
   ProcessStatus = coRef.ProcessStatus;
   Quality = coRef.Quality;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgRouteCalculationStatusStatus& rcfi_tclMsgRouteCalculationStatusStatus::operator=(const rcfi_tclMsgRouteCalculationStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   JobId = coRef.JobId;
   ProcessStatus = coRef.ProcessStatus;
   Quality = coRef.Quality;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgRouteCalculationStatusStatus::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgRouteCalculationStatusStatus::u16GetFunctionID() const {return RCFI_C_U16_ROUTECALCULATIONSTATUS;}
tU8 rcfi_tclMsgRouteCalculationStatusStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 rcfi_tclMsgRouteCalculationStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

tBool rcfi_tclMsgRouteCalculationStatusStatus::operator==(const rcfi_tclMsgRouteCalculationStatusStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (TripSegmentNumber == rfoCmp.TripSegmentNumber);
      bResult = bResult && (JobId == rfoCmp.JobId);
      bResult = bResult && (ProcessStatus == rfoCmp.ProcessStatus);
      bResult = bResult && (Quality == rfoCmp.Quality);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgRouteCalculationStatusStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> TripSegmentNumber;
   oIn >> JobId;
   oIn >> ProcessStatus;
   oIn >> Quality;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgRouteCalculationStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << TripSegmentNumber;
   oOut << JobId;
   oOut << ProcessStatus;
   oOut << Quality;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgRouteStatusGet::rcfi_tclMsgRouteStatusGet(const rcfi_tclMsgRouteStatusGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgRouteStatusGet& rcfi_tclMsgRouteStatusGet::operator=(const rcfi_tclMsgRouteStatusGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgRouteStatusGet::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgRouteStatusGet::u16GetFunctionID() const {return RCFI_C_U16_ROUTESTATUS;}
tU8 rcfi_tclMsgRouteStatusGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rcfi_tclMsgRouteStatusGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgRouteStatusGet::operator==(const rcfi_tclMsgRouteStatusGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgRouteStatusGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgRouteStatusGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgRouteStatusStatus::rcfi_tclMsgRouteStatusStatus(const rcfi_tclMsgRouteStatusStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   JobId = coRef.JobId;
   TripSegmentStatus = coRef.TripSegmentStatus;
   NavDataSetID = coRef.NavDataSetID;
   RouteList = coRef.RouteList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgRouteStatusStatus& rcfi_tclMsgRouteStatusStatus::operator=(const rcfi_tclMsgRouteStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   JobId = coRef.JobId;
   TripSegmentStatus = coRef.TripSegmentStatus;
   NavDataSetID = coRef.NavDataSetID;
   RouteList = coRef.RouteList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgRouteStatusStatus::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgRouteStatusStatus::u16GetFunctionID() const {return RCFI_C_U16_ROUTESTATUS;}
tU8 rcfi_tclMsgRouteStatusStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rcfi_tclMsgRouteStatusStatus::vDestroy()
{
   TripSegmentStatus.vDestroy(); 
}

tU32 rcfi_tclMsgRouteStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 18+TripSegmentStatus.u32GetSize(u16MajorVersion);
}

tBool rcfi_tclMsgRouteStatusStatus::operator==(const rcfi_tclMsgRouteStatusStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (TripSegmentNumber == rfoCmp.TripSegmentNumber);
      bResult = bResult && (JobId == rfoCmp.JobId);
      bResult = bResult && (TripSegmentStatus == rfoCmp.TripSegmentStatus);
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (RouteList == rfoCmp.RouteList);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgRouteStatusStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> TripHandle;
   oIn >> RouteHandle;
   oIn >> TripSegmentNumber;
   oIn >> JobId;
   oIn >> TripSegmentStatus;
   oIn >> NavDataSetID;
   oIn >> RouteList;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgRouteStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TripHandle;
   oOut << RouteHandle;
   oOut << TripSegmentNumber;
   oOut << JobId;
   oOut << TripSegmentStatus;
   oOut << NavDataSetID;
   oOut << RouteList;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgRDBAccessibilityGet::rcfi_tclMsgRDBAccessibilityGet(const rcfi_tclMsgRDBAccessibilityGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgRDBAccessibilityGet& rcfi_tclMsgRDBAccessibilityGet::operator=(const rcfi_tclMsgRDBAccessibilityGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgRDBAccessibilityGet::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgRDBAccessibilityGet::u16GetFunctionID() const {return RCFI_C_U16_RDBACCESSIBILITY;}
tU8 rcfi_tclMsgRDBAccessibilityGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rcfi_tclMsgRDBAccessibilityGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgRDBAccessibilityGet::operator==(const rcfi_tclMsgRDBAccessibilityGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgRDBAccessibilityGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgRDBAccessibilityGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgRDBAccessibilityStatus::rcfi_tclMsgRDBAccessibilityStatus(const rcfi_tclMsgRDBAccessibilityStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   MediumId = coRef.MediumId;
   DataSetId = coRef.DataSetId;
   DataAccessibility = coRef.DataAccessibility;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgRDBAccessibilityStatus& rcfi_tclMsgRDBAccessibilityStatus::operator=(const rcfi_tclMsgRDBAccessibilityStatus& coRef)
{
   if (this == &coRef) return *this;
   MediumId = coRef.MediumId;
   DataSetId = coRef.DataSetId;
   DataAccessibility = coRef.DataAccessibility;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgRDBAccessibilityStatus::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgRDBAccessibilityStatus::u16GetFunctionID() const {return RCFI_C_U16_RDBACCESSIBILITY;}
tU8 rcfi_tclMsgRDBAccessibilityStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 rcfi_tclMsgRDBAccessibilityStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

tBool rcfi_tclMsgRDBAccessibilityStatus::operator==(const rcfi_tclMsgRDBAccessibilityStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MediumId == rfoCmp.MediumId);
      bResult = bResult && (DataSetId == rfoCmp.DataSetId);
      bResult = bResult && (DataAccessibility == rfoCmp.DataAccessibility);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgRDBAccessibilityStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> MediumId;
   oIn >> DataSetId;
   oIn >> DataAccessibility;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgRDBAccessibilityStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MediumId;
   oOut << DataSetId;
   oOut << DataAccessibility;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgRDBLoaderStatusGet::rcfi_tclMsgRDBLoaderStatusGet(const rcfi_tclMsgRDBLoaderStatusGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgRDBLoaderStatusGet& rcfi_tclMsgRDBLoaderStatusGet::operator=(const rcfi_tclMsgRDBLoaderStatusGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgRDBLoaderStatusGet::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgRDBLoaderStatusGet::u16GetFunctionID() const {return RCFI_C_U16_RDBLOADERSTATUS;}
tU8 rcfi_tclMsgRDBLoaderStatusGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rcfi_tclMsgRDBLoaderStatusGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgRDBLoaderStatusGet::operator==(const rcfi_tclMsgRDBLoaderStatusGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgRDBLoaderStatusGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgRDBLoaderStatusGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgRDBLoaderStatusStatus::rcfi_tclMsgRDBLoaderStatusStatus(const rcfi_tclMsgRDBLoaderStatusStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavDataSetID = coRef.NavDataSetID;
   StrategyStatus = coRef.StrategyStatus;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgRDBLoaderStatusStatus& rcfi_tclMsgRDBLoaderStatusStatus::operator=(const rcfi_tclMsgRDBLoaderStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   NavDataSetID = coRef.NavDataSetID;
   StrategyStatus = coRef.StrategyStatus;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgRDBLoaderStatusStatus::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgRDBLoaderStatusStatus::u16GetFunctionID() const {return RCFI_C_U16_RDBLOADERSTATUS;}
tU8 rcfi_tclMsgRDBLoaderStatusStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rcfi_tclMsgRDBLoaderStatusStatus::vDestroy()
{
   StrategyStatus.vDestroy(); 
}

tU32 rcfi_tclMsgRDBLoaderStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

tBool rcfi_tclMsgRDBLoaderStatusStatus::operator==(const rcfi_tclMsgRDBLoaderStatusStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (StrategyStatus == rfoCmp.StrategyStatus);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgRDBLoaderStatusStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> NavDataSetID;
   oIn >> StrategyStatus;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgRDBLoaderStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavDataSetID;
   oOut << StrategyStatus;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgEngineeringTextGet::rcfi_tclMsgEngineeringTextGet(const rcfi_tclMsgEngineeringTextGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgEngineeringTextGet& rcfi_tclMsgEngineeringTextGet::operator=(const rcfi_tclMsgEngineeringTextGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgEngineeringTextGet::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgEngineeringTextGet::u16GetFunctionID() const {return RCFI_C_U16_ENGINEERINGTEXT;}
tU8 rcfi_tclMsgEngineeringTextGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rcfi_tclMsgEngineeringTextGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgEngineeringTextGet::operator==(const rcfi_tclMsgEngineeringTextGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgEngineeringTextGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgEngineeringTextGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgEngineeringTextUpReg::rcfi_tclMsgEngineeringTextUpReg(const rcfi_tclMsgEngineeringTextUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgEngineeringTextUpReg& rcfi_tclMsgEngineeringTextUpReg::operator=(const rcfi_tclMsgEngineeringTextUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgEngineeringTextUpReg::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgEngineeringTextUpReg::u16GetFunctionID() const {return RCFI_C_U16_ENGINEERINGTEXT;}
tU8 rcfi_tclMsgEngineeringTextUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 rcfi_tclMsgEngineeringTextUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgEngineeringTextUpReg::operator==(const rcfi_tclMsgEngineeringTextUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgEngineeringTextUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgEngineeringTextUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgEngineeringTextRelUpReg::rcfi_tclMsgEngineeringTextRelUpReg(const rcfi_tclMsgEngineeringTextRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgEngineeringTextRelUpReg& rcfi_tclMsgEngineeringTextRelUpReg::operator=(const rcfi_tclMsgEngineeringTextRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgEngineeringTextRelUpReg::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgEngineeringTextRelUpReg::u16GetFunctionID() const {return RCFI_C_U16_ENGINEERINGTEXT;}
tU8 rcfi_tclMsgEngineeringTextRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 rcfi_tclMsgEngineeringTextRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgEngineeringTextRelUpReg::operator==(const rcfi_tclMsgEngineeringTextRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgEngineeringTextRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgEngineeringTextRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgEngineeringTextStatus::rcfi_tclMsgEngineeringTextStatus(const rcfi_tclMsgEngineeringTextStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Message = coRef.Message;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgEngineeringTextStatus& rcfi_tclMsgEngineeringTextStatus::operator=(const rcfi_tclMsgEngineeringTextStatus& coRef)
{
   if (this == &coRef) return *this;
   Message = coRef.Message;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgEngineeringTextStatus::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgEngineeringTextStatus::u16GetFunctionID() const {return RCFI_C_U16_ENGINEERINGTEXT;}
tU8 rcfi_tclMsgEngineeringTextStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid rcfi_tclMsgEngineeringTextStatus::vDestroy()
{
   Message.vDestroy();
}

tU32 rcfi_tclMsgEngineeringTextStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Message.u32GetSize(u16MajorVersion);
}

tBool rcfi_tclMsgEngineeringTextStatus::operator==(const rcfi_tclMsgEngineeringTextStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Message == rfoCmp.Message);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgEngineeringTextStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Message;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgEngineeringTextStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Message;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgUsedDatasetGet::rcfi_tclMsgUsedDatasetGet(const rcfi_tclMsgUsedDatasetGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgUsedDatasetGet& rcfi_tclMsgUsedDatasetGet::operator=(const rcfi_tclMsgUsedDatasetGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgUsedDatasetGet::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgUsedDatasetGet::u16GetFunctionID() const {return RCFI_C_U16_USEDDATASET;}
tU8 rcfi_tclMsgUsedDatasetGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 rcfi_tclMsgUsedDatasetGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgUsedDatasetGet::operator==(const rcfi_tclMsgUsedDatasetGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgUsedDatasetGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgUsedDatasetGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgUsedDatasetUpReg::rcfi_tclMsgUsedDatasetUpReg(const rcfi_tclMsgUsedDatasetUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgUsedDatasetUpReg& rcfi_tclMsgUsedDatasetUpReg::operator=(const rcfi_tclMsgUsedDatasetUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgUsedDatasetUpReg::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgUsedDatasetUpReg::u16GetFunctionID() const {return RCFI_C_U16_USEDDATASET;}
tU8 rcfi_tclMsgUsedDatasetUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 rcfi_tclMsgUsedDatasetUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgUsedDatasetUpReg::operator==(const rcfi_tclMsgUsedDatasetUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgUsedDatasetUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgUsedDatasetUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgUsedDatasetRelUpReg::rcfi_tclMsgUsedDatasetRelUpReg(const rcfi_tclMsgUsedDatasetRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgUsedDatasetRelUpReg& rcfi_tclMsgUsedDatasetRelUpReg::operator=(const rcfi_tclMsgUsedDatasetRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgUsedDatasetRelUpReg::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgUsedDatasetRelUpReg::u16GetFunctionID() const {return RCFI_C_U16_USEDDATASET;}
tU8 rcfi_tclMsgUsedDatasetRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 rcfi_tclMsgUsedDatasetRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool rcfi_tclMsgUsedDatasetRelUpReg::operator==(const rcfi_tclMsgUsedDatasetRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& rcfi_tclMsgUsedDatasetRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgUsedDatasetRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgUsedDatasetStatus::rcfi_tclMsgUsedDatasetStatus(const rcfi_tclMsgUsedDatasetStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   MediaId = coRef.MediaId;
   DataSetId = coRef.DataSetId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rcfi_tclMsgUsedDatasetStatus& rcfi_tclMsgUsedDatasetStatus::operator=(const rcfi_tclMsgUsedDatasetStatus& coRef)
{
   if (this == &coRef) return *this;
   MediaId = coRef.MediaId;
   DataSetId = coRef.DataSetId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 rcfi_tclMsgUsedDatasetStatus::u16GetServiceID() const {return RCFI_C_U16_SERVICE_ID;}
tU16 rcfi_tclMsgUsedDatasetStatus::u16GetFunctionID() const {return RCFI_C_U16_USEDDATASET;}
tU8 rcfi_tclMsgUsedDatasetStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 rcfi_tclMsgUsedDatasetStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool rcfi_tclMsgUsedDatasetStatus::operator==(const rcfi_tclMsgUsedDatasetStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MediaId == rfoCmp.MediaId);
      bResult = bResult && (DataSetId == rfoCmp.DataSetId);
   return bResult;
}

fi_tclInContext& rcfi_tclMsgUsedDatasetStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> MediaId;
   oIn >> DataSetId;
   return oIn;
}

fi_tclOutContext& rcfi_tclMsgUsedDatasetStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MediaId;
   oOut << DataSetId;
   return oOut;
}

