#ifndef RCFILANGUAGE_HEADER
#define RCFILANGUAGE_HEADER

class rcfi_tclInContext;
class rcfi_tclOutContext;
class rcfi_tclVisitorBase;

class MY_DECL rcfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  rcfi_tclDescription(fi_tclInContext* poIn, rcfi_tclVisitorBase* poVisit);
  rcfi_tclDescription(fi_tclOutContext* poOut, rcfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(rcfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ rcfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  rcfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<rcfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<rcfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline rcfi_tclDescription::rcfi_tclDescription(fi_tclInContext* poIn, rcfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline rcfi_tclDescription::rcfi_tclDescription(fi_tclOutContext* poOut, rcfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

