#include "precompiled.hh"

tBool rcfi_tclDescription::bInitMessage(rcfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case rcfi_tclToken::EN_LAST_TOKEN:
   case rcfi_tclToken::EN_LIST:
   case rcfi_tclToken::EN_END_OF_STRUCT:
   case rcfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case rcfi_tclToken::EN_MSG_GETROUTECAPABILITIESMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROUTECAPABILITY,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_CAPABILITYLIST));
   } break;
   case rcfi_tclToken::EN_MSG_GETROUTECALCOPTIONSMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CURRENTROUTEOPTION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_CURRENTROUTEOPTIONS));
   } break;
   case rcfi_tclToken::EN_MSG_GETROUTECALCOPTIONSMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_AVAILABLEROUTEOPTION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_AVAILABLEROUTEOPTIONS));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_MSG_MAXSUMVALUE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_MSG_MINSUMVALUE));
   } break;
   case rcfi_tclToken::EN_MSG_CHECKPROFILEVALIDITYMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_USERPROFILES,rcfi_tclSemanticDomain::EN_MSG_SPEEDPROFILES));
   } break;
   case rcfi_tclToken::EN_MSG_GETSTANDARDSPEEDHISTOGRAMMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_PROFILETYPE,rcfi_tclSemanticDomain::EN_MSG_PROFILETYPE));
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_DATASETID,rcfi_tclSemanticDomain::EN_MSG_NAVDATASETID));
      }
   } break;
   case rcfi_tclToken::EN_MSG_GETSTANDARDSPEEDHISTOGRAMMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_USERSPEEDPROFILE,rcfi_tclSemanticDomain::EN_MSG_USERPROFILE));
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_DATASETID,rcfi_tclSemanticDomain::EN_MSG_NAVDATASETID));
      }
   } break;
   case rcfi_tclToken::EN_MSG_GETDEFAULTVEHICLEPARAMETERMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_VEHICLECLASS,rcfi_tclSemanticDomain::EN_MSG_VEHICLECLASS));
   } break;
   case rcfi_tclToken::EN_MSG_GETDEFAULTVEHICLEPARAMETERMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_VEHICLEPARAMETER,rcfi_tclSemanticDomain::EN_MSG_VEHICLEPARAMETER));
   } break;
   case rcfi_tclToken::EN_MSG_SETTRAVELADVANTAGETHRESHOLDSMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_MICROLITER,rcfi_tclSemanticDomain::EN_MSG_USERCONFIRMEDDYNAMIZATIONTHRESHOLDTFA));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_MSG_USERCONFIRMEDDYNAMIZATIONTHRESHOLDTTA));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_MICROLITER,rcfi_tclSemanticDomain::EN_MSG_AUTOMATICDYNAMIZATIONTHRESHOLDTFA));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_MSG_AUTOMATICDYNAMIZATIONTHRESHOLDTTA));
   } break;
   case rcfi_tclToken::EN_MSG_SETTHRESHOLDDEFINITIONPROFILEMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_THRESHOLDDEFINITIONPROFILE,rcfi_tclSemanticDomain::EN_MSG_THRESHOLDDEFINITIONPROFILE));
   } break;
   case rcfi_tclToken::EN_MSG_CREATETRIPMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROUTEDEFINITION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_ROUTEDEFINITION));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TRIPSEGMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_TRIPDEFINITION));
      if (7 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_USERPROFILES,rcfi_tclSemanticDomain::EN_MSG_USERPROFILES));
      }
      if (poOutContext->u16GetMajorVersion() <= 6)
      {
         bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_SPEEDPROFILES,rcfi_tclSemanticDomain::EN_MSG_SPEEDPROFILES));
      }
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LOCATIONDESCRIPTION,rcfi_tclSemanticDomain::EN_MSG_STARTPOSITION));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_MSG_TRACKEDFLAG));
   } break;
   case rcfi_tclToken::EN_MSG_CREATETRIPMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROUTEHANDLEDESCRIPTION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLEDESCRIPTION));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_GETTRIPMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_GETTRIPMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROUTEHANDLEDESCRIPTION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_ROUTEDEFINITION));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TRIPSEGMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_TRIPDEFINITION));
      if (7 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_USERPROFILES,rcfi_tclSemanticDomain::EN_MSG_USERPROFILES));
      }
      if (poOutContext->u16GetMajorVersion() <= 6)
      {
         bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_SPEEDPROFILES,rcfi_tclSemanticDomain::EN_MSG_SPEEDPROFILES));
      }
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LOCATIONDESCRIPTION,rcfi_tclSemanticDomain::EN_MSG_STARTPOSITION));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_MSG_TRACKEDFLAG));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_KILLTRIPMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_KILLTRIPMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_KILLEDTRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_GETEXISTINGTRIPHANDLESMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_EXISTINGTRIPHANDLES));
   } break;
   case rcfi_tclToken::EN_MSG_ADDTRIPSEGMENTTOTRIPMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_ADDTRIPSEGMENTPARAMETERS,rcfi_tclSemanticDomain::EN_MSG_ADDTRIPSEGMENTPARAMETERS));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROUTEHANDLEDESCRIPTION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLEDESCRIPTION));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TRIPSEGMENT,rcfi_tclSemanticDomain::EN_MSG_TRIPSEGMENTDEFINITION));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_SEGMENTNUMBER));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_SOURCETRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_ADDTRIPSEGMENTTOTRIPMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_STARTROUTECALCULATIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROUTEHANDLEDESCRIPTION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLEDESCRIPTION));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_STARTROUTECALCULATIONMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_STOPROUTECALCULATIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_STOPROUTECALCULATIONMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_SETTRACKEDSEGMENTMETHODSTART:
   {
      if (35 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_SEGMENTSKIPPINGMODE,rcfi_tclSemanticDomain::EN_MSG_SEGMENTSKIPPINGMODE));
      }
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_TRIPSEGMENTNUMBER));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_SETTRACKEDSEGMENTMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_TRIPSEGMENTNUMBER));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_CHANGEDYNAMICROUTECALCMODEMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ACTIVEMANIPSOURCESOFROUTE,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_ACTIVEMANIPSOURCESOFROUTE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_CHANGEDYNAMICROUTECALCMODEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_SELECTTRAFFICSCENARIOMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_MSG_TRAFFICMESSAGEREVISION));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_SELECTTRAFFICSCENARIOMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_MSG_TRAFFICMESSAGEREVISION));
   } break;
   case rcfi_tclToken::EN_MSG_SETCALCULATIONMODEMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CALCULATIONMODE,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_CALCULATIONMODES));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_SETCALCULATIONMODEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_GETCALCULATIONMODEMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_GETCALCULATIONMODEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CALCULATIONMODE,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_CALCULATIONMODES));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_GETAVAILABLEROUTEINFOMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_ROUTEINFOCATEGORY,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_ROUTEINFOCATEGORY));
   } break;
   case rcfi_tclToken::EN_MSG_GETROUTEINFOMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_ROUTEINFOCATEGORY,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_ROUTEINFOCATEGORY));
      if (25 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_MSG_MAPROUTEBINCONTAINERMAJORVERSION));
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_MSG_NAVUTMBINCONTAINERMAJORVERSION));
      }
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_LASTREQUIREDTRIPSEGMENT));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_GETROUTEINFOMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROUTEINFOCATEGORY,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_ROUTEINFOCATEGORYLIST));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROUTEINFOELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_ROUTEINFOELEMENTLIST));
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_SINGLEROUTEINFOSTATUS,rcfi_tclSemanticDomain::EN_MSG_ROUTEINFOSTATUS));
      }
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_FIRSTELEMENT,rcfi_tclSemanticDomain::EN_MSG_FIRSTELEMENT));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_MSG_ROUTEINFOCOUNTER));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_MSG_ROUTEINFOID));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_GETNAVROUTELISTDEPICTIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_PATHLISTTODEPICT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_TRIPSEGMENTLISTTODEPICT));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_MSG_ROUTELISTID));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_GETNAVROUTELISTDEPICTIONMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DEPICTEDDATAPATHLISTSET,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_DEPICTEDTRIPSEGMENTLIST));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_DATASETID,rcfi_tclSemanticDomain::EN_MSG_NAVDATASETID));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_MSG_ROUTELISTID));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_GETCLUSTERLISTSMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_ROUTESEGMENTCLTYPES,rcfi_tclSemanticDomain::EN_MSG_CLUSTERLISTTYPES));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_TRIPSEGMENTNUMBERLIST));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_GETCLUSTERLISTSMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROUTESEGMENTCL,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_ROUTESEGMENTCLUSTERLISTS));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_DATASETID,rcfi_tclSemanticDomain::EN_MSG_NAVDATASETID));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_EVALUATEPOSITIONSMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONDESCRIPTION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_POSITIONS));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_CURRENTTRIPSEGMENT));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_EVALUATEPOSITIONSMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_EVALUATEDPOSITION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_EVALUATEDPOSITIONS));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_CURRENTTRIPSEGMENT));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_VERIFYNEWTRAFFICMESSAGESMETHODSTART:
   {
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TRAFFICMESSAGESTATUS,rcfi_tclSemanticDomain::EN_MSG_TRAFFICMESSAGESTATUS));
      }
   } break;
   case rcfi_tclToken::EN_MSG_ACTIVATEROUTECALCULATIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_MSG_TRACKEDSEGMENT));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSIXTIME,rcfi_tclSemanticDomain::EN_MSG_TRIPSTARTTIME));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVSUBDESTINATIONLIST,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_SEGMENTDESTINATIONLIST));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVRCALCROUTESTARTPOINTUNIONTYPE,rcfi_tclSemanticDomain::EN_MSG_SEGMENTSTARTPOINT));
      if (7 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_USERPROFILES,rcfi_tclSemanticDomain::EN_MSG_USERPROFILES));
      }
      if (poOutContext->u16GetMajorVersion() <= 6)
      {
         bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_SPEEDPROFILES,rcfi_tclSemanticDomain::EN_MSG_SPEEDPROFILES));
      }
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVROUTECALCPROPERTY,rcfi_tclSemanticDomain::EN_MSG_ROUTECALCPROPERTY));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_TRIPSEGMENTNUMBER));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_ACTIVATEROUTECALCULATIONMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_GLUEAREADESC,rcfi_tclSemanticDomain::EN_MSG_GLUEAREADESCRIPTION));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_MSG_JOBID));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_TRIPSEGMENTNUMBER));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_DEACTIVATEROUTECALCULATIONMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_MSG_JOBID));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_TRIPSEGMENTNUMBER));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_SETPOSITIONANDUPDATEROUTEMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVRCALCPOSITIONDESC,rcfi_tclSemanticDomain::EN_MSG_REALCARPOSITION));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVRCALCPOSITIONDESC,rcfi_tclSemanticDomain::EN_MSG_CALCCARPOSITION));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_DATASETID,rcfi_tclSemanticDomain::EN_MSG_NAVDATASETID));
   } break;
   case rcfi_tclToken::EN_MSG_SETPOSITIONANDUPDATEROUTEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_TRIPSEGMENTNUMBER));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_SETCRITERIONANDUPDATEROUTEMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVROUTECALCPROPERTY,rcfi_tclSemanticDomain::EN_MSG_ROUTECALCPROPERTY));
   } break;
   case rcfi_tclToken::EN_MSG_SETCRITERIONANDUPDATEROUTEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_MSG_JOBID));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_TRIPSEGMENTNUMBER));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_SETTRAFFICMESSAGESANDUPDATEROUTEMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TRAFFICMESSAGESTATUS,rcfi_tclSemanticDomain::EN_MSG_TRAFFICMESSAGESTATUS));
   } break;
   case rcfi_tclToken::EN_MSG_SETTRAFFICMESSAGESANDUPDATEROUTEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_MSG_JOBID));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_TRIPSEGMENTNUMBER));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_COPYCALCULATIONJOBMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32,rcfi_tclSemanticDomain::EN_MSG_GLUEAREATREE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_TRIPSEGMENTNUMBER));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_SETCALCULATIONJOBANDACTIVATEROUTEMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32,rcfi_tclSemanticDomain::EN_MSG_GLUEAREATREE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVSUBDESTINATIONLIST,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_SEGMENTDESTINATIONLIST));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVRCALCROUTESTARTPOINTUNIONTYPE,rcfi_tclSemanticDomain::EN_MSG_SEGMENTSTARTPOINT));
      if (7 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_USERPROFILES,rcfi_tclSemanticDomain::EN_MSG_USERPROFILES));
      }
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVROUTECALCPROPERTY,rcfi_tclSemanticDomain::EN_MSG_ROUTECALCPROPERTY));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_TRIPSEGMENTNUMBER));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_SETCALCULATIONJOBANDACTIVATEROUTEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_MSG_JOBID));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_TRIPSEGMENTNUMBER));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_GETGLUEAREADESCRIPTIONMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32,rcfi_tclSemanticDomain::EN_MSG_GLUEAREATREE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_TRIPSEGMENTNUMBER));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_SETENTRYPOINTSANDUPDATEROUTEMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_MSG_OFFROADCOORDINATES));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_DATASETID,rcfi_tclSemanticDomain::EN_MSG_NAVDATASETID));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ENTRYPOINT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_ENTRYPOINTLIST));
   } break;
   case rcfi_tclToken::EN_MSG_SETENTRYPOINTSANDUPDATEROUTEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ENTRYPOINTINFO,rcfi_tclSemanticDomain::EN_MSG_ENTRYPOINTINFO));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_TRIPSEGMENTNUMBER));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_SWITCHMISSIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_TRIPSEGMENTNUMBER));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_SWITCHMISSIONMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_MSG_JOBID));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_NEWTRIPSEGMENTNUMBER));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_NEWROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_NEWTRIPHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_OLDTRIPSEGMENTNUMBER));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_OLDROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_OLDTRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_UPDATEROUTEINFOMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32,rcfi_tclSemanticDomain::EN_MSG_ROUTELIST));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_DEPICTNAVDATALISTMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_PATHDATALISTSETTODEPICT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_PATHDATALISTTODEPICT));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_DATASETID,rcfi_tclSemanticDomain::EN_MSG_NAVDATASETID));
   } break;
   case rcfi_tclToken::EN_MSG_DEPICTNAVDATALISTMETHODRESULT:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DEPICTEDDATAPATHLISTSET,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_DEPICTEDDATAPATHLIST));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_DATASETID,rcfi_tclSemanticDomain::EN_MSG_NAVDATASETID));
   } break;
   case rcfi_tclToken::EN_MSG_STARTLOADINGMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVRCALCROUTESTARTPOINTUNIONTYPE,rcfi_tclSemanticDomain::EN_MSG_LOCATION));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_DATASETID,rcfi_tclSemanticDomain::EN_MSG_NAVDATASETID));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LOADSTRATEGY,rcfi_tclSemanticDomain::EN_MSG_STRATEGY));
   } break;
   case rcfi_tclToken::EN_MSG_UPDATEPOSITIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVRCALCPOSITIONDESC,rcfi_tclSemanticDomain::EN_MSG_REALCARPOSITION));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVRCALCPOSITIONDESC,rcfi_tclSemanticDomain::EN_MSG_CALCCARPOSITION));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_DATASETID,rcfi_tclSemanticDomain::EN_MSG_NAVDATASETID));
   } break;
   case rcfi_tclToken::EN_MSG_TRIPSTATUSGET:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_TRIPSTATUSSTATUS:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROUTESTATUS,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_ROUTESTATUS));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_MSG_TRACKEDTRIP));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_CURRENTTRACKEDSEGMENT));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_ROUTEINFOSTATUSGET:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_ROUTEINFOSTATUSSTATUS:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_SINGLEROUTEINFOSTATUS,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_SINGLEROUTEINFOSTATUS));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLEISVALID));
   } break;
   case rcfi_tclToken::EN_MSG_DISTANCETIMEINFOGET:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_DISTANCETIMEINFOSTATUS:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROUTEDISTANCETIMEINFO,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_ROUTEDISTANCETIMEINFOLIST));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_DIRECTIONABSOLUTE,rcfi_tclSemanticDomain::EN_MSG_VEHICLEHEADING));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_CURRENTTRIPSEGMENT));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLEISVALID));
   } break;
   case rcfi_tclToken::EN_MSG_TRAVELVALUESCHANGEUPREG:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_TRAVELVALUESCHANGESTATUS:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROUTEVALUESCHANGE,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MSG_ROUTEVALUESCHANGE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_CURRENTTRACKEDSEGMENT));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLEISVALID));
   } break;
   case rcfi_tclToken::EN_MSG_ROUTECALCULATIONSTATUSSTATUS:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_PERCENT,rcfi_tclSemanticDomain::EN_MSG_QUALITY));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_RCALCPROCESSSTATUS,rcfi_tclSemanticDomain::EN_MSG_PROCESSSTATUS));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_MSG_JOBID));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_TRIPSEGMENTNUMBER));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_ROUTESTATUSSTATUS:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32,rcfi_tclSemanticDomain::EN_MSG_ROUTELIST));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_DATASETID,rcfi_tclSemanticDomain::EN_MSG_NAVDATASETID));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TRIPSEGMENTSTATUS,rcfi_tclSemanticDomain::EN_MSG_TRIPSEGMENTSTATUS));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_MSG_JOBID));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_MSG_TRIPSEGMENTNUMBER));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case rcfi_tclToken::EN_MSG_RDBACCESSIBILITYSTATUS:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_DATAACCESSIBILITY,rcfi_tclSemanticDomain::EN_MSG_DATAACCESSIBILITY));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_MSG_MEDIUMID));
   } break;
   case rcfi_tclToken::EN_MSG_RDBLOADERSTATUSSTATUS:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRATEGYSTATUS,rcfi_tclSemanticDomain::EN_MSG_STRATEGYSTATUS));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_DATASETID,rcfi_tclSemanticDomain::EN_MSG_NAVDATASETID));
   } break;
   case rcfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_MSG_MESSAGE));
   } break;
   case rcfi_tclToken::EN_MSG_USEDDATASETSTATUS:
   {
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_DATASETID,rcfi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_MEDIAID,rcfi_tclSemanticDomain::EN_MSG_MEDIAID));
   } break;
   case rcfi_tclToken::EN_BINCONTAINER:
   case rcfi_tclToken::EN_RESERVED:
   case rcfi_tclToken::EN_U8_PERCENT:
   case rcfi_tclToken::EN_U16_INDEXINREFERENCELIST:
   case rcfi_tclToken::EN_S32_KILOGRAM:
   case rcfi_tclToken::EN_S32_POUND:
   case rcfi_tclToken::EN_S32_METER:
   case rcfi_tclToken::EN_S32_YARDS:
   case rcfi_tclToken::EN_S32_CENTIMETER:
   case rcfi_tclToken::EN_S32_INCH:
   case rcfi_tclToken::EN_S32_MILLIMETER:
   case rcfi_tclToken::EN_S32_MICROLITER:
   case rcfi_tclToken::EN_S32_SECOND:
   case rcfi_tclToken::EN_S32_MILLISECOND:
   case rcfi_tclToken::EN_POSIXTIME:
   case rcfi_tclToken::EN_E8_DST_STATE:
   case rcfi_tclToken::EN_TIMEZONEELEMENT:
   case rcfi_tclToken::EN_S16_KMPERHOUR:
   case rcfi_tclToken::EN_S16_MILESPERHOUR:
   case rcfi_tclToken::EN_S16_CENTIMETERSECOND:
   case rcfi_tclToken::EN_S16_KELVIN:
   case rcfi_tclToken::EN_S16_FAHRENHEIT:
   case rcfi_tclToken::EN_S32_PASCAL:
   case rcfi_tclToken::EN_FIVERSION:
   case rcfi_tclToken::EN_S32_LONGITUDE:
   case rcfi_tclToken::EN_S32_LATITUDE:
   case rcfi_tclToken::EN_POSITIONWGS84:
   case rcfi_tclToken::EN_E16_ISOCOUNTRYCODE:
   case rcfi_tclToken::EN_U8_DIRECTIONABSOLUTE:
   case rcfi_tclToken::EN_U8_DIRECTIONRELATIVE:
   case rcfi_tclToken::EN_E8_FUELTYPE:
   case rcfi_tclToken::EN_DISTTIMEFUEL:
   case rcfi_tclToken::EN_E8_BINCONTAINERTYPES:
   case rcfi_tclToken::EN_E16_SELECTIONCRITERIONTYPE:
   case rcfi_tclToken::EN_STRINGID:
   case rcfi_tclToken::EN_STRINGPOSITION:
   case rcfi_tclToken::EN_E8_LOCATIONDESCRIPTIONDATATYPE:
   case rcfi_tclToken::EN_B8_LOCATIONDESCRIPTORSTATUS:
   case rcfi_tclToken::EN_LOCATIONDESCRIPTOR:
   case rcfi_tclToken::EN_LOCATIONDESCRIPTORUNION0:
   case rcfi_tclToken::EN_LOCATIONDESCRIPTION:
   case rcfi_tclToken::EN_FLISTRING:
   case rcfi_tclToken::EN_B8_POSITIONSTATUS:
   case rcfi_tclToken::EN_LISTOFPOSITIONS:
   case rcfi_tclToken::EN_E16_NAVIEVENTVALUE:
   case rcfi_tclToken::EN_E8_TRAFFICMSGTYPE:
   case rcfi_tclToken::EN_E8_TMLOCATIONTYPE:
   case rcfi_tclToken::EN_E8_EVENTTYPE:
   case rcfi_tclToken::EN_E16_EFFECTCODE:
   case rcfi_tclToken::EN_E16_CAUSECODE:
   case rcfi_tclToken::EN_E8_TENDENCY:
   case rcfi_tclToken::EN_RDBID:
   case rcfi_tclToken::EN_TMEVENT:
   case rcfi_tclToken::EN_B32_TRAFFICMESSAGESOURCE:
   case rcfi_tclToken::EN_E8_TMURGENCY:
   case rcfi_tclToken::EN_TMCODEDMESSAGE:
   case rcfi_tclToken::EN_TMCODEDMESSAGEBINCONTAINER:
   case rcfi_tclToken::EN_TMPROGRAMSERVICE:
   case rcfi_tclToken::EN_U32_DATASETID:
   case rcfi_tclToken::EN_U32_MEDIAID:
   case rcfi_tclToken::EN_NAVCLUSTERDESC:
   case rcfi_tclToken::EN_E8_NAVDATALEVEL:
   case rcfi_tclToken::EN_E8_NAVONECELLDIRECTION:
   case rcfi_tclToken::EN_NAVONECELLDESC:
   case rcfi_tclToken::EN_E8_SIDEINFO:
   case rcfi_tclToken::EN_S32_EMU:
   case rcfi_tclToken::EN_NAVZEROCELLDESC:
   case rcfi_tclToken::EN_NAVONECELL:
   case rcfi_tclToken::EN_E8_NAVONECELLCATEGORY:
   case rcfi_tclToken::EN_E8_SIGNPOSTDESTTYPE:
   case rcfi_tclToken::EN_E8_SIGNPOSTDESTINATIONCATEGORY:
   case rcfi_tclToken::EN_E8_SIGNPOSTDESTSTATUS:
   case rcfi_tclToken::EN_E8_DIRECTIONSTATUS:
   case rcfi_tclToken::EN_SIGNPOSTDESTDIRECTION:
   case rcfi_tclToken::EN_E8_DIRECTIONCATEGORY:
   case rcfi_tclToken::EN_B8_DIRECTIONINFOSTATUS:
   case rcfi_tclToken::EN_DIRECTIONCATEGORY:
   case rcfi_tclToken::EN_DIRECTIONCATEGORYUNION0:
   case rcfi_tclToken::EN_DIRECTIONINFO:
   case rcfi_tclToken::EN_SIGNPOSTDESTINATION:
   case rcfi_tclToken::EN_SIGNPOSTDESTINATIONUNION0:
   case rcfi_tclToken::EN_REFERENCEELEMENT:
   case rcfi_tclToken::EN_DIRECTIONINFOLISTSET:
   case rcfi_tclToken::EN_B16_POSITIONRELIABILITY:
   case rcfi_tclToken::EN_POSITIONHEADINGSPEED:
   case rcfi_tclToken::EN_E8_SHAPETYPE:
   case rcfi_tclToken::EN_SHAPE:
   case rcfi_tclToken::EN_TMSERVICEPROVIDER:
   case rcfi_tclToken::EN_E8_TMCATEGORY:
   case rcfi_tclToken::EN_E8_TMFLOWIMPACT:
   case rcfi_tclToken::EN_B8_TMMAPPINGPOSSIBILITY:
   case rcfi_tclToken::EN_B8_TMMAPPINGSTATUS:
   case rcfi_tclToken::EN_E8_TMAFFECTIONTYPE:
   case rcfi_tclToken::EN_B8_TMONECELLATTRIBUTE:
   case rcfi_tclToken::EN_TMONECELLPORTION:
   case rcfi_tclToken::EN_E8_TMVALUESTATUS:
   case rcfi_tclToken::EN_E8_TMCINTERSECTIONPATHTYPE:
   case rcfi_tclToken::EN_E8_TMGEOMETRICMESSAGETYPE:
   case rcfi_tclToken::EN_E8_TMGEOGRAPHICALPATHRELATIONTYPE:
   case rcfi_tclToken::EN_B8_TMRELEVANCE:
   case rcfi_tclToken::EN_TMCSTRUCTUREDTEXT:
   case rcfi_tclToken::EN_B8_ROADNUMBERSTATUS:
   case rcfi_tclToken::EN_COMPASSDIRECTION:
   case rcfi_tclToken::EN_E8_INFOSTATUS:
   case rcfi_tclToken::EN_INFOSTATUS:
   case rcfi_tclToken::EN_SIGNPOSTELEMENT:
   case rcfi_tclToken::EN_SIGNPOSTELEMENTUNION0:
   case rcfi_tclToken::EN_REFERENCEELEMENTWITHID:
   case rcfi_tclToken::EN_STATENAMEELEMENT:
   case rcfi_tclToken::EN_COUNTYNAMEELEMENT:
   case rcfi_tclToken::EN_CITYDISTRICTNAMEELEMENT:
   case rcfi_tclToken::EN_BUILDUPAREANAMEELEMENT:
   case rcfi_tclToken::EN_ROADNUMBER:
   case rcfi_tclToken::EN_REQUIREDTAXDISC:
   case rcfi_tclToken::EN_E8_REQUIREDPERMISSIONTYPE:
   case rcfi_tclToken::EN_E8_REQUIREDPERMISSION:
   case rcfi_tclToken::EN_GENERICREQUIREDPERMISSION:
   case rcfi_tclToken::EN_REQUIREDPERMISSION:
   case rcfi_tclToken::EN_REQUIREDPERMISSIONUNION0:
   case rcfi_tclToken::EN_COUNTRYNAMEELEMENT:
   case rcfi_tclToken::EN_STATENAMELISTSET:
   case rcfi_tclToken::EN_COUNTYNAMELISTSET:
   case rcfi_tclToken::EN_CITYNAMEELEMENT:
   case rcfi_tclToken::EN_INDEXINREFERENCELIST:
   case rcfi_tclToken::EN_BUILDUPAREANAMELISTSET:
   case rcfi_tclToken::EN_ROADNAMELISTSET:
   case rcfi_tclToken::EN_ROADNUMBERLISTSET:
   case rcfi_tclToken::EN_REQUIREDPERMISSIONLISTSET:
   case rcfi_tclToken::EN_E8_INTERSECTIONTYPE:
   case rcfi_tclToken::EN_TIMEZONELISTSET:
   case rcfi_tclToken::EN_INTERSECTIONNAMEELEMENT:
   case rcfi_tclToken::EN_ROADNAMEELEMENT:
   case rcfi_tclToken::EN_INTERSECTIONNUMBERELEMENT:
   case rcfi_tclToken::EN_COUNTRYNAMELISTSET:
   case rcfi_tclToken::EN_CITYNAMELISTSET:
   case rcfi_tclToken::EN_SIGNPOSTLISTSET:
   case rcfi_tclToken::EN_E8_ROADCLASSCODE:
   case rcfi_tclToken::EN_U16_USERTRAFFICMESSAGEHANDLE:
   case rcfi_tclToken::EN_TMCOMBINATION:
   case rcfi_tclToken::EN_B32_ROADPROPERTY:
   case rcfi_tclToken::EN_E8_NAVSTREETTYPE:
   case rcfi_tclToken::EN_E8_ROADNETWORKCLASS:
   case rcfi_tclToken::EN_ROADATTRIBUTES:
   case rcfi_tclToken::EN_E8_EXTRADESCELEMENTTYPE:
   case rcfi_tclToken::EN_EXTRADESCELEMENT:
   case rcfi_tclToken::EN_EXTRADESCLISTSET:
   case rcfi_tclToken::EN_B32_DATAPROPERTIES:
   case rcfi_tclToken::EN_DATADESCELEMENT:
   case rcfi_tclToken::EN_DATADESCLISTSET:
   case rcfi_tclToken::EN_B8_CROSSROADPROPERTIES:
   case rcfi_tclToken::EN_CROSSROADDESC:
   case rcfi_tclToken::EN_E8_CROSSROADINFOCATEGORY:
   case rcfi_tclToken::EN_CROSSROADINFO:
   case rcfi_tclToken::EN_CROSSROADINFOUNION0:
   case rcfi_tclToken::EN_INTERSECTIONDENOTATION:
   case rcfi_tclToken::EN_INTERSECTIONDESCELEMENT:
   case rcfi_tclToken::EN_INTERSECTIONLISTSET:
   case rcfi_tclToken::EN_E8_BASETRAFFICSIGNCATEGORY:
   case rcfi_tclToken::EN_E8_SPEEDSIGN:
   case rcfi_tclToken::EN_E16_WARNINGSIGN:
   case rcfi_tclToken::EN_E16_REGULATORYSIGN:
   case rcfi_tclToken::EN_E16_ADDITIONALTRAFFICSIGN:
   case rcfi_tclToken::EN_TIMEDEPENDENTSTRING:
   case rcfi_tclToken::EN_B8_LANEDEPENDENTVALIDITY:
   case rcfi_tclToken::EN_E8_TRAFFICSIGNQUANTIFIER:
   case rcfi_tclToken::EN_ADDITIONALTRAFFICSIGN:
   case rcfi_tclToken::EN_ADDITIONALTRAFFICSIGNUNION0:
   case rcfi_tclToken::EN_TRAFFICSIGNELEMENT:
   case rcfi_tclToken::EN_TRAFFICSIGNELEMENTUNION0:
   case rcfi_tclToken::EN_TRAFFICSIGNELEMENTUNION1:
   case rcfi_tclToken::EN_ROADINFOCOMBINATION:
   case rcfi_tclToken::EN_TRAFFICSIGNLISTSET:
   case rcfi_tclToken::EN_B32_POICATEGORY:
   case rcfi_tclToken::EN_POIELEMENT:
   case rcfi_tclToken::EN_POILISTSET:
   case rcfi_tclToken::EN_B8_INSTRUCTIONSTATUS:
   case rcfi_tclToken::EN_SIMPLEINSTRUCTION:
   case rcfi_tclToken::EN_SIMPLEINSTRUCTIONLISTSET:
   case rcfi_tclToken::EN_SECTIONCHARACTERISTICS:
   case rcfi_tclToken::EN_E8_MANOEUVRECRITICALITY:
   case rcfi_tclToken::EN_B8_ROUTEPROPERTIES:
   case rcfi_tclToken::EN_MOSTWORSEMANOEUVREINFO:
   case rcfi_tclToken::EN_CRITICALDECISIONPOINTLISTELEMENT:
   case rcfi_tclToken::EN_CRITICALDECISIONPOINTLISTSET:
   case rcfi_tclToken::EN_TOLLBOOTHELEMENT:
   case rcfi_tclToken::EN_TOLLBOOTHLISTSET:
   case rcfi_tclToken::EN_CITYDISTRICTNAMELISTSET:
   case rcfi_tclToken::EN_POINTOFINTERESTELEMENT:
   case rcfi_tclToken::EN_UNSPECIFIEDTEXT:
   case rcfi_tclToken::EN_U16_TRIPHANDLE:
   case rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER:
   case rcfi_tclToken::EN_U16_ROUTEHANDLE:
   case rcfi_tclToken::EN_B8_ROUTESEGMENTCLTYPES:
   case rcfi_tclToken::EN_ROUTESEGMENTCL:
   case rcfi_tclToken::EN_ROUTESEGMENTCLUNION0:
   case rcfi_tclToken::EN_LOCATIONBRANCHCL:
   case rcfi_tclToken::EN_DESTINATIONBRANCHCL:
   case rcfi_tclToken::EN_DESTINATIONCL:
   case rcfi_tclToken::EN_S32_MEMU:
   case rcfi_tclToken::EN_S16_EAU:
   case rcfi_tclToken::EN_NAVPOSONECELLPROPERTY:
   case rcfi_tclToken::EN_NAVPOSONECELLSECTIONDESCRIPTION:
   case rcfi_tclToken::EN_E8_ENTRYPOINTSTATE:
   case rcfi_tclToken::EN_U32_RESISTANCE:
   case rcfi_tclToken::EN_ENTRYPOINT:
   case rcfi_tclToken::EN_POSITIONDESCRIPTION:
   case rcfi_tclToken::EN_E8_NAVLOCATIONDESCTYPE:
   case rcfi_tclToken::EN_NAVLOCATIONDESC:
   case rcfi_tclToken::EN_NAVLOCATIONDESCUNION0:
   case rcfi_tclToken::EN_NAVLOCATIONBINCONTAINER:
   case rcfi_tclToken::EN_E8_NAVINDEXZFDESTINATIONTYPE:
   case rcfi_tclToken::EN_E8_NAVLOCATIONNAVDATATYPE:
   case rcfi_tclToken::EN_NAVLOCATIONDATADESC:
   case rcfi_tclToken::EN_NAVLOCATIONDATADESCUNION0:
   case rcfi_tclToken::EN_NAVSPOTDESTINATIONONECELLPROPERTY:
   case rcfi_tclToken::EN_NAVSPOTDESTINATIONONECELLDESC:
   case rcfi_tclToken::EN_NAVSPOTDESTINATIONONECELLLISTSET:
   case rcfi_tclToken::EN_NAVSTREETDESTINATIONONECELLPROPERTY:
   case rcfi_tclToken::EN_NAVSTREETDESTINATIONONECELLDESC:
   case rcfi_tclToken::EN_NAVSTREETDESTINATIONONECELLLISTSET:
   case rcfi_tclToken::EN_E8_NAVINTERSECTIONTYPE:
   case rcfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLPROPERTY:
   case rcfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLDESC:
   case rcfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
   case rcfi_tclToken::EN_NAVAREADESCRIPTIONCIRCLE:
   case rcfi_tclToken::EN_NAVAREADESCRIPTIONPOLYGON:
   case rcfi_tclToken::EN_NAVDLDCHAINONECELLPROPERTY:
   case rcfi_tclToken::EN_NAVDLDCHAINONECELLDESC:
   case rcfi_tclToken::EN_NAVDLDCHAINONECELLLISTSET:
   case rcfi_tclToken::EN_NAVUTMBINCONTAINER:
   case rcfi_tclToken::EN_COUNTRYINFO:
   case rcfi_tclToken::EN_NAVROUTEID:
   case rcfi_tclToken::EN_B32_NAVROUTESTATUS:
   case rcfi_tclToken::EN_B32_EXTNAVROUTESTATUS:
   case rcfi_tclToken::EN_NAVROUTEINFO:
   case rcfi_tclToken::EN_NAVROUTECOMPARE:
   case rcfi_tclToken::EN_NAVROUTEINSTRUCTIONDESC:
   case rcfi_tclToken::EN_NAVROUTEDESTINATIONDESC:
   case rcfi_tclToken::EN_B32_NAVROUTEONECELLSTATUS:
   case rcfi_tclToken::EN_B32_EXTNAVROUTEONECELLSTATUS:
   case rcfi_tclToken::EN_NAVROUTEONECELLPROPERTIES:
   case rcfi_tclToken::EN_NAVROUTEONECELLDESC:
   case rcfi_tclToken::EN_NAVROUTELISTSET:
   case rcfi_tclToken::EN_NAVROUTELISTBINCONTAINER:
   case rcfi_tclToken::EN_TMINFO:
   case rcfi_tclToken::EN_TMINFOLISTSET:
   case rcfi_tclToken::EN_E8_LANESTATUS:
   case rcfi_tclToken::EN_B8_LANETYPE:
   case rcfi_tclToken::EN_B8_LANECHANGERESTRICTION:
   case rcfi_tclToken::EN_U8_INDEXINLANEINFOSEGMENTLIST:
   case rcfi_tclToken::EN_U8_INDEXINLANEINFOLIST:
   case rcfi_tclToken::EN_U8_DRIVINGDIRECTION:
   case rcfi_tclToken::EN_LANEDIRECTION:
   case rcfi_tclToken::EN_LANEINFOONECELLREFERENCE:
   case rcfi_tclToken::EN_LANEINFOONECELLINDEXREFERENCE:
   case rcfi_tclToken::EN_LANEINFOPATHSECTIONINDEXREFERENCE:
   case rcfi_tclToken::EN_LANEINFOELEMENTREFERENCE:
   case rcfi_tclToken::EN_E8_LANEREFERENCECATEGORY:
   case rcfi_tclToken::EN_LANEREFERENCE:
   case rcfi_tclToken::EN_LANEREFERENCEUNION0:
   case rcfi_tclToken::EN_LANEINFO:
   case rcfi_tclToken::EN_LANEINFOSEGMENT:
   case rcfi_tclToken::EN_LANEINFOSEGMENTLIST:
   case rcfi_tclToken::EN_LANEINFOLISTSET:
   case rcfi_tclToken::EN_E8_ENTRYEXITTYPE:
   case rcfi_tclToken::EN_ENTRYEXITCOORDINATES:
   case rcfi_tclToken::EN_ENTRYEXITPOINTLISTSET:
   case rcfi_tclToken::EN_WGS84COORDINATELIST:
   case rcfi_tclToken::EN_SHAPEPOINTLISTSET:
   case rcfi_tclToken::EN_E8_DEPICTIONAREA:
   case rcfi_tclToken::EN_DEPICTIONAREA:
   case rcfi_tclToken::EN_DEPICTIONAREAUNION0:
   case rcfi_tclToken::EN_DEPICTCOMPLETE:
   case rcfi_tclToken::EN_DEPICTLENGTH:
   case rcfi_tclToken::EN_DEPICTPOLYGON:
   case rcfi_tclToken::EN_E8_DEPICTIONQUANTITYSTATE:
   case rcfi_tclToken::EN_DEPICTIONQUANTITYSTATE:
   case rcfi_tclToken::EN_DEPICTIONQUANTITYSTATEUNION0:
   case rcfi_tclToken::EN_DEPICTEDCOMPLETE:
   case rcfi_tclToken::EN_DEPICTEDPARTLENGTH:
   case rcfi_tclToken::EN_DEPICTEDPARTPOLYGON:
   case rcfi_tclToken::EN_B8_DEPICTIONMODESETTINGS:
   case rcfi_tclToken::EN_DEPICTIONMODESETTINGS:
   case rcfi_tclToken::EN_DEPICTIONMODESETTINGSUNION0:
   case rcfi_tclToken::EN_E8_DEPICTIONDIRECTIONMODE:
   case rcfi_tclToken::EN_B8_DEPICTIONRESULT:
   case rcfi_tclToken::EN_CNTDEPICTRESULTELEM:
   case rcfi_tclToken::EN_PATHLISTTODEPICT:
   case rcfi_tclToken::EN_PATHDATALISTSETTODEPICT:
   case rcfi_tclToken::EN_NAVDLDONECELLPROPERTY:
   case rcfi_tclToken::EN_NAVDLDONECELLDESC:
   case rcfi_tclToken::EN_NAVDLDEPICTEDPSONECELLLIST:
   case rcfi_tclToken::EN_DEPICTEDNAVDATALEVELLISTSET:
   case rcfi_tclToken::EN_DEPICTEDDATAPATHLISTSET:
   case rcfi_tclToken::EN_U32_SQUAREDECIMETER:
   case rcfi_tclToken::EN_U32_MILLILITER:
   case rcfi_tclToken::EN_U32_MICROLITER:
   case rcfi_tclToken::EN_E8_ROUTECAPABILITYID:
   case rcfi_tclToken::EN_ROUTECAPABILITY:
   case rcfi_tclToken::EN_E8_ROUTEOPTION:
   case rcfi_tclToken::EN_TRIPSEGMENT:
   case rcfi_tclToken::EN_B8_ADDTRIPSEGMENTPARAMETERS:
   case rcfi_tclToken::EN_E8_DYNAMICROUTECALCMODE:
   case rcfi_tclToken::EN_CURRENTROUTEOPTION:
   case rcfi_tclToken::EN_AVAILABLEPERMISSION:
   case rcfi_tclToken::EN_AVAILABLEPERMISSIONUNION0:
   case rcfi_tclToken::EN_E8_CALCULATIONCAUSE:
   case rcfi_tclToken::EN_E8_CALCULATIONMODE:
   case rcfi_tclToken::EN_CALCULATIONMODE:
   case rcfi_tclToken::EN_ACTIVEMANIPSOURCESOFSEGMENT:
   case rcfi_tclToken::EN_ACTIVEMANIPSOURCESOFROUTE:
   case rcfi_tclToken::EN_TRAFFICMESSAGESTATUS:
   case rcfi_tclToken::EN_E8_SEGMENTSKIPPINGMODE:
   case rcfi_tclToken::EN_USERPERMISSIONPROFILE:
   case rcfi_tclToken::EN_B8_DYNAMISATIONCAUSE:
   case rcfi_tclToken::EN_ROUTEINFOELEMENTVALUES:
   case rcfi_tclToken::EN_B32_ROADINFOPROPERTIES:
   case rcfi_tclToken::EN_ROUTEINFOELEMENTSTATUS:
   case rcfi_tclToken::EN_FIRSTELEMENT:
   case rcfi_tclToken::EN_ENTRYPOINTINFO:
   case rcfi_tclToken::EN_E8_ROUTEINFOCATEGORY:
   case rcfi_tclToken::EN_ROUTEINFOELEMENT:
   case rcfi_tclToken::EN_ROUTEINFOCATEGORY:
   case rcfi_tclToken::EN_ROUTEINFOCATEGORYUNION0:
   case rcfi_tclToken::EN_ROUTEINFOCATEGORYSTATUS:
   case rcfi_tclToken::EN_SINGLEROUTEINFOSTATUS:
   case rcfi_tclToken::EN_UTMGROUPNUMBERONLENGTHLIST:
   case rcfi_tclToken::EN_UTMGROUPNUMBERONNAMELIST:
   case rcfi_tclToken::EN_DESTINATION:
   case rcfi_tclToken::EN_DESTINATIONLISTSET:
   case rcfi_tclToken::EN_STATE:
   case rcfi_tclToken::EN_E8_TIMEZONE:
   case rcfi_tclToken::EN_TABULARWEATHERLOCATION:
   case rcfi_tclToken::EN_OFFROADELEMENTINFO:
   case rcfi_tclToken::EN_DISTANCETIMEINFO:
   case rcfi_tclToken::EN_ROUTEDISTANCETIMEINFO:
   case rcfi_tclToken::EN_E32_ROUTECALCULATIONERRORINFO:
   case rcfi_tclToken::EN_AVAILABLEROUTEOPTION:
   case rcfi_tclToken::EN_ROUTESEGMENTDEFINITION:
   case rcfi_tclToken::EN_E8_TRIPSEGMENTSTATUS:
   case rcfi_tclToken::EN_TRIPSEGMENTSTATUS:
   case rcfi_tclToken::EN_ROUTESTATUS:
   case rcfi_tclToken::EN_B8_ROUTEDIFFERENCESTATUS:
   case rcfi_tclToken::EN_B8_TRAVELVALUEVALIDITY:
   case rcfi_tclToken::EN_E8_ROUTEBRANCHINGTYPE:
   case rcfi_tclToken::EN_ROUTEBRANCHINGCOORDINATE:
   case rcfi_tclToken::EN_ROUTEVALUESCHANGE:
   case rcfi_tclToken::EN_E8_PROFILETYPE:
   case rcfi_tclToken::EN_E8_NAVAREATYPE:
   case rcfi_tclToken::EN_E8_VEHICLETYPE:
   case rcfi_tclToken::EN_SPEEDVECTOR:
   case rcfi_tclToken::EN_VEHICLESPEEDPROFILE:
   case rcfi_tclToken::EN_B8_CARGOINFO:
   case rcfi_tclToken::EN_VEHICLEPROFILE:
   case rcfi_tclToken::EN_USERSPEEDPROFILE:
   case rcfi_tclToken::EN_FUELCONSUMPTIONPROFILE:
   case rcfi_tclToken::EN_B8_THRESHOLDDEFINITIONPROFILE:
   case rcfi_tclToken::EN_THRESHOLDDEFINITIONPROFILE:
   case rcfi_tclToken::EN_ROUTEHANDLEDESCRIPTION:
   case rcfi_tclToken::EN_ROUTEDEFINITION:
   case rcfi_tclToken::EN_B8_SPEEDPROFILES:
   case rcfi_tclToken::EN_B8_USERPROFILES:
   case rcfi_tclToken::EN_SPEEDPROFILES:
   case rcfi_tclToken::EN_SPEEDPROFILESUNION0:
   case rcfi_tclToken::EN_E8_VEHICLECLASS:
   case rcfi_tclToken::EN_E8_GEARBOX:
   case rcfi_tclToken::EN_E8_DRIVEMODE:
   case rcfi_tclToken::EN_VEHICLEPARAMETER:
   case rcfi_tclToken::EN_E8_DRIVERTYPE:
   case rcfi_tclToken::EN_DRIVERPARAMETER:
   case rcfi_tclToken::EN_GREENPROFILE:
   case rcfi_tclToken::EN_USERPROFILES:
   case rcfi_tclToken::EN_USERPROFILESUNION0:
   case rcfi_tclToken::EN_E8_MAPDESTINATIONTYPE:
   case rcfi_tclToken::EN_MAPDESTINATION:
   case rcfi_tclToken::EN_MAPONECELLDESC:
   case rcfi_tclToken::EN_MAPROUTEBINCONTAINER:
   case rcfi_tclToken::EN_TIMEDURATION:
   case rcfi_tclToken::EN_E8_TIMEDEPENDENTCLOSURETYPE:
   case rcfi_tclToken::EN_TIMEDEPENDENTCLOSURE:
   case rcfi_tclToken::EN_TIMEDEPENDENTCLOSURELISTSET:
   case rcfi_tclToken::EN_E8_RCALCPROCESSSTATUS:
   case rcfi_tclToken::EN_B32_CALCULATIONPROPERTIES:
   case rcfi_tclToken::EN_NAVROUTECALCPROPERTY:
   case rcfi_tclToken::EN_GLUEAREADESC:
   case rcfi_tclToken::EN_E8_DATAACCESSIBILITY:
   case rcfi_tclToken::EN_E8_NAVRCALCROUTESTARTPOINT:
   case rcfi_tclToken::EN_NAVRCALCROUTESTARTPOINTUNIONTYPE:
   case rcfi_tclToken::EN_NAVRCALCROUTESTARTPOINTUNIONTYPEUNION0:
   case rcfi_tclToken::EN_NAVRCALCPOSITIONDESC:
   case rcfi_tclToken::EN_NAVRCALCCARPOSITION:
   case rcfi_tclToken::EN_NAVSUBDESTINATIONLIST:
   case rcfi_tclToken::EN_E8_LOADSTRATEGY:
   case rcfi_tclToken::EN_LOADSTRATEGY:
   case rcfi_tclToken::EN_E8_STRATEGYSTATUS:
   case rcfi_tclToken::EN_STRATEGYSTATUS:
   case rcfi_tclToken::EN_EVALUATEDPOSITION:
   case rcfi_tclToken::EN_E8_WEATHERID:
   case rcfi_tclToken::EN_E8_TABULARWEATHERID:
   case rcfi_tclToken::EN_CODEDCITY:
   case rcfi_tclToken::EN_METARSTATION:
   case rcfi_tclToken::EN_WEATHERCONDITION:
   case rcfi_tclToken::EN_VISIBILITY:
   case rcfi_tclToken::EN_CURRENTWEATHER:
   case rcfi_tclToken::EN_WEATHERFORPOSITION:
   case rcfi_tclToken::EN_CURRENTWEATHERLISTSET:
   case rcfi_tclToken::EN_WEATHERFORECAST:
   case rcfi_tclToken::EN_WEATHERFORECASTFORPOSITION:
   case rcfi_tclToken::EN_WEATHERFORECASTLISTSET:
   case rcfi_tclToken::EN_E8_FORECASTTYPE:
   case rcfi_tclToken::EN_E8_PRECIPITATIONTYPE:
   case rcfi_tclToken::EN_E8_CLOUDCOVERAGETYPE:
   case rcfi_tclToken::EN_TABULARWEATHERCONDITION:
   case rcfi_tclToken::EN_PRECIPITATION:
   case rcfi_tclToken::EN_HUMIDITY:
   case rcfi_tclToken::EN_CLOUDCOVERAGE:
   case rcfi_tclToken::EN_UVLEVEL:
   case rcfi_tclToken::EN_POLLENLEVEL:
   case rcfi_tclToken::EN_TABULARWEATHERPERFORECAST:
   case rcfi_tclToken::EN_TABULARWEATHER:
   case rcfi_tclToken::EN_TABULARWEATHERFORPOSITION:
   case rcfi_tclToken::EN_TABULARWEATHERLISTSET:
   case rcfi_tclToken::EN_U8:   
   case rcfi_tclToken::EN_S8:   
   case rcfi_tclToken::EN_U16:   
   case rcfi_tclToken::EN_S16:   
   case rcfi_tclToken::EN_U24:   
   case rcfi_tclToken::EN_S24:   
   case rcfi_tclToken::EN_U32:   
   case rcfi_tclToken::EN_S32:   
   case rcfi_tclToken::EN_U64:   
   case rcfi_tclToken::EN_S64:   
   case rcfi_tclToken::EN_F32:   
   case rcfi_tclToken::EN_F64:   
   case rcfi_tclToken::EN_BOOL:   
   case rcfi_tclToken::EN_STRING:   
   case rcfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(rcfi_tclKnot(enMsgToken,rcfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool rcfi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool rcfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      rcfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      rcfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      rcfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == rcfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(rcfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(rcfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(rcfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case rcfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == rcfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case rcfi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            rcfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(rcfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            rcfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(rcfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case rcfi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case rcfi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rcfi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rcfi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rcfi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rcfi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rcfi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rcfi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rcfi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rcfi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rcfi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rcfi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rcfi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rcfi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case rcfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case rcfi_tclToken::EN_MSG_GETROUTECAPABILITIESMETHODSTART:
   case rcfi_tclToken::EN_MSG_GETROUTECAPABILITIESMETHODRESULT:
   case rcfi_tclToken::EN_MSG_GETROUTECALCOPTIONSMETHODSTART:
   case rcfi_tclToken::EN_MSG_GETROUTECALCOPTIONSMETHODRESULT:
   case rcfi_tclToken::EN_MSG_CHECKPROFILEVALIDITYMETHODSTART:
   case rcfi_tclToken::EN_MSG_CHECKPROFILEVALIDITYMETHODRESULT:
   case rcfi_tclToken::EN_MSG_GETSTANDARDSPEEDHISTOGRAMMETHODSTART:
   case rcfi_tclToken::EN_MSG_GETSTANDARDSPEEDHISTOGRAMMETHODRESULT:
   case rcfi_tclToken::EN_MSG_GETDEFAULTVEHICLEPARAMETERMETHODSTART:
   case rcfi_tclToken::EN_MSG_GETDEFAULTVEHICLEPARAMETERMETHODRESULT:
   case rcfi_tclToken::EN_MSG_SETTRAVELADVANTAGETHRESHOLDSMETHODSTART:
   case rcfi_tclToken::EN_MSG_SETTRAVELADVANTAGETHRESHOLDSMETHODRESULT:
   case rcfi_tclToken::EN_MSG_SETTHRESHOLDDEFINITIONPROFILEMETHODSTART:
   case rcfi_tclToken::EN_MSG_SETTHRESHOLDDEFINITIONPROFILEMETHODRESULT:
   case rcfi_tclToken::EN_MSG_CREATETRIPMETHODSTART:
   case rcfi_tclToken::EN_MSG_CREATETRIPMETHODRESULT:
   case rcfi_tclToken::EN_MSG_GETTRIPMETHODSTART:
   case rcfi_tclToken::EN_MSG_GETTRIPMETHODRESULT:
   case rcfi_tclToken::EN_MSG_KILLTRIPMETHODSTART:
   case rcfi_tclToken::EN_MSG_KILLTRIPMETHODRESULT:
   case rcfi_tclToken::EN_MSG_GETEXISTINGTRIPHANDLESMETHODSTART:
   case rcfi_tclToken::EN_MSG_GETEXISTINGTRIPHANDLESMETHODRESULT:
   case rcfi_tclToken::EN_MSG_ADDTRIPSEGMENTTOTRIPMETHODSTART:
   case rcfi_tclToken::EN_MSG_ADDTRIPSEGMENTTOTRIPMETHODRESULT:
   case rcfi_tclToken::EN_MSG_STARTROUTECALCULATIONMETHODSTART:
   case rcfi_tclToken::EN_MSG_STARTROUTECALCULATIONMETHODRESULT:
   case rcfi_tclToken::EN_MSG_STOPROUTECALCULATIONMETHODSTART:
   case rcfi_tclToken::EN_MSG_STOPROUTECALCULATIONMETHODRESULT:
   case rcfi_tclToken::EN_MSG_SETTRACKEDSEGMENTMETHODSTART:
   case rcfi_tclToken::EN_MSG_SETTRACKEDSEGMENTMETHODRESULT:
   case rcfi_tclToken::EN_MSG_CHANGEDYNAMICROUTECALCMODEMETHODSTART:
   case rcfi_tclToken::EN_MSG_CHANGEDYNAMICROUTECALCMODEMETHODRESULT:
   case rcfi_tclToken::EN_MSG_SELECTTRAFFICSCENARIOMETHODSTART:
   case rcfi_tclToken::EN_MSG_SELECTTRAFFICSCENARIOMETHODRESULT:
   case rcfi_tclToken::EN_MSG_SETCALCULATIONMODEMETHODSTART:
   case rcfi_tclToken::EN_MSG_SETCALCULATIONMODEMETHODRESULT:
   case rcfi_tclToken::EN_MSG_GETCALCULATIONMODEMETHODSTART:
   case rcfi_tclToken::EN_MSG_GETCALCULATIONMODEMETHODRESULT:
   case rcfi_tclToken::EN_MSG_GETAVAILABLEROUTEINFOMETHODSTART:
   case rcfi_tclToken::EN_MSG_GETAVAILABLEROUTEINFOMETHODRESULT:
   case rcfi_tclToken::EN_MSG_GETROUTEINFOMETHODSTART:
   case rcfi_tclToken::EN_MSG_GETROUTEINFOMETHODRESULT:
   case rcfi_tclToken::EN_MSG_GETNAVROUTELISTDEPICTIONMETHODSTART:
   case rcfi_tclToken::EN_MSG_GETNAVROUTELISTDEPICTIONMETHODRESULT:
   case rcfi_tclToken::EN_MSG_GETCLUSTERLISTSMETHODSTART:
   case rcfi_tclToken::EN_MSG_GETCLUSTERLISTSMETHODRESULT:
   case rcfi_tclToken::EN_MSG_EVALUATEPOSITIONSMETHODSTART:
   case rcfi_tclToken::EN_MSG_EVALUATEPOSITIONSMETHODRESULT:
   case rcfi_tclToken::EN_MSG_VERIFYNEWTRAFFICMESSAGESMETHODSTART:
   case rcfi_tclToken::EN_MSG_VERIFYNEWTRAFFICMESSAGESMETHODRESULT:
   case rcfi_tclToken::EN_MSG_ACTIVATEROUTECALCULATIONMETHODSTART:
   case rcfi_tclToken::EN_MSG_ACTIVATEROUTECALCULATIONMETHODRESULT:
   case rcfi_tclToken::EN_MSG_DEACTIVATEROUTECALCULATIONMETHODSTART:
   case rcfi_tclToken::EN_MSG_DEACTIVATEROUTECALCULATIONMETHODRESULT:
   case rcfi_tclToken::EN_MSG_SETPOSITIONANDUPDATEROUTEMETHODSTART:
   case rcfi_tclToken::EN_MSG_SETPOSITIONANDUPDATEROUTEMETHODRESULT:
   case rcfi_tclToken::EN_MSG_SETCRITERIONANDUPDATEROUTEMETHODSTART:
   case rcfi_tclToken::EN_MSG_SETCRITERIONANDUPDATEROUTEMETHODRESULT:
   case rcfi_tclToken::EN_MSG_SETTRAFFICMESSAGESANDUPDATEROUTEMETHODSTART:
   case rcfi_tclToken::EN_MSG_SETTRAFFICMESSAGESANDUPDATEROUTEMETHODRESULT:
   case rcfi_tclToken::EN_MSG_COPYCALCULATIONJOBMETHODSTART:
   case rcfi_tclToken::EN_MSG_COPYCALCULATIONJOBMETHODRESULT:
   case rcfi_tclToken::EN_MSG_SETCALCULATIONJOBANDACTIVATEROUTEMETHODSTART:
   case rcfi_tclToken::EN_MSG_SETCALCULATIONJOBANDACTIVATEROUTEMETHODRESULT:
   case rcfi_tclToken::EN_MSG_GETGLUEAREADESCRIPTIONMETHODSTART:
   case rcfi_tclToken::EN_MSG_GETGLUEAREADESCRIPTIONMETHODRESULT:
   case rcfi_tclToken::EN_MSG_SETENTRYPOINTSANDUPDATEROUTEMETHODSTART:
   case rcfi_tclToken::EN_MSG_SETENTRYPOINTSANDUPDATEROUTEMETHODRESULT:
   case rcfi_tclToken::EN_MSG_SWITCHMISSIONMETHODSTART:
   case rcfi_tclToken::EN_MSG_SWITCHMISSIONMETHODRESULT:
   case rcfi_tclToken::EN_MSG_UPDATEROUTEINFOMETHODSTART:
   case rcfi_tclToken::EN_MSG_UPDATEROUTEINFOMETHODRESULT:
   case rcfi_tclToken::EN_MSG_DEPICTNAVDATALISTMETHODSTART:
   case rcfi_tclToken::EN_MSG_DEPICTNAVDATALISTMETHODRESULT:
   case rcfi_tclToken::EN_MSG_STARTLOADINGMETHODSTART:
   case rcfi_tclToken::EN_MSG_STARTLOADINGMETHODRESULT:
   case rcfi_tclToken::EN_MSG_STOPLOADINGMETHODSTART:
   case rcfi_tclToken::EN_MSG_STOPLOADINGMETHODRESULT:
   case rcfi_tclToken::EN_MSG_UPDATEPOSITIONMETHODSTART:
   case rcfi_tclToken::EN_MSG_UPDATEPOSITIONMETHODRESULT:
   case rcfi_tclToken::EN_MSG_TRIPSTATUSGET:
   case rcfi_tclToken::EN_MSG_TRIPSTATUSSTATUS:
   case rcfi_tclToken::EN_MSG_ROUTEINFOSTATUSGET:
   case rcfi_tclToken::EN_MSG_ROUTEINFOSTATUSSTATUS:
   case rcfi_tclToken::EN_MSG_DISTANCETIMEINFOGET:
   case rcfi_tclToken::EN_MSG_DISTANCETIMEINFOSTATUS:
   case rcfi_tclToken::EN_MSG_TRAVELVALUESCHANGEUPREG:
   case rcfi_tclToken::EN_MSG_TRAVELVALUESCHANGESTATUS:
   case rcfi_tclToken::EN_MSG_ROUTECALCULATIONSTATUSGET:
   case rcfi_tclToken::EN_MSG_ROUTECALCULATIONSTATUSSTATUS:
   case rcfi_tclToken::EN_MSG_ROUTESTATUSGET:
   case rcfi_tclToken::EN_MSG_ROUTESTATUSSTATUS:
   case rcfi_tclToken::EN_MSG_RDBACCESSIBILITYGET:
   case rcfi_tclToken::EN_MSG_RDBACCESSIBILITYSTATUS:
   case rcfi_tclToken::EN_MSG_RDBLOADERSTATUSGET:
   case rcfi_tclToken::EN_MSG_RDBLOADERSTATUSSTATUS:
   case rcfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
   case rcfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
   case rcfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
   case rcfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
   case rcfi_tclToken::EN_MSG_USEDDATASETGET:
   case rcfi_tclToken::EN_MSG_USEDDATASETUPREG:
   case rcfi_tclToken::EN_MSG_USEDDATASETRELUPREG:
   case rcfi_tclToken::EN_MSG_USEDDATASETSTATUS:
      bInitMessage(enToken);
      break;
   case rcfi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_RESERVED:
   {
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_U8_PERCENT:
   {
      fi_tcl_u8_Percent o_u8_Percent;
      if (!bDoIt(o_u8_Percent))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_U16_INDEXINREFERENCELIST:
   {
      fi_tcl_u16_IndexInReferenceList o_u16_IndexInReferenceList;
      if (!bDoIt(o_u16_IndexInReferenceList))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_S32_KILOGRAM:
   {
      fi_tcl_s32_Kilogram o_s32_Kilogram;
      if (!bDoIt(o_s32_Kilogram))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_S32_POUND:
   {
      fi_tcl_s32_Pound o_s32_Pound;
      if (!bDoIt(o_s32_Pound))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_S32_METER:
   {
      fi_tcl_s32_Meter o_s32_Meter;
      if (!bDoIt(o_s32_Meter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_S32_YARDS:
   {
      fi_tcl_s32_Yards o_s32_Yards;
      if (!bDoIt(o_s32_Yards))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_S32_CENTIMETER:
   {
      fi_tcl_s32_Centimeter o_s32_Centimeter;
      if (!bDoIt(o_s32_Centimeter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_S32_INCH:
   {
      fi_tcl_s32_Inch o_s32_Inch;
      if (!bDoIt(o_s32_Inch))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_S32_MILLIMETER:
   {
      fi_tcl_s32_Millimeter o_s32_Millimeter;
      if (!bDoIt(o_s32_Millimeter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_S32_MICROLITER:
   {
      fi_tcl_s32_Microliter o_s32_Microliter;
      if (!bDoIt(o_s32_Microliter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_S32_SECOND:
   {
      fi_tcl_s32_Second o_s32_Second;
      if (!bDoIt(o_s32_Second))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_S32_MILLISECOND:
   {
      fi_tcl_s32_MilliSecond o_s32_MilliSecond;
      if (!bDoIt(o_s32_MilliSecond))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_POSIXTIME:
   {
      if (poVisitor->bDoExpand_POSIXTime(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32,rcfi_tclSemanticDomain::EN_TIME));
      }
      else
      {
         fi_tcl_POSIXTime o_POSIXTime;
         if (!bDoIt(o_POSIXTime))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POSIXTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POSIXTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_DST_STATE:
   {
      fi_tcl_e8_DST_State o_e8_DST_State;
      if (!bDoIt(o_e8_DST_State))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_TIMEZONEELEMENT:
   {
      if (poVisitor->bDoExpand_TimeZoneElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_DST_TIMEDOMAIN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_DSTDIFFERENCE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_DST_STATE,rcfi_tclSemanticDomain::EN_DST_STATE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_TIMEZONEDIFFERENCE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_ABBREVIATION_DST_IN_EFFECT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_ABBREVIATION_STANDARDTIME));
      }
      else
      {
         fi_tcl_TimeZoneElement o_TimeZoneElement;
         if (!bDoIt(o_TimeZoneElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeZoneElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeZoneElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_S16_KMPERHOUR:
   {
      fi_tcl_s16_KmPerHour o_s16_KmPerHour;
      if (!bDoIt(o_s16_KmPerHour))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_S16_MILESPERHOUR:
   {
      fi_tcl_s16_MilesPerHour o_s16_MilesPerHour;
      if (!bDoIt(o_s16_MilesPerHour))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_S16_CENTIMETERSECOND:
   {
      fi_tcl_s16_CentimeterSecond o_s16_CentimeterSecond;
      if (!bDoIt(o_s16_CentimeterSecond))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_S16_KELVIN:
   {
      fi_tcl_s16_Kelvin o_s16_Kelvin;
      if (!bDoIt(o_s16_Kelvin))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_S16_FAHRENHEIT:
   {
      fi_tcl_s16_Fahrenheit o_s16_Fahrenheit;
      if (!bDoIt(o_s16_Fahrenheit))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_S32_PASCAL:
   {
      fi_tcl_s32_Pascal o_s32_Pascal;
      if (!bDoIt(o_s32_Pascal))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_FIVERSION:
   {
      if (poVisitor->bDoExpand_FIVersion(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_PATCHVERSION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_MINORVERSION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_MAJORVERSION));
      }
      else
      {
         fi_tcl_FIVersion o_FIVersion;
         if (!bDoIt(o_FIVersion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FIVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FIVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_S32_LONGITUDE:
   {
      fi_tcl_s32_Longitude o_s32_Longitude;
      if (!bDoIt(o_s32_Longitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_S32_LATITUDE:
   {
      fi_tcl_s32_Latitude o_s32_Latitude;
      if (!bDoIt(o_s32_Latitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_POSITIONWGS84:
   {
      if (poVisitor->bDoExpand_PositionWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_LATITUDE,rcfi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_LONGITUDE,rcfi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_PositionWGS84 o_PositionWGS84;
         if (!bDoIt(o_PositionWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E16_ISOCOUNTRYCODE:
   {
      fi_tcl_e16_ISOCountryCode o_e16_ISOCountryCode;
      if (!bDoIt(o_e16_ISOCountryCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_U8_DIRECTIONABSOLUTE:
   {
      fi_tcl_u8_DirectionAbsolute o_u8_DirectionAbsolute;
      if (!bDoIt(o_u8_DirectionAbsolute))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_U8_DIRECTIONRELATIVE:
   {
      fi_tcl_u8_DirectionRelative o_u8_DirectionRelative;
      if (!bDoIt(o_u8_DirectionRelative))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_FUELTYPE:
   {
      fi_tcl_e8_FuelType o_e8_FuelType;
      if (!bDoIt(o_e8_FuelType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_DISTTIMEFUEL:
   {
      if (poVisitor->bDoExpand_DistTimeFuel(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_MICROLITER,rcfi_tclSemanticDomain::EN_FUEL));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_TIME));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_DISTANCE));
      }
      else
      {
         fi_tcl_DistTimeFuel o_DistTimeFuel;
         if (!bDoIt(o_DistTimeFuel))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DistTimeFuel.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DistTimeFuel.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_BINCONTAINERTYPES:
   {
      fi_tcl_e8_BinContainerTypes o_e8_BinContainerTypes;
      if (!bDoIt(o_e8_BinContainerTypes))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E16_SELECTIONCRITERIONTYPE:
   {
      fi_tcl_e16_SelectionCriterionType o_e16_SelectionCriterionType;
      if (!bDoIt(o_e16_SelectionCriterionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_STRINGID:
   {
      if (poVisitor->bDoExpand_StringID(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_ID));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_STRING));
      }
      else
      {
         fi_tcl_StringID o_StringID;
         if (!bDoIt(o_StringID))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_STRINGPOSITION:
   {
      if (poVisitor->bDoExpand_StringPosition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_POSITION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_STRING));
      }
      else
      {
         fi_tcl_StringPosition o_StringPosition;
         if (!bDoIt(o_StringPosition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_LOCATIONDESCRIPTIONDATATYPE:
   {
      fi_tcl_e8_LocationDescriptionDataType o_e8_LocationDescriptionDataType;
      if (!bDoIt(o_e8_LocationDescriptionDataType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_B8_LOCATIONDESCRIPTORSTATUS:
   {
      fi_tcl_b8_LocationDescriptorStatus o_b8_LocationDescriptorStatus;
      if (!bDoIt(o_b8_LocationDescriptorStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_LOCATIONDESCRIPTORUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_LocationDescriptionDataType oDataType;
      oCallStack.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_LOCATIONDESCRIPTIONDATATYPE,rcfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_LISTOFPOSITIONS) &&
          !(17 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_FLISTRING) &&
          !(11 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_RESERVED,rcfi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_TSTRING:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGID:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRINGID,rcfi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONHEADINGSPEED:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONHEADINGSPEED,rcfi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONWGS84:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_NAVLOCATIONBINCONTAINER:
         #ifndef FI_S_EXTERNAL_FI
         if (bUseSpecialBinContainer)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVLOCATIONBINCONTAINER,rcfi_tclSemanticDomain::EN_DATA));
         }
         else
         #endif // FI_S_EXTERNAL_FI
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BINCONTAINER,rcfi_tclSemanticDomain::EN_DATA));
         }
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGPOSITION:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRINGPOSITION,rcfi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_FLISTRING:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_FLISTRING,rcfi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_LISTOFPOSITIONS:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LISTOFPOSITIONS,rcfi_tclSemanticDomain::EN_DATA));
         break;
      }
   } break;
   case rcfi_tclToken::EN_LOCATIONDESCRIPTOR:
   {
      if (poVisitor->bDoExpand_LocationDescriptor(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (25 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_LOCATIONDESCRIPTORSTATUS,rcfi_tclSemanticDomain::EN_STATUS));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LOCATIONDESCRIPTORUNION0,rcfi_tclSemanticDomain::EN_DATA));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E16_SELECTIONCRITERIONTYPE,rcfi_tclSemanticDomain::EN_SELECTIONCRITERION));
      }
      else
      {
         fi_tcl_LocationDescriptor o_LocationDescriptor;
         if (!bDoIt(o_LocationDescriptor))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocationDescriptor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocationDescriptor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_LOCATIONDESCRIPTION:
   {
      if (poVisitor->bDoExpand_LocationDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LOCATIONDESCRIPTOR,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_DESCRIPTORS));
      }
      else
      {
         fi_tcl_LocationDescription o_LocationDescription;
         if (!bDoIt(o_LocationDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocationDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocationDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_FLISTRING:
   {
      if (poVisitor->bDoExpand_FLIString(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_STRING));
      }
      else
      {
         fi_tcl_FLIString o_FLIString;
         if (!bDoIt(o_FLIString))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FLIString.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FLIString.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_B8_POSITIONSTATUS:
   {
      fi_tcl_b8_PositionStatus o_b8_PositionStatus;
      if (!bDoIt(o_b8_PositionStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_LISTOFPOSITIONS:
   {
      if (poVisitor->bDoExpand_ListOfPositions(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_CURRENTPOSITION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_ID));
         if (26 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_POSITIONSTATUS,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_POSITIONSTATI));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_POSITIONS));
      }
      else
      {
         fi_tcl_ListOfPositions o_ListOfPositions;
         if (!bDoIt(o_ListOfPositions))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ListOfPositions.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ListOfPositions.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E16_NAVIEVENTVALUE:
   {
      fi_tcl_e16_NaviEventValue o_e16_NaviEventValue;
      if (!bDoIt(o_e16_NaviEventValue))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_TRAFFICMSGTYPE:
   {
      fi_tcl_e8_TrafficMsgType o_e8_TrafficMsgType;
      if (!bDoIt(o_e8_TrafficMsgType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_TMLOCATIONTYPE:
   {
      fi_tcl_e8_TMLocationType o_e8_TMLocationType;
      if (!bDoIt(o_e8_TMLocationType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_EVENTTYPE:
   {
      fi_tcl_e8_EventType o_e8_EventType;
      if (!bDoIt(o_e8_EventType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E16_EFFECTCODE:
   {
      fi_tcl_e16_EffectCode o_e16_EffectCode;
      if (!bDoIt(o_e16_EffectCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E16_CAUSECODE:
   {
      fi_tcl_e16_CauseCode o_e16_CauseCode;
      if (!bDoIt(o_e16_CauseCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_TENDENCY:
   {
      fi_tcl_e8_Tendency o_e8_Tendency;
      if (!bDoIt(o_e8_Tendency))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_RDBID:
   {
      if (poVisitor->bDoExpand_RDBId(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_BSA));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_TABLENO));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_TMCCOUNTRYCODE));
      }
      else
      {
         fi_tcl_RDBId o_RDBId;
         if (!bDoIt(o_RDBId))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RDBId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RDBId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_TMEVENT:
   {
      if (poVisitor->bDoExpand_TMEvent(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_PRIORITY));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_CENTIMETERSECOND,rcfi_tclSemanticDomain::EN_AVERAGESPEEDCMPERSEC));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_KMPERHOUR,rcfi_tclSemanticDomain::EN_AVERAGESPEED));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_CENTIMETERSECOND,rcfi_tclSemanticDomain::EN_SPEEDLIMITADVICECMPERSEC));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_KMPERHOUR,rcfi_tclSemanticDomain::EN_SPEEDLIMITADVICE));
         if (36 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_DELAYINFORMATION));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_LENGTHINFORMATION));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E16_CAUSECODE,rcfi_tclSemanticDomain::EN_CAUSE));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_TENDENCY,rcfi_tclSemanticDomain::EN_TENDENCY));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E16_EFFECTCODE,rcfi_tclSemanticDomain::EN_EFFECT));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E16_NAVIEVENTVALUE,rcfi_tclSemanticDomain::EN_NAVIEVENTVALUE));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_EVENTTYPE,rcfi_tclSemanticDomain::EN_EVENTTYPE));
         }
      }
      else
      {
         fi_tcl_TMEvent o_TMEvent;
         if (!bDoIt(o_TMEvent))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMEvent.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMEvent.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_B32_TRAFFICMESSAGESOURCE:
   {
      fi_tcl_b32_TrafficMessageSource o_b32_TrafficMessageSource;
      if (!bDoIt(o_b32_TrafficMessageSource))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_TMURGENCY:
   {
      fi_tcl_e8_TMUrgency o_e8_TMUrgency;
      if (!bDoIt(o_e8_TMUrgency))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_TMCODEDMESSAGE:
   {
      if (poVisitor->bDoExpand_TMCodedMessage(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_RDBID,rcfi_tclSemanticDomain::EN_RDBID));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TMEVENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_EVENTS));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_BIDIRECTIONAL));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_DIRECTIONAGAINSTTMC));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_EXTENT));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_TMLOCATIONTYPE,rcfi_tclSemanticDomain::EN_PRIMARYLOCATIONTYPE));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_SECONDARYLOCATIONCODE));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_PRIMARYLOCATIONCODE));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_AVERAGESPEED));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_SPEEDLIMITADVICE));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_LENGTHINFOANDLABEL2));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_ROADNUMBERSUFFIX));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_ROADNUMBER));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_ROADCLASS));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E16_NAVIEVENTVALUE,rcfi_tclSemanticDomain::EN_ADDITIONALNEV7));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E16_NAVIEVENTVALUE,rcfi_tclSemanticDomain::EN_ADDITIONALNEV6));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E16_NAVIEVENTVALUE,rcfi_tclSemanticDomain::EN_ADDITIONALNEV5));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E16_NAVIEVENTVALUE,rcfi_tclSemanticDomain::EN_ADDITIONALNEV4));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E16_NAVIEVENTVALUE,rcfi_tclSemanticDomain::EN_ADDITIONALNEV3));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E16_NAVIEVENTVALUE,rcfi_tclSemanticDomain::EN_ADDITIONALNEV2));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E16_NAVIEVENTVALUE,rcfi_tclSemanticDomain::EN_ADDITIONALNEV1));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E16_NAVIEVENTVALUE,rcfi_tclSemanticDomain::EN_MAINNEV));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_DIRECTIONALITY));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_DIRANDEXTENT));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_LOCATIONTYPE));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_LOCATION2));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_LOCATION1));
         }
      }
      else
      {
         fi_tcl_TMCodedMessage o_TMCodedMessage;
         if (!bDoIt(o_TMCodedMessage))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMessage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMessage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#ifndef FI_S_EXTERNAL_FI
   case rcfi_tclToken::EN_TMCODEDMESSAGEBINCONTAINER:
   {
      if (poVisitor->bDoExpand_TMCodedMessageBinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         bInsideBinContainerVersion = true;
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_BINCONTAINER));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TMCODEDMESSAGE,rcfi_tclSemanticDomain::EN_TMCODEDMESSAGE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_BINCONTAINERTYPES,rcfi_tclSemanticDomain::EN_CONTAINERTYPE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_FIVERSION,rcfi_tclSemanticDomain::EN_CONTAINERFIVERSION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_SERVICEID));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_CONTAINERLENGTH));
      }
      else
      {
         fi_tcl_TMCodedMessageBinContainer o_TMCodedMessageBinContainer;
         if (!bDoIt(o_TMCodedMessageBinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMessageBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMessageBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#endif // FI_S_EXTERNAL_FI
   case rcfi_tclToken::EN_TMPROGRAMSERVICE:
   {
      if (poVisitor->bDoExpand_TMProgramService(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_PROGRAMSERVICENAME));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E16_ISOCOUNTRYCODE,rcfi_tclSemanticDomain::EN_COUNTRYCODE));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_EXTENDEDPROGRAMID));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_PROGRAMID));
      }
      else
      {
         fi_tcl_TMProgramService o_TMProgramService;
         if (!bDoIt(o_TMProgramService))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMProgramService.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMProgramService.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_U32_DATASETID:
   {
      fi_tcl_u32_DataSetId o_u32_DataSetId;
      if (!bDoIt(o_u32_DataSetId))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_U32_MEDIAID:
   {
      fi_tcl_u32_MediaId o_u32_MediaId;
      if (!bDoIt(o_u32_MediaId))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_NAVCLUSTERDESC:
   {
      if (poVisitor->bDoExpand_NavClusterDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_LENGTH));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_FILEOFFSET));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_FILEID));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_LEVEL));
      }
      else
      {
         fi_tcl_NavClusterDesc o_NavClusterDesc;
         if (!bDoIt(o_NavClusterDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_NAVDATALEVEL:
   {
      fi_tcl_e8_NavDataLevel o_e8_NavDataLevel;
      if (!bDoIt(o_e8_NavDataLevel))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_NAVONECELLDIRECTION:
   {
      fi_tcl_e8_NavOneCellDirection o_e8_NavOneCellDirection;
      if (!bDoIt(o_e8_NavOneCellDirection))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_NAVONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_INDEXINCLUSTERREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_NAVONECELLDIRECTION,rcfi_tclSemanticDomain::EN_USEDIRECTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_ONECELLID));
      }
      else
      {
         fi_tcl_NavOneCellDesc o_NavOneCellDesc;
         if (!bDoIt(o_NavOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_SIDEINFO:
   {
      fi_tcl_e8_SideInfo o_e8_SideInfo;
      if (!bDoIt(o_e8_SideInfo))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_S32_EMU:
   {
      fi_tcl_s32_EMU o_s32_EMU;
      if (!bDoIt(o_s32_EMU))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_NAVZEROCELLDESC:
   {
      if (poVisitor->bDoExpand_NavZeroCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_INDEXINCLUSTERREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_ZEROCELLID));
      }
      else
      {
         fi_tcl_NavZeroCellDesc o_NavZeroCellDesc;
         if (!bDoIt(o_NavZeroCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavZeroCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavZeroCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVONECELL:
   {
      if (poVisitor->bDoExpand_NavOneCell(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_CLUSTERLENGTH));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_CLUSTERFILEOFFSET));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_CLUSTERFILEID));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_NAVONECELLDIRECTION,rcfi_tclSemanticDomain::EN_USEDIRECTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_ONECELLID));
      }
      else
      {
         fi_tcl_NavOneCell o_NavOneCell;
         if (!bDoIt(o_NavOneCell))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCell.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCell.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_NAVONECELLCATEGORY:
   {
      fi_tcl_e8_NavOneCellCategory o_e8_NavOneCellCategory;
      if (!bDoIt(o_e8_NavOneCellCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_SIGNPOSTDESTTYPE:
   {
      fi_tcl_e8_SignPostDestType o_e8_SignPostDestType;
      if (!bDoIt(o_e8_SignPostDestType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_SIGNPOSTDESTINATIONCATEGORY:
   {
      fi_tcl_e8_SignPostDestinationCategory o_e8_SignPostDestinationCategory;
      if (!bDoIt(o_e8_SignPostDestinationCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_SIGNPOSTDESTSTATUS:
   {
      fi_tcl_e8_SignPostDestStatus o_e8_SignPostDestStatus;
      if (!bDoIt(o_e8_SignPostDestStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_DIRECTIONSTATUS:
   {
      fi_tcl_e8_DirectionStatus o_e8_DirectionStatus;
      if (!bDoIt(o_e8_DirectionStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_SIGNPOSTDESTDIRECTION:
   {
      if (poVisitor->bDoExpand_SignPostDestDirection(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_DIRECTIONDESC));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_DIRECTIONABSOLUTE,rcfi_tclSemanticDomain::EN_DIRECTION));
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_DIRECTIONISVALID));
         }
      }
      else
      {
         fi_tcl_SignPostDestDirection o_SignPostDestDirection;
         if (!bDoIt(o_SignPostDestDirection))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SignPostDestDirection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SignPostDestDirection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_DIRECTIONCATEGORY:
   {
      fi_tcl_e8_DirectionCategory o_e8_DirectionCategory;
      if (!bDoIt(o_e8_DirectionCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_B8_DIRECTIONINFOSTATUS:
   {
      fi_tcl_b8_DirectionInfoStatus o_b8_DirectionInfoStatus;
      if (!bDoIt(o_b8_DirectionInfoStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_DIRECTIONCATEGORYUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_DirectionCategory oDataType;
      oCallStack.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_DIRECTIONCATEGORY,rcfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_COMPASSDIRECTION) &&
          !(9 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_DirectionCategory::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_DirectionCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_RESERVED,rcfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_COUNTRYNAMEELEMENT:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_COUNTRYNAMEELEMENT,rcfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_STATENAMEELEMENT:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STATENAMEELEMENT,rcfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_COUNTYNAMEELEMENT:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_COUNTYNAMEELEMENT,rcfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_CITYNAMEELEMENT:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CITYNAMEELEMENT,rcfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CITYDISTRICTNAMEELEMENT,rcfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_BUILDUPAREANAMEELEMENT:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BUILDUPAREANAMEELEMENT,rcfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_ROADNAMEELEMENT:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROADNAMEELEMENT,rcfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_ROADNUMBER:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROADNUMBER,rcfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_INTERSECTIONNAMEELEMENT:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_INTERSECTIONNAMEELEMENT,rcfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_INTERSECTIONNUMBERELEMENT:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_INTERSECTIONNUMBERELEMENT,rcfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_POINTOFINTERESTELEMENT:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POINTOFINTERESTELEMENT,rcfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_UNSPECIFIEDTEXT:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_UNSPECIFIEDTEXT,rcfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_COMPASSDIRECTION:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_COMPASSDIRECTION,rcfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      }
   } break;
   case rcfi_tclToken::EN_DIRECTIONCATEGORY:
   {
      if (poVisitor->bDoExpand_DirectionCategory(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DIRECTIONCATEGORYUNION0,rcfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
      }
      else
      {
         fi_tcl_DirectionCategory o_DirectionCategory;
         if (!bDoIt(o_DirectionCategory))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DirectionCategory.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DirectionCategory.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_DIRECTIONINFO:
   {
      if (poVisitor->bDoExpand_DirectionInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (21 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_DIRECTIONINFOSTATUS,rcfi_tclSemanticDomain::EN_STATUS));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_DIRECTIONSTATUS,rcfi_tclSemanticDomain::EN_DIRECTIONSTATUS));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DIRECTIONCATEGORY,rcfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_DIRECTIONID));
      }
      else
      {
         fi_tcl_DirectionInfo o_DirectionInfo;
         if (!bDoIt(o_DirectionInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DirectionInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DirectionInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_SIGNPOSTDESTINATIONUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_SignPostDestinationCategory oDataType;
      oCallStack.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_SIGNPOSTDESTINATIONCATEGORY,rcfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COMPASSDIRECTION) &&
          !(9 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_RESERVED,rcfi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COUNTRYNAMEELEMENT:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_COUNTRYNAMEELEMENT,rcfi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_STATENAMEELEMENT:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STATENAMEELEMENT,rcfi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COUNTYNAMEELEMENT:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_COUNTYNAMEELEMENT,rcfi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_CITYNAMEELEMENT:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CITYNAMEELEMENT,rcfi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CITYDISTRICTNAMEELEMENT,rcfi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_BUILDUPAREANAMEELEMENT:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BUILDUPAREANAMEELEMENT,rcfi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_ROADNAMEELEMENT:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROADNAMEELEMENT,rcfi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_ROADNUMBER:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROADNUMBER,rcfi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_INTERSECTIONNAMEELEMENT:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_INTERSECTIONNAMEELEMENT,rcfi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_INTERSECTIONNUMBERELEMENT:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_INTERSECTIONNUMBERELEMENT,rcfi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_POINTOFINTERESTELEMENT:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POINTOFINTERESTELEMENT,rcfi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_UNSPECIFIEDTEXT:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_UNSPECIFIEDTEXT,rcfi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      case fi_tcl_e8_SignPostDestinationCategory::FI_EN_T_COMPASSDIRECTION:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_COMPASSDIRECTION,rcfi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         break;
      }
   } break;
   case rcfi_tclToken::EN_SIGNPOSTDESTINATION:
   {
      if (poVisitor->bDoExpand_SignPostDestination(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DIRECTIONINFO,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_DIRECTIONINFOLIST));
         }
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_SIGNPOSTDESTDIRECTION,rcfi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONDIRECTION));
         }
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_SIGNPOSTDESTINATIONUNION0,rcfi_tclSemanticDomain::EN_SIGNPOSTDESTINATIONCATEGORY));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_SIGNPOSTDESTTYPE,rcfi_tclSemanticDomain::EN_TYPE));
      }
      else
      {
         fi_tcl_SignPostDestination o_SignPostDestination;
         if (!bDoIt(o_SignPostDestination))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SignPostDestination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SignPostDestination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_REFERENCEELEMENT:
   {
      if (poVisitor->bDoExpand_ReferenceElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_REFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_BASELIST));
      }
      else
      {
         fi_tcl_ReferenceElement o_ReferenceElement;
         if (!bDoIt(o_ReferenceElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ReferenceElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ReferenceElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_DIRECTIONINFOLISTSET:
   {
      if (poVisitor->bDoExpand_DirectionInfoListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DIRECTIONINFO,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_DIRECTIONINFOLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REFERENCEELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
      }
      else
      {
         fi_tcl_DirectionInfoListSet o_DirectionInfoListSet;
         if (!bDoIt(o_DirectionInfoListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DirectionInfoListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DirectionInfoListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_B16_POSITIONRELIABILITY:
   {
      fi_tcl_b16_PositionReliability o_b16_PositionReliability;
      if (!bDoIt(o_b16_PositionReliability))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_POSITIONHEADINGSPEED:
   {
      if (poVisitor->bDoExpand_PositionHeadingSpeed(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_DIRECTIONABSOLUTE,rcfi_tclSemanticDomain::EN_HEADING));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_CENTIMETERSECOND,rcfi_tclSemanticDomain::EN_SPEED));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B16_POSITIONRELIABILITY,rcfi_tclSemanticDomain::EN_POSITIONRELIABILITY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_POSITIONWGS84));
      }
      else
      {
         fi_tcl_PositionHeadingSpeed o_PositionHeadingSpeed;
         if (!bDoIt(o_PositionHeadingSpeed))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionHeadingSpeed.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionHeadingSpeed.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_SHAPETYPE:
   {
      fi_tcl_e8_ShapeType o_e8_ShapeType;
      if (!bDoIt(o_e8_ShapeType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_SHAPE:
   {
      if (poVisitor->bDoExpand_Shape(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_SHAPEPOINTS));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_SHAPETYPE,rcfi_tclSemanticDomain::EN_SHAPETYPE));
      }
      else
      {
         fi_tcl_Shape o_Shape;
         if (!bDoIt(o_Shape))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Shape.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Shape.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_TMSERVICEPROVIDER:
   {
      if (poVisitor->bDoExpand_TMServiceProvider(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_SERVICEPROVIDERNAME));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E16_ISOCOUNTRYCODE,rcfi_tclSemanticDomain::EN_COUNTRYCODE));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_EXTENDEDSERVICEID));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_SERVICEID));
      }
      else
      {
         fi_tcl_TMServiceProvider o_TMServiceProvider;
         if (!bDoIt(o_TMServiceProvider))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMServiceProvider.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMServiceProvider.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_TMCATEGORY:
   {
      fi_tcl_e8_TMCategory o_e8_TMCategory;
      if (!bDoIt(o_e8_TMCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_TMFLOWIMPACT:
   {
      fi_tcl_e8_TMFlowImpact o_e8_TMFlowImpact;
      if (!bDoIt(o_e8_TMFlowImpact))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_B8_TMMAPPINGPOSSIBILITY:
   {
      fi_tcl_b8_TMMappingPossibility o_b8_TMMappingPossibility;
      if (!bDoIt(o_b8_TMMappingPossibility))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_B8_TMMAPPINGSTATUS:
   {
      fi_tcl_b8_TMMappingStatus o_b8_TMMappingStatus;
      if (!bDoIt(o_b8_TMMappingStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_TMAFFECTIONTYPE:
   {
      fi_tcl_e8_TMAffectionType o_e8_TMAffectionType;
      if (!bDoIt(o_e8_TMAffectionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_B8_TMONECELLATTRIBUTE:
   {
      fi_tcl_b8_TMOneCellAttribute o_b8_TMOneCellAttribute;
      if (!bDoIt(o_b8_TMOneCellAttribute))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_TMONECELLPORTION:
   {
      if (poVisitor->bDoExpand_TMOneCellPortion(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_PERCENT,rcfi_tclSemanticDomain::EN_LENGTH));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_PERCENT,rcfi_tclSemanticDomain::EN_OFFSET));
      }
      else
      {
         fi_tcl_TMOneCellPortion o_TMOneCellPortion;
         if (!bDoIt(o_TMOneCellPortion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMOneCellPortion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMOneCellPortion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_TMVALUESTATUS:
   {
      fi_tcl_e8_TMValueStatus o_e8_TMValueStatus;
      if (!bDoIt(o_e8_TMValueStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_TMCINTERSECTIONPATHTYPE:
   {
      fi_tcl_e8_TMCIntersectionPathType o_e8_TMCIntersectionPathType;
      if (!bDoIt(o_e8_TMCIntersectionPathType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_TMGEOMETRICMESSAGETYPE:
   {
      fi_tcl_e8_TMGeometricMessageType o_e8_TMGeometricMessageType;
      if (!bDoIt(o_e8_TMGeometricMessageType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_TMGEOGRAPHICALPATHRELATIONTYPE:
   {
      fi_tcl_e8_TMGeographicalPathRelationType o_e8_TMGeographicalPathRelationType;
      if (!bDoIt(o_e8_TMGeographicalPathRelationType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_B8_TMRELEVANCE:
   {
      fi_tcl_b8_TMRelevance o_b8_TMRelevance;
      if (!bDoIt(o_b8_TMRelevance))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_TMCSTRUCTUREDTEXT:
   {
      if (poVisitor->bDoExpand_TMCStructuredText(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_LONGSUFFIX));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_SHORTSUFFIX));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_LONGBODY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_SHORTBODY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_LONGPREFIX));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_SHORTPREFIX));
      }
      else
      {
         fi_tcl_TMCStructuredText o_TMCStructuredText;
         if (!bDoIt(o_TMCStructuredText))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCStructuredText.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCStructuredText.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_B8_ROADNUMBERSTATUS:
   {
      fi_tcl_b8_RoadNumberStatus o_b8_RoadNumberStatus;
      if (!bDoIt(o_b8_RoadNumberStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_COMPASSDIRECTION:
   {
      if (poVisitor->bDoExpand_CompassDirection(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_DIRECTIONDESC));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_DIRECTIONABSOLUTE,rcfi_tclSemanticDomain::EN_DIRECTION));
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_DIRECTIONISVALID));
         }
      }
      else
      {
         fi_tcl_CompassDirection o_CompassDirection;
         if (!bDoIt(o_CompassDirection))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CompassDirection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CompassDirection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_INFOSTATUS:
   {
      fi_tcl_e8_InfoStatus o_e8_InfoStatus;
      if (!bDoIt(o_e8_InfoStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_INFOSTATUS:
   {
      if (poVisitor->bDoExpand_InfoStatus(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_INFOSTATUS,rcfi_tclSemanticDomain::EN_STATUS));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_INFOCOUNTER));
      }
      else
      {
         fi_tcl_InfoStatus o_InfoStatus;
         if (!bDoIt(o_InfoStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_InfoStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_InfoStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_SIGNPOSTELEMENTUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_NavOneCellCategory oDataType;
      oCallStack.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_NAVONECELLCATEGORY,rcfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_NavOneCellCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_RESERVED,rcfi_tclSemanticDomain::EN_NAVONECELLCATEGORY));
         break;
      case fi_tcl_e8_NavOneCellCategory::FI_EN_T_NAVONECELL:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVONECELL,rcfi_tclSemanticDomain::EN_NAVONECELLCATEGORY));
         break;
      case fi_tcl_e8_NavOneCellCategory::FI_EN_T_U16_INDEXINREFERENCELIST:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_NAVONECELLCATEGORY));
         break;
      }
   } break;
   case rcfi_tclToken::EN_SIGNPOSTELEMENT:
   {
      if (poVisitor->bDoExpand_SignPostElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_SIGNPOSTDESTINATION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_SIGNPOSTDESTINATION));
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_SIGNPOSTDESTSTATUS,rcfi_tclSemanticDomain::EN_STATUS));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_SIGNPOSTELEMENTUNION0,rcfi_tclSemanticDomain::EN_NAVONECELLCATEGORY));
      }
      else
      {
         fi_tcl_SignPostElement o_SignPostElement;
         if (!bDoIt(o_SignPostElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SignPostElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SignPostElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_REFERENCEELEMENTWITHID:
   {
      if (poVisitor->bDoExpand_ReferenceElementWithID(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_ID));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_REFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_BASELIST));
      }
      else
      {
         fi_tcl_ReferenceElementWithID o_ReferenceElementWithID;
         if (!bDoIt(o_ReferenceElementWithID))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ReferenceElementWithID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ReferenceElementWithID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_STATENAMEELEMENT:
   {
      if (poVisitor->bDoExpand_StateNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_STATECODE));
         }
         if (u16MajorVersion <= 10)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_STATECODE_OLD));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_STATENAME));
      }
      else
      {
         fi_tcl_StateNameElement o_StateNameElement;
         if (!bDoIt(o_StateNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StateNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StateNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_COUNTYNAMEELEMENT:
   {
      if (poVisitor->bDoExpand_CountyNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_COUNTYNAME));
      }
      else
      {
         fi_tcl_CountyNameElement o_CountyNameElement;
         if (!bDoIt(o_CountyNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountyNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountyNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_CITYDISTRICTNAMEELEMENT:
   {
      if (poVisitor->bDoExpand_CityDistrictNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_POPULATION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S8,rcfi_tclSemanticDomain::EN_PRIORITY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_NAME));
      }
      else
      {
         fi_tcl_CityDistrictNameElement o_CityDistrictNameElement;
         if (!bDoIt(o_CityDistrictNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityDistrictNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityDistrictNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_BUILDUPAREANAMEELEMENT:
   {
      if (poVisitor->bDoExpand_BuildUpAreaNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_POPULATION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S8,rcfi_tclSemanticDomain::EN_PRIORITY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_NAME));
      }
      else
      {
         fi_tcl_BuildUpAreaNameElement o_BuildUpAreaNameElement;
         if (!bDoIt(o_BuildUpAreaNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BuildUpAreaNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BuildUpAreaNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_ROADNUMBER:
   {
      if (poVisitor->bDoExpand_RoadNumber(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_COMPASSDIRECTION,rcfi_tclSemanticDomain::EN_COMPASSDIRECTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_NUMBERSUFFIX));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_ROADNUMBER));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_NUMBERPREFIX));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_NUMBERHIERARCHY));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_STATECODE));
         }
         if (u16MajorVersion <= 10)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_STATE));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E16_ISOCOUNTRYCODE,rcfi_tclSemanticDomain::EN_COUNTRYCODE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_ROADNUMBERSTATUS,rcfi_tclSemanticDomain::EN_STATUS));
      }
      else
      {
         fi_tcl_RoadNumber o_RoadNumber;
         if (!bDoIt(o_RoadNumber))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNumber.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNumber.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_REQUIREDTAXDISC:
   {
      if (poVisitor->bDoExpand_RequiredTaxDisc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_DESCRIPTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_REQUIREDPERMISSIONNAME));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_REGION));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E16_ISOCOUNTRYCODE,rcfi_tclSemanticDomain::EN_COUNTRYCODE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32,rcfi_tclSemanticDomain::EN_REQUIREDPERMISSIONID));
      }
      else
      {
         fi_tcl_RequiredTaxDisc o_RequiredTaxDisc;
         if (!bDoIt(o_RequiredTaxDisc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredTaxDisc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredTaxDisc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_REQUIREDPERMISSIONTYPE:
   {
      fi_tcl_e8_RequiredPermissionType o_e8_RequiredPermissionType;
      if (!bDoIt(o_e8_RequiredPermissionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_REQUIREDPERMISSION:
   {
      fi_tcl_e8_RequiredPermission o_e8_RequiredPermission;
      if (!bDoIt(o_e8_RequiredPermission))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_GENERICREQUIREDPERMISSION:
   {
      if (poVisitor->bDoExpand_GenericRequiredPermission(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_REQUIREDPERMISSIONTYPE,rcfi_tclSemanticDomain::EN_REQUIREDPERMISSIONTYPE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_DESCRIPTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_REQUIREDPERMISSIONNAME));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_REGIONID));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E16_ISOCOUNTRYCODE,rcfi_tclSemanticDomain::EN_COUNTRYCODE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32,rcfi_tclSemanticDomain::EN_REQUIREDPERMISSIONID));
      }
      else
      {
         fi_tcl_GenericRequiredPermission o_GenericRequiredPermission;
         if (!bDoIt(o_GenericRequiredPermission))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GenericRequiredPermission.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GenericRequiredPermission.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_REQUIREDPERMISSIONUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_RequiredPermission oDataType;
      oCallStack.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_REQUIREDPERMISSION,rcfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_RequiredPermission::FI_EN_T_GENERICREQUIREDPERMISSION) &&
          !(13 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_RequiredPermission::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_RequiredPermission::FI_EN_T_REQUIREDTAXDISC) &&
          !(u16MajorVersion <= 12))
      {
         oDataType.enType = fi_tcl_e8_RequiredPermission::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_RequiredPermission::FI_EN_T_RESERVED:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_RESERVED,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RequiredPermission::FI_EN_T_REQUIREDTAXDISC:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REQUIREDTAXDISC,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RequiredPermission::FI_EN_T_GENERICREQUIREDPERMISSION:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_GENERICREQUIREDPERMISSION,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      }
   } break;
   case rcfi_tclToken::EN_REQUIREDPERMISSION:
   {
      if (poVisitor->bDoExpand_RequiredPermission(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REQUIREDPERMISSIONUNION0,rcfi_tclSemanticDomain::EN_CATEGORY));
      }
      else
      {
         fi_tcl_RequiredPermission o_RequiredPermission;
         if (!bDoIt(o_RequiredPermission))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredPermission.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredPermission.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_COUNTRYNAMEELEMENT:
   {
      if (poVisitor->bDoExpand_CountryNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_NAME));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E16_ISOCOUNTRYCODE,rcfi_tclSemanticDomain::EN_CODE));
      }
      else
      {
         fi_tcl_CountryNameElement o_CountryNameElement;
         if (!bDoIt(o_CountryNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_STATENAMELISTSET:
   {
      if (poVisitor->bDoExpand_StateNameListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STATENAMEELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_STATENAMEREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_StateNameListSet o_StateNameListSet;
         if (!bDoIt(o_StateNameListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StateNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StateNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_COUNTYNAMELISTSET:
   {
      if (poVisitor->bDoExpand_CountyNameListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_COUNTYNAMEREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_CountyNameListSet o_CountyNameListSet;
         if (!bDoIt(o_CountyNameListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountyNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountyNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_CITYNAMEELEMENT:
   {
      if (poVisitor->bDoExpand_CityNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_POPULATION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S8,rcfi_tclSemanticDomain::EN_PRIORITY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_NAME));
      }
      else
      {
         fi_tcl_CityNameElement o_CityNameElement;
         if (!bDoIt(o_CityNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_INDEXINREFERENCELIST:
   {
      if (poVisitor->bDoExpand_IndexInReferenceList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_DESCRIPTIONONNEXTNODE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_REFELEMENT));
      }
      else
      {
         fi_tcl_IndexInReferenceList o_IndexInReferenceList;
         if (!bDoIt(o_IndexInReferenceList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IndexInReferenceList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IndexInReferenceList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_BUILDUPAREANAMELISTSET:
   {
      if (poVisitor->bDoExpand_BuildUpAreaNameListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BUILDUPAREANAMEELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_BUILDUPAREANAMEREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ELEMENTINREFLIST));
      }
      else
      {
         fi_tcl_BuildUpAreaNameListSet o_BuildUpAreaNameListSet;
         if (!bDoIt(o_BuildUpAreaNameListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BuildUpAreaNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BuildUpAreaNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_ROADNAMELISTSET:
   {
      if (poVisitor->bDoExpand_RoadNameListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ROADNAMEREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REFERENCEELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_RoadNameListSet o_RoadNameListSet;
         if (!bDoIt(o_RoadNameListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_ROADNUMBERLISTSET:
   {
      if (poVisitor->bDoExpand_RoadNumberListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROADNUMBER,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ROADNUMBERREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REFERENCEELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_RoadNumberListSet o_RoadNumberListSet;
         if (!bDoIt(o_RoadNumberListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNumberListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNumberListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_REQUIREDPERMISSIONLISTSET:
   {
      if (poVisitor->bDoExpand_RequiredPermissionListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REQUIREDPERMISSION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_REQUIREDPERMISSIONREFLIST));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REFERENCEELEMENTWITHID,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ALTERNATIVREFIDLIST));
         }
         if (u16MajorVersion <= 10)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REFERENCEELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
         }
      }
      else
      {
         fi_tcl_RequiredPermissionListSet o_RequiredPermissionListSet;
         if (!bDoIt(o_RequiredPermissionListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredPermissionListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredPermissionListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_INTERSECTIONTYPE:
   {
      fi_tcl_e8_IntersectionType o_e8_IntersectionType;
      if (!bDoIt(o_e8_IntersectionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_TIMEZONELISTSET:
   {
      if (poVisitor->bDoExpand_TimeZoneListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TIMEZONEELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_TIMEZONELIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_TimeZoneListSet o_TimeZoneListSet;
         if (!bDoIt(o_TimeZoneListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeZoneListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeZoneListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_INTERSECTIONNAMEELEMENT:
   {
      if (poVisitor->bDoExpand_IntersectionNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_INTERSECTIONSUFFIX));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_INTERSECTIONNAME));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_INTERSECTIONPREFIX));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_INTERSECTIONTYPE,rcfi_tclSemanticDomain::EN_INTERSECTIONTYPE));
      }
      else
      {
         fi_tcl_IntersectionNameElement o_IntersectionNameElement;
         if (!bDoIt(o_IntersectionNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_ROADNAMEELEMENT:
   {
      if (poVisitor->bDoExpand_RoadNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_ROADNAME));
      }
      else
      {
         fi_tcl_RoadNameElement o_RoadNameElement;
         if (!bDoIt(o_RoadNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_INTERSECTIONNUMBERELEMENT:
   {
      if (poVisitor->bDoExpand_IntersectionNumberElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROADNUMBER,rcfi_tclSemanticDomain::EN_INTERSECTIONNUMBER));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_INTERSECTIONTYPE,rcfi_tclSemanticDomain::EN_INTERSECTIONTYPE));
      }
      else
      {
         fi_tcl_IntersectionNumberElement o_IntersectionNumberElement;
         if (!bDoIt(o_IntersectionNumberElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionNumberElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionNumberElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_COUNTRYNAMELISTSET:
   {
      if (poVisitor->bDoExpand_CountryNameListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_COUNTRYNAMEELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_COUNTRYNAMEREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_CountryNameListSet o_CountryNameListSet;
         if (!bDoIt(o_CountryNameListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_CITYNAMELISTSET:
   {
      if (poVisitor->bDoExpand_CityNameListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CITYNAMEELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_CITYNAMEREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ELEMENTINREFLIST));
      }
      else
      {
         fi_tcl_CityNameListSet o_CityNameListSet;
         if (!bDoIt(o_CityNameListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_SIGNPOSTLISTSET:
   {
      if (poVisitor->bDoExpand_SignPostListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_SIGNPOSTELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_SIGNPOSTELEMENT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REFERENCEELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
      }
      else
      {
         fi_tcl_SignPostListSet o_SignPostListSet;
         if (!bDoIt(o_SignPostListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SignPostListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SignPostListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_ROADCLASSCODE:
   {
      fi_tcl_e8_RoadClassCode o_e8_RoadClassCode;
      if (!bDoIt(o_e8_RoadClassCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_U16_USERTRAFFICMESSAGEHANDLE:
   {
      fi_tcl_u16_UserTrafficMessageHandle o_u16_UserTrafficMessageHandle;
      if (!bDoIt(o_u16_UserTrafficMessageHandle))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_TMCOMBINATION:
   {
      if (poVisitor->bDoExpand_TMCombination(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_TMCINTERSECTIONPATHTYPE,rcfi_tclSemanticDomain::EN_INTERSECTIONPATHTYPE));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_TMAFFECTIONTYPE,rcfi_tclSemanticDomain::EN_AFFECTIONTYPE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TMONECELLPORTION,rcfi_tclSemanticDomain::EN_PORTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_TMONECELLATTRIBUTE,rcfi_tclSemanticDomain::EN_TMATTRIBUTES));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_INDEXINTMINFOLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_INDEXINTMPATHLIST));
      }
      else
      {
         fi_tcl_TMCombination o_TMCombination;
         if (!bDoIt(o_TMCombination))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCombination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCombination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_B32_ROADPROPERTY:
   {
      fi_tcl_b32_RoadProperty o_b32_RoadProperty;
      if (!bDoIt(o_b32_RoadProperty))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_NAVSTREETTYPE:
   {
      fi_tcl_e8_NavStreetType o_e8_NavStreetType;
      if (!bDoIt(o_e8_NavStreetType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_ROADNETWORKCLASS:
   {
      fi_tcl_e8_RoadNetworkClass o_e8_RoadNetworkClass;
      if (!bDoIt(o_e8_RoadNetworkClass))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_ROADATTRIBUTES:
   {
      if (poVisitor->bDoExpand_RoadAttributes(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_ROADNETWORKCLASS,rcfi_tclSemanticDomain::EN_ROADNETWORKCLASS));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_NAVSTREETTYPE,rcfi_tclSemanticDomain::EN_ROADTYPE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B32_ROADPROPERTY,rcfi_tclSemanticDomain::EN_ROADPROPERTY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_ROADCLASSCODE,rcfi_tclSemanticDomain::EN_ROADCLASS));
      }
      else
      {
         fi_tcl_RoadAttributes o_RoadAttributes;
         if (!bDoIt(o_RoadAttributes))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadAttributes.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadAttributes.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_EXTRADESCELEMENTTYPE:
   {
      fi_tcl_e8_ExtraDescElementType o_e8_ExtraDescElementType;
      if (!bDoIt(o_e8_ExtraDescElementType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_EXTRADESCELEMENT:
   {
      if (poVisitor->bDoExpand_ExtraDescElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_LONGDESCRIPTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_SHORTDESCRIPTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_EXTRADESCELEMENTTYPE,rcfi_tclSemanticDomain::EN_TYPE));
      }
      else
      {
         fi_tcl_ExtraDescElement o_ExtraDescElement;
         if (!bDoIt(o_ExtraDescElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ExtraDescElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ExtraDescElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_EXTRADESCLISTSET:
   {
      if (poVisitor->bDoExpand_ExtraDescListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_EXTRADESCELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_EXTRADESCREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REFERENCEELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
      }
      else
      {
         fi_tcl_ExtraDescListSet o_ExtraDescListSet;
         if (!bDoIt(o_ExtraDescListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ExtraDescListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ExtraDescListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_B32_DATAPROPERTIES:
   {
      fi_tcl_b32_DataProperties o_b32_DataProperties;
      if (!bDoIt(o_b32_DataProperties))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_DATADESCELEMENT:
   {
      if (poVisitor->bDoExpand_DataDescElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_CANDYPRODUCTCODE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B32_DATAPROPERTIES,rcfi_tclSemanticDomain::EN_RNWDATAPROPERTIES));
      }
      else
      {
         fi_tcl_DataDescElement o_DataDescElement;
         if (!bDoIt(o_DataDescElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DataDescElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DataDescElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_DATADESCLISTSET:
   {
      if (poVisitor->bDoExpand_DataDescListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DATADESCELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_DATADESCREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REFERENCEELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_DataDescListSet o_DataDescListSet;
         if (!bDoIt(o_DataDescListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DataDescListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DataDescListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_B8_CROSSROADPROPERTIES:
   {
      fi_tcl_b8_CrossroadProperties o_b8_CrossroadProperties;
      if (!bDoIt(o_b8_CrossroadProperties))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_CROSSROADDESC:
   {
      if (poVisitor->bDoExpand_CrossroadDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_INDEXOFTWINELEMENT));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROADATTRIBUTES,rcfi_tclSemanticDomain::EN_CROSSROADATTRIBUTES));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_CROSSROADINFOREFELEMENT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_CROSSROADPROPERTIES,rcfi_tclSemanticDomain::EN_CROSSROADPROPERTY));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_DIRECTIONABSOLUTE,rcfi_tclSemanticDomain::EN_DIRECTIONOFCONNECTEDELEMENT));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_DIRECTIONABSOLUTE,rcfi_tclSemanticDomain::EN_DIRECTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_ISDIRECTIONVALID));
      }
      else
      {
         fi_tcl_CrossroadDesc o_CrossroadDesc;
         if (!bDoIt(o_CrossroadDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CrossroadDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CrossroadDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_CROSSROADINFOCATEGORY:
   {
      fi_tcl_e8_CrossroadInfoCategory o_e8_CrossroadInfoCategory;
      if (!bDoIt(o_e8_CrossroadInfoCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_CROSSROADINFOUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_CrossroadInfoCategory oDataType;
      oCallStack.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_CROSSROADINFOCATEGORY,rcfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_CrossroadInfoCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_RESERVED,rcfi_tclSemanticDomain::EN_CROSSROADINFO));
         break;
      case fi_tcl_e8_CrossroadInfoCategory::FI_EN_T_ROADNAMELISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROADNAMELISTSET,rcfi_tclSemanticDomain::EN_CROSSROADINFO));
         break;
      case fi_tcl_e8_CrossroadInfoCategory::FI_EN_T_ROADNUMBERLISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROADNUMBERLISTSET,rcfi_tclSemanticDomain::EN_CROSSROADINFO));
         break;
      }
   } break;
   case rcfi_tclToken::EN_CROSSROADINFO:
   {
      if (poVisitor->bDoExpand_CrossroadInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CROSSROADINFOUNION0,rcfi_tclSemanticDomain::EN_CROSSROADINFO));
      }
      else
      {
         fi_tcl_CrossroadInfo o_CrossroadInfo;
         if (!bDoIt(o_CrossroadInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CrossroadInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CrossroadInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_INTERSECTIONDENOTATION:
   {
      if (poVisitor->bDoExpand_IntersectionDenotation(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_INTERSECTIONNAMESUFFIX));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_INTERSECTIONNAMEBODY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_INTERSECTIONNAMEPREFIX));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROADNUMBER,rcfi_tclSemanticDomain::EN_INTERSECTIONNUMBER));
      }
      else
      {
         fi_tcl_IntersectionDenotation o_IntersectionDenotation;
         if (!bDoIt(o_IntersectionDenotation))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionDenotation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionDenotation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_INTERSECTIONDESCELEMENT:
   {
      if (poVisitor->bDoExpand_IntersectionDescElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CROSSROADINFO,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_CROSSROADINFOLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CROSSROADDESC,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_CROSSROADLIST));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_INTERSECTIONCENTERCOORDINATES));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_EMU,rcfi_tclSemanticDomain::EN_INTERSECTIONDIAMETER));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_INTERSECTIONDENOTATION,rcfi_tclSemanticDomain::EN_INTERSECTIONDENOTATION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_INTERSECTIONTYPE,rcfi_tclSemanticDomain::EN_INTERSECTIONTYPE));
      }
      else
      {
         fi_tcl_IntersectionDescElement o_IntersectionDescElement;
         if (!bDoIt(o_IntersectionDescElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionDescElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionDescElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_INTERSECTIONLISTSET:
   {
      if (poVisitor->bDoExpand_IntersectionListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CROSSROADINFO,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_CROSSROADINFOLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_INTERSECTIONDESCELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_INTERSECTIONREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ELEMENTINREFLIST));
      }
      else
      {
         fi_tcl_IntersectionListSet o_IntersectionListSet;
         if (!bDoIt(o_IntersectionListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_BASETRAFFICSIGNCATEGORY:
   {
      fi_tcl_e8_BaseTrafficSignCategory o_e8_BaseTrafficSignCategory;
      if (!bDoIt(o_e8_BaseTrafficSignCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_SPEEDSIGN:
   {
      fi_tcl_e8_SpeedSign o_e8_SpeedSign;
      if (!bDoIt(o_e8_SpeedSign))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E16_WARNINGSIGN:
   {
      fi_tcl_e16_WarningSign o_e16_WarningSign;
      if (!bDoIt(o_e16_WarningSign))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E16_REGULATORYSIGN:
   {
      fi_tcl_e16_RegulatorySign o_e16_RegulatorySign;
      if (!bDoIt(o_e16_RegulatorySign))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E16_ADDITIONALTRAFFICSIGN:
   {
      fi_tcl_e16_AdditionalTrafficSign o_e16_AdditionalTrafficSign;
      if (!bDoIt(o_e16_AdditionalTrafficSign))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_TIMEDEPENDENTSTRING:
   {
      fi_tcl_TimeDependentString o_TimeDependentString;
      if (!bDoIt(o_TimeDependentString))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_B8_LANEDEPENDENTVALIDITY:
   {
      fi_tcl_b8_LaneDependentValidity o_b8_LaneDependentValidity;
      if (!bDoIt(o_b8_LaneDependentValidity))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_TRAFFICSIGNQUANTIFIER:
   {
      fi_tcl_e8_TrafficSignQuantifier o_e8_TrafficSignQuantifier;
      if (!bDoIt(o_e8_TrafficSignQuantifier))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_ADDITIONALTRAFFICSIGNUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_TrafficSignQuantifier oDataType;
      oCallStack.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_TRAFFICSIGNQUANTIFIER,rcfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_RESERVED,rcfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_KMPERHOUR,rcfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_MILESPERHOUR,rcfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_PERCENT,rcfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_LANEDEPENDENTVALIDITY,rcfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TIMEDEPENDENTSTRING,rcfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_YARDS,rcfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_CENTIMETER,rcfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_INCH,rcfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_KILOGRAM,rcfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_POUND,rcfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      }
   } break;
   case rcfi_tclToken::EN_ADDITIONALTRAFFICSIGN:
   {
      if (poVisitor->bDoExpand_AdditionalTrafficSign(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ADDITIONALTRAFFICSIGNUNION0,rcfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E16_ADDITIONALTRAFFICSIGN,rcfi_tclSemanticDomain::EN_ADDITIONALSIGN));
      }
      else
      {
         fi_tcl_AdditionalTrafficSign o_AdditionalTrafficSign;
         if (!bDoIt(o_AdditionalTrafficSign))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AdditionalTrafficSign.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AdditionalTrafficSign.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_TRAFFICSIGNELEMENTUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_BaseTrafficSignCategory oDataType;
      oCallStack.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_BASETRAFFICSIGNCATEGORY,rcfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_REGULATORYSIGN) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_RESERVED,rcfi_tclSemanticDomain::EN_BASESIGNUNION));
         break;
      case fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E8_SPEEDSIGN:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_SPEEDSIGN,rcfi_tclSemanticDomain::EN_BASESIGNUNION));
         break;
      case fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_WARNINGSIGN:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E16_WARNINGSIGN,rcfi_tclSemanticDomain::EN_BASESIGNUNION));
         break;
      case fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_REGULATORYSIGN:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E16_REGULATORYSIGN,rcfi_tclSemanticDomain::EN_BASESIGNUNION));
         break;
      }
   } break;
   case rcfi_tclToken::EN_TRAFFICSIGNELEMENTUNION1:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_TrafficSignQuantifier oDataType;
      oCallStack.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_TRAFFICSIGNQUANTIFIER,rcfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_RESERVED,rcfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_KMPERHOUR,rcfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_MILESPERHOUR,rcfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_PERCENT,rcfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_LANEDEPENDENTVALIDITY,rcfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TIMEDEPENDENTSTRING,rcfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_YARDS,rcfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_CENTIMETER,rcfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_INCH,rcfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_KILOGRAM,rcfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_POUND,rcfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      }
   } break;
   case rcfi_tclToken::EN_TRAFFICSIGNELEMENT:
   {
      if (poVisitor->bDoExpand_TrafficSignElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ADDITIONALTRAFFICSIGN,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ADDITIONALSIGNLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TRAFFICSIGNELEMENTUNION1,rcfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TRAFFICSIGNELEMENTUNION0,rcfi_tclSemanticDomain::EN_BASESIGNUNION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_VIRTUALTRAFFICSIGN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_DYNAMICTRAFFICSIGN));
      }
      else
      {
         fi_tcl_TrafficSignElement o_TrafficSignElement;
         if (!bDoIt(o_TrafficSignElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficSignElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficSignElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_ROADINFOCOMBINATION:
   {
      if (poVisitor->bDoExpand_RoadInfoCombination(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_ID));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_LENGTH));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_STARTOFFSET));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_INFOELEMENT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_ROADELEMENT));
      }
      else
      {
         fi_tcl_RoadInfoCombination o_RoadInfoCombination;
         if (!bDoIt(o_RoadInfoCombination))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadInfoCombination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadInfoCombination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_TRAFFICSIGNLISTSET:
   {
      if (poVisitor->bDoExpand_TrafficSignListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TRAFFICSIGNELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_TRAFFICSIGNLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROADINFOCOMBINATION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_COMBINATIONLIST));
      }
      else
      {
         fi_tcl_TrafficSignListSet o_TrafficSignListSet;
         if (!bDoIt(o_TrafficSignListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficSignListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficSignListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_B32_POICATEGORY:
   {
      fi_tcl_b32_POICategory o_b32_POICategory;
      if (!bDoIt(o_b32_POICategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_POIELEMENT:
   {
      if (poVisitor->bDoExpand_POIElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_POSITION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_LOCATION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_ISLOCATIONVALID));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_NAME));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B32_POICATEGORY,rcfi_tclSemanticDomain::EN_CATEGORY));
      }
      else
      {
         fi_tcl_POIElement o_POIElement;
         if (!bDoIt(o_POIElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POIElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POIElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_POILISTSET:
   {
      if (poVisitor->bDoExpand_POIListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POIELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_POILIST));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REFERENCEELEMENTWITHID,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ALTERNATIVREFIDLIST));
         }
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REFERENCEELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
         }
      }
      else
      {
         fi_tcl_POIListSet o_POIListSet;
         if (!bDoIt(o_POIListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POIListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POIListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_B8_INSTRUCTIONSTATUS:
   {
      fi_tcl_b8_InstructionStatus o_b8_InstructionStatus;
      if (!bDoIt(o_b8_InstructionStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_SIMPLEINSTRUCTION:
   {
      if (poVisitor->bDoExpand_SimpleInstruction(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (31 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_INSTRUCTIONSTATUS,rcfi_tclSemanticDomain::EN_STATUS));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_SIDEINFO,rcfi_tclSemanticDomain::EN_TRAFFICSENSE));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_DIRECTIONRELATIVE,rcfi_tclSemanticDomain::EN_TURNDIRECTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_INTERSECTIONTYPE,rcfi_tclSemanticDomain::EN_INTERSECTIONTYPE));
      }
      else
      {
         fi_tcl_SimpleInstruction o_SimpleInstruction;
         if (!bDoIt(o_SimpleInstruction))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SimpleInstruction.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SimpleInstruction.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_SIMPLEINSTRUCTIONLISTSET:
   {
      if (poVisitor->bDoExpand_SimpleInstructionListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_SIMPLEINSTRUCTION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_SIMPLEINSTRUCTIONLIST));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REFERENCEELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
         }
      }
      else
      {
         fi_tcl_SimpleInstructionListSet o_SimpleInstructionListSet;
         if (!bDoIt(o_SimpleInstructionListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SimpleInstructionListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SimpleInstructionListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_SECTIONCHARACTERISTICS:
   {
      if (poVisitor->bDoExpand_SectionCharacteristics(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_MICROLITER,rcfi_tclSemanticDomain::EN_FUELNOTRAFFIC));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_MICROLITER,rcfi_tclSemanticDomain::EN_FUELFULLTRAFFIC));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_MICROLITER,rcfi_tclSemanticDomain::EN_FUEL));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_TIMENOTRAFFIC));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_TIMEFULLTRAFFIC));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_TIME));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_LENGTH));
      }
      else
      {
         fi_tcl_SectionCharacteristics o_SectionCharacteristics;
         if (!bDoIt(o_SectionCharacteristics))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SectionCharacteristics.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SectionCharacteristics.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_MANOEUVRECRITICALITY:
   {
      fi_tcl_e8_ManoeuvreCriticality o_e8_ManoeuvreCriticality;
      if (!bDoIt(o_e8_ManoeuvreCriticality))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_B8_ROUTEPROPERTIES:
   {
      fi_tcl_b8_RouteProperties o_b8_RouteProperties;
      if (!bDoIt(o_b8_RouteProperties))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_MOSTWORSEMANOEUVREINFO:
   {
      if (poVisitor->bDoExpand_MostWorseManoeuvreInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_ROUTEPROPERTIES,rcfi_tclSemanticDomain::EN_ROUTEPROPERTIES));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_SECTIONCHARACTERISTICS,rcfi_tclSemanticDomain::EN_ROUTEDELTAVALUES));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_MANOEUVRECRITICALITY,rcfi_tclSemanticDomain::EN_CRITICALITY));
      }
      else
      {
         fi_tcl_MostWorseManoeuvreInfo o_MostWorseManoeuvreInfo;
         if (!bDoIt(o_MostWorseManoeuvreInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MostWorseManoeuvreInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MostWorseManoeuvreInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_CRITICALDECISIONPOINTLISTELEMENT:
   {
      if (poVisitor->bDoExpand_CriticalDecisionPointListElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MOSTWORSEMANOEUVREINFO,rcfi_tclSemanticDomain::EN_MOSTWORSEMANOEUVREINFO));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_MOSTWORSENAVINSTRUCTION));
      }
      else
      {
         fi_tcl_CriticalDecisionPointListElement o_CriticalDecisionPointListElement;
         if (!bDoIt(o_CriticalDecisionPointListElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CriticalDecisionPointListElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CriticalDecisionPointListElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_CRITICALDECISIONPOINTLISTSET:
   {
      if (poVisitor->bDoExpand_CriticalDecisionPointListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CRITICALDECISIONPOINTLISTELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_CRITICALDECISIONPOINTLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REFERENCEELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
      }
      else
      {
         fi_tcl_CriticalDecisionPointListSet o_CriticalDecisionPointListSet;
         if (!bDoIt(o_CriticalDecisionPointListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CriticalDecisionPointListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CriticalDecisionPointListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_TOLLBOOTHELEMENT:
   {
      if (poVisitor->bDoExpand_TollBoothElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_TOLLBOOTHPOSITION));
      }
      else
      {
         fi_tcl_TollBoothElement o_TollBoothElement;
         if (!bDoIt(o_TollBoothElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TollBoothElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TollBoothElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_TOLLBOOTHLISTSET:
   {
      if (poVisitor->bDoExpand_TollBoothListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TOLLBOOTHELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_TOLLBOOTHELEMENTLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REFERENCEELEMENTWITHID,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ALTERNATIVREFIDLIST));
      }
      else
      {
         fi_tcl_TollBoothListSet o_TollBoothListSet;
         if (!bDoIt(o_TollBoothListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TollBoothListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TollBoothListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_CITYDISTRICTNAMELISTSET:
   {
      if (poVisitor->bDoExpand_CityDistrictNameListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CITYDISTRICTNAMEELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_CITYDISTRICTNAMEREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ELEMENTINREFLIST));
      }
      else
      {
         fi_tcl_CityDistrictNameListSet o_CityDistrictNameListSet;
         if (!bDoIt(o_CityDistrictNameListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityDistrictNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityDistrictNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_POINTOFINTERESTELEMENT:
   {
      if (poVisitor->bDoExpand_PointOfInterestElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B32_POICATEGORY,rcfi_tclSemanticDomain::EN_CATEGORY));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_NAME));
      }
      else
      {
         fi_tcl_PointOfInterestElement o_PointOfInterestElement;
         if (!bDoIt(o_PointOfInterestElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PointOfInterestElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PointOfInterestElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_UNSPECIFIEDTEXT:
   {
      if (poVisitor->bDoExpand_UnspecifiedText(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_DESCRIPTION));
      }
      else
      {
         fi_tcl_UnspecifiedText o_UnspecifiedText;
         if (!bDoIt(o_UnspecifiedText))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UnspecifiedText.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UnspecifiedText.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_U16_TRIPHANDLE:
   {
      fi_tcl_u16_TripHandle o_u16_TripHandle;
      if (!bDoIt(o_u16_TripHandle))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER:
   {
      fi_tcl_u16_TripSegmentNumber o_u16_TripSegmentNumber;
      if (!bDoIt(o_u16_TripSegmentNumber))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_U16_ROUTEHANDLE:
   {
      fi_tcl_u16_RouteHandle o_u16_RouteHandle;
      if (!bDoIt(o_u16_RouteHandle))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_B8_ROUTESEGMENTCLTYPES:
   {
      fi_tcl_b8_RouteSegmentCLTypes o_b8_RouteSegmentCLTypes;
      if (!bDoIt(o_b8_RouteSegmentCLTypes))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_ROUTESEGMENTCLUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_b8_RouteSegmentCLTypes oDataMask;
      oCallStack.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_ROUTESEGMENTCLTYPES,rcfi_tclSemanticDomain::EN_DATA_MASK));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataMask);
      oCallStack.bGoUp();
      if (oDataMask.u8Value & fi_tcl_b8_RouteSegmentCLTypes::FI_C_U8_BIT_T_DESTINATIONCL)
      {
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DESTINATIONCL,rcfi_tclSemanticDomain::EN_CLUSTERLISTS));
      }
      if (oDataMask.u8Value & fi_tcl_b8_RouteSegmentCLTypes::FI_C_U8_BIT_T_DESTINATIONBRANCHCL)
      {
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DESTINATIONBRANCHCL,rcfi_tclSemanticDomain::EN_CLUSTERLISTS));
      }
      if (oDataMask.u8Value & fi_tcl_b8_RouteSegmentCLTypes::FI_C_U8_BIT_T_LOCATIONBRANCHCL)
      {
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LOCATIONBRANCHCL,rcfi_tclSemanticDomain::EN_CLUSTERLISTS));
      }
   } break;
   case rcfi_tclToken::EN_ROUTESEGMENTCL:
   {
      if (poVisitor->bDoExpand_RouteSegmentCL(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROUTESEGMENTCLUNION0,rcfi_tclSemanticDomain::EN_CLUSTERLISTS));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_ROUTESEGMENTNUMBER));
      }
      else
      {
         fi_tcl_RouteSegmentCL o_RouteSegmentCL;
         if (!bDoIt(o_RouteSegmentCL))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteSegmentCL.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteSegmentCL.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_LOCATIONBRANCHCL:
   {
      if (poVisitor->bDoExpand_LocationBranchCL(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVCLUSTERDESC,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_LOCATIONBRANCHCL));
      }
      else
      {
         fi_tcl_LocationBranchCL o_LocationBranchCL;
         if (!bDoIt(o_LocationBranchCL))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocationBranchCL.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocationBranchCL.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_DESTINATIONBRANCHCL:
   {
      if (poVisitor->bDoExpand_DestinationBranchCL(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVCLUSTERDESC,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_DESTINATIONBRANCHCL));
      }
      else
      {
         fi_tcl_DestinationBranchCL o_DestinationBranchCL;
         if (!bDoIt(o_DestinationBranchCL))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DestinationBranchCL.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DestinationBranchCL.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_DESTINATIONCL:
   {
      if (poVisitor->bDoExpand_DestinationCL(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVCLUSTERDESC,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_DESTCLUSTERLIST));
      }
      else
      {
         fi_tcl_DestinationCL o_DestinationCL;
         if (!bDoIt(o_DestinationCL))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DestinationCL.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DestinationCL.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_S32_MEMU:
   {
      fi_tcl_s32_MEMU o_s32_MEMU;
      if (!bDoIt(o_s32_MEMU))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_S16_EAU:
   {
      fi_tcl_s16_EAU o_s16_EAU;
      if (!bDoIt(o_s16_EAU))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_NAVPOSONECELLPROPERTY:
   {
      if (poVisitor->bDoExpand_NavPosOneCellProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_STATECODE));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B32_ROADPROPERTY,rcfi_tclSemanticDomain::EN_ONECELLSTATUS));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_ROADNETWORKCLASS,rcfi_tclSemanticDomain::EN_ROADNETWORKCLASS));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_NAVSTREETTYPE,rcfi_tclSemanticDomain::EN_ROADTYPE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_ROADCLASSCODE,rcfi_tclSemanticDomain::EN_ROADCLASS));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_EMU,rcfi_tclSemanticDomain::EN_ONECELLLENGTH));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E16_ISOCOUNTRYCODE,rcfi_tclSemanticDomain::EN_COUNTRYCODE));
      }
      else
      {
         fi_tcl_NavPosOneCellProperty o_NavPosOneCellProperty;
         if (!bDoIt(o_NavPosOneCellProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavPosOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavPosOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVPOSONECELLSECTIONDESCRIPTION:
   {
      if (poVisitor->bDoExpand_NavPosOnecellSectionDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_SECTIONINDEX));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVPOSONECELLPROPERTY,rcfi_tclSemanticDomain::EN_ONECELLPROPERTY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVONECELLDESC,rcfi_tclSemanticDomain::EN_ONECELL));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVCLUSTERDESC,rcfi_tclSemanticDomain::EN_CLUSTER));
      }
      else
      {
         fi_tcl_NavPosOnecellSectionDescription o_NavPosOnecellSectionDescription;
         if (!bDoIt(o_NavPosOnecellSectionDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavPosOnecellSectionDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavPosOnecellSectionDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_ENTRYPOINTSTATE:
   {
      fi_tcl_e8_EntryPointState o_e8_EntryPointState;
      if (!bDoIt(o_e8_EntryPointState))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_U32_RESISTANCE:
   {
      fi_tcl_u32_Resistance o_u32_Resistance;
      if (!bDoIt(o_u32_Resistance))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_ENTRYPOINT:
   {
      if (poVisitor->bDoExpand_EntryPoint(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_RESISTANCE,rcfi_tclSemanticDomain::EN_RESISTANCEMANIPULATOR));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_MEMU,rcfi_tclSemanticDomain::EN_LENGTHTOONECELLEND));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVPOSONECELLSECTIONDESCRIPTION,rcfi_tclSemanticDomain::EN_ONECELLSECTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_EAU,rcfi_tclSemanticDomain::EN_MAPANGLE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_POSITIONCOORD));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_ENTRYPOINTSTATE,rcfi_tclSemanticDomain::EN_ENTRYPOINTSTATUS));
      }
      else
      {
         fi_tcl_EntryPoint o_EntryPoint;
         if (!bDoIt(o_EntryPoint))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EntryPoint.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EntryPoint.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_POSITIONDESCRIPTION:
   {
      if (poVisitor->bDoExpand_PositionDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_INDEXINHORIZON));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_EAU,rcfi_tclSemanticDomain::EN_MAPANGLE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_EAU,rcfi_tclSemanticDomain::EN_ICOURSE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_MEMU,rcfi_tclSemanticDomain::EN_LENGTHTOINTERSECTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVPOSONECELLSECTIONDESCRIPTION,rcfi_tclSemanticDomain::EN_ONECELLSECTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_POSITIONCOORD));
      }
      else
      {
         fi_tcl_PositionDescription o_PositionDescription;
         if (!bDoIt(o_PositionDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_NAVLOCATIONDESCTYPE:
   {
      fi_tcl_e8_NavLocationDescType o_e8_NavLocationDescType;
      if (!bDoIt(o_e8_NavLocationDescType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_NAVLOCATIONDESCUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_NavLocationDescType oDataType;
      oCallStack.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_NAVLOCATIONDESCTYPE,rcfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_RESERVED:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_RESERVED,rcfi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
         break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVLOCATIONDATADESC:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVLOCATIONDATADESC,rcfi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
         break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONCIRCLE:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVAREADESCRIPTIONCIRCLE,rcfi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
         break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONPOLYGON:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVAREADESCRIPTIONPOLYGON,rcfi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
         break;
      }
   } break;
   case rcfi_tclToken::EN_NAVLOCATIONDESC:
   {
      if (poVisitor->bDoExpand_NavLocationDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVLOCATIONDESCUNION0,rcfi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
      }
      else
      {
         fi_tcl_NavLocationDesc o_NavLocationDesc;
         if (!bDoIt(o_NavLocationDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#ifndef FI_S_EXTERNAL_FI
   case rcfi_tclToken::EN_NAVLOCATIONBINCONTAINER:
   {
      if (poVisitor->bDoExpand_NavLocationBinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         bInsideBinContainerVersion = true;
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_BINCONTAINER));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVLOCATIONDESC,rcfi_tclSemanticDomain::EN_CONTAINERDATA));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_BINCONTAINERTYPES,rcfi_tclSemanticDomain::EN_CONTAINERTYPE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_FIVERSION,rcfi_tclSemanticDomain::EN_CONTAINERFIVERSION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_SERVICEID));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_CONTAINERLENGTH));
      }
      else
      {
         fi_tcl_NavLocationBinContainer o_NavLocationBinContainer;
         if (!bDoIt(o_NavLocationBinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#endif // FI_S_EXTERNAL_FI
   case rcfi_tclToken::EN_E8_NAVINDEXZFDESTINATIONTYPE:
   {
      fi_tcl_e8_NavIndexZFDestinationType o_e8_NavIndexZFDestinationType;
      if (!bDoIt(o_e8_NavIndexZFDestinationType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_NAVLOCATIONNAVDATATYPE:
   {
      fi_tcl_e8_NavLocationNavDataType o_e8_NavLocationNavDataType;
      if (!bDoIt(o_e8_NavLocationNavDataType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_NAVLOCATIONDATADESCUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_NavLocationNavDataType oDataType;
      oCallStack.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_NAVLOCATIONNAVDATATYPE,rcfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_RESERVED:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_RESERVED,rcfi_tclSemanticDomain::EN_NAVDATATYPE));
         break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET,rcfi_tclSemanticDomain::EN_NAVDATATYPE));
         break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSTREETDESTINATIONONECELLLISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVSTREETDESTINATIONONECELLLISTSET,rcfi_tclSemanticDomain::EN_NAVDATATYPE));
         break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSPOTDESTINATIONONECELLLISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVSPOTDESTINATIONONECELLLISTSET,rcfi_tclSemanticDomain::EN_NAVDATATYPE));
         break;
      }
   } break;
   case rcfi_tclToken::EN_NAVLOCATIONDATADESC:
   {
      if (poVisitor->bDoExpand_NavLocationDataDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVLOCATIONDATADESCUNION0,rcfi_tclSemanticDomain::EN_NAVDATATYPE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ACCESSPOINTREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_OBJECTPOINTREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_NAVINDEXZFDESTINATIONTYPE,rcfi_tclSemanticDomain::EN_INDEXZFDESTTYPE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_DATASETID,rcfi_tclSemanticDomain::EN_NAVDATASETID));
      }
      else
      {
         fi_tcl_NavLocationDataDesc o_NavLocationDataDesc;
         if (!bDoIt(o_NavLocationDataDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationDataDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationDataDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVSPOTDESTINATIONONECELLPROPERTY:
   {
      if (poVisitor->bDoExpand_NavSpotDestinationOneCellProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_INDEXINACCESSPOINTREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_INDEXINOBJECTPOINTREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_DECISIONPOINT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_EMU,rcfi_tclSemanticDomain::EN_DESTDISTANCE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_EMU,rcfi_tclSemanticDomain::EN_ONECELLLENGTH));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_EMU,rcfi_tclSemanticDomain::EN_FROMZEROCELLTOSPOTLENGTH));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_SIDEINFO,rcfi_tclSemanticDomain::EN_SIDEINFO));
      }
      else
      {
         fi_tcl_NavSpotDestinationOneCellProperty o_NavSpotDestinationOneCellProperty;
         if (!bDoIt(o_NavSpotDestinationOneCellProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVSPOTDESTINATIONONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavSpotDestinationOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVSPOTDESTINATIONONECELLPROPERTY,rcfi_tclSemanticDomain::EN_ONECELLPROPERTY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVONECELLDESC,rcfi_tclSemanticDomain::EN_ONECELLDESC));
      }
      else
      {
         fi_tcl_NavSpotDestinationOneCellDesc o_NavSpotDestinationOneCellDesc;
         if (!bDoIt(o_NavSpotDestinationOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVSPOTDESTINATIONONECELLLISTSET:
   {
      if (poVisitor->bDoExpand_NavSpotDestinationOneCellListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVSPOTDESTINATIONONECELLDESC,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_SPOTDESTINATIONONECELLREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVCLUSTERDESC,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_CLUSTERREFLIST));
      }
      else
      {
         fi_tcl_NavSpotDestinationOneCellListSet o_NavSpotDestinationOneCellListSet;
         if (!bDoIt(o_NavSpotDestinationOneCellListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVSTREETDESTINATIONONECELLPROPERTY:
   {
      if (poVisitor->bDoExpand_NavStreetDestinationOneCellProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_INDEXINACCESSPOINTREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_INDEXINOBJECTPOINTREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_SIDEINFO,rcfi_tclSemanticDomain::EN_SIDEINFO));
      }
      else
      {
         fi_tcl_NavStreetDestinationOneCellProperty o_NavStreetDestinationOneCellProperty;
         if (!bDoIt(o_NavStreetDestinationOneCellProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVSTREETDESTINATIONONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavStreetDestinationOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVSTREETDESTINATIONONECELLPROPERTY,rcfi_tclSemanticDomain::EN_ONECELLPROPERTY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVONECELLDESC,rcfi_tclSemanticDomain::EN_ONECELLDESC));
      }
      else
      {
         fi_tcl_NavStreetDestinationOneCellDesc o_NavStreetDestinationOneCellDesc;
         if (!bDoIt(o_NavStreetDestinationOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVSTREETDESTINATIONONECELLLISTSET:
   {
      if (poVisitor->bDoExpand_NavStreetDestinationOneCellListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVSTREETDESTINATIONONECELLDESC,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_STREETDESTINATIONONECELLREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVCLUSTERDESC,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_CLUSTERREFLIST));
      }
      else
      {
         fi_tcl_NavStreetDestinationOneCellListSet o_NavStreetDestinationOneCellListSet;
         if (!bDoIt(o_NavStreetDestinationOneCellListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_NAVINTERSECTIONTYPE:
   {
      fi_tcl_e8_NavIntersectionType o_e8_NavIntersectionType;
      if (!bDoIt(o_e8_NavIntersectionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLPROPERTY:
   {
      if (poVisitor->bDoExpand_NavIntersectionDestinationZeroCellProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_INDEXINACCESSPOINTREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_INDEXINOBJECTPOINTREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_NAVINTERSECTIONTYPE,rcfi_tclSemanticDomain::EN_INTERSECTIONTYPE));
      }
      else
      {
         fi_tcl_NavIntersectionDestinationZeroCellProperty o_NavIntersectionDestinationZeroCellProperty;
         if (!bDoIt(o_NavIntersectionDestinationZeroCellProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLDESC:
   {
      if (poVisitor->bDoExpand_NavIntersectionDestinationZeroCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLPROPERTY,rcfi_tclSemanticDomain::EN_ZEROCELLPROPERTY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVZEROCELLDESC,rcfi_tclSemanticDomain::EN_ZEROCELLDESC));
      }
      else
      {
         fi_tcl_NavIntersectionDestinationZeroCellDesc o_NavIntersectionDestinationZeroCellDesc;
         if (!bDoIt(o_NavIntersectionDestinationZeroCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
   {
      if (poVisitor->bDoExpand_NavIntersectionDestinationZeroCellListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLDESC,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_INTERSECTIONDESTINATIONZEROCELLREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVCLUSTERDESC,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_CLUSTERREFLIST));
      }
      else
      {
         fi_tcl_NavIntersectionDestinationZeroCellListSet o_NavIntersectionDestinationZeroCellListSet;
         if (!bDoIt(o_NavIntersectionDestinationZeroCellListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVAREADESCRIPTIONCIRCLE:
   {
      if (poVisitor->bDoExpand_NavAreaDescriptionCircle(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_COORDINATE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_RADIUS));
      }
      else
      {
         fi_tcl_NavAreaDescriptionCircle o_NavAreaDescriptionCircle;
         if (!bDoIt(o_NavAreaDescriptionCircle))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAreaDescriptionCircle.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAreaDescriptionCircle.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVAREADESCRIPTIONPOLYGON:
   {
      if (poVisitor->bDoExpand_NavAreaDescriptionPolygon(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_COORDINATELIST));
      }
      else
      {
         fi_tcl_NavAreaDescriptionPolygon o_NavAreaDescriptionPolygon;
         if (!bDoIt(o_NavAreaDescriptionPolygon))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAreaDescriptionPolygon.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAreaDescriptionPolygon.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVDLDCHAINONECELLPROPERTY:
   {
      if (poVisitor->bDoExpand_NavDLDChainOneCellProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_TURNLENGTHONFOLLOWINGINTERSECTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_LENGTHFROMFIRSTOC));
      }
      else
      {
         fi_tcl_NavDLDChainOneCellProperty o_NavDLDChainOneCellProperty;
         if (!bDoIt(o_NavDLDChainOneCellProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavDLDChainOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavDLDChainOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVDLDCHAINONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavDLDChainOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVDLDCHAINONECELLPROPERTY,rcfi_tclSemanticDomain::EN_ONECELLPROPERTY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVONECELLDESC,rcfi_tclSemanticDomain::EN_ONECELLDESC));
      }
      else
      {
         fi_tcl_NavDLDChainOneCellDesc o_NavDLDChainOneCellDesc;
         if (!bDoIt(o_NavDLDChainOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavDLDChainOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavDLDChainOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVDLDCHAINONECELLLISTSET:
   {
      if (poVisitor->bDoExpand_NavDLDChainOneCellListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVDLDCHAINONECELLDESC,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ONECELLREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVCLUSTERDESC,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_CLUSTERREFLIST));
      }
      else
      {
         fi_tcl_NavDLDChainOneCellListSet o_NavDLDChainOneCellListSet;
         if (!bDoIt(o_NavDLDChainOneCellListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavDLDChainOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavDLDChainOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#ifndef FI_S_EXTERNAL_FI
   case rcfi_tclToken::EN_NAVUTMBINCONTAINER:
   {
      if (poVisitor->bDoExpand_NavUTMBinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         bInsideBinContainerVersion = true;
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_BINCONTAINER));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVDLDCHAINONECELLLISTSET,rcfi_tclSemanticDomain::EN_UTMONECELLLISTSET));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_DATASETID,rcfi_tclSemanticDomain::EN_NAVDATASETID));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_BINCONTAINERTYPES,rcfi_tclSemanticDomain::EN_CONTAINERTYPE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_FIVERSION,rcfi_tclSemanticDomain::EN_CONTAINERFIVERSION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_SERVICEID));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_CONTAINERLENGTH));
      }
      else
      {
         fi_tcl_NavUTMBinContainer o_NavUTMBinContainer;
         if (!bDoIt(o_NavUTMBinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavUTMBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavUTMBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#endif // FI_S_EXTERNAL_FI
   case rcfi_tclToken::EN_COUNTRYINFO:
   {
      if (poVisitor->bDoExpand_CountryInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_SIDEINFO,rcfi_tclSemanticDomain::EN_TRAFFICSENSE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E16_ISOCOUNTRYCODE,rcfi_tclSemanticDomain::EN_COUNTRYCODE));
      }
      else
      {
         fi_tcl_CountryInfo o_CountryInfo;
         if (!bDoIt(o_CountryInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVROUTEID:
   {
      if (poVisitor->bDoExpand_NavRouteId(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_RELEASENUMBER));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_TRIPSEGMENTNUMBER));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_ROUTEHANDLE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPHANDLE,rcfi_tclSemanticDomain::EN_TRIPHANDLE));
      }
      else
      {
         fi_tcl_NavRouteId o_NavRouteId;
         if (!bDoIt(o_NavRouteId))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRouteId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRouteId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_B32_NAVROUTESTATUS:
   {
      fi_tcl_b32_NavRouteStatus o_b32_NavRouteStatus;
      if (!bDoIt(o_b32_NavRouteStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_B32_EXTNAVROUTESTATUS:
   {
      fi_tcl_b32_ExtNavRouteStatus o_b32_ExtNavRouteStatus;
      if (!bDoIt(o_b32_ExtNavRouteStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_NAVROUTEINFO:
   {
      if (poVisitor->bDoExpand_NavRouteInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (7 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B32_EXTNAVROUTESTATUS,rcfi_tclSemanticDomain::EN_EXTINFOSTATUS));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B32_NAVROUTESTATUS,rcfi_tclSemanticDomain::EN_INFOSTATUS));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_MAXCLUSTERLEVEL));
      }
      else
      {
         fi_tcl_NavRouteInfo o_NavRouteInfo;
         if (!bDoIt(o_NavRouteInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRouteInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRouteInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVROUTECOMPARE:
   {
      if (poVisitor->bDoExpand_NavRouteCompare(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_NEWROUTETIME));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_OLDROUTETIMEAFTER));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_OLDROUTETIMEBEFORE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_EMU,rcfi_tclSemanticDomain::EN_NEWROUTELENGTH));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_EMU,rcfi_tclSemanticDomain::EN_OLDROUTELENGTH));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVROUTEID,rcfi_tclSemanticDomain::EN_OLDROUTEID));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_NEWBLOCKAGEONOLDROUTE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_ROUTELENGTHAREVALID));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_DRIVINGTIMESAREVALID));
      }
      else
      {
         fi_tcl_NavRouteCompare o_NavRouteCompare;
         if (!bDoIt(o_NavRouteCompare))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRouteCompare.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRouteCompare.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVROUTEINSTRUCTIONDESC:
   {
      if (poVisitor->bDoExpand_NavRouteInstructionDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (25 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_MANOEUVRECRITICALITY,rcfi_tclSemanticDomain::EN_MANOEUVRECRITICALITY));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_INDEXINFILENAMELIST));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_NEXTINSTRUCTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_NAVINSTRUCTION));
      }
      else
      {
         fi_tcl_NavRouteInstructionDesc o_NavRouteInstructionDesc;
         if (!bDoIt(o_NavRouteInstructionDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRouteInstructionDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRouteInstructionDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVROUTEDESTINATIONDESC:
   {
      if (poVisitor->bDoExpand_NavRouteDestinationDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_DECISIONPOINT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_OBJECTPOINT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_SUBDESTINATIONNUMBER));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_ISSPOTDESTINATION));
      }
      else
      {
         fi_tcl_NavRouteDestinationDesc o_NavRouteDestinationDesc;
         if (!bDoIt(o_NavRouteDestinationDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRouteDestinationDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRouteDestinationDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_B32_NAVROUTEONECELLSTATUS:
   {
      fi_tcl_b32_NavRouteOneCellStatus o_b32_NavRouteOneCellStatus;
      if (!bDoIt(o_b32_NavRouteOneCellStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_B32_EXTNAVROUTEONECELLSTATUS:
   {
      fi_tcl_b32_ExtNavRouteOneCellStatus o_b32_ExtNavRouteOneCellStatus;
      if (!bDoIt(o_b32_ExtNavRouteOneCellStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_NAVROUTEONECELLPROPERTIES:
   {
      if (poVisitor->bDoExpand_NavRouteOneCellProperties(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_GBWZ));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_ROSA));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_RESISTANCE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_ONECELLTIME));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_EMU,rcfi_tclSemanticDomain::EN_ONECELLLENGTH));
         if (25 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_ROUTETIMENOTRAFFIC));
         }
         if (25 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_ROUTETIMEFULLTRAFFIC));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_ROUTETIME));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_EMU,rcfi_tclSemanticDomain::EN_ROUTELENGTH));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_TIMEMANIPULATOR));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_STREETTYPE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_ROADCLASS));
         if (7 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B32_ROADPROPERTY,rcfi_tclSemanticDomain::EN_ROADPROPERTY));
         }
         if (7 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B32_EXTNAVROUTEONECELLSTATUS,rcfi_tclSemanticDomain::EN_EXTSTATUS));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B32_NAVROUTEONECELLSTATUS,rcfi_tclSemanticDomain::EN_STATUS));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_COORDOFTOZEROCELL));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_TRIPSEGMENTNUMBER));
      }
      else
      {
         fi_tcl_NavRouteOneCellProperties o_NavRouteOneCellProperties;
         if (!bDoIt(o_NavRouteOneCellProperties))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRouteOneCellProperties.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRouteOneCellProperties.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVROUTEONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavRouteOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_STATECODE));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVROUTEONECELLPROPERTIES,rcfi_tclSemanticDomain::EN_OCPROPERTIES));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_NEXTONECELLONPATH));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_COUNTRYCODE));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_DESTINATION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_INSTRUCTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVONECELLDESC,rcfi_tclSemanticDomain::EN_OCDESC));
      }
      else
      {
         fi_tcl_NavRouteOneCellDesc o_NavRouteOneCellDesc;
         if (!bDoIt(o_NavRouteOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRouteOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRouteOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVROUTELISTSET:
   {
      if (poVisitor->bDoExpand_NavRouteListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_STATECODEREFLIST));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_FILENAMEREFLIST));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_COUNTRYINFO,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_COUNTRYCODEREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVROUTEONECELLDESC,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ONECELLREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVROUTEDESTINATIONDESC,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_DESTINATIONREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVROUTEINSTRUCTIONDESC,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_INSTRUCTIONREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVCLUSTERDESC,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_CLUSTERREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_LASTKNOWNSTARTPOSONPATH));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVROUTECOMPARE,rcfi_tclSemanticDomain::EN_COMPARE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVROUTEINFO,rcfi_tclSemanticDomain::EN_INFO));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_DATASETID,rcfi_tclSemanticDomain::EN_NAVDATASETID));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVROUTEID,rcfi_tclSemanticDomain::EN_ID));
      }
      else
      {
         fi_tcl_NavRouteListSet o_NavRouteListSet;
         if (!bDoIt(o_NavRouteListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRouteListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRouteListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#ifndef FI_S_EXTERNAL_FI
   case rcfi_tclToken::EN_NAVROUTELISTBINCONTAINER:
   {
      if (poVisitor->bDoExpand_NavRouteListBinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         bInsideBinContainerVersion = true;
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_BINCONTAINER));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVROUTELISTSET,rcfi_tclSemanticDomain::EN_NAVROUTELISTSET));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_BINCONTAINERTYPES,rcfi_tclSemanticDomain::EN_CONTAINERTYPE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_FIVERSION,rcfi_tclSemanticDomain::EN_CONTAINERFIVERSION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_SERVICEID));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_CONTAINERLENGTH));
      }
      else
      {
         fi_tcl_NavRouteListBinContainer o_NavRouteListBinContainer;
         if (!bDoIt(o_NavRouteListBinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRouteListBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRouteListBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#endif // FI_S_EXTERNAL_FI
   case rcfi_tclToken::EN_TMINFO:
   {
      if (poVisitor->bDoExpand_TMInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_TMGEOGRAPHICALPATHRELATIONTYPE,rcfi_tclSemanticDomain::EN_GEOGRAPHICALPATHRELATION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSIXTIME,rcfi_tclSemanticDomain::EN_LATESTDECODETIME));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSIXTIME,rcfi_tclSemanticDomain::EN_STOPTIME));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSIXTIME,rcfi_tclSemanticDomain::EN_STARTTIME));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_INDEXINSERVICEPROVIDERLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_INDICESINPROGRAMSERVICELIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_BIDIRECTIONAL));
         if (32 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_DIRECTIONAGAINSTTMC));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_RDBID,rcfi_tclSemanticDomain::EN_RDBID));
         if (32 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TMCSTRUCTUREDTEXT,rcfi_tclSemanticDomain::EN_ROADNAME));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROADNUMBER,rcfi_tclSemanticDomain::EN_ROADNUMBER));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_ROADCLASSCODE,rcfi_tclSemanticDomain::EN_ROADCLASS));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_PREFIXPRIORITY));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_LOCATIONSEGMENTIDX));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_SEGMENTID));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_TMURGENCY,rcfi_tclSemanticDomain::EN_URGENCYOFEVENT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_USERTRAFFICMESSAGEHANDLE,rcfi_tclSemanticDomain::EN_UTMHANDLE));
         if (15 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_TMRELEVANCE,rcfi_tclSemanticDomain::EN_TMRELEVANCE));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B32_TRAFFICMESSAGESOURCE,rcfi_tclSemanticDomain::EN_TRAFFICINFOSOURCE));
         if (36 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_TMVALUESTATUS,rcfi_tclSemanticDomain::EN_LENGTHSTATUS));
         }
         if (30 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_LENGTH));
         }
         if (36 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_TMVALUESTATUS,rcfi_tclSemanticDomain::EN_DELAYSTATUS));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_DELAY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_SHAPE,rcfi_tclSemanticDomain::EN_SHAPE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_TMGEOMETRICMESSAGETYPE,rcfi_tclSemanticDomain::EN_GEOMETRICMESSAGETYPE));
         if (36 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_FLOWVALUE));
         }
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_TMFLOWIMPACT,rcfi_tclSemanticDomain::EN_TMFLOWIMPACT));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_TMCATEGORY,rcfi_tclSemanticDomain::EN_TMCATEGORY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_TMMAPPINGSTATUS,rcfi_tclSemanticDomain::EN_TMMAPPINGSTATUS));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_TMMAPPINGPOSSIBILITY,rcfi_tclSemanticDomain::EN_TMMAPPINGPOSSIBILITY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TMEVENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_EVENTLIST));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_TRAFFICMSGTYPE,rcfi_tclSemanticDomain::EN_MESSAGETYPE));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_TRAFFICMESSAGEID));
      }
      else
      {
         fi_tcl_TMInfo o_TMInfo;
         if (!bDoIt(o_TMInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_TMINFOLISTSET:
   {
      if (poVisitor->bDoExpand_TMInfoListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TMCOMBINATION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_TMCOMBINATION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TMSERVICEPROVIDER,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_SERVICEPROVIDERLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TMPROGRAMSERVICE,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_PROGRAMSERVICELIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TMINFO,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_TMINFO));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BINCONTAINER,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_TMCODEDTEXTMESSAGE));
      }
      else
      {
         fi_tcl_TMInfoListSet o_TMInfoListSet;
         if (!bDoIt(o_TMInfoListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMInfoListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMInfoListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_LANESTATUS:
   {
      fi_tcl_e8_LaneStatus o_e8_LaneStatus;
      if (!bDoIt(o_e8_LaneStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_B8_LANETYPE:
   {
      fi_tcl_b8_LaneType o_b8_LaneType;
      if (!bDoIt(o_b8_LaneType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_B8_LANECHANGERESTRICTION:
   {
      fi_tcl_b8_LaneChangeRestriction o_b8_LaneChangeRestriction;
      if (!bDoIt(o_b8_LaneChangeRestriction))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_U8_INDEXINLANEINFOSEGMENTLIST:
   {
      fi_tcl_u8_IndexInLaneInfoSegmentList o_u8_IndexInLaneInfoSegmentList;
      if (!bDoIt(o_u8_IndexInLaneInfoSegmentList))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_U8_INDEXINLANEINFOLIST:
   {
      fi_tcl_u8_IndexInLaneInfoList o_u8_IndexInLaneInfoList;
      if (!bDoIt(o_u8_IndexInLaneInfoList))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_U8_DRIVINGDIRECTION:
   {
      fi_tcl_u8_DrivingDirection o_u8_DrivingDirection;
      if (!bDoIt(o_u8_DrivingDirection))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_LANEDIRECTION:
   {
      if (poVisitor->bDoExpand_LaneDirection(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_LANETYPE,rcfi_tclSemanticDomain::EN_FOLLOWINGLANETYPE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_LANESTATUS,rcfi_tclSemanticDomain::EN_FOLLOWINGLANESTATUS));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_DRIVINGDIRECTION,rcfi_tclSemanticDomain::EN_DIRECTIONTOFOLLOWINGLANE));
      }
      else
      {
         fi_tcl_LaneDirection o_LaneDirection;
         if (!bDoIt(o_LaneDirection))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneDirection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneDirection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_LANEINFOONECELLREFERENCE:
   {
      if (poVisitor->bDoExpand_LaneInfoOneCellReference(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_INDEXINLANEINFOLIST,rcfi_tclSemanticDomain::EN_LANEINDEX));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_INDEXINLANEINFOSEGMENTLIST,rcfi_tclSemanticDomain::EN_SEGMENTINDEX));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVONECELL,rcfi_tclSemanticDomain::EN_ONECELL));
      }
      else
      {
         fi_tcl_LaneInfoOneCellReference o_LaneInfoOneCellReference;
         if (!bDoIt(o_LaneInfoOneCellReference))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoOneCellReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoOneCellReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_LANEINFOONECELLINDEXREFERENCE:
   {
      if (poVisitor->bDoExpand_LaneInfoOneCellIndexReference(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_INDEXINLANEINFOLIST,rcfi_tclSemanticDomain::EN_LANEINDEX));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_INDEXINLANEINFOSEGMENTLIST,rcfi_tclSemanticDomain::EN_SEGMENTINDEX));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_ONECELLINDEX));
      }
      else
      {
         fi_tcl_LaneInfoOneCellIndexReference o_LaneInfoOneCellIndexReference;
         if (!bDoIt(o_LaneInfoOneCellIndexReference))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoOneCellIndexReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoOneCellIndexReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_LANEINFOPATHSECTIONINDEXREFERENCE:
   {
      if (poVisitor->bDoExpand_LaneInfoPathSectionIndexReference(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_INDEXINLANEINFOLIST,rcfi_tclSemanticDomain::EN_LANEINDEX));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_INDEXINLANEINFOSEGMENTLIST,rcfi_tclSemanticDomain::EN_SEGMENTINDEX));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_PATHSECTIONINDEX));
      }
      else
      {
         fi_tcl_LaneInfoPathSectionIndexReference o_LaneInfoPathSectionIndexReference;
         if (!bDoIt(o_LaneInfoPathSectionIndexReference))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoPathSectionIndexReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoPathSectionIndexReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_LANEINFOELEMENTREFERENCE:
   {
      if (poVisitor->bDoExpand_LaneInfoElementReference(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_INDEXINLANEINFOLIST,rcfi_tclSemanticDomain::EN_LANEINDEX));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_ELEMENTID));
      }
      else
      {
         fi_tcl_LaneInfoElementReference o_LaneInfoElementReference;
         if (!bDoIt(o_LaneInfoElementReference))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoElementReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoElementReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_LANEREFERENCECATEGORY:
   {
      fi_tcl_e8_LaneReferenceCategory o_e8_LaneReferenceCategory;
      if (!bDoIt(o_e8_LaneReferenceCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_LANEREFERENCEUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_LaneReferenceCategory oDataType;
      oCallStack.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_LANEREFERENCECATEGORY,rcfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOPATHSECTIONINDEXREFERENCE) &&
          !(11 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOONECELLINDEXREFERENCE;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_RESERVED,rcfi_tclSemanticDomain::EN_LANEREFERENCECATEGORY));
         break;
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOONECELLREFERENCE:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LANEINFOONECELLREFERENCE,rcfi_tclSemanticDomain::EN_LANEREFERENCECATEGORY));
         break;
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOONECELLINDEXREFERENCE:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LANEINFOONECELLINDEXREFERENCE,rcfi_tclSemanticDomain::EN_LANEREFERENCECATEGORY));
         break;
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOELEMENTREFERENCE:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LANEINFOELEMENTREFERENCE,rcfi_tclSemanticDomain::EN_LANEREFERENCECATEGORY));
         break;
      case fi_tcl_e8_LaneReferenceCategory::FI_EN_T_LANEINFOPATHSECTIONINDEXREFERENCE:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LANEINFOPATHSECTIONINDEXREFERENCE,rcfi_tclSemanticDomain::EN_LANEREFERENCECATEGORY));
         break;
      }
   } break;
   case rcfi_tclToken::EN_LANEREFERENCE:
   {
      if (poVisitor->bDoExpand_LaneReference(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LANEDIRECTION,rcfi_tclSemanticDomain::EN_LANEDIRECTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LANEREFERENCEUNION0,rcfi_tclSemanticDomain::EN_LANEREFERENCECATEGORY));
      }
      else
      {
         fi_tcl_LaneReference o_LaneReference;
         if (!bDoIt(o_LaneReference))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_LANEINFO:
   {
      if (poVisitor->bDoExpand_LaneInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LANEREFERENCE,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_FOLLOWINGLANELIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_LANECHANGERESTRICTION,rcfi_tclSemanticDomain::EN_CHANGERESTRICTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_LANETYPE,rcfi_tclSemanticDomain::EN_TYPE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_LANESTATUS,rcfi_tclSemanticDomain::EN_STATUS));
      }
      else
      {
         fi_tcl_LaneInfo o_LaneInfo;
         if (!bDoIt(o_LaneInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_LANEINFOSEGMENT:
   {
      if (poVisitor->bDoExpand_LaneInfoSegment(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LANEINFO,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_LANEINFOLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_EMU,rcfi_tclSemanticDomain::EN_OFFSET));
      }
      else
      {
         fi_tcl_LaneInfoSegment o_LaneInfoSegment;
         if (!bDoIt(o_LaneInfoSegment))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoSegment.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoSegment.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_LANEINFOSEGMENTLIST:
   {
      if (poVisitor->bDoExpand_LaneInfoSegmentList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LANEINFOSEGMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_LANEINFOSEGMENTLIST));
      }
      else
      {
         fi_tcl_LaneInfoSegmentList o_LaneInfoSegmentList;
         if (!bDoIt(o_LaneInfoSegmentList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoSegmentList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoSegmentList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_LANEINFOLISTSET:
   {
      if (poVisitor->bDoExpand_LaneInfoListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LANEINFOSEGMENTLIST,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_LANEINFOSEGMENTLISTLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REFERENCEELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
      }
      else
      {
         fi_tcl_LaneInfoListSet o_LaneInfoListSet;
         if (!bDoIt(o_LaneInfoListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LaneInfoListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_ENTRYEXITTYPE:
   {
      fi_tcl_e8_EntryExitType o_e8_EntryExitType;
      if (!bDoIt(o_e8_EntryExitType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_ENTRYEXITCOORDINATES:
   {
      if (poVisitor->bDoExpand_EntryExitCoordinates(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_COORDINATE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_ENTRYEXITTYPE,rcfi_tclSemanticDomain::EN_TYPE));
      }
      else
      {
         fi_tcl_EntryExitCoordinates o_EntryExitCoordinates;
         if (!bDoIt(o_EntryExitCoordinates))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EntryExitCoordinates.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EntryExitCoordinates.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_ENTRYEXITPOINTLISTSET:
   {
      if (poVisitor->bDoExpand_EntryExitPointListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ENTRYEXITCOORDINATES,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ENTRYEXITPOINTLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REFERENCEELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
      }
      else
      {
         fi_tcl_EntryExitPointListSet o_EntryExitPointListSet;
         if (!bDoIt(o_EntryExitPointListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EntryExitPointListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EntryExitPointListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_WGS84COORDINATELIST:
   {
      if (poVisitor->bDoExpand_WGS84CoordinateList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_WGS84COORDINATELIST));
      }
      else
      {
         fi_tcl_WGS84CoordinateList o_WGS84CoordinateList;
         if (!bDoIt(o_WGS84CoordinateList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WGS84CoordinateList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WGS84CoordinateList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_SHAPEPOINTLISTSET:
   {
      if (poVisitor->bDoExpand_ShapePointListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_WGS84COORDINATELIST,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_SHAPEPOINTLISTLIST));
      }
      else
      {
         fi_tcl_ShapePointListSet o_ShapePointListSet;
         if (!bDoIt(o_ShapePointListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ShapePointListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ShapePointListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_DEPICTIONAREA:
   {
      fi_tcl_e8_DepictionArea o_e8_DepictionArea;
      if (!bDoIt(o_e8_DepictionArea))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_DEPICTIONAREAUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_DepictionArea oDataType;
      oCallStack.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_DEPICTIONAREA,rcfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_DepictionArea::FI_EN_T_RESERVED:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_RESERVED,rcfi_tclSemanticDomain::EN_DEPICTIONAREA));
         break;
      case fi_tcl_e8_DepictionArea::FI_EN_T_DEPICTCOMPLETE:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DEPICTCOMPLETE,rcfi_tclSemanticDomain::EN_DEPICTIONAREA));
         break;
      case fi_tcl_e8_DepictionArea::FI_EN_T_DEPICTLENGTH:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DEPICTLENGTH,rcfi_tclSemanticDomain::EN_DEPICTIONAREA));
         break;
      case fi_tcl_e8_DepictionArea::FI_EN_T_DEPICTPOLYGON:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DEPICTPOLYGON,rcfi_tclSemanticDomain::EN_DEPICTIONAREA));
         break;
      }
   } break;
   case rcfi_tclToken::EN_DEPICTIONAREA:
   {
      if (poVisitor->bDoExpand_DepictionArea(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DEPICTIONAREAUNION0,rcfi_tclSemanticDomain::EN_DEPICTIONAREA));
      }
      else
      {
         fi_tcl_DepictionArea o_DepictionArea;
         if (!bDoIt(o_DepictionArea))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DepictionArea.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DepictionArea.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_DEPICTCOMPLETE:
   {
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_DEPICTLENGTH:
   {
      if (poVisitor->bDoExpand_DepictLength(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_DEPICTIONLENGTH));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_DEPICTIONSTARTOFFSETLENGTH));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_DEPICTIONSTARTELEMENT));
      }
      else
      {
         fi_tcl_DepictLength o_DepictLength;
         if (!bDoIt(o_DepictLength))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DepictLength.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DepictLength.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_DEPICTPOLYGON:
   {
      if (poVisitor->bDoExpand_DepictPolygon(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_DEPICTIONPOLYGON));
      }
      else
      {
         fi_tcl_DepictPolygon o_DepictPolygon;
         if (!bDoIt(o_DepictPolygon))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DepictPolygon.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DepictPolygon.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_DEPICTIONQUANTITYSTATE:
   {
      fi_tcl_e8_DepictionQuantityState o_e8_DepictionQuantityState;
      if (!bDoIt(o_e8_DepictionQuantityState))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_DEPICTIONQUANTITYSTATEUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_DepictionQuantityState oDataType;
      oCallStack.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_DEPICTIONQUANTITYSTATE,rcfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_DepictionQuantityState::FI_EN_T_RESERVED:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_RESERVED,rcfi_tclSemanticDomain::EN_DEPICTIONQUANTITYSTATE));
         break;
      case fi_tcl_e8_DepictionQuantityState::FI_EN_T_DEPICTEDCOMPLETE:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DEPICTEDCOMPLETE,rcfi_tclSemanticDomain::EN_DEPICTIONQUANTITYSTATE));
         break;
      case fi_tcl_e8_DepictionQuantityState::FI_EN_T_DEPICTEDPARTLENGTH:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DEPICTEDPARTLENGTH,rcfi_tclSemanticDomain::EN_DEPICTIONQUANTITYSTATE));
         break;
      case fi_tcl_e8_DepictionQuantityState::FI_EN_T_DEPICTEDPARTPOLYGON:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DEPICTEDPARTPOLYGON,rcfi_tclSemanticDomain::EN_DEPICTIONQUANTITYSTATE));
         break;
      }
   } break;
   case rcfi_tclToken::EN_DEPICTIONQUANTITYSTATE:
   {
      if (poVisitor->bDoExpand_DepictionQuantityState(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DEPICTIONQUANTITYSTATEUNION0,rcfi_tclSemanticDomain::EN_DEPICTIONQUANTITYSTATE));
      }
      else
      {
         fi_tcl_DepictionQuantityState o_DepictionQuantityState;
         if (!bDoIt(o_DepictionQuantityState))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DepictionQuantityState.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DepictionQuantityState.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_DEPICTEDCOMPLETE:
   {
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_DEPICTEDPARTLENGTH:
   {
      if (poVisitor->bDoExpand_DepictedPartLength(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_ENTIREPATHLENGTH));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_DEPICTEDLENGTH));
      }
      else
      {
         fi_tcl_DepictedPartLength o_DepictedPartLength;
         if (!bDoIt(o_DepictedPartLength))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DepictedPartLength.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DepictedPartLength.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_DEPICTEDPARTPOLYGON:
   {
      if (poVisitor->bDoExpand_DepictedPartPolygon(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_DEPICTEDPOLYGON));
      }
      else
      {
         fi_tcl_DepictedPartPolygon o_DepictedPartPolygon;
         if (!bDoIt(o_DepictedPartPolygon))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DepictedPartPolygon.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DepictedPartPolygon.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_B8_DEPICTIONMODESETTINGS:
   {
      fi_tcl_b8_DepictionModeSettings o_b8_DepictionModeSettings;
      if (!bDoIt(o_b8_DepictionModeSettings))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_DEPICTIONMODESETTINGSUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_b8_DepictionModeSettings oDataMask;
      oCallStack.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_DEPICTIONMODESETTINGS,rcfi_tclSemanticDomain::EN_DATA_MASK));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataMask);
      oCallStack.bGoUp();
      if (oDataMask.u8Value & fi_tcl_b8_DepictionModeSettings::FI_C_U8_BIT_T_E8_NAVDATALEVEL)
      {
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_NAVDATALEVEL,rcfi_tclSemanticDomain::EN_DEPICTIONMODE));
      }
      if (oDataMask.u8Value & fi_tcl_b8_DepictionModeSettings::FI_C_U8_BIT_T_E8_DEPICTIONDIRECTIONMODE)
      {
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_DEPICTIONDIRECTIONMODE,rcfi_tclSemanticDomain::EN_DEPICTIONMODE));
      }
   } break;
   case rcfi_tclToken::EN_DEPICTIONMODESETTINGS:
   {
      if (poVisitor->bDoExpand_DepictionModeSettings(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DEPICTIONMODESETTINGSUNION0,rcfi_tclSemanticDomain::EN_DEPICTIONMODE));
      }
      else
      {
         fi_tcl_DepictionModeSettings o_DepictionModeSettings;
         if (!bDoIt(o_DepictionModeSettings))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DepictionModeSettings.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DepictionModeSettings.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_DEPICTIONDIRECTIONMODE:
   {
      fi_tcl_e8_DepictionDirectionMode o_e8_DepictionDirectionMode;
      if (!bDoIt(o_e8_DepictionDirectionMode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_B8_DEPICTIONRESULT:
   {
      fi_tcl_b8_DepictionResult o_b8_DepictionResult;
      if (!bDoIt(o_b8_DepictionResult))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_CNTDEPICTRESULTELEM:
   {
      if (poVisitor->bDoExpand_CntDepictResultElem(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_CNTELEMENT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_CNTONECELL));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_CNTCLUSTER));
      }
      else
      {
         fi_tcl_CntDepictResultElem o_CntDepictResultElem;
         if (!bDoIt(o_CntDepictResultElem))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CntDepictResultElem.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CntDepictResultElem.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_PATHLISTTODEPICT:
   {
      if (poVisitor->bDoExpand_PathListToDepict(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DEPICTIONAREA,rcfi_tclSemanticDomain::EN_DEPICTIONAREA));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CNTDEPICTRESULTELEM,rcfi_tclSemanticDomain::EN_MAXCNTRESULTELEM));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_DEPICTIONRESULT,rcfi_tclSemanticDomain::EN_DEPICTIONRESULT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DEPICTIONMODESETTINGS,rcfi_tclSemanticDomain::EN_DEPICTIONMODE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_PATHNUMBER));
      }
      else
      {
         fi_tcl_PathListToDepict o_PathListToDepict;
         if (!bDoIt(o_PathListToDepict))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PathListToDepict.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PathListToDepict.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_PATHDATALISTSETTODEPICT:
   {
      if (poVisitor->bDoExpand_PathDataListSetToDepict(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVDLDCHAINONECELLLISTSET,rcfi_tclSemanticDomain::EN_DLDCHAINONECELLLISTSET));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DEPICTIONAREA,rcfi_tclSemanticDomain::EN_DEPICTIONAREA));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CNTDEPICTRESULTELEM,rcfi_tclSemanticDomain::EN_MAXCNTRESULTELEM));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_DEPICTIONRESULT,rcfi_tclSemanticDomain::EN_DEPICTIONRESULT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DEPICTIONMODESETTINGS,rcfi_tclSemanticDomain::EN_DEPICTIONMODE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_PATHNUMBER));
      }
      else
      {
         fi_tcl_PathDataListSetToDepict o_PathDataListSetToDepict;
         if (!bDoIt(o_PathDataListSetToDepict))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PathDataListSetToDepict.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PathDataListSetToDepict.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVDLDONECELLPROPERTY:
   {
      if (poVisitor->bDoExpand_NavDLDOneCellProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_ISCMPLXINTERSECTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_ISOBJECT));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TMONECELLPORTION,rcfi_tclSemanticDomain::EN_PORTION));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_PERCENT,rcfi_tclSemanticDomain::EN_RELATIVEDEPICTIONLENGTH));
      }
      else
      {
         fi_tcl_NavDLDOneCellProperty o_NavDLDOneCellProperty;
         if (!bDoIt(o_NavDLDOneCellProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavDLDOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavDLDOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVDLDONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavDLDOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVDLDONECELLPROPERTY,rcfi_tclSemanticDomain::EN_ONECELLPROPERTY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVONECELLDESC,rcfi_tclSemanticDomain::EN_ONECELLDESC));
      }
      else
      {
         fi_tcl_NavDLDOneCellDesc o_NavDLDOneCellDesc;
         if (!bDoIt(o_NavDLDOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavDLDOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavDLDOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVDLDEPICTEDPSONECELLLIST:
   {
      if (poVisitor->bDoExpand_NavDLDepictedPSOneCellList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVDLDONECELLDESC,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_DEPICTEDNAVONECELLREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_ISPRIMARY));
      }
      else
      {
         fi_tcl_NavDLDepictedPSOneCellList o_NavDLDepictedPSOneCellList;
         if (!bDoIt(o_NavDLDepictedPSOneCellList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavDLDepictedPSOneCellList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavDLDepictedPSOneCellList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_DEPICTEDNAVDATALEVELLISTSET:
   {
      if (poVisitor->bDoExpand_DepictedNavDataLevelListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVDLDEPICTEDPSONECELLLIST,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_DEPICTEDNAVPSONECELLLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVCLUSTERDESC,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_DEPICTEDNAVCLUSTERREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_NAVDATALEVEL,rcfi_tclSemanticDomain::EN_NAVDATALEVEL));
      }
      else
      {
         fi_tcl_DepictedNavDataLevelListSet o_DepictedNavDataLevelListSet;
         if (!bDoIt(o_DepictedNavDataLevelListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DepictedNavDataLevelListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DepictedNavDataLevelListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_DEPICTEDDATAPATHLISTSET:
   {
      if (poVisitor->bDoExpand_DepictedDataPathListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DEPICTEDNAVDATALEVELLISTSET,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_DEPICTEDNAVDATALEVELLISTSET));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DEPICTIONQUANTITYSTATE,rcfi_tclSemanticDomain::EN_DEPICTIONQUANTITYSTATE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_PATHNUMBER));
      }
      else
      {
         fi_tcl_DepictedDataPathListSet o_DepictedDataPathListSet;
         if (!bDoIt(o_DepictedDataPathListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DepictedDataPathListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DepictedDataPathListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_U32_SQUAREDECIMETER:
   {
      fi_tcl_u32_SquareDecimeter o_u32_SquareDecimeter;
      if (!bDoIt(o_u32_SquareDecimeter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_U32_MILLILITER:
   {
      fi_tcl_u32_Milliliter o_u32_Milliliter;
      if (!bDoIt(o_u32_Milliliter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_U32_MICROLITER:
   {
      fi_tcl_u32_Microliter o_u32_Microliter;
      if (!bDoIt(o_u32_Microliter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_ROUTECAPABILITYID:
   {
      fi_tcl_e8_RouteCapabilityID o_e8_RouteCapabilityID;
      if (!bDoIt(o_e8_RouteCapabilityID))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_ROUTECAPABILITY:
   {
      if (poVisitor->bDoExpand_RouteCapability(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_VALUE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_ROUTECAPABILITYID,rcfi_tclSemanticDomain::EN_ROUTECAPABILITYID));
      }
      else
      {
         fi_tcl_RouteCapability o_RouteCapability;
         if (!bDoIt(o_RouteCapability))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteCapability.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteCapability.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_ROUTEOPTION:
   {
      fi_tcl_e8_RouteOption o_e8_RouteOption;
      if (!bDoIt(o_e8_RouteOption))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_TRIPSEGMENT:
   {
      if (poVisitor->bDoExpand_TripSegment(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LOCATIONDESCRIPTION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_DESTINATIONS));
      }
      else
      {
         fi_tcl_TripSegment o_TripSegment;
         if (!bDoIt(o_TripSegment))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TripSegment.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TripSegment.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_B8_ADDTRIPSEGMENTPARAMETERS:
   {
      fi_tcl_b8_AddTripSegmentParameters o_b8_AddTripSegmentParameters;
      if (!bDoIt(o_b8_AddTripSegmentParameters))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_DYNAMICROUTECALCMODE:
   {
      fi_tcl_e8_DynamicRouteCalcMode o_e8_DynamicRouteCalcMode;
      if (!bDoIt(o_e8_DynamicRouteCalcMode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_CURRENTROUTEOPTION:
   {
      if (poVisitor->bDoExpand_CurrentRouteOption(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (7 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_PRIORITY));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_VALUE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_ROUTEOPTION,rcfi_tclSemanticDomain::EN_ROUTEOPTION));
      }
      else
      {
         fi_tcl_CurrentRouteOption o_CurrentRouteOption;
         if (!bDoIt(o_CurrentRouteOption))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CurrentRouteOption.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CurrentRouteOption.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_AVAILABLEPERMISSIONUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_RequiredPermission oDataType;
      oCallStack.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_REQUIREDPERMISSION,rcfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_RequiredPermission::FI_EN_T_GENERICREQUIREDPERMISSION) &&
          !(13 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_RequiredPermission::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_RequiredPermission::FI_EN_T_REQUIREDTAXDISC) &&
          !(u16MajorVersion <= 12))
      {
         oDataType.enType = fi_tcl_e8_RequiredPermission::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_RequiredPermission::FI_EN_T_RESERVED:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_RESERVED,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RequiredPermission::FI_EN_T_REQUIREDTAXDISC:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REQUIREDTAXDISC,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RequiredPermission::FI_EN_T_GENERICREQUIREDPERMISSION:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_GENERICREQUIREDPERMISSION,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      }
   } break;
   case rcfi_tclToken::EN_AVAILABLEPERMISSION:
   {
      if (poVisitor->bDoExpand_AvailablePermission(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_AVAILABLEPERMISSIONUNION0,rcfi_tclSemanticDomain::EN_CATEGORY));
      }
      else
      {
         fi_tcl_AvailablePermission o_AvailablePermission;
         if (!bDoIt(o_AvailablePermission))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AvailablePermission.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AvailablePermission.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_CALCULATIONCAUSE:
   {
      fi_tcl_e8_CalculationCause o_e8_CalculationCause;
      if (!bDoIt(o_e8_CalculationCause))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_CALCULATIONMODE:
   {
      fi_tcl_e8_CalculationMode o_e8_CalculationMode;
      if (!bDoIt(o_e8_CalculationMode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_CALCULATIONMODE:
   {
      if (poVisitor->bDoExpand_CalculationMode(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_CALCULATIONMODE,rcfi_tclSemanticDomain::EN_CALCULATIONMODE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_ROUTEHANDLE));
      }
      else
      {
         fi_tcl_CalculationMode o_CalculationMode;
         if (!bDoIt(o_CalculationMode))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CalculationMode.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CalculationMode.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_ACTIVEMANIPSOURCESOFSEGMENT:
   {
      if (poVisitor->bDoExpand_ActiveManipSourcesOfSegment(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B32_TRAFFICMESSAGESOURCE,rcfi_tclSemanticDomain::EN_ACTIVEMANIPULATIONSOURCES));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_DYNAMICROUTECALCMODE,rcfi_tclSemanticDomain::EN_DYNAMICROUTECALCMODE));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_TRIPSEGMENTNUMBER));
      }
      else
      {
         fi_tcl_ActiveManipSourcesOfSegment o_ActiveManipSourcesOfSegment;
         if (!bDoIt(o_ActiveManipSourcesOfSegment))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ActiveManipSourcesOfSegment.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ActiveManipSourcesOfSegment.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_ACTIVEMANIPSOURCESOFROUTE:
   {
      if (poVisitor->bDoExpand_ActiveManipSourcesOfRoute(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ACTIVEMANIPSOURCESOFSEGMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ACTIVEMANIPSOURCESOFSEGMENT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_ROUTEHANDLE));
      }
      else
      {
         fi_tcl_ActiveManipSourcesOfRoute o_ActiveManipSourcesOfRoute;
         if (!bDoIt(o_ActiveManipSourcesOfRoute))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ActiveManipSourcesOfRoute.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ActiveManipSourcesOfRoute.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_TRAFFICMESSAGESTATUS:
   {
      if (poVisitor->bDoExpand_TrafficMessageStatus(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B32_TRAFFICMESSAGESOURCE,rcfi_tclSemanticDomain::EN_NEWMESSAGEONROUTE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B32_TRAFFICMESSAGESOURCE,rcfi_tclSemanticDomain::EN_DELETEDMESSAGE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B32_TRAFFICMESSAGESOURCE,rcfi_tclSemanticDomain::EN_NEWMESSAGE));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_TRAFFICMESSAGEREVISION));
         }
      }
      else
      {
         fi_tcl_TrafficMessageStatus o_TrafficMessageStatus;
         if (!bDoIt(o_TrafficMessageStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficMessageStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficMessageStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_SEGMENTSKIPPINGMODE:
   {
      fi_tcl_e8_SegmentSkippingMode o_e8_SegmentSkippingMode;
      if (!bDoIt(o_e8_SegmentSkippingMode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_USERPERMISSIONPROFILE:
   {
      if (poVisitor->bDoExpand_UserPermissionProfile(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_AVAILABLEPERMISSION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_AVAILABLEPERMISSIONLIST));
      }
      else
      {
         fi_tcl_UserPermissionProfile o_UserPermissionProfile;
         if (!bDoIt(o_UserPermissionProfile))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UserPermissionProfile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UserPermissionProfile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_B8_DYNAMISATIONCAUSE:
   {
      fi_tcl_b8_DynamisationCause o_b8_DynamisationCause;
      if (!bDoIt(o_b8_DynamisationCause))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_ROUTEINFOELEMENTVALUES:
   {
      if (poVisitor->bDoExpand_RouteInfoElementValues(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (21 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_MICROLITER,rcfi_tclSemanticDomain::EN_FUELOFELEMENTNOTRAFFIC));
         }
         if (21 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_MICROLITER,rcfi_tclSemanticDomain::EN_FUELOFELEMENTFULLTRAFFIC));
         }
         if (21 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_MICROLITER,rcfi_tclSemanticDomain::EN_FUELOFELEMENT));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_LENGTHOFELEMENT));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_TIMEOFELEMENTNOTRAFFIC));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_TIMEOFELEMENTFULLTRAFFIC));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_TIMEOFELEMENT));
      }
      else
      {
         fi_tcl_RouteInfoElementValues o_RouteInfoElementValues;
         if (!bDoIt(o_RouteInfoElementValues))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteInfoElementValues.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteInfoElementValues.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_B32_ROADINFOPROPERTIES:
   {
      fi_tcl_b32_RoadInfoProperties o_b32_RoadInfoProperties;
      if (!bDoIt(o_b32_RoadInfoProperties))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_ROUTEINFOELEMENTSTATUS:
   {
      if (poVisitor->bDoExpand_RouteInfoElementStatus(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_ISPARTOFOBJECTINTERSECTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_ISPARTOFCOMPLEXINTERSECTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_ISSELECTABLEFORUTM));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_ISINSIDEBUILDUPAREA));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_ROADCLASSCODE,rcfi_tclSemanticDomain::EN_ROADCLASS));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_DATALEVEL));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B32_ROADINFOPROPERTIES,rcfi_tclSemanticDomain::EN_ROADPROPERTIES));
      }
      else
      {
         fi_tcl_RouteInfoElementStatus o_RouteInfoElementStatus;
         if (!bDoIt(o_RouteInfoElementStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteInfoElementStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteInfoElementStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_FIRSTELEMENT:
   {
      if (poVisitor->bDoExpand_FirstElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROUTEINFOELEMENTVALUES,rcfi_tclSemanticDomain::EN_OFFROADELEMENTVALUES));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_OFFROADVALUESAREVALID));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROUTEINFOELEMENTVALUES,rcfi_tclSemanticDomain::EN_ELEMENTVALUES));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_BASEELEMENT));
      }
      else
      {
         fi_tcl_FirstElement o_FirstElement;
         if (!bDoIt(o_FirstElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FirstElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FirstElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_ENTRYPOINTINFO:
   {
      if (poVisitor->bDoExpand_EntryPointInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_DATASETID,rcfi_tclSemanticDomain::EN_DATASETID));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ENTRYPOINT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ENTRYPOINTLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_ROUTEENTRYPOINTINDEX));
      }
      else
      {
         fi_tcl_EntryPointInfo o_EntryPointInfo;
         if (!bDoIt(o_EntryPointInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EntryPointInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EntryPointInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_ROUTEINFOCATEGORY:
   {
      fi_tcl_e8_RouteInfoCategory o_e8_RouteInfoCategory;
      if (!bDoIt(o_e8_RouteInfoCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_ROUTEINFOELEMENT:
   {
      if (poVisitor->bDoExpand_RouteInfoElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROUTEINFOELEMENTSTATUS,rcfi_tclSemanticDomain::EN_STATUS));
         if (29 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROUTEINFOELEMENTVALUES,rcfi_tclSemanticDomain::EN_VALUESOFFOLLOWINGINTERSECTION));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROUTEINFOELEMENTVALUES,rcfi_tclSemanticDomain::EN_VALUES));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_TRIPSEGMENTNUMBER));
      }
      else
      {
         fi_tcl_RouteInfoElement o_RouteInfoElement;
         if (!bDoIt(o_RouteInfoElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteInfoElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteInfoElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_ROUTEINFOCATEGORYUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_RouteInfoCategory oDataType;
      oCallStack.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_ROUTEINFOCATEGORY,rcfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_RouteInfoCategory::FI_EN_T_TOLLBOOTHLISTSET) &&
          !(36 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_RouteInfoCategory::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_RouteInfoCategory::FI_EN_T_CRITICALDECISIONPOINTLISTSET) &&
          !(25 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_RouteInfoCategory::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_RouteInfoCategory::FI_EN_T_TABULARWEATHERLISTSET) &&
          !(25 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_RouteInfoCategory::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_RouteInfoCategory::FI_EN_T_TIMEZONELISTSET) &&
          !(21 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_RouteInfoCategory::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_RouteInfoCategory::FI_EN_T_TIMEDEPENDENTCLOSURELISTSET) &&
          !(15 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_RouteInfoCategory::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_RouteInfoCategory::FI_EN_T_MAPROUTEBINCONTAINER) &&
          !(15 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_RouteInfoCategory::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_RouteInfoCategory::FI_EN_T_ENTRYEXITPOINTLISTSET) &&
          !(9 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_RouteInfoCategory::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_RouteInfoCategory::FI_EN_T_WEATHERFORECASTLISTSET) &&
          !(9 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_RouteInfoCategory::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_RouteInfoCategory::FI_EN_T_CURRENTWEATHERLISTSET) &&
          !(9 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_RouteInfoCategory::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_RouteInfoCategory::FI_EN_T_REQUIREDPERMISSIONLISTSET) &&
          !(9 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_RouteInfoCategory::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_RouteInfoCategory::FI_EN_T_SHAPEPOINTLISTSET) &&
          !(9 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_RouteInfoCategory::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_RouteInfoCategory::FI_EN_T_SIMPLEINSTRUCTIONLISTSET) &&
          !(9 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_RouteInfoCategory::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_RouteInfoCategory::FI_EN_T_DIRECTIONINFOLISTSET) &&
          !(9 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_RouteInfoCategory::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_RESERVED,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_COUNTRYNAMELISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_COUNTRYNAMELISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_STATENAMELISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STATENAMELISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_COUNTYNAMELISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_COUNTYNAMELISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_CITYNAMELISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CITYNAMELISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_CITYDISTRICTNAMELISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CITYDISTRICTNAMELISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_BUILDUPAREANAMELISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BUILDUPAREANAMELISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_ROADNAMELISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROADNAMELISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_ROADNUMBERLISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROADNUMBERLISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_TMINFOLISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TMINFOLISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_NAVUTMBINCONTAINER:
         #ifndef FI_S_EXTERNAL_FI
         if (bUseSpecialBinContainer)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVUTMBINCONTAINER,rcfi_tclSemanticDomain::EN_CATEGORY));
         }
         else
         #endif // FI_S_EXTERNAL_FI
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BINCONTAINER,rcfi_tclSemanticDomain::EN_CATEGORY));
         }
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_NAVROUTELISTBINCONTAINER:
         #ifndef FI_S_EXTERNAL_FI
         if (bUseSpecialBinContainer)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVROUTELISTBINCONTAINER,rcfi_tclSemanticDomain::EN_CATEGORY));
         }
         else
         #endif // FI_S_EXTERNAL_FI
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BINCONTAINER,rcfi_tclSemanticDomain::EN_CATEGORY));
         }
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_UTMGROUPNUMBERONLENGTHLIST:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_UTMGROUPNUMBERONLENGTHLIST,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_UTMGROUPNUMBERONNAMELIST:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_UTMGROUPNUMBERONNAMELIST,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_DESTINATIONLISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DESTINATIONLISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_SIGNPOSTLISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_SIGNPOSTLISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_EXTRADESCLISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_EXTRADESCLISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_DATADESCLISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DATADESCLISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_INTERSECTIONLISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_INTERSECTIONLISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_TRAFFICSIGNLISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TRAFFICSIGNLISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_POILISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POILISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_LANEINFOLISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LANEINFOLISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_DIRECTIONINFOLISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DIRECTIONINFOLISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_SIMPLEINSTRUCTIONLISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_SIMPLEINSTRUCTIONLISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_SHAPEPOINTLISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_SHAPEPOINTLISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_REQUIREDPERMISSIONLISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REQUIREDPERMISSIONLISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_CURRENTWEATHERLISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CURRENTWEATHERLISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_WEATHERFORECASTLISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_WEATHERFORECASTLISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_ENTRYEXITPOINTLISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ENTRYEXITPOINTLISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_MAPROUTEBINCONTAINER:
         #ifndef FI_S_EXTERNAL_FI
         if (bUseSpecialBinContainer)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MAPROUTEBINCONTAINER,rcfi_tclSemanticDomain::EN_CATEGORY));
         }
         else
         #endif // FI_S_EXTERNAL_FI
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BINCONTAINER,rcfi_tclSemanticDomain::EN_CATEGORY));
         }
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_TIMEDEPENDENTCLOSURELISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TIMEDEPENDENTCLOSURELISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_TIMEZONELISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TIMEZONELISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_TABULARWEATHERLISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TABULARWEATHERLISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_CRITICALDECISIONPOINTLISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CRITICALDECISIONPOINTLISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RouteInfoCategory::FI_EN_T_TOLLBOOTHLISTSET:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TOLLBOOTHLISTSET,rcfi_tclSemanticDomain::EN_CATEGORY));
         break;
      }
   } break;
   case rcfi_tclToken::EN_ROUTEINFOCATEGORY:
   {
      if (poVisitor->bDoExpand_RouteInfoCategory(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROUTEINFOCATEGORYUNION0,rcfi_tclSemanticDomain::EN_CATEGORY));
      }
      else
      {
         fi_tcl_RouteInfoCategory o_RouteInfoCategory;
         if (!bDoIt(o_RouteInfoCategory))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteInfoCategory.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteInfoCategory.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_ROUTEINFOCATEGORYSTATUS:
   {
      if (poVisitor->bDoExpand_RouteInfoCategoryStatus(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_TOTALELEMENTCOUNT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_ELEMENTCOUNT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_LASTCOMPLETEELEMENT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_INFOSTATUS,rcfi_tclSemanticDomain::EN_STATUS));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_ROUTEINFOCATEGORY,rcfi_tclSemanticDomain::EN_ROUTEINFOCATEGORY));
      }
      else
      {
         fi_tcl_RouteInfoCategoryStatus o_RouteInfoCategoryStatus;
         if (!bDoIt(o_RouteInfoCategoryStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteInfoCategoryStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteInfoCategoryStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_SINGLEROUTEINFOSTATUS:
   {
      if (poVisitor->bDoExpand_SingleRouteInfoStatus(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ENTRYPOINTINFO,rcfi_tclSemanticDomain::EN_ENTRYPOINTINFO));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROUTEINFOCATEGORYSTATUS,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ROUTEINFOCATEGORYSTATUSLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_PERCENT,rcfi_tclSemanticDomain::EN_QUALITY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_INFOSTATUS,rcfi_tclSemanticDomain::EN_INFOSTATUS));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_FIRSTELEMENT,rcfi_tclSemanticDomain::EN_FIRSTELEMENT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_ROUTEINFOID));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_ROUTEHANDLE));
      }
      else
      {
         fi_tcl_SingleRouteInfoStatus o_SingleRouteInfoStatus;
         if (!bDoIt(o_SingleRouteInfoStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SingleRouteInfoStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SingleRouteInfoStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_UTMGROUPNUMBERONLENGTHLIST:
   {
      if (poVisitor->bDoExpand_UTMGroupNumberOnLengthList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_GROUPNUMBER));
      }
      else
      {
         fi_tcl_UTMGroupNumberOnLengthList o_UTMGroupNumberOnLengthList;
         if (!bDoIt(o_UTMGroupNumberOnLengthList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTMGroupNumberOnLengthList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTMGroupNumberOnLengthList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_UTMGROUPNUMBERONNAMELIST:
   {
      if (poVisitor->bDoExpand_UTMGroupNumberOnNameList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_GROUPNUMBER));
      }
      else
      {
         fi_tcl_UTMGroupNumberOnNameList o_UTMGroupNumberOnNameList;
         if (!bDoIt(o_UTMGroupNumberOnNameList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTMGroupNumberOnNameList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTMGroupNumberOnNameList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_DESTINATION:
   {
      if (poVisitor->bDoExpand_Destination(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_TRIPSEGMENTNUMBER));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_INDEXINREFERENCELIST,rcfi_tclSemanticDomain::EN_SUBDESTINATIONINDEX));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_COORDINATE));
      }
      else
      {
         fi_tcl_Destination o_Destination;
         if (!bDoIt(o_Destination))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Destination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Destination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_DESTINATIONLISTSET:
   {
      if (poVisitor->bDoExpand_DestinationListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DESTINATION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_DESTINATIONREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REFERENCEELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
      }
      else
      {
         fi_tcl_DestinationListSet o_DestinationListSet;
         if (!bDoIt(o_DestinationListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DestinationListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DestinationListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_STATE:
   {
      if (poVisitor->bDoExpand_State(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_STATENAME));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_STATEID));
      }
      else
      {
         fi_tcl_State o_State;
         if (!bDoIt(o_State))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_State.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_State.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_TIMEZONE:
   {
      fi_tcl_e8_Timezone o_e8_Timezone;
      if (!bDoIt(o_e8_Timezone))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_TABULARWEATHERLOCATION:
   {
      if (poVisitor->bDoExpand_TabularWeatherLocation(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_LOCATIONCOORDINATES));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STATE,rcfi_tclSemanticDomain::EN_STATE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_LOCATIONNAME));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_LOCATIONID));
      }
      else
      {
         fi_tcl_TabularWeatherLocation o_TabularWeatherLocation;
         if (!bDoIt(o_TabularWeatherLocation))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TabularWeatherLocation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TabularWeatherLocation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_OFFROADELEMENTINFO:
   {
      if (poVisitor->bDoExpand_OffRoadElementInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_DIRECTIONABSOLUTE,rcfi_tclSemanticDomain::EN_SECTIONHEADINGONCONNECTIONPOINT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_DIRECTIONABSOLUTE,rcfi_tclSemanticDomain::EN_AIRDIRECTION));
         if (15 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_MICROLITER,rcfi_tclSemanticDomain::EN_OFFROADFUELTODESTINATION));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_OFFROADTIMETODESTINATION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_AIRDISTANCE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_VALUESAREVALID));
      }
      else
      {
         fi_tcl_OffRoadElementInfo o_OffRoadElementInfo;
         if (!bDoIt(o_OffRoadElementInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_OffRoadElementInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_OffRoadElementInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_DISTANCETIMEINFO:
   {
      if (poVisitor->bDoExpand_DistanceTimeInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (13 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_MICROLITER,rcfi_tclSemanticDomain::EN_OFFROADFUELTODESTINATION));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_OFFROADTIMETODESTINATION));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_OFFROADELEMENTINFO,rcfi_tclSemanticDomain::EN_EXITPOINTINFO));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_OFFROADELEMENTINFO,rcfi_tclSemanticDomain::EN_ENTRYPOINTINFO));
         }
         if (21 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_MICROLITER,rcfi_tclSemanticDomain::EN_ONROUTEFUELTODESTINATIONNOTRAFFIC));
         }
         if (21 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_MICROLITER,rcfi_tclSemanticDomain::EN_ONROUTEFUELTODESTINATIONFULLTRAFFIC));
         }
         if (13 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_MICROLITER,rcfi_tclSemanticDomain::EN_ONROUTEFUELTODESTINATION));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_ONROUTETIMETODESTINATIONNOTRAFFIC));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_ONROUTETIMETODESTINATIONFULLTRAFFIC));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_ONROUTETIMETODESTINATION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_ONROUTEDISTANCETODESTINATION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_ONROUTEVALUESAREVALID));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_DIRECTIONABSOLUTE,rcfi_tclSemanticDomain::EN_AIRDIRECTIONTODESTINATION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_AIRDISTANCETODESTINATION));
      }
      else
      {
         fi_tcl_DistanceTimeInfo o_DistanceTimeInfo;
         if (!bDoIt(o_DistanceTimeInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DistanceTimeInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DistanceTimeInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_ROUTEDISTANCETIMEINFO:
   {
      if (poVisitor->bDoExpand_RouteDistanceTimeInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DISTANCETIMEINFO,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_DISTANCETIMEINFOLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_ROUTEHANDLE));
      }
      else
      {
         fi_tcl_RouteDistanceTimeInfo o_RouteDistanceTimeInfo;
         if (!bDoIt(o_RouteDistanceTimeInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteDistanceTimeInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteDistanceTimeInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E32_ROUTECALCULATIONERRORINFO:
   {
      fi_tcl_e32_RouteCalculationErrorInfo o_e32_RouteCalculationErrorInfo;
      if (!bDoIt(o_e32_RouteCalculationErrorInfo))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_AVAILABLEROUTEOPTION:
   {
      if (poVisitor->bDoExpand_AvailableRouteOption(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_MAXVALUE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_MINVALUE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_ROUTEOPTION,rcfi_tclSemanticDomain::EN_ROUTEOPTION));
      }
      else
      {
         fi_tcl_AvailableRouteOption o_AvailableRouteOption;
         if (!bDoIt(o_AvailableRouteOption))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AvailableRouteOption.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AvailableRouteOption.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_ROUTESEGMENTDEFINITION:
   {
      if (poVisitor->bDoExpand_RouteSegmentDefinition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CURRENTROUTEOPTION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ROUTEOPTIONSLIST));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_USERPERMISSIONPROFILE,rcfi_tclSemanticDomain::EN_AVAILABLEPERMISSIONS));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B32_TRAFFICMESSAGESOURCE,rcfi_tclSemanticDomain::EN_ACTIVEMANIPULATIONSOURCES));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_DYNAMICROUTECALCMODE,rcfi_tclSemanticDomain::EN_DYNAMICROUTECALCMODE));
         }
      }
      else
      {
         fi_tcl_RouteSegmentDefinition o_RouteSegmentDefinition;
         if (!bDoIt(o_RouteSegmentDefinition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteSegmentDefinition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteSegmentDefinition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_TRIPSEGMENTSTATUS:
   {
      fi_tcl_e8_TripSegmentStatus o_e8_TripSegmentStatus;
      if (!bDoIt(o_e8_TripSegmentStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_TRIPSEGMENTSTATUS:
   {
      if (poVisitor->bDoExpand_TripSegmentStatus(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_DYNAMICROUTECALCMODE,rcfi_tclSemanticDomain::EN_DYNAMICROUTECALCMODE));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B32_TRAFFICMESSAGESOURCE,rcfi_tclSemanticDomain::EN_USEDMANIPULATIONSOURCES));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B32_TRAFFICMESSAGESOURCE,rcfi_tclSemanticDomain::EN_ENABLEDMANIPULATIONSOURCES));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_TRAFFICMESSAGEREVISION));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CURRENTROUTEOPTION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ROUTEOPTIONSLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_PERCENT,rcfi_tclSemanticDomain::EN_NEXTEXPECTEDPROGRESS));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_MILLISECOND,rcfi_tclSemanticDomain::EN_TIMETONEXTEXPECTEDPROGRESS));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_PERCENT,rcfi_tclSemanticDomain::EN_CURRENTPROGRESS));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E32_ROUTECALCULATIONERRORINFO,rcfi_tclSemanticDomain::EN_ROUTECALCULATIONERRORINFO));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_TRIPSEGMENTSTATUS,rcfi_tclSemanticDomain::EN_STATUS));
      }
      else
      {
         fi_tcl_TripSegmentStatus o_TripSegmentStatus;
         if (!bDoIt(o_TripSegmentStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TripSegmentStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TripSegmentStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_ROUTESTATUS:
   {
      if (poVisitor->bDoExpand_RouteStatus(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TRIPSEGMENTSTATUS,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_TRIPSEGMENTSTATUS));
         if (7 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_CALCULATIONMODE,rcfi_tclSemanticDomain::EN_CALCULATIONMODE));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_CALCULATIONINPROGRESS));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_ROUTEHANDLE));
      }
      else
      {
         fi_tcl_RouteStatus o_RouteStatus;
         if (!bDoIt(o_RouteStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_B8_ROUTEDIFFERENCESTATUS:
   {
      fi_tcl_b8_RouteDifferenceStatus o_b8_RouteDifferenceStatus;
      if (!bDoIt(o_b8_RouteDifferenceStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_B8_TRAVELVALUEVALIDITY:
   {
      fi_tcl_b8_TravelValueValidity o_b8_TravelValueValidity;
      if (!bDoIt(o_b8_TravelValueValidity))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_ROUTEBRANCHINGTYPE:
   {
      fi_tcl_e8_RouteBranchingType o_e8_RouteBranchingType;
      if (!bDoIt(o_e8_RouteBranchingType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_ROUTEBRANCHINGCOORDINATE:
   {
      if (poVisitor->bDoExpand_RouteBranchingCoordinate(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_COORDINATEOFBRANCH));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_ROUTEBRANCHINGTYPE,rcfi_tclSemanticDomain::EN_BRANCHINGTYPE));
      }
      else
      {
         fi_tcl_RouteBranchingCoordinate o_RouteBranchingCoordinate;
         if (!bDoIt(o_RouteBranchingCoordinate))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteBranchingCoordinate.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteBranchingCoordinate.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_ROUTEVALUESCHANGE:
   {
      if (poVisitor->bDoExpand_RouteValuesChange(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (35 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_ROUTEDIFFERENCESTATUS,rcfi_tclSemanticDomain::EN_ROUTEDIFFERENCESTATUS));
         }
         if (34 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_TMID_DIFFERENCELIST));
         }
         if (25 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROUTEBRANCHINGCOORDINATE,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ROUTEBRANCHINGCOORDINATELIST));
         }
         if (21 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_MICROLITER,rcfi_tclSemanticDomain::EN_TRAVELFUELADVANTAGE));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_TRAVELDISTANCEADVANTAGE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_TRAVELTIMEADVANTAGE));
         if (u16MajorVersion <= 20)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_TRAVELADVANTAGEVALUESAREVALID));
         }
         if (21 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_MICROLITER,rcfi_tclSemanticDomain::EN_TRAVELFUELDIFFERENCE));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_TRAVELDISTANCEDIFFERENCE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_SECOND,rcfi_tclSemanticDomain::EN_TRAVELTIMEDIFFERENCE));
         if (u16MajorVersion <= 20)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_TRAVELDIFFERENCEVALUESAREVALID));
         }
         if (21 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_TRAVELVALUEVALIDITY,rcfi_tclSemanticDomain::EN_TRAVELVALUEVALIDITY));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_BLOCKINGDELETED));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_BLOCKINGONROUTE));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_ROUTEINFOIDAFTERCALCULATION));
         if (21 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_DYNAMISATIONCAUSE,rcfi_tclSemanticDomain::EN_DYNAMISATIONCAUSE));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_CALCULATIONCAUSE,rcfi_tclSemanticDomain::EN_CALCULATIONCAUSE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_ROUTEINFOIDBEFORECALCULATION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_ROUTEHANDLE));
      }
      else
      {
         fi_tcl_RouteValuesChange o_RouteValuesChange;
         if (!bDoIt(o_RouteValuesChange))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteValuesChange.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteValuesChange.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_PROFILETYPE:
   {
      fi_tcl_e8_ProfileType o_e8_ProfileType;
      if (!bDoIt(o_e8_ProfileType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_NAVAREATYPE:
   {
      fi_tcl_e8_NavAreaType o_e8_NavAreaType;
      if (!bDoIt(o_e8_NavAreaType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_VEHICLETYPE:
   {
      fi_tcl_e8_VehicleType o_e8_VehicleType;
      if (!bDoIt(o_e8_VehicleType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_SPEEDVECTOR:
   {
      if (poVisitor->bDoExpand_Speedvector(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_KMPERHOUR,rcfi_tclSemanticDomain::EN_PED_MALL));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_KMPERHOUR,rcfi_tclSemanticDomain::EN_ALLEY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_KMPERHOUR,rcfi_tclSemanticDomain::EN_LOCAL));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_KMPERHOUR,rcfi_tclSemanticDomain::EN_COLLECTOR));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_KMPERHOUR,rcfi_tclSemanticDomain::EN_ARTERIAL));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_KMPERHOUR,rcfi_tclSemanticDomain::EN_HIGHWAY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_KMPERHOUR,rcfi_tclSemanticDomain::EN_FREEWAY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_KMPERHOUR,rcfi_tclSemanticDomain::EN_SFREEWAY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_NAVAREATYPE,rcfi_tclSemanticDomain::EN_AREATYPE));
      }
      else
      {
         fi_tcl_Speedvector o_Speedvector;
         if (!bDoIt(o_Speedvector))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Speedvector.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Speedvector.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_VEHICLESPEEDPROFILE:
   {
      if (poVisitor->bDoExpand_VehicleSpeedProfile(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_KMPERHOUR,rcfi_tclSemanticDomain::EN_MAXSPEED));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_VEHICLETYPE,rcfi_tclSemanticDomain::EN_VEHICLETYPE));
      }
      else
      {
         fi_tcl_VehicleSpeedProfile o_VehicleSpeedProfile;
         if (!bDoIt(o_VehicleSpeedProfile))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VehicleSpeedProfile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VehicleSpeedProfile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_B8_CARGOINFO:
   {
      fi_tcl_b8_CargoInfo o_b8_CargoInfo;
      if (!bDoIt(o_b8_CargoInfo))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_VEHICLEPROFILE:
   {
      if (poVisitor->bDoExpand_VehicleProfile(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (25 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_NUMBEROFPERSONS));
         }
         if (13 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_PERCENT,rcfi_tclSemanticDomain::EN_TRAILER));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_CARGOINFO,rcfi_tclSemanticDomain::EN_CARGOSPECIFICATION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_NUMBEROFAXLES));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_KILOGRAM,rcfi_tclSemanticDomain::EN_MAXLOADPERAXLE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_KILOGRAM,rcfi_tclSemanticDomain::EN_MAXPERMISSABLETOTALWEIGHT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_KILOGRAM,rcfi_tclSemanticDomain::EN_MAXTOTALWEIGHT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_CENTIMETER,rcfi_tclSemanticDomain::EN_LENGTH));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_CENTIMETER,rcfi_tclSemanticDomain::EN_WIDTH));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_CENTIMETER,rcfi_tclSemanticDomain::EN_HEIGHT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_KMPERHOUR,rcfi_tclSemanticDomain::EN_MAXSPEED));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_VEHICLETYPE,rcfi_tclSemanticDomain::EN_VEHICLETYPE));
      }
      else
      {
         fi_tcl_VehicleProfile o_VehicleProfile;
         if (!bDoIt(o_VehicleProfile))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VehicleProfile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VehicleProfile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_USERSPEEDPROFILE:
   {
      if (poVisitor->bDoExpand_UserSpeedProfile(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_SPEEDVECTOR,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_SPEEDVECTORLIST));
         if (22 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_KMPERHOUR,rcfi_tclSemanticDomain::EN_MAXSPEED));
         }
      }
      else
      {
         fi_tcl_UserSpeedProfile o_UserSpeedProfile;
         if (!bDoIt(o_UserSpeedProfile))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UserSpeedProfile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UserSpeedProfile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_FUELCONSUMPTIONPROFILE:
   {
      if (poVisitor->bDoExpand_FuelConsumptionProfile(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_MICROLITER,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_FUELACCELERATION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_MICROLITER,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_FUELCONSTANTSPEED));
      }
      else
      {
         fi_tcl_FuelConsumptionProfile o_FuelConsumptionProfile;
         if (!bDoIt(o_FuelConsumptionProfile))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelConsumptionProfile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelConsumptionProfile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_B8_THRESHOLDDEFINITIONPROFILE:
   {
      fi_tcl_b8_ThresholdDefinitionProfile o_b8_ThresholdDefinitionProfile;
      if (!bDoIt(o_b8_ThresholdDefinitionProfile))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_THRESHOLDDEFINITIONPROFILE:
   {
      if (poVisitor->bDoExpand_ThresholdDefinitionProfile(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DISTTIMEFUEL,rcfi_tclSemanticDomain::EN_MINIMALDIFFERENCESTOGUIDEDROUTE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_THRESHOLDDEFINITIONPROFILE,rcfi_tclSemanticDomain::EN_ALTERNATIVEROUTECONFIGURATION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DISTTIMEFUEL,rcfi_tclSemanticDomain::EN_CRITICALMANOEVREUPPERLIMIT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DISTTIMEFUEL,rcfi_tclSemanticDomain::EN_CRITICALMANOEVRELOWERLIMIT));
      }
      else
      {
         fi_tcl_ThresholdDefinitionProfile o_ThresholdDefinitionProfile;
         if (!bDoIt(o_ThresholdDefinitionProfile))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ThresholdDefinitionProfile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ThresholdDefinitionProfile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_ROUTEHANDLEDESCRIPTION:
   {
      if (poVisitor->bDoExpand_RouteHandleDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROUTESEGMENTDEFINITION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ROUTESEGMENTDEFINITION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_ROUTEHANDLE,rcfi_tclSemanticDomain::EN_ROUTEHANDLE));
      }
      else
      {
         fi_tcl_RouteHandleDescription o_RouteHandleDescription;
         if (!bDoIt(o_RouteHandleDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteHandleDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteHandleDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_ROUTEDEFINITION:
   {
      if (poVisitor->bDoExpand_RouteDefinition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_ROUTESEGMENTDEFINITION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ROUTESEGMENTDEFINITION));
      }
      else
      {
         fi_tcl_RouteDefinition o_RouteDefinition;
         if (!bDoIt(o_RouteDefinition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteDefinition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RouteDefinition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_B8_SPEEDPROFILES:
   {
      fi_tcl_b8_SpeedProfiles o_b8_SpeedProfiles;
      if (!bDoIt(o_b8_SpeedProfiles))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_B8_USERPROFILES:
   {
      fi_tcl_b8_UserProfiles o_b8_UserProfiles;
      if (!bDoIt(o_b8_UserProfiles))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_SPEEDPROFILESUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_b8_SpeedProfiles oDataMask;
      oCallStack.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_SPEEDPROFILES,rcfi_tclSemanticDomain::EN_DATA_MASK));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataMask);
      oCallStack.bGoUp();
      if (oDataMask.u8Value & fi_tcl_b8_SpeedProfiles::FI_C_U8_BIT_T_VEHICLESPEEDPROFILE)
      {
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_VEHICLESPEEDPROFILE,rcfi_tclSemanticDomain::EN_SPEEDPROFILESUNION));
      }
      if (oDataMask.u8Value & fi_tcl_b8_SpeedProfiles::FI_C_U8_BIT_T_USERSPEEDPROFILE)
      {
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_USERSPEEDPROFILE,rcfi_tclSemanticDomain::EN_SPEEDPROFILESUNION));
      }
   } break;
   case rcfi_tclToken::EN_SPEEDPROFILES:
   {
      if (poVisitor->bDoExpand_SpeedProfiles(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_SPEEDPROFILESUNION0,rcfi_tclSemanticDomain::EN_SPEEDPROFILESUNION));
      }
      else
      {
         fi_tcl_SpeedProfiles o_SpeedProfiles;
         if (!bDoIt(o_SpeedProfiles))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SpeedProfiles.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SpeedProfiles.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_VEHICLECLASS:
   {
      fi_tcl_e8_VehicleClass o_e8_VehicleClass;
      if (!bDoIt(o_e8_VehicleClass))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_GEARBOX:
   {
      fi_tcl_e8_Gearbox o_e8_Gearbox;
      if (!bDoIt(o_e8_Gearbox))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_DRIVEMODE:
   {
      fi_tcl_e8_DriveMode o_e8_DriveMode;
      if (!bDoIt(o_e8_DriveMode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_VEHICLEPARAMETER:
   {
      if (poVisitor->bDoExpand_VehicleParameter(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_DRIVEMODE,rcfi_tclSemanticDomain::EN_DRIVEMODE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_GEARBOX,rcfi_tclSemanticDomain::EN_GEARBOX));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_MILLILITER,rcfi_tclSemanticDomain::EN_CYLINDERCAPACITY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_FUELTYPE,rcfi_tclSemanticDomain::EN_FUELTYPE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_F32,rcfi_tclSemanticDomain::EN_CDVALUE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_SQUAREDECIMETER,rcfi_tclSemanticDomain::EN_FRONTALAREA));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_KILOGRAM,rcfi_tclSemanticDomain::EN_WEIGHT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_VEHICLECLASS,rcfi_tclSemanticDomain::EN_VEHICLECLASS));
      }
      else
      {
         fi_tcl_VehicleParameter o_VehicleParameter;
         if (!bDoIt(o_VehicleParameter))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VehicleParameter.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VehicleParameter.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_DRIVERTYPE:
   {
      fi_tcl_e8_DriverType o_e8_DriverType;
      if (!bDoIt(o_e8_DriverType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_DRIVERPARAMETER:
   {
      if (poVisitor->bDoExpand_DriverParameter(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_DRIVERTYPE,rcfi_tclSemanticDomain::EN_DRIVERTYPE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_DRIVERPARAMETERVALID));
      }
      else
      {
         fi_tcl_DriverParameter o_DriverParameter;
         if (!bDoIt(o_DriverParameter))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DriverParameter.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DriverParameter.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_GREENPROFILE:
   {
      if (poVisitor->bDoExpand_GreenProfile(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_DRIVERPARAMETER,rcfi_tclSemanticDomain::EN_DRIVERPARAMETER));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_VEHICLEPARAMETER,rcfi_tclSemanticDomain::EN_VEHICLEPARAMETER));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_PERCENT,rcfi_tclSemanticDomain::EN_TRAILER));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_PERCENT,rcfi_tclSemanticDomain::EN_ROOFLOAD));
      }
      else
      {
         fi_tcl_GreenProfile o_GreenProfile;
         if (!bDoIt(o_GreenProfile))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GreenProfile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GreenProfile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_USERPROFILESUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_b8_UserProfiles oDataMask;
      oCallStack.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B8_USERPROFILES,rcfi_tclSemanticDomain::EN_DATA_MASK));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataMask);
      oCallStack.bGoUp();
      if (oDataMask.u8Value & fi_tcl_b8_UserProfiles::FI_C_U8_BIT_T_VEHICLEPROFILE)
      {
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_VEHICLEPROFILE,rcfi_tclSemanticDomain::EN_USERPROFILESUNION));
      }
      if (oDataMask.u8Value & fi_tcl_b8_UserProfiles::FI_C_U8_BIT_T_USERSPEEDPROFILE)
      {
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_USERSPEEDPROFILE,rcfi_tclSemanticDomain::EN_USERPROFILESUNION));
      }
      if ((oDataMask.u8Value & fi_tcl_b8_UserProfiles::FI_C_U8_BIT_T_USERPERMISSIONPROFILE) &&
          (9 <= u16MajorVersion))
      {
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_USERPERMISSIONPROFILE,rcfi_tclSemanticDomain::EN_USERPROFILESUNION));
      }
      if ((oDataMask.u8Value & fi_tcl_b8_UserProfiles::FI_C_U8_BIT_T_GREENPROFILE) &&
          (13 <= u16MajorVersion))
      {
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_GREENPROFILE,rcfi_tclSemanticDomain::EN_USERPROFILESUNION));
      }
      if ((oDataMask.u8Value & fi_tcl_b8_UserProfiles::FI_C_U8_BIT_T_FUELCONSUMPTIONPROFILE) &&
          (13 <= u16MajorVersion))
      {
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_FUELCONSUMPTIONPROFILE,rcfi_tclSemanticDomain::EN_USERPROFILESUNION));
      }
      if ((oDataMask.u8Value & fi_tcl_b8_UserProfiles::FI_C_U8_BIT_T_THRESHOLDDEFINITIONPROFILE) &&
          (28 <= u16MajorVersion))
      {
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_THRESHOLDDEFINITIONPROFILE,rcfi_tclSemanticDomain::EN_USERPROFILESUNION));
      }
   } break;
   case rcfi_tclToken::EN_USERPROFILES:
   {
      if (poVisitor->bDoExpand_UserProfiles(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_USERPROFILESUNION0,rcfi_tclSemanticDomain::EN_USERPROFILESUNION));
      }
      else
      {
         fi_tcl_UserProfiles o_UserProfiles;
         if (!bDoIt(o_UserProfiles))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UserProfiles.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UserProfiles.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_MAPDESTINATIONTYPE:
   {
      fi_tcl_e8_MapDestinationType o_e8_MapDestinationType;
      if (!bDoIt(o_e8_MapDestinationType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_MAPDESTINATION:
   {
      if (poVisitor->bDoExpand_MapDestination(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (25 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_SIDEINFO,rcfi_tclSemanticDomain::EN_SIDEINFO));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_DESTOCROUTEPART));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_DESTOCREF));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_DECISIONPOINT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_OBJECTPOINT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,rcfi_tclSemanticDomain::EN_TRIPSEGMENTNUMBER));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_MAPDESTINATIONTYPE,rcfi_tclSemanticDomain::EN_DESTINATIONTYPE));
      }
      else
      {
         fi_tcl_MapDestination o_MapDestination;
         if (!bDoIt(o_MapDestination))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapDestination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapDestination.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_MAPONECELLDESC:
   {
      if (poVisitor->bDoExpand_MapOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B32_ROADPROPERTY,rcfi_tclSemanticDomain::EN_ROADPROPERTY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVONECELLDESC,rcfi_tclSemanticDomain::EN_OCDESC));
      }
      else
      {
         fi_tcl_MapOneCellDesc o_MapOneCellDesc;
         if (!bDoIt(o_MapOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#ifndef FI_S_EXTERNAL_FI
   case rcfi_tclToken::EN_MAPROUTEBINCONTAINER:
   {
      if (poVisitor->bDoExpand_MapRouteBinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         bInsideBinContainerVersion = true;
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_BINCONTAINER));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MAPDESTINATION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_DESTINATIONS));
         if (39 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MAPONECELLDESC,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_OCPROPERTYLIST));
         }
         if (u16MajorVersion <= 38)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVONECELLDESC,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_OCLIST));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVCLUSTERDESC,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_CLUSTERREFLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_NUMTRIPSEGMENTS));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_CALCULATIONCAUSE,rcfi_tclSemanticDomain::EN_CALCULATIONCAUSE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_DATASETID,rcfi_tclSemanticDomain::EN_NAVDATASETID));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_BINCONTAINERTYPES,rcfi_tclSemanticDomain::EN_CONTAINERTYPE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_FIVERSION,rcfi_tclSemanticDomain::EN_CONTAINERFIVERSION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_SERVICEID));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_CONTAINERLENGTH));
      }
      else
      {
         fi_tcl_MapRouteBinContainer o_MapRouteBinContainer;
         if (!bDoIt(o_MapRouteBinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapRouteBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapRouteBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#endif // FI_S_EXTERNAL_FI
   case rcfi_tclToken::EN_TIMEDURATION:
   {
      if (poVisitor->bDoExpand_TimeDuration(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSIXTIME,rcfi_tclSemanticDomain::EN_ENDTIME));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSIXTIME,rcfi_tclSemanticDomain::EN_STARTTIME));
      }
      else
      {
         fi_tcl_TimeDuration o_TimeDuration;
         if (!bDoIt(o_TimeDuration))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeDuration.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeDuration.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_TIMEDEPENDENTCLOSURETYPE:
   {
      fi_tcl_e8_TimeDependentClosureType o_e8_TimeDependentClosureType;
      if (!bDoIt(o_e8_TimeDependentClosureType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_TIMEDEPENDENTCLOSURE:
   {
      if (poVisitor->bDoExpand_TimeDependentClosure(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TIMEDURATION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_TIMEDURATIONLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_TIMEDEPENDENTCLOSURETYPE,rcfi_tclSemanticDomain::EN_TYPE));
      }
      else
      {
         fi_tcl_TimeDependentClosure o_TimeDependentClosure;
         if (!bDoIt(o_TimeDependentClosure))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeDependentClosure.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeDependentClosure.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_TIMEDEPENDENTCLOSURELISTSET:
   {
      if (poVisitor->bDoExpand_TimeDependentClosureListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TIMEDEPENDENTCLOSURE,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_TIMEDEPENDENTCLOSURELIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REFERENCEELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
      }
      else
      {
         fi_tcl_TimeDependentClosureListSet o_TimeDependentClosureListSet;
         if (!bDoIt(o_TimeDependentClosureListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeDependentClosureListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeDependentClosureListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_RCALCPROCESSSTATUS:
   {
      fi_tcl_e8_RCalcProcessStatus o_e8_RCalcProcessStatus;
      if (!bDoIt(o_e8_RCalcProcessStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_B32_CALCULATIONPROPERTIES:
   {
      fi_tcl_b32_CalculationProperties o_b32_CalculationProperties;
      if (!bDoIt(o_b32_CalculationProperties))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_NAVROUTECALCPROPERTY:
   {
      if (poVisitor->bDoExpand_NavRouteCalcProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         if (25 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B32_CALCULATIONPROPERTIES,rcfi_tclSemanticDomain::EN_CALCULATIONPROPERTIES));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_DYNAMICROUTECALCMODE,rcfi_tclSemanticDomain::EN_DYNAMICROUTECALCMODE));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_B32_TRAFFICMESSAGESOURCE,rcfi_tclSemanticDomain::EN_ACTIVEMANIPULATIONSOURCES));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_TRAFFICMESSAGEREVISION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CURRENTROUTEOPTION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ROUTEOPTIONSLIST));
      }
      else
      {
         fi_tcl_NavRouteCalcProperty o_NavRouteCalcProperty;
         if (!bDoIt(o_NavRouteCalcProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRouteCalcProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRouteCalcProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_GLUEAREADESC:
   {
      if (poVisitor->bDoExpand_GlueAreaDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32,rcfi_tclSemanticDomain::EN_ROUTETABLES));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32,rcfi_tclSemanticDomain::EN_GLUEAREADESC));
      }
      else
      {
         fi_tcl_GlueAreaDesc o_GlueAreaDesc;
         if (!bDoIt(o_GlueAreaDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GlueAreaDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GlueAreaDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_DATAACCESSIBILITY:
   {
      fi_tcl_e8_DataAccessibility o_e8_DataAccessibility;
      if (!bDoIt(o_e8_DataAccessibility))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_NAVRCALCROUTESTARTPOINT:
   {
      fi_tcl_e8_NavRCalcRouteStartPoint o_e8_NavRCalcRouteStartPoint;
      if (!bDoIt(o_e8_NavRCalcRouteStartPoint))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_NAVRCALCROUTESTARTPOINTUNIONTYPEUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_NavRCalcRouteStartPoint oDataType;
      oCallStack.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_NAVRCALCROUTESTARTPOINT,rcfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_NavRCalcRouteStartPoint::FI_EN_T_RESERVED:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_RESERVED,rcfi_tclSemanticDomain::EN_NAVRCALCROUTESTARTPOINT));
         break;
      case fi_tcl_e8_NavRCalcRouteStartPoint::FI_EN_T_NAVRCALCCARPOSITION:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVRCALCCARPOSITION,rcfi_tclSemanticDomain::EN_NAVRCALCROUTESTARTPOINT));
         break;
      case fi_tcl_e8_NavRCalcRouteStartPoint::FI_EN_T_NAVSUBDESTINATIONLIST:
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVSUBDESTINATIONLIST,rcfi_tclSemanticDomain::EN_NAVRCALCROUTESTARTPOINT));
         break;
      }
   } break;
   case rcfi_tclToken::EN_NAVRCALCROUTESTARTPOINTUNIONTYPE:
   {
      if (poVisitor->bDoExpand_NavRCalcRouteStartPointUnionType(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVRCALCROUTESTARTPOINTUNIONTYPEUNION0,rcfi_tclSemanticDomain::EN_NAVRCALCROUTESTARTPOINT));
      }
      else
      {
         fi_tcl_NavRCalcRouteStartPointUnionType o_NavRCalcRouteStartPointUnionType;
         if (!bDoIt(o_NavRCalcRouteStartPointUnionType))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRCalcRouteStartPointUnionType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRCalcRouteStartPointUnionType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVRCALCPOSITIONDESC:
   {
      if (poVisitor->bDoExpand_NavRCalcPositionDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVCLUSTERDESC,rcfi_tclSemanticDomain::EN_CLUSTERDESC));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_NAVONECELLDIRECTION,rcfi_tclSemanticDomain::EN_ONECELLDIRECTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U16,rcfi_tclSemanticDomain::EN_ONECELLCELLID));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_COORDINATEOFPOSITION));
      }
      else
      {
         fi_tcl_NavRCalcPositionDesc o_NavRCalcPositionDesc;
         if (!bDoIt(o_NavRCalcPositionDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRCalcPositionDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRCalcPositionDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVRCALCCARPOSITION:
   {
      if (poVisitor->bDoExpand_NavRCalcCarPosition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVRCALCPOSITIONDESC,rcfi_tclSemanticDomain::EN_REALCARPOSITION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVRCALCPOSITIONDESC,rcfi_tclSemanticDomain::EN_CALCCARPOSITION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32_DATASETID,rcfi_tclSemanticDomain::EN_NAVDATASETID));
      }
      else
      {
         fi_tcl_NavRCalcCarPosition o_NavRCalcCarPosition;
         if (!bDoIt(o_NavRCalcCarPosition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRCalcCarPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavRCalcCarPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_NAVSUBDESTINATIONLIST:
   {
      if (poVisitor->bDoExpand_NavSubDestinationList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_NAVLOCATIONDESC,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_SUBDESTINATIONLIST));
      }
      else
      {
         fi_tcl_NavSubDestinationList o_NavSubDestinationList;
         if (!bDoIt(o_NavSubDestinationList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSubDestinationList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSubDestinationList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_LOADSTRATEGY:
   {
      fi_tcl_e8_LoadStrategy o_e8_LoadStrategy;
      if (!bDoIt(o_e8_LoadStrategy))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_LOADSTRATEGY:
   {
      if (poVisitor->bDoExpand_LoadStrategy(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_LOADSTRATEGY,rcfi_tclSemanticDomain::EN_LOADSTRATEGY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_BUPDATEBYLOCATION));
      }
      else
      {
         fi_tcl_LoadStrategy o_LoadStrategy;
         if (!bDoIt(o_LoadStrategy))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LoadStrategy.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LoadStrategy.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_STRATEGYSTATUS:
   {
      fi_tcl_e8_StrategyStatus o_e8_StrategyStatus;
      if (!bDoIt(o_e8_StrategyStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_STRATEGYSTATUS:
   {
      if (poVisitor->bDoExpand_StrategyStatus(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E32_ROUTECALCULATIONERRORINFO,rcfi_tclSemanticDomain::EN_STRATEGYERROR));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_STRATEGYSTATUS,rcfi_tclSemanticDomain::EN_STATUS));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LOADSTRATEGY,rcfi_tclSemanticDomain::EN_LOADSTRATEGY));
      }
      else
      {
         fi_tcl_StrategyStatus o_StrategyStatus;
         if (!bDoIt(o_StrategyStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StrategyStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StrategyStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_EVALUATEDPOSITION:
   {
      if (poVisitor->bDoExpand_EvaluatedPosition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_EVALUATIONVALUE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONDESCRIPTION,rcfi_tclSemanticDomain::EN_POSITION));
      }
      else
      {
         fi_tcl_EvaluatedPosition o_EvaluatedPosition;
         if (!bDoIt(o_EvaluatedPosition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EvaluatedPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EvaluatedPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_WEATHERID:
   {
      fi_tcl_e8_WeatherId o_e8_WeatherId;
      if (!bDoIt(o_e8_WeatherId))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_TABULARWEATHERID:
   {
      fi_tcl_e8_TabularWeatherId o_e8_TabularWeatherId;
      if (!bDoIt(o_e8_TabularWeatherId))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_CODEDCITY:
   {
      if (poVisitor->bDoExpand_CodedCity(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_TIMEZONE,rcfi_tclSemanticDomain::EN_TIMEZONE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_CITYCOORDINATES));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STATE,rcfi_tclSemanticDomain::EN_STATE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_CITYNAME));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_CITYID));
      }
      else
      {
         fi_tcl_CodedCity o_CodedCity;
         if (!bDoIt(o_CodedCity))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CodedCity.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CodedCity.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_METARSTATION:
   {
      if (poVisitor->bDoExpand_MetarStation(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_TIMEZONE,rcfi_tclSemanticDomain::EN_TIMEZONE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_STATIONCOORDINATES));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STATE,rcfi_tclSemanticDomain::EN_STATE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_STRING,rcfi_tclSemanticDomain::EN_STATIONNAME));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U32,rcfi_tclSemanticDomain::EN_STATIONID));
      }
      else
      {
         fi_tcl_MetarStation o_MetarStation;
         if (!bDoIt(o_MetarStation))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MetarStation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MetarStation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_WEATHERCONDITION:
   {
      if (poVisitor->bDoExpand_WeatherCondition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_WEATHERDESCRIPTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_WEATHERID,rcfi_tclSemanticDomain::EN_WEATHERID));
      }
      else
      {
         fi_tcl_WeatherCondition o_WeatherCondition;
         if (!bDoIt(o_WeatherCondition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherCondition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherCondition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_VISIBILITY:
   {
      if (poVisitor->bDoExpand_Visibility(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_VISIBILITY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_LESSTHAN));
      }
      else
      {
         fi_tcl_Visibility o_Visibility;
         if (!bDoIt(o_Visibility))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Visibility.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Visibility.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_CURRENTWEATHER:
   {
      if (poVisitor->bDoExpand_CurrentWeather(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_PASCAL,rcfi_tclSemanticDomain::EN_PRESSURE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_KMPERHOUR,rcfi_tclSemanticDomain::EN_WINDSPEED));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_DIRECTIONABSOLUTE,rcfi_tclSemanticDomain::EN_WINDDIRECTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_VISIBILITY,rcfi_tclSemanticDomain::EN_VISIBILITY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_KELVIN,rcfi_tclSemanticDomain::EN_DEWPOINT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_KELVIN,rcfi_tclSemanticDomain::EN_TEMPERATURE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_WEATHERCONDITION,rcfi_tclSemanticDomain::EN_WEATHERCONDITION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSIXTIME,rcfi_tclSemanticDomain::EN_GENERATIONTIME));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_DISTANCE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_METARSTATION,rcfi_tclSemanticDomain::EN_METARSTATION));
      }
      else
      {
         fi_tcl_CurrentWeather o_CurrentWeather;
         if (!bDoIt(o_CurrentWeather))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CurrentWeather.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CurrentWeather.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_WEATHERFORPOSITION:
   {
      if (poVisitor->bDoExpand_WeatherForPosition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CURRENTWEATHER,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_CURRENTWEATHERSITUATION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_POSITION));
      }
      else
      {
         fi_tcl_WeatherForPosition o_WeatherForPosition;
         if (!bDoIt(o_WeatherForPosition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherForPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherForPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_CURRENTWEATHERLISTSET:
   {
      if (poVisitor->bDoExpand_CurrentWeatherListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_WEATHERFORPOSITION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_WEATHERFORPOSITION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REFERENCEELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
      }
      else
      {
         fi_tcl_CurrentWeatherListSet o_CurrentWeatherListSet;
         if (!bDoIt(o_CurrentWeatherListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CurrentWeatherListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CurrentWeatherListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_WEATHERFORECAST:
   {
      if (poVisitor->bDoExpand_WeatherForecast(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_KELVIN,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_MINMAXTEMPERATURELIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_WEATHERCONDITION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_WEATHERCONDITIONLIST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSIXTIME,rcfi_tclSemanticDomain::EN_FORECASTSTARTTIME));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSIXTIME,rcfi_tclSemanticDomain::EN_GENERATIONTIME));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_DISTANCE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CODEDCITY,rcfi_tclSemanticDomain::EN_CODEDCITY));
      }
      else
      {
         fi_tcl_WeatherForecast o_WeatherForecast;
         if (!bDoIt(o_WeatherForecast))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherForecast.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherForecast.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_WEATHERFORECASTFORPOSITION:
   {
      if (poVisitor->bDoExpand_WeatherForecastForPosition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_WEATHERFORECAST,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_WEATHERFORECASTS));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_POSITION));
      }
      else
      {
         fi_tcl_WeatherForecastForPosition o_WeatherForecastForPosition;
         if (!bDoIt(o_WeatherForecastForPosition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherForecastForPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherForecastForPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_WEATHERFORECASTLISTSET:
   {
      if (poVisitor->bDoExpand_WeatherForecastListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_WEATHERFORECASTFORPOSITION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_WEATHERFORECASTFORPOSITION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REFERENCEELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
      }
      else
      {
         fi_tcl_WeatherForecastListSet o_WeatherForecastListSet;
         if (!bDoIt(o_WeatherForecastListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherForecastListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WeatherForecastListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_E8_FORECASTTYPE:
   {
      fi_tcl_e8_ForecastType o_e8_ForecastType;
      if (!bDoIt(o_e8_ForecastType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_PRECIPITATIONTYPE:
   {
      fi_tcl_e8_PrecipitationType o_e8_PrecipitationType;
      if (!bDoIt(o_e8_PrecipitationType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_E8_CLOUDCOVERAGETYPE:
   {
      fi_tcl_e8_CloudCoverageType o_e8_CloudCoverageType;
      if (!bDoIt(o_e8_CloudCoverageType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case rcfi_tclToken::EN_TABULARWEATHERCONDITION:
   {
      if (poVisitor->bDoExpand_TabularWeatherCondition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_WEATHERDESCRIPTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_TABULARWEATHERID,rcfi_tclSemanticDomain::EN_WEATHERID));
      }
      else
      {
         fi_tcl_TabularWeatherCondition o_TabularWeatherCondition;
         if (!bDoIt(o_TabularWeatherCondition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TabularWeatherCondition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TabularWeatherCondition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_PRECIPITATION:
   {
      if (poVisitor->bDoExpand_Precipitation(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_MILLIMETER,rcfi_tclSemanticDomain::EN_PRECIPITATIONAMOUNTHIGH));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_MILLIMETER,rcfi_tclSemanticDomain::EN_PRECIPITATIONAMOUNTLOW));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_PRECIPITATIONTYPETEXT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_PRECIPITATIONTYPE,rcfi_tclSemanticDomain::EN_PRECIPITATIONTYPE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_PRECIPITATIONVALID));
      }
      else
      {
         fi_tcl_Precipitation o_Precipitation;
         if (!bDoIt(o_Precipitation))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Precipitation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Precipitation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_HUMIDITY:
   {
      if (poVisitor->bDoExpand_Humidity(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_PERCENT,rcfi_tclSemanticDomain::EN_HUMIDITYHIGH));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_PERCENT,rcfi_tclSemanticDomain::EN_HUMIDITYLOW));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_VALID));
      }
      else
      {
         fi_tcl_Humidity o_Humidity;
         if (!bDoIt(o_Humidity))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Humidity.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Humidity.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_CLOUDCOVERAGE:
   {
      if (poVisitor->bDoExpand_CloudCoverage(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_CLOUDCOVERAGETEXT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_CLOUDCOVERAGETYPE,rcfi_tclSemanticDomain::EN_CLOUDCOVERAGETYPE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_VALID));
      }
      else
      {
         fi_tcl_CloudCoverage o_CloudCoverage;
         if (!bDoIt(o_CloudCoverage))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CloudCoverage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CloudCoverage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_UVLEVEL:
   {
      if (poVisitor->bDoExpand_UVLevel(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_UVRISK));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_UVINDEXHIGH));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_UVINDEXLOW));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_VALID));
      }
      else
      {
         fi_tcl_UVLevel o_UVLevel;
         if (!bDoIt(o_UVLevel))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UVLevel.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UVLevel.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_POLLENLEVEL:
   {
      if (poVisitor->bDoExpand_PollenLevel(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_POLLENLEVEL));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8,rcfi_tclSemanticDomain::EN_POLLENCOUNT));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_BOOL,rcfi_tclSemanticDomain::EN_VALID));
      }
      else
      {
         fi_tcl_PollenLevel o_PollenLevel;
         if (!bDoIt(o_PollenLevel))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PollenLevel.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PollenLevel.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_TABULARWEATHERPERFORECAST:
   {
      if (poVisitor->bDoExpand_TabularWeatherPerForecast(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POLLENLEVEL,rcfi_tclSemanticDomain::EN_POLLENLEVEL));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_MULTILANGUAGESTRING,rcfi_tclSemanticDomain::EN_AIRQUALITY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_UVLEVEL,rcfi_tclSemanticDomain::EN_UVLEVEL));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_CLOUDCOVERAGE,rcfi_tclSemanticDomain::EN_CLOUDCOVERAGE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_HUMIDITY,rcfi_tclSemanticDomain::EN_HUMIDITY));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_KMPERHOUR,rcfi_tclSemanticDomain::EN_WINDSPEED));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_DIRECTIONABSOLUTE,rcfi_tclSemanticDomain::EN_WINDDIRECTION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_PRECIPITATION,rcfi_tclSemanticDomain::EN_PRECIPITATION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_U8_PERCENT,rcfi_tclSemanticDomain::EN_PROBABILITYOFPRECIPITATION));
         if (27 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_FAHRENHEIT,rcfi_tclSemanticDomain::EN_MINTEMPERATUREFAHRENHEIT));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_KELVIN,rcfi_tclSemanticDomain::EN_MINTEMPERATURE));
         if (27 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_FAHRENHEIT,rcfi_tclSemanticDomain::EN_MAXTEMPERATUREFAHRENHEIT));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_KELVIN,rcfi_tclSemanticDomain::EN_MAXTEMPERATURE));
         if (27 <= u16MajorVersion)
         {
            oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_FAHRENHEIT,rcfi_tclSemanticDomain::EN_TEMPERATUREFAHRENHEIT));
         }
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S16_KELVIN,rcfi_tclSemanticDomain::EN_TEMPERATURE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TABULARWEATHERCONDITION,rcfi_tclSemanticDomain::EN_WEATHERCONDITION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSIXTIME,rcfi_tclSemanticDomain::EN_RECEPTIONTIME));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_E8_FORECASTTYPE,rcfi_tclSemanticDomain::EN_FORECASTTYPE));
      }
      else
      {
         fi_tcl_TabularWeatherPerForecast o_TabularWeatherPerForecast;
         if (!bDoIt(o_TabularWeatherPerForecast))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TabularWeatherPerForecast.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TabularWeatherPerForecast.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_TABULARWEATHER:
   {
      if (poVisitor->bDoExpand_TabularWeather(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TABULARWEATHERPERFORECAST,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_TABULARWEATHERPERFORECAST));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_S32_METER,rcfi_tclSemanticDomain::EN_DISTANCE));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TABULARWEATHERLOCATION,rcfi_tclSemanticDomain::EN_TABULARWEATHERLOCATION));
      }
      else
      {
         fi_tcl_TabularWeather o_TabularWeather;
         if (!bDoIt(o_TabularWeather))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TabularWeather.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TabularWeather.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_TABULARWEATHERFORPOSITION:
   {
      if (poVisitor->bDoExpand_TabularWeatherForPosition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TABULARWEATHER,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_TABULARWEATHERSITUATION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_POSITIONWGS84,rcfi_tclSemanticDomain::EN_POSITION));
      }
      else
      {
         fi_tcl_TabularWeatherForPosition o_TabularWeatherForPosition;
         if (!bDoIt(o_TabularWeatherForPosition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TabularWeatherForPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TabularWeatherForPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case rcfi_tclToken::EN_TABULARWEATHERLISTSET:
   {
      if (poVisitor->bDoExpand_TabularWeatherListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_END_OF_STRUCT,rcfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_TABULARWEATHERFORPOSITION,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_TABULARWEATHERFORPOSITION));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_REFERENCEELEMENT,rcfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(rcfi_tclKnot(rcfi_tclToken::EN_LIST,rcfi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
      }
      else
      {
         fi_tcl_TabularWeatherListSet o_TabularWeatherListSet;
         if (!bDoIt(o_TabularWeatherListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TabularWeatherListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TabularWeatherListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case rcfi_tclToken::EN_UNKNOWN:
      case rcfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

