#ifndef __RCFIDEBUGVISITOR_H__
#define __RCFIDEBUGVISITOR_H__

class MY_DECL rcfi_tclPrintVisitor : public rcfi_tclVisitorBase {

private:
   /* default constructor */ rcfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   rcfi_tclPrintVisitor(fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Reserved(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u8_Percent(fi_tcl_u8_Percent& o_u8_Percent);
   virtual tVoid vVisit_u16_IndexInReferenceList(fi_tcl_u16_IndexInReferenceList& o_u16_IndexInReferenceList);
   virtual tVoid vVisit_s32_Kilogram(fi_tcl_s32_Kilogram& o_s32_Kilogram);
   virtual tVoid vVisit_s32_Pound(fi_tcl_s32_Pound& o_s32_Pound);
   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& o_s32_Meter);
   virtual tVoid vVisit_s32_Yards(fi_tcl_s32_Yards& o_s32_Yards);
   virtual tVoid vVisit_s32_Centimeter(fi_tcl_s32_Centimeter& o_s32_Centimeter);
   virtual tVoid vVisit_s32_Inch(fi_tcl_s32_Inch& o_s32_Inch);
   virtual tVoid vVisit_s32_Millimeter(fi_tcl_s32_Millimeter& o_s32_Millimeter);
   virtual tVoid vVisit_s32_Microliter(fi_tcl_s32_Microliter& o_s32_Microliter);
   virtual tVoid vVisit_s32_Second(fi_tcl_s32_Second& o_s32_Second);
   virtual tVoid vVisit_s32_MilliSecond(fi_tcl_s32_MilliSecond& o_s32_MilliSecond);
   virtual tBool bDoExpand_POSIXTime(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DST_State(fi_tcl_e8_DST_State& o_e8_DST_State);
   virtual tBool bDoExpand_TimeZoneElement(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s16_KmPerHour(fi_tcl_s16_KmPerHour& o_s16_KmPerHour);
   virtual tVoid vVisit_s16_MilesPerHour(fi_tcl_s16_MilesPerHour& o_s16_MilesPerHour);
   virtual tVoid vVisit_s16_CentimeterSecond(fi_tcl_s16_CentimeterSecond& o_s16_CentimeterSecond);
   virtual tVoid vVisit_s16_Kelvin(fi_tcl_s16_Kelvin& o_s16_Kelvin);
   virtual tVoid vVisit_s16_Fahrenheit(fi_tcl_s16_Fahrenheit& o_s16_Fahrenheit);
   virtual tVoid vVisit_s32_Pascal(fi_tcl_s32_Pascal& o_s32_Pascal);
   virtual tBool bDoExpand_FIVersion(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tBool bDoExpand_PositionWGS84(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_u8_DirectionAbsolute(fi_tcl_u8_DirectionAbsolute& o_u8_DirectionAbsolute);
   virtual tVoid vVisit_u8_DirectionRelative(fi_tcl_u8_DirectionRelative& o_u8_DirectionRelative);
   virtual tVoid vVisit_e8_FuelType(fi_tcl_e8_FuelType& o_e8_FuelType);
   virtual tBool bDoExpand_DistTimeFuel(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_BinContainerTypes(fi_tcl_e8_BinContainerTypes& o_e8_BinContainerTypes);
   virtual tVoid vVisit_e16_SelectionCriterionType(fi_tcl_e16_SelectionCriterionType& o_e16_SelectionCriterionType);
   virtual tBool bDoExpand_StringID(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StringPosition(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_LocationDescriptionDataType(fi_tcl_e8_LocationDescriptionDataType& o_e8_LocationDescriptionDataType);
   virtual tVoid vVisit_b8_LocationDescriptorStatus(fi_tcl_b8_LocationDescriptorStatus& o_b8_LocationDescriptorStatus);
   virtual tBool bDoExpand_LocationDescriptor(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LocationDescription(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_FLIString(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_PositionStatus(fi_tcl_b8_PositionStatus& o_b8_PositionStatus);
   virtual tBool bDoExpand_ListOfPositions(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_NaviEventValue(fi_tcl_e16_NaviEventValue& o_e16_NaviEventValue);
   virtual tVoid vVisit_e8_TrafficMsgType(fi_tcl_e8_TrafficMsgType& o_e8_TrafficMsgType);
   virtual tVoid vVisit_e8_TMLocationType(fi_tcl_e8_TMLocationType& o_e8_TMLocationType);
   virtual tVoid vVisit_e8_EventType(fi_tcl_e8_EventType& o_e8_EventType);
   virtual tVoid vVisit_e16_EffectCode(fi_tcl_e16_EffectCode& o_e16_EffectCode);
   virtual tVoid vVisit_e16_CauseCode(fi_tcl_e16_CauseCode& o_e16_CauseCode);
   virtual tVoid vVisit_e8_Tendency(fi_tcl_e8_Tendency& o_e8_Tendency);
   virtual tBool bDoExpand_RDBId(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMEvent(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b32_TrafficMessageSource(fi_tcl_b32_TrafficMessageSource& o_b32_TrafficMessageSource);
   virtual tVoid vVisit_e8_TMUrgency(fi_tcl_e8_TMUrgency& o_e8_TMUrgency);
   virtual tBool bDoExpand_TMCodedMessage(rcfi_tclSemanticDomain::tenType enSemantic);
#ifndef FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_TMCodedMessageBinContainer(rcfi_tclSemanticDomain::tenType enSemantic);
#endif // FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_TMProgramService(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u32_DataSetId(fi_tcl_u32_DataSetId& o_u32_DataSetId);
   virtual tVoid vVisit_u32_MediaId(fi_tcl_u32_MediaId& o_u32_MediaId);
   virtual tBool bDoExpand_NavClusterDesc(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_NavDataLevel(fi_tcl_e8_NavDataLevel& o_e8_NavDataLevel);
   virtual tVoid vVisit_e8_NavOneCellDirection(fi_tcl_e8_NavOneCellDirection& o_e8_NavOneCellDirection);
   virtual tBool bDoExpand_NavOneCellDesc(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_SideInfo(fi_tcl_e8_SideInfo& o_e8_SideInfo);
   virtual tVoid vVisit_s32_EMU(fi_tcl_s32_EMU& o_s32_EMU);
   virtual tBool bDoExpand_NavZeroCellDesc(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavOneCell(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_NavOneCellCategory(fi_tcl_e8_NavOneCellCategory& o_e8_NavOneCellCategory);
   virtual tVoid vVisit_e8_SignPostDestType(fi_tcl_e8_SignPostDestType& o_e8_SignPostDestType);
   virtual tVoid vVisit_e8_SignPostDestinationCategory(fi_tcl_e8_SignPostDestinationCategory& o_e8_SignPostDestinationCategory);
   virtual tVoid vVisit_e8_SignPostDestStatus(fi_tcl_e8_SignPostDestStatus& o_e8_SignPostDestStatus);
   virtual tVoid vVisit_e8_DirectionStatus(fi_tcl_e8_DirectionStatus& o_e8_DirectionStatus);
   virtual tBool bDoExpand_SignPostDestDirection(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DirectionCategory(fi_tcl_e8_DirectionCategory& o_e8_DirectionCategory);
   virtual tVoid vVisit_b8_DirectionInfoStatus(fi_tcl_b8_DirectionInfoStatus& o_b8_DirectionInfoStatus);
   virtual tBool bDoExpand_DirectionCategory(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DirectionInfo(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SignPostDestination(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ReferenceElement(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DirectionInfoListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b16_PositionReliability(fi_tcl_b16_PositionReliability& o_b16_PositionReliability);
   virtual tBool bDoExpand_PositionHeadingSpeed(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_ShapeType(fi_tcl_e8_ShapeType& o_e8_ShapeType);
   virtual tBool bDoExpand_Shape(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMServiceProvider(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TMCategory(fi_tcl_e8_TMCategory& o_e8_TMCategory);
   virtual tVoid vVisit_e8_TMFlowImpact(fi_tcl_e8_TMFlowImpact& o_e8_TMFlowImpact);
   virtual tVoid vVisit_b8_TMMappingPossibility(fi_tcl_b8_TMMappingPossibility& o_b8_TMMappingPossibility);
   virtual tVoid vVisit_b8_TMMappingStatus(fi_tcl_b8_TMMappingStatus& o_b8_TMMappingStatus);
   virtual tVoid vVisit_e8_TMAffectionType(fi_tcl_e8_TMAffectionType& o_e8_TMAffectionType);
   virtual tVoid vVisit_b8_TMOneCellAttribute(fi_tcl_b8_TMOneCellAttribute& o_b8_TMOneCellAttribute);
   virtual tBool bDoExpand_TMOneCellPortion(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TMValueStatus(fi_tcl_e8_TMValueStatus& o_e8_TMValueStatus);
   virtual tVoid vVisit_e8_TMCIntersectionPathType(fi_tcl_e8_TMCIntersectionPathType& o_e8_TMCIntersectionPathType);
   virtual tVoid vVisit_e8_TMGeometricMessageType(fi_tcl_e8_TMGeometricMessageType& o_e8_TMGeometricMessageType);
   virtual tVoid vVisit_e8_TMGeographicalPathRelationType(fi_tcl_e8_TMGeographicalPathRelationType& o_e8_TMGeographicalPathRelationType);
   virtual tVoid vVisit_b8_TMRelevance(fi_tcl_b8_TMRelevance& o_b8_TMRelevance);
   virtual tBool bDoExpand_TMCStructuredText(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_RoadNumberStatus(fi_tcl_b8_RoadNumberStatus& o_b8_RoadNumberStatus);
   virtual tBool bDoExpand_CompassDirection(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_InfoStatus(fi_tcl_e8_InfoStatus& o_e8_InfoStatus);
   virtual tBool bDoExpand_InfoStatus(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SignPostElement(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ReferenceElementWithID(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StateNameElement(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CountyNameElement(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CityDistrictNameElement(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_BuildUpAreaNameElement(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadNumber(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RequiredTaxDisc(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_RequiredPermissionType(fi_tcl_e8_RequiredPermissionType& o_e8_RequiredPermissionType);
   virtual tVoid vVisit_e8_RequiredPermission(fi_tcl_e8_RequiredPermission& o_e8_RequiredPermission);
   virtual tBool bDoExpand_GenericRequiredPermission(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RequiredPermission(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CountryNameElement(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StateNameListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CountyNameListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CityNameElement(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IndexInReferenceList(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_BuildUpAreaNameListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadNameListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadNumberListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RequiredPermissionListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_IntersectionType(fi_tcl_e8_IntersectionType& o_e8_IntersectionType);
   virtual tBool bDoExpand_TimeZoneListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IntersectionNameElement(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadNameElement(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IntersectionNumberElement(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CountryNameListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CityNameListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SignPostListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_RoadClassCode(fi_tcl_e8_RoadClassCode& o_e8_RoadClassCode);
   virtual tVoid vVisit_u16_UserTrafficMessageHandle(fi_tcl_u16_UserTrafficMessageHandle& o_u16_UserTrafficMessageHandle);
   virtual tBool bDoExpand_TMCombination(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b32_RoadProperty(fi_tcl_b32_RoadProperty& o_b32_RoadProperty);
   virtual tVoid vVisit_e8_NavStreetType(fi_tcl_e8_NavStreetType& o_e8_NavStreetType);
   virtual tVoid vVisit_e8_RoadNetworkClass(fi_tcl_e8_RoadNetworkClass& o_e8_RoadNetworkClass);
   virtual tBool bDoExpand_RoadAttributes(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_ExtraDescElementType(fi_tcl_e8_ExtraDescElementType& o_e8_ExtraDescElementType);
   virtual tBool bDoExpand_ExtraDescElement(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ExtraDescListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b32_DataProperties(fi_tcl_b32_DataProperties& o_b32_DataProperties);
   virtual tBool bDoExpand_DataDescElement(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DataDescListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_CrossroadProperties(fi_tcl_b8_CrossroadProperties& o_b8_CrossroadProperties);
   virtual tBool bDoExpand_CrossroadDesc(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_CrossroadInfoCategory(fi_tcl_e8_CrossroadInfoCategory& o_e8_CrossroadInfoCategory);
   virtual tBool bDoExpand_CrossroadInfo(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IntersectionDenotation(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IntersectionDescElement(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IntersectionListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_BaseTrafficSignCategory(fi_tcl_e8_BaseTrafficSignCategory& o_e8_BaseTrafficSignCategory);
   virtual tVoid vVisit_e8_SpeedSign(fi_tcl_e8_SpeedSign& o_e8_SpeedSign);
   virtual tVoid vVisit_e16_WarningSign(fi_tcl_e16_WarningSign& o_e16_WarningSign);
   virtual tVoid vVisit_e16_RegulatorySign(fi_tcl_e16_RegulatorySign& o_e16_RegulatorySign);
   virtual tVoid vVisit_e16_AdditionalTrafficSign(fi_tcl_e16_AdditionalTrafficSign& o_e16_AdditionalTrafficSign);
   virtual tVoid vVisit_TimeDependentString(fi_tcl_TimeDependentString& o_TimeDependentString);
   virtual tVoid vVisit_b8_LaneDependentValidity(fi_tcl_b8_LaneDependentValidity& o_b8_LaneDependentValidity);
   virtual tVoid vVisit_e8_TrafficSignQuantifier(fi_tcl_e8_TrafficSignQuantifier& o_e8_TrafficSignQuantifier);
   virtual tBool bDoExpand_AdditionalTrafficSign(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TrafficSignElement(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadInfoCombination(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TrafficSignListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b32_POICategory(fi_tcl_b32_POICategory& o_b32_POICategory);
   virtual tBool bDoExpand_POIElement(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_POIListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_InstructionStatus(fi_tcl_b8_InstructionStatus& o_b8_InstructionStatus);
   virtual tBool bDoExpand_SimpleInstruction(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SimpleInstructionListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SectionCharacteristics(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_ManoeuvreCriticality(fi_tcl_e8_ManoeuvreCriticality& o_e8_ManoeuvreCriticality);
   virtual tVoid vVisit_b8_RouteProperties(fi_tcl_b8_RouteProperties& o_b8_RouteProperties);
   virtual tBool bDoExpand_MostWorseManoeuvreInfo(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CriticalDecisionPointListElement(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CriticalDecisionPointListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TollBoothElement(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TollBoothListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CityDistrictNameListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PointOfInterestElement(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UnspecifiedText(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u16_TripHandle(fi_tcl_u16_TripHandle& o_u16_TripHandle);
   virtual tVoid vVisit_u16_TripSegmentNumber(fi_tcl_u16_TripSegmentNumber& o_u16_TripSegmentNumber);
   virtual tVoid vVisit_u16_RouteHandle(fi_tcl_u16_RouteHandle& o_u16_RouteHandle);
   virtual tVoid vVisit_b8_RouteSegmentCLTypes(fi_tcl_b8_RouteSegmentCLTypes& o_b8_RouteSegmentCLTypes);
   virtual tBool bDoExpand_RouteSegmentCL(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LocationBranchCL(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DestinationBranchCL(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DestinationCL(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s32_MEMU(fi_tcl_s32_MEMU& o_s32_MEMU);
   virtual tVoid vVisit_s16_EAU(fi_tcl_s16_EAU& o_s16_EAU);
   virtual tBool bDoExpand_NavPosOneCellProperty(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavPosOnecellSectionDescription(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_EntryPointState(fi_tcl_e8_EntryPointState& o_e8_EntryPointState);
   virtual tVoid vVisit_u32_Resistance(fi_tcl_u32_Resistance& o_u32_Resistance);
   virtual tBool bDoExpand_EntryPoint(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PositionDescription(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_NavLocationDescType(fi_tcl_e8_NavLocationDescType& o_e8_NavLocationDescType);
   virtual tBool bDoExpand_NavLocationDesc(rcfi_tclSemanticDomain::tenType enSemantic);
#ifndef FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_NavLocationBinContainer(rcfi_tclSemanticDomain::tenType enSemantic);
#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_e8_NavIndexZFDestinationType(fi_tcl_e8_NavIndexZFDestinationType& o_e8_NavIndexZFDestinationType);
   virtual tVoid vVisit_e8_NavLocationNavDataType(fi_tcl_e8_NavLocationNavDataType& o_e8_NavLocationNavDataType);
   virtual tBool bDoExpand_NavLocationDataDesc(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavSpotDestinationOneCellProperty(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavSpotDestinationOneCellDesc(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavSpotDestinationOneCellListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavStreetDestinationOneCellProperty(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavStreetDestinationOneCellDesc(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavStreetDestinationOneCellListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_NavIntersectionType(fi_tcl_e8_NavIntersectionType& o_e8_NavIntersectionType);
   virtual tBool bDoExpand_NavIntersectionDestinationZeroCellProperty(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavIntersectionDestinationZeroCellDesc(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavIntersectionDestinationZeroCellListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavAreaDescriptionCircle(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavAreaDescriptionPolygon(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavDLDChainOneCellProperty(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavDLDChainOneCellDesc(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavDLDChainOneCellListSet(rcfi_tclSemanticDomain::tenType enSemantic);
#ifndef FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_NavUTMBinContainer(rcfi_tclSemanticDomain::tenType enSemantic);
#endif // FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_CountryInfo(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavRouteId(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b32_NavRouteStatus(fi_tcl_b32_NavRouteStatus& o_b32_NavRouteStatus);
   virtual tVoid vVisit_b32_ExtNavRouteStatus(fi_tcl_b32_ExtNavRouteStatus& o_b32_ExtNavRouteStatus);
   virtual tBool bDoExpand_NavRouteInfo(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavRouteCompare(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavRouteInstructionDesc(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavRouteDestinationDesc(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b32_NavRouteOneCellStatus(fi_tcl_b32_NavRouteOneCellStatus& o_b32_NavRouteOneCellStatus);
   virtual tVoid vVisit_b32_ExtNavRouteOneCellStatus(fi_tcl_b32_ExtNavRouteOneCellStatus& o_b32_ExtNavRouteOneCellStatus);
   virtual tBool bDoExpand_NavRouteOneCellProperties(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavRouteOneCellDesc(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavRouteListSet(rcfi_tclSemanticDomain::tenType enSemantic);
#ifndef FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_NavRouteListBinContainer(rcfi_tclSemanticDomain::tenType enSemantic);
#endif // FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_TMInfo(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMInfoListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_LaneStatus(fi_tcl_e8_LaneStatus& o_e8_LaneStatus);
   virtual tVoid vVisit_b8_LaneType(fi_tcl_b8_LaneType& o_b8_LaneType);
   virtual tVoid vVisit_b8_LaneChangeRestriction(fi_tcl_b8_LaneChangeRestriction& o_b8_LaneChangeRestriction);
   virtual tVoid vVisit_u8_IndexInLaneInfoSegmentList(fi_tcl_u8_IndexInLaneInfoSegmentList& o_u8_IndexInLaneInfoSegmentList);
   virtual tVoid vVisit_u8_IndexInLaneInfoList(fi_tcl_u8_IndexInLaneInfoList& o_u8_IndexInLaneInfoList);
   virtual tVoid vVisit_u8_DrivingDirection(fi_tcl_u8_DrivingDirection& o_u8_DrivingDirection);
   virtual tBool bDoExpand_LaneDirection(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfoOneCellReference(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfoOneCellIndexReference(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfoPathSectionIndexReference(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfoElementReference(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_LaneReferenceCategory(fi_tcl_e8_LaneReferenceCategory& o_e8_LaneReferenceCategory);
   virtual tBool bDoExpand_LaneReference(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfo(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfoSegment(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfoSegmentList(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfoListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_EntryExitType(fi_tcl_e8_EntryExitType& o_e8_EntryExitType);
   virtual tBool bDoExpand_EntryExitCoordinates(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_EntryExitPointListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WGS84CoordinateList(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ShapePointListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DepictionArea(fi_tcl_e8_DepictionArea& o_e8_DepictionArea);
   virtual tBool bDoExpand_DepictionArea(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DepictComplete(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DepictLength(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DepictPolygon(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DepictionQuantityState(fi_tcl_e8_DepictionQuantityState& o_e8_DepictionQuantityState);
   virtual tBool bDoExpand_DepictionQuantityState(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DepictedComplete(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DepictedPartLength(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DepictedPartPolygon(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_DepictionModeSettings(fi_tcl_b8_DepictionModeSettings& o_b8_DepictionModeSettings);
   virtual tBool bDoExpand_DepictionModeSettings(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DepictionDirectionMode(fi_tcl_e8_DepictionDirectionMode& o_e8_DepictionDirectionMode);
   virtual tVoid vVisit_b8_DepictionResult(fi_tcl_b8_DepictionResult& o_b8_DepictionResult);
   virtual tBool bDoExpand_CntDepictResultElem(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PathListToDepict(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PathDataListSetToDepict(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavDLDOneCellProperty(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavDLDOneCellDesc(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavDLDepictedPSOneCellList(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DepictedNavDataLevelListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DepictedDataPathListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u32_SquareDecimeter(fi_tcl_u32_SquareDecimeter& o_u32_SquareDecimeter);
   virtual tVoid vVisit_u32_Milliliter(fi_tcl_u32_Milliliter& o_u32_Milliliter);
   virtual tVoid vVisit_u32_Microliter(fi_tcl_u32_Microliter& o_u32_Microliter);
   virtual tVoid vVisit_e8_RouteCapabilityID(fi_tcl_e8_RouteCapabilityID& o_e8_RouteCapabilityID);
   virtual tBool bDoExpand_RouteCapability(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_RouteOption(fi_tcl_e8_RouteOption& o_e8_RouteOption);
   virtual tBool bDoExpand_TripSegment(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_AddTripSegmentParameters(fi_tcl_b8_AddTripSegmentParameters& o_b8_AddTripSegmentParameters);
   virtual tVoid vVisit_e8_DynamicRouteCalcMode(fi_tcl_e8_DynamicRouteCalcMode& o_e8_DynamicRouteCalcMode);
   virtual tBool bDoExpand_CurrentRouteOption(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_AvailablePermission(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_CalculationCause(fi_tcl_e8_CalculationCause& o_e8_CalculationCause);
   virtual tVoid vVisit_e8_CalculationMode(fi_tcl_e8_CalculationMode& o_e8_CalculationMode);
   virtual tBool bDoExpand_CalculationMode(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ActiveManipSourcesOfSegment(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ActiveManipSourcesOfRoute(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TrafficMessageStatus(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_SegmentSkippingMode(fi_tcl_e8_SegmentSkippingMode& o_e8_SegmentSkippingMode);
   virtual tBool bDoExpand_UserPermissionProfile(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_DynamisationCause(fi_tcl_b8_DynamisationCause& o_b8_DynamisationCause);
   virtual tBool bDoExpand_RouteInfoElementValues(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b32_RoadInfoProperties(fi_tcl_b32_RoadInfoProperties& o_b32_RoadInfoProperties);
   virtual tBool bDoExpand_RouteInfoElementStatus(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_FirstElement(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_EntryPointInfo(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_RouteInfoCategory(fi_tcl_e8_RouteInfoCategory& o_e8_RouteInfoCategory);
   virtual tBool bDoExpand_RouteInfoElement(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RouteInfoCategory(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RouteInfoCategoryStatus(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SingleRouteInfoStatus(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UTMGroupNumberOnLengthList(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UTMGroupNumberOnNameList(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Destination(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DestinationListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_State(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Timezone(fi_tcl_e8_Timezone& o_e8_Timezone);
   virtual tBool bDoExpand_TabularWeatherLocation(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_OffRoadElementInfo(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DistanceTimeInfo(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RouteDistanceTimeInfo(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e32_RouteCalculationErrorInfo(fi_tcl_e32_RouteCalculationErrorInfo& o_e32_RouteCalculationErrorInfo);
   virtual tBool bDoExpand_AvailableRouteOption(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RouteSegmentDefinition(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TripSegmentStatus(fi_tcl_e8_TripSegmentStatus& o_e8_TripSegmentStatus);
   virtual tBool bDoExpand_TripSegmentStatus(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RouteStatus(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_RouteDifferenceStatus(fi_tcl_b8_RouteDifferenceStatus& o_b8_RouteDifferenceStatus);
   virtual tVoid vVisit_b8_TravelValueValidity(fi_tcl_b8_TravelValueValidity& o_b8_TravelValueValidity);
   virtual tVoid vVisit_e8_RouteBranchingType(fi_tcl_e8_RouteBranchingType& o_e8_RouteBranchingType);
   virtual tBool bDoExpand_RouteBranchingCoordinate(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RouteValuesChange(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_ProfileType(fi_tcl_e8_ProfileType& o_e8_ProfileType);
   virtual tVoid vVisit_e8_NavAreaType(fi_tcl_e8_NavAreaType& o_e8_NavAreaType);
   virtual tVoid vVisit_e8_VehicleType(fi_tcl_e8_VehicleType& o_e8_VehicleType);
   virtual tBool bDoExpand_Speedvector(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_VehicleSpeedProfile(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_CargoInfo(fi_tcl_b8_CargoInfo& o_b8_CargoInfo);
   virtual tBool bDoExpand_VehicleProfile(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UserSpeedProfile(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_FuelConsumptionProfile(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_ThresholdDefinitionProfile(fi_tcl_b8_ThresholdDefinitionProfile& o_b8_ThresholdDefinitionProfile);
   virtual tBool bDoExpand_ThresholdDefinitionProfile(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RouteHandleDescription(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RouteDefinition(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_SpeedProfiles(fi_tcl_b8_SpeedProfiles& o_b8_SpeedProfiles);
   virtual tVoid vVisit_b8_UserProfiles(fi_tcl_b8_UserProfiles& o_b8_UserProfiles);
   virtual tBool bDoExpand_SpeedProfiles(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_VehicleClass(fi_tcl_e8_VehicleClass& o_e8_VehicleClass);
   virtual tVoid vVisit_e8_Gearbox(fi_tcl_e8_Gearbox& o_e8_Gearbox);
   virtual tVoid vVisit_e8_DriveMode(fi_tcl_e8_DriveMode& o_e8_DriveMode);
   virtual tBool bDoExpand_VehicleParameter(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DriverType(fi_tcl_e8_DriverType& o_e8_DriverType);
   virtual tBool bDoExpand_DriverParameter(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_GreenProfile(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UserProfiles(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_MapDestinationType(fi_tcl_e8_MapDestinationType& o_e8_MapDestinationType);
   virtual tBool bDoExpand_MapDestination(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MapOneCellDesc(rcfi_tclSemanticDomain::tenType enSemantic);
#ifndef FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_MapRouteBinContainer(rcfi_tclSemanticDomain::tenType enSemantic);
#endif // FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_TimeDuration(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TimeDependentClosureType(fi_tcl_e8_TimeDependentClosureType& o_e8_TimeDependentClosureType);
   virtual tBool bDoExpand_TimeDependentClosure(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TimeDependentClosureListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_RCalcProcessStatus(fi_tcl_e8_RCalcProcessStatus& o_e8_RCalcProcessStatus);
   virtual tVoid vVisit_b32_CalculationProperties(fi_tcl_b32_CalculationProperties& o_b32_CalculationProperties);
   virtual tBool bDoExpand_NavRouteCalcProperty(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_GlueAreaDesc(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DataAccessibility(fi_tcl_e8_DataAccessibility& o_e8_DataAccessibility);
   virtual tVoid vVisit_e8_NavRCalcRouteStartPoint(fi_tcl_e8_NavRCalcRouteStartPoint& o_e8_NavRCalcRouteStartPoint);
   virtual tBool bDoExpand_NavRCalcRouteStartPointUnionType(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavRCalcPositionDesc(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavRCalcCarPosition(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavSubDestinationList(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_LoadStrategy(fi_tcl_e8_LoadStrategy& o_e8_LoadStrategy);
   virtual tBool bDoExpand_LoadStrategy(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_StrategyStatus(fi_tcl_e8_StrategyStatus& o_e8_StrategyStatus);
   virtual tBool bDoExpand_StrategyStatus(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_EvaluatedPosition(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_WeatherId(fi_tcl_e8_WeatherId& o_e8_WeatherId);
   virtual tVoid vVisit_e8_TabularWeatherId(fi_tcl_e8_TabularWeatherId& o_e8_TabularWeatherId);
   virtual tBool bDoExpand_CodedCity(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MetarStation(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WeatherCondition(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Visibility(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CurrentWeather(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WeatherForPosition(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CurrentWeatherListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WeatherForecast(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WeatherForecastForPosition(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WeatherForecastListSet(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_ForecastType(fi_tcl_e8_ForecastType& o_e8_ForecastType);
   virtual tVoid vVisit_e8_PrecipitationType(fi_tcl_e8_PrecipitationType& o_e8_PrecipitationType);
   virtual tVoid vVisit_e8_CloudCoverageType(fi_tcl_e8_CloudCoverageType& o_e8_CloudCoverageType);
   virtual tBool bDoExpand_TabularWeatherCondition(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Precipitation(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Humidity(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CloudCoverage(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UVLevel(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PollenLevel(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TabularWeatherPerForecast(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TabularWeather(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TabularWeatherForPosition(rcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TabularWeatherListSet(rcfi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   fi_tclOutput* poOutput;
};


class MY_DECL rcfi_tclRandomInitVisitor : public rcfi_tclVisitorBase {
public:

   rcfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_u8_Percent(fi_tcl_u8_Percent& o_u8_Percent);
   virtual tVoid vVisit_u16_IndexInReferenceList(fi_tcl_u16_IndexInReferenceList& o_u16_IndexInReferenceList);
   virtual tVoid vVisit_s32_Kilogram(fi_tcl_s32_Kilogram& o_s32_Kilogram);
   virtual tVoid vVisit_s32_Pound(fi_tcl_s32_Pound& o_s32_Pound);
   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& o_s32_Meter);
   virtual tVoid vVisit_s32_Yards(fi_tcl_s32_Yards& o_s32_Yards);
   virtual tVoid vVisit_s32_Centimeter(fi_tcl_s32_Centimeter& o_s32_Centimeter);
   virtual tVoid vVisit_s32_Inch(fi_tcl_s32_Inch& o_s32_Inch);
   virtual tVoid vVisit_s32_Millimeter(fi_tcl_s32_Millimeter& o_s32_Millimeter);
   virtual tVoid vVisit_s32_Microliter(fi_tcl_s32_Microliter& o_s32_Microliter);
   virtual tVoid vVisit_s32_Second(fi_tcl_s32_Second& o_s32_Second);
   virtual tVoid vVisit_s32_MilliSecond(fi_tcl_s32_MilliSecond& o_s32_MilliSecond);
   virtual tVoid vVisit_e8_DST_State(fi_tcl_e8_DST_State& o_e8_DST_State);
   virtual tVoid vVisit_s16_KmPerHour(fi_tcl_s16_KmPerHour& o_s16_KmPerHour);
   virtual tVoid vVisit_s16_MilesPerHour(fi_tcl_s16_MilesPerHour& o_s16_MilesPerHour);
   virtual tVoid vVisit_s16_CentimeterSecond(fi_tcl_s16_CentimeterSecond& o_s16_CentimeterSecond);
   virtual tVoid vVisit_s16_Kelvin(fi_tcl_s16_Kelvin& o_s16_Kelvin);
   virtual tVoid vVisit_s16_Fahrenheit(fi_tcl_s16_Fahrenheit& o_s16_Fahrenheit);
   virtual tVoid vVisit_s32_Pascal(fi_tcl_s32_Pascal& o_s32_Pascal);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_u8_DirectionAbsolute(fi_tcl_u8_DirectionAbsolute& o_u8_DirectionAbsolute);
   virtual tVoid vVisit_u8_DirectionRelative(fi_tcl_u8_DirectionRelative& o_u8_DirectionRelative);
   virtual tVoid vVisit_e8_FuelType(fi_tcl_e8_FuelType& o_e8_FuelType);
   virtual tVoid vVisit_e8_BinContainerTypes(fi_tcl_e8_BinContainerTypes& o_e8_BinContainerTypes);
   virtual tVoid vVisit_e16_SelectionCriterionType(fi_tcl_e16_SelectionCriterionType& o_e16_SelectionCriterionType);
   virtual tVoid vVisit_e8_LocationDescriptionDataType(fi_tcl_e8_LocationDescriptionDataType& o_e8_LocationDescriptionDataType);
   virtual tVoid vVisit_b8_LocationDescriptorStatus(fi_tcl_b8_LocationDescriptorStatus& o_b8_LocationDescriptorStatus);
   virtual tVoid vVisit_b8_PositionStatus(fi_tcl_b8_PositionStatus& o_b8_PositionStatus);
   virtual tVoid vVisit_e16_NaviEventValue(fi_tcl_e16_NaviEventValue& o_e16_NaviEventValue);
   virtual tVoid vVisit_e8_TrafficMsgType(fi_tcl_e8_TrafficMsgType& o_e8_TrafficMsgType);
   virtual tVoid vVisit_e8_TMLocationType(fi_tcl_e8_TMLocationType& o_e8_TMLocationType);
   virtual tVoid vVisit_e8_EventType(fi_tcl_e8_EventType& o_e8_EventType);
   virtual tVoid vVisit_e16_EffectCode(fi_tcl_e16_EffectCode& o_e16_EffectCode);
   virtual tVoid vVisit_e16_CauseCode(fi_tcl_e16_CauseCode& o_e16_CauseCode);
   virtual tVoid vVisit_e8_Tendency(fi_tcl_e8_Tendency& o_e8_Tendency);
   virtual tVoid vVisit_b32_TrafficMessageSource(fi_tcl_b32_TrafficMessageSource& o_b32_TrafficMessageSource);
   virtual tVoid vVisit_e8_TMUrgency(fi_tcl_e8_TMUrgency& o_e8_TMUrgency);
#ifndef FI_S_EXTERNAL_FI
#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_u32_DataSetId(fi_tcl_u32_DataSetId& o_u32_DataSetId);
   virtual tVoid vVisit_u32_MediaId(fi_tcl_u32_MediaId& o_u32_MediaId);
   virtual tVoid vVisit_e8_NavDataLevel(fi_tcl_e8_NavDataLevel& o_e8_NavDataLevel);
   virtual tVoid vVisit_e8_NavOneCellDirection(fi_tcl_e8_NavOneCellDirection& o_e8_NavOneCellDirection);
   virtual tVoid vVisit_e8_SideInfo(fi_tcl_e8_SideInfo& o_e8_SideInfo);
   virtual tVoid vVisit_s32_EMU(fi_tcl_s32_EMU& o_s32_EMU);
   virtual tVoid vVisit_e8_NavOneCellCategory(fi_tcl_e8_NavOneCellCategory& o_e8_NavOneCellCategory);
   virtual tVoid vVisit_e8_SignPostDestType(fi_tcl_e8_SignPostDestType& o_e8_SignPostDestType);
   virtual tVoid vVisit_e8_SignPostDestinationCategory(fi_tcl_e8_SignPostDestinationCategory& o_e8_SignPostDestinationCategory);
   virtual tVoid vVisit_e8_SignPostDestStatus(fi_tcl_e8_SignPostDestStatus& o_e8_SignPostDestStatus);
   virtual tVoid vVisit_e8_DirectionStatus(fi_tcl_e8_DirectionStatus& o_e8_DirectionStatus);
   virtual tVoid vVisit_e8_DirectionCategory(fi_tcl_e8_DirectionCategory& o_e8_DirectionCategory);
   virtual tVoid vVisit_b8_DirectionInfoStatus(fi_tcl_b8_DirectionInfoStatus& o_b8_DirectionInfoStatus);
   virtual tVoid vVisit_b16_PositionReliability(fi_tcl_b16_PositionReliability& o_b16_PositionReliability);
   virtual tVoid vVisit_e8_ShapeType(fi_tcl_e8_ShapeType& o_e8_ShapeType);
   virtual tVoid vVisit_e8_TMCategory(fi_tcl_e8_TMCategory& o_e8_TMCategory);
   virtual tVoid vVisit_e8_TMFlowImpact(fi_tcl_e8_TMFlowImpact& o_e8_TMFlowImpact);
   virtual tVoid vVisit_b8_TMMappingPossibility(fi_tcl_b8_TMMappingPossibility& o_b8_TMMappingPossibility);
   virtual tVoid vVisit_b8_TMMappingStatus(fi_tcl_b8_TMMappingStatus& o_b8_TMMappingStatus);
   virtual tVoid vVisit_e8_TMAffectionType(fi_tcl_e8_TMAffectionType& o_e8_TMAffectionType);
   virtual tVoid vVisit_b8_TMOneCellAttribute(fi_tcl_b8_TMOneCellAttribute& o_b8_TMOneCellAttribute);
   virtual tVoid vVisit_e8_TMValueStatus(fi_tcl_e8_TMValueStatus& o_e8_TMValueStatus);
   virtual tVoid vVisit_e8_TMCIntersectionPathType(fi_tcl_e8_TMCIntersectionPathType& o_e8_TMCIntersectionPathType);
   virtual tVoid vVisit_e8_TMGeometricMessageType(fi_tcl_e8_TMGeometricMessageType& o_e8_TMGeometricMessageType);
   virtual tVoid vVisit_e8_TMGeographicalPathRelationType(fi_tcl_e8_TMGeographicalPathRelationType& o_e8_TMGeographicalPathRelationType);
   virtual tVoid vVisit_b8_TMRelevance(fi_tcl_b8_TMRelevance& o_b8_TMRelevance);
   virtual tVoid vVisit_b8_RoadNumberStatus(fi_tcl_b8_RoadNumberStatus& o_b8_RoadNumberStatus);
   virtual tVoid vVisit_e8_InfoStatus(fi_tcl_e8_InfoStatus& o_e8_InfoStatus);
   virtual tVoid vVisit_e8_RequiredPermissionType(fi_tcl_e8_RequiredPermissionType& o_e8_RequiredPermissionType);
   virtual tVoid vVisit_e8_RequiredPermission(fi_tcl_e8_RequiredPermission& o_e8_RequiredPermission);
   virtual tVoid vVisit_e8_IntersectionType(fi_tcl_e8_IntersectionType& o_e8_IntersectionType);
   virtual tVoid vVisit_e8_RoadClassCode(fi_tcl_e8_RoadClassCode& o_e8_RoadClassCode);
   virtual tVoid vVisit_u16_UserTrafficMessageHandle(fi_tcl_u16_UserTrafficMessageHandle& o_u16_UserTrafficMessageHandle);
   virtual tVoid vVisit_b32_RoadProperty(fi_tcl_b32_RoadProperty& o_b32_RoadProperty);
   virtual tVoid vVisit_e8_NavStreetType(fi_tcl_e8_NavStreetType& o_e8_NavStreetType);
   virtual tVoid vVisit_e8_RoadNetworkClass(fi_tcl_e8_RoadNetworkClass& o_e8_RoadNetworkClass);
   virtual tVoid vVisit_e8_ExtraDescElementType(fi_tcl_e8_ExtraDescElementType& o_e8_ExtraDescElementType);
   virtual tVoid vVisit_b32_DataProperties(fi_tcl_b32_DataProperties& o_b32_DataProperties);
   virtual tVoid vVisit_b8_CrossroadProperties(fi_tcl_b8_CrossroadProperties& o_b8_CrossroadProperties);
   virtual tVoid vVisit_e8_CrossroadInfoCategory(fi_tcl_e8_CrossroadInfoCategory& o_e8_CrossroadInfoCategory);
   virtual tVoid vVisit_e8_BaseTrafficSignCategory(fi_tcl_e8_BaseTrafficSignCategory& o_e8_BaseTrafficSignCategory);
   virtual tVoid vVisit_e8_SpeedSign(fi_tcl_e8_SpeedSign& o_e8_SpeedSign);
   virtual tVoid vVisit_e16_WarningSign(fi_tcl_e16_WarningSign& o_e16_WarningSign);
   virtual tVoid vVisit_e16_RegulatorySign(fi_tcl_e16_RegulatorySign& o_e16_RegulatorySign);
   virtual tVoid vVisit_e16_AdditionalTrafficSign(fi_tcl_e16_AdditionalTrafficSign& o_e16_AdditionalTrafficSign);
   virtual tVoid vVisit_TimeDependentString(fi_tcl_TimeDependentString& o_TimeDependentString);
   virtual tVoid vVisit_b8_LaneDependentValidity(fi_tcl_b8_LaneDependentValidity& o_b8_LaneDependentValidity);
   virtual tVoid vVisit_e8_TrafficSignQuantifier(fi_tcl_e8_TrafficSignQuantifier& o_e8_TrafficSignQuantifier);
   virtual tVoid vVisit_b32_POICategory(fi_tcl_b32_POICategory& o_b32_POICategory);
   virtual tVoid vVisit_b8_InstructionStatus(fi_tcl_b8_InstructionStatus& o_b8_InstructionStatus);
   virtual tVoid vVisit_e8_ManoeuvreCriticality(fi_tcl_e8_ManoeuvreCriticality& o_e8_ManoeuvreCriticality);
   virtual tVoid vVisit_b8_RouteProperties(fi_tcl_b8_RouteProperties& o_b8_RouteProperties);
   virtual tVoid vVisit_u16_TripHandle(fi_tcl_u16_TripHandle& o_u16_TripHandle);
   virtual tVoid vVisit_u16_TripSegmentNumber(fi_tcl_u16_TripSegmentNumber& o_u16_TripSegmentNumber);
   virtual tVoid vVisit_u16_RouteHandle(fi_tcl_u16_RouteHandle& o_u16_RouteHandle);
   virtual tVoid vVisit_b8_RouteSegmentCLTypes(fi_tcl_b8_RouteSegmentCLTypes& o_b8_RouteSegmentCLTypes);
   virtual tVoid vVisit_s32_MEMU(fi_tcl_s32_MEMU& o_s32_MEMU);
   virtual tVoid vVisit_s16_EAU(fi_tcl_s16_EAU& o_s16_EAU);
   virtual tVoid vVisit_e8_EntryPointState(fi_tcl_e8_EntryPointState& o_e8_EntryPointState);
   virtual tVoid vVisit_u32_Resistance(fi_tcl_u32_Resistance& o_u32_Resistance);
   virtual tVoid vVisit_e8_NavLocationDescType(fi_tcl_e8_NavLocationDescType& o_e8_NavLocationDescType);
#ifndef FI_S_EXTERNAL_FI
#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_e8_NavIndexZFDestinationType(fi_tcl_e8_NavIndexZFDestinationType& o_e8_NavIndexZFDestinationType);
   virtual tVoid vVisit_e8_NavLocationNavDataType(fi_tcl_e8_NavLocationNavDataType& o_e8_NavLocationNavDataType);
   virtual tVoid vVisit_e8_NavIntersectionType(fi_tcl_e8_NavIntersectionType& o_e8_NavIntersectionType);
#ifndef FI_S_EXTERNAL_FI
#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_b32_NavRouteStatus(fi_tcl_b32_NavRouteStatus& o_b32_NavRouteStatus);
   virtual tVoid vVisit_b32_ExtNavRouteStatus(fi_tcl_b32_ExtNavRouteStatus& o_b32_ExtNavRouteStatus);
   virtual tVoid vVisit_b32_NavRouteOneCellStatus(fi_tcl_b32_NavRouteOneCellStatus& o_b32_NavRouteOneCellStatus);
   virtual tVoid vVisit_b32_ExtNavRouteOneCellStatus(fi_tcl_b32_ExtNavRouteOneCellStatus& o_b32_ExtNavRouteOneCellStatus);
#ifndef FI_S_EXTERNAL_FI
#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_e8_LaneStatus(fi_tcl_e8_LaneStatus& o_e8_LaneStatus);
   virtual tVoid vVisit_b8_LaneType(fi_tcl_b8_LaneType& o_b8_LaneType);
   virtual tVoid vVisit_b8_LaneChangeRestriction(fi_tcl_b8_LaneChangeRestriction& o_b8_LaneChangeRestriction);
   virtual tVoid vVisit_u8_IndexInLaneInfoSegmentList(fi_tcl_u8_IndexInLaneInfoSegmentList& o_u8_IndexInLaneInfoSegmentList);
   virtual tVoid vVisit_u8_IndexInLaneInfoList(fi_tcl_u8_IndexInLaneInfoList& o_u8_IndexInLaneInfoList);
   virtual tVoid vVisit_u8_DrivingDirection(fi_tcl_u8_DrivingDirection& o_u8_DrivingDirection);
   virtual tVoid vVisit_e8_LaneReferenceCategory(fi_tcl_e8_LaneReferenceCategory& o_e8_LaneReferenceCategory);
   virtual tVoid vVisit_e8_EntryExitType(fi_tcl_e8_EntryExitType& o_e8_EntryExitType);
   virtual tVoid vVisit_e8_DepictionArea(fi_tcl_e8_DepictionArea& o_e8_DepictionArea);
   virtual tVoid vVisit_e8_DepictionQuantityState(fi_tcl_e8_DepictionQuantityState& o_e8_DepictionQuantityState);
   virtual tVoid vVisit_b8_DepictionModeSettings(fi_tcl_b8_DepictionModeSettings& o_b8_DepictionModeSettings);
   virtual tVoid vVisit_e8_DepictionDirectionMode(fi_tcl_e8_DepictionDirectionMode& o_e8_DepictionDirectionMode);
   virtual tVoid vVisit_b8_DepictionResult(fi_tcl_b8_DepictionResult& o_b8_DepictionResult);
   virtual tVoid vVisit_u32_SquareDecimeter(fi_tcl_u32_SquareDecimeter& o_u32_SquareDecimeter);
   virtual tVoid vVisit_u32_Milliliter(fi_tcl_u32_Milliliter& o_u32_Milliliter);
   virtual tVoid vVisit_u32_Microliter(fi_tcl_u32_Microliter& o_u32_Microliter);
   virtual tVoid vVisit_e8_RouteCapabilityID(fi_tcl_e8_RouteCapabilityID& o_e8_RouteCapabilityID);
   virtual tVoid vVisit_e8_RouteOption(fi_tcl_e8_RouteOption& o_e8_RouteOption);
   virtual tVoid vVisit_b8_AddTripSegmentParameters(fi_tcl_b8_AddTripSegmentParameters& o_b8_AddTripSegmentParameters);
   virtual tVoid vVisit_e8_DynamicRouteCalcMode(fi_tcl_e8_DynamicRouteCalcMode& o_e8_DynamicRouteCalcMode);
   virtual tVoid vVisit_e8_CalculationCause(fi_tcl_e8_CalculationCause& o_e8_CalculationCause);
   virtual tVoid vVisit_e8_CalculationMode(fi_tcl_e8_CalculationMode& o_e8_CalculationMode);
   virtual tVoid vVisit_e8_SegmentSkippingMode(fi_tcl_e8_SegmentSkippingMode& o_e8_SegmentSkippingMode);
   virtual tVoid vVisit_b8_DynamisationCause(fi_tcl_b8_DynamisationCause& o_b8_DynamisationCause);
   virtual tVoid vVisit_b32_RoadInfoProperties(fi_tcl_b32_RoadInfoProperties& o_b32_RoadInfoProperties);
   virtual tVoid vVisit_e8_RouteInfoCategory(fi_tcl_e8_RouteInfoCategory& o_e8_RouteInfoCategory);
   virtual tVoid vVisit_e8_Timezone(fi_tcl_e8_Timezone& o_e8_Timezone);
   virtual tVoid vVisit_e32_RouteCalculationErrorInfo(fi_tcl_e32_RouteCalculationErrorInfo& o_e32_RouteCalculationErrorInfo);
   virtual tVoid vVisit_e8_TripSegmentStatus(fi_tcl_e8_TripSegmentStatus& o_e8_TripSegmentStatus);
   virtual tVoid vVisit_b8_RouteDifferenceStatus(fi_tcl_b8_RouteDifferenceStatus& o_b8_RouteDifferenceStatus);
   virtual tVoid vVisit_b8_TravelValueValidity(fi_tcl_b8_TravelValueValidity& o_b8_TravelValueValidity);
   virtual tVoid vVisit_e8_RouteBranchingType(fi_tcl_e8_RouteBranchingType& o_e8_RouteBranchingType);
   virtual tVoid vVisit_e8_ProfileType(fi_tcl_e8_ProfileType& o_e8_ProfileType);
   virtual tVoid vVisit_e8_NavAreaType(fi_tcl_e8_NavAreaType& o_e8_NavAreaType);
   virtual tVoid vVisit_e8_VehicleType(fi_tcl_e8_VehicleType& o_e8_VehicleType);
   virtual tVoid vVisit_b8_CargoInfo(fi_tcl_b8_CargoInfo& o_b8_CargoInfo);
   virtual tVoid vVisit_b8_ThresholdDefinitionProfile(fi_tcl_b8_ThresholdDefinitionProfile& o_b8_ThresholdDefinitionProfile);
   virtual tVoid vVisit_b8_SpeedProfiles(fi_tcl_b8_SpeedProfiles& o_b8_SpeedProfiles);
   virtual tVoid vVisit_b8_UserProfiles(fi_tcl_b8_UserProfiles& o_b8_UserProfiles);
   virtual tVoid vVisit_e8_VehicleClass(fi_tcl_e8_VehicleClass& o_e8_VehicleClass);
   virtual tVoid vVisit_e8_Gearbox(fi_tcl_e8_Gearbox& o_e8_Gearbox);
   virtual tVoid vVisit_e8_DriveMode(fi_tcl_e8_DriveMode& o_e8_DriveMode);
   virtual tVoid vVisit_e8_DriverType(fi_tcl_e8_DriverType& o_e8_DriverType);
   virtual tVoid vVisit_e8_MapDestinationType(fi_tcl_e8_MapDestinationType& o_e8_MapDestinationType);
#ifndef FI_S_EXTERNAL_FI
#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_e8_TimeDependentClosureType(fi_tcl_e8_TimeDependentClosureType& o_e8_TimeDependentClosureType);
   virtual tVoid vVisit_e8_RCalcProcessStatus(fi_tcl_e8_RCalcProcessStatus& o_e8_RCalcProcessStatus);
   virtual tVoid vVisit_b32_CalculationProperties(fi_tcl_b32_CalculationProperties& o_b32_CalculationProperties);
   virtual tVoid vVisit_e8_DataAccessibility(fi_tcl_e8_DataAccessibility& o_e8_DataAccessibility);
   virtual tVoid vVisit_e8_NavRCalcRouteStartPoint(fi_tcl_e8_NavRCalcRouteStartPoint& o_e8_NavRCalcRouteStartPoint);
   virtual tVoid vVisit_e8_LoadStrategy(fi_tcl_e8_LoadStrategy& o_e8_LoadStrategy);
   virtual tVoid vVisit_e8_StrategyStatus(fi_tcl_e8_StrategyStatus& o_e8_StrategyStatus);
   virtual tVoid vVisit_e8_WeatherId(fi_tcl_e8_WeatherId& o_e8_WeatherId);
   virtual tVoid vVisit_e8_TabularWeatherId(fi_tcl_e8_TabularWeatherId& o_e8_TabularWeatherId);
   virtual tVoid vVisit_e8_ForecastType(fi_tcl_e8_ForecastType& o_e8_ForecastType);
   virtual tVoid vVisit_e8_PrecipitationType(fi_tcl_e8_PrecipitationType& o_e8_PrecipitationType);
   virtual tVoid vVisit_e8_CloudCoverageType(fi_tcl_e8_CloudCoverageType& o_e8_CloudCoverageType);
	tU32 u32ListSize;
};

#endif
