/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef POSFITYPES_HEADER
#define POSFITYPES_HEADER

// #include <vector>
// 


class posfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class posfi_tclMsgSetUsedPositionPathMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgSetUsedPositionPathMethodStart():PathId(0),SensorTime(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgSetUsedPositionPathMethodStart& operator=(const posfi_tclMsgSetUsedPositionPathMethodStart& coRef);
   posfi_tclMsgSetUsedPositionPathMethodStart(const posfi_tclMsgSetUsedPositionPathMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 PathId;
   tU32 SensorTime;
   std::vector<tU32, std::allocator<tU32> > PlaceBackPathIdList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgSetUsedPositionPathMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_SETUSEDPOSITIONPATHMETHODSTART;}
};

class posfi_tclMsgSetUsedPositionPathMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgSetUsedPositionPathMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgSetUsedPositionPathMethodResult& operator=(const posfi_tclMsgSetUsedPositionPathMethodResult& coRef);
   posfi_tclMsgSetUsedPositionPathMethodResult(const posfi_tclMsgSetUsedPositionPathMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgSetUsedPositionPathMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_SETUSEDPOSITIONPATHMETHODRESULT;}
};

class posfi_tclMsgGetPositionDescriptionMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgGetPositionDescriptionMethodStart():NavLocationBinContainerMajorVersion(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgGetPositionDescriptionMethodStart& operator=(const posfi_tclMsgGetPositionDescriptionMethodStart& coRef);
   posfi_tclMsgGetPositionDescriptionMethodStart(const posfi_tclMsgGetPositionDescriptionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 NavLocationBinContainerMajorVersion;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgGetPositionDescriptionMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_GETPOSITIONDESCRIPTIONMETHODSTART;}
};

class posfi_tclMsgGetPositionDescriptionMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgGetPositionDescriptionMethodResult():PositionDescription() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgGetPositionDescriptionMethodResult& operator=(const posfi_tclMsgGetPositionDescriptionMethodResult& coRef);
   posfi_tclMsgGetPositionDescriptionMethodResult(const posfi_tclMsgGetPositionDescriptionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LocationDescription PositionDescription;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgGetPositionDescriptionMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_GETPOSITIONDESCRIPTIONMETHODRESULT;}
};

class posfi_tclMsgSetPositionByCoordinatesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgSetPositionByCoordinatesMethodStart():WGS84Position(),Heading(),PositionTolerance(0),HeadingTolerance(),RoadClassFilter() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgSetPositionByCoordinatesMethodStart& operator=(const posfi_tclMsgSetPositionByCoordinatesMethodStart& coRef);
   posfi_tclMsgSetPositionByCoordinatesMethodStart(const posfi_tclMsgSetPositionByCoordinatesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionWGS84 WGS84Position;
   fi_tcl_u8_DirectionAbsolute Heading;
   tU16 PositionTolerance;
   fi_tcl_u8_DirectionRelative HeadingTolerance;
   fi_tcl_e8_RoadClassCode RoadClassFilter;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgSetPositionByCoordinatesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_SETPOSITIONBYCOORDINATESMETHODSTART;}
};

class posfi_tclMsgSetPositionByCoordinatesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgSetPositionByCoordinatesMethodResult():Success() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgSetPositionByCoordinatesMethodResult& operator=(const posfi_tclMsgSetPositionByCoordinatesMethodResult& coRef);
   posfi_tclMsgSetPositionByCoordinatesMethodResult(const posfi_tclMsgSetPositionByCoordinatesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_PositionCalculationState Success;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgSetPositionByCoordinatesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_SETPOSITIONBYCOORDINATESMETHODRESULT;}
};

class posfi_tclMsgSetPositionByLocationMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgSetPositionByLocationMethodStart():LocationInfo(),Heading(),DistanceToLocationInfo() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgSetPositionByLocationMethodStart& operator=(const posfi_tclMsgSetPositionByLocationMethodStart& coRef);
   posfi_tclMsgSetPositionByLocationMethodStart(const posfi_tclMsgSetPositionByLocationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LocationDescription LocationInfo;
   fi_tcl_u8_DirectionAbsolute Heading;
   fi_tcl_s32_Meter DistanceToLocationInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgSetPositionByLocationMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_SETPOSITIONBYLOCATIONMETHODSTART;}
};

class posfi_tclMsgSetPositionByLocationMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgSetPositionByLocationMethodResult():Success() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgSetPositionByLocationMethodResult& operator=(const posfi_tclMsgSetPositionByLocationMethodResult& coRef);
   posfi_tclMsgSetPositionByLocationMethodResult(const posfi_tclMsgSetPositionByLocationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_PositionCalculationState Success;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgSetPositionByLocationMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_SETPOSITIONBYLOCATIONMETHODRESULT;}
};

class posfi_tclMsgSetMatchingPermissionMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgSetMatchingPermissionMethodStart():MatchingPermission() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgSetMatchingPermissionMethodStart& operator=(const posfi_tclMsgSetMatchingPermissionMethodStart& coRef);
   posfi_tclMsgSetMatchingPermissionMethodStart(const posfi_tclMsgSetMatchingPermissionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_MapMatchingRule MatchingPermission;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgSetMatchingPermissionMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_SETMATCHINGPERMISSIONMETHODSTART;}
};

class posfi_tclMsgSetMatchingPermissionMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgSetMatchingPermissionMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgSetMatchingPermissionMethodResult& operator=(const posfi_tclMsgSetMatchingPermissionMethodResult& coRef);
   posfi_tclMsgSetMatchingPermissionMethodResult(const posfi_tclMsgSetMatchingPermissionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgSetMatchingPermissionMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_SETMATCHINGPERMISSIONMETHODRESULT;}
};

class posfi_tclMsgSwitchPositionActivateMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgSwitchPositionActivateMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgSwitchPositionActivateMethodStart& operator=(const posfi_tclMsgSwitchPositionActivateMethodStart& coRef);
   posfi_tclMsgSwitchPositionActivateMethodStart(const posfi_tclMsgSwitchPositionActivateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgSwitchPositionActivateMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_SWITCHPOSITIONACTIVATEMETHODSTART;}
};

class posfi_tclMsgSwitchPositionActivateMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgSwitchPositionActivateMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgSwitchPositionActivateMethodResult& operator=(const posfi_tclMsgSwitchPositionActivateMethodResult& coRef);
   posfi_tclMsgSwitchPositionActivateMethodResult(const posfi_tclMsgSwitchPositionActivateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgSwitchPositionActivateMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_SWITCHPOSITIONACTIVATEMETHODRESULT;}
};

class posfi_tclMsgSwitchPositionDeactivateMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgSwitchPositionDeactivateMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgSwitchPositionDeactivateMethodStart& operator=(const posfi_tclMsgSwitchPositionDeactivateMethodStart& coRef);
   posfi_tclMsgSwitchPositionDeactivateMethodStart(const posfi_tclMsgSwitchPositionDeactivateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgSwitchPositionDeactivateMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_SWITCHPOSITIONDEACTIVATEMETHODSTART;}
};

class posfi_tclMsgSwitchPositionDeactivateMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgSwitchPositionDeactivateMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgSwitchPositionDeactivateMethodResult& operator=(const posfi_tclMsgSwitchPositionDeactivateMethodResult& coRef);
   posfi_tclMsgSwitchPositionDeactivateMethodResult(const posfi_tclMsgSwitchPositionDeactivateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgSwitchPositionDeactivateMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_SWITCHPOSITIONDEACTIVATEMETHODRESULT;}
};

class posfi_tclMsgSwitchPositionToNextPossiblePositionMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgSwitchPositionToNextPossiblePositionMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgSwitchPositionToNextPossiblePositionMethodStart& operator=(const posfi_tclMsgSwitchPositionToNextPossiblePositionMethodStart& coRef);
   posfi_tclMsgSwitchPositionToNextPossiblePositionMethodStart(const posfi_tclMsgSwitchPositionToNextPossiblePositionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgSwitchPositionToNextPossiblePositionMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_SWITCHPOSITIONTONEXTPOSSIBLEPOSITIONMETHODSTART;}
};

class posfi_tclMsgSwitchPositionToNextPossiblePositionMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgSwitchPositionToNextPossiblePositionMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgSwitchPositionToNextPossiblePositionMethodResult& operator=(const posfi_tclMsgSwitchPositionToNextPossiblePositionMethodResult& coRef);
   posfi_tclMsgSwitchPositionToNextPossiblePositionMethodResult(const posfi_tclMsgSwitchPositionToNextPossiblePositionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgSwitchPositionToNextPossiblePositionMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_SWITCHPOSITIONTONEXTPOSSIBLEPOSITIONMETHODRESULT;}
};

class posfi_tclMsgActivatePresentationMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgActivatePresentationMethodStart():VehiclePosition() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgActivatePresentationMethodStart& operator=(const posfi_tclMsgActivatePresentationMethodStart& coRef);
   posfi_tclMsgActivatePresentationMethodStart(const posfi_tclMsgActivatePresentationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LocationDescription VehiclePosition;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgActivatePresentationMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_ACTIVATEPRESENTATIONMETHODSTART;}
};

class posfi_tclMsgActivatePresentationMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgActivatePresentationMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgActivatePresentationMethodResult& operator=(const posfi_tclMsgActivatePresentationMethodResult& coRef);
   posfi_tclMsgActivatePresentationMethodResult(const posfi_tclMsgActivatePresentationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgActivatePresentationMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_ACTIVATEPRESENTATIONMETHODRESULT;}
};

class posfi_tclMsgDeactivatePresentationMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgDeactivatePresentationMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgDeactivatePresentationMethodStart& operator=(const posfi_tclMsgDeactivatePresentationMethodStart& coRef);
   posfi_tclMsgDeactivatePresentationMethodStart(const posfi_tclMsgDeactivatePresentationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgDeactivatePresentationMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_DEACTIVATEPRESENTATIONMETHODSTART;}
};

class posfi_tclMsgDeactivatePresentationMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgDeactivatePresentationMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgDeactivatePresentationMethodResult& operator=(const posfi_tclMsgDeactivatePresentationMethodResult& coRef);
   posfi_tclMsgDeactivatePresentationMethodResult(const posfi_tclMsgDeactivatePresentationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgDeactivatePresentationMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_DEACTIVATEPRESENTATIONMETHODRESULT;}
};

class posfi_tclMsgUpdatePresentationPositionMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgUpdatePresentationPositionMethodStart():TripHandle(),RouteHandle(),UseScalableSpeedTable(0),SpeedValue(0),Steps(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgUpdatePresentationPositionMethodStart& operator=(const posfi_tclMsgUpdatePresentationPositionMethodStart& coRef);
   posfi_tclMsgUpdatePresentationPositionMethodStart(const posfi_tclMsgUpdatePresentationPositionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   tBool UseScalableSpeedTable;
   tU16 SpeedValue;
   tU32 Steps;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgUpdatePresentationPositionMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_UPDATEPRESENTATIONPOSITIONMETHODSTART;}
};

class posfi_tclMsgUpdatePresentationPositionMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgUpdatePresentationPositionMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgUpdatePresentationPositionMethodResult& operator=(const posfi_tclMsgUpdatePresentationPositionMethodResult& coRef);
   posfi_tclMsgUpdatePresentationPositionMethodResult(const posfi_tclMsgUpdatePresentationPositionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgUpdatePresentationPositionMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_UPDATEPRESENTATIONPOSITIONMETHODRESULT;}
};

class posfi_tclMsgCancelPresentationUpdateMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgCancelPresentationUpdateMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgCancelPresentationUpdateMethodStart& operator=(const posfi_tclMsgCancelPresentationUpdateMethodStart& coRef);
   posfi_tclMsgCancelPresentationUpdateMethodStart(const posfi_tclMsgCancelPresentationUpdateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgCancelPresentationUpdateMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_CANCELPRESENTATIONUPDATEMETHODSTART;}
};

class posfi_tclMsgCancelPresentationUpdateMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgCancelPresentationUpdateMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgCancelPresentationUpdateMethodResult& operator=(const posfi_tclMsgCancelPresentationUpdateMethodResult& coRef);
   posfi_tclMsgCancelPresentationUpdateMethodResult(const posfi_tclMsgCancelPresentationUpdateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgCancelPresentationUpdateMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_CANCELPRESENTATIONUPDATEMETHODRESULT;}
};

class posfi_tclMsgControlAutomOdometerCalibrationMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgControlAutomOdometerCalibrationMethodStart():Operation() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgControlAutomOdometerCalibrationMethodStart& operator=(const posfi_tclMsgControlAutomOdometerCalibrationMethodStart& coRef);
   posfi_tclMsgControlAutomOdometerCalibrationMethodStart(const posfi_tclMsgControlAutomOdometerCalibrationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_CalibrationOperationCode Operation;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgControlAutomOdometerCalibrationMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_CONTROLAUTOMODOMETERCALIBRATIONMETHODSTART;}
};

class posfi_tclMsgControlAutomOdometerCalibrationMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgControlAutomOdometerCalibrationMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgControlAutomOdometerCalibrationMethodResult& operator=(const posfi_tclMsgControlAutomOdometerCalibrationMethodResult& coRef);
   posfi_tclMsgControlAutomOdometerCalibrationMethodResult(const posfi_tclMsgControlAutomOdometerCalibrationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgControlAutomOdometerCalibrationMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_CONTROLAUTOMODOMETERCALIBRATIONMETHODRESULT;}
};

class posfi_tclMsgSetData2DefaultMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgSetData2DefaultMethodStart():Longitude(),Latitude(),Heading() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgSetData2DefaultMethodStart& operator=(const posfi_tclMsgSetData2DefaultMethodStart& coRef);
   posfi_tclMsgSetData2DefaultMethodStart(const posfi_tclMsgSetData2DefaultMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_s32_Longitude Longitude;
   fi_tcl_s32_Latitude Latitude;
   fi_tcl_u8_DirectionAbsolute Heading;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgSetData2DefaultMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_SETDATA2DEFAULTMETHODSTART;}
};

class posfi_tclMsgSetData2DefaultMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgSetData2DefaultMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgSetData2DefaultMethodResult& operator=(const posfi_tclMsgSetData2DefaultMethodResult& coRef);
   posfi_tclMsgSetData2DefaultMethodResult(const posfi_tclMsgSetData2DefaultMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgSetData2DefaultMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_SETDATA2DEFAULTMETHODRESULT;}
};

class posfi_tclMsgExtendedPositionUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgExtendedPositionUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgExtendedPositionUpReg& operator=(const posfi_tclMsgExtendedPositionUpReg& coRef);
   posfi_tclMsgExtendedPositionUpReg(const posfi_tclMsgExtendedPositionUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgExtendedPositionUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_EXTENDEDPOSITIONUPREG;}
};

class posfi_tclMsgExtendedPositionRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgExtendedPositionRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgExtendedPositionRelUpReg& operator=(const posfi_tclMsgExtendedPositionRelUpReg& coRef);
   posfi_tclMsgExtendedPositionRelUpReg(const posfi_tclMsgExtendedPositionRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgExtendedPositionRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_EXTENDEDPOSITIONRELUPREG;}
};

class posfi_tclMsgExtendedPositionStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgExtendedPositionStatus():ReleaseId(0),SensorPosixTime() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgExtendedPositionStatus& operator=(const posfi_tclMsgExtendedPositionStatus& coRef);
   posfi_tclMsgExtendedPositionStatus(const posfi_tclMsgExtendedPositionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ReleaseId;
   std::vector<fi_tcl_PosHorizonStartPath, std::allocator<fi_tcl_PosHorizonStartPath> > StartPathList;
   fi_tcl_PosixExactTime SensorPosixTime;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgExtendedPositionStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_EXTENDEDPOSITIONSTATUS;}
};

class posfi_tclMsgExtendedPositionHorizonUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgExtendedPositionHorizonUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgExtendedPositionHorizonUpReg& operator=(const posfi_tclMsgExtendedPositionHorizonUpReg& coRef);
   posfi_tclMsgExtendedPositionHorizonUpReg(const posfi_tclMsgExtendedPositionHorizonUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgExtendedPositionHorizonUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_EXTENDEDPOSITIONHORIZONUPREG;}
};

class posfi_tclMsgExtendedPositionHorizonRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgExtendedPositionHorizonRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgExtendedPositionHorizonRelUpReg& operator=(const posfi_tclMsgExtendedPositionHorizonRelUpReg& coRef);
   posfi_tclMsgExtendedPositionHorizonRelUpReg(const posfi_tclMsgExtendedPositionHorizonRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgExtendedPositionHorizonRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_EXTENDEDPOSITIONHORIZONRELUPREG;}
};

class posfi_tclMsgExtendedPositionHorizonStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgExtendedPositionHorizonStatus():ReleaseId(0),PositionHorizonState(),DataBaseId(0),IndexOfRootInLastHorizon(),IndexOfLastRootInCurrentHorizon(0xFFFF),TripHandle(),RouteHandle(),TripSegmentNumber(),RouteInfoId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgExtendedPositionHorizonStatus& operator=(const posfi_tclMsgExtendedPositionHorizonStatus& coRef);
   posfi_tclMsgExtendedPositionHorizonStatus(const posfi_tclMsgExtendedPositionHorizonStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ReleaseId;
   fi_tcl_e8_PosHorizonState PositionHorizonState;
   tU32 DataBaseId;
   fi_tcl_u16_IndexInReferenceList IndexOfRootInLastHorizon;
   std::vector<fi_tcl_PosHorizonRootElement, std::allocator<fi_tcl_PosHorizonRootElement> > RootList;
   fi_tcl_u16_IndexInReferenceList IndexOfLastRootInCurrentHorizon;
   std::vector<fi_tcl_u16_IndexInReferenceList, std::allocator<fi_tcl_u16_IndexInReferenceList> > IndicesOfLastRootsInCurrentHorizon;
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   fi_tcl_u16_TripSegmentNumber TripSegmentNumber;
   tU32 RouteInfoId;
   std::vector<fi_tcl_PosHorizonPathSection, std::allocator<fi_tcl_PosHorizonPathSection> > PathSectionList;
   std::vector<fi_tcl_PosHorizonOneCellSection, std::allocator<fi_tcl_PosHorizonOneCellSection> > OneCellRefList;
   std::vector<fi_tcl_NavClusterDesc, std::allocator<fi_tcl_NavClusterDesc> > ClusterRefList;
   std::vector<fi_tcl_HorizonMostProbablePath, std::allocator<fi_tcl_HorizonMostProbablePath> > MostProbablePathesList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgExtendedPositionHorizonStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_EXTENDEDPOSITIONHORIZONSTATUS;}
};

class posfi_tclMsgMostStraightPathGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgMostStraightPathGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgMostStraightPathGet& operator=(const posfi_tclMsgMostStraightPathGet& coRef);
   posfi_tclMsgMostStraightPathGet(const posfi_tclMsgMostStraightPathGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgMostStraightPathGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_MOSTSTRAIGHTPATHGET;}
};

class posfi_tclMsgMostStraightPathUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgMostStraightPathUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgMostStraightPathUpReg& operator=(const posfi_tclMsgMostStraightPathUpReg& coRef);
   posfi_tclMsgMostStraightPathUpReg(const posfi_tclMsgMostStraightPathUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgMostStraightPathUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_MOSTSTRAIGHTPATHUPREG;}
};

class posfi_tclMsgMostStraightPathRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgMostStraightPathRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgMostStraightPathRelUpReg& operator=(const posfi_tclMsgMostStraightPathRelUpReg& coRef);
   posfi_tclMsgMostStraightPathRelUpReg(const posfi_tclMsgMostStraightPathRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgMostStraightPathRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_MOSTSTRAIGHTPATHRELUPREG;}
};

class posfi_tclMsgMostStraightPathStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgMostStraightPathStatus():ReleaseId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgMostStraightPathStatus& operator=(const posfi_tclMsgMostStraightPathStatus& coRef);
   posfi_tclMsgMostStraightPathStatus(const posfi_tclMsgMostStraightPathStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ReleaseId;
   std::vector<fi_tcl_u16_IndexInReferenceList, std::allocator<fi_tcl_u16_IndexInReferenceList> > PathSectionListIndices;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgMostStraightPathStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_MOSTSTRAIGHTPATHSTATUS;}
};

class posfi_tclMsgNavPositionGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgNavPositionGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgNavPositionGet& operator=(const posfi_tclMsgNavPositionGet& coRef);
   posfi_tclMsgNavPositionGet(const posfi_tclMsgNavPositionGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgNavPositionGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_NAVPOSITIONGET;}
};

class posfi_tclMsgNavPositionUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgNavPositionUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgNavPositionUpReg& operator=(const posfi_tclMsgNavPositionUpReg& coRef);
   posfi_tclMsgNavPositionUpReg(const posfi_tclMsgNavPositionUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgNavPositionUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_NAVPOSITIONUPREG;}
};

class posfi_tclMsgNavPositionRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgNavPositionRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgNavPositionRelUpReg& operator=(const posfi_tclMsgNavPositionRelUpReg& coRef);
   posfi_tclMsgNavPositionRelUpReg(const posfi_tclMsgNavPositionRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgNavPositionRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_NAVPOSITIONRELUPREG;}
};

class posfi_tclMsgNavPositionStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgNavPositionStatus():DataSetId(),RealPosition(),NonComplexPosition(),Speed(),PositionStatus(),ExtendedPositionStatus(),SensorTime(0),SensorPosixTime(),TripHandle(),RouteHandle(),TripSegmentNumber(),RouteInfoId(0),EntryPointStatus(),EntryPoint(),Height(),Inclination(),Acceleration(),HorizonReleaseId(0xFFFFFFFF) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgNavPositionStatus& operator=(const posfi_tclMsgNavPositionStatus& coRef);
   posfi_tclMsgNavPositionStatus(const posfi_tclMsgNavPositionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId DataSetId;
   fi_tcl_PositionDescription RealPosition;
   fi_tcl_PositionDescription NonComplexPosition;
   fi_tcl_s16_MEMUSecond Speed;
   fi_tcl_e8_PositionCalculationState PositionStatus;
   fi_tcl_e8_ExtendedPositionCalculationState ExtendedPositionStatus;
   tU32 SensorTime;
   fi_tcl_PosixExactTime SensorPosixTime;
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   fi_tcl_u16_TripSegmentNumber TripSegmentNumber;
   tU32 RouteInfoId;
   fi_tcl_e8_EntryPointState EntryPointStatus;
   fi_tcl_PositionDescription EntryPoint;
   fi_tcl_s32_Meter Height;
   fi_tcl_s16_Degree Inclination;
   fi_tcl_s16_CentimeterSecond Acceleration;
   tU32 HorizonReleaseId;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgNavPositionStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_NAVPOSITIONSTATUS;}
};

class posfi_tclMsgPositionPathesGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgPositionPathesGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgPositionPathesGet& operator=(const posfi_tclMsgPositionPathesGet& coRef);
   posfi_tclMsgPositionPathesGet(const posfi_tclMsgPositionPathesGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgPositionPathesGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_POSITIONPATHESGET;}
};

class posfi_tclMsgPositionPathesUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgPositionPathesUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgPositionPathesUpReg& operator=(const posfi_tclMsgPositionPathesUpReg& coRef);
   posfi_tclMsgPositionPathesUpReg(const posfi_tclMsgPositionPathesUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgPositionPathesUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_POSITIONPATHESUPREG;}
};

class posfi_tclMsgPositionPathesRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgPositionPathesRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgPositionPathesRelUpReg& operator=(const posfi_tclMsgPositionPathesRelUpReg& coRef);
   posfi_tclMsgPositionPathesRelUpReg(const posfi_tclMsgPositionPathesRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgPositionPathesRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_POSITIONPATHESRELUPREG;}
};

class posfi_tclMsgPositionPathesStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgPositionPathesStatus():NavPosition(),NavRectangle(),SensorTime(0),SensorPosixTime(),VehicleSystemParameter(),VehicleCovarianceMatrix() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgPositionPathesStatus& operator=(const posfi_tclMsgPositionPathesStatus& coRef);
   posfi_tclMsgPositionPathesStatus(const posfi_tclMsgPositionPathesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionList NavPosition;
   fi_tcl_RectangleWGS84 NavRectangle;
   tU32 SensorTime;
   fi_tcl_PosixExactTime SensorPosixTime;
   fi_tcl_VehicleSystemParameter VehicleSystemParameter;
   fi_tcl_VehicleCovarianceMatrix VehicleCovarianceMatrix;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgPositionPathesStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_POSITIONPATHESSTATUS;}
};

class posfi_tclMsgExtrapolatedPositionsGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgExtrapolatedPositionsGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgExtrapolatedPositionsGet& operator=(const posfi_tclMsgExtrapolatedPositionsGet& coRef);
   posfi_tclMsgExtrapolatedPositionsGet(const posfi_tclMsgExtrapolatedPositionsGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgExtrapolatedPositionsGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_EXTRAPOLATEDPOSITIONSGET;}
};

class posfi_tclMsgExtrapolatedPositionsUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgExtrapolatedPositionsUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgExtrapolatedPositionsUpReg& operator=(const posfi_tclMsgExtrapolatedPositionsUpReg& coRef);
   posfi_tclMsgExtrapolatedPositionsUpReg(const posfi_tclMsgExtrapolatedPositionsUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgExtrapolatedPositionsUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_EXTRAPOLATEDPOSITIONSUPREG;}
};

class posfi_tclMsgExtrapolatedPositionsRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgExtrapolatedPositionsRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgExtrapolatedPositionsRelUpReg& operator=(const posfi_tclMsgExtrapolatedPositionsRelUpReg& coRef);
   posfi_tclMsgExtrapolatedPositionsRelUpReg(const posfi_tclMsgExtrapolatedPositionsRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgExtrapolatedPositionsRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_EXTRAPOLATEDPOSITIONSRELUPREG;}
};

class posfi_tclMsgExtrapolatedPositionsStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgExtrapolatedPositionsStatus():DataSetId(),HorizonReleaseId(0xFFFFFFFF),ExtrapolationReliability(),TimestampOfFirstPosition(),ExtrapolationIntervall() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgExtrapolatedPositionsStatus& operator=(const posfi_tclMsgExtrapolatedPositionsStatus& coRef);
   posfi_tclMsgExtrapolatedPositionsStatus(const posfi_tclMsgExtrapolatedPositionsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId DataSetId;
   tU32 HorizonReleaseId;
   fi_tcl_b8_ExtrapolationReliability ExtrapolationReliability;
   fi_tcl_PosixExactTime TimestampOfFirstPosition;
   fi_tcl_u16_MilliSecond ExtrapolationIntervall;
   std::vector<fi_tcl_ExtrapolatedPosition, std::allocator<fi_tcl_ExtrapolatedPosition> > ExtrapolatedPositionList;
   std::vector<fi_tcl_ExtrapolatedOCDesc, std::allocator<fi_tcl_ExtrapolatedOCDesc> > ExtrapolatedOCRefList;
   std::vector<fi_tcl_NavClusterDesc, std::allocator<fi_tcl_NavClusterDesc> > ClusterRefList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgExtrapolatedPositionsStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_EXTRAPOLATEDPOSITIONSSTATUS;}
};

class posfi_tclMsgPositionGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgPositionGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgPositionGet& operator=(const posfi_tclMsgPositionGet& coRef);
   posfi_tclMsgPositionGet(const posfi_tclMsgPositionGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgPositionGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_POSITIONGET;}
};

class posfi_tclMsgPositionUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgPositionUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgPositionUpReg& operator=(const posfi_tclMsgPositionUpReg& coRef);
   posfi_tclMsgPositionUpReg(const posfi_tclMsgPositionUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgPositionUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_POSITIONUPREG;}
};

class posfi_tclMsgPositionRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgPositionRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgPositionRelUpReg& operator=(const posfi_tclMsgPositionRelUpReg& coRef);
   posfi_tclMsgPositionRelUpReg(const posfi_tclMsgPositionRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgPositionRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_POSITIONRELUPREG;}
};

class posfi_tclMsgPositionStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgPositionStatus():PositionElementBlock(),PositionStatus(),SensorPosixTime(),Height(),Inclination(),Acceleration() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgPositionStatus& operator=(const posfi_tclMsgPositionStatus& coRef);
   posfi_tclMsgPositionStatus(const posfi_tclMsgPositionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_PositionHeadingSpeed PositionElementBlock;
   fi_tcl_e8_PositionCalculationState PositionStatus;
   fi_tcl_PosixExactTime SensorPosixTime;
   fi_tcl_s32_Meter Height;
   fi_tcl_s16_Degree Inclination;
   fi_tcl_s16_CentimeterSecond Acceleration;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgPositionStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_POSITIONSTATUS;}
};

class posfi_tclMsgPositionInfoGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgPositionInfoGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgPositionInfoGet& operator=(const posfi_tclMsgPositionInfoGet& coRef);
   posfi_tclMsgPositionInfoGet(const posfi_tclMsgPositionInfoGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgPositionInfoGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_POSITIONINFOGET;}
};

class posfi_tclMsgPositionInfoUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgPositionInfoUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgPositionInfoUpReg& operator=(const posfi_tclMsgPositionInfoUpReg& coRef);
   posfi_tclMsgPositionInfoUpReg(const posfi_tclMsgPositionInfoUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgPositionInfoUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_POSITIONINFOUPREG;}
};

class posfi_tclMsgPositionInfoRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgPositionInfoRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgPositionInfoRelUpReg& operator=(const posfi_tclMsgPositionInfoRelUpReg& coRef);
   posfi_tclMsgPositionInfoRelUpReg(const posfi_tclMsgPositionInfoRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgPositionInfoRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_POSITIONINFORELUPREG;}
};

class posfi_tclMsgPositionInfoStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgPositionInfoStatus():RoadAttributes(),PositionCoord(),Course(),IsEntryPoint(0),SensorPosixTime() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgPositionInfoStatus& operator=(const posfi_tclMsgPositionInfoStatus& coRef);
   posfi_tclMsgPositionInfoStatus(const posfi_tclMsgPositionInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_RoadAttributes RoadAttributes;
   std::vector<fi_tcl_SingleRoadInfo, std::allocator<fi_tcl_SingleRoadInfo> > PositionInfo;
   fi_tcl_PositionWGS84 PositionCoord;
   fi_tcl_u8_DirectionAbsolute Course;
   tBool IsEntryPoint;
   fi_tcl_PosixExactTime SensorPosixTime;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgPositionInfoStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_POSITIONINFOSTATUS;}
};

class posfi_tclMsgCountryCodeGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgCountryCodeGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgCountryCodeGet& operator=(const posfi_tclMsgCountryCodeGet& coRef);
   posfi_tclMsgCountryCodeGet(const posfi_tclMsgCountryCodeGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgCountryCodeGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_COUNTRYCODEGET;}
};

class posfi_tclMsgCountryCodeUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgCountryCodeUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgCountryCodeUpReg& operator=(const posfi_tclMsgCountryCodeUpReg& coRef);
   posfi_tclMsgCountryCodeUpReg(const posfi_tclMsgCountryCodeUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgCountryCodeUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_COUNTRYCODEUPREG;}
};

class posfi_tclMsgCountryCodeRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgCountryCodeRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgCountryCodeRelUpReg& operator=(const posfi_tclMsgCountryCodeRelUpReg& coRef);
   posfi_tclMsgCountryCodeRelUpReg(const posfi_tclMsgCountryCodeRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgCountryCodeRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_COUNTRYCODERELUPREG;}
};

class posfi_tclMsgCountryCodeStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgCountryCodeStatus():CountryCode() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgCountryCodeStatus& operator=(const posfi_tclMsgCountryCodeStatus& coRef);
   posfi_tclMsgCountryCodeStatus(const posfi_tclMsgCountryCodeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOCountryCode CountryCode;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgCountryCodeStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_COUNTRYCODESTATUS;}
};

class posfi_tclMsgPossibleEntryPointsGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgPossibleEntryPointsGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgPossibleEntryPointsGet& operator=(const posfi_tclMsgPossibleEntryPointsGet& coRef);
   posfi_tclMsgPossibleEntryPointsGet(const posfi_tclMsgPossibleEntryPointsGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgPossibleEntryPointsGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_POSSIBLEENTRYPOINTSGET;}
};

class posfi_tclMsgPossibleEntryPointsUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgPossibleEntryPointsUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgPossibleEntryPointsUpReg& operator=(const posfi_tclMsgPossibleEntryPointsUpReg& coRef);
   posfi_tclMsgPossibleEntryPointsUpReg(const posfi_tclMsgPossibleEntryPointsUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgPossibleEntryPointsUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_POSSIBLEENTRYPOINTSUPREG;}
};

class posfi_tclMsgPossibleEntryPointsRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgPossibleEntryPointsRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgPossibleEntryPointsRelUpReg& operator=(const posfi_tclMsgPossibleEntryPointsRelUpReg& coRef);
   posfi_tclMsgPossibleEntryPointsRelUpReg(const posfi_tclMsgPossibleEntryPointsRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgPossibleEntryPointsRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_POSSIBLEENTRYPOINTSRELUPREG;}
};

class posfi_tclMsgPossibleEntryPointsStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgPossibleEntryPointsStatus():DataSetId(),OffPosition(),SensorTime(0),SensorPosixTime() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgPossibleEntryPointsStatus& operator=(const posfi_tclMsgPossibleEntryPointsStatus& coRef);
   posfi_tclMsgPossibleEntryPointsStatus(const posfi_tclMsgPossibleEntryPointsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_EntryPoint, std::allocator<fi_tcl_EntryPoint> > EntryPoints;
   fi_tcl_u32_DataSetId DataSetId;
   fi_tcl_PositionHeadingSpeed OffPosition;
   tU32 SensorTime;
   fi_tcl_PosixExactTime SensorPosixTime;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgPossibleEntryPointsStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_POSSIBLEENTRYPOINTSSTATUS;}
};

class posfi_tclMsgDeadReckoningPositionGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgDeadReckoningPositionGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgDeadReckoningPositionGet& operator=(const posfi_tclMsgDeadReckoningPositionGet& coRef);
   posfi_tclMsgDeadReckoningPositionGet(const posfi_tclMsgDeadReckoningPositionGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgDeadReckoningPositionGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_DEADRECKONINGPOSITIONGET;}
};

class posfi_tclMsgDeadReckoningPositionUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgDeadReckoningPositionUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgDeadReckoningPositionUpReg& operator=(const posfi_tclMsgDeadReckoningPositionUpReg& coRef);
   posfi_tclMsgDeadReckoningPositionUpReg(const posfi_tclMsgDeadReckoningPositionUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgDeadReckoningPositionUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_DEADRECKONINGPOSITIONUPREG;}
};

class posfi_tclMsgDeadReckoningPositionRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgDeadReckoningPositionRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgDeadReckoningPositionRelUpReg& operator=(const posfi_tclMsgDeadReckoningPositionRelUpReg& coRef);
   posfi_tclMsgDeadReckoningPositionRelUpReg(const posfi_tclMsgDeadReckoningPositionRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgDeadReckoningPositionRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_DEADRECKONINGPOSITIONRELUPREG;}
};

class posfi_tclMsgDeadReckoningPositionStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgDeadReckoningPositionStatus():Status(),SensorTime(0),SensorPosixTime(),Position(),PositionError(),Heading(),HeadingError(),Turnrate(),TurnrateError(),Speed(),SpeedError(),Acceleration(),AccelerationError(),Height(),HeightError(),ProvidedSensors(),DeterminedSensors(),CurrentlyUsedSensors(),CalibratedSensors() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgDeadReckoningPositionStatus& operator=(const posfi_tclMsgDeadReckoningPositionStatus& coRef);
   posfi_tclMsgDeadReckoningPositionStatus(const posfi_tclMsgDeadReckoningPositionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DeadReckoningPositionState Status;
   tU32 SensorTime;
   fi_tcl_PosixExactTime SensorPosixTime;
   fi_tcl_PositionWGS84 Position;
   fi_tcl_ContourEqualProbability PositionError;
   fi_tcl_u16_DirectionAbsolute_CentiDegree Heading;
   fi_tcl_s16_DirectionRelative_CentiDegree HeadingError;
   fi_tcl_s16_CentiDegreePerSecond Turnrate;
   fi_tcl_s16_CentiDegreePerSecond TurnrateError;
   fi_tcl_s16_CentimeterSecond Speed;
   fi_tcl_s16_CentimeterSecond SpeedError;
   fi_tcl_s16_CentimeterSecond Acceleration;
   fi_tcl_s16_CentimeterSecond AccelerationError;
   fi_tcl_s32_Meter Height;
   fi_tcl_s32_Meter HeightError;
   fi_tcl_b16_SensorDataPhalanx ProvidedSensors;
   fi_tcl_b16_SensorDataPhalanx DeterminedSensors;
   fi_tcl_b16_SensorDataPhalanx CurrentlyUsedSensors;
   fi_tcl_b16_SensorDataPhalanx CalibratedSensors;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgDeadReckoningPositionStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_DEADRECKONINGPOSITIONSTATUS;}
};

class posfi_tclMsgPositionHorizon_CallbackStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgPositionHorizon_CallbackStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgPositionHorizon_CallbackStatus& operator=(const posfi_tclMsgPositionHorizon_CallbackStatus& coRef);
   posfi_tclMsgPositionHorizon_CallbackStatus(const posfi_tclMsgPositionHorizon_CallbackStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgPositionHorizon_CallbackStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_POSITIONHORIZON_CALLBACKSTATUS;}
};

class posfi_tclMsgWakeUpStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgWakeUpStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgWakeUpStatus& operator=(const posfi_tclMsgWakeUpStatus& coRef);
   posfi_tclMsgWakeUpStatus(const posfi_tclMsgWakeUpStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgWakeUpStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_WAKEUPSTATUS;}
};

class posfi_tclMsgSwitchPositionListCountGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgSwitchPositionListCountGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgSwitchPositionListCountGet& operator=(const posfi_tclMsgSwitchPositionListCountGet& coRef);
   posfi_tclMsgSwitchPositionListCountGet(const posfi_tclMsgSwitchPositionListCountGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgSwitchPositionListCountGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_SWITCHPOSITIONLISTCOUNTGET;}
};

class posfi_tclMsgSwitchPositionListCountUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgSwitchPositionListCountUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgSwitchPositionListCountUpReg& operator=(const posfi_tclMsgSwitchPositionListCountUpReg& coRef);
   posfi_tclMsgSwitchPositionListCountUpReg(const posfi_tclMsgSwitchPositionListCountUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgSwitchPositionListCountUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_SWITCHPOSITIONLISTCOUNTUPREG;}
};

class posfi_tclMsgSwitchPositionListCountRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgSwitchPositionListCountRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgSwitchPositionListCountRelUpReg& operator=(const posfi_tclMsgSwitchPositionListCountRelUpReg& coRef);
   posfi_tclMsgSwitchPositionListCountRelUpReg(const posfi_tclMsgSwitchPositionListCountRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgSwitchPositionListCountRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_SWITCHPOSITIONLISTCOUNTRELUPREG;}
};

class posfi_tclMsgSwitchPositionListCountStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgSwitchPositionListCountStatus():Status(),NumberSwitchablePositions(0),SubPositionsPossibleDependingOnRoute(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgSwitchPositionListCountStatus& operator=(const posfi_tclMsgSwitchPositionListCountStatus& coRef);
   posfi_tclMsgSwitchPositionListCountStatus(const posfi_tclMsgSwitchPositionListCountStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_SwitchPositionStatus Status;
   tU8 NumberSwitchablePositions;
   tBool SubPositionsPossibleDependingOnRoute;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgSwitchPositionListCountStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_SWITCHPOSITIONLISTCOUNTSTATUS;}
};

class posfi_tclMsgPresentationGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgPresentationGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgPresentationGet& operator=(const posfi_tclMsgPresentationGet& coRef);
   posfi_tclMsgPresentationGet(const posfi_tclMsgPresentationGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgPresentationGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_PRESENTATIONGET;}
};

class posfi_tclMsgPresentationUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgPresentationUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgPresentationUpReg& operator=(const posfi_tclMsgPresentationUpReg& coRef);
   posfi_tclMsgPresentationUpReg(const posfi_tclMsgPresentationUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgPresentationUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_PRESENTATIONUPREG;}
};

class posfi_tclMsgPresentationRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgPresentationRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgPresentationRelUpReg& operator=(const posfi_tclMsgPresentationRelUpReg& coRef);
   posfi_tclMsgPresentationRelUpReg(const posfi_tclMsgPresentationRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgPresentationRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_PRESENTATIONRELUPREG;}
};

class posfi_tclMsgPresentationStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgPresentationStatus():Status() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgPresentationStatus& operator=(const posfi_tclMsgPresentationStatus& coRef);
   posfi_tclMsgPresentationStatus(const posfi_tclMsgPresentationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_PresentationStatus Status;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgPresentationStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_PRESENTATIONSTATUS;}
};

class posfi_tclMsgAutomOdometerCalibrationGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgAutomOdometerCalibrationGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgAutomOdometerCalibrationGet& operator=(const posfi_tclMsgAutomOdometerCalibrationGet& coRef);
   posfi_tclMsgAutomOdometerCalibrationGet(const posfi_tclMsgAutomOdometerCalibrationGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgAutomOdometerCalibrationGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_AUTOMODOMETERCALIBRATIONGET;}
};

class posfi_tclMsgAutomOdometerCalibrationUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgAutomOdometerCalibrationUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgAutomOdometerCalibrationUpReg& operator=(const posfi_tclMsgAutomOdometerCalibrationUpReg& coRef);
   posfi_tclMsgAutomOdometerCalibrationUpReg(const posfi_tclMsgAutomOdometerCalibrationUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgAutomOdometerCalibrationUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_AUTOMODOMETERCALIBRATIONUPREG;}
};

class posfi_tclMsgAutomOdometerCalibrationRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgAutomOdometerCalibrationRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgAutomOdometerCalibrationRelUpReg& operator=(const posfi_tclMsgAutomOdometerCalibrationRelUpReg& coRef);
   posfi_tclMsgAutomOdometerCalibrationRelUpReg(const posfi_tclMsgAutomOdometerCalibrationRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgAutomOdometerCalibrationRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_AUTOMODOMETERCALIBRATIONRELUPREG;}
};

class posfi_tclMsgAutomOdometerCalibrationStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgAutomOdometerCalibrationStatus():State(),Progress() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgAutomOdometerCalibrationStatus& operator=(const posfi_tclMsgAutomOdometerCalibrationStatus& coRef);
   posfi_tclMsgAutomOdometerCalibrationStatus(const posfi_tclMsgAutomOdometerCalibrationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_CalibrationState State;
   fi_tcl_u8_Percent Progress;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgAutomOdometerCalibrationStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_AUTOMODOMETERCALIBRATIONSTATUS;}
};

class posfi_tclMsgEngineeringTextGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgEngineeringTextGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgEngineeringTextGet& operator=(const posfi_tclMsgEngineeringTextGet& coRef);
   posfi_tclMsgEngineeringTextGet(const posfi_tclMsgEngineeringTextGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgEngineeringTextGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_ENGINEERINGTEXTGET;}
};

class posfi_tclMsgEngineeringTextUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgEngineeringTextUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgEngineeringTextUpReg& operator=(const posfi_tclMsgEngineeringTextUpReg& coRef);
   posfi_tclMsgEngineeringTextUpReg(const posfi_tclMsgEngineeringTextUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgEngineeringTextUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG;}
};

class posfi_tclMsgEngineeringTextRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgEngineeringTextRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgEngineeringTextRelUpReg& operator=(const posfi_tclMsgEngineeringTextRelUpReg& coRef);
   posfi_tclMsgEngineeringTextRelUpReg(const posfi_tclMsgEngineeringTextRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgEngineeringTextRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG;}
};

class posfi_tclMsgEngineeringTextStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgEngineeringTextStatus():Message() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgEngineeringTextStatus& operator=(const posfi_tclMsgEngineeringTextStatus& coRef);
   posfi_tclMsgEngineeringTextStatus(const posfi_tclMsgEngineeringTextStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString Message;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgEngineeringTextStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS;}
};

class posfi_tclMsgUsedDatasetGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgUsedDatasetGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgUsedDatasetGet& operator=(const posfi_tclMsgUsedDatasetGet& coRef);
   posfi_tclMsgUsedDatasetGet(const posfi_tclMsgUsedDatasetGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgUsedDatasetGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_USEDDATASETGET;}
};

class posfi_tclMsgUsedDatasetUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgUsedDatasetUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgUsedDatasetUpReg& operator=(const posfi_tclMsgUsedDatasetUpReg& coRef);
   posfi_tclMsgUsedDatasetUpReg(const posfi_tclMsgUsedDatasetUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgUsedDatasetUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_USEDDATASETUPREG;}
};

class posfi_tclMsgUsedDatasetRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgUsedDatasetRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgUsedDatasetRelUpReg& operator=(const posfi_tclMsgUsedDatasetRelUpReg& coRef);
   posfi_tclMsgUsedDatasetRelUpReg(const posfi_tclMsgUsedDatasetRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgUsedDatasetRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_USEDDATASETRELUPREG;}
};

class posfi_tclMsgUsedDatasetStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   posfi_tclMsgUsedDatasetStatus():MediaId(),DataSetId() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   posfi_tclMsgUsedDatasetStatus& operator=(const posfi_tclMsgUsedDatasetStatus& coRef);
   posfi_tclMsgUsedDatasetStatus(const posfi_tclMsgUsedDatasetStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_MediaId MediaId;
   fi_tcl_u32_DataSetId DataSetId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const posfi_tclMsgUsedDatasetStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return posfi_tclToken::EN_MSG_USEDDATASETSTATUS;}
};


#endif
