#include "precompiled.hh"

tBool posfi_tclDescription::bInitMessage(posfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case posfi_tclToken::EN_LAST_TOKEN:
   case posfi_tclToken::EN_LIST:
   case posfi_tclToken::EN_END_OF_STRUCT:
   case posfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case posfi_tclToken::EN_MSG_SETUSEDPOSITIONPATHMETHODSTART:
   {
      if (15 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_MSG_PLACEBACKPATHIDLIST));
      }
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_MSG_SENSORTIME));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_MSG_PATHID));
   } break;
   case posfi_tclToken::EN_MSG_GETPOSITIONDESCRIPTIONMETHODSTART:
   {
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16,posfi_tclSemanticDomain::EN_MSG_NAVLOCATIONBINCONTAINERMAJORVERSION));
      }
   } break;
   case posfi_tclToken::EN_MSG_GETPOSITIONDESCRIPTIONMETHODRESULT:
   {
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LOCATIONDESCRIPTION,posfi_tclSemanticDomain::EN_MSG_POSITIONDESCRIPTION));
   } break;
   case posfi_tclToken::EN_MSG_SETPOSITIONBYCOORDINATESMETHODSTART:
   {
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_ROADCLASSCODE,posfi_tclSemanticDomain::EN_MSG_ROADCLASSFILTER));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8_DIRECTIONRELATIVE,posfi_tclSemanticDomain::EN_MSG_HEADINGTOLERANCE));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16,posfi_tclSemanticDomain::EN_MSG_POSITIONTOLERANCE));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8_DIRECTIONABSOLUTE,posfi_tclSemanticDomain::EN_MSG_HEADING));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONWGS84,posfi_tclSemanticDomain::EN_MSG_WGS84POSITION));
   } break;
   case posfi_tclToken::EN_MSG_SETPOSITIONBYCOORDINATESMETHODRESULT:
   {
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_POSITIONCALCULATIONSTATE,posfi_tclSemanticDomain::EN_MSG_SUCCESS));
   } break;
   case posfi_tclToken::EN_MSG_SETPOSITIONBYLOCATIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_METER,posfi_tclSemanticDomain::EN_MSG_DISTANCETOLOCATIONINFO));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8_DIRECTIONABSOLUTE,posfi_tclSemanticDomain::EN_MSG_HEADING));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LOCATIONDESCRIPTION,posfi_tclSemanticDomain::EN_MSG_LOCATIONINFO));
   } break;
   case posfi_tclToken::EN_MSG_SETPOSITIONBYLOCATIONMETHODRESULT:
   {
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_POSITIONCALCULATIONSTATE,posfi_tclSemanticDomain::EN_MSG_SUCCESS));
   } break;
   case posfi_tclToken::EN_MSG_SETMATCHINGPERMISSIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_MAPMATCHINGRULE,posfi_tclSemanticDomain::EN_MSG_MATCHINGPERMISSION));
   } break;
   case posfi_tclToken::EN_MSG_ACTIVATEPRESENTATIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LOCATIONDESCRIPTION,posfi_tclSemanticDomain::EN_MSG_VEHICLEPOSITION));
   } break;
   case posfi_tclToken::EN_MSG_UPDATEPRESENTATIONPOSITIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_MSG_STEPS));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16,posfi_tclSemanticDomain::EN_MSG_SPEEDVALUE));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_BOOL,posfi_tclSemanticDomain::EN_MSG_USESCALABLESPEEDTABLE));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_ROUTEHANDLE,posfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_TRIPHANDLE,posfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
   } break;
   case posfi_tclToken::EN_MSG_CONTROLAUTOMODOMETERCALIBRATIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_CALIBRATIONOPERATIONCODE,posfi_tclSemanticDomain::EN_MSG_OPERATION));
   } break;
   case posfi_tclToken::EN_MSG_SETDATA2DEFAULTMETHODSTART:
   {
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8_DIRECTIONABSOLUTE,posfi_tclSemanticDomain::EN_MSG_HEADING));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_LATITUDE,posfi_tclSemanticDomain::EN_MSG_LATITUDE));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_LONGITUDE,posfi_tclSemanticDomain::EN_MSG_LONGITUDE));
   } break;
   case posfi_tclToken::EN_MSG_EXTENDEDPOSITIONSTATUS:
   {
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSIXEXACTTIME,posfi_tclSemanticDomain::EN_MSG_SENSORPOSIXTIME));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSHORIZONSTARTPATH,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_MSG_STARTPATHLIST));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_MSG_RELEASEID));
   } break;
   case posfi_tclToken::EN_MSG_EXTENDEDPOSITIONHORIZONSTATUS:
   {
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_HORIZONMOSTPROBABLEPATH,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_MSG_MOSTPROBABLEPATHESLIST));
      }
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVCLUSTERDESC,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_MSG_CLUSTERREFLIST));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSHORIZONONECELLSECTION,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_MSG_ONECELLREFLIST));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSHORIZONPATHSECTION,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_MSG_PATHSECTIONLIST));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_MSG_ROUTEINFOID));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,posfi_tclSemanticDomain::EN_MSG_TRIPSEGMENTNUMBER));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_ROUTEHANDLE,posfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_TRIPHANDLE,posfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
      if (17 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_MSG_INDICESOFLASTROOTSINCURRENTHORIZON));
      }
      if ((9 <= poOutContext->u16GetMajorVersion()) && (poOutContext->u16GetMajorVersion() <= 16))
      {
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_MSG_INDEXOFLASTROOTINCURRENTHORIZON));
      }
      if (17 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSHORIZONROOTELEMENT,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_MSG_ROOTLIST));
      }
      if (poOutContext->u16GetMajorVersion() <= 16)
      {
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_MSG_INDEXOFROOTINLASTHORIZON));
      }
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_MSG_DATABASEID));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_POSHORIZONSTATE,posfi_tclSemanticDomain::EN_MSG_POSITIONHORIZONSTATE));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_MSG_RELEASEID));
   } break;
   case posfi_tclToken::EN_MSG_MOSTSTRAIGHTPATHSTATUS:
   {
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_MSG_PATHSECTIONLISTINDICES));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_MSG_RELEASEID));
   } break;
   case posfi_tclToken::EN_MSG_NAVPOSITIONSTATUS:
   {
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_MSG_HORIZONRELEASEID));
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_CENTIMETERSECOND,posfi_tclSemanticDomain::EN_MSG_ACCELERATION));
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_DEGREE,posfi_tclSemanticDomain::EN_MSG_INCLINATION));
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_METER,posfi_tclSemanticDomain::EN_MSG_HEIGHT));
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONDESCRIPTION,posfi_tclSemanticDomain::EN_MSG_ENTRYPOINT));
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_ENTRYPOINTSTATE,posfi_tclSemanticDomain::EN_MSG_ENTRYPOINTSTATUS));
      }
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_MSG_ROUTEINFOID));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_TRIPSEGMENTNUMBER,posfi_tclSemanticDomain::EN_MSG_TRIPSEGMENTNUMBER));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_ROUTEHANDLE,posfi_tclSemanticDomain::EN_MSG_ROUTEHANDLE));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_TRIPHANDLE,posfi_tclSemanticDomain::EN_MSG_TRIPHANDLE));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSIXEXACTTIME,posfi_tclSemanticDomain::EN_MSG_SENSORPOSIXTIME));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_MSG_SENSORTIME));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_EXTENDEDPOSITIONCALCULATIONSTATE,posfi_tclSemanticDomain::EN_MSG_EXTENDEDPOSITIONSTATUS));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_POSITIONCALCULATIONSTATE,posfi_tclSemanticDomain::EN_MSG_POSITIONSTATUS));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_MEMUSECOND,posfi_tclSemanticDomain::EN_MSG_SPEED));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONDESCRIPTION,posfi_tclSemanticDomain::EN_MSG_NONCOMPLEXPOSITION));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONDESCRIPTION,posfi_tclSemanticDomain::EN_MSG_REALPOSITION));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32_DATASETID,posfi_tclSemanticDomain::EN_MSG_DATASETID));
   } break;
   case posfi_tclToken::EN_MSG_POSITIONPATHESSTATUS:
   {
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_VEHICLECOVARIANCEMATRIX,posfi_tclSemanticDomain::EN_MSG_VEHICLECOVARIANCEMATRIX));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_VEHICLESYSTEMPARAMETER,posfi_tclSemanticDomain::EN_MSG_VEHICLESYSTEMPARAMETER));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSIXEXACTTIME,posfi_tclSemanticDomain::EN_MSG_SENSORPOSIXTIME));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_MSG_SENSORTIME));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_RECTANGLEWGS84,posfi_tclSemanticDomain::EN_MSG_NAVRECTANGLE));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONLIST,posfi_tclSemanticDomain::EN_MSG_NAVPOSITION));
   } break;
   case posfi_tclToken::EN_MSG_EXTRAPOLATEDPOSITIONSSTATUS:
   {
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVCLUSTERDESC,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_MSG_CLUSTERREFLIST));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_EXTRAPOLATEDOCDESC,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_MSG_EXTRAPOLATEDOCREFLIST));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_EXTRAPOLATEDPOSITION,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_MSG_EXTRAPOLATEDPOSITIONLIST));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_MILLISECOND,posfi_tclSemanticDomain::EN_MSG_EXTRAPOLATIONINTERVALL));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSIXEXACTTIME,posfi_tclSemanticDomain::EN_MSG_TIMESTAMPOFFIRSTPOSITION));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_B8_EXTRAPOLATIONRELIABILITY,posfi_tclSemanticDomain::EN_MSG_EXTRAPOLATIONRELIABILITY));
      if (15 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_MSG_HORIZONRELEASEID));
      }
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32_DATASETID,posfi_tclSemanticDomain::EN_MSG_DATASETID));
   } break;
   case posfi_tclToken::EN_MSG_POSITIONSTATUS:
   {
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_CENTIMETERSECOND,posfi_tclSemanticDomain::EN_MSG_ACCELERATION));
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_DEGREE,posfi_tclSemanticDomain::EN_MSG_INCLINATION));
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_METER,posfi_tclSemanticDomain::EN_MSG_HEIGHT));
      }
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSIXEXACTTIME,posfi_tclSemanticDomain::EN_MSG_SENSORPOSIXTIME));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_POSITIONCALCULATIONSTATE,posfi_tclSemanticDomain::EN_MSG_POSITIONSTATUS));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONHEADINGSPEED,posfi_tclSemanticDomain::EN_MSG_POSITIONELEMENTBLOCK));
   } break;
   case posfi_tclToken::EN_MSG_POSITIONINFOSTATUS:
   {
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSIXEXACTTIME,posfi_tclSemanticDomain::EN_MSG_SENSORPOSIXTIME));
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_BOOL,posfi_tclSemanticDomain::EN_MSG_ISENTRYPOINT));
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8_DIRECTIONABSOLUTE,posfi_tclSemanticDomain::EN_MSG_COURSE));
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONWGS84,posfi_tclSemanticDomain::EN_MSG_POSITIONCOORD));
      }
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_SINGLEROADINFO,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_MSG_POSITIONINFO));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_ROADATTRIBUTES,posfi_tclSemanticDomain::EN_MSG_ROADATTRIBUTES));
   } break;
   case posfi_tclToken::EN_MSG_COUNTRYCODESTATUS:
   {
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E16_ISOCOUNTRYCODE,posfi_tclSemanticDomain::EN_MSG_COUNTRYCODE));
   } break;
   case posfi_tclToken::EN_MSG_POSSIBLEENTRYPOINTSSTATUS:
   {
      if (10 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSIXEXACTTIME,posfi_tclSemanticDomain::EN_MSG_SENSORPOSIXTIME));
      }
      if (10 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_MSG_SENSORTIME));
      }
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONHEADINGSPEED,posfi_tclSemanticDomain::EN_MSG_OFFPOSITION));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32_DATASETID,posfi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_ENTRYPOINT,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_MSG_ENTRYPOINTS));
   } break;
   case posfi_tclToken::EN_MSG_DEADRECKONINGPOSITIONSTATUS:
   {
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_B16_SENSORDATAPHALANX,posfi_tclSemanticDomain::EN_MSG_CALIBRATEDSENSORS));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_B16_SENSORDATAPHALANX,posfi_tclSemanticDomain::EN_MSG_CURRENTLYUSEDSENSORS));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_B16_SENSORDATAPHALANX,posfi_tclSemanticDomain::EN_MSG_DETERMINEDSENSORS));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_B16_SENSORDATAPHALANX,posfi_tclSemanticDomain::EN_MSG_PROVIDEDSENSORS));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_METER,posfi_tclSemanticDomain::EN_MSG_HEIGHTERROR));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_METER,posfi_tclSemanticDomain::EN_MSG_HEIGHT));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_CENTIMETERSECOND,posfi_tclSemanticDomain::EN_MSG_ACCELERATIONERROR));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_CENTIMETERSECOND,posfi_tclSemanticDomain::EN_MSG_ACCELERATION));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_CENTIMETERSECOND,posfi_tclSemanticDomain::EN_MSG_SPEEDERROR));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_CENTIMETERSECOND,posfi_tclSemanticDomain::EN_MSG_SPEED));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_CENTIDEGREEPERSECOND,posfi_tclSemanticDomain::EN_MSG_TURNRATEERROR));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_CENTIDEGREEPERSECOND,posfi_tclSemanticDomain::EN_MSG_TURNRATE));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_DIRECTIONRELATIVE_CENTIDEGREE,posfi_tclSemanticDomain::EN_MSG_HEADINGERROR));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_DIRECTIONABSOLUTE_CENTIDEGREE,posfi_tclSemanticDomain::EN_MSG_HEADING));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_CONTOUREQUALPROBABILITY,posfi_tclSemanticDomain::EN_MSG_POSITIONERROR));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONWGS84,posfi_tclSemanticDomain::EN_MSG_POSITION));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSIXEXACTTIME,posfi_tclSemanticDomain::EN_MSG_SENSORPOSIXTIME));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_MSG_SENSORTIME));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_DEADRECKONINGPOSITIONSTATE,posfi_tclSemanticDomain::EN_MSG_STATUS));
   } break;
   case posfi_tclToken::EN_MSG_SWITCHPOSITIONLISTCOUNTSTATUS:
   {
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_BOOL,posfi_tclSemanticDomain::EN_MSG_SUBPOSITIONSPOSSIBLEDEPENDINGONROUTE));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8,posfi_tclSemanticDomain::EN_MSG_NUMBERSWITCHABLEPOSITIONS));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_SWITCHPOSITIONSTATUS,posfi_tclSemanticDomain::EN_MSG_STATUS));
   } break;
   case posfi_tclToken::EN_MSG_PRESENTATIONSTATUS:
   {
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_PRESENTATIONSTATUS,posfi_tclSemanticDomain::EN_MSG_STATUS));
   } break;
   case posfi_tclToken::EN_MSG_AUTOMODOMETERCALIBRATIONSTATUS:
   {
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8_PERCENT,posfi_tclSemanticDomain::EN_MSG_PROGRESS));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_CALIBRATIONSTATE,posfi_tclSemanticDomain::EN_MSG_STATE));
   } break;
   case posfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
   {
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_STRING,posfi_tclSemanticDomain::EN_MSG_MESSAGE));
   } break;
   case posfi_tclToken::EN_MSG_USEDDATASETSTATUS:
   {
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32_DATASETID,posfi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32_MEDIAID,posfi_tclSemanticDomain::EN_MSG_MEDIAID));
   } break;
   case posfi_tclToken::EN_BINCONTAINER:
   case posfi_tclToken::EN_RESERVED:
   case posfi_tclToken::EN_U8_PERCENT:
   case posfi_tclToken::EN_U16_INDEXINREFERENCELIST:
   case posfi_tclToken::EN_S32_KILOGRAM:
   case posfi_tclToken::EN_S32_POUND:
   case posfi_tclToken::EN_S16_METER:
   case posfi_tclToken::EN_S32_METER:
   case posfi_tclToken::EN_S32_YARDS:
   case posfi_tclToken::EN_S32_CENTIMETER:
   case posfi_tclToken::EN_S32_INCH:
   case posfi_tclToken::EN_S32_SECOND:
   case posfi_tclToken::EN_U16_MILLISECOND:
   case posfi_tclToken::EN_POSIXTIME:
   case posfi_tclToken::EN_E8_DST_STATE:
   case posfi_tclToken::EN_TIMEZONEELEMENT:
   case posfi_tclToken::EN_S16_KMPERHOUR:
   case posfi_tclToken::EN_S16_MILESPERHOUR:
   case posfi_tclToken::EN_S16_CENTIMETERSECOND:
   case posfi_tclToken::EN_FIVERSION:
   case posfi_tclToken::EN_S32_LONGITUDE:
   case posfi_tclToken::EN_S32_LATITUDE:
   case posfi_tclToken::EN_POSITIONWGS84:
   case posfi_tclToken::EN_RECTANGLEWGS84:
   case posfi_tclToken::EN_E16_ISOCOUNTRYCODE:
   case posfi_tclToken::EN_U8_DIRECTIONABSOLUTE:
   case posfi_tclToken::EN_U8_DIRECTIONRELATIVE:
   case posfi_tclToken::EN_S16_CENTIDEGREE:
   case posfi_tclToken::EN_S16_DEGREE:
   case posfi_tclToken::EN_U16_DIRECTIONABSOLUTE_CENTIDEGREE:
   case posfi_tclToken::EN_S16_DIRECTIONRELATIVE_CENTIDEGREE:
   case posfi_tclToken::EN_B16_POSITIONRELIABILITY:
   case posfi_tclToken::EN_POSITIONHEADINGSPEED:
   case posfi_tclToken::EN_E8_LOCATIONDESCRIPTIONDATATYPE:
   case posfi_tclToken::EN_B8_LOCATIONDESCRIPTORSTATUS:
   case posfi_tclToken::EN_E16_SELECTIONCRITERIONTYPE:
   case posfi_tclToken::EN_LOCATIONDESCRIPTOR:
   case posfi_tclToken::EN_LOCATIONDESCRIPTORUNION0:
   case posfi_tclToken::EN_STRINGPOSITION:
   case posfi_tclToken::EN_STRINGID:
   case posfi_tclToken::EN_FLISTRING:
   case posfi_tclToken::EN_B8_POSITIONSTATUS:
   case posfi_tclToken::EN_LISTOFPOSITIONS:
   case posfi_tclToken::EN_S32_MEMU:
   case posfi_tclToken::EN_S16_MEMUSECOND:
   case posfi_tclToken::EN_S16_EAU:
   case posfi_tclToken::EN_NAVCLUSTERDESC:
   case posfi_tclToken::EN_S32_EMU:
   case posfi_tclToken::EN_E8_NAVONECELLDIRECTION:
   case posfi_tclToken::EN_E8_PATHTYPE:
   case posfi_tclToken::EN_S16_CURVATUREVALUE:
   case posfi_tclToken::EN_E8_ENTRYPOINTSTATE:
   case posfi_tclToken::EN_U32_RESISTANCE:
   case posfi_tclToken::EN_NAVONECELLDESC:
   case posfi_tclToken::EN_E8_ROADCLASSCODE:
   case posfi_tclToken::EN_U32_DATASETID:
   case posfi_tclToken::EN_U32_MEDIAID:
   case posfi_tclToken::EN_E8_CROSSROADINFOCATEGORY:
   case posfi_tclToken::EN_B32_ROADPROPERTY:
   case posfi_tclToken::EN_E8_NAVSTREETTYPE:
   case posfi_tclToken::EN_E8_SIDEINFO:
   case posfi_tclToken::EN_E8_ROADNETWORKCLASS:
   case posfi_tclToken::EN_NAVZEROCELLDESC:
   case posfi_tclToken::EN_REFERENCEELEMENT:
   case posfi_tclToken::EN_E8_SINGLEROADINFOCATEGORY:
   case posfi_tclToken::EN_SINGLEROADINFO:
   case posfi_tclToken::EN_SINGLEROADINFOUNION0:
   case posfi_tclToken::EN_STATENAMEELEMENT:
   case posfi_tclToken::EN_COUNTYNAMEELEMENT:
   case posfi_tclToken::EN_CITYDISTRICTNAMEELEMENT:
   case posfi_tclToken::EN_BUILDUPAREANAMEELEMENT:
   case posfi_tclToken::EN_ROADNAMEELEMENTLIST:
   case posfi_tclToken::EN_B8_ROADNUMBERSTATUS:
   case posfi_tclToken::EN_REQUIREDTAXDISC:
   case posfi_tclToken::EN_E8_REQUIREDPERMISSIONTYPE:
   case posfi_tclToken::EN_E8_REQUIREDPERMISSION:
   case posfi_tclToken::EN_GENERICREQUIREDPERMISSION:
   case posfi_tclToken::EN_REQUIREDPERMISSION:
   case posfi_tclToken::EN_REQUIREDPERMISSIONUNION0:
   case posfi_tclToken::EN_REQUIREDPERMISSIONLIST:
   case posfi_tclToken::EN_COUNTRYNAMEELEMENT:
   case posfi_tclToken::EN_CITYNAMEELEMENT:
   case posfi_tclToken::EN_ROADNAMELISTSET:
   case posfi_tclToken::EN_COMPASSDIRECTION:
   case posfi_tclToken::EN_E8_INTERSECTIONTYPE:
   case posfi_tclToken::EN_INTERSECTIONNAMEELEMENT:
   case posfi_tclToken::EN_ROADNAMEELEMENT:
   case posfi_tclToken::EN_ROADNUMBER:
   case posfi_tclToken::EN_INTERSECTIONNUMBERELEMENT:
   case posfi_tclToken::EN_ROADNUMBERELEMENTLIST:
   case posfi_tclToken::EN_ROADNUMBERLISTSET:
   case posfi_tclToken::EN_NAVPOSONECELLPROPERTY:
   case posfi_tclToken::EN_NAVPOSONECELLSECTIONDESCRIPTION:
   case posfi_tclToken::EN_POSITIONDESCRIPTION:
   case posfi_tclToken::EN_ENTRYPOINT:
   case posfi_tclToken::EN_ROADATTRIBUTES:
   case posfi_tclToken::EN_E8_EXTRADESCELEMENTTYPE:
   case posfi_tclToken::EN_EXTRADESCELEMENT:
   case posfi_tclToken::EN_B32_DATAPROPERTIES:
   case posfi_tclToken::EN_DATADESCELEMENT:
   case posfi_tclToken::EN_B8_CROSSROADPROPERTIES:
   case posfi_tclToken::EN_CROSSROADDESC:
   case posfi_tclToken::EN_CROSSROADINFO:
   case posfi_tclToken::EN_CROSSROADINFOUNION0:
   case posfi_tclToken::EN_INTERSECTIONDENOTATION:
   case posfi_tclToken::EN_INTERSECTIONDESCELEMENT:
   case posfi_tclToken::EN_E8_BASETRAFFICSIGNCATEGORY:
   case posfi_tclToken::EN_E8_SPEEDSIGN:
   case posfi_tclToken::EN_E16_WARNINGSIGN:
   case posfi_tclToken::EN_E16_REGULATORYSIGN:
   case posfi_tclToken::EN_E16_ADDITIONALTRAFFICSIGN:
   case posfi_tclToken::EN_TIMEDEPENDENTSTRING:
   case posfi_tclToken::EN_B8_LANEDEPENDENTVALIDITY:
   case posfi_tclToken::EN_E8_TRAFFICSIGNQUANTIFIER:
   case posfi_tclToken::EN_ADDITIONALTRAFFICSIGN:
   case posfi_tclToken::EN_ADDITIONALTRAFFICSIGNUNION0:
   case posfi_tclToken::EN_TRAFFICSIGNELEMENT:
   case posfi_tclToken::EN_TRAFFICSIGNELEMENTUNION0:
   case posfi_tclToken::EN_TRAFFICSIGNELEMENTUNION1:
   case posfi_tclToken::EN_TRAFFICSIGNLIST:
   case posfi_tclToken::EN_B32_POICATEGORY:
   case posfi_tclToken::EN_POINTOFINTERESTELEMENT:
   case posfi_tclToken::EN_UNSPECIFIEDTEXT:
   case posfi_tclToken::EN_U16_TRIPHANDLE:
   case posfi_tclToken::EN_U16_TRIPSEGMENTNUMBER:
   case posfi_tclToken::EN_U16_ROUTEHANDLE:
   case posfi_tclToken::EN_E8_POSITIONCALCULATIONSTATE:
   case posfi_tclToken::EN_E8_SWITCHPOSITIONSTATUS:
   case posfi_tclToken::EN_LOCATIONDESCRIPTION:
   case posfi_tclToken::EN_E8_NAVLOCATIONDESCTYPE:
   case posfi_tclToken::EN_NAVLOCATIONDESC:
   case posfi_tclToken::EN_NAVLOCATIONDESCUNION0:
   case posfi_tclToken::EN_E8_BINCONTAINERTYPES:
   case posfi_tclToken::EN_E8_NAVINDEXZFDESTINATIONTYPE:
   case posfi_tclToken::EN_E8_NAVLOCATIONNAVDATATYPE:
   case posfi_tclToken::EN_NAVLOCATIONDATADESC:
   case posfi_tclToken::EN_NAVLOCATIONDATADESCUNION0:
   case posfi_tclToken::EN_NAVSPOTDESTINATIONONECELLPROPERTY:
   case posfi_tclToken::EN_NAVSPOTDESTINATIONONECELLDESC:
   case posfi_tclToken::EN_NAVSPOTDESTINATIONONECELLLISTSET:
   case posfi_tclToken::EN_NAVSTREETDESTINATIONONECELLPROPERTY:
   case posfi_tclToken::EN_NAVSTREETDESTINATIONONECELLDESC:
   case posfi_tclToken::EN_NAVSTREETDESTINATIONONECELLLISTSET:
   case posfi_tclToken::EN_E8_NAVINTERSECTIONTYPE:
   case posfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLPROPERTY:
   case posfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLDESC:
   case posfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
   case posfi_tclToken::EN_NAVAREADESCRIPTIONCIRCLE:
   case posfi_tclToken::EN_NAVAREADESCRIPTIONPOLYGON:
   case posfi_tclToken::EN_E8_DIRECTIONSTATUS:
   case posfi_tclToken::EN_E8_DIRECTIONCATEGORY:
   case posfi_tclToken::EN_B8_DIRECTIONINFOSTATUS:
   case posfi_tclToken::EN_DIRECTIONCATEGORY:
   case posfi_tclToken::EN_DIRECTIONCATEGORYUNION0:
   case posfi_tclToken::EN_DIRECTIONINFO:
   case posfi_tclToken::EN_DIRECTIONINFOLIST:
   case posfi_tclToken::EN_NAVLOCATIONBINCONTAINER:
   case posfi_tclToken::EN_E8_POSHORIZONSTATE:
   case posfi_tclToken::EN_POSIXEXACTTIME:
   case posfi_tclToken::EN_OFFSETSLOPEVALUE:
   case posfi_tclToken::EN_OFFSETHEIGHTVALUE:
   case posfi_tclToken::EN_POSHORIZONSTARTPATH:
   case posfi_tclToken::EN_E8_DIGITALMAPSPEEDCATEGORYTYPE:
   case posfi_tclToken::EN_E8_POSHORIZONSUCCESSORSTATE:
   case posfi_tclToken::EN_B32_PATHSECTIONSTATUS:
   case posfi_tclToken::EN_B8_POSHORIZONSUCCESSORSTATE:
   case posfi_tclToken::EN_POSHORIZONPATHSUCCESSOR:
   case posfi_tclToken::EN_POSHORIZONPATHSECTION:
   case posfi_tclToken::EN_POSHORIZONONECELLDESC:
   case posfi_tclToken::EN_B8_HORIZONONECELLPROPERTYSTATUS:
   case posfi_tclToken::EN_HORIZONMOSTPROBABLEPATH:
   case posfi_tclToken::EN_POSHORIZONROOTELEMENT:
   case posfi_tclToken::EN_POSHORIZONONECELLSECTION:
   case posfi_tclToken::EN_POSITIONPATHDESCRIPTION:
   case posfi_tclToken::EN_POSITIONLIST:
   case posfi_tclToken::EN_E8_EXTENDEDPOSITIONCALCULATIONSTATE:
   case posfi_tclToken::EN_EXTRAPOLATEDPOSITION:
   case posfi_tclToken::EN_EXTRAPOLATEDOCDESC:
   case posfi_tclToken::EN_B8_EXTRAPOLATIONRELIABILITY:
   case posfi_tclToken::EN_VEHICLESYSTEMPARAMETER:
   case posfi_tclToken::EN_VEHICLECOVARIANCEMATRIX:
   case posfi_tclToken::EN_E8_PRESENTATIONSTATUS:
   case posfi_tclToken::EN_E8_CALIBRATIONOPERATIONCODE:
   case posfi_tclToken::EN_E8_CALIBRATIONSTATE:
   case posfi_tclToken::EN_E8_DEADRECKONINGPOSITIONSTATE:
   case posfi_tclToken::EN_S16_CENTIDEGREEPERSECOND:
   case posfi_tclToken::EN_CONTOUREQUALPROBABILITY:
   case posfi_tclToken::EN_B16_SENSORDATAPHALANX:
   case posfi_tclToken::EN_E8_MAPMATCHINGRULE:
   case posfi_tclToken::EN_U8:   
   case posfi_tclToken::EN_S8:   
   case posfi_tclToken::EN_U16:   
   case posfi_tclToken::EN_S16:   
   case posfi_tclToken::EN_U24:   
   case posfi_tclToken::EN_S24:   
   case posfi_tclToken::EN_U32:   
   case posfi_tclToken::EN_S32:   
   case posfi_tclToken::EN_U64:   
   case posfi_tclToken::EN_S64:   
   case posfi_tclToken::EN_F32:   
   case posfi_tclToken::EN_F64:   
   case posfi_tclToken::EN_BOOL:   
   case posfi_tclToken::EN_STRING:   
   case posfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(posfi_tclKnot(enMsgToken,posfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool posfi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool posfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      posfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      posfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      posfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == posfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(posfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(posfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(posfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case posfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == posfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case posfi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            posfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(posfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            posfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(posfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case posfi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case posfi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case posfi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case posfi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case posfi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case posfi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case posfi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case posfi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case posfi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case posfi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case posfi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case posfi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case posfi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case posfi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case posfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case posfi_tclToken::EN_MSG_SETUSEDPOSITIONPATHMETHODSTART:
   case posfi_tclToken::EN_MSG_SETUSEDPOSITIONPATHMETHODRESULT:
   case posfi_tclToken::EN_MSG_GETPOSITIONDESCRIPTIONMETHODSTART:
   case posfi_tclToken::EN_MSG_GETPOSITIONDESCRIPTIONMETHODRESULT:
   case posfi_tclToken::EN_MSG_SETPOSITIONBYCOORDINATESMETHODSTART:
   case posfi_tclToken::EN_MSG_SETPOSITIONBYCOORDINATESMETHODRESULT:
   case posfi_tclToken::EN_MSG_SETPOSITIONBYLOCATIONMETHODSTART:
   case posfi_tclToken::EN_MSG_SETPOSITIONBYLOCATIONMETHODRESULT:
   case posfi_tclToken::EN_MSG_SETMATCHINGPERMISSIONMETHODSTART:
   case posfi_tclToken::EN_MSG_SETMATCHINGPERMISSIONMETHODRESULT:
   case posfi_tclToken::EN_MSG_SWITCHPOSITIONACTIVATEMETHODSTART:
   case posfi_tclToken::EN_MSG_SWITCHPOSITIONACTIVATEMETHODRESULT:
   case posfi_tclToken::EN_MSG_SWITCHPOSITIONDEACTIVATEMETHODSTART:
   case posfi_tclToken::EN_MSG_SWITCHPOSITIONDEACTIVATEMETHODRESULT:
   case posfi_tclToken::EN_MSG_SWITCHPOSITIONTONEXTPOSSIBLEPOSITIONMETHODSTART:
   case posfi_tclToken::EN_MSG_SWITCHPOSITIONTONEXTPOSSIBLEPOSITIONMETHODRESULT:
   case posfi_tclToken::EN_MSG_ACTIVATEPRESENTATIONMETHODSTART:
   case posfi_tclToken::EN_MSG_ACTIVATEPRESENTATIONMETHODRESULT:
   case posfi_tclToken::EN_MSG_DEACTIVATEPRESENTATIONMETHODSTART:
   case posfi_tclToken::EN_MSG_DEACTIVATEPRESENTATIONMETHODRESULT:
   case posfi_tclToken::EN_MSG_UPDATEPRESENTATIONPOSITIONMETHODSTART:
   case posfi_tclToken::EN_MSG_UPDATEPRESENTATIONPOSITIONMETHODRESULT:
   case posfi_tclToken::EN_MSG_CANCELPRESENTATIONUPDATEMETHODSTART:
   case posfi_tclToken::EN_MSG_CANCELPRESENTATIONUPDATEMETHODRESULT:
   case posfi_tclToken::EN_MSG_CONTROLAUTOMODOMETERCALIBRATIONMETHODSTART:
   case posfi_tclToken::EN_MSG_CONTROLAUTOMODOMETERCALIBRATIONMETHODRESULT:
   case posfi_tclToken::EN_MSG_SETDATA2DEFAULTMETHODSTART:
   case posfi_tclToken::EN_MSG_SETDATA2DEFAULTMETHODRESULT:
   case posfi_tclToken::EN_MSG_EXTENDEDPOSITIONUPREG:
   case posfi_tclToken::EN_MSG_EXTENDEDPOSITIONRELUPREG:
   case posfi_tclToken::EN_MSG_EXTENDEDPOSITIONSTATUS:
   case posfi_tclToken::EN_MSG_EXTENDEDPOSITIONHORIZONUPREG:
   case posfi_tclToken::EN_MSG_EXTENDEDPOSITIONHORIZONRELUPREG:
   case posfi_tclToken::EN_MSG_EXTENDEDPOSITIONHORIZONSTATUS:
   case posfi_tclToken::EN_MSG_MOSTSTRAIGHTPATHGET:
   case posfi_tclToken::EN_MSG_MOSTSTRAIGHTPATHUPREG:
   case posfi_tclToken::EN_MSG_MOSTSTRAIGHTPATHRELUPREG:
   case posfi_tclToken::EN_MSG_MOSTSTRAIGHTPATHSTATUS:
   case posfi_tclToken::EN_MSG_NAVPOSITIONGET:
   case posfi_tclToken::EN_MSG_NAVPOSITIONUPREG:
   case posfi_tclToken::EN_MSG_NAVPOSITIONRELUPREG:
   case posfi_tclToken::EN_MSG_NAVPOSITIONSTATUS:
   case posfi_tclToken::EN_MSG_POSITIONPATHESGET:
   case posfi_tclToken::EN_MSG_POSITIONPATHESUPREG:
   case posfi_tclToken::EN_MSG_POSITIONPATHESRELUPREG:
   case posfi_tclToken::EN_MSG_POSITIONPATHESSTATUS:
   case posfi_tclToken::EN_MSG_EXTRAPOLATEDPOSITIONSGET:
   case posfi_tclToken::EN_MSG_EXTRAPOLATEDPOSITIONSUPREG:
   case posfi_tclToken::EN_MSG_EXTRAPOLATEDPOSITIONSRELUPREG:
   case posfi_tclToken::EN_MSG_EXTRAPOLATEDPOSITIONSSTATUS:
   case posfi_tclToken::EN_MSG_POSITIONGET:
   case posfi_tclToken::EN_MSG_POSITIONUPREG:
   case posfi_tclToken::EN_MSG_POSITIONRELUPREG:
   case posfi_tclToken::EN_MSG_POSITIONSTATUS:
   case posfi_tclToken::EN_MSG_POSITIONINFOGET:
   case posfi_tclToken::EN_MSG_POSITIONINFOUPREG:
   case posfi_tclToken::EN_MSG_POSITIONINFORELUPREG:
   case posfi_tclToken::EN_MSG_POSITIONINFOSTATUS:
   case posfi_tclToken::EN_MSG_COUNTRYCODEGET:
   case posfi_tclToken::EN_MSG_COUNTRYCODEUPREG:
   case posfi_tclToken::EN_MSG_COUNTRYCODERELUPREG:
   case posfi_tclToken::EN_MSG_COUNTRYCODESTATUS:
   case posfi_tclToken::EN_MSG_POSSIBLEENTRYPOINTSGET:
   case posfi_tclToken::EN_MSG_POSSIBLEENTRYPOINTSUPREG:
   case posfi_tclToken::EN_MSG_POSSIBLEENTRYPOINTSRELUPREG:
   case posfi_tclToken::EN_MSG_POSSIBLEENTRYPOINTSSTATUS:
   case posfi_tclToken::EN_MSG_DEADRECKONINGPOSITIONGET:
   case posfi_tclToken::EN_MSG_DEADRECKONINGPOSITIONUPREG:
   case posfi_tclToken::EN_MSG_DEADRECKONINGPOSITIONRELUPREG:
   case posfi_tclToken::EN_MSG_DEADRECKONINGPOSITIONSTATUS:
   case posfi_tclToken::EN_MSG_POSITIONHORIZON_CALLBACKSTATUS:
   case posfi_tclToken::EN_MSG_WAKEUPSTATUS:
   case posfi_tclToken::EN_MSG_SWITCHPOSITIONLISTCOUNTGET:
   case posfi_tclToken::EN_MSG_SWITCHPOSITIONLISTCOUNTUPREG:
   case posfi_tclToken::EN_MSG_SWITCHPOSITIONLISTCOUNTRELUPREG:
   case posfi_tclToken::EN_MSG_SWITCHPOSITIONLISTCOUNTSTATUS:
   case posfi_tclToken::EN_MSG_PRESENTATIONGET:
   case posfi_tclToken::EN_MSG_PRESENTATIONUPREG:
   case posfi_tclToken::EN_MSG_PRESENTATIONRELUPREG:
   case posfi_tclToken::EN_MSG_PRESENTATIONSTATUS:
   case posfi_tclToken::EN_MSG_AUTOMODOMETERCALIBRATIONGET:
   case posfi_tclToken::EN_MSG_AUTOMODOMETERCALIBRATIONUPREG:
   case posfi_tclToken::EN_MSG_AUTOMODOMETERCALIBRATIONRELUPREG:
   case posfi_tclToken::EN_MSG_AUTOMODOMETERCALIBRATIONSTATUS:
   case posfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
   case posfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
   case posfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
   case posfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
   case posfi_tclToken::EN_MSG_USEDDATASETGET:
   case posfi_tclToken::EN_MSG_USEDDATASETUPREG:
   case posfi_tclToken::EN_MSG_USEDDATASETRELUPREG:
   case posfi_tclToken::EN_MSG_USEDDATASETSTATUS:
      bInitMessage(enToken);
      break;
   case posfi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_RESERVED:
   {
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_U8_PERCENT:
   {
      fi_tcl_u8_Percent o_u8_Percent;
      if (!bDoIt(o_u8_Percent))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_U16_INDEXINREFERENCELIST:
   {
      fi_tcl_u16_IndexInReferenceList o_u16_IndexInReferenceList;
      if (!bDoIt(o_u16_IndexInReferenceList))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_S32_KILOGRAM:
   {
      fi_tcl_s32_Kilogram o_s32_Kilogram;
      if (!bDoIt(o_s32_Kilogram))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_S32_POUND:
   {
      fi_tcl_s32_Pound o_s32_Pound;
      if (!bDoIt(o_s32_Pound))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_S16_METER:
   {
      fi_tcl_s16_Meter o_s16_Meter;
      if (!bDoIt(o_s16_Meter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_S32_METER:
   {
      fi_tcl_s32_Meter o_s32_Meter;
      if (!bDoIt(o_s32_Meter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_S32_YARDS:
   {
      fi_tcl_s32_Yards o_s32_Yards;
      if (!bDoIt(o_s32_Yards))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_S32_CENTIMETER:
   {
      fi_tcl_s32_Centimeter o_s32_Centimeter;
      if (!bDoIt(o_s32_Centimeter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_S32_INCH:
   {
      fi_tcl_s32_Inch o_s32_Inch;
      if (!bDoIt(o_s32_Inch))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_S32_SECOND:
   {
      fi_tcl_s32_Second o_s32_Second;
      if (!bDoIt(o_s32_Second))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_U16_MILLISECOND:
   {
      fi_tcl_u16_MilliSecond o_u16_MilliSecond;
      if (!bDoIt(o_u16_MilliSecond))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_POSIXTIME:
   {
      if (poVisitor->bDoExpand_POSIXTime(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32,posfi_tclSemanticDomain::EN_TIME));
      }
      else
      {
         fi_tcl_POSIXTime o_POSIXTime;
         if (!bDoIt(o_POSIXTime))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POSIXTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POSIXTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_E8_DST_STATE:
   {
      fi_tcl_e8_DST_State o_e8_DST_State;
      if (!bDoIt(o_e8_DST_State))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_TIMEZONEELEMENT:
   {
      if (poVisitor->bDoExpand_TimeZoneElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_DST_TIMEDOMAIN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_SECOND,posfi_tclSemanticDomain::EN_DSTDIFFERENCE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_DST_STATE,posfi_tclSemanticDomain::EN_DST_STATE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_SECOND,posfi_tclSemanticDomain::EN_TIMEZONEDIFFERENCE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_MULTILANGUAGESTRING,posfi_tclSemanticDomain::EN_ABBREVIATION_DST_IN_EFFECT));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_MULTILANGUAGESTRING,posfi_tclSemanticDomain::EN_ABBREVIATION_STANDARDTIME));
      }
      else
      {
         fi_tcl_TimeZoneElement o_TimeZoneElement;
         if (!bDoIt(o_TimeZoneElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeZoneElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeZoneElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_S16_KMPERHOUR:
   {
      fi_tcl_s16_KmPerHour o_s16_KmPerHour;
      if (!bDoIt(o_s16_KmPerHour))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_S16_MILESPERHOUR:
   {
      fi_tcl_s16_MilesPerHour o_s16_MilesPerHour;
      if (!bDoIt(o_s16_MilesPerHour))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_S16_CENTIMETERSECOND:
   {
      fi_tcl_s16_CentimeterSecond o_s16_CentimeterSecond;
      if (!bDoIt(o_s16_CentimeterSecond))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_FIVERSION:
   {
      if (poVisitor->bDoExpand_FIVersion(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8,posfi_tclSemanticDomain::EN_PATCHVERSION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8,posfi_tclSemanticDomain::EN_MINORVERSION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8,posfi_tclSemanticDomain::EN_MAJORVERSION));
      }
      else
      {
         fi_tcl_FIVersion o_FIVersion;
         if (!bDoIt(o_FIVersion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FIVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FIVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_S32_LONGITUDE:
   {
      fi_tcl_s32_Longitude o_s32_Longitude;
      if (!bDoIt(o_s32_Longitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_S32_LATITUDE:
   {
      fi_tcl_s32_Latitude o_s32_Latitude;
      if (!bDoIt(o_s32_Latitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_POSITIONWGS84:
   {
      if (poVisitor->bDoExpand_PositionWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_LATITUDE,posfi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_LONGITUDE,posfi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_PositionWGS84 o_PositionWGS84;
         if (!bDoIt(o_PositionWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_RECTANGLEWGS84:
   {
      if (poVisitor->bDoExpand_RectangleWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_LATITUDE,posfi_tclSemanticDomain::EN_LATITUDEMAX));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_LONGITUDE,posfi_tclSemanticDomain::EN_LONGITUDEMAX));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_LATITUDE,posfi_tclSemanticDomain::EN_LATITUDEMIN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_LONGITUDE,posfi_tclSemanticDomain::EN_LONGITUDEMIN));
      }
      else
      {
         fi_tcl_RectangleWGS84 o_RectangleWGS84;
         if (!bDoIt(o_RectangleWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RectangleWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RectangleWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_E16_ISOCOUNTRYCODE:
   {
      fi_tcl_e16_ISOCountryCode o_e16_ISOCountryCode;
      if (!bDoIt(o_e16_ISOCountryCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_U8_DIRECTIONABSOLUTE:
   {
      fi_tcl_u8_DirectionAbsolute o_u8_DirectionAbsolute;
      if (!bDoIt(o_u8_DirectionAbsolute))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_U8_DIRECTIONRELATIVE:
   {
      fi_tcl_u8_DirectionRelative o_u8_DirectionRelative;
      if (!bDoIt(o_u8_DirectionRelative))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_S16_CENTIDEGREE:
   {
      fi_tcl_s16_CentiDegree o_s16_CentiDegree;
      if (!bDoIt(o_s16_CentiDegree))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_S16_DEGREE:
   {
      fi_tcl_s16_Degree o_s16_Degree;
      if (!bDoIt(o_s16_Degree))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_U16_DIRECTIONABSOLUTE_CENTIDEGREE:
   {
      fi_tcl_u16_DirectionAbsolute_CentiDegree o_u16_DirectionAbsolute_CentiDegree;
      if (!bDoIt(o_u16_DirectionAbsolute_CentiDegree))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_S16_DIRECTIONRELATIVE_CENTIDEGREE:
   {
      fi_tcl_s16_DirectionRelative_CentiDegree o_s16_DirectionRelative_CentiDegree;
      if (!bDoIt(o_s16_DirectionRelative_CentiDegree))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_B16_POSITIONRELIABILITY:
   {
      fi_tcl_b16_PositionReliability o_b16_PositionReliability;
      if (!bDoIt(o_b16_PositionReliability))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_POSITIONHEADINGSPEED:
   {
      if (poVisitor->bDoExpand_PositionHeadingSpeed(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8_DIRECTIONABSOLUTE,posfi_tclSemanticDomain::EN_HEADING));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_CENTIMETERSECOND,posfi_tclSemanticDomain::EN_SPEED));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_B16_POSITIONRELIABILITY,posfi_tclSemanticDomain::EN_POSITIONRELIABILITY));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONWGS84,posfi_tclSemanticDomain::EN_POSITIONWGS84));
      }
      else
      {
         fi_tcl_PositionHeadingSpeed o_PositionHeadingSpeed;
         if (!bDoIt(o_PositionHeadingSpeed))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionHeadingSpeed.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionHeadingSpeed.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_E8_LOCATIONDESCRIPTIONDATATYPE:
   {
      fi_tcl_e8_LocationDescriptionDataType o_e8_LocationDescriptionDataType;
      if (!bDoIt(o_e8_LocationDescriptionDataType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_B8_LOCATIONDESCRIPTORSTATUS:
   {
      fi_tcl_b8_LocationDescriptorStatus o_b8_LocationDescriptorStatus;
      if (!bDoIt(o_b8_LocationDescriptorStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_E16_SELECTIONCRITERIONTYPE:
   {
      fi_tcl_e16_SelectionCriterionType o_e16_SelectionCriterionType;
      if (!bDoIt(o_e16_SelectionCriterionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_LOCATIONDESCRIPTORUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_LocationDescriptionDataType oDataType;
      oCallStack.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_LOCATIONDESCRIPTIONDATATYPE,posfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_LISTOFPOSITIONS) &&
          !(17 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_FLISTRING) &&
          !(11 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_RESERVED,posfi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_TSTRING:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_STRING,posfi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGID:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_STRINGID,posfi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONHEADINGSPEED:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONHEADINGSPEED,posfi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONWGS84:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONWGS84,posfi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_NAVLOCATIONBINCONTAINER:
         #ifndef FI_S_EXTERNAL_FI
         if (bUseSpecialBinContainer)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVLOCATIONBINCONTAINER,posfi_tclSemanticDomain::EN_DATA));
         }
         else
         #endif // FI_S_EXTERNAL_FI
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_BINCONTAINER,posfi_tclSemanticDomain::EN_DATA));
         }
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGPOSITION:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_STRINGPOSITION,posfi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_FLISTRING:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_FLISTRING,posfi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_LISTOFPOSITIONS:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LISTOFPOSITIONS,posfi_tclSemanticDomain::EN_DATA));
         break;
      }
   } break;
   case posfi_tclToken::EN_LOCATIONDESCRIPTOR:
   {
      if (poVisitor->bDoExpand_LocationDescriptor(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         if (25 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_B8_LOCATIONDESCRIPTORSTATUS,posfi_tclSemanticDomain::EN_STATUS));
         }
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LOCATIONDESCRIPTORUNION0,posfi_tclSemanticDomain::EN_DATA));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E16_SELECTIONCRITERIONTYPE,posfi_tclSemanticDomain::EN_SELECTIONCRITERION));
      }
      else
      {
         fi_tcl_LocationDescriptor o_LocationDescriptor;
         if (!bDoIt(o_LocationDescriptor))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocationDescriptor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocationDescriptor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_STRINGPOSITION:
   {
      if (poVisitor->bDoExpand_StringPosition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONWGS84,posfi_tclSemanticDomain::EN_POSITION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_STRING,posfi_tclSemanticDomain::EN_STRING));
      }
      else
      {
         fi_tcl_StringPosition o_StringPosition;
         if (!bDoIt(o_StringPosition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_STRINGID:
   {
      if (poVisitor->bDoExpand_StringID(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_ID));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_STRING,posfi_tclSemanticDomain::EN_STRING));
      }
      else
      {
         fi_tcl_StringID o_StringID;
         if (!bDoIt(o_StringID))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_FLISTRING:
   {
      if (poVisitor->bDoExpand_FLIString(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_STRING,posfi_tclSemanticDomain::EN_STRING));
      }
      else
      {
         fi_tcl_FLIString o_FLIString;
         if (!bDoIt(o_FLIString))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FLIString.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FLIString.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_B8_POSITIONSTATUS:
   {
      fi_tcl_b8_PositionStatus o_b8_PositionStatus;
      if (!bDoIt(o_b8_PositionStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_LISTOFPOSITIONS:
   {
      if (poVisitor->bDoExpand_ListOfPositions(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONWGS84,posfi_tclSemanticDomain::EN_CURRENTPOSITION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_ID));
         if (26 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_B8_POSITIONSTATUS,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_POSITIONSTATI));
         }
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONWGS84,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_POSITIONS));
      }
      else
      {
         fi_tcl_ListOfPositions o_ListOfPositions;
         if (!bDoIt(o_ListOfPositions))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ListOfPositions.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ListOfPositions.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_S32_MEMU:
   {
      fi_tcl_s32_MEMU o_s32_MEMU;
      if (!bDoIt(o_s32_MEMU))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_S16_MEMUSECOND:
   {
      fi_tcl_s16_MEMUSecond o_s16_MEMUSecond;
      if (!bDoIt(o_s16_MEMUSecond))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_S16_EAU:
   {
      fi_tcl_s16_EAU o_s16_EAU;
      if (!bDoIt(o_s16_EAU))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_NAVCLUSTERDESC:
   {
      if (poVisitor->bDoExpand_NavClusterDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16,posfi_tclSemanticDomain::EN_LENGTH));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_FILEOFFSET));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16,posfi_tclSemanticDomain::EN_FILEID));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8,posfi_tclSemanticDomain::EN_LEVEL));
      }
      else
      {
         fi_tcl_NavClusterDesc o_NavClusterDesc;
         if (!bDoIt(o_NavClusterDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_S32_EMU:
   {
      fi_tcl_s32_EMU o_s32_EMU;
      if (!bDoIt(o_s32_EMU))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_E8_NAVONECELLDIRECTION:
   {
      fi_tcl_e8_NavOneCellDirection o_e8_NavOneCellDirection;
      if (!bDoIt(o_e8_NavOneCellDirection))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_E8_PATHTYPE:
   {
      fi_tcl_e8_PathType o_e8_PathType;
      if (!bDoIt(o_e8_PathType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_S16_CURVATUREVALUE:
   {
      fi_tcl_s16_CurvatureValue o_s16_CurvatureValue;
      if (!bDoIt(o_s16_CurvatureValue))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_E8_ENTRYPOINTSTATE:
   {
      fi_tcl_e8_EntryPointState o_e8_EntryPointState;
      if (!bDoIt(o_e8_EntryPointState))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_U32_RESISTANCE:
   {
      fi_tcl_u32_Resistance o_u32_Resistance;
      if (!bDoIt(o_u32_Resistance))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_NAVONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_INDEXINCLUSTERREFLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_NAVONECELLDIRECTION,posfi_tclSemanticDomain::EN_USEDIRECTION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16,posfi_tclSemanticDomain::EN_ONECELLID));
      }
      else
      {
         fi_tcl_NavOneCellDesc o_NavOneCellDesc;
         if (!bDoIt(o_NavOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_E8_ROADCLASSCODE:
   {
      fi_tcl_e8_RoadClassCode o_e8_RoadClassCode;
      if (!bDoIt(o_e8_RoadClassCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_U32_DATASETID:
   {
      fi_tcl_u32_DataSetId o_u32_DataSetId;
      if (!bDoIt(o_u32_DataSetId))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_U32_MEDIAID:
   {
      fi_tcl_u32_MediaId o_u32_MediaId;
      if (!bDoIt(o_u32_MediaId))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_E8_CROSSROADINFOCATEGORY:
   {
      fi_tcl_e8_CrossroadInfoCategory o_e8_CrossroadInfoCategory;
      if (!bDoIt(o_e8_CrossroadInfoCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_B32_ROADPROPERTY:
   {
      fi_tcl_b32_RoadProperty o_b32_RoadProperty;
      if (!bDoIt(o_b32_RoadProperty))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_E8_NAVSTREETTYPE:
   {
      fi_tcl_e8_NavStreetType o_e8_NavStreetType;
      if (!bDoIt(o_e8_NavStreetType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_E8_SIDEINFO:
   {
      fi_tcl_e8_SideInfo o_e8_SideInfo;
      if (!bDoIt(o_e8_SideInfo))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_E8_ROADNETWORKCLASS:
   {
      fi_tcl_e8_RoadNetworkClass o_e8_RoadNetworkClass;
      if (!bDoIt(o_e8_RoadNetworkClass))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_NAVZEROCELLDESC:
   {
      if (poVisitor->bDoExpand_NavZeroCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_INDEXINCLUSTERREFLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16,posfi_tclSemanticDomain::EN_ZEROCELLID));
      }
      else
      {
         fi_tcl_NavZeroCellDesc o_NavZeroCellDesc;
         if (!bDoIt(o_NavZeroCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavZeroCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavZeroCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_REFERENCEELEMENT:
   {
      if (poVisitor->bDoExpand_ReferenceElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_REFLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_BASELIST));
      }
      else
      {
         fi_tcl_ReferenceElement o_ReferenceElement;
         if (!bDoIt(o_ReferenceElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ReferenceElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ReferenceElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_E8_SINGLEROADINFOCATEGORY:
   {
      fi_tcl_e8_SingleRoadInfoCategory o_e8_SingleRoadInfoCategory;
      if (!bDoIt(o_e8_SingleRoadInfoCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_SINGLEROADINFOUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_SingleRoadInfoCategory oDataType;
      oCallStack.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_SINGLEROADINFOCATEGORY,posfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_TIMEZONEELEMENT) &&
          !(21 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_REQUIREDPERMISSIONLIST) &&
          !(9 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_DIRECTIONINFOLIST) &&
          !(9 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_RESERVED,posfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_COUNTRYNAMEELEMENT:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_COUNTRYNAMEELEMENT,posfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_STATENAMEELEMENT:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_STATENAMEELEMENT,posfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_COUNTYNAMEELEMENT:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_COUNTYNAMEELEMENT,posfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_CITYNAMEELEMENT:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_CITYNAMEELEMENT,posfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_CITYDISTRICTNAMEELEMENT,posfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_BUILDUPAREANAMEELEMENT:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_BUILDUPAREANAMEELEMENT,posfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_ROADNAMEELEMENTLIST:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_ROADNAMEELEMENTLIST,posfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_ROADNUMBERELEMENTLIST:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_ROADNUMBERELEMENTLIST,posfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_EXTRADESCELEMENT:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_EXTRADESCELEMENT,posfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_DATADESCELEMENT:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_DATADESCELEMENT,posfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_INTERSECTIONDESCELEMENT:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_INTERSECTIONDESCELEMENT,posfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_TRAFFICSIGNLIST:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_TRAFFICSIGNLIST,posfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_DIRECTIONINFOLIST:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_DIRECTIONINFOLIST,posfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_REQUIREDPERMISSIONLIST:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_REQUIREDPERMISSIONLIST,posfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_SingleRoadInfoCategory::FI_EN_T_TIMEZONEELEMENT:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_TIMEZONEELEMENT,posfi_tclSemanticDomain::EN_CATEGORY));
         break;
      }
   } break;
   case posfi_tclToken::EN_SINGLEROADINFO:
   {
      if (poVisitor->bDoExpand_SingleRoadInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_SINGLEROADINFOUNION0,posfi_tclSemanticDomain::EN_CATEGORY));
      }
      else
      {
         fi_tcl_SingleRoadInfo o_SingleRoadInfo;
         if (!bDoIt(o_SingleRoadInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SingleRoadInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SingleRoadInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_STATENAMEELEMENT:
   {
      if (poVisitor->bDoExpand_StateNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_STATECODE));
         }
         if (u16MajorVersion <= 10)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16,posfi_tclSemanticDomain::EN_STATECODE_OLD));
         }
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_MULTILANGUAGESTRING,posfi_tclSemanticDomain::EN_STATENAME));
      }
      else
      {
         fi_tcl_StateNameElement o_StateNameElement;
         if (!bDoIt(o_StateNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StateNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StateNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_COUNTYNAMEELEMENT:
   {
      if (poVisitor->bDoExpand_CountyNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_MULTILANGUAGESTRING,posfi_tclSemanticDomain::EN_COUNTYNAME));
      }
      else
      {
         fi_tcl_CountyNameElement o_CountyNameElement;
         if (!bDoIt(o_CountyNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountyNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountyNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_CITYDISTRICTNAMEELEMENT:
   {
      if (poVisitor->bDoExpand_CityDistrictNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_POPULATION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S8,posfi_tclSemanticDomain::EN_PRIORITY));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_MULTILANGUAGESTRING,posfi_tclSemanticDomain::EN_NAME));
      }
      else
      {
         fi_tcl_CityDistrictNameElement o_CityDistrictNameElement;
         if (!bDoIt(o_CityDistrictNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityDistrictNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityDistrictNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_BUILDUPAREANAMEELEMENT:
   {
      if (poVisitor->bDoExpand_BuildUpAreaNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_POPULATION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S8,posfi_tclSemanticDomain::EN_PRIORITY));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_MULTILANGUAGESTRING,posfi_tclSemanticDomain::EN_NAME));
      }
      else
      {
         fi_tcl_BuildUpAreaNameElement o_BuildUpAreaNameElement;
         if (!bDoIt(o_BuildUpAreaNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BuildUpAreaNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BuildUpAreaNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_ROADNAMEELEMENTLIST:
   {
      if (poVisitor->bDoExpand_RoadNameElementList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_MULTILANGUAGESTRING,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_ROADNAMELIST));
      }
      else
      {
         fi_tcl_RoadNameElementList o_RoadNameElementList;
         if (!bDoIt(o_RoadNameElementList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNameElementList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNameElementList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_B8_ROADNUMBERSTATUS:
   {
      fi_tcl_b8_RoadNumberStatus o_b8_RoadNumberStatus;
      if (!bDoIt(o_b8_RoadNumberStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_REQUIREDTAXDISC:
   {
      if (poVisitor->bDoExpand_RequiredTaxDisc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_MULTILANGUAGESTRING,posfi_tclSemanticDomain::EN_DESCRIPTION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_MULTILANGUAGESTRING,posfi_tclSemanticDomain::EN_REQUIREDPERMISSIONNAME));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16,posfi_tclSemanticDomain::EN_REGION));
         }
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E16_ISOCOUNTRYCODE,posfi_tclSemanticDomain::EN_COUNTRYCODE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32,posfi_tclSemanticDomain::EN_REQUIREDPERMISSIONID));
      }
      else
      {
         fi_tcl_RequiredTaxDisc o_RequiredTaxDisc;
         if (!bDoIt(o_RequiredTaxDisc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredTaxDisc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredTaxDisc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_E8_REQUIREDPERMISSIONTYPE:
   {
      fi_tcl_e8_RequiredPermissionType o_e8_RequiredPermissionType;
      if (!bDoIt(o_e8_RequiredPermissionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_E8_REQUIREDPERMISSION:
   {
      fi_tcl_e8_RequiredPermission o_e8_RequiredPermission;
      if (!bDoIt(o_e8_RequiredPermission))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_GENERICREQUIREDPERMISSION:
   {
      if (poVisitor->bDoExpand_GenericRequiredPermission(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_REQUIREDPERMISSIONTYPE,posfi_tclSemanticDomain::EN_REQUIREDPERMISSIONTYPE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_MULTILANGUAGESTRING,posfi_tclSemanticDomain::EN_DESCRIPTION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_MULTILANGUAGESTRING,posfi_tclSemanticDomain::EN_REQUIREDPERMISSIONNAME));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16,posfi_tclSemanticDomain::EN_REGIONID));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E16_ISOCOUNTRYCODE,posfi_tclSemanticDomain::EN_COUNTRYCODE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32,posfi_tclSemanticDomain::EN_REQUIREDPERMISSIONID));
      }
      else
      {
         fi_tcl_GenericRequiredPermission o_GenericRequiredPermission;
         if (!bDoIt(o_GenericRequiredPermission))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GenericRequiredPermission.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GenericRequiredPermission.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_REQUIREDPERMISSIONUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_RequiredPermission oDataType;
      oCallStack.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_REQUIREDPERMISSION,posfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_RequiredPermission::FI_EN_T_GENERICREQUIREDPERMISSION) &&
          !(13 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_RequiredPermission::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_RequiredPermission::FI_EN_T_REQUIREDTAXDISC) &&
          !(u16MajorVersion <= 12))
      {
         oDataType.enType = fi_tcl_e8_RequiredPermission::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_RequiredPermission::FI_EN_T_RESERVED:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_RESERVED,posfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RequiredPermission::FI_EN_T_REQUIREDTAXDISC:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_REQUIREDTAXDISC,posfi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RequiredPermission::FI_EN_T_GENERICREQUIREDPERMISSION:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_GENERICREQUIREDPERMISSION,posfi_tclSemanticDomain::EN_CATEGORY));
         break;
      }
   } break;
   case posfi_tclToken::EN_REQUIREDPERMISSION:
   {
      if (poVisitor->bDoExpand_RequiredPermission(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_REQUIREDPERMISSIONUNION0,posfi_tclSemanticDomain::EN_CATEGORY));
      }
      else
      {
         fi_tcl_RequiredPermission o_RequiredPermission;
         if (!bDoIt(o_RequiredPermission))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredPermission.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredPermission.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_REQUIREDPERMISSIONLIST:
   {
      if (poVisitor->bDoExpand_RequiredPermissionList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_REQUIREDPERMISSION,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_REQUIREDPERMISSIONLIST));
      }
      else
      {
         fi_tcl_RequiredPermissionList o_RequiredPermissionList;
         if (!bDoIt(o_RequiredPermissionList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredPermissionList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredPermissionList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_COUNTRYNAMEELEMENT:
   {
      if (poVisitor->bDoExpand_CountryNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_MULTILANGUAGESTRING,posfi_tclSemanticDomain::EN_NAME));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E16_ISOCOUNTRYCODE,posfi_tclSemanticDomain::EN_CODE));
      }
      else
      {
         fi_tcl_CountryNameElement o_CountryNameElement;
         if (!bDoIt(o_CountryNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_CITYNAMEELEMENT:
   {
      if (poVisitor->bDoExpand_CityNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_POPULATION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S8,posfi_tclSemanticDomain::EN_PRIORITY));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_MULTILANGUAGESTRING,posfi_tclSemanticDomain::EN_NAME));
      }
      else
      {
         fi_tcl_CityNameElement o_CityNameElement;
         if (!bDoIt(o_CityNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CityNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_ROADNAMELISTSET:
   {
      if (poVisitor->bDoExpand_RoadNameListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_MULTILANGUAGESTRING,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_ROADNAMEREFLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_REFERENCEELEMENT,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_RoadNameListSet o_RoadNameListSet;
         if (!bDoIt(o_RoadNameListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNameListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_COMPASSDIRECTION:
   {
      if (poVisitor->bDoExpand_CompassDirection(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_MULTILANGUAGESTRING,posfi_tclSemanticDomain::EN_DIRECTIONDESC));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8_DIRECTIONABSOLUTE,posfi_tclSemanticDomain::EN_DIRECTION));
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_BOOL,posfi_tclSemanticDomain::EN_DIRECTIONISVALID));
         }
      }
      else
      {
         fi_tcl_CompassDirection o_CompassDirection;
         if (!bDoIt(o_CompassDirection))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CompassDirection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CompassDirection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_E8_INTERSECTIONTYPE:
   {
      fi_tcl_e8_IntersectionType o_e8_IntersectionType;
      if (!bDoIt(o_e8_IntersectionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_INTERSECTIONNAMEELEMENT:
   {
      if (poVisitor->bDoExpand_IntersectionNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_STRING,posfi_tclSemanticDomain::EN_INTERSECTIONSUFFIX));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_MULTILANGUAGESTRING,posfi_tclSemanticDomain::EN_INTERSECTIONNAME));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_STRING,posfi_tclSemanticDomain::EN_INTERSECTIONPREFIX));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_INTERSECTIONTYPE,posfi_tclSemanticDomain::EN_INTERSECTIONTYPE));
      }
      else
      {
         fi_tcl_IntersectionNameElement o_IntersectionNameElement;
         if (!bDoIt(o_IntersectionNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_ROADNAMEELEMENT:
   {
      if (poVisitor->bDoExpand_RoadNameElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_MULTILANGUAGESTRING,posfi_tclSemanticDomain::EN_ROADNAME));
      }
      else
      {
         fi_tcl_RoadNameElement o_RoadNameElement;
         if (!bDoIt(o_RoadNameElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNameElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_ROADNUMBER:
   {
      if (poVisitor->bDoExpand_RoadNumber(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_COMPASSDIRECTION,posfi_tclSemanticDomain::EN_COMPASSDIRECTION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_STRING,posfi_tclSemanticDomain::EN_NUMBERSUFFIX));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_STRING,posfi_tclSemanticDomain::EN_ROADNUMBER));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_STRING,posfi_tclSemanticDomain::EN_NUMBERPREFIX));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8,posfi_tclSemanticDomain::EN_NUMBERHIERARCHY));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_STATECODE));
         }
         if (u16MajorVersion <= 10)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16,posfi_tclSemanticDomain::EN_STATE));
         }
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E16_ISOCOUNTRYCODE,posfi_tclSemanticDomain::EN_COUNTRYCODE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_B8_ROADNUMBERSTATUS,posfi_tclSemanticDomain::EN_STATUS));
      }
      else
      {
         fi_tcl_RoadNumber o_RoadNumber;
         if (!bDoIt(o_RoadNumber))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNumber.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNumber.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_INTERSECTIONNUMBERELEMENT:
   {
      if (poVisitor->bDoExpand_IntersectionNumberElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_ROADNUMBER,posfi_tclSemanticDomain::EN_INTERSECTIONNUMBER));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_INTERSECTIONTYPE,posfi_tclSemanticDomain::EN_INTERSECTIONTYPE));
      }
      else
      {
         fi_tcl_IntersectionNumberElement o_IntersectionNumberElement;
         if (!bDoIt(o_IntersectionNumberElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionNumberElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionNumberElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_ROADNUMBERELEMENTLIST:
   {
      if (poVisitor->bDoExpand_RoadNumberElementList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_ROADNUMBER,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_ROADNUMBERLIST));
      }
      else
      {
         fi_tcl_RoadNumberElementList o_RoadNumberElementList;
         if (!bDoIt(o_RoadNumberElementList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNumberElementList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNumberElementList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_ROADNUMBERLISTSET:
   {
      if (poVisitor->bDoExpand_RoadNumberListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_ROADNUMBER,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_ROADNUMBERREFLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_REFERENCEELEMENT,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_ALTERNATIVREFLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_ELEMENTREFLIST));
      }
      else
      {
         fi_tcl_RoadNumberListSet o_RoadNumberListSet;
         if (!bDoIt(o_RoadNumberListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNumberListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNumberListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_NAVPOSONECELLPROPERTY:
   {
      if (poVisitor->bDoExpand_NavPosOneCellProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_STATECODE));
         }
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_B32_ROADPROPERTY,posfi_tclSemanticDomain::EN_ONECELLSTATUS));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_ROADNETWORKCLASS,posfi_tclSemanticDomain::EN_ROADNETWORKCLASS));
         }
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_NAVSTREETTYPE,posfi_tclSemanticDomain::EN_ROADTYPE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_ROADCLASSCODE,posfi_tclSemanticDomain::EN_ROADCLASS));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_EMU,posfi_tclSemanticDomain::EN_ONECELLLENGTH));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E16_ISOCOUNTRYCODE,posfi_tclSemanticDomain::EN_COUNTRYCODE));
      }
      else
      {
         fi_tcl_NavPosOneCellProperty o_NavPosOneCellProperty;
         if (!bDoIt(o_NavPosOneCellProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavPosOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavPosOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_NAVPOSONECELLSECTIONDESCRIPTION:
   {
      if (poVisitor->bDoExpand_NavPosOnecellSectionDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16,posfi_tclSemanticDomain::EN_SECTIONINDEX));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVPOSONECELLPROPERTY,posfi_tclSemanticDomain::EN_ONECELLPROPERTY));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVONECELLDESC,posfi_tclSemanticDomain::EN_ONECELL));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVCLUSTERDESC,posfi_tclSemanticDomain::EN_CLUSTER));
      }
      else
      {
         fi_tcl_NavPosOnecellSectionDescription o_NavPosOnecellSectionDescription;
         if (!bDoIt(o_NavPosOnecellSectionDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavPosOnecellSectionDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavPosOnecellSectionDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_POSITIONDESCRIPTION:
   {
      if (poVisitor->bDoExpand_PositionDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_INDEXINHORIZON));
         }
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_EAU,posfi_tclSemanticDomain::EN_MAPANGLE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_EAU,posfi_tclSemanticDomain::EN_ICOURSE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_MEMU,posfi_tclSemanticDomain::EN_LENGTHTOINTERSECTION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVPOSONECELLSECTIONDESCRIPTION,posfi_tclSemanticDomain::EN_ONECELLSECTION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONWGS84,posfi_tclSemanticDomain::EN_POSITIONCOORD));
      }
      else
      {
         fi_tcl_PositionDescription o_PositionDescription;
         if (!bDoIt(o_PositionDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_ENTRYPOINT:
   {
      if (poVisitor->bDoExpand_EntryPoint(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32_RESISTANCE,posfi_tclSemanticDomain::EN_RESISTANCEMANIPULATOR));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_MEMU,posfi_tclSemanticDomain::EN_LENGTHTOONECELLEND));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVPOSONECELLSECTIONDESCRIPTION,posfi_tclSemanticDomain::EN_ONECELLSECTION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_EAU,posfi_tclSemanticDomain::EN_MAPANGLE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONWGS84,posfi_tclSemanticDomain::EN_POSITIONCOORD));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_ENTRYPOINTSTATE,posfi_tclSemanticDomain::EN_ENTRYPOINTSTATUS));
      }
      else
      {
         fi_tcl_EntryPoint o_EntryPoint;
         if (!bDoIt(o_EntryPoint))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EntryPoint.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EntryPoint.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_ROADATTRIBUTES:
   {
      if (poVisitor->bDoExpand_RoadAttributes(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_ROADNETWORKCLASS,posfi_tclSemanticDomain::EN_ROADNETWORKCLASS));
         }
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_NAVSTREETTYPE,posfi_tclSemanticDomain::EN_ROADTYPE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_B32_ROADPROPERTY,posfi_tclSemanticDomain::EN_ROADPROPERTY));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_ROADCLASSCODE,posfi_tclSemanticDomain::EN_ROADCLASS));
      }
      else
      {
         fi_tcl_RoadAttributes o_RoadAttributes;
         if (!bDoIt(o_RoadAttributes))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadAttributes.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadAttributes.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_E8_EXTRADESCELEMENTTYPE:
   {
      fi_tcl_e8_ExtraDescElementType o_e8_ExtraDescElementType;
      if (!bDoIt(o_e8_ExtraDescElementType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_EXTRADESCELEMENT:
   {
      if (poVisitor->bDoExpand_ExtraDescElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_MULTILANGUAGESTRING,posfi_tclSemanticDomain::EN_LONGDESCRIPTION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_MULTILANGUAGESTRING,posfi_tclSemanticDomain::EN_SHORTDESCRIPTION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_EXTRADESCELEMENTTYPE,posfi_tclSemanticDomain::EN_TYPE));
      }
      else
      {
         fi_tcl_ExtraDescElement o_ExtraDescElement;
         if (!bDoIt(o_ExtraDescElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ExtraDescElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ExtraDescElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_B32_DATAPROPERTIES:
   {
      fi_tcl_b32_DataProperties o_b32_DataProperties;
      if (!bDoIt(o_b32_DataProperties))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_DATADESCELEMENT:
   {
      if (poVisitor->bDoExpand_DataDescElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_CANDYPRODUCTCODE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_B32_DATAPROPERTIES,posfi_tclSemanticDomain::EN_RNWDATAPROPERTIES));
      }
      else
      {
         fi_tcl_DataDescElement o_DataDescElement;
         if (!bDoIt(o_DataDescElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DataDescElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DataDescElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_B8_CROSSROADPROPERTIES:
   {
      fi_tcl_b8_CrossroadProperties o_b8_CrossroadProperties;
      if (!bDoIt(o_b8_CrossroadProperties))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_CROSSROADDESC:
   {
      if (poVisitor->bDoExpand_CrossroadDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_INDEXOFTWINELEMENT));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_ROADATTRIBUTES,posfi_tclSemanticDomain::EN_CROSSROADATTRIBUTES));
         }
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_CROSSROADINFOREFELEMENT));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_B8_CROSSROADPROPERTIES,posfi_tclSemanticDomain::EN_CROSSROADPROPERTY));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8_DIRECTIONABSOLUTE,posfi_tclSemanticDomain::EN_DIRECTIONOFCONNECTEDELEMENT));
         }
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8_DIRECTIONABSOLUTE,posfi_tclSemanticDomain::EN_DIRECTION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_BOOL,posfi_tclSemanticDomain::EN_ISDIRECTIONVALID));
      }
      else
      {
         fi_tcl_CrossroadDesc o_CrossroadDesc;
         if (!bDoIt(o_CrossroadDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CrossroadDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CrossroadDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_CROSSROADINFOUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_CrossroadInfoCategory oDataType;
      oCallStack.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_CROSSROADINFOCATEGORY,posfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_CrossroadInfoCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_RESERVED,posfi_tclSemanticDomain::EN_CROSSROADINFO));
         break;
      case fi_tcl_e8_CrossroadInfoCategory::FI_EN_T_ROADNAMELISTSET:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_ROADNAMELISTSET,posfi_tclSemanticDomain::EN_CROSSROADINFO));
         break;
      case fi_tcl_e8_CrossroadInfoCategory::FI_EN_T_ROADNUMBERLISTSET:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_ROADNUMBERLISTSET,posfi_tclSemanticDomain::EN_CROSSROADINFO));
         break;
      }
   } break;
   case posfi_tclToken::EN_CROSSROADINFO:
   {
      if (poVisitor->bDoExpand_CrossroadInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_CROSSROADINFOUNION0,posfi_tclSemanticDomain::EN_CROSSROADINFO));
      }
      else
      {
         fi_tcl_CrossroadInfo o_CrossroadInfo;
         if (!bDoIt(o_CrossroadInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CrossroadInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CrossroadInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_INTERSECTIONDENOTATION:
   {
      if (poVisitor->bDoExpand_IntersectionDenotation(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_STRING,posfi_tclSemanticDomain::EN_INTERSECTIONNAMESUFFIX));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_MULTILANGUAGESTRING,posfi_tclSemanticDomain::EN_INTERSECTIONNAMEBODY));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_STRING,posfi_tclSemanticDomain::EN_INTERSECTIONNAMEPREFIX));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_ROADNUMBER,posfi_tclSemanticDomain::EN_INTERSECTIONNUMBER));
      }
      else
      {
         fi_tcl_IntersectionDenotation o_IntersectionDenotation;
         if (!bDoIt(o_IntersectionDenotation))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionDenotation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionDenotation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_INTERSECTIONDESCELEMENT:
   {
      if (poVisitor->bDoExpand_IntersectionDescElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_CROSSROADINFO,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_CROSSROADINFOLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_CROSSROADDESC,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_CROSSROADLIST));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONWGS84,posfi_tclSemanticDomain::EN_INTERSECTIONCENTERCOORDINATES));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_EMU,posfi_tclSemanticDomain::EN_INTERSECTIONDIAMETER));
         }
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_INTERSECTIONDENOTATION,posfi_tclSemanticDomain::EN_INTERSECTIONDENOTATION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_INTERSECTIONTYPE,posfi_tclSemanticDomain::EN_INTERSECTIONTYPE));
      }
      else
      {
         fi_tcl_IntersectionDescElement o_IntersectionDescElement;
         if (!bDoIt(o_IntersectionDescElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionDescElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IntersectionDescElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_E8_BASETRAFFICSIGNCATEGORY:
   {
      fi_tcl_e8_BaseTrafficSignCategory o_e8_BaseTrafficSignCategory;
      if (!bDoIt(o_e8_BaseTrafficSignCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_E8_SPEEDSIGN:
   {
      fi_tcl_e8_SpeedSign o_e8_SpeedSign;
      if (!bDoIt(o_e8_SpeedSign))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_E16_WARNINGSIGN:
   {
      fi_tcl_e16_WarningSign o_e16_WarningSign;
      if (!bDoIt(o_e16_WarningSign))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_E16_REGULATORYSIGN:
   {
      fi_tcl_e16_RegulatorySign o_e16_RegulatorySign;
      if (!bDoIt(o_e16_RegulatorySign))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_E16_ADDITIONALTRAFFICSIGN:
   {
      fi_tcl_e16_AdditionalTrafficSign o_e16_AdditionalTrafficSign;
      if (!bDoIt(o_e16_AdditionalTrafficSign))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_TIMEDEPENDENTSTRING:
   {
      fi_tcl_TimeDependentString o_TimeDependentString;
      if (!bDoIt(o_TimeDependentString))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_B8_LANEDEPENDENTVALIDITY:
   {
      fi_tcl_b8_LaneDependentValidity o_b8_LaneDependentValidity;
      if (!bDoIt(o_b8_LaneDependentValidity))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_E8_TRAFFICSIGNQUANTIFIER:
   {
      fi_tcl_e8_TrafficSignQuantifier o_e8_TrafficSignQuantifier;
      if (!bDoIt(o_e8_TrafficSignQuantifier))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_ADDITIONALTRAFFICSIGNUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_TrafficSignQuantifier oDataType;
      oCallStack.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_TRAFFICSIGNQUANTIFIER,posfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_RESERVED,posfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_KMPERHOUR,posfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_MILESPERHOUR,posfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_STRING,posfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8_PERCENT,posfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_B8_LANEDEPENDENTVALIDITY,posfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_TIMEDEPENDENTSTRING,posfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_METER,posfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_YARDS,posfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_MULTILANGUAGESTRING,posfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_CENTIMETER,posfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_INCH,posfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_KILOGRAM,posfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_POUND,posfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         break;
      }
   } break;
   case posfi_tclToken::EN_ADDITIONALTRAFFICSIGN:
   {
      if (poVisitor->bDoExpand_AdditionalTrafficSign(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_ADDITIONALTRAFFICSIGNUNION0,posfi_tclSemanticDomain::EN_QUANTIFIEROFADDSIGN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E16_ADDITIONALTRAFFICSIGN,posfi_tclSemanticDomain::EN_ADDITIONALSIGN));
      }
      else
      {
         fi_tcl_AdditionalTrafficSign o_AdditionalTrafficSign;
         if (!bDoIt(o_AdditionalTrafficSign))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AdditionalTrafficSign.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AdditionalTrafficSign.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_TRAFFICSIGNELEMENTUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_BaseTrafficSignCategory oDataType;
      oCallStack.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_BASETRAFFICSIGNCATEGORY,posfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_REGULATORYSIGN) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_RESERVED,posfi_tclSemanticDomain::EN_BASESIGNUNION));
         break;
      case fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E8_SPEEDSIGN:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_SPEEDSIGN,posfi_tclSemanticDomain::EN_BASESIGNUNION));
         break;
      case fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_WARNINGSIGN:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E16_WARNINGSIGN,posfi_tclSemanticDomain::EN_BASESIGNUNION));
         break;
      case fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_REGULATORYSIGN:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E16_REGULATORYSIGN,posfi_tclSemanticDomain::EN_BASESIGNUNION));
         break;
      }
   } break;
   case posfi_tclToken::EN_TRAFFICSIGNELEMENTUNION1:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_TrafficSignQuantifier oDataType;
      oCallStack.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_TRAFFICSIGNQUANTIFIER,posfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER) &&
          !(7 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_RESERVED,posfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_KMPERHOUR,posfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_MILESPERHOUR,posfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_STRING,posfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8_PERCENT,posfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_B8_LANEDEPENDENTVALIDITY,posfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_TIMEDEPENDENTSTRING,posfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_METER,posfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_YARDS,posfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_MULTILANGUAGESTRING,posfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_CENTIMETER,posfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_INCH,posfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_KILOGRAM,posfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      case fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_POUND,posfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         break;
      }
   } break;
   case posfi_tclToken::EN_TRAFFICSIGNELEMENT:
   {
      if (poVisitor->bDoExpand_TrafficSignElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_ADDITIONALTRAFFICSIGN,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_ADDITIONALSIGNLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_TRAFFICSIGNELEMENTUNION1,posfi_tclSemanticDomain::EN_QUANTIFIEROFBASESIGN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_TRAFFICSIGNELEMENTUNION0,posfi_tclSemanticDomain::EN_BASESIGNUNION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_BOOL,posfi_tclSemanticDomain::EN_VIRTUALTRAFFICSIGN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_BOOL,posfi_tclSemanticDomain::EN_DYNAMICTRAFFICSIGN));
      }
      else
      {
         fi_tcl_TrafficSignElement o_TrafficSignElement;
         if (!bDoIt(o_TrafficSignElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficSignElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficSignElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_TRAFFICSIGNLIST:
   {
      if (poVisitor->bDoExpand_TrafficSignList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_TRAFFICSIGNELEMENT,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_TRAFFICSIGNROADLIST));
      }
      else
      {
         fi_tcl_TrafficSignList o_TrafficSignList;
         if (!bDoIt(o_TrafficSignList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficSignList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficSignList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_B32_POICATEGORY:
   {
      fi_tcl_b32_POICategory o_b32_POICategory;
      if (!bDoIt(o_b32_POICategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_POINTOFINTERESTELEMENT:
   {
      if (poVisitor->bDoExpand_PointOfInterestElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_B32_POICATEGORY,posfi_tclSemanticDomain::EN_CATEGORY));
         }
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_MULTILANGUAGESTRING,posfi_tclSemanticDomain::EN_NAME));
      }
      else
      {
         fi_tcl_PointOfInterestElement o_PointOfInterestElement;
         if (!bDoIt(o_PointOfInterestElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PointOfInterestElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PointOfInterestElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_UNSPECIFIEDTEXT:
   {
      if (poVisitor->bDoExpand_UnspecifiedText(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_MULTILANGUAGESTRING,posfi_tclSemanticDomain::EN_DESCRIPTION));
      }
      else
      {
         fi_tcl_UnspecifiedText o_UnspecifiedText;
         if (!bDoIt(o_UnspecifiedText))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UnspecifiedText.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UnspecifiedText.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_U16_TRIPHANDLE:
   {
      fi_tcl_u16_TripHandle o_u16_TripHandle;
      if (!bDoIt(o_u16_TripHandle))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_U16_TRIPSEGMENTNUMBER:
   {
      fi_tcl_u16_TripSegmentNumber o_u16_TripSegmentNumber;
      if (!bDoIt(o_u16_TripSegmentNumber))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_U16_ROUTEHANDLE:
   {
      fi_tcl_u16_RouteHandle o_u16_RouteHandle;
      if (!bDoIt(o_u16_RouteHandle))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_E8_POSITIONCALCULATIONSTATE:
   {
      fi_tcl_e8_PositionCalculationState o_e8_PositionCalculationState;
      if (!bDoIt(o_e8_PositionCalculationState))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_E8_SWITCHPOSITIONSTATUS:
   {
      fi_tcl_e8_SwitchPositionStatus o_e8_SwitchPositionStatus;
      if (!bDoIt(o_e8_SwitchPositionStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_LOCATIONDESCRIPTION:
   {
      if (poVisitor->bDoExpand_LocationDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LOCATIONDESCRIPTOR,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_DESCRIPTORS));
      }
      else
      {
         fi_tcl_LocationDescription o_LocationDescription;
         if (!bDoIt(o_LocationDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocationDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocationDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_E8_NAVLOCATIONDESCTYPE:
   {
      fi_tcl_e8_NavLocationDescType o_e8_NavLocationDescType;
      if (!bDoIt(o_e8_NavLocationDescType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_NAVLOCATIONDESCUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_NavLocationDescType oDataType;
      oCallStack.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_NAVLOCATIONDESCTYPE,posfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_RESERVED:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_RESERVED,posfi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
         break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVLOCATIONDATADESC:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVLOCATIONDATADESC,posfi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
         break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONCIRCLE:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVAREADESCRIPTIONCIRCLE,posfi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
         break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONPOLYGON:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVAREADESCRIPTIONPOLYGON,posfi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
         break;
      }
   } break;
   case posfi_tclToken::EN_NAVLOCATIONDESC:
   {
      if (poVisitor->bDoExpand_NavLocationDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVLOCATIONDESCUNION0,posfi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
      }
      else
      {
         fi_tcl_NavLocationDesc o_NavLocationDesc;
         if (!bDoIt(o_NavLocationDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_E8_BINCONTAINERTYPES:
   {
      fi_tcl_e8_BinContainerTypes o_e8_BinContainerTypes;
      if (!bDoIt(o_e8_BinContainerTypes))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_E8_NAVINDEXZFDESTINATIONTYPE:
   {
      fi_tcl_e8_NavIndexZFDestinationType o_e8_NavIndexZFDestinationType;
      if (!bDoIt(o_e8_NavIndexZFDestinationType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_E8_NAVLOCATIONNAVDATATYPE:
   {
      fi_tcl_e8_NavLocationNavDataType o_e8_NavLocationNavDataType;
      if (!bDoIt(o_e8_NavLocationNavDataType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_NAVLOCATIONDATADESCUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_NavLocationNavDataType oDataType;
      oCallStack.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_NAVLOCATIONNAVDATATYPE,posfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_RESERVED:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_RESERVED,posfi_tclSemanticDomain::EN_NAVDATATYPE));
         break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET,posfi_tclSemanticDomain::EN_NAVDATATYPE));
         break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSTREETDESTINATIONONECELLLISTSET:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVSTREETDESTINATIONONECELLLISTSET,posfi_tclSemanticDomain::EN_NAVDATATYPE));
         break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSPOTDESTINATIONONECELLLISTSET:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVSPOTDESTINATIONONECELLLISTSET,posfi_tclSemanticDomain::EN_NAVDATATYPE));
         break;
      }
   } break;
   case posfi_tclToken::EN_NAVLOCATIONDATADESC:
   {
      if (poVisitor->bDoExpand_NavLocationDataDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVLOCATIONDATADESCUNION0,posfi_tclSemanticDomain::EN_NAVDATATYPE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONWGS84,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_ACCESSPOINTREFLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONWGS84,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_OBJECTPOINTREFLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_NAVINDEXZFDESTINATIONTYPE,posfi_tclSemanticDomain::EN_INDEXZFDESTTYPE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32_DATASETID,posfi_tclSemanticDomain::EN_NAVDATASETID));
      }
      else
      {
         fi_tcl_NavLocationDataDesc o_NavLocationDataDesc;
         if (!bDoIt(o_NavLocationDataDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationDataDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationDataDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_NAVSPOTDESTINATIONONECELLPROPERTY:
   {
      if (poVisitor->bDoExpand_NavSpotDestinationOneCellProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_INDEXINACCESSPOINTREFLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_INDEXINOBJECTPOINTREFLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONWGS84,posfi_tclSemanticDomain::EN_DECISIONPOINT));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_EMU,posfi_tclSemanticDomain::EN_DESTDISTANCE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_EMU,posfi_tclSemanticDomain::EN_ONECELLLENGTH));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_EMU,posfi_tclSemanticDomain::EN_FROMZEROCELLTOSPOTLENGTH));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_SIDEINFO,posfi_tclSemanticDomain::EN_SIDEINFO));
      }
      else
      {
         fi_tcl_NavSpotDestinationOneCellProperty o_NavSpotDestinationOneCellProperty;
         if (!bDoIt(o_NavSpotDestinationOneCellProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_NAVSPOTDESTINATIONONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavSpotDestinationOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVSPOTDESTINATIONONECELLPROPERTY,posfi_tclSemanticDomain::EN_ONECELLPROPERTY));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVONECELLDESC,posfi_tclSemanticDomain::EN_ONECELLDESC));
      }
      else
      {
         fi_tcl_NavSpotDestinationOneCellDesc o_NavSpotDestinationOneCellDesc;
         if (!bDoIt(o_NavSpotDestinationOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_NAVSPOTDESTINATIONONECELLLISTSET:
   {
      if (poVisitor->bDoExpand_NavSpotDestinationOneCellListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVSPOTDESTINATIONONECELLDESC,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_SPOTDESTINATIONONECELLREFLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVCLUSTERDESC,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_CLUSTERREFLIST));
      }
      else
      {
         fi_tcl_NavSpotDestinationOneCellListSet o_NavSpotDestinationOneCellListSet;
         if (!bDoIt(o_NavSpotDestinationOneCellListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_NAVSTREETDESTINATIONONECELLPROPERTY:
   {
      if (poVisitor->bDoExpand_NavStreetDestinationOneCellProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_INDEXINACCESSPOINTREFLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_INDEXINOBJECTPOINTREFLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_SIDEINFO,posfi_tclSemanticDomain::EN_SIDEINFO));
      }
      else
      {
         fi_tcl_NavStreetDestinationOneCellProperty o_NavStreetDestinationOneCellProperty;
         if (!bDoIt(o_NavStreetDestinationOneCellProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_NAVSTREETDESTINATIONONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavStreetDestinationOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVSTREETDESTINATIONONECELLPROPERTY,posfi_tclSemanticDomain::EN_ONECELLPROPERTY));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVONECELLDESC,posfi_tclSemanticDomain::EN_ONECELLDESC));
      }
      else
      {
         fi_tcl_NavStreetDestinationOneCellDesc o_NavStreetDestinationOneCellDesc;
         if (!bDoIt(o_NavStreetDestinationOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_NAVSTREETDESTINATIONONECELLLISTSET:
   {
      if (poVisitor->bDoExpand_NavStreetDestinationOneCellListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVSTREETDESTINATIONONECELLDESC,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_STREETDESTINATIONONECELLREFLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVCLUSTERDESC,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_CLUSTERREFLIST));
      }
      else
      {
         fi_tcl_NavStreetDestinationOneCellListSet o_NavStreetDestinationOneCellListSet;
         if (!bDoIt(o_NavStreetDestinationOneCellListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_E8_NAVINTERSECTIONTYPE:
   {
      fi_tcl_e8_NavIntersectionType o_e8_NavIntersectionType;
      if (!bDoIt(o_e8_NavIntersectionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLPROPERTY:
   {
      if (poVisitor->bDoExpand_NavIntersectionDestinationZeroCellProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_INDEXINACCESSPOINTREFLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_INDEXINOBJECTPOINTREFLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_NAVINTERSECTIONTYPE,posfi_tclSemanticDomain::EN_INTERSECTIONTYPE));
      }
      else
      {
         fi_tcl_NavIntersectionDestinationZeroCellProperty o_NavIntersectionDestinationZeroCellProperty;
         if (!bDoIt(o_NavIntersectionDestinationZeroCellProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLDESC:
   {
      if (poVisitor->bDoExpand_NavIntersectionDestinationZeroCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLPROPERTY,posfi_tclSemanticDomain::EN_ZEROCELLPROPERTY));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVZEROCELLDESC,posfi_tclSemanticDomain::EN_ZEROCELLDESC));
      }
      else
      {
         fi_tcl_NavIntersectionDestinationZeroCellDesc o_NavIntersectionDestinationZeroCellDesc;
         if (!bDoIt(o_NavIntersectionDestinationZeroCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
   {
      if (poVisitor->bDoExpand_NavIntersectionDestinationZeroCellListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLDESC,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_INTERSECTIONDESTINATIONZEROCELLREFLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVCLUSTERDESC,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_CLUSTERREFLIST));
      }
      else
      {
         fi_tcl_NavIntersectionDestinationZeroCellListSet o_NavIntersectionDestinationZeroCellListSet;
         if (!bDoIt(o_NavIntersectionDestinationZeroCellListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_NAVAREADESCRIPTIONCIRCLE:
   {
      if (poVisitor->bDoExpand_NavAreaDescriptionCircle(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONWGS84,posfi_tclSemanticDomain::EN_COORDINATE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_METER,posfi_tclSemanticDomain::EN_RADIUS));
      }
      else
      {
         fi_tcl_NavAreaDescriptionCircle o_NavAreaDescriptionCircle;
         if (!bDoIt(o_NavAreaDescriptionCircle))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAreaDescriptionCircle.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAreaDescriptionCircle.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_NAVAREADESCRIPTIONPOLYGON:
   {
      if (poVisitor->bDoExpand_NavAreaDescriptionPolygon(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONWGS84,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_COORDINATELIST));
      }
      else
      {
         fi_tcl_NavAreaDescriptionPolygon o_NavAreaDescriptionPolygon;
         if (!bDoIt(o_NavAreaDescriptionPolygon))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAreaDescriptionPolygon.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAreaDescriptionPolygon.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_E8_DIRECTIONSTATUS:
   {
      fi_tcl_e8_DirectionStatus o_e8_DirectionStatus;
      if (!bDoIt(o_e8_DirectionStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_E8_DIRECTIONCATEGORY:
   {
      fi_tcl_e8_DirectionCategory o_e8_DirectionCategory;
      if (!bDoIt(o_e8_DirectionCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_B8_DIRECTIONINFOSTATUS:
   {
      fi_tcl_b8_DirectionInfoStatus o_b8_DirectionInfoStatus;
      if (!bDoIt(o_b8_DirectionInfoStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_DIRECTIONCATEGORYUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_DirectionCategory oDataType;
      oCallStack.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_DIRECTIONCATEGORY,posfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_DirectionCategory::FI_EN_T_COMPASSDIRECTION) &&
          !(9 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_DirectionCategory::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_DirectionCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_RESERVED,posfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_COUNTRYNAMEELEMENT:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_COUNTRYNAMEELEMENT,posfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_STATENAMEELEMENT:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_STATENAMEELEMENT,posfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_COUNTYNAMEELEMENT:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_COUNTYNAMEELEMENT,posfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_CITYNAMEELEMENT:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_CITYNAMEELEMENT,posfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_CITYDISTRICTNAMEELEMENT:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_CITYDISTRICTNAMEELEMENT,posfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_BUILDUPAREANAMEELEMENT:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_BUILDUPAREANAMEELEMENT,posfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_ROADNAMEELEMENT:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_ROADNAMEELEMENT,posfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_ROADNUMBER:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_ROADNUMBER,posfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_INTERSECTIONNAMEELEMENT:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_INTERSECTIONNAMEELEMENT,posfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_INTERSECTIONNUMBERELEMENT:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_INTERSECTIONNUMBERELEMENT,posfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_POINTOFINTERESTELEMENT:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POINTOFINTERESTELEMENT,posfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_UNSPECIFIEDTEXT:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_UNSPECIFIEDTEXT,posfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      case fi_tcl_e8_DirectionCategory::FI_EN_T_COMPASSDIRECTION:
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_COMPASSDIRECTION,posfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         break;
      }
   } break;
   case posfi_tclToken::EN_DIRECTIONCATEGORY:
   {
      if (poVisitor->bDoExpand_DirectionCategory(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_DIRECTIONCATEGORYUNION0,posfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
      }
      else
      {
         fi_tcl_DirectionCategory o_DirectionCategory;
         if (!bDoIt(o_DirectionCategory))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DirectionCategory.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DirectionCategory.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_DIRECTIONINFO:
   {
      if (poVisitor->bDoExpand_DirectionInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         if (21 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_B8_DIRECTIONINFOSTATUS,posfi_tclSemanticDomain::EN_STATUS));
         }
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_DIRECTIONSTATUS,posfi_tclSemanticDomain::EN_DIRECTIONSTATUS));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_DIRECTIONCATEGORY,posfi_tclSemanticDomain::EN_DIRECTIONCATEGORY));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_DIRECTIONID));
      }
      else
      {
         fi_tcl_DirectionInfo o_DirectionInfo;
         if (!bDoIt(o_DirectionInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DirectionInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DirectionInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_DIRECTIONINFOLIST:
   {
      if (poVisitor->bDoExpand_DirectionInfoList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_DIRECTIONINFO,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_DIRECTIONINFOLIST));
      }
      else
      {
         fi_tcl_DirectionInfoList o_DirectionInfoList;
         if (!bDoIt(o_DirectionInfoList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DirectionInfoList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DirectionInfoList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#ifndef FI_S_EXTERNAL_FI
   case posfi_tclToken::EN_NAVLOCATIONBINCONTAINER:
   {
      if (poVisitor->bDoExpand_NavLocationBinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         bInsideBinContainerVersion = true;
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_BINCONTAINER));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVLOCATIONDESC,posfi_tclSemanticDomain::EN_CONTAINERDATA));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_BINCONTAINERTYPES,posfi_tclSemanticDomain::EN_CONTAINERTYPE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_FIVERSION,posfi_tclSemanticDomain::EN_CONTAINERFIVERSION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16,posfi_tclSemanticDomain::EN_SERVICEID));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_CONTAINERLENGTH));
      }
      else
      {
         fi_tcl_NavLocationBinContainer o_NavLocationBinContainer;
         if (!bDoIt(o_NavLocationBinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#endif // FI_S_EXTERNAL_FI
   case posfi_tclToken::EN_E8_POSHORIZONSTATE:
   {
      fi_tcl_e8_PosHorizonState o_e8_PosHorizonState;
      if (!bDoIt(o_e8_PosHorizonState))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_POSIXEXACTTIME:
   {
      if (poVisitor->bDoExpand_PosixExactTime(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16,posfi_tclSemanticDomain::EN_EXACTTIME));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSIXTIME,posfi_tclSemanticDomain::EN_POSIXTIME));
      }
      else
      {
         fi_tcl_PosixExactTime o_PosixExactTime;
         if (!bDoIt(o_PosixExactTime))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PosixExactTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PosixExactTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_OFFSETSLOPEVALUE:
   {
      if (poVisitor->bDoExpand_OffsetSlopeValue(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_CENTIDEGREE,posfi_tclSemanticDomain::EN_SLOPE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_CENTIMETER,posfi_tclSemanticDomain::EN_OFFSET));
      }
      else
      {
         fi_tcl_OffsetSlopeValue o_OffsetSlopeValue;
         if (!bDoIt(o_OffsetSlopeValue))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_OffsetSlopeValue.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_OffsetSlopeValue.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_OFFSETHEIGHTVALUE:
   {
      if (poVisitor->bDoExpand_OffsetHeightValue(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_METER,posfi_tclSemanticDomain::EN_HEIGHT));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_CENTIMETER,posfi_tclSemanticDomain::EN_OFFSET));
      }
      else
      {
         fi_tcl_OffsetHeightValue o_OffsetHeightValue;
         if (!bDoIt(o_OffsetHeightValue))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_OffsetHeightValue.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_OffsetHeightValue.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_POSHORIZONSTARTPATH:
   {
      if (poVisitor->bDoExpand_PosHorizonStartPath(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_MEMU,posfi_tclSemanticDomain::EN_DELTAPLUSCEPERROR));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_MEMU,posfi_tclSemanticDomain::EN_DELTAMINUSCEPERROR));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_MEMU,posfi_tclSemanticDomain::EN_LENGTHTOINTERSECTION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8_PERCENT,posfi_tclSemanticDomain::EN_PROBABILITY));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_INDEXINPOSITIONHORIZON));
      }
      else
      {
         fi_tcl_PosHorizonStartPath o_PosHorizonStartPath;
         if (!bDoIt(o_PosHorizonStartPath))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PosHorizonStartPath.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PosHorizonStartPath.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_E8_DIGITALMAPSPEEDCATEGORYTYPE:
   {
      fi_tcl_e8_DigitalMapSpeedCategoryType o_e8_DigitalMapSpeedCategoryType;
      if (!bDoIt(o_e8_DigitalMapSpeedCategoryType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_E8_POSHORIZONSUCCESSORSTATE:
   {
      fi_tcl_e8_PosHorizonSuccessorState o_e8_PosHorizonSuccessorState;
      if (!bDoIt(o_e8_PosHorizonSuccessorState))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_B32_PATHSECTIONSTATUS:
   {
      fi_tcl_b32_PathSectionStatus o_b32_PathSectionStatus;
      if (!bDoIt(o_b32_PathSectionStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_B8_POSHORIZONSUCCESSORSTATE:
   {
      fi_tcl_b8_PosHorizonSuccessorState o_b8_PosHorizonSuccessorState;
      if (!bDoIt(o_b8_PosHorizonSuccessorState))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_POSHORIZONPATHSUCCESSOR:
   {
      if (poVisitor->bDoExpand_PosHorizonPathSuccessor(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_CURVATUREVALUE,posfi_tclSemanticDomain::EN_TRANSITIONCURVATURE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8_PERCENT,posfi_tclSemanticDomain::EN_RELPROBABILITY));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_PATHID));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_B8_POSHORIZONSUCCESSORSTATE,posfi_tclSemanticDomain::EN_SUCCESSORSTATUS));
         }
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_POSHORIZONSUCCESSORSTATE,posfi_tclSemanticDomain::EN_SUCCESSORSTATE));
         }
      }
      else
      {
         fi_tcl_PosHorizonPathSuccessor o_PosHorizonPathSuccessor;
         if (!bDoIt(o_PosHorizonPathSuccessor))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PosHorizonPathSuccessor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PosHorizonPathSuccessor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_POSHORIZONPATHSECTION:
   {
      if (poVisitor->bDoExpand_PosHorizonPathSection(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         if (37 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_DIGITALMAPSPEEDCATEGORYTYPE,posfi_tclSemanticDomain::EN_SPEEDCATEGORY));
         }
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSHORIZONPATHSUCCESSOR,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_SUCCESSORLIST));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8,posfi_tclSemanticDomain::EN_NUMBEROFMOSTPROBABLEPATHES));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_INDEXOFFIRSTMOSTPROBABLEPATH));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_OCINDEXINROUTELIST));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_B32_PATHSECTIONSTATUS,posfi_tclSemanticDomain::EN_PATHSECTIONSTATUS));
         }
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_BOOL,posfi_tclSemanticDomain::EN_ISPARTOFROUTE));
         }
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_NAVONECELLDIRECTION,posfi_tclSemanticDomain::EN_USEDDIRECTION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_INDEXINONECELLREFLIST));
      }
      else
      {
         fi_tcl_PosHorizonPathSection o_PosHorizonPathSection;
         if (!bDoIt(o_PosHorizonPathSection))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PosHorizonPathSection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PosHorizonPathSection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_POSHORIZONONECELLDESC:
   {
      if (poVisitor->bDoExpand_PosHorizonOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_INDEXINCLUSTERREFLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16,posfi_tclSemanticDomain::EN_ONECELLID));
      }
      else
      {
         fi_tcl_PosHorizonOneCellDesc o_PosHorizonOneCellDesc;
         if (!bDoIt(o_PosHorizonOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PosHorizonOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PosHorizonOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_B8_HORIZONONECELLPROPERTYSTATUS:
   {
      fi_tcl_b8_HorizonOneCellPropertyStatus o_b8_HorizonOneCellPropertyStatus;
      if (!bDoIt(o_b8_HorizonOneCellPropertyStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_HORIZONMOSTPROBABLEPATH:
   {
      if (poVisitor->bDoExpand_HorizonMostProbablePath(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_PATHLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_INDEXOFLASTCOMMONPREDECESSOR));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_INDEXOFPREDECESSORLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8_PERCENT,posfi_tclSemanticDomain::EN_RELPROBABILITY));
      }
      else
      {
         fi_tcl_HorizonMostProbablePath o_HorizonMostProbablePath;
         if (!bDoIt(o_HorizonMostProbablePath))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_HorizonMostProbablePath.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_HorizonMostProbablePath.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_POSHORIZONROOTELEMENT:
   {
      if (poVisitor->bDoExpand_PosHorizonRootElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8_PERCENT,posfi_tclSemanticDomain::EN_ROOTPROBABILITY));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_INDEXOFROOTINLASTHORIZON));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_INDEXOFROOT));
      }
      else
      {
         fi_tcl_PosHorizonRootElement o_PosHorizonRootElement;
         if (!bDoIt(o_PosHorizonRootElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PosHorizonRootElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PosHorizonRootElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_POSHORIZONONECELLSECTION:
   {
      if (poVisitor->bDoExpand_PosHorizonOneCellSection(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_IDLIST));
         }
         if ((19 <= u16MajorVersion) && (u16MajorVersion <= 20))
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_OFFSETHEIGHTVALUE,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_OCHEIGHTS));
         }
         if ((19 <= u16MajorVersion) && (u16MajorVersion <= 20))
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_OFFSETSLOPEVALUE,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_OCSLOPES));
         }
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONWGS84,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_OCSHAPE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_NAVPOSONECELLPROPERTY,posfi_tclSemanticDomain::EN_OCPROPERTIES));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_B8_HORIZONONECELLPROPERTYSTATUS,posfi_tclSemanticDomain::EN_OCPROPERTYSTATUS));
         }
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_BOOL,posfi_tclSemanticDomain::EN_OCPROPERTIESVALID));
         }
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSHORIZONONECELLDESC,posfi_tclSemanticDomain::EN_OCDESC));
      }
      else
      {
         fi_tcl_PosHorizonOneCellSection o_PosHorizonOneCellSection;
         if (!bDoIt(o_PosHorizonOneCellSection))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PosHorizonOneCellSection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PosHorizonOneCellSection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_POSITIONPATHDESCRIPTION:
   {
      if (poVisitor->bDoExpand_PositionPathDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         if (37 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_BOOL,posfi_tclSemanticDomain::EN_SELECTEDBYJUNCTIONORDEVIATION));
         }
         if (26 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_BOOL,posfi_tclSemanticDomain::EN_SLOPEBETTERTHANROUTE));
         }
         if (15 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16,posfi_tclSemanticDomain::EN_CONTINUOUSTURNID));
         }
         if (15 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16,posfi_tclSemanticDomain::EN_SEQUENCEVALUE));
         }
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_PATHTYPE,posfi_tclSemanticDomain::EN_PATHTYPE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32,posfi_tclSemanticDomain::EN_PATHID));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16,posfi_tclSemanticDomain::EN_GRADE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16,posfi_tclSemanticDomain::EN_ONECELLSECTIONLASTNONCOMPLEX));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16,posfi_tclSemanticDomain::EN_ONECELLSECTION));
      }
      else
      {
         fi_tcl_PositionPathDescription o_PositionPathDescription;
         if (!bDoIt(o_PositionPathDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionPathDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionPathDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_POSITIONLIST:
   {
      if (poVisitor->bDoExpand_PositionList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_CENTIMETERSECOND,posfi_tclSemanticDomain::EN_ACCELERATION));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_DEGREE,posfi_tclSemanticDomain::EN_INCLINATION));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_METER,posfi_tclSemanticDomain::EN_HEIGHT));
         }
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_ENTRYPOINTSTATE,posfi_tclSemanticDomain::EN_ENTRYPOINTSTATUS));
         }
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8,posfi_tclSemanticDomain::EN_PATHNUMBERINTERN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8,posfi_tclSemanticDomain::EN_PATHNUMBER));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_POSITIONCALCULATIONSTATE,posfi_tclSemanticDomain::EN_STATUS));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_MEMU,posfi_tclSemanticDomain::EN_ODOMETER));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_MEMUSECOND,posfi_tclSemanticDomain::EN_ISPEED));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_B16_POSITIONRELIABILITY,posfi_tclSemanticDomain::EN_POSITIONRELIABILITY));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONDESCRIPTION,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_PATHLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONPATHDESCRIPTION,posfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_LIST,posfi_tclSemanticDomain::EN_POSITIONPATHES));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONDESCRIPTION,posfi_tclSemanticDomain::EN_MAINPATHLASTNONCOMPLEX));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONDESCRIPTION,posfi_tclSemanticDomain::EN_MAINPATH));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U32_DATASETID,posfi_tclSemanticDomain::EN_DATASETID));
      }
      else
      {
         fi_tcl_PositionList o_PositionList;
         if (!bDoIt(o_PositionList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_E8_EXTENDEDPOSITIONCALCULATIONSTATE:
   {
      fi_tcl_e8_ExtendedPositionCalculationState o_e8_ExtendedPositionCalculationState;
      if (!bDoIt(o_e8_ExtendedPositionCalculationState))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_EXTRAPOLATEDPOSITION:
   {
      if (poVisitor->bDoExpand_ExtrapolatedPosition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_INDEXINONECELLLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_MEMU,posfi_tclSemanticDomain::EN_LENGTHTOINTERSECTION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_MEMUSECOND,posfi_tclSemanticDomain::EN_SPEEDACCURACY));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_EAU,posfi_tclSemanticDomain::EN_HEADINGACCURACY));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_MEMU,posfi_tclSemanticDomain::EN_POSITIONACCURACY));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_MEMUSECOND,posfi_tclSemanticDomain::EN_SPEED));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_EAU,posfi_tclSemanticDomain::EN_MAPANGLE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S16_EAU,posfi_tclSemanticDomain::EN_HEADING));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_POSITIONWGS84,posfi_tclSemanticDomain::EN_POSITIONCOORD));
      }
      else
      {
         fi_tcl_ExtrapolatedPosition o_ExtrapolatedPosition;
         if (!bDoIt(o_ExtrapolatedPosition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ExtrapolatedPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ExtrapolatedPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_EXTRAPOLATEDOCDESC:
   {
      if (poVisitor->bDoExpand_ExtrapolatedOCDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         if (15 <= u16MajorVersion)
         {
            oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_INDEXINHORIZON));
         }
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_INDEXOFSUCCESSOR));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_INDEXINREFERENCELIST,posfi_tclSemanticDomain::EN_INDEXINCLUSTERREFLIST));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U8_PERCENT,posfi_tclSemanticDomain::EN_PROBABILITY));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_E8_NAVONECELLDIRECTION,posfi_tclSemanticDomain::EN_USEDDIRECTION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16,posfi_tclSemanticDomain::EN_ONECELLID));
      }
      else
      {
         fi_tcl_ExtrapolatedOCDesc o_ExtrapolatedOCDesc;
         if (!bDoIt(o_ExtrapolatedOCDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ExtrapolatedOCDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ExtrapolatedOCDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_B8_EXTRAPOLATIONRELIABILITY:
   {
      fi_tcl_b8_ExtrapolationReliability o_b8_ExtrapolationReliability;
      if (!bDoIt(o_b8_ExtrapolationReliability))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_VEHICLESYSTEMPARAMETER:
   {
      if (poVisitor->bDoExpand_VehicleSystemParameter(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_F64,posfi_tclSemanticDomain::EN_TURNRATE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_F64,posfi_tclSemanticDomain::EN_HEADING));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_F64,posfi_tclSemanticDomain::EN_ACCELERATION));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_F64,posfi_tclSemanticDomain::EN_VELOCITY));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_F64,posfi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_F64,posfi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_VehicleSystemParameter o_VehicleSystemParameter;
         if (!bDoIt(o_VehicleSystemParameter))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VehicleSystemParameter.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VehicleSystemParameter.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_VEHICLECOVARIANCEMATRIX:
   {
      if (poVisitor->bDoExpand_VehicleCovarianceMatrix(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_F64,posfi_tclSemanticDomain::EN_P66));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_F64,posfi_tclSemanticDomain::EN_P56));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_F64,posfi_tclSemanticDomain::EN_P55));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_F64,posfi_tclSemanticDomain::EN_P44));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_F64,posfi_tclSemanticDomain::EN_P34));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_F64,posfi_tclSemanticDomain::EN_P33));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_F64,posfi_tclSemanticDomain::EN_P26));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_F64,posfi_tclSemanticDomain::EN_P25));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_F64,posfi_tclSemanticDomain::EN_P24));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_F64,posfi_tclSemanticDomain::EN_P23));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_F64,posfi_tclSemanticDomain::EN_P22));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_F64,posfi_tclSemanticDomain::EN_P16));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_F64,posfi_tclSemanticDomain::EN_P15));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_F64,posfi_tclSemanticDomain::EN_P14));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_F64,posfi_tclSemanticDomain::EN_P13));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_F64,posfi_tclSemanticDomain::EN_P12));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_F64,posfi_tclSemanticDomain::EN_P11));
      }
      else
      {
         fi_tcl_VehicleCovarianceMatrix o_VehicleCovarianceMatrix;
         if (!bDoIt(o_VehicleCovarianceMatrix))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VehicleCovarianceMatrix.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VehicleCovarianceMatrix.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_E8_PRESENTATIONSTATUS:
   {
      fi_tcl_e8_PresentationStatus o_e8_PresentationStatus;
      if (!bDoIt(o_e8_PresentationStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_E8_CALIBRATIONOPERATIONCODE:
   {
      fi_tcl_e8_CalibrationOperationCode o_e8_CalibrationOperationCode;
      if (!bDoIt(o_e8_CalibrationOperationCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_E8_CALIBRATIONSTATE:
   {
      fi_tcl_e8_CalibrationState o_e8_CalibrationState;
      if (!bDoIt(o_e8_CalibrationState))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_E8_DEADRECKONINGPOSITIONSTATE:
   {
      fi_tcl_e8_DeadReckoningPositionState o_e8_DeadReckoningPositionState;
      if (!bDoIt(o_e8_DeadReckoningPositionState))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_S16_CENTIDEGREEPERSECOND:
   {
      fi_tcl_s16_CentiDegreePerSecond o_s16_CentiDegreePerSecond;
      if (!bDoIt(o_s16_CentiDegreePerSecond))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_CONTOUREQUALPROBABILITY:
   {
      if (poVisitor->bDoExpand_ContourEqualProbability(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_END_OF_STRUCT,posfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_U16_DIRECTIONABSOLUTE_CENTIDEGREE,posfi_tclSemanticDomain::EN_CEPHEADING));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_METER,posfi_tclSemanticDomain::EN_CEPSMALL));
         oPath.bGoDown(posfi_tclKnot(posfi_tclToken::EN_S32_METER,posfi_tclSemanticDomain::EN_CEPLARGE));
      }
      else
      {
         fi_tcl_ContourEqualProbability o_ContourEqualProbability;
         if (!bDoIt(o_ContourEqualProbability))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ContourEqualProbability.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ContourEqualProbability.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case posfi_tclToken::EN_B16_SENSORDATAPHALANX:
   {
      fi_tcl_b16_SensorDataPhalanx o_b16_SensorDataPhalanx;
      if (!bDoIt(o_b16_SensorDataPhalanx))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case posfi_tclToken::EN_E8_MAPMATCHINGRULE:
   {
      fi_tcl_e8_MapMatchingRule o_e8_MapMatchingRule;
      if (!bDoIt(o_e8_MapMatchingRule))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
      case posfi_tclToken::EN_UNKNOWN:
      case posfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

