#ifndef __POSFIDEBUGVISITOR_H__
#define __POSFIDEBUGVISITOR_H__

class MY_DECL posfi_tclPrintVisitor : public posfi_tclVisitorBase {

private:
   /* default constructor */ posfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   posfi_tclPrintVisitor(fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Reserved(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u8_Percent(fi_tcl_u8_Percent& o_u8_Percent);
   virtual tVoid vVisit_u16_IndexInReferenceList(fi_tcl_u16_IndexInReferenceList& o_u16_IndexInReferenceList);
   virtual tVoid vVisit_s32_Kilogram(fi_tcl_s32_Kilogram& o_s32_Kilogram);
   virtual tVoid vVisit_s32_Pound(fi_tcl_s32_Pound& o_s32_Pound);
   virtual tVoid vVisit_s16_Meter(fi_tcl_s16_Meter& o_s16_Meter);
   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& o_s32_Meter);
   virtual tVoid vVisit_s32_Yards(fi_tcl_s32_Yards& o_s32_Yards);
   virtual tVoid vVisit_s32_Centimeter(fi_tcl_s32_Centimeter& o_s32_Centimeter);
   virtual tVoid vVisit_s32_Inch(fi_tcl_s32_Inch& o_s32_Inch);
   virtual tVoid vVisit_s32_Second(fi_tcl_s32_Second& o_s32_Second);
   virtual tVoid vVisit_u16_MilliSecond(fi_tcl_u16_MilliSecond& o_u16_MilliSecond);
   virtual tBool bDoExpand_POSIXTime(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DST_State(fi_tcl_e8_DST_State& o_e8_DST_State);
   virtual tBool bDoExpand_TimeZoneElement(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s16_KmPerHour(fi_tcl_s16_KmPerHour& o_s16_KmPerHour);
   virtual tVoid vVisit_s16_MilesPerHour(fi_tcl_s16_MilesPerHour& o_s16_MilesPerHour);
   virtual tVoid vVisit_s16_CentimeterSecond(fi_tcl_s16_CentimeterSecond& o_s16_CentimeterSecond);
   virtual tBool bDoExpand_FIVersion(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tBool bDoExpand_PositionWGS84(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RectangleWGS84(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_u8_DirectionAbsolute(fi_tcl_u8_DirectionAbsolute& o_u8_DirectionAbsolute);
   virtual tVoid vVisit_u8_DirectionRelative(fi_tcl_u8_DirectionRelative& o_u8_DirectionRelative);
   virtual tVoid vVisit_s16_CentiDegree(fi_tcl_s16_CentiDegree& o_s16_CentiDegree);
   virtual tVoid vVisit_s16_Degree(fi_tcl_s16_Degree& o_s16_Degree);
   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(fi_tcl_u16_DirectionAbsolute_CentiDegree& o_u16_DirectionAbsolute_CentiDegree);
   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(fi_tcl_s16_DirectionRelative_CentiDegree& o_s16_DirectionRelative_CentiDegree);
   virtual tVoid vVisit_b16_PositionReliability(fi_tcl_b16_PositionReliability& o_b16_PositionReliability);
   virtual tBool bDoExpand_PositionHeadingSpeed(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_LocationDescriptionDataType(fi_tcl_e8_LocationDescriptionDataType& o_e8_LocationDescriptionDataType);
   virtual tVoid vVisit_b8_LocationDescriptorStatus(fi_tcl_b8_LocationDescriptorStatus& o_b8_LocationDescriptorStatus);
   virtual tVoid vVisit_e16_SelectionCriterionType(fi_tcl_e16_SelectionCriterionType& o_e16_SelectionCriterionType);
   virtual tBool bDoExpand_LocationDescriptor(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StringPosition(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StringID(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_FLIString(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_PositionStatus(fi_tcl_b8_PositionStatus& o_b8_PositionStatus);
   virtual tBool bDoExpand_ListOfPositions(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s32_MEMU(fi_tcl_s32_MEMU& o_s32_MEMU);
   virtual tVoid vVisit_s16_MEMUSecond(fi_tcl_s16_MEMUSecond& o_s16_MEMUSecond);
   virtual tVoid vVisit_s16_EAU(fi_tcl_s16_EAU& o_s16_EAU);
   virtual tBool bDoExpand_NavClusterDesc(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s32_EMU(fi_tcl_s32_EMU& o_s32_EMU);
   virtual tVoid vVisit_e8_NavOneCellDirection(fi_tcl_e8_NavOneCellDirection& o_e8_NavOneCellDirection);
   virtual tVoid vVisit_e8_PathType(fi_tcl_e8_PathType& o_e8_PathType);
   virtual tVoid vVisit_s16_CurvatureValue(fi_tcl_s16_CurvatureValue& o_s16_CurvatureValue);
   virtual tVoid vVisit_e8_EntryPointState(fi_tcl_e8_EntryPointState& o_e8_EntryPointState);
   virtual tVoid vVisit_u32_Resistance(fi_tcl_u32_Resistance& o_u32_Resistance);
   virtual tBool bDoExpand_NavOneCellDesc(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_RoadClassCode(fi_tcl_e8_RoadClassCode& o_e8_RoadClassCode);
   virtual tVoid vVisit_u32_DataSetId(fi_tcl_u32_DataSetId& o_u32_DataSetId);
   virtual tVoid vVisit_u32_MediaId(fi_tcl_u32_MediaId& o_u32_MediaId);
   virtual tVoid vVisit_e8_CrossroadInfoCategory(fi_tcl_e8_CrossroadInfoCategory& o_e8_CrossroadInfoCategory);
   virtual tVoid vVisit_b32_RoadProperty(fi_tcl_b32_RoadProperty& o_b32_RoadProperty);
   virtual tVoid vVisit_e8_NavStreetType(fi_tcl_e8_NavStreetType& o_e8_NavStreetType);
   virtual tVoid vVisit_e8_SideInfo(fi_tcl_e8_SideInfo& o_e8_SideInfo);
   virtual tVoid vVisit_e8_RoadNetworkClass(fi_tcl_e8_RoadNetworkClass& o_e8_RoadNetworkClass);
   virtual tBool bDoExpand_NavZeroCellDesc(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ReferenceElement(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_SingleRoadInfoCategory(fi_tcl_e8_SingleRoadInfoCategory& o_e8_SingleRoadInfoCategory);
   virtual tBool bDoExpand_SingleRoadInfo(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StateNameElement(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CountyNameElement(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CityDistrictNameElement(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_BuildUpAreaNameElement(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadNameElementList(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_RoadNumberStatus(fi_tcl_b8_RoadNumberStatus& o_b8_RoadNumberStatus);
   virtual tBool bDoExpand_RequiredTaxDisc(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_RequiredPermissionType(fi_tcl_e8_RequiredPermissionType& o_e8_RequiredPermissionType);
   virtual tVoid vVisit_e8_RequiredPermission(fi_tcl_e8_RequiredPermission& o_e8_RequiredPermission);
   virtual tBool bDoExpand_GenericRequiredPermission(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RequiredPermission(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RequiredPermissionList(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CountryNameElement(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CityNameElement(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadNameListSet(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CompassDirection(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_IntersectionType(fi_tcl_e8_IntersectionType& o_e8_IntersectionType);
   virtual tBool bDoExpand_IntersectionNameElement(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadNameElement(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadNumber(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IntersectionNumberElement(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadNumberElementList(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadNumberListSet(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavPosOneCellProperty(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavPosOnecellSectionDescription(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PositionDescription(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_EntryPoint(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadAttributes(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_ExtraDescElementType(fi_tcl_e8_ExtraDescElementType& o_e8_ExtraDescElementType);
   virtual tBool bDoExpand_ExtraDescElement(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b32_DataProperties(fi_tcl_b32_DataProperties& o_b32_DataProperties);
   virtual tBool bDoExpand_DataDescElement(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_CrossroadProperties(fi_tcl_b8_CrossroadProperties& o_b8_CrossroadProperties);
   virtual tBool bDoExpand_CrossroadDesc(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CrossroadInfo(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IntersectionDenotation(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IntersectionDescElement(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_BaseTrafficSignCategory(fi_tcl_e8_BaseTrafficSignCategory& o_e8_BaseTrafficSignCategory);
   virtual tVoid vVisit_e8_SpeedSign(fi_tcl_e8_SpeedSign& o_e8_SpeedSign);
   virtual tVoid vVisit_e16_WarningSign(fi_tcl_e16_WarningSign& o_e16_WarningSign);
   virtual tVoid vVisit_e16_RegulatorySign(fi_tcl_e16_RegulatorySign& o_e16_RegulatorySign);
   virtual tVoid vVisit_e16_AdditionalTrafficSign(fi_tcl_e16_AdditionalTrafficSign& o_e16_AdditionalTrafficSign);
   virtual tVoid vVisit_TimeDependentString(fi_tcl_TimeDependentString& o_TimeDependentString);
   virtual tVoid vVisit_b8_LaneDependentValidity(fi_tcl_b8_LaneDependentValidity& o_b8_LaneDependentValidity);
   virtual tVoid vVisit_e8_TrafficSignQuantifier(fi_tcl_e8_TrafficSignQuantifier& o_e8_TrafficSignQuantifier);
   virtual tBool bDoExpand_AdditionalTrafficSign(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TrafficSignElement(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TrafficSignList(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b32_POICategory(fi_tcl_b32_POICategory& o_b32_POICategory);
   virtual tBool bDoExpand_PointOfInterestElement(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UnspecifiedText(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u16_TripHandle(fi_tcl_u16_TripHandle& o_u16_TripHandle);
   virtual tVoid vVisit_u16_TripSegmentNumber(fi_tcl_u16_TripSegmentNumber& o_u16_TripSegmentNumber);
   virtual tVoid vVisit_u16_RouteHandle(fi_tcl_u16_RouteHandle& o_u16_RouteHandle);
   virtual tVoid vVisit_e8_PositionCalculationState(fi_tcl_e8_PositionCalculationState& o_e8_PositionCalculationState);
   virtual tVoid vVisit_e8_SwitchPositionStatus(fi_tcl_e8_SwitchPositionStatus& o_e8_SwitchPositionStatus);
   virtual tBool bDoExpand_LocationDescription(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_NavLocationDescType(fi_tcl_e8_NavLocationDescType& o_e8_NavLocationDescType);
   virtual tBool bDoExpand_NavLocationDesc(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_BinContainerTypes(fi_tcl_e8_BinContainerTypes& o_e8_BinContainerTypes);
   virtual tVoid vVisit_e8_NavIndexZFDestinationType(fi_tcl_e8_NavIndexZFDestinationType& o_e8_NavIndexZFDestinationType);
   virtual tVoid vVisit_e8_NavLocationNavDataType(fi_tcl_e8_NavLocationNavDataType& o_e8_NavLocationNavDataType);
   virtual tBool bDoExpand_NavLocationDataDesc(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavSpotDestinationOneCellProperty(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavSpotDestinationOneCellDesc(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavSpotDestinationOneCellListSet(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavStreetDestinationOneCellProperty(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavStreetDestinationOneCellDesc(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavStreetDestinationOneCellListSet(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_NavIntersectionType(fi_tcl_e8_NavIntersectionType& o_e8_NavIntersectionType);
   virtual tBool bDoExpand_NavIntersectionDestinationZeroCellProperty(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavIntersectionDestinationZeroCellDesc(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavIntersectionDestinationZeroCellListSet(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavAreaDescriptionCircle(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavAreaDescriptionPolygon(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DirectionStatus(fi_tcl_e8_DirectionStatus& o_e8_DirectionStatus);
   virtual tVoid vVisit_e8_DirectionCategory(fi_tcl_e8_DirectionCategory& o_e8_DirectionCategory);
   virtual tVoid vVisit_b8_DirectionInfoStatus(fi_tcl_b8_DirectionInfoStatus& o_b8_DirectionInfoStatus);
   virtual tBool bDoExpand_DirectionCategory(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DirectionInfo(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DirectionInfoList(posfi_tclSemanticDomain::tenType enSemantic);
#ifndef FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_NavLocationBinContainer(posfi_tclSemanticDomain::tenType enSemantic);
#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_e8_PosHorizonState(fi_tcl_e8_PosHorizonState& o_e8_PosHorizonState);
   virtual tBool bDoExpand_PosixExactTime(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_OffsetSlopeValue(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_OffsetHeightValue(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PosHorizonStartPath(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DigitalMapSpeedCategoryType(fi_tcl_e8_DigitalMapSpeedCategoryType& o_e8_DigitalMapSpeedCategoryType);
   virtual tVoid vVisit_e8_PosHorizonSuccessorState(fi_tcl_e8_PosHorizonSuccessorState& o_e8_PosHorizonSuccessorState);
   virtual tVoid vVisit_b32_PathSectionStatus(fi_tcl_b32_PathSectionStatus& o_b32_PathSectionStatus);
   virtual tVoid vVisit_b8_PosHorizonSuccessorState(fi_tcl_b8_PosHorizonSuccessorState& o_b8_PosHorizonSuccessorState);
   virtual tBool bDoExpand_PosHorizonPathSuccessor(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PosHorizonPathSection(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PosHorizonOneCellDesc(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_HorizonOneCellPropertyStatus(fi_tcl_b8_HorizonOneCellPropertyStatus& o_b8_HorizonOneCellPropertyStatus);
   virtual tBool bDoExpand_HorizonMostProbablePath(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PosHorizonRootElement(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PosHorizonOneCellSection(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PositionPathDescription(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PositionList(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_ExtendedPositionCalculationState(fi_tcl_e8_ExtendedPositionCalculationState& o_e8_ExtendedPositionCalculationState);
   virtual tBool bDoExpand_ExtrapolatedPosition(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ExtrapolatedOCDesc(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_ExtrapolationReliability(fi_tcl_b8_ExtrapolationReliability& o_b8_ExtrapolationReliability);
   virtual tBool bDoExpand_VehicleSystemParameter(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_VehicleCovarianceMatrix(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_PresentationStatus(fi_tcl_e8_PresentationStatus& o_e8_PresentationStatus);
   virtual tVoid vVisit_e8_CalibrationOperationCode(fi_tcl_e8_CalibrationOperationCode& o_e8_CalibrationOperationCode);
   virtual tVoid vVisit_e8_CalibrationState(fi_tcl_e8_CalibrationState& o_e8_CalibrationState);
   virtual tVoid vVisit_e8_DeadReckoningPositionState(fi_tcl_e8_DeadReckoningPositionState& o_e8_DeadReckoningPositionState);
   virtual tVoid vVisit_s16_CentiDegreePerSecond(fi_tcl_s16_CentiDegreePerSecond& o_s16_CentiDegreePerSecond);
   virtual tBool bDoExpand_ContourEqualProbability(posfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b16_SensorDataPhalanx(fi_tcl_b16_SensorDataPhalanx& o_b16_SensorDataPhalanx);
   virtual tVoid vVisit_e8_MapMatchingRule(fi_tcl_e8_MapMatchingRule& o_e8_MapMatchingRule);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   fi_tclOutput* poOutput;
};


class MY_DECL posfi_tclRandomInitVisitor : public posfi_tclVisitorBase {
public:

   posfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_u8_Percent(fi_tcl_u8_Percent& o_u8_Percent);
   virtual tVoid vVisit_u16_IndexInReferenceList(fi_tcl_u16_IndexInReferenceList& o_u16_IndexInReferenceList);
   virtual tVoid vVisit_s32_Kilogram(fi_tcl_s32_Kilogram& o_s32_Kilogram);
   virtual tVoid vVisit_s32_Pound(fi_tcl_s32_Pound& o_s32_Pound);
   virtual tVoid vVisit_s16_Meter(fi_tcl_s16_Meter& o_s16_Meter);
   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& o_s32_Meter);
   virtual tVoid vVisit_s32_Yards(fi_tcl_s32_Yards& o_s32_Yards);
   virtual tVoid vVisit_s32_Centimeter(fi_tcl_s32_Centimeter& o_s32_Centimeter);
   virtual tVoid vVisit_s32_Inch(fi_tcl_s32_Inch& o_s32_Inch);
   virtual tVoid vVisit_s32_Second(fi_tcl_s32_Second& o_s32_Second);
   virtual tVoid vVisit_u16_MilliSecond(fi_tcl_u16_MilliSecond& o_u16_MilliSecond);
   virtual tVoid vVisit_e8_DST_State(fi_tcl_e8_DST_State& o_e8_DST_State);
   virtual tVoid vVisit_s16_KmPerHour(fi_tcl_s16_KmPerHour& o_s16_KmPerHour);
   virtual tVoid vVisit_s16_MilesPerHour(fi_tcl_s16_MilesPerHour& o_s16_MilesPerHour);
   virtual tVoid vVisit_s16_CentimeterSecond(fi_tcl_s16_CentimeterSecond& o_s16_CentimeterSecond);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_u8_DirectionAbsolute(fi_tcl_u8_DirectionAbsolute& o_u8_DirectionAbsolute);
   virtual tVoid vVisit_u8_DirectionRelative(fi_tcl_u8_DirectionRelative& o_u8_DirectionRelative);
   virtual tVoid vVisit_s16_CentiDegree(fi_tcl_s16_CentiDegree& o_s16_CentiDegree);
   virtual tVoid vVisit_s16_Degree(fi_tcl_s16_Degree& o_s16_Degree);
   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(fi_tcl_u16_DirectionAbsolute_CentiDegree& o_u16_DirectionAbsolute_CentiDegree);
   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(fi_tcl_s16_DirectionRelative_CentiDegree& o_s16_DirectionRelative_CentiDegree);
   virtual tVoid vVisit_b16_PositionReliability(fi_tcl_b16_PositionReliability& o_b16_PositionReliability);
   virtual tVoid vVisit_e8_LocationDescriptionDataType(fi_tcl_e8_LocationDescriptionDataType& o_e8_LocationDescriptionDataType);
   virtual tVoid vVisit_b8_LocationDescriptorStatus(fi_tcl_b8_LocationDescriptorStatus& o_b8_LocationDescriptorStatus);
   virtual tVoid vVisit_e16_SelectionCriterionType(fi_tcl_e16_SelectionCriterionType& o_e16_SelectionCriterionType);
   virtual tVoid vVisit_b8_PositionStatus(fi_tcl_b8_PositionStatus& o_b8_PositionStatus);
   virtual tVoid vVisit_s32_MEMU(fi_tcl_s32_MEMU& o_s32_MEMU);
   virtual tVoid vVisit_s16_MEMUSecond(fi_tcl_s16_MEMUSecond& o_s16_MEMUSecond);
   virtual tVoid vVisit_s16_EAU(fi_tcl_s16_EAU& o_s16_EAU);
   virtual tVoid vVisit_s32_EMU(fi_tcl_s32_EMU& o_s32_EMU);
   virtual tVoid vVisit_e8_NavOneCellDirection(fi_tcl_e8_NavOneCellDirection& o_e8_NavOneCellDirection);
   virtual tVoid vVisit_e8_PathType(fi_tcl_e8_PathType& o_e8_PathType);
   virtual tVoid vVisit_s16_CurvatureValue(fi_tcl_s16_CurvatureValue& o_s16_CurvatureValue);
   virtual tVoid vVisit_e8_EntryPointState(fi_tcl_e8_EntryPointState& o_e8_EntryPointState);
   virtual tVoid vVisit_u32_Resistance(fi_tcl_u32_Resistance& o_u32_Resistance);
   virtual tVoid vVisit_e8_RoadClassCode(fi_tcl_e8_RoadClassCode& o_e8_RoadClassCode);
   virtual tVoid vVisit_u32_DataSetId(fi_tcl_u32_DataSetId& o_u32_DataSetId);
   virtual tVoid vVisit_u32_MediaId(fi_tcl_u32_MediaId& o_u32_MediaId);
   virtual tVoid vVisit_e8_CrossroadInfoCategory(fi_tcl_e8_CrossroadInfoCategory& o_e8_CrossroadInfoCategory);
   virtual tVoid vVisit_b32_RoadProperty(fi_tcl_b32_RoadProperty& o_b32_RoadProperty);
   virtual tVoid vVisit_e8_NavStreetType(fi_tcl_e8_NavStreetType& o_e8_NavStreetType);
   virtual tVoid vVisit_e8_SideInfo(fi_tcl_e8_SideInfo& o_e8_SideInfo);
   virtual tVoid vVisit_e8_RoadNetworkClass(fi_tcl_e8_RoadNetworkClass& o_e8_RoadNetworkClass);
   virtual tVoid vVisit_e8_SingleRoadInfoCategory(fi_tcl_e8_SingleRoadInfoCategory& o_e8_SingleRoadInfoCategory);
   virtual tVoid vVisit_b8_RoadNumberStatus(fi_tcl_b8_RoadNumberStatus& o_b8_RoadNumberStatus);
   virtual tVoid vVisit_e8_RequiredPermissionType(fi_tcl_e8_RequiredPermissionType& o_e8_RequiredPermissionType);
   virtual tVoid vVisit_e8_RequiredPermission(fi_tcl_e8_RequiredPermission& o_e8_RequiredPermission);
   virtual tVoid vVisit_e8_IntersectionType(fi_tcl_e8_IntersectionType& o_e8_IntersectionType);
   virtual tVoid vVisit_e8_ExtraDescElementType(fi_tcl_e8_ExtraDescElementType& o_e8_ExtraDescElementType);
   virtual tVoid vVisit_b32_DataProperties(fi_tcl_b32_DataProperties& o_b32_DataProperties);
   virtual tVoid vVisit_b8_CrossroadProperties(fi_tcl_b8_CrossroadProperties& o_b8_CrossroadProperties);
   virtual tVoid vVisit_e8_BaseTrafficSignCategory(fi_tcl_e8_BaseTrafficSignCategory& o_e8_BaseTrafficSignCategory);
   virtual tVoid vVisit_e8_SpeedSign(fi_tcl_e8_SpeedSign& o_e8_SpeedSign);
   virtual tVoid vVisit_e16_WarningSign(fi_tcl_e16_WarningSign& o_e16_WarningSign);
   virtual tVoid vVisit_e16_RegulatorySign(fi_tcl_e16_RegulatorySign& o_e16_RegulatorySign);
   virtual tVoid vVisit_e16_AdditionalTrafficSign(fi_tcl_e16_AdditionalTrafficSign& o_e16_AdditionalTrafficSign);
   virtual tVoid vVisit_TimeDependentString(fi_tcl_TimeDependentString& o_TimeDependentString);
   virtual tVoid vVisit_b8_LaneDependentValidity(fi_tcl_b8_LaneDependentValidity& o_b8_LaneDependentValidity);
   virtual tVoid vVisit_e8_TrafficSignQuantifier(fi_tcl_e8_TrafficSignQuantifier& o_e8_TrafficSignQuantifier);
   virtual tVoid vVisit_b32_POICategory(fi_tcl_b32_POICategory& o_b32_POICategory);
   virtual tVoid vVisit_u16_TripHandle(fi_tcl_u16_TripHandle& o_u16_TripHandle);
   virtual tVoid vVisit_u16_TripSegmentNumber(fi_tcl_u16_TripSegmentNumber& o_u16_TripSegmentNumber);
   virtual tVoid vVisit_u16_RouteHandle(fi_tcl_u16_RouteHandle& o_u16_RouteHandle);
   virtual tVoid vVisit_e8_PositionCalculationState(fi_tcl_e8_PositionCalculationState& o_e8_PositionCalculationState);
   virtual tVoid vVisit_e8_SwitchPositionStatus(fi_tcl_e8_SwitchPositionStatus& o_e8_SwitchPositionStatus);
   virtual tVoid vVisit_e8_NavLocationDescType(fi_tcl_e8_NavLocationDescType& o_e8_NavLocationDescType);
   virtual tVoid vVisit_e8_BinContainerTypes(fi_tcl_e8_BinContainerTypes& o_e8_BinContainerTypes);
   virtual tVoid vVisit_e8_NavIndexZFDestinationType(fi_tcl_e8_NavIndexZFDestinationType& o_e8_NavIndexZFDestinationType);
   virtual tVoid vVisit_e8_NavLocationNavDataType(fi_tcl_e8_NavLocationNavDataType& o_e8_NavLocationNavDataType);
   virtual tVoid vVisit_e8_NavIntersectionType(fi_tcl_e8_NavIntersectionType& o_e8_NavIntersectionType);
   virtual tVoid vVisit_e8_DirectionStatus(fi_tcl_e8_DirectionStatus& o_e8_DirectionStatus);
   virtual tVoid vVisit_e8_DirectionCategory(fi_tcl_e8_DirectionCategory& o_e8_DirectionCategory);
   virtual tVoid vVisit_b8_DirectionInfoStatus(fi_tcl_b8_DirectionInfoStatus& o_b8_DirectionInfoStatus);
#ifndef FI_S_EXTERNAL_FI
#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_e8_PosHorizonState(fi_tcl_e8_PosHorizonState& o_e8_PosHorizonState);
   virtual tVoid vVisit_e8_DigitalMapSpeedCategoryType(fi_tcl_e8_DigitalMapSpeedCategoryType& o_e8_DigitalMapSpeedCategoryType);
   virtual tVoid vVisit_e8_PosHorizonSuccessorState(fi_tcl_e8_PosHorizonSuccessorState& o_e8_PosHorizonSuccessorState);
   virtual tVoid vVisit_b32_PathSectionStatus(fi_tcl_b32_PathSectionStatus& o_b32_PathSectionStatus);
   virtual tVoid vVisit_b8_PosHorizonSuccessorState(fi_tcl_b8_PosHorizonSuccessorState& o_b8_PosHorizonSuccessorState);
   virtual tVoid vVisit_b8_HorizonOneCellPropertyStatus(fi_tcl_b8_HorizonOneCellPropertyStatus& o_b8_HorizonOneCellPropertyStatus);
   virtual tVoid vVisit_e8_ExtendedPositionCalculationState(fi_tcl_e8_ExtendedPositionCalculationState& o_e8_ExtendedPositionCalculationState);
   virtual tVoid vVisit_b8_ExtrapolationReliability(fi_tcl_b8_ExtrapolationReliability& o_b8_ExtrapolationReliability);
   virtual tVoid vVisit_e8_PresentationStatus(fi_tcl_e8_PresentationStatus& o_e8_PresentationStatus);
   virtual tVoid vVisit_e8_CalibrationOperationCode(fi_tcl_e8_CalibrationOperationCode& o_e8_CalibrationOperationCode);
   virtual tVoid vVisit_e8_CalibrationState(fi_tcl_e8_CalibrationState& o_e8_CalibrationState);
   virtual tVoid vVisit_e8_DeadReckoningPositionState(fi_tcl_e8_DeadReckoningPositionState& o_e8_DeadReckoningPositionState);
   virtual tVoid vVisit_s16_CentiDegreePerSecond(fi_tcl_s16_CentiDegreePerSecond& o_s16_CentiDegreePerSecond);
   virtual tVoid vVisit_b16_SensorDataPhalanx(fi_tcl_b16_SensorDataPhalanx& o_b16_SensorDataPhalanx);
   virtual tVoid vVisit_e8_MapMatchingRule(fi_tcl_e8_MapMatchingRule& o_e8_MapMatchingRule);
	tU32 u32ListSize;
};

#endif
