/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgGetAvailablePermissionsMethodStart::navifi_tclMsgGetAvailablePermissionsMethodStart(const navifi_tclMsgGetAvailablePermissionsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavDataSetID = coRef.NavDataSetID;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgGetAvailablePermissionsMethodStart& navifi_tclMsgGetAvailablePermissionsMethodStart::operator=(const navifi_tclMsgGetAvailablePermissionsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NavDataSetID = coRef.NavDataSetID;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgGetAvailablePermissionsMethodStart::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgGetAvailablePermissionsMethodStart::u16GetFunctionID() const {return NAVIFI_C_U16_GETAVAILABLEPERMISSIONS;}
tU8 navifi_tclMsgGetAvailablePermissionsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 navifi_tclMsgGetAvailablePermissionsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+0;
}

tBool navifi_tclMsgGetAvailablePermissionsMethodStart::operator==(const navifi_tclMsgGetAvailablePermissionsMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
   return bResult;
}

fi_tclInContext& navifi_tclMsgGetAvailablePermissionsMethodStart::oRead(fi_tclInContext& oIn)
{
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> NavDataSetID;
   }
   return oIn;
}

fi_tclOutContext& navifi_tclMsgGetAvailablePermissionsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << NavDataSetID;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgGetAvailablePermissionsMethodResult::navifi_tclMsgGetAvailablePermissionsMethodResult(const navifi_tclMsgGetAvailablePermissionsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavDataSetID = coRef.NavDataSetID;
   AvailablePermissions = coRef.AvailablePermissions;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgGetAvailablePermissionsMethodResult& navifi_tclMsgGetAvailablePermissionsMethodResult::operator=(const navifi_tclMsgGetAvailablePermissionsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   NavDataSetID = coRef.NavDataSetID;
   AvailablePermissions = coRef.AvailablePermissions;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgGetAvailablePermissionsMethodResult::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgGetAvailablePermissionsMethodResult::u16GetFunctionID() const {return NAVIFI_C_U16_GETAVAILABLEPERMISSIONS;}
tU8 navifi_tclMsgGetAvailablePermissionsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid navifi_tclMsgGetAvailablePermissionsMethodResult::vDestroy()
{
   AvailablePermissions.vDestroy(); 
}

tU32 navifi_tclMsgGetAvailablePermissionsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+0+AvailablePermissions.u32GetSize(u16MajorVersion);
}

tBool navifi_tclMsgGetAvailablePermissionsMethodResult::operator==(const navifi_tclMsgGetAvailablePermissionsMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (AvailablePermissions == rfoCmp.AvailablePermissions);
   return bResult;
}

fi_tclInContext& navifi_tclMsgGetAvailablePermissionsMethodResult::oRead(fi_tclInContext& oIn)
{
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> NavDataSetID;
   }
   oIn >> AvailablePermissions;
   return oIn;
}

fi_tclOutContext& navifi_tclMsgGetAvailablePermissionsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << NavDataSetID;
   }
   oOut << AvailablePermissions;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgGetGlobalAnnotationTablesMethodStart::navifi_tclMsgGetGlobalAnnotationTablesMethodStart(const navifi_tclMsgGetGlobalAnnotationTablesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavDataSetID = coRef.NavDataSetID;
   RequiredCountryCodes = coRef.RequiredCountryCodes;
   RequiredAnnotationTables = coRef.RequiredAnnotationTables;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgGetGlobalAnnotationTablesMethodStart& navifi_tclMsgGetGlobalAnnotationTablesMethodStart::operator=(const navifi_tclMsgGetGlobalAnnotationTablesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NavDataSetID = coRef.NavDataSetID;
   RequiredCountryCodes = coRef.RequiredCountryCodes;
   RequiredAnnotationTables = coRef.RequiredAnnotationTables;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgGetGlobalAnnotationTablesMethodStart::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgGetGlobalAnnotationTablesMethodStart::u16GetFunctionID() const {return NAVIFI_C_U16_GETGLOBALANNOTATIONTABLES;}
tU8 navifi_tclMsgGetGlobalAnnotationTablesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid navifi_tclMsgGetGlobalAnnotationTablesMethodStart::vDestroy()
{
   RequiredCountryCodes.clear();
   RequiredAnnotationTables.clear();
}

tU32 navifi_tclMsgGetGlobalAnnotationTablesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12+RequiredCountryCodes.size()*2+RequiredAnnotationTables.size()*1;
}

tBool navifi_tclMsgGetGlobalAnnotationTablesMethodStart::operator==(const navifi_tclMsgGetGlobalAnnotationTablesMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (RequiredCountryCodes.size() == rfoCmp.RequiredCountryCodes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RequiredCountryCodes.size()); ++u32Idx)
            bResult = bResult && (RequiredCountryCodes[u32Idx] == rfoCmp.RequiredCountryCodes[u32Idx]);
      }
      bResult = bResult && (RequiredAnnotationTables.size() == rfoCmp.RequiredAnnotationTables.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RequiredAnnotationTables.size()); ++u32Idx)
            bResult = bResult && (RequiredAnnotationTables[u32Idx] == rfoCmp.RequiredAnnotationTables[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& navifi_tclMsgGetGlobalAnnotationTablesMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> NavDataSetID;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      RequiredCountryCodes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RequiredCountryCodes[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      RequiredAnnotationTables.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RequiredAnnotationTables[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& navifi_tclMsgGetGlobalAnnotationTablesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavDataSetID;
   oOut << (tU32)RequiredCountryCodes.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RequiredCountryCodes.size(); ++u32Idx)
         oOut << RequiredCountryCodes[u32Idx];
   }
   oOut << (tU32)RequiredAnnotationTables.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RequiredAnnotationTables.size(); ++u32Idx)
         oOut << RequiredAnnotationTables[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgGetGlobalAnnotationTablesMethodResult::navifi_tclMsgGetGlobalAnnotationTablesMethodResult(const navifi_tclMsgGetGlobalAnnotationTablesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   NavDataSetID = coRef.NavDataSetID;
   GlobalAnnotationTables = coRef.GlobalAnnotationTables;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgGetGlobalAnnotationTablesMethodResult& navifi_tclMsgGetGlobalAnnotationTablesMethodResult::operator=(const navifi_tclMsgGetGlobalAnnotationTablesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   NavDataSetID = coRef.NavDataSetID;
   GlobalAnnotationTables = coRef.GlobalAnnotationTables;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgGetGlobalAnnotationTablesMethodResult::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgGetGlobalAnnotationTablesMethodResult::u16GetFunctionID() const {return NAVIFI_C_U16_GETGLOBALANNOTATIONTABLES;}
tU8 navifi_tclMsgGetGlobalAnnotationTablesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid navifi_tclMsgGetGlobalAnnotationTablesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < GlobalAnnotationTables.size(); ++u32Idx)
         GlobalAnnotationTables[u32Idx].vDestroy();
   }
   GlobalAnnotationTables.clear();
}

tU32 navifi_tclMsgGetGlobalAnnotationTablesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < GlobalAnnotationTables.size(); ++u32ListIdx)
      u32DynamicSize += GlobalAnnotationTables[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool navifi_tclMsgGetGlobalAnnotationTablesMethodResult::operator==(const navifi_tclMsgGetGlobalAnnotationTablesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (NavDataSetID == rfoCmp.NavDataSetID);
      bResult = bResult && (GlobalAnnotationTables.size() == rfoCmp.GlobalAnnotationTables.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < GlobalAnnotationTables.size()); ++u32Idx)
            bResult = bResult && (GlobalAnnotationTables[u32Idx] == rfoCmp.GlobalAnnotationTables[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& navifi_tclMsgGetGlobalAnnotationTablesMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> NavDataSetID;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < GlobalAnnotationTables.size(); ++u32Idx)
      {
         GlobalAnnotationTables[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      GlobalAnnotationTables.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> GlobalAnnotationTables[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& navifi_tclMsgGetGlobalAnnotationTablesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << NavDataSetID;
   oOut << (tU32)GlobalAnnotationTables.size();
   {
      for (tU32 u32Idx = 0; u32Idx < GlobalAnnotationTables.size(); ++u32Idx)
         oOut << GlobalAnnotationTables[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgGetAllTrafficMessagesMethodStart::navifi_tclMsgGetAllTrafficMessagesMethodStart(const navifi_tclMsgGetAllTrafficMessagesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   WantedBinContainer = coRef.WantedBinContainer;
   TMCodedMapMajorVersion = coRef.TMCodedMapMajorVersion;
   TMCurrentIDList = coRef.TMCurrentIDList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgGetAllTrafficMessagesMethodStart& navifi_tclMsgGetAllTrafficMessagesMethodStart::operator=(const navifi_tclMsgGetAllTrafficMessagesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   WantedBinContainer = coRef.WantedBinContainer;
   TMCodedMapMajorVersion = coRef.TMCodedMapMajorVersion;
   TMCurrentIDList = coRef.TMCurrentIDList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgGetAllTrafficMessagesMethodStart::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgGetAllTrafficMessagesMethodStart::u16GetFunctionID() const {return NAVIFI_C_U16_GETALLTRAFFICMESSAGES;}
tU8 navifi_tclMsgGetAllTrafficMessagesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid navifi_tclMsgGetAllTrafficMessagesMethodStart::vDestroy()
{
   TMCurrentIDList.clear();
}

tU32 navifi_tclMsgGetAllTrafficMessagesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+5+TMCurrentIDList.size()*4;
}

tBool navifi_tclMsgGetAllTrafficMessagesMethodStart::operator==(const navifi_tclMsgGetAllTrafficMessagesMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (WantedBinContainer == rfoCmp.WantedBinContainer);
      bResult = bResult && (TMCodedMapMajorVersion == rfoCmp.TMCodedMapMajorVersion);
      bResult = bResult && (TMCurrentIDList.size() == rfoCmp.TMCurrentIDList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TMCurrentIDList.size()); ++u32Idx)
            bResult = bResult && (TMCurrentIDList[u32Idx] == rfoCmp.TMCurrentIDList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& navifi_tclMsgGetAllTrafficMessagesMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> WantedBinContainer;
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> TMCodedMapMajorVersion;
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      TMCurrentIDList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TMCurrentIDList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& navifi_tclMsgGetAllTrafficMessagesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << WantedBinContainer;
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << TMCodedMapMajorVersion;
   }
   oOut << (tU32)TMCurrentIDList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TMCurrentIDList.size(); ++u32Idx)
         oOut << TMCurrentIDList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgGetAllTrafficMessagesMethodResult::navifi_tclMsgGetAllTrafficMessagesMethodResult(const navifi_tclMsgGetAllTrafficMessagesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   CurrentTrafficMessageRevision = coRef.CurrentTrafficMessageRevision;
   WantedBinContainer = coRef.WantedBinContainer;
   TMContentComplete = coRef.TMContentComplete;
   DeletedIDList = coRef.DeletedIDList;
   TMInfo = coRef.TMInfo;
   ProgramServiceList = coRef.ProgramServiceList;
   ServiceProviderList = coRef.ServiceProviderList;
   CodedTextMessages = coRef.CodedTextMessages;
   CodedMapMessages = coRef.CodedMapMessages;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgGetAllTrafficMessagesMethodResult& navifi_tclMsgGetAllTrafficMessagesMethodResult::operator=(const navifi_tclMsgGetAllTrafficMessagesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   CurrentTrafficMessageRevision = coRef.CurrentTrafficMessageRevision;
   WantedBinContainer = coRef.WantedBinContainer;
   TMContentComplete = coRef.TMContentComplete;
   DeletedIDList = coRef.DeletedIDList;
   TMInfo = coRef.TMInfo;
   ProgramServiceList = coRef.ProgramServiceList;
   ServiceProviderList = coRef.ServiceProviderList;
   CodedTextMessages = coRef.CodedTextMessages;
   CodedMapMessages = coRef.CodedMapMessages;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgGetAllTrafficMessagesMethodResult::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgGetAllTrafficMessagesMethodResult::u16GetFunctionID() const {return NAVIFI_C_U16_GETALLTRAFFICMESSAGES;}
tU8 navifi_tclMsgGetAllTrafficMessagesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid navifi_tclMsgGetAllTrafficMessagesMethodResult::vDestroy()
{
   DeletedIDList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < TMInfo.size(); ++u32Idx)
         TMInfo[u32Idx].vDestroy();
   }
   TMInfo.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < ProgramServiceList.size(); ++u32Idx)
         ProgramServiceList[u32Idx].vDestroy();
   }
   ProgramServiceList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < ServiceProviderList.size(); ++u32Idx)
         ServiceProviderList[u32Idx].vDestroy();
   }
   ServiceProviderList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < CodedTextMessages.size(); ++u32Idx)
         CodedTextMessages[u32Idx].vDestroy();
   }
   CodedTextMessages.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < CodedMapMessages.size(); ++u32Idx)
         CodedMapMessages[u32Idx].vDestroy();
   }
   CodedMapMessages.clear();
}

tU32 navifi_tclMsgGetAllTrafficMessagesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TMInfo.size(); ++u32ListIdx)
      u32DynamicSize += TMInfo[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < ProgramServiceList.size(); ++u32ListIdx)
      u32DynamicSize += ProgramServiceList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < ServiceProviderList.size(); ++u32ListIdx)
      u32DynamicSize += ServiceProviderList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < CodedTextMessages.size(); ++u32ListIdx)
      u32DynamicSize += CodedTextMessages[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < CodedMapMessages.size(); ++u32ListIdx)
      u32DynamicSize += CodedMapMessages[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+30+DeletedIDList.size()*4;
}

tBool navifi_tclMsgGetAllTrafficMessagesMethodResult::operator==(const navifi_tclMsgGetAllTrafficMessagesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CurrentTrafficMessageRevision == rfoCmp.CurrentTrafficMessageRevision);
      bResult = bResult && (WantedBinContainer == rfoCmp.WantedBinContainer);
      bResult = bResult && (TMContentComplete == rfoCmp.TMContentComplete);
      bResult = bResult && (DeletedIDList.size() == rfoCmp.DeletedIDList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DeletedIDList.size()); ++u32Idx)
            bResult = bResult && (DeletedIDList[u32Idx] == rfoCmp.DeletedIDList[u32Idx]);
      }
      bResult = bResult && (TMInfo.size() == rfoCmp.TMInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TMInfo.size()); ++u32Idx)
            bResult = bResult && (TMInfo[u32Idx] == rfoCmp.TMInfo[u32Idx]);
      }
      bResult = bResult && (ProgramServiceList.size() == rfoCmp.ProgramServiceList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ProgramServiceList.size()); ++u32Idx)
            bResult = bResult && (ProgramServiceList[u32Idx] == rfoCmp.ProgramServiceList[u32Idx]);
      }
      bResult = bResult && (ServiceProviderList.size() == rfoCmp.ServiceProviderList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ServiceProviderList.size()); ++u32Idx)
            bResult = bResult && (ServiceProviderList[u32Idx] == rfoCmp.ServiceProviderList[u32Idx]);
      }
      bResult = bResult && (CodedTextMessages.size() == rfoCmp.CodedTextMessages.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CodedTextMessages.size()); ++u32Idx)
            bResult = bResult && (CodedTextMessages[u32Idx] == rfoCmp.CodedTextMessages[u32Idx]);
      }
      bResult = bResult && (CodedMapMessages.size() == rfoCmp.CodedMapMessages.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CodedMapMessages.size()); ++u32Idx)
            bResult = bResult && (CodedMapMessages[u32Idx] == rfoCmp.CodedMapMessages[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& navifi_tclMsgGetAllTrafficMessagesMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> CurrentTrafficMessageRevision;
   oIn >> WantedBinContainer;
   oIn >> TMContentComplete;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      DeletedIDList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> DeletedIDList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TMInfo.size(); ++u32Idx)
      {
         TMInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TMInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TMInfo[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ProgramServiceList.size(); ++u32Idx)
      {
         ProgramServiceList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ProgramServiceList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ProgramServiceList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ServiceProviderList.size(); ++u32Idx)
      {
         ServiceProviderList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ServiceProviderList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ServiceProviderList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CodedTextMessages.size(); ++u32Idx)
      {
         CodedTextMessages[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      CodedTextMessages.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CodedTextMessages[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CodedMapMessages.size(); ++u32Idx)
      {
         CodedMapMessages[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      CodedMapMessages.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CodedMapMessages[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& navifi_tclMsgGetAllTrafficMessagesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CurrentTrafficMessageRevision;
   oOut << WantedBinContainer;
   oOut << TMContentComplete;
   oOut << (tU32)DeletedIDList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < DeletedIDList.size(); ++u32Idx)
         oOut << DeletedIDList[u32Idx];
   }
   oOut << (tU32)TMInfo.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TMInfo.size(); ++u32Idx)
         oOut << TMInfo[u32Idx];
   }
   oOut << (tU32)ProgramServiceList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ProgramServiceList.size(); ++u32Idx)
         oOut << ProgramServiceList[u32Idx];
   }
   oOut << (tU32)ServiceProviderList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ServiceProviderList.size(); ++u32Idx)
         oOut << ServiceProviderList[u32Idx];
   }
   oOut << (tU32)CodedTextMessages.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CodedTextMessages.size(); ++u32Idx)
         oOut << CodedTextMessages[u32Idx];
   }
   oOut << (tU32)CodedMapMessages.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CodedMapMessages.size(); ++u32Idx)
         oOut << CodedMapMessages[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgGetAllTMCLocationsMethodStart::navifi_tclMsgGetAllTMCLocationsMethodStart(const navifi_tclMsgGetAllTMCLocationsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgGetAllTMCLocationsMethodStart& navifi_tclMsgGetAllTMCLocationsMethodStart::operator=(const navifi_tclMsgGetAllTMCLocationsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgGetAllTMCLocationsMethodStart::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgGetAllTMCLocationsMethodStart::u16GetFunctionID() const {return NAVIFI_C_U16_GETALLTMCLOCATIONS;}
tU8 navifi_tclMsgGetAllTMCLocationsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 navifi_tclMsgGetAllTMCLocationsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool navifi_tclMsgGetAllTMCLocationsMethodStart::operator==(const navifi_tclMsgGetAllTMCLocationsMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& navifi_tclMsgGetAllTMCLocationsMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& navifi_tclMsgGetAllTMCLocationsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgGetAllTMCLocationsMethodResult::navifi_tclMsgGetAllTMCLocationsMethodResult(const navifi_tclMsgGetAllTMCLocationsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   CurrentTrafficMessageRevision = coRef.CurrentTrafficMessageRevision;
   LocationElementCount = coRef.LocationElementCount;
   LocationTableList = coRef.LocationTableList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgGetAllTMCLocationsMethodResult& navifi_tclMsgGetAllTMCLocationsMethodResult::operator=(const navifi_tclMsgGetAllTMCLocationsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   CurrentTrafficMessageRevision = coRef.CurrentTrafficMessageRevision;
   LocationElementCount = coRef.LocationElementCount;
   LocationTableList = coRef.LocationTableList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgGetAllTMCLocationsMethodResult::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgGetAllTMCLocationsMethodResult::u16GetFunctionID() const {return NAVIFI_C_U16_GETALLTMCLOCATIONS;}
tU8 navifi_tclMsgGetAllTMCLocationsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid navifi_tclMsgGetAllTMCLocationsMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < LocationTableList.size(); ++u32Idx)
         LocationTableList[u32Idx].vDestroy();
   }
   LocationTableList.clear();
}

tU32 navifi_tclMsgGetAllTMCLocationsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < LocationTableList.size(); ++u32ListIdx)
      u32DynamicSize += LocationTableList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+12;
}

tBool navifi_tclMsgGetAllTMCLocationsMethodResult::operator==(const navifi_tclMsgGetAllTMCLocationsMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CurrentTrafficMessageRevision == rfoCmp.CurrentTrafficMessageRevision);
      bResult = bResult && (LocationElementCount == rfoCmp.LocationElementCount);
      bResult = bResult && (LocationTableList.size() == rfoCmp.LocationTableList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < LocationTableList.size()); ++u32Idx)
            bResult = bResult && (LocationTableList[u32Idx] == rfoCmp.LocationTableList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& navifi_tclMsgGetAllTMCLocationsMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> CurrentTrafficMessageRevision;
   oIn >> LocationElementCount;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < LocationTableList.size(); ++u32Idx)
      {
         LocationTableList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      LocationTableList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> LocationTableList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& navifi_tclMsgGetAllTMCLocationsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CurrentTrafficMessageRevision;
   oOut << LocationElementCount;
   oOut << (tU32)LocationTableList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < LocationTableList.size(); ++u32Idx)
         oOut << LocationTableList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgChangeTrafficMessageHandlingMethodStart::navifi_tclMsgChangeTrafficMessageHandlingMethodStart(const navifi_tclMsgChangeTrafficMessageHandlingMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   AmbiguousClosing = coRef.AmbiguousClosing;
   AmbiguousDynamicDisruption = coRef.AmbiguousDynamicDisruption;
   AmbiguousArea = coRef.AmbiguousArea;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgChangeTrafficMessageHandlingMethodStart& navifi_tclMsgChangeTrafficMessageHandlingMethodStart::operator=(const navifi_tclMsgChangeTrafficMessageHandlingMethodStart& coRef)
{
   if (this == &coRef) return *this;
   AmbiguousClosing = coRef.AmbiguousClosing;
   AmbiguousDynamicDisruption = coRef.AmbiguousDynamicDisruption;
   AmbiguousArea = coRef.AmbiguousArea;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgChangeTrafficMessageHandlingMethodStart::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgChangeTrafficMessageHandlingMethodStart::u16GetFunctionID() const {return NAVIFI_C_U16_CHANGETRAFFICMESSAGEHANDLING;}
tU8 navifi_tclMsgChangeTrafficMessageHandlingMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid navifi_tclMsgChangeTrafficMessageHandlingMethodStart::vDestroy()
{
   AmbiguousClosing.vDestroy(); 
   AmbiguousDynamicDisruption.vDestroy(); 
   AmbiguousArea.vDestroy(); 
}

tU32 navifi_tclMsgChangeTrafficMessageHandlingMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

tBool navifi_tclMsgChangeTrafficMessageHandlingMethodStart::operator==(const navifi_tclMsgChangeTrafficMessageHandlingMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AmbiguousClosing == rfoCmp.AmbiguousClosing);
      bResult = bResult && (AmbiguousDynamicDisruption == rfoCmp.AmbiguousDynamicDisruption);
      bResult = bResult && (AmbiguousArea == rfoCmp.AmbiguousArea);
   return bResult;
}

fi_tclInContext& navifi_tclMsgChangeTrafficMessageHandlingMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> AmbiguousClosing;
   oIn >> AmbiguousDynamicDisruption;
   oIn >> AmbiguousArea;
   return oIn;
}

fi_tclOutContext& navifi_tclMsgChangeTrafficMessageHandlingMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << AmbiguousClosing;
   oOut << AmbiguousDynamicDisruption;
   oOut << AmbiguousArea;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgChangeTrafficMessageHandlingMethodResult::navifi_tclMsgChangeTrafficMessageHandlingMethodResult(const navifi_tclMsgChangeTrafficMessageHandlingMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   AmbiguousClosing = coRef.AmbiguousClosing;
   AmbiguousDynamicDisruption = coRef.AmbiguousDynamicDisruption;
   AmbiguousArea = coRef.AmbiguousArea;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgChangeTrafficMessageHandlingMethodResult& navifi_tclMsgChangeTrafficMessageHandlingMethodResult::operator=(const navifi_tclMsgChangeTrafficMessageHandlingMethodResult& coRef)
{
   if (this == &coRef) return *this;
   AmbiguousClosing = coRef.AmbiguousClosing;
   AmbiguousDynamicDisruption = coRef.AmbiguousDynamicDisruption;
   AmbiguousArea = coRef.AmbiguousArea;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgChangeTrafficMessageHandlingMethodResult::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgChangeTrafficMessageHandlingMethodResult::u16GetFunctionID() const {return NAVIFI_C_U16_CHANGETRAFFICMESSAGEHANDLING;}
tU8 navifi_tclMsgChangeTrafficMessageHandlingMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid navifi_tclMsgChangeTrafficMessageHandlingMethodResult::vDestroy()
{
   AmbiguousClosing.vDestroy(); 
   AmbiguousDynamicDisruption.vDestroy(); 
   AmbiguousArea.vDestroy(); 
}

tU32 navifi_tclMsgChangeTrafficMessageHandlingMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

tBool navifi_tclMsgChangeTrafficMessageHandlingMethodResult::operator==(const navifi_tclMsgChangeTrafficMessageHandlingMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AmbiguousClosing == rfoCmp.AmbiguousClosing);
      bResult = bResult && (AmbiguousDynamicDisruption == rfoCmp.AmbiguousDynamicDisruption);
      bResult = bResult && (AmbiguousArea == rfoCmp.AmbiguousArea);
   return bResult;
}

fi_tclInContext& navifi_tclMsgChangeTrafficMessageHandlingMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> AmbiguousClosing;
   oIn >> AmbiguousDynamicDisruption;
   oIn >> AmbiguousArea;
   return oIn;
}

fi_tclOutContext& navifi_tclMsgChangeTrafficMessageHandlingMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << AmbiguousClosing;
   oOut << AmbiguousDynamicDisruption;
   oOut << AmbiguousArea;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgGetTrafficMessagesMethodStart::navifi_tclMsgGetTrafficMessagesMethodStart(const navifi_tclMsgGetTrafficMessagesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   WantedBinContainer = coRef.WantedBinContainer;
   TMCodedMapMajorVersion = coRef.TMCodedMapMajorVersion;
   TMCurrentIDList = coRef.TMCurrentIDList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgGetTrafficMessagesMethodStart& navifi_tclMsgGetTrafficMessagesMethodStart::operator=(const navifi_tclMsgGetTrafficMessagesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   WantedBinContainer = coRef.WantedBinContainer;
   TMCodedMapMajorVersion = coRef.TMCodedMapMajorVersion;
   TMCurrentIDList = coRef.TMCurrentIDList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgGetTrafficMessagesMethodStart::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgGetTrafficMessagesMethodStart::u16GetFunctionID() const {return NAVIFI_C_U16_GETTRAFFICMESSAGES;}
tU8 navifi_tclMsgGetTrafficMessagesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid navifi_tclMsgGetTrafficMessagesMethodStart::vDestroy()
{
   TMCurrentIDList.clear();
}

tU32 navifi_tclMsgGetTrafficMessagesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7+TMCurrentIDList.size()*4;
}

tBool navifi_tclMsgGetTrafficMessagesMethodStart::operator==(const navifi_tclMsgGetTrafficMessagesMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (WantedBinContainer == rfoCmp.WantedBinContainer);
      bResult = bResult && (TMCodedMapMajorVersion == rfoCmp.TMCodedMapMajorVersion);
      bResult = bResult && (TMCurrentIDList.size() == rfoCmp.TMCurrentIDList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TMCurrentIDList.size()); ++u32Idx)
            bResult = bResult && (TMCurrentIDList[u32Idx] == rfoCmp.TMCurrentIDList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& navifi_tclMsgGetTrafficMessagesMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> WantedBinContainer;
   oIn >> TMCodedMapMajorVersion;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      TMCurrentIDList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TMCurrentIDList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& navifi_tclMsgGetTrafficMessagesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << WantedBinContainer;
   oOut << TMCodedMapMajorVersion;
   oOut << (tU32)TMCurrentIDList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TMCurrentIDList.size(); ++u32Idx)
         oOut << TMCurrentIDList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgGetTrafficMessagesMethodResult::navifi_tclMsgGetTrafficMessagesMethodResult(const navifi_tclMsgGetTrafficMessagesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   CurrentTrafficMessageRevision = coRef.CurrentTrafficMessageRevision;
   WantedBinContainer = coRef.WantedBinContainer;
   TMContentComplete = coRef.TMContentComplete;
   DeletedIDList = coRef.DeletedIDList;
   TMBaseInfoList = coRef.TMBaseInfoList;
   ProgramServiceList = coRef.ProgramServiceList;
   ServiceProviderList = coRef.ServiceProviderList;
   TMInfoRefList = coRef.TMInfoRefList;
   TMCodedTextRefList = coRef.TMCodedTextRefList;
   TMCodedMapRefList = coRef.TMCodedMapRefList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgGetTrafficMessagesMethodResult& navifi_tclMsgGetTrafficMessagesMethodResult::operator=(const navifi_tclMsgGetTrafficMessagesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   CurrentTrafficMessageRevision = coRef.CurrentTrafficMessageRevision;
   WantedBinContainer = coRef.WantedBinContainer;
   TMContentComplete = coRef.TMContentComplete;
   DeletedIDList = coRef.DeletedIDList;
   TMBaseInfoList = coRef.TMBaseInfoList;
   ProgramServiceList = coRef.ProgramServiceList;
   ServiceProviderList = coRef.ServiceProviderList;
   TMInfoRefList = coRef.TMInfoRefList;
   TMCodedTextRefList = coRef.TMCodedTextRefList;
   TMCodedMapRefList = coRef.TMCodedMapRefList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgGetTrafficMessagesMethodResult::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgGetTrafficMessagesMethodResult::u16GetFunctionID() const {return NAVIFI_C_U16_GETTRAFFICMESSAGES;}
tU8 navifi_tclMsgGetTrafficMessagesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid navifi_tclMsgGetTrafficMessagesMethodResult::vDestroy()
{
   DeletedIDList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < TMBaseInfoList.size(); ++u32Idx)
         TMBaseInfoList[u32Idx].vDestroy();
   }
   TMBaseInfoList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < ProgramServiceList.size(); ++u32Idx)
         ProgramServiceList[u32Idx].vDestroy();
   }
   ProgramServiceList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < ServiceProviderList.size(); ++u32Idx)
         ServiceProviderList[u32Idx].vDestroy();
   }
   ServiceProviderList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < TMInfoRefList.size(); ++u32Idx)
         TMInfoRefList[u32Idx].vDestroy();
   }
   TMInfoRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < TMCodedTextRefList.size(); ++u32Idx)
         TMCodedTextRefList[u32Idx].vDestroy();
   }
   TMCodedTextRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < TMCodedMapRefList.size(); ++u32Idx)
         TMCodedMapRefList[u32Idx].vDestroy();
   }
   TMCodedMapRefList.clear();
}

tU32 navifi_tclMsgGetTrafficMessagesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TMBaseInfoList.size(); ++u32ListIdx)
      u32DynamicSize += TMBaseInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < ProgramServiceList.size(); ++u32ListIdx)
      u32DynamicSize += ProgramServiceList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < ServiceProviderList.size(); ++u32ListIdx)
      u32DynamicSize += ServiceProviderList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < TMInfoRefList.size(); ++u32ListIdx)
      u32DynamicSize += TMInfoRefList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < TMCodedTextRefList.size(); ++u32ListIdx)
      u32DynamicSize += TMCodedTextRefList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < TMCodedMapRefList.size(); ++u32ListIdx)
      u32DynamicSize += TMCodedMapRefList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+34+DeletedIDList.size()*4;
}

tBool navifi_tclMsgGetTrafficMessagesMethodResult::operator==(const navifi_tclMsgGetTrafficMessagesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CurrentTrafficMessageRevision == rfoCmp.CurrentTrafficMessageRevision);
      bResult = bResult && (WantedBinContainer == rfoCmp.WantedBinContainer);
      bResult = bResult && (TMContentComplete == rfoCmp.TMContentComplete);
      bResult = bResult && (DeletedIDList.size() == rfoCmp.DeletedIDList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DeletedIDList.size()); ++u32Idx)
            bResult = bResult && (DeletedIDList[u32Idx] == rfoCmp.DeletedIDList[u32Idx]);
      }
      bResult = bResult && (TMBaseInfoList.size() == rfoCmp.TMBaseInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TMBaseInfoList.size()); ++u32Idx)
            bResult = bResult && (TMBaseInfoList[u32Idx] == rfoCmp.TMBaseInfoList[u32Idx]);
      }
      bResult = bResult && (ProgramServiceList.size() == rfoCmp.ProgramServiceList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ProgramServiceList.size()); ++u32Idx)
            bResult = bResult && (ProgramServiceList[u32Idx] == rfoCmp.ProgramServiceList[u32Idx]);
      }
      bResult = bResult && (ServiceProviderList.size() == rfoCmp.ServiceProviderList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ServiceProviderList.size()); ++u32Idx)
            bResult = bResult && (ServiceProviderList[u32Idx] == rfoCmp.ServiceProviderList[u32Idx]);
      }
      bResult = bResult && (TMInfoRefList.size() == rfoCmp.TMInfoRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TMInfoRefList.size()); ++u32Idx)
            bResult = bResult && (TMInfoRefList[u32Idx] == rfoCmp.TMInfoRefList[u32Idx]);
      }
      bResult = bResult && (TMCodedTextRefList.size() == rfoCmp.TMCodedTextRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TMCodedTextRefList.size()); ++u32Idx)
            bResult = bResult && (TMCodedTextRefList[u32Idx] == rfoCmp.TMCodedTextRefList[u32Idx]);
      }
      bResult = bResult && (TMCodedMapRefList.size() == rfoCmp.TMCodedMapRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TMCodedMapRefList.size()); ++u32Idx)
            bResult = bResult && (TMCodedMapRefList[u32Idx] == rfoCmp.TMCodedMapRefList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& navifi_tclMsgGetTrafficMessagesMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> CurrentTrafficMessageRevision;
   oIn >> WantedBinContainer;
   oIn >> TMContentComplete;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      DeletedIDList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> DeletedIDList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TMBaseInfoList.size(); ++u32Idx)
      {
         TMBaseInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TMBaseInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TMBaseInfoList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ProgramServiceList.size(); ++u32Idx)
      {
         ProgramServiceList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ProgramServiceList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ProgramServiceList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ServiceProviderList.size(); ++u32Idx)
      {
         ServiceProviderList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ServiceProviderList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ServiceProviderList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TMInfoRefList.size(); ++u32Idx)
      {
         TMInfoRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TMInfoRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TMInfoRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TMCodedTextRefList.size(); ++u32Idx)
      {
         TMCodedTextRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TMCodedTextRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TMCodedTextRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TMCodedMapRefList.size(); ++u32Idx)
      {
         TMCodedMapRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TMCodedMapRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TMCodedMapRefList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& navifi_tclMsgGetTrafficMessagesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CurrentTrafficMessageRevision;
   oOut << WantedBinContainer;
   oOut << TMContentComplete;
   oOut << (tU32)DeletedIDList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < DeletedIDList.size(); ++u32Idx)
         oOut << DeletedIDList[u32Idx];
   }
   oOut << (tU32)TMBaseInfoList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TMBaseInfoList.size(); ++u32Idx)
         oOut << TMBaseInfoList[u32Idx];
   }
   oOut << (tU32)ProgramServiceList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ProgramServiceList.size(); ++u32Idx)
         oOut << ProgramServiceList[u32Idx];
   }
   oOut << (tU32)ServiceProviderList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ServiceProviderList.size(); ++u32Idx)
         oOut << ServiceProviderList[u32Idx];
   }
   oOut << (tU32)TMInfoRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TMInfoRefList.size(); ++u32Idx)
         oOut << TMInfoRefList[u32Idx];
   }
   oOut << (tU32)TMCodedTextRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TMCodedTextRefList.size(); ++u32Idx)
         oOut << TMCodedTextRefList[u32Idx];
   }
   oOut << (tU32)TMCodedMapRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TMCodedMapRefList.size(); ++u32Idx)
         oOut << TMCodedMapRefList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgDeleteUserTrafficMessagesMethodStart::navifi_tclMsgDeleteUserTrafficMessagesMethodStart(const navifi_tclMsgDeleteUserTrafficMessagesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   UTMHandles = coRef.UTMHandles;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgDeleteUserTrafficMessagesMethodStart& navifi_tclMsgDeleteUserTrafficMessagesMethodStart::operator=(const navifi_tclMsgDeleteUserTrafficMessagesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   UTMHandles = coRef.UTMHandles;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgDeleteUserTrafficMessagesMethodStart::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgDeleteUserTrafficMessagesMethodStart::u16GetFunctionID() const {return NAVIFI_C_U16_DELETEUSERTRAFFICMESSAGES;}
tU8 navifi_tclMsgDeleteUserTrafficMessagesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid navifi_tclMsgDeleteUserTrafficMessagesMethodStart::vDestroy()
{
   UTMHandles.clear();
}

tU32 navifi_tclMsgDeleteUserTrafficMessagesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+UTMHandles.size()*2;
}

tBool navifi_tclMsgDeleteUserTrafficMessagesMethodStart::operator==(const navifi_tclMsgDeleteUserTrafficMessagesMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UTMHandles.size() == rfoCmp.UTMHandles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < UTMHandles.size()); ++u32Idx)
            bResult = bResult && (UTMHandles[u32Idx] == rfoCmp.UTMHandles[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& navifi_tclMsgDeleteUserTrafficMessagesMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      UTMHandles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> UTMHandles[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& navifi_tclMsgDeleteUserTrafficMessagesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)UTMHandles.size();
   {
      for (tU32 u32Idx = 0; u32Idx < UTMHandles.size(); ++u32Idx)
         oOut << UTMHandles[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgDeleteUserTrafficMessagesMethodResult::navifi_tclMsgDeleteUserTrafficMessagesMethodResult(const navifi_tclMsgDeleteUserTrafficMessagesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Result = coRef.Result;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgDeleteUserTrafficMessagesMethodResult& navifi_tclMsgDeleteUserTrafficMessagesMethodResult::operator=(const navifi_tclMsgDeleteUserTrafficMessagesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgDeleteUserTrafficMessagesMethodResult::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgDeleteUserTrafficMessagesMethodResult::u16GetFunctionID() const {return NAVIFI_C_U16_DELETEUSERTRAFFICMESSAGES;}
tU8 navifi_tclMsgDeleteUserTrafficMessagesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid navifi_tclMsgDeleteUserTrafficMessagesMethodResult::vDestroy()
{
   Result.clear();
}

tU32 navifi_tclMsgDeleteUserTrafficMessagesMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+Result.size()*2;
}

tBool navifi_tclMsgDeleteUserTrafficMessagesMethodResult::operator==(const navifi_tclMsgDeleteUserTrafficMessagesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Result.size() == rfoCmp.Result.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Result.size()); ++u32Idx)
            bResult = bResult && (Result[u32Idx] == rfoCmp.Result[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& navifi_tclMsgDeleteUserTrafficMessagesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      Result.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Result[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& navifi_tclMsgDeleteUserTrafficMessagesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)Result.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Result.size(); ++u32Idx)
         oOut << Result[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgCreateUserTrafficMessagesMethodStart::navifi_tclMsgCreateUserTrafficMessagesMethodStart(const navifi_tclMsgCreateUserTrafficMessagesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   UTMDesc = coRef.UTMDesc;
   UTMDescByTM = coRef.UTMDescByTM;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgCreateUserTrafficMessagesMethodStart& navifi_tclMsgCreateUserTrafficMessagesMethodStart::operator=(const navifi_tclMsgCreateUserTrafficMessagesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   UTMDesc = coRef.UTMDesc;
   UTMDescByTM = coRef.UTMDescByTM;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgCreateUserTrafficMessagesMethodStart::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgCreateUserTrafficMessagesMethodStart::u16GetFunctionID() const {return NAVIFI_C_U16_CREATEUSERTRAFFICMESSAGES;}
tU8 navifi_tclMsgCreateUserTrafficMessagesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid navifi_tclMsgCreateUserTrafficMessagesMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < UTMDesc.size(); ++u32Idx)
         UTMDesc[u32Idx].vDestroy();
   }
   UTMDesc.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < UTMDescByTM.size(); ++u32Idx)
         UTMDescByTM[u32Idx].vDestroy();
   }
   UTMDescByTM.clear();
}

tU32 navifi_tclMsgCreateUserTrafficMessagesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < UTMDesc.size(); ++u32ListIdx)
      u32DynamicSize += UTMDesc[u32ListIdx].u32GetSize(u16MajorVersion);
   if (17 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      u32DynamicSize += UTMDescByTM.size()*10;
   }
   return u32DynamicSize+4;
}

tBool navifi_tclMsgCreateUserTrafficMessagesMethodStart::operator==(const navifi_tclMsgCreateUserTrafficMessagesMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UTMDesc.size() == rfoCmp.UTMDesc.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < UTMDesc.size()); ++u32Idx)
            bResult = bResult && (UTMDesc[u32Idx] == rfoCmp.UTMDesc[u32Idx]);
      }
      bResult = bResult && (UTMDescByTM.size() == rfoCmp.UTMDescByTM.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < UTMDescByTM.size()); ++u32Idx)
            bResult = bResult && (UTMDescByTM[u32Idx] == rfoCmp.UTMDescByTM[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& navifi_tclMsgCreateUserTrafficMessagesMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < UTMDesc.size(); ++u32Idx)
      {
         UTMDesc[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      UTMDesc.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> UTMDesc[u32Idx];
      }
   }
   if (17 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < UTMDescByTM.size(); ++u32Idx)
         {
            UTMDescByTM[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         UTMDescByTM.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> UTMDescByTM[u32Idx];
         }
      }
   }
   return oIn;
}

fi_tclOutContext& navifi_tclMsgCreateUserTrafficMessagesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)UTMDesc.size();
   {
      for (tU32 u32Idx = 0; u32Idx < UTMDesc.size(); ++u32Idx)
         oOut << UTMDesc[u32Idx];
   }
   if (17 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)UTMDescByTM.size();
      {
         for (tU32 u32Idx = 0; u32Idx < UTMDescByTM.size(); ++u32Idx)
            oOut << UTMDescByTM[u32Idx];
      }
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgCreateUserTrafficMessagesMethodResult::navifi_tclMsgCreateUserTrafficMessagesMethodResult(const navifi_tclMsgCreateUserTrafficMessagesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UTMHandles = coRef.UTMHandles;
   UTMHandlesByTM = coRef.UTMHandlesByTM;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgCreateUserTrafficMessagesMethodResult& navifi_tclMsgCreateUserTrafficMessagesMethodResult::operator=(const navifi_tclMsgCreateUserTrafficMessagesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UTMHandles = coRef.UTMHandles;
   UTMHandlesByTM = coRef.UTMHandlesByTM;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgCreateUserTrafficMessagesMethodResult::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgCreateUserTrafficMessagesMethodResult::u16GetFunctionID() const {return NAVIFI_C_U16_CREATEUSERTRAFFICMESSAGES;}
tU8 navifi_tclMsgCreateUserTrafficMessagesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid navifi_tclMsgCreateUserTrafficMessagesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < UTMHandles.size(); ++u32Idx)
         UTMHandles[u32Idx].vDestroy();
   }
   UTMHandles.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < UTMHandlesByTM.size(); ++u32Idx)
         UTMHandlesByTM[u32Idx].vDestroy();
   }
   UTMHandlesByTM.clear();
}

tU32 navifi_tclMsgCreateUserTrafficMessagesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (17 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      u32DynamicSize += UTMHandlesByTM.size()*8;
   }
   return u32DynamicSize+4+UTMHandles.size()*8;
}

tBool navifi_tclMsgCreateUserTrafficMessagesMethodResult::operator==(const navifi_tclMsgCreateUserTrafficMessagesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UTMHandles.size() == rfoCmp.UTMHandles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < UTMHandles.size()); ++u32Idx)
            bResult = bResult && (UTMHandles[u32Idx] == rfoCmp.UTMHandles[u32Idx]);
      }
      bResult = bResult && (UTMHandlesByTM.size() == rfoCmp.UTMHandlesByTM.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < UTMHandlesByTM.size()); ++u32Idx)
            bResult = bResult && (UTMHandlesByTM[u32Idx] == rfoCmp.UTMHandlesByTM[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& navifi_tclMsgCreateUserTrafficMessagesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < UTMHandles.size(); ++u32Idx)
      {
         UTMHandles[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      UTMHandles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> UTMHandles[u32Idx];
      }
   }
   if (17 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < UTMHandlesByTM.size(); ++u32Idx)
         {
            UTMHandlesByTM[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         UTMHandlesByTM.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> UTMHandlesByTM[u32Idx];
         }
      }
   }
   return oIn;
}

fi_tclOutContext& navifi_tclMsgCreateUserTrafficMessagesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)UTMHandles.size();
   {
      for (tU32 u32Idx = 0; u32Idx < UTMHandles.size(); ++u32Idx)
         oOut << UTMHandles[u32Idx];
   }
   if (17 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)UTMHandlesByTM.size();
      {
         for (tU32 u32Idx = 0; u32Idx < UTMHandlesByTM.size(); ++u32Idx)
            oOut << UTMHandlesByTM[u32Idx];
      }
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgGetTimeZoneInfoMethodStart::navifi_tclMsgGetTimeZoneInfoMethodStart(const navifi_tclMsgGetTimeZoneInfoMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   Locations = coRef.Locations;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgGetTimeZoneInfoMethodStart& navifi_tclMsgGetTimeZoneInfoMethodStart::operator=(const navifi_tclMsgGetTimeZoneInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Locations = coRef.Locations;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgGetTimeZoneInfoMethodStart::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgGetTimeZoneInfoMethodStart::u16GetFunctionID() const {return NAVIFI_C_U16_GETTIMEZONEINFO;}
tU8 navifi_tclMsgGetTimeZoneInfoMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid navifi_tclMsgGetTimeZoneInfoMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Locations.size(); ++u32Idx)
         Locations[u32Idx].vDestroy();
   }
   Locations.clear();
}

tU32 navifi_tclMsgGetTimeZoneInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Locations.size(); ++u32ListIdx)
      u32DynamicSize += Locations[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool navifi_tclMsgGetTimeZoneInfoMethodStart::operator==(const navifi_tclMsgGetTimeZoneInfoMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Locations.size() == rfoCmp.Locations.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Locations.size()); ++u32Idx)
            bResult = bResult && (Locations[u32Idx] == rfoCmp.Locations[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& navifi_tclMsgGetTimeZoneInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Locations.size(); ++u32Idx)
      {
         Locations[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Locations.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Locations[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& navifi_tclMsgGetTimeZoneInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)Locations.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Locations.size(); ++u32Idx)
         oOut << Locations[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgGetTimeZoneInfoMethodResult::navifi_tclMsgGetTimeZoneInfoMethodResult(const navifi_tclMsgGetTimeZoneInfoMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TimeZoneElementList = coRef.TimeZoneElementList;
   TimeZoneNameList = coRef.TimeZoneNameList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgGetTimeZoneInfoMethodResult& navifi_tclMsgGetTimeZoneInfoMethodResult::operator=(const navifi_tclMsgGetTimeZoneInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TimeZoneElementList = coRef.TimeZoneElementList;
   TimeZoneNameList = coRef.TimeZoneNameList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgGetTimeZoneInfoMethodResult::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgGetTimeZoneInfoMethodResult::u16GetFunctionID() const {return NAVIFI_C_U16_GETTIMEZONEINFO;}
tU8 navifi_tclMsgGetTimeZoneInfoMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid navifi_tclMsgGetTimeZoneInfoMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TimeZoneElementList.size(); ++u32Idx)
         TimeZoneElementList[u32Idx].vDestroy();
   }
   TimeZoneElementList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < TimeZoneNameList.size(); ++u32Idx)
         TimeZoneNameList[u32Idx].vDestroy();
   }
   TimeZoneNameList.clear();
}

tU32 navifi_tclMsgGetTimeZoneInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TimeZoneElementList.size(); ++u32ListIdx)
      u32DynamicSize += TimeZoneElementList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < TimeZoneNameList.size(); ++u32ListIdx)
      u32DynamicSize += TimeZoneNameList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool navifi_tclMsgGetTimeZoneInfoMethodResult::operator==(const navifi_tclMsgGetTimeZoneInfoMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TimeZoneElementList.size() == rfoCmp.TimeZoneElementList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TimeZoneElementList.size()); ++u32Idx)
            bResult = bResult && (TimeZoneElementList[u32Idx] == rfoCmp.TimeZoneElementList[u32Idx]);
      }
      bResult = bResult && (TimeZoneNameList.size() == rfoCmp.TimeZoneNameList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TimeZoneNameList.size()); ++u32Idx)
            bResult = bResult && (TimeZoneNameList[u32Idx] == rfoCmp.TimeZoneNameList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& navifi_tclMsgGetTimeZoneInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TimeZoneElementList.size(); ++u32Idx)
      {
         TimeZoneElementList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TimeZoneElementList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TimeZoneElementList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TimeZoneNameList.size(); ++u32Idx)
      {
         TimeZoneNameList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TimeZoneNameList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TimeZoneNameList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& navifi_tclMsgGetTimeZoneInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)TimeZoneElementList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TimeZoneElementList.size(); ++u32Idx)
         oOut << TimeZoneElementList[u32Idx];
   }
   oOut << (tU32)TimeZoneNameList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TimeZoneNameList.size(); ++u32Idx)
         oOut << TimeZoneNameList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgVersionInfoGet::navifi_tclMsgVersionInfoGet(const navifi_tclMsgVersionInfoGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgVersionInfoGet& navifi_tclMsgVersionInfoGet::operator=(const navifi_tclMsgVersionInfoGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgVersionInfoGet::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgVersionInfoGet::u16GetFunctionID() const {return NAVIFI_C_U16_VERSIONINFO;}
tU8 navifi_tclMsgVersionInfoGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 navifi_tclMsgVersionInfoGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool navifi_tclMsgVersionInfoGet::operator==(const navifi_tclMsgVersionInfoGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& navifi_tclMsgVersionInfoGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& navifi_tclMsgVersionInfoGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgVersionInfoStatus::navifi_tclMsgVersionInfoStatus(const navifi_tclMsgVersionInfoStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ProductVersionInfo = coRef.ProductVersionInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgVersionInfoStatus& navifi_tclMsgVersionInfoStatus::operator=(const navifi_tclMsgVersionInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   ProductVersionInfo = coRef.ProductVersionInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgVersionInfoStatus::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgVersionInfoStatus::u16GetFunctionID() const {return NAVIFI_C_U16_VERSIONINFO;}
tU8 navifi_tclMsgVersionInfoStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid navifi_tclMsgVersionInfoStatus::vDestroy()
{
   ProductVersionInfo.vDestroy(); 
}

tU32 navifi_tclMsgVersionInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+ProductVersionInfo.u32GetSize(u16MajorVersion);
}

tBool navifi_tclMsgVersionInfoStatus::operator==(const navifi_tclMsgVersionInfoStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ProductVersionInfo == rfoCmp.ProductVersionInfo);
   return bResult;
}

fi_tclInContext& navifi_tclMsgVersionInfoStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ProductVersionInfo;
   return oIn;
}

fi_tclOutContext& navifi_tclMsgVersionInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ProductVersionInfo;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgAvailablePOISourcesUpReg::navifi_tclMsgAvailablePOISourcesUpReg(const navifi_tclMsgAvailablePOISourcesUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgAvailablePOISourcesUpReg& navifi_tclMsgAvailablePOISourcesUpReg::operator=(const navifi_tclMsgAvailablePOISourcesUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgAvailablePOISourcesUpReg::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgAvailablePOISourcesUpReg::u16GetFunctionID() const {return NAVIFI_C_U16_AVAILABLEPOISOURCES;}
tU8 navifi_tclMsgAvailablePOISourcesUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 navifi_tclMsgAvailablePOISourcesUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool navifi_tclMsgAvailablePOISourcesUpReg::operator==(const navifi_tclMsgAvailablePOISourcesUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& navifi_tclMsgAvailablePOISourcesUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& navifi_tclMsgAvailablePOISourcesUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgAvailablePOISourcesRelUpReg::navifi_tclMsgAvailablePOISourcesRelUpReg(const navifi_tclMsgAvailablePOISourcesRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgAvailablePOISourcesRelUpReg& navifi_tclMsgAvailablePOISourcesRelUpReg::operator=(const navifi_tclMsgAvailablePOISourcesRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgAvailablePOISourcesRelUpReg::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgAvailablePOISourcesRelUpReg::u16GetFunctionID() const {return NAVIFI_C_U16_AVAILABLEPOISOURCES;}
tU8 navifi_tclMsgAvailablePOISourcesRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 navifi_tclMsgAvailablePOISourcesRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool navifi_tclMsgAvailablePOISourcesRelUpReg::operator==(const navifi_tclMsgAvailablePOISourcesRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& navifi_tclMsgAvailablePOISourcesRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& navifi_tclMsgAvailablePOISourcesRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgAvailablePOISourcesGet::navifi_tclMsgAvailablePOISourcesGet(const navifi_tclMsgAvailablePOISourcesGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgAvailablePOISourcesGet& navifi_tclMsgAvailablePOISourcesGet::operator=(const navifi_tclMsgAvailablePOISourcesGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgAvailablePOISourcesGet::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgAvailablePOISourcesGet::u16GetFunctionID() const {return NAVIFI_C_U16_AVAILABLEPOISOURCES;}
tU8 navifi_tclMsgAvailablePOISourcesGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 navifi_tclMsgAvailablePOISourcesGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool navifi_tclMsgAvailablePOISourcesGet::operator==(const navifi_tclMsgAvailablePOISourcesGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& navifi_tclMsgAvailablePOISourcesGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& navifi_tclMsgAvailablePOISourcesGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgAvailablePOISourcesStatus::navifi_tclMsgAvailablePOISourcesStatus(const navifi_tclMsgAvailablePOISourcesStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   AvailablePOISource = coRef.AvailablePOISource;
   ChangedPOISource = coRef.ChangedPOISource;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgAvailablePOISourcesStatus& navifi_tclMsgAvailablePOISourcesStatus::operator=(const navifi_tclMsgAvailablePOISourcesStatus& coRef)
{
   if (this == &coRef) return *this;
   AvailablePOISource = coRef.AvailablePOISource;
   ChangedPOISource = coRef.ChangedPOISource;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgAvailablePOISourcesStatus::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgAvailablePOISourcesStatus::u16GetFunctionID() const {return NAVIFI_C_U16_AVAILABLEPOISOURCES;}
tU8 navifi_tclMsgAvailablePOISourcesStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 navifi_tclMsgAvailablePOISourcesStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (15 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+2;
}

tBool navifi_tclMsgAvailablePOISourcesStatus::operator==(const navifi_tclMsgAvailablePOISourcesStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AvailablePOISource == rfoCmp.AvailablePOISource);
      bResult = bResult && (ChangedPOISource == rfoCmp.ChangedPOISource);
   return bResult;
}

fi_tclInContext& navifi_tclMsgAvailablePOISourcesStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> AvailablePOISource;
   if (15 <= oIn.u16GetMajorVersion())
   {
      oIn >> ChangedPOISource;
   }
   return oIn;
}

fi_tclOutContext& navifi_tclMsgAvailablePOISourcesStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << AvailablePOISource;
   if (15 <= oOut.u16GetMajorVersion())
   {
      oOut << ChangedPOISource;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgTrafficMessageSourceAvailableGet::navifi_tclMsgTrafficMessageSourceAvailableGet(const navifi_tclMsgTrafficMessageSourceAvailableGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgTrafficMessageSourceAvailableGet& navifi_tclMsgTrafficMessageSourceAvailableGet::operator=(const navifi_tclMsgTrafficMessageSourceAvailableGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgTrafficMessageSourceAvailableGet::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgTrafficMessageSourceAvailableGet::u16GetFunctionID() const {return NAVIFI_C_U16_TRAFFICMESSAGESOURCEAVAILABLE;}
tU8 navifi_tclMsgTrafficMessageSourceAvailableGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 navifi_tclMsgTrafficMessageSourceAvailableGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool navifi_tclMsgTrafficMessageSourceAvailableGet::operator==(const navifi_tclMsgTrafficMessageSourceAvailableGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& navifi_tclMsgTrafficMessageSourceAvailableGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& navifi_tclMsgTrafficMessageSourceAvailableGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgTrafficMessageSourceAvailableStatus::navifi_tclMsgTrafficMessageSourceAvailableStatus(const navifi_tclMsgTrafficMessageSourceAvailableStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   TrafficMessageSourceAvailable = coRef.TrafficMessageSourceAvailable;
   SupportedRDBIDs = coRef.SupportedRDBIDs;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgTrafficMessageSourceAvailableStatus& navifi_tclMsgTrafficMessageSourceAvailableStatus::operator=(const navifi_tclMsgTrafficMessageSourceAvailableStatus& coRef)
{
   if (this == &coRef) return *this;
   TrafficMessageSourceAvailable = coRef.TrafficMessageSourceAvailable;
   SupportedRDBIDs = coRef.SupportedRDBIDs;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgTrafficMessageSourceAvailableStatus::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgTrafficMessageSourceAvailableStatus::u16GetFunctionID() const {return NAVIFI_C_U16_TRAFFICMESSAGESOURCEAVAILABLE;}
tU8 navifi_tclMsgTrafficMessageSourceAvailableStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid navifi_tclMsgTrafficMessageSourceAvailableStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SupportedRDBIDs.size(); ++u32Idx)
         SupportedRDBIDs[u32Idx].vDestroy();
   }
   SupportedRDBIDs.clear();
}

tU32 navifi_tclMsgTrafficMessageSourceAvailableStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SupportedRDBIDs.size(); ++u32ListIdx)
      u32DynamicSize += SupportedRDBIDs[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5;
}

tBool navifi_tclMsgTrafficMessageSourceAvailableStatus::operator==(const navifi_tclMsgTrafficMessageSourceAvailableStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TrafficMessageSourceAvailable == rfoCmp.TrafficMessageSourceAvailable);
      bResult = bResult && (SupportedRDBIDs.size() == rfoCmp.SupportedRDBIDs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SupportedRDBIDs.size()); ++u32Idx)
            bResult = bResult && (SupportedRDBIDs[u32Idx] == rfoCmp.SupportedRDBIDs[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& navifi_tclMsgTrafficMessageSourceAvailableStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> TrafficMessageSourceAvailable;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SupportedRDBIDs.size(); ++u32Idx)
      {
         SupportedRDBIDs[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SupportedRDBIDs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SupportedRDBIDs[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& navifi_tclMsgTrafficMessageSourceAvailableStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TrafficMessageSourceAvailable;
   oOut << (tU32)SupportedRDBIDs.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SupportedRDBIDs.size(); ++u32Idx)
         oOut << SupportedRDBIDs[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgAllTrafficMessagesStatusGet::navifi_tclMsgAllTrafficMessagesStatusGet(const navifi_tclMsgAllTrafficMessagesStatusGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgAllTrafficMessagesStatusGet& navifi_tclMsgAllTrafficMessagesStatusGet::operator=(const navifi_tclMsgAllTrafficMessagesStatusGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgAllTrafficMessagesStatusGet::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgAllTrafficMessagesStatusGet::u16GetFunctionID() const {return NAVIFI_C_U16_ALLTRAFFICMESSAGESSTATUS;}
tU8 navifi_tclMsgAllTrafficMessagesStatusGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 navifi_tclMsgAllTrafficMessagesStatusGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool navifi_tclMsgAllTrafficMessagesStatusGet::operator==(const navifi_tclMsgAllTrafficMessagesStatusGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& navifi_tclMsgAllTrafficMessagesStatusGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& navifi_tclMsgAllTrafficMessagesStatusGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgAllTrafficMessagesStatusStatus::navifi_tclMsgAllTrafficMessagesStatusStatus(const navifi_tclMsgAllTrafficMessagesStatusStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Status = coRef.Status;
   CurrentTrafficMessageRevision = coRef.CurrentTrafficMessageRevision;
   TMStatistics = coRef.TMStatistics;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgAllTrafficMessagesStatusStatus& navifi_tclMsgAllTrafficMessagesStatusStatus::operator=(const navifi_tclMsgAllTrafficMessagesStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   CurrentTrafficMessageRevision = coRef.CurrentTrafficMessageRevision;
   TMStatistics = coRef.TMStatistics;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgAllTrafficMessagesStatusStatus::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgAllTrafficMessagesStatusStatus::u16GetFunctionID() const {return NAVIFI_C_U16_ALLTRAFFICMESSAGESSTATUS;}
tU8 navifi_tclMsgAllTrafficMessagesStatusStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid navifi_tclMsgAllTrafficMessagesStatusStatus::vDestroy()
{
   Status.vDestroy(); 
   TMStatistics.vDestroy(); 
}

tU32 navifi_tclMsgAllTrafficMessagesStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 7+TMStatistics.u32GetSize(u16MajorVersion);
}

tBool navifi_tclMsgAllTrafficMessagesStatusStatus::operator==(const navifi_tclMsgAllTrafficMessagesStatusStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Status == rfoCmp.Status);
      bResult = bResult && (CurrentTrafficMessageRevision == rfoCmp.CurrentTrafficMessageRevision);
      bResult = bResult && (TMStatistics == rfoCmp.TMStatistics);
   return bResult;
}

fi_tclInContext& navifi_tclMsgAllTrafficMessagesStatusStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Status;
   oIn >> CurrentTrafficMessageRevision;
   oIn >> TMStatistics;
   return oIn;
}

fi_tclOutContext& navifi_tclMsgAllTrafficMessagesStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Status;
   oOut << CurrentTrafficMessageRevision;
   oOut << TMStatistics;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgTrafficMsgMemoryStatisticsUpReg::navifi_tclMsgTrafficMsgMemoryStatisticsUpReg(const navifi_tclMsgTrafficMsgMemoryStatisticsUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgTrafficMsgMemoryStatisticsUpReg& navifi_tclMsgTrafficMsgMemoryStatisticsUpReg::operator=(const navifi_tclMsgTrafficMsgMemoryStatisticsUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgTrafficMsgMemoryStatisticsUpReg::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgTrafficMsgMemoryStatisticsUpReg::u16GetFunctionID() const {return NAVIFI_C_U16_TRAFFICMSGMEMORYSTATISTICS;}
tU8 navifi_tclMsgTrafficMsgMemoryStatisticsUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 navifi_tclMsgTrafficMsgMemoryStatisticsUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool navifi_tclMsgTrafficMsgMemoryStatisticsUpReg::operator==(const navifi_tclMsgTrafficMsgMemoryStatisticsUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& navifi_tclMsgTrafficMsgMemoryStatisticsUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& navifi_tclMsgTrafficMsgMemoryStatisticsUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgTrafficMsgMemoryStatisticsRelUpReg::navifi_tclMsgTrafficMsgMemoryStatisticsRelUpReg(const navifi_tclMsgTrafficMsgMemoryStatisticsRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgTrafficMsgMemoryStatisticsRelUpReg& navifi_tclMsgTrafficMsgMemoryStatisticsRelUpReg::operator=(const navifi_tclMsgTrafficMsgMemoryStatisticsRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgTrafficMsgMemoryStatisticsRelUpReg::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgTrafficMsgMemoryStatisticsRelUpReg::u16GetFunctionID() const {return NAVIFI_C_U16_TRAFFICMSGMEMORYSTATISTICS;}
tU8 navifi_tclMsgTrafficMsgMemoryStatisticsRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 navifi_tclMsgTrafficMsgMemoryStatisticsRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool navifi_tclMsgTrafficMsgMemoryStatisticsRelUpReg::operator==(const navifi_tclMsgTrafficMsgMemoryStatisticsRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& navifi_tclMsgTrafficMsgMemoryStatisticsRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& navifi_tclMsgTrafficMsgMemoryStatisticsRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgTrafficMsgMemoryStatisticsStatus::navifi_tclMsgTrafficMsgMemoryStatisticsStatus(const navifi_tclMsgTrafficMsgMemoryStatisticsStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   TrafficMsgMemoryStatisticsAll = coRef.TrafficMsgMemoryStatisticsAll;
   TrafficMsgMemoryStatisticsSelected = coRef.TrafficMsgMemoryStatisticsSelected;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgTrafficMsgMemoryStatisticsStatus& navifi_tclMsgTrafficMsgMemoryStatisticsStatus::operator=(const navifi_tclMsgTrafficMsgMemoryStatisticsStatus& coRef)
{
   if (this == &coRef) return *this;
   TrafficMsgMemoryStatisticsAll = coRef.TrafficMsgMemoryStatisticsAll;
   TrafficMsgMemoryStatisticsSelected = coRef.TrafficMsgMemoryStatisticsSelected;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgTrafficMsgMemoryStatisticsStatus::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgTrafficMsgMemoryStatisticsStatus::u16GetFunctionID() const {return NAVIFI_C_U16_TRAFFICMSGMEMORYSTATISTICS;}
tU8 navifi_tclMsgTrafficMsgMemoryStatisticsStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid navifi_tclMsgTrafficMsgMemoryStatisticsStatus::vDestroy()
{
   TrafficMsgMemoryStatisticsAll.vDestroy(); 
   TrafficMsgMemoryStatisticsSelected.vDestroy(); 
}

tU32 navifi_tclMsgTrafficMsgMemoryStatisticsStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TrafficMsgMemoryStatisticsAll.u32GetSize(u16MajorVersion)+TrafficMsgMemoryStatisticsSelected.u32GetSize(u16MajorVersion);
}

tBool navifi_tclMsgTrafficMsgMemoryStatisticsStatus::operator==(const navifi_tclMsgTrafficMsgMemoryStatisticsStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TrafficMsgMemoryStatisticsAll == rfoCmp.TrafficMsgMemoryStatisticsAll);
      bResult = bResult && (TrafficMsgMemoryStatisticsSelected == rfoCmp.TrafficMsgMemoryStatisticsSelected);
   return bResult;
}

fi_tclInContext& navifi_tclMsgTrafficMsgMemoryStatisticsStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> TrafficMsgMemoryStatisticsAll;
   oIn >> TrafficMsgMemoryStatisticsSelected;
   return oIn;
}

fi_tclOutContext& navifi_tclMsgTrafficMsgMemoryStatisticsStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TrafficMsgMemoryStatisticsAll;
   oOut << TrafficMsgMemoryStatisticsSelected;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgUserTrafficMessagesStatusGet::navifi_tclMsgUserTrafficMessagesStatusGet(const navifi_tclMsgUserTrafficMessagesStatusGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgUserTrafficMessagesStatusGet& navifi_tclMsgUserTrafficMessagesStatusGet::operator=(const navifi_tclMsgUserTrafficMessagesStatusGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgUserTrafficMessagesStatusGet::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgUserTrafficMessagesStatusGet::u16GetFunctionID() const {return NAVIFI_C_U16_USERTRAFFICMESSAGESSTATUS;}
tU8 navifi_tclMsgUserTrafficMessagesStatusGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 navifi_tclMsgUserTrafficMessagesStatusGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool navifi_tclMsgUserTrafficMessagesStatusGet::operator==(const navifi_tclMsgUserTrafficMessagesStatusGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& navifi_tclMsgUserTrafficMessagesStatusGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& navifi_tclMsgUserTrafficMessagesStatusGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgUserTrafficMessagesStatusStatus::navifi_tclMsgUserTrafficMessagesStatusStatus(const navifi_tclMsgUserTrafficMessagesStatusStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   FreeUTMHandleCount = coRef.FreeUTMHandleCount;
   UsedUTMHandles = coRef.UsedUTMHandles;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgUserTrafficMessagesStatusStatus& navifi_tclMsgUserTrafficMessagesStatusStatus::operator=(const navifi_tclMsgUserTrafficMessagesStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   FreeUTMHandleCount = coRef.FreeUTMHandleCount;
   UsedUTMHandles = coRef.UsedUTMHandles;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgUserTrafficMessagesStatusStatus::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgUserTrafficMessagesStatusStatus::u16GetFunctionID() const {return NAVIFI_C_U16_USERTRAFFICMESSAGESSTATUS;}
tU8 navifi_tclMsgUserTrafficMessagesStatusStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid navifi_tclMsgUserTrafficMessagesStatusStatus::vDestroy()
{
   UsedUTMHandles.clear();
}

tU32 navifi_tclMsgUserTrafficMessagesStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+UsedUTMHandles.size()*2;
}

tBool navifi_tclMsgUserTrafficMessagesStatusStatus::operator==(const navifi_tclMsgUserTrafficMessagesStatusStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FreeUTMHandleCount == rfoCmp.FreeUTMHandleCount);
      bResult = bResult && (UsedUTMHandles.size() == rfoCmp.UsedUTMHandles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < UsedUTMHandles.size()); ++u32Idx)
            bResult = bResult && (UsedUTMHandles[u32Idx] == rfoCmp.UsedUTMHandles[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& navifi_tclMsgUserTrafficMessagesStatusStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> FreeUTMHandleCount;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      UsedUTMHandles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> UsedUTMHandles[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& navifi_tclMsgUserTrafficMessagesStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << FreeUTMHandleCount;
   oOut << (tU32)UsedUTMHandles.size();
   {
      for (tU32 u32Idx = 0; u32Idx < UsedUTMHandles.size(); ++u32Idx)
         oOut << UsedUTMHandles[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgEngineeringTextGet::navifi_tclMsgEngineeringTextGet(const navifi_tclMsgEngineeringTextGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgEngineeringTextGet& navifi_tclMsgEngineeringTextGet::operator=(const navifi_tclMsgEngineeringTextGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgEngineeringTextGet::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgEngineeringTextGet::u16GetFunctionID() const {return NAVIFI_C_U16_ENGINEERINGTEXT;}
tU8 navifi_tclMsgEngineeringTextGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 navifi_tclMsgEngineeringTextGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool navifi_tclMsgEngineeringTextGet::operator==(const navifi_tclMsgEngineeringTextGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& navifi_tclMsgEngineeringTextGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& navifi_tclMsgEngineeringTextGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgEngineeringTextUpReg::navifi_tclMsgEngineeringTextUpReg(const navifi_tclMsgEngineeringTextUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgEngineeringTextUpReg& navifi_tclMsgEngineeringTextUpReg::operator=(const navifi_tclMsgEngineeringTextUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgEngineeringTextUpReg::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgEngineeringTextUpReg::u16GetFunctionID() const {return NAVIFI_C_U16_ENGINEERINGTEXT;}
tU8 navifi_tclMsgEngineeringTextUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 navifi_tclMsgEngineeringTextUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool navifi_tclMsgEngineeringTextUpReg::operator==(const navifi_tclMsgEngineeringTextUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& navifi_tclMsgEngineeringTextUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& navifi_tclMsgEngineeringTextUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgEngineeringTextRelUpReg::navifi_tclMsgEngineeringTextRelUpReg(const navifi_tclMsgEngineeringTextRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgEngineeringTextRelUpReg& navifi_tclMsgEngineeringTextRelUpReg::operator=(const navifi_tclMsgEngineeringTextRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgEngineeringTextRelUpReg::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgEngineeringTextRelUpReg::u16GetFunctionID() const {return NAVIFI_C_U16_ENGINEERINGTEXT;}
tU8 navifi_tclMsgEngineeringTextRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 navifi_tclMsgEngineeringTextRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool navifi_tclMsgEngineeringTextRelUpReg::operator==(const navifi_tclMsgEngineeringTextRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& navifi_tclMsgEngineeringTextRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& navifi_tclMsgEngineeringTextRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgEngineeringTextStatus::navifi_tclMsgEngineeringTextStatus(const navifi_tclMsgEngineeringTextStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Message = coRef.Message;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgEngineeringTextStatus& navifi_tclMsgEngineeringTextStatus::operator=(const navifi_tclMsgEngineeringTextStatus& coRef)
{
   if (this == &coRef) return *this;
   Message = coRef.Message;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgEngineeringTextStatus::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgEngineeringTextStatus::u16GetFunctionID() const {return NAVIFI_C_U16_ENGINEERINGTEXT;}
tU8 navifi_tclMsgEngineeringTextStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid navifi_tclMsgEngineeringTextStatus::vDestroy()
{
   Message.vDestroy();
}

tU32 navifi_tclMsgEngineeringTextStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Message.u32GetSize(u16MajorVersion);
}

tBool navifi_tclMsgEngineeringTextStatus::operator==(const navifi_tclMsgEngineeringTextStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Message == rfoCmp.Message);
   return bResult;
}

fi_tclInContext& navifi_tclMsgEngineeringTextStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Message;
   return oIn;
}

fi_tclOutContext& navifi_tclMsgEngineeringTextStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Message;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgUsedDatasetGet::navifi_tclMsgUsedDatasetGet(const navifi_tclMsgUsedDatasetGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgUsedDatasetGet& navifi_tclMsgUsedDatasetGet::operator=(const navifi_tclMsgUsedDatasetGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgUsedDatasetGet::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgUsedDatasetGet::u16GetFunctionID() const {return NAVIFI_C_U16_USEDDATASET;}
tU8 navifi_tclMsgUsedDatasetGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 navifi_tclMsgUsedDatasetGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool navifi_tclMsgUsedDatasetGet::operator==(const navifi_tclMsgUsedDatasetGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& navifi_tclMsgUsedDatasetGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& navifi_tclMsgUsedDatasetGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgUsedDatasetUpReg::navifi_tclMsgUsedDatasetUpReg(const navifi_tclMsgUsedDatasetUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgUsedDatasetUpReg& navifi_tclMsgUsedDatasetUpReg::operator=(const navifi_tclMsgUsedDatasetUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgUsedDatasetUpReg::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgUsedDatasetUpReg::u16GetFunctionID() const {return NAVIFI_C_U16_USEDDATASET;}
tU8 navifi_tclMsgUsedDatasetUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 navifi_tclMsgUsedDatasetUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool navifi_tclMsgUsedDatasetUpReg::operator==(const navifi_tclMsgUsedDatasetUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& navifi_tclMsgUsedDatasetUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& navifi_tclMsgUsedDatasetUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgUsedDatasetRelUpReg::navifi_tclMsgUsedDatasetRelUpReg(const navifi_tclMsgUsedDatasetRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgUsedDatasetRelUpReg& navifi_tclMsgUsedDatasetRelUpReg::operator=(const navifi_tclMsgUsedDatasetRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgUsedDatasetRelUpReg::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgUsedDatasetRelUpReg::u16GetFunctionID() const {return NAVIFI_C_U16_USEDDATASET;}
tU8 navifi_tclMsgUsedDatasetRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 navifi_tclMsgUsedDatasetRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool navifi_tclMsgUsedDatasetRelUpReg::operator==(const navifi_tclMsgUsedDatasetRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& navifi_tclMsgUsedDatasetRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& navifi_tclMsgUsedDatasetRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgUsedDatasetStatus::navifi_tclMsgUsedDatasetStatus(const navifi_tclMsgUsedDatasetStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   MediaId = coRef.MediaId;
   DataSetId = coRef.DataSetId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
navifi_tclMsgUsedDatasetStatus& navifi_tclMsgUsedDatasetStatus::operator=(const navifi_tclMsgUsedDatasetStatus& coRef)
{
   if (this == &coRef) return *this;
   MediaId = coRef.MediaId;
   DataSetId = coRef.DataSetId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 navifi_tclMsgUsedDatasetStatus::u16GetServiceID() const {return NAVIFI_C_U16_SERVICE_ID;}
tU16 navifi_tclMsgUsedDatasetStatus::u16GetFunctionID() const {return NAVIFI_C_U16_USEDDATASET;}
tU8 navifi_tclMsgUsedDatasetStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 navifi_tclMsgUsedDatasetStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool navifi_tclMsgUsedDatasetStatus::operator==(const navifi_tclMsgUsedDatasetStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MediaId == rfoCmp.MediaId);
      bResult = bResult && (DataSetId == rfoCmp.DataSetId);
   return bResult;
}

fi_tclInContext& navifi_tclMsgUsedDatasetStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> MediaId;
   oIn >> DataSetId;
   return oIn;
}

fi_tclOutContext& navifi_tclMsgUsedDatasetStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MediaId;
   oOut << DataSetId;
   return oOut;
}

