#ifndef NAVIFILANGUAGE_HEADER
#define NAVIFILANGUAGE_HEADER

class navifi_tclInContext;
class navifi_tclOutContext;
class navifi_tclVisitorBase;

class MY_DECL navifi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  navifi_tclDescription(fi_tclInContext* poIn, navifi_tclVisitorBase* poVisit);
  navifi_tclDescription(fi_tclOutContext* poOut, navifi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(navifi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ navifi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  navifi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<navifi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<navifi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline navifi_tclDescription::navifi_tclDescription(fi_tclInContext* poIn, navifi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline navifi_tclDescription::navifi_tclDescription(fi_tclOutContext* poOut, navifi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

