#include "precompiled.hh"

tBool navifi_tclDescription::bInitMessage(navifi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case navifi_tclToken::EN_LAST_TOKEN:
   case navifi_tclToken::EN_LIST:
   case navifi_tclToken::EN_END_OF_STRUCT:
   case navifi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case navifi_tclToken::EN_MSG_GETAVAILABLEPERMISSIONSMETHODSTART:
   {
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32_DATASETID,navifi_tclSemanticDomain::EN_MSG_NAVDATASETID));
      }
   } break;
   case navifi_tclToken::EN_MSG_GETAVAILABLEPERMISSIONSMETHODRESULT:
   {
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_REQUIREDPERMISSIONLIST,navifi_tclSemanticDomain::EN_MSG_AVAILABLEPERMISSIONS));
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32_DATASETID,navifi_tclSemanticDomain::EN_MSG_NAVDATASETID));
      }
   } break;
   case navifi_tclToken::EN_MSG_GETGLOBALANNOTATIONTABLESMETHODSTART:
   {
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_GLOBALANNOTATIONCATEGORY,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_REQUIREDANNOTATIONTABLES));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_ISOCOUNTRYCODE,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_REQUIREDCOUNTRYCODES));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32_DATASETID,navifi_tclSemanticDomain::EN_MSG_NAVDATASETID));
   } break;
   case navifi_tclToken::EN_MSG_GETGLOBALANNOTATIONTABLESMETHODRESULT:
   {
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_GLOBALANNOTATIONTABLESUNION,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_GLOBALANNOTATIONTABLES));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32_DATASETID,navifi_tclSemanticDomain::EN_MSG_NAVDATASETID));
   } break;
   case navifi_tclToken::EN_MSG_GETALLTRAFFICMESSAGESMETHODSTART:
   {
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_TMCURRENTIDLIST));
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_MSG_TMCODEDMAPMAJORVERSION));
      }
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_B8_TRAFFICMESSAGECONTENT,navifi_tclSemanticDomain::EN_MSG_WANTEDBINCONTAINER));
   } break;
   case navifi_tclToken::EN_MSG_GETALLTRAFFICMESSAGESMETHODRESULT:
   {
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_BINCONTAINER,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_CODEDMAPMESSAGES));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_BINCONTAINER,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_CODEDTEXTMESSAGES));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMSERVICEPROVIDER,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_SERVICEPROVIDERLIST));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMPROGRAMSERVICE,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_PROGRAMSERVICELIST));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMINFO,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_TMINFO));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_DELETEDIDLIST));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_BOOL,navifi_tclSemanticDomain::EN_MSG_TMCONTENTCOMPLETE));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_B8_TRAFFICMESSAGECONTENT,navifi_tclSemanticDomain::EN_MSG_WANTEDBINCONTAINER));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32,navifi_tclSemanticDomain::EN_MSG_CURRENTTRAFFICMESSAGEREVISION));
   } break;
   case navifi_tclToken::EN_MSG_GETALLTMCLOCATIONSMETHODRESULT:
   {
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_COUNTRYLOCATIONLIST,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_LOCATIONTABLELIST));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32,navifi_tclSemanticDomain::EN_MSG_LOCATIONELEMENTCOUNT));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32,navifi_tclSemanticDomain::EN_MSG_CURRENTTRAFFICMESSAGEREVISION));
   } break;
   case navifi_tclToken::EN_MSG_CHANGETRAFFICMESSAGEHANDLINGMETHODSTART:
   {
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMPARAMAMBIGUOUSAREA,navifi_tclSemanticDomain::EN_MSG_AMBIGUOUSAREA));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMPARAMAMBIGUOUSDYNAMICDISRUPTION,navifi_tclSemanticDomain::EN_MSG_AMBIGUOUSDYNAMICDISRUPTION));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMPARAMAMBIGUOUSCLOSING,navifi_tclSemanticDomain::EN_MSG_AMBIGUOUSCLOSING));
   } break;
   case navifi_tclToken::EN_MSG_CHANGETRAFFICMESSAGEHANDLINGMETHODRESULT:
   {
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMPARAMAMBIGUOUSAREA,navifi_tclSemanticDomain::EN_MSG_AMBIGUOUSAREA));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMPARAMAMBIGUOUSDYNAMICDISRUPTION,navifi_tclSemanticDomain::EN_MSG_AMBIGUOUSDYNAMICDISRUPTION));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMPARAMAMBIGUOUSCLOSING,navifi_tclSemanticDomain::EN_MSG_AMBIGUOUSCLOSING));
   } break;
   case navifi_tclToken::EN_MSG_GETTRAFFICMESSAGESMETHODSTART:
   {
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_TMCURRENTIDLIST));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_MSG_TMCODEDMAPMAJORVERSION));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_B8_TRAFFICMESSAGECONTENT,navifi_tclSemanticDomain::EN_MSG_WANTEDBINCONTAINER));
   } break;
   case navifi_tclToken::EN_MSG_GETTRAFFICMESSAGESMETHODRESULT:
   {
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMCODEDMAPREFERENCE,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_TMCODEDMAPREFLIST));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMCODEDTEXTREFERENCE,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_TMCODEDTEXTREFLIST));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMINFOREFERENCE,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_TMINFOREFLIST));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMSERVICEPROVIDER,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_SERVICEPROVIDERLIST));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMPROGRAMSERVICE,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_PROGRAMSERVICELIST));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMBASEINFO,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_TMBASEINFOLIST));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_DELETEDIDLIST));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_BOOL,navifi_tclSemanticDomain::EN_MSG_TMCONTENTCOMPLETE));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_B8_TRAFFICMESSAGECONTENT,navifi_tclSemanticDomain::EN_MSG_WANTEDBINCONTAINER));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32,navifi_tclSemanticDomain::EN_MSG_CURRENTTRAFFICMESSAGEREVISION));
   } break;
   case navifi_tclToken::EN_MSG_DELETEUSERTRAFFICMESSAGESMETHODSTART:
   {
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16_USERTRAFFICMESSAGEHANDLE,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_UTMHANDLES));
   } break;
   case navifi_tclToken::EN_MSG_DELETEUSERTRAFFICMESSAGESMETHODRESULT:
   {
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16_ERRORCODE,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_RESULT));
   } break;
   case navifi_tclToken::EN_MSG_CREATEUSERTRAFFICMESSAGESMETHODSTART:
   {
      if (17 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_UTMDESCBYTM,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_UTMDESCBYTM));
      }
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_UTMDESC,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_UTMDESC));
   } break;
   case navifi_tclToken::EN_MSG_CREATEUSERTRAFFICMESSAGESMETHODRESULT:
   {
      if (17 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_UTMHANDLECONTAINER,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_UTMHANDLESBYTM));
      }
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_UTMHANDLECONTAINER,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_UTMHANDLES));
   } break;
   case navifi_tclToken::EN_MSG_GETTIMEZONEINFOMETHODSTART:
   {
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_BINCONTAINER,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_LOCATIONS));
   } break;
   case navifi_tclToken::EN_MSG_GETTIMEZONEINFOMETHODRESULT:
   {
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TIMEZONENAME,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_TIMEZONENAMELIST));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TIMEZONEELEMENT,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_TIMEZONEELEMENTLIST));
   } break;
   case navifi_tclToken::EN_MSG_VERSIONINFOSTATUS:
   {
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_VERSIONINFO,navifi_tclSemanticDomain::EN_MSG_PRODUCTVERSIONINFO));
   } break;
   case navifi_tclToken::EN_MSG_AVAILABLEPOISOURCESSTATUS:
   {
      if (15 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_B16_UPOI_SOURCE,navifi_tclSemanticDomain::EN_MSG_CHANGEDPOISOURCE));
      }
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_B16_UPOI_SOURCE,navifi_tclSemanticDomain::EN_MSG_AVAILABLEPOISOURCE));
   } break;
   case navifi_tclToken::EN_MSG_TRAFFICMESSAGESOURCEAVAILABLESTATUS:
   {
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_ISORDBIDAVAILABILITY,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_SUPPORTEDRDBIDS));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_BOOL,navifi_tclSemanticDomain::EN_MSG_TRAFFICMESSAGESOURCEAVAILABLE));
   } break;
   case navifi_tclToken::EN_MSG_ALLTRAFFICMESSAGESSTATUSSTATUS:
   {
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMSTATISTICS,navifi_tclSemanticDomain::EN_MSG_TMSTATISTICS));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32,navifi_tclSemanticDomain::EN_MSG_CURRENTTRAFFICMESSAGEREVISION));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_INFOSTATUS,navifi_tclSemanticDomain::EN_MSG_STATUS));
   } break;
   case navifi_tclToken::EN_MSG_TRAFFICMSGMEMORYSTATISTICSSTATUS:
   {
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TRAFFICMSGMEMORYSTATISTICS,navifi_tclSemanticDomain::EN_MSG_TRAFFICMSGMEMORYSTATISTICSSELECTED));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TRAFFICMSGMEMORYSTATISTICS,navifi_tclSemanticDomain::EN_MSG_TRAFFICMSGMEMORYSTATISTICSALL));
   } break;
   case navifi_tclToken::EN_MSG_USERTRAFFICMESSAGESSTATUSSTATUS:
   {
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16_USERTRAFFICMESSAGEHANDLE,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_MSG_USEDUTMHANDLES));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_MSG_FREEUTMHANDLECOUNT));
   } break;
   case navifi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
   {
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_STRING,navifi_tclSemanticDomain::EN_MSG_MESSAGE));
   } break;
   case navifi_tclToken::EN_MSG_USEDDATASETSTATUS:
   {
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32_DATASETID,navifi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32_MEDIAID,navifi_tclSemanticDomain::EN_MSG_MEDIAID));
   } break;
   case navifi_tclToken::EN_BINCONTAINER:
   case navifi_tclToken::EN_RESERVED:
   case navifi_tclToken::EN_U8_PERCENT:
   case navifi_tclToken::EN_U16_INDEXINREFERENCELIST:
   case navifi_tclToken::EN_U16_ERRORCODE:
   case navifi_tclToken::EN_S32_METER:
   case navifi_tclToken::EN_S32_SECOND:
   case navifi_tclToken::EN_S32_MILLISECOND:
   case navifi_tclToken::EN_POSIXTIME:
   case navifi_tclToken::EN_E8_DST_STATE:
   case navifi_tclToken::EN_TIMEZONEELEMENT:
   case navifi_tclToken::EN_S16_KMPERHOUR:
   case navifi_tclToken::EN_S16_CENTIMETERSECOND:
   case navifi_tclToken::EN_FIVERSION:
   case navifi_tclToken::EN_S32_LONGITUDE:
   case navifi_tclToken::EN_S32_LATITUDE:
   case navifi_tclToken::EN_POSITIONWGS84:
   case navifi_tclToken::EN_E16_ISOCOUNTRYCODE:
   case navifi_tclToken::EN_E16_ISOLANGUAGECODE:
   case navifi_tclToken::EN_U8_DIRECTIONABSOLUTE:
   case navifi_tclToken::EN_E8_BINCONTAINERTYPES:
   case navifi_tclToken::EN_E16_NAVIEVENTVALUE:
   case navifi_tclToken::EN_E8_TRAFFICMSGTYPE:
   case navifi_tclToken::EN_E8_TMLOCATIONTYPE:
   case navifi_tclToken::EN_E8_EVENTTYPE:
   case navifi_tclToken::EN_E16_EFFECTCODE:
   case navifi_tclToken::EN_E16_CAUSECODE:
   case navifi_tclToken::EN_E8_TENDENCY:
   case navifi_tclToken::EN_RDBID:
   case navifi_tclToken::EN_TMEVENT:
   case navifi_tclToken::EN_B32_TRAFFICMESSAGESOURCE:
   case navifi_tclToken::EN_B8_TMADDITIONALINFORMATION:
   case navifi_tclToken::EN_B8_TRAFFICMESSAGESOURCEAVAILABILITY:
   case navifi_tclToken::EN_TRAFFICMSGMEMORYSTATISTICSPERTYPE:
   case navifi_tclToken::EN_TRAFFICMSGMEMORYSTATISTICS:
   case navifi_tclToken::EN_ISORDBIDAVAILABILITY:
   case navifi_tclToken::EN_E8_TMURGENCY:
   case navifi_tclToken::EN_TMCODEDMESSAGE:
   case navifi_tclToken::EN_TMCODEDMESSAGEBINCONTAINER:
   case navifi_tclToken::EN_TMPROGRAMSERVICE:
   case navifi_tclToken::EN_U32_DATASETID:
   case navifi_tclToken::EN_U32_MEDIAID:
   case navifi_tclToken::EN_NAVCLUSTERDESC:
   case navifi_tclToken::EN_E8_NAVONECELLDIRECTION:
   case navifi_tclToken::EN_NAVONECELLDESC:
   case navifi_tclToken::EN_E8_SIDEINFO:
   case navifi_tclToken::EN_S32_EMU:
   case navifi_tclToken::EN_NAVZEROCELLDESC:
   case navifi_tclToken::EN_E8_NAVLOCATIONDESCTYPE:
   case navifi_tclToken::EN_NAVLOCATIONDESC:
   case navifi_tclToken::EN_NAVLOCATIONDESCUNION0:
   case navifi_tclToken::EN_NAVLOCATIONBINCONTAINER:
   case navifi_tclToken::EN_E8_NAVINDEXZFDESTINATIONTYPE:
   case navifi_tclToken::EN_E8_NAVLOCATIONNAVDATATYPE:
   case navifi_tclToken::EN_NAVLOCATIONDATADESC:
   case navifi_tclToken::EN_NAVLOCATIONDATADESCUNION0:
   case navifi_tclToken::EN_NAVSPOTDESTINATIONONECELLPROPERTY:
   case navifi_tclToken::EN_NAVSPOTDESTINATIONONECELLDESC:
   case navifi_tclToken::EN_NAVSPOTDESTINATIONONECELLLISTSET:
   case navifi_tclToken::EN_NAVSTREETDESTINATIONONECELLPROPERTY:
   case navifi_tclToken::EN_NAVSTREETDESTINATIONONECELLDESC:
   case navifi_tclToken::EN_NAVSTREETDESTINATIONONECELLLISTSET:
   case navifi_tclToken::EN_E8_NAVINTERSECTIONTYPE:
   case navifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLPROPERTY:
   case navifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLDESC:
   case navifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
   case navifi_tclToken::EN_NAVAREADESCRIPTIONCIRCLE:
   case navifi_tclToken::EN_NAVAREADESCRIPTIONPOLYGON:
   case navifi_tclToken::EN_NAVDLDCHAINONECELLPROPERTY:
   case navifi_tclToken::EN_NAVDLDCHAINONECELLDESC:
   case navifi_tclToken::EN_NAVDLDCHAINONECELLLISTSET:
   case navifi_tclToken::EN_NAVUTMBINCONTAINER:
   case navifi_tclToken::EN_U16_USERTRAFFICMESSAGEHANDLE:
   case navifi_tclToken::EN_UTMHANDLECONTAINER:
   case navifi_tclToken::EN_B8_TRAFFICMESSAGECONTENT:
   case navifi_tclToken::EN_E8_TMGEOMETRICMESSAGETYPE:
   case navifi_tclToken::EN_TMCODEDTEXTREFERENCE:
   case navifi_tclToken::EN_E8_TMAFFECTIONTYPE:
   case navifi_tclToken::EN_TRAFFICSENSE:
   case navifi_tclToken::EN_TRAFFICSENSELIST:
   case navifi_tclToken::EN_E8_ROADCLASSCODE:
   case navifi_tclToken::EN_E8_ROADTYPEDESC:
   case navifi_tclToken::EN_SPEEDFACTOR:
   case navifi_tclToken::EN_SPEEDFACTORROADAREATYPE:
   case navifi_tclToken::EN_SPEEDFACTORSCOUNTRY:
   case navifi_tclToken::EN_B8_SPEEDLIMITSTATUS:
   case navifi_tclToken::EN_E8_SPEEDUNIT:
   case navifi_tclToken::EN_E8_SPEEDTYPE:
   case navifi_tclToken::EN_SPEEDLIMITSTATUS:
   case navifi_tclToken::EN_SPEEDLIMIT:
   case navifi_tclToken::EN_SPEEDLIMITROADAREATYPE:
   case navifi_tclToken::EN_SPEEDLIMITSCOUNTRY:
   case navifi_tclToken::EN_SPEEDLIMITSLIST:
   case navifi_tclToken::EN_PREFIXDESC:
   case navifi_tclToken::EN_PREFIXSTATE:
   case navifi_tclToken::EN_PREFIXSTATELIST:
   case navifi_tclToken::EN_E8_LANGUAGECAT:
   case navifi_tclToken::EN_LANGUAGECATEGORY:
   case navifi_tclToken::EN_LANGUAGEDESC:
   case navifi_tclToken::EN_LANGUAGEDESCLIST:
   case navifi_tclToken::EN_E8_GLOBALANNOTATIONCATEGORY:
   case navifi_tclToken::EN_GLOBALANNOTATIONTABLESUNION:
   case navifi_tclToken::EN_GLOBALANNOTATIONTABLESUNIONUNION0:
   case navifi_tclToken::EN_TIMEZONENAME:
   case navifi_tclToken::EN_B16_UPOI_SOURCE:
   case navifi_tclToken::EN_E8_TMHANDLING:
   case navifi_tclToken::EN_E8_TMDIRECTIONINTERPRETATION:
   case navifi_tclToken::EN_B8_TMINTERSECTIONPATH:
   case navifi_tclToken::EN_TMPARAMAMBIGUOUSCLOSING:
   case navifi_tclToken::EN_TMPARAMAMBIGUOUSDYNAMICDISRUPTION:
   case navifi_tclToken::EN_TMPARAMAMBIGUOUSAREA:
   case navifi_tclToken::EN_E8_SHAPETYPE:
   case navifi_tclToken::EN_SHAPE:
   case navifi_tclToken::EN_EXTENDEDLOCATION:
   case navifi_tclToken::EN_COUNTRYLOCATIONLIST:
   case navifi_tclToken::EN_TMSERVICEPROVIDER:
   case navifi_tclToken::EN_E8_TMCATEGORY:
   case navifi_tclToken::EN_E8_TMFLOWIMPACT:
   case navifi_tclToken::EN_B8_TMMAPPINGPOSSIBILITY:
   case navifi_tclToken::EN_B8_TMMAPPINGSTATUS:
   case navifi_tclToken::EN_B8_TMONECELLATTRIBUTE:
   case navifi_tclToken::EN_TMONECELLPORTION:
   case navifi_tclToken::EN_TMONECELLDESC:
   case navifi_tclToken::EN_E8_TMVALUESTATUS:
   case navifi_tclToken::EN_TMCSTRUCTUREDTEXT:
   case navifi_tclToken::EN_TMCATEGORYSTATISTICS:
   case navifi_tclToken::EN_TMFLOWIMPACTSTATISTICS:
   case navifi_tclToken::EN_TMURGENCYSTATISTICS:
   case navifi_tclToken::EN_UTMSTATISTICS:
   case navifi_tclToken::EN_TMSTATISTICS:
   case navifi_tclToken::EN_E8_TMGEOGRAPHICALPATHRELATIONTYPE:
   case navifi_tclToken::EN_B8_TMRELEVANCE:
   case navifi_tclToken::EN_B8_ROADNUMBERSTATUS:
   case navifi_tclToken::EN_COMPASSDIRECTION:
   case navifi_tclToken::EN_TMBASEINFO:
   case navifi_tclToken::EN_ROADNUMBER:
   case navifi_tclToken::EN_E8_INFOSTATUS:
   case navifi_tclToken::EN_INFOSTATUS:
   case navifi_tclToken::EN_REQUIREDTAXDISC:
   case navifi_tclToken::EN_E8_REQUIREDPERMISSIONTYPE:
   case navifi_tclToken::EN_E8_REQUIREDPERMISSION:
   case navifi_tclToken::EN_GENERICREQUIREDPERMISSION:
   case navifi_tclToken::EN_REQUIREDPERMISSION:
   case navifi_tclToken::EN_REQUIREDPERMISSIONUNION0:
   case navifi_tclToken::EN_REQUIREDPERMISSIONLIST:
   case navifi_tclToken::EN_TMINFO:
   case navifi_tclToken::EN_TMINFOREFERENCE:
   case navifi_tclToken::EN_SPEEDFACTORSLIST:
   case navifi_tclToken::EN_VERSIONINFO:
   case navifi_tclToken::EN_UTMDESC:
   case navifi_tclToken::EN_UTMDESCBYTM:
   case navifi_tclToken::EN_TMMAPONECELLLISTSET:
   case navifi_tclToken::EN_TMMAPBINCONTAINER:
   case navifi_tclToken::EN_TMCODEDMAPREFERENCE:
   case navifi_tclToken::EN_U8:   
   case navifi_tclToken::EN_S8:   
   case navifi_tclToken::EN_U16:   
   case navifi_tclToken::EN_S16:   
   case navifi_tclToken::EN_U24:   
   case navifi_tclToken::EN_S24:   
   case navifi_tclToken::EN_U32:   
   case navifi_tclToken::EN_S32:   
   case navifi_tclToken::EN_U64:   
   case navifi_tclToken::EN_S64:   
   case navifi_tclToken::EN_F32:   
   case navifi_tclToken::EN_F64:   
   case navifi_tclToken::EN_BOOL:   
   case navifi_tclToken::EN_STRING:   
   case navifi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(navifi_tclKnot(enMsgToken,navifi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool navifi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool navifi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      navifi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      navifi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      navifi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == navifi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(navifi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(navifi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(navifi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case navifi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == navifi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case navifi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            navifi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(navifi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            navifi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(navifi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case navifi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case navifi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case navifi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case navifi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case navifi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case navifi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case navifi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case navifi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case navifi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case navifi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case navifi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case navifi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case navifi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case navifi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case navifi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case navifi_tclToken::EN_MSG_GETAVAILABLEPERMISSIONSMETHODSTART:
   case navifi_tclToken::EN_MSG_GETAVAILABLEPERMISSIONSMETHODRESULT:
   case navifi_tclToken::EN_MSG_GETGLOBALANNOTATIONTABLESMETHODSTART:
   case navifi_tclToken::EN_MSG_GETGLOBALANNOTATIONTABLESMETHODRESULT:
   case navifi_tclToken::EN_MSG_GETALLTRAFFICMESSAGESMETHODSTART:
   case navifi_tclToken::EN_MSG_GETALLTRAFFICMESSAGESMETHODRESULT:
   case navifi_tclToken::EN_MSG_GETALLTMCLOCATIONSMETHODSTART:
   case navifi_tclToken::EN_MSG_GETALLTMCLOCATIONSMETHODRESULT:
   case navifi_tclToken::EN_MSG_CHANGETRAFFICMESSAGEHANDLINGMETHODSTART:
   case navifi_tclToken::EN_MSG_CHANGETRAFFICMESSAGEHANDLINGMETHODRESULT:
   case navifi_tclToken::EN_MSG_GETTRAFFICMESSAGESMETHODSTART:
   case navifi_tclToken::EN_MSG_GETTRAFFICMESSAGESMETHODRESULT:
   case navifi_tclToken::EN_MSG_DELETEUSERTRAFFICMESSAGESMETHODSTART:
   case navifi_tclToken::EN_MSG_DELETEUSERTRAFFICMESSAGESMETHODRESULT:
   case navifi_tclToken::EN_MSG_CREATEUSERTRAFFICMESSAGESMETHODSTART:
   case navifi_tclToken::EN_MSG_CREATEUSERTRAFFICMESSAGESMETHODRESULT:
   case navifi_tclToken::EN_MSG_GETTIMEZONEINFOMETHODSTART:
   case navifi_tclToken::EN_MSG_GETTIMEZONEINFOMETHODRESULT:
   case navifi_tclToken::EN_MSG_VERSIONINFOGET:
   case navifi_tclToken::EN_MSG_VERSIONINFOSTATUS:
   case navifi_tclToken::EN_MSG_AVAILABLEPOISOURCESUPREG:
   case navifi_tclToken::EN_MSG_AVAILABLEPOISOURCESRELUPREG:
   case navifi_tclToken::EN_MSG_AVAILABLEPOISOURCESGET:
   case navifi_tclToken::EN_MSG_AVAILABLEPOISOURCESSTATUS:
   case navifi_tclToken::EN_MSG_TRAFFICMESSAGESOURCEAVAILABLEGET:
   case navifi_tclToken::EN_MSG_TRAFFICMESSAGESOURCEAVAILABLESTATUS:
   case navifi_tclToken::EN_MSG_ALLTRAFFICMESSAGESSTATUSGET:
   case navifi_tclToken::EN_MSG_ALLTRAFFICMESSAGESSTATUSSTATUS:
   case navifi_tclToken::EN_MSG_TRAFFICMSGMEMORYSTATISTICSUPREG:
   case navifi_tclToken::EN_MSG_TRAFFICMSGMEMORYSTATISTICSRELUPREG:
   case navifi_tclToken::EN_MSG_TRAFFICMSGMEMORYSTATISTICSSTATUS:
   case navifi_tclToken::EN_MSG_USERTRAFFICMESSAGESSTATUSGET:
   case navifi_tclToken::EN_MSG_USERTRAFFICMESSAGESSTATUSSTATUS:
   case navifi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
   case navifi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
   case navifi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
   case navifi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
   case navifi_tclToken::EN_MSG_USEDDATASETGET:
   case navifi_tclToken::EN_MSG_USEDDATASETUPREG:
   case navifi_tclToken::EN_MSG_USEDDATASETRELUPREG:
   case navifi_tclToken::EN_MSG_USEDDATASETSTATUS:
      bInitMessage(enToken);
      break;
   case navifi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_RESERVED:
   {
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_U8_PERCENT:
   {
      fi_tcl_u8_Percent o_u8_Percent;
      if (!bDoIt(o_u8_Percent))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_U16_INDEXINREFERENCELIST:
   {
      fi_tcl_u16_IndexInReferenceList o_u16_IndexInReferenceList;
      if (!bDoIt(o_u16_IndexInReferenceList))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_U16_ERRORCODE:
   {
      fi_tcl_u16_ErrorCode o_u16_ErrorCode;
      if (!bDoIt(o_u16_ErrorCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_S32_METER:
   {
      fi_tcl_s32_Meter o_s32_Meter;
      if (!bDoIt(o_s32_Meter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_S32_SECOND:
   {
      fi_tcl_s32_Second o_s32_Second;
      if (!bDoIt(o_s32_Second))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_S32_MILLISECOND:
   {
      fi_tcl_s32_MilliSecond o_s32_MilliSecond;
      if (!bDoIt(o_s32_MilliSecond))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_POSIXTIME:
   {
      if (poVisitor->bDoExpand_POSIXTime(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S32,navifi_tclSemanticDomain::EN_TIME));
      }
      else
      {
         fi_tcl_POSIXTime o_POSIXTime;
         if (!bDoIt(o_POSIXTime))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POSIXTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POSIXTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_E8_DST_STATE:
   {
      fi_tcl_e8_DST_State o_e8_DST_State;
      if (!bDoIt(o_e8_DST_State))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_TIMEZONEELEMENT:
   {
      if (poVisitor->bDoExpand_TimeZoneElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_DST_TIMEDOMAIN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S32_SECOND,navifi_tclSemanticDomain::EN_DSTDIFFERENCE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_DST_STATE,navifi_tclSemanticDomain::EN_DST_STATE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S32_SECOND,navifi_tclSemanticDomain::EN_TIMEZONEDIFFERENCE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_MULTILANGUAGESTRING,navifi_tclSemanticDomain::EN_ABBREVIATION_DST_IN_EFFECT));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_MULTILANGUAGESTRING,navifi_tclSemanticDomain::EN_ABBREVIATION_STANDARDTIME));
      }
      else
      {
         fi_tcl_TimeZoneElement o_TimeZoneElement;
         if (!bDoIt(o_TimeZoneElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeZoneElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeZoneElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_S16_KMPERHOUR:
   {
      fi_tcl_s16_KmPerHour o_s16_KmPerHour;
      if (!bDoIt(o_s16_KmPerHour))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_S16_CENTIMETERSECOND:
   {
      fi_tcl_s16_CentimeterSecond o_s16_CentimeterSecond;
      if (!bDoIt(o_s16_CentimeterSecond))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_FIVERSION:
   {
      if (poVisitor->bDoExpand_FIVersion(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8,navifi_tclSemanticDomain::EN_PATCHVERSION));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8,navifi_tclSemanticDomain::EN_MINORVERSION));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8,navifi_tclSemanticDomain::EN_MAJORVERSION));
      }
      else
      {
         fi_tcl_FIVersion o_FIVersion;
         if (!bDoIt(o_FIVersion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FIVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FIVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_S32_LONGITUDE:
   {
      fi_tcl_s32_Longitude o_s32_Longitude;
      if (!bDoIt(o_s32_Longitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_S32_LATITUDE:
   {
      fi_tcl_s32_Latitude o_s32_Latitude;
      if (!bDoIt(o_s32_Latitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_POSITIONWGS84:
   {
      if (poVisitor->bDoExpand_PositionWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S32_LATITUDE,navifi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S32_LONGITUDE,navifi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_PositionWGS84 o_PositionWGS84;
         if (!bDoIt(o_PositionWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_E16_ISOCOUNTRYCODE:
   {
      fi_tcl_e16_ISOCountryCode o_e16_ISOCountryCode;
      if (!bDoIt(o_e16_ISOCountryCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_E16_ISOLANGUAGECODE:
   {
      fi_tcl_e16_ISOLanguageCode o_e16_ISOLanguageCode;
      if (!bDoIt(o_e16_ISOLanguageCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_U8_DIRECTIONABSOLUTE:
   {
      fi_tcl_u8_DirectionAbsolute o_u8_DirectionAbsolute;
      if (!bDoIt(o_u8_DirectionAbsolute))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_E8_BINCONTAINERTYPES:
   {
      fi_tcl_e8_BinContainerTypes o_e8_BinContainerTypes;
      if (!bDoIt(o_e8_BinContainerTypes))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_E16_NAVIEVENTVALUE:
   {
      fi_tcl_e16_NaviEventValue o_e16_NaviEventValue;
      if (!bDoIt(o_e16_NaviEventValue))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_E8_TRAFFICMSGTYPE:
   {
      fi_tcl_e8_TrafficMsgType o_e8_TrafficMsgType;
      if (!bDoIt(o_e8_TrafficMsgType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_E8_TMLOCATIONTYPE:
   {
      fi_tcl_e8_TMLocationType o_e8_TMLocationType;
      if (!bDoIt(o_e8_TMLocationType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_E8_EVENTTYPE:
   {
      fi_tcl_e8_EventType o_e8_EventType;
      if (!bDoIt(o_e8_EventType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_E16_EFFECTCODE:
   {
      fi_tcl_e16_EffectCode o_e16_EffectCode;
      if (!bDoIt(o_e16_EffectCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_E16_CAUSECODE:
   {
      fi_tcl_e16_CauseCode o_e16_CauseCode;
      if (!bDoIt(o_e16_CauseCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_E8_TENDENCY:
   {
      fi_tcl_e8_Tendency o_e8_Tendency;
      if (!bDoIt(o_e8_Tendency))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_RDBID:
   {
      if (poVisitor->bDoExpand_RDBId(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_BSA));
         }
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8,navifi_tclSemanticDomain::EN_TABLENO));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8,navifi_tclSemanticDomain::EN_TMCCOUNTRYCODE));
      }
      else
      {
         fi_tcl_RDBId o_RDBId;
         if (!bDoIt(o_RDBId))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RDBId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RDBId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_TMEVENT:
   {
      if (poVisitor->bDoExpand_TMEvent(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8,navifi_tclSemanticDomain::EN_PRIORITY));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S16_CENTIMETERSECOND,navifi_tclSemanticDomain::EN_AVERAGESPEEDCMPERSEC));
         }
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S16_KMPERHOUR,navifi_tclSemanticDomain::EN_AVERAGESPEED));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S16_CENTIMETERSECOND,navifi_tclSemanticDomain::EN_SPEEDLIMITADVICECMPERSEC));
         }
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S16_KMPERHOUR,navifi_tclSemanticDomain::EN_SPEEDLIMITADVICE));
         if (36 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S32_SECOND,navifi_tclSemanticDomain::EN_DELAYINFORMATION));
         }
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S32_METER,navifi_tclSemanticDomain::EN_LENGTHINFORMATION));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_CAUSECODE,navifi_tclSemanticDomain::EN_CAUSE));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_TENDENCY,navifi_tclSemanticDomain::EN_TENDENCY));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_EFFECTCODE,navifi_tclSemanticDomain::EN_EFFECT));
         }
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_NAVIEVENTVALUE,navifi_tclSemanticDomain::EN_NAVIEVENTVALUE));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_EVENTTYPE,navifi_tclSemanticDomain::EN_EVENTTYPE));
         }
      }
      else
      {
         fi_tcl_TMEvent o_TMEvent;
         if (!bDoIt(o_TMEvent))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMEvent.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMEvent.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_B32_TRAFFICMESSAGESOURCE:
   {
      fi_tcl_b32_TrafficMessageSource o_b32_TrafficMessageSource;
      if (!bDoIt(o_b32_TrafficMessageSource))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_B8_TMADDITIONALINFORMATION:
   {
      fi_tcl_b8_TMAdditionalInformation o_b8_TMAdditionalInformation;
      if (!bDoIt(o_b8_TMAdditionalInformation))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_B8_TRAFFICMESSAGESOURCEAVAILABILITY:
   {
      fi_tcl_b8_TrafficMessageSourceAvailability o_b8_TrafficMessageSourceAvailability;
      if (!bDoIt(o_b8_TrafficMessageSourceAvailability))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_TRAFFICMSGMEMORYSTATISTICSPERTYPE:
   {
      if (poVisitor->bDoExpand_TrafficMsgMemoryStatisticsPerType(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_POSIXTIME,navifi_tclSemanticDomain::EN_LATESTRECEPTIONTIME));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_NUMBEROFTRAFFICMSGS));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_TRAFFICMSGTYPE,navifi_tclSemanticDomain::EN_TRAFFICMSGTYPE));
      }
      else
      {
         fi_tcl_TrafficMsgMemoryStatisticsPerType o_TrafficMsgMemoryStatisticsPerType;
         if (!bDoIt(o_TrafficMsgMemoryStatisticsPerType))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficMsgMemoryStatisticsPerType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficMsgMemoryStatisticsPerType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_TRAFFICMSGMEMORYSTATISTICS:
   {
      if (poVisitor->bDoExpand_TrafficMsgMemoryStatistics(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TRAFFICMSGMEMORYSTATISTICSPERTYPE,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_STATISTICSPERTYPE));
         }
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_POSIXTIME,navifi_tclSemanticDomain::EN_LATESTRECEPTIONTIME));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_NUMBEROFTRAFFICMSGS));
      }
      else
      {
         fi_tcl_TrafficMsgMemoryStatistics o_TrafficMsgMemoryStatistics;
         if (!bDoIt(o_TrafficMsgMemoryStatistics))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficMsgMemoryStatistics.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficMsgMemoryStatistics.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_ISORDBIDAVAILABILITY:
   {
      if (poVisitor->bDoExpand_ISORDBIdAvailability(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_B8_TRAFFICMESSAGESOURCEAVAILABILITY,navifi_tclSemanticDomain::EN_AVAILABILITY));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_BOOL,navifi_tclSemanticDomain::EN_CURRENTPOSITIONINSIDE));
         }
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_STRING,navifi_tclSemanticDomain::EN_BSANAME));
         }
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_ISOCOUNTRYCODE,navifi_tclSemanticDomain::EN_ISOCOUNTRYCODE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_RDBID,navifi_tclSemanticDomain::EN_RDBID));
      }
      else
      {
         fi_tcl_ISORDBIdAvailability o_ISORDBIdAvailability;
         if (!bDoIt(o_ISORDBIdAvailability))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ISORDBIdAvailability.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ISORDBIdAvailability.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_E8_TMURGENCY:
   {
      fi_tcl_e8_TMUrgency o_e8_TMUrgency;
      if (!bDoIt(o_e8_TMUrgency))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_TMCODEDMESSAGE:
   {
      if (poVisitor->bDoExpand_TMCodedMessage(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_RDBID,navifi_tclSemanticDomain::EN_RDBID));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMEVENT,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_EVENTS));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_BOOL,navifi_tclSemanticDomain::EN_BIDIRECTIONAL));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_BOOL,navifi_tclSemanticDomain::EN_DIRECTIONAGAINSTTMC));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8,navifi_tclSemanticDomain::EN_EXTENT));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_TMLOCATIONTYPE,navifi_tclSemanticDomain::EN_PRIMARYLOCATIONTYPE));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_SECONDARYLOCATIONCODE));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_PRIMARYLOCATIONCODE));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8,navifi_tclSemanticDomain::EN_AVERAGESPEED));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8,navifi_tclSemanticDomain::EN_SPEEDLIMITADVICE));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8,navifi_tclSemanticDomain::EN_LENGTHINFOANDLABEL2));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8,navifi_tclSemanticDomain::EN_ROADNUMBERSUFFIX));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_ROADNUMBER));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_ROADCLASS));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_NAVIEVENTVALUE,navifi_tclSemanticDomain::EN_ADDITIONALNEV7));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_NAVIEVENTVALUE,navifi_tclSemanticDomain::EN_ADDITIONALNEV6));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_NAVIEVENTVALUE,navifi_tclSemanticDomain::EN_ADDITIONALNEV5));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_NAVIEVENTVALUE,navifi_tclSemanticDomain::EN_ADDITIONALNEV4));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_NAVIEVENTVALUE,navifi_tclSemanticDomain::EN_ADDITIONALNEV3));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_NAVIEVENTVALUE,navifi_tclSemanticDomain::EN_ADDITIONALNEV2));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_NAVIEVENTVALUE,navifi_tclSemanticDomain::EN_ADDITIONALNEV1));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_NAVIEVENTVALUE,navifi_tclSemanticDomain::EN_MAINNEV));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8,navifi_tclSemanticDomain::EN_DIRECTIONALITY));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8,navifi_tclSemanticDomain::EN_DIRANDEXTENT));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8,navifi_tclSemanticDomain::EN_LOCATIONTYPE));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_LOCATION2));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_LOCATION1));
         }
      }
      else
      {
         fi_tcl_TMCodedMessage o_TMCodedMessage;
         if (!bDoIt(o_TMCodedMessage))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMessage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMessage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#ifndef FI_S_EXTERNAL_FI
   case navifi_tclToken::EN_TMCODEDMESSAGEBINCONTAINER:
   {
      if (poVisitor->bDoExpand_TMCodedMessageBinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         bInsideBinContainerVersion = true;
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_BINCONTAINER));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMCODEDMESSAGE,navifi_tclSemanticDomain::EN_TMCODEDMESSAGE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_BINCONTAINERTYPES,navifi_tclSemanticDomain::EN_CONTAINERTYPE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_FIVERSION,navifi_tclSemanticDomain::EN_CONTAINERFIVERSION));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_SERVICEID));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32,navifi_tclSemanticDomain::EN_CONTAINERLENGTH));
      }
      else
      {
         fi_tcl_TMCodedMessageBinContainer o_TMCodedMessageBinContainer;
         if (!bDoIt(o_TMCodedMessageBinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMessageBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMessageBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#endif // FI_S_EXTERNAL_FI
   case navifi_tclToken::EN_TMPROGRAMSERVICE:
   {
      if (poVisitor->bDoExpand_TMProgramService(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_STRING,navifi_tclSemanticDomain::EN_PROGRAMSERVICENAME));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_ISOCOUNTRYCODE,navifi_tclSemanticDomain::EN_COUNTRYCODE));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32,navifi_tclSemanticDomain::EN_EXTENDEDPROGRAMID));
         }
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_PROGRAMID));
      }
      else
      {
         fi_tcl_TMProgramService o_TMProgramService;
         if (!bDoIt(o_TMProgramService))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMProgramService.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMProgramService.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_U32_DATASETID:
   {
      fi_tcl_u32_DataSetId o_u32_DataSetId;
      if (!bDoIt(o_u32_DataSetId))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_U32_MEDIAID:
   {
      fi_tcl_u32_MediaId o_u32_MediaId;
      if (!bDoIt(o_u32_MediaId))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_NAVCLUSTERDESC:
   {
      if (poVisitor->bDoExpand_NavClusterDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_LENGTH));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32,navifi_tclSemanticDomain::EN_FILEOFFSET));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_FILEID));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8,navifi_tclSemanticDomain::EN_LEVEL));
      }
      else
      {
         fi_tcl_NavClusterDesc o_NavClusterDesc;
         if (!bDoIt(o_NavClusterDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_E8_NAVONECELLDIRECTION:
   {
      fi_tcl_e8_NavOneCellDirection o_e8_NavOneCellDirection;
      if (!bDoIt(o_e8_NavOneCellDirection))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_NAVONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16_INDEXINREFERENCELIST,navifi_tclSemanticDomain::EN_INDEXINCLUSTERREFLIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_NAVONECELLDIRECTION,navifi_tclSemanticDomain::EN_USEDIRECTION));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_ONECELLID));
      }
      else
      {
         fi_tcl_NavOneCellDesc o_NavOneCellDesc;
         if (!bDoIt(o_NavOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_E8_SIDEINFO:
   {
      fi_tcl_e8_SideInfo o_e8_SideInfo;
      if (!bDoIt(o_e8_SideInfo))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_S32_EMU:
   {
      fi_tcl_s32_EMU o_s32_EMU;
      if (!bDoIt(o_s32_EMU))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_NAVZEROCELLDESC:
   {
      if (poVisitor->bDoExpand_NavZeroCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16_INDEXINREFERENCELIST,navifi_tclSemanticDomain::EN_INDEXINCLUSTERREFLIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_ZEROCELLID));
      }
      else
      {
         fi_tcl_NavZeroCellDesc o_NavZeroCellDesc;
         if (!bDoIt(o_NavZeroCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavZeroCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavZeroCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_E8_NAVLOCATIONDESCTYPE:
   {
      fi_tcl_e8_NavLocationDescType o_e8_NavLocationDescType;
      if (!bDoIt(o_e8_NavLocationDescType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_NAVLOCATIONDESCUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_NavLocationDescType oDataType;
      oCallStack.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_NAVLOCATIONDESCTYPE,navifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_RESERVED:
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_RESERVED,navifi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
         break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVLOCATIONDATADESC:
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVLOCATIONDATADESC,navifi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
         break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONCIRCLE:
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVAREADESCRIPTIONCIRCLE,navifi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
         break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONPOLYGON:
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVAREADESCRIPTIONPOLYGON,navifi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
         break;
      }
   } break;
   case navifi_tclToken::EN_NAVLOCATIONDESC:
   {
      if (poVisitor->bDoExpand_NavLocationDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVLOCATIONDESCUNION0,navifi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
      }
      else
      {
         fi_tcl_NavLocationDesc o_NavLocationDesc;
         if (!bDoIt(o_NavLocationDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#ifndef FI_S_EXTERNAL_FI
   case navifi_tclToken::EN_NAVLOCATIONBINCONTAINER:
   {
      if (poVisitor->bDoExpand_NavLocationBinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         bInsideBinContainerVersion = true;
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_BINCONTAINER));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVLOCATIONDESC,navifi_tclSemanticDomain::EN_CONTAINERDATA));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_BINCONTAINERTYPES,navifi_tclSemanticDomain::EN_CONTAINERTYPE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_FIVERSION,navifi_tclSemanticDomain::EN_CONTAINERFIVERSION));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_SERVICEID));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32,navifi_tclSemanticDomain::EN_CONTAINERLENGTH));
      }
      else
      {
         fi_tcl_NavLocationBinContainer o_NavLocationBinContainer;
         if (!bDoIt(o_NavLocationBinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#endif // FI_S_EXTERNAL_FI
   case navifi_tclToken::EN_E8_NAVINDEXZFDESTINATIONTYPE:
   {
      fi_tcl_e8_NavIndexZFDestinationType o_e8_NavIndexZFDestinationType;
      if (!bDoIt(o_e8_NavIndexZFDestinationType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_E8_NAVLOCATIONNAVDATATYPE:
   {
      fi_tcl_e8_NavLocationNavDataType o_e8_NavLocationNavDataType;
      if (!bDoIt(o_e8_NavLocationNavDataType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_NAVLOCATIONDATADESCUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_NavLocationNavDataType oDataType;
      oCallStack.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_NAVLOCATIONNAVDATATYPE,navifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_RESERVED:
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_RESERVED,navifi_tclSemanticDomain::EN_NAVDATATYPE));
         break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET,navifi_tclSemanticDomain::EN_NAVDATATYPE));
         break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSTREETDESTINATIONONECELLLISTSET:
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVSTREETDESTINATIONONECELLLISTSET,navifi_tclSemanticDomain::EN_NAVDATATYPE));
         break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSPOTDESTINATIONONECELLLISTSET:
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVSPOTDESTINATIONONECELLLISTSET,navifi_tclSemanticDomain::EN_NAVDATATYPE));
         break;
      }
   } break;
   case navifi_tclToken::EN_NAVLOCATIONDATADESC:
   {
      if (poVisitor->bDoExpand_NavLocationDataDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVLOCATIONDATADESCUNION0,navifi_tclSemanticDomain::EN_NAVDATATYPE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_POSITIONWGS84,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_ACCESSPOINTREFLIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_POSITIONWGS84,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_OBJECTPOINTREFLIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_NAVINDEXZFDESTINATIONTYPE,navifi_tclSemanticDomain::EN_INDEXZFDESTTYPE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32_DATASETID,navifi_tclSemanticDomain::EN_NAVDATASETID));
      }
      else
      {
         fi_tcl_NavLocationDataDesc o_NavLocationDataDesc;
         if (!bDoIt(o_NavLocationDataDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationDataDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationDataDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_NAVSPOTDESTINATIONONECELLPROPERTY:
   {
      if (poVisitor->bDoExpand_NavSpotDestinationOneCellProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16_INDEXINREFERENCELIST,navifi_tclSemanticDomain::EN_INDEXINACCESSPOINTREFLIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16_INDEXINREFERENCELIST,navifi_tclSemanticDomain::EN_INDEXINOBJECTPOINTREFLIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_POSITIONWGS84,navifi_tclSemanticDomain::EN_DECISIONPOINT));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S32_EMU,navifi_tclSemanticDomain::EN_DESTDISTANCE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S32_EMU,navifi_tclSemanticDomain::EN_ONECELLLENGTH));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S32_EMU,navifi_tclSemanticDomain::EN_FROMZEROCELLTOSPOTLENGTH));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_SIDEINFO,navifi_tclSemanticDomain::EN_SIDEINFO));
      }
      else
      {
         fi_tcl_NavSpotDestinationOneCellProperty o_NavSpotDestinationOneCellProperty;
         if (!bDoIt(o_NavSpotDestinationOneCellProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_NAVSPOTDESTINATIONONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavSpotDestinationOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVSPOTDESTINATIONONECELLPROPERTY,navifi_tclSemanticDomain::EN_ONECELLPROPERTY));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVONECELLDESC,navifi_tclSemanticDomain::EN_ONECELLDESC));
      }
      else
      {
         fi_tcl_NavSpotDestinationOneCellDesc o_NavSpotDestinationOneCellDesc;
         if (!bDoIt(o_NavSpotDestinationOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_NAVSPOTDESTINATIONONECELLLISTSET:
   {
      if (poVisitor->bDoExpand_NavSpotDestinationOneCellListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVSPOTDESTINATIONONECELLDESC,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_SPOTDESTINATIONONECELLREFLIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVCLUSTERDESC,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_CLUSTERREFLIST));
      }
      else
      {
         fi_tcl_NavSpotDestinationOneCellListSet o_NavSpotDestinationOneCellListSet;
         if (!bDoIt(o_NavSpotDestinationOneCellListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_NAVSTREETDESTINATIONONECELLPROPERTY:
   {
      if (poVisitor->bDoExpand_NavStreetDestinationOneCellProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16_INDEXINREFERENCELIST,navifi_tclSemanticDomain::EN_INDEXINACCESSPOINTREFLIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16_INDEXINREFERENCELIST,navifi_tclSemanticDomain::EN_INDEXINOBJECTPOINTREFLIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_SIDEINFO,navifi_tclSemanticDomain::EN_SIDEINFO));
      }
      else
      {
         fi_tcl_NavStreetDestinationOneCellProperty o_NavStreetDestinationOneCellProperty;
         if (!bDoIt(o_NavStreetDestinationOneCellProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_NAVSTREETDESTINATIONONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavStreetDestinationOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVSTREETDESTINATIONONECELLPROPERTY,navifi_tclSemanticDomain::EN_ONECELLPROPERTY));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVONECELLDESC,navifi_tclSemanticDomain::EN_ONECELLDESC));
      }
      else
      {
         fi_tcl_NavStreetDestinationOneCellDesc o_NavStreetDestinationOneCellDesc;
         if (!bDoIt(o_NavStreetDestinationOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_NAVSTREETDESTINATIONONECELLLISTSET:
   {
      if (poVisitor->bDoExpand_NavStreetDestinationOneCellListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVSTREETDESTINATIONONECELLDESC,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_STREETDESTINATIONONECELLREFLIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVCLUSTERDESC,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_CLUSTERREFLIST));
      }
      else
      {
         fi_tcl_NavStreetDestinationOneCellListSet o_NavStreetDestinationOneCellListSet;
         if (!bDoIt(o_NavStreetDestinationOneCellListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_E8_NAVINTERSECTIONTYPE:
   {
      fi_tcl_e8_NavIntersectionType o_e8_NavIntersectionType;
      if (!bDoIt(o_e8_NavIntersectionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLPROPERTY:
   {
      if (poVisitor->bDoExpand_NavIntersectionDestinationZeroCellProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16_INDEXINREFERENCELIST,navifi_tclSemanticDomain::EN_INDEXINACCESSPOINTREFLIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16_INDEXINREFERENCELIST,navifi_tclSemanticDomain::EN_INDEXINOBJECTPOINTREFLIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_NAVINTERSECTIONTYPE,navifi_tclSemanticDomain::EN_INTERSECTIONTYPE));
      }
      else
      {
         fi_tcl_NavIntersectionDestinationZeroCellProperty o_NavIntersectionDestinationZeroCellProperty;
         if (!bDoIt(o_NavIntersectionDestinationZeroCellProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLDESC:
   {
      if (poVisitor->bDoExpand_NavIntersectionDestinationZeroCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLPROPERTY,navifi_tclSemanticDomain::EN_ZEROCELLPROPERTY));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVZEROCELLDESC,navifi_tclSemanticDomain::EN_ZEROCELLDESC));
      }
      else
      {
         fi_tcl_NavIntersectionDestinationZeroCellDesc o_NavIntersectionDestinationZeroCellDesc;
         if (!bDoIt(o_NavIntersectionDestinationZeroCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
   {
      if (poVisitor->bDoExpand_NavIntersectionDestinationZeroCellListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLDESC,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_INTERSECTIONDESTINATIONZEROCELLREFLIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVCLUSTERDESC,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_CLUSTERREFLIST));
      }
      else
      {
         fi_tcl_NavIntersectionDestinationZeroCellListSet o_NavIntersectionDestinationZeroCellListSet;
         if (!bDoIt(o_NavIntersectionDestinationZeroCellListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_NAVAREADESCRIPTIONCIRCLE:
   {
      if (poVisitor->bDoExpand_NavAreaDescriptionCircle(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_POSITIONWGS84,navifi_tclSemanticDomain::EN_COORDINATE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S32_METER,navifi_tclSemanticDomain::EN_RADIUS));
      }
      else
      {
         fi_tcl_NavAreaDescriptionCircle o_NavAreaDescriptionCircle;
         if (!bDoIt(o_NavAreaDescriptionCircle))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAreaDescriptionCircle.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAreaDescriptionCircle.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_NAVAREADESCRIPTIONPOLYGON:
   {
      if (poVisitor->bDoExpand_NavAreaDescriptionPolygon(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_POSITIONWGS84,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_COORDINATELIST));
      }
      else
      {
         fi_tcl_NavAreaDescriptionPolygon o_NavAreaDescriptionPolygon;
         if (!bDoIt(o_NavAreaDescriptionPolygon))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAreaDescriptionPolygon.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAreaDescriptionPolygon.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_NAVDLDCHAINONECELLPROPERTY:
   {
      if (poVisitor->bDoExpand_NavDLDChainOneCellProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S32_METER,navifi_tclSemanticDomain::EN_TURNLENGTHONFOLLOWINGINTERSECTION));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S32_METER,navifi_tclSemanticDomain::EN_LENGTHFROMFIRSTOC));
      }
      else
      {
         fi_tcl_NavDLDChainOneCellProperty o_NavDLDChainOneCellProperty;
         if (!bDoIt(o_NavDLDChainOneCellProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavDLDChainOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavDLDChainOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_NAVDLDCHAINONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavDLDChainOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVDLDCHAINONECELLPROPERTY,navifi_tclSemanticDomain::EN_ONECELLPROPERTY));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVONECELLDESC,navifi_tclSemanticDomain::EN_ONECELLDESC));
      }
      else
      {
         fi_tcl_NavDLDChainOneCellDesc o_NavDLDChainOneCellDesc;
         if (!bDoIt(o_NavDLDChainOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavDLDChainOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavDLDChainOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_NAVDLDCHAINONECELLLISTSET:
   {
      if (poVisitor->bDoExpand_NavDLDChainOneCellListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVDLDCHAINONECELLDESC,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_ONECELLREFLIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVCLUSTERDESC,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_CLUSTERREFLIST));
      }
      else
      {
         fi_tcl_NavDLDChainOneCellListSet o_NavDLDChainOneCellListSet;
         if (!bDoIt(o_NavDLDChainOneCellListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavDLDChainOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavDLDChainOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#ifndef FI_S_EXTERNAL_FI
   case navifi_tclToken::EN_NAVUTMBINCONTAINER:
   {
      if (poVisitor->bDoExpand_NavUTMBinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         bInsideBinContainerVersion = true;
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_BINCONTAINER));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVDLDCHAINONECELLLISTSET,navifi_tclSemanticDomain::EN_UTMONECELLLISTSET));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32_DATASETID,navifi_tclSemanticDomain::EN_NAVDATASETID));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_BINCONTAINERTYPES,navifi_tclSemanticDomain::EN_CONTAINERTYPE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_FIVERSION,navifi_tclSemanticDomain::EN_CONTAINERFIVERSION));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_SERVICEID));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32,navifi_tclSemanticDomain::EN_CONTAINERLENGTH));
      }
      else
      {
         fi_tcl_NavUTMBinContainer o_NavUTMBinContainer;
         if (!bDoIt(o_NavUTMBinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavUTMBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavUTMBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#endif // FI_S_EXTERNAL_FI
   case navifi_tclToken::EN_U16_USERTRAFFICMESSAGEHANDLE:
   {
      fi_tcl_u16_UserTrafficMessageHandle o_u16_UserTrafficMessageHandle;
      if (!bDoIt(o_u16_UserTrafficMessageHandle))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_UTMHANDLECONTAINER:
   {
      if (poVisitor->bDoExpand_UTMHandleContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16_ERRORCODE,navifi_tclSemanticDomain::EN_ERRORCODE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S32_METER,navifi_tclSemanticDomain::EN_OUTCOMINGCLOSINGLENGTH));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16_USERTRAFFICMESSAGEHANDLE,navifi_tclSemanticDomain::EN_UTMHANDLE));
      }
      else
      {
         fi_tcl_UTMHandleContainer o_UTMHandleContainer;
         if (!bDoIt(o_UTMHandleContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTMHandleContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTMHandleContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_B8_TRAFFICMESSAGECONTENT:
   {
      fi_tcl_b8_TrafficMessageContent o_b8_TrafficMessageContent;
      if (!bDoIt(o_b8_TrafficMessageContent))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_E8_TMGEOMETRICMESSAGETYPE:
   {
      fi_tcl_e8_TMGeometricMessageType o_e8_TMGeometricMessageType;
      if (!bDoIt(o_e8_TMGeometricMessageType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_TMCODEDTEXTREFERENCE:
   {
      if (poVisitor->bDoExpand_TMCodedTextReference(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_BINCONTAINER,navifi_tclSemanticDomain::EN_TMCODEDTEXTMESSAGE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16_INDEXINREFERENCELIST,navifi_tclSemanticDomain::EN_INDEXINBASELIST));
      }
      else
      {
         fi_tcl_TMCodedTextReference o_TMCodedTextReference;
         if (!bDoIt(o_TMCodedTextReference))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedTextReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedTextReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_E8_TMAFFECTIONTYPE:
   {
      fi_tcl_e8_TMAffectionType o_e8_TMAffectionType;
      if (!bDoIt(o_e8_TMAffectionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_TRAFFICSENSE:
   {
      if (poVisitor->bDoExpand_TrafficSense(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_SIDEINFO,navifi_tclSemanticDomain::EN_TRAFFICSENSE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_ISOCOUNTRYCODE,navifi_tclSemanticDomain::EN_COUNTRYCODE));
      }
      else
      {
         fi_tcl_TrafficSense o_TrafficSense;
         if (!bDoIt(o_TrafficSense))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficSense.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficSense.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_TRAFFICSENSELIST:
   {
      if (poVisitor->bDoExpand_TrafficSenseList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TRAFFICSENSE,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_TRAFFICSENSELIST));
      }
      else
      {
         fi_tcl_TrafficSenseList o_TrafficSenseList;
         if (!bDoIt(o_TrafficSenseList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficSenseList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficSenseList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_E8_ROADCLASSCODE:
   {
      fi_tcl_e8_RoadClassCode o_e8_RoadClassCode;
      if (!bDoIt(o_e8_RoadClassCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_E8_ROADTYPEDESC:
   {
      fi_tcl_e8_RoadTypeDesc o_e8_RoadTypeDesc;
      if (!bDoIt(o_e8_RoadTypeDesc))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_SPEEDFACTOR:
   {
      if (poVisitor->bDoExpand_SpeedFactor(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S16_CENTIMETERSECOND,navifi_tclSemanticDomain::EN_SPEEDVALUE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_ROADCLASSCODE,navifi_tclSemanticDomain::EN_ROADCLASS));
      }
      else
      {
         fi_tcl_SpeedFactor o_SpeedFactor;
         if (!bDoIt(o_SpeedFactor))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SpeedFactor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SpeedFactor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_SPEEDFACTORROADAREATYPE:
   {
      if (poVisitor->bDoExpand_SpeedFactorRoadAreaType(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_SPEEDFACTOR,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_SPEEDFACTOR));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_ROADTYPEDESC,navifi_tclSemanticDomain::EN_ROADTYPEDESCRIPTION));
      }
      else
      {
         fi_tcl_SpeedFactorRoadAreaType o_SpeedFactorRoadAreaType;
         if (!bDoIt(o_SpeedFactorRoadAreaType))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SpeedFactorRoadAreaType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SpeedFactorRoadAreaType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_SPEEDFACTORSCOUNTRY:
   {
      if (poVisitor->bDoExpand_SpeedFactorsCountry(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S32_MILLISECOND,navifi_tclSemanticDomain::EN_TIMEOFFSETONLONGRAMP));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S32_SECOND,navifi_tclSemanticDomain::EN_TIMEOFFSETTOHIGHWAY));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_SPEEDFACTORROADAREATYPE,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_SPEEDFACTORSROADAREATYPELIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_ISOCOUNTRYCODE,navifi_tclSemanticDomain::EN_COUNTRYCODE));
      }
      else
      {
         fi_tcl_SpeedFactorsCountry o_SpeedFactorsCountry;
         if (!bDoIt(o_SpeedFactorsCountry))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SpeedFactorsCountry.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SpeedFactorsCountry.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_B8_SPEEDLIMITSTATUS:
   {
      fi_tcl_b8_SpeedLimitStatus o_b8_SpeedLimitStatus;
      if (!bDoIt(o_b8_SpeedLimitStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_E8_SPEEDUNIT:
   {
      fi_tcl_e8_SpeedUnit o_e8_SpeedUnit;
      if (!bDoIt(o_e8_SpeedUnit))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_E8_SPEEDTYPE:
   {
      fi_tcl_e8_SpeedType o_e8_SpeedType;
      if (!bDoIt(o_e8_SpeedType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_SPEEDLIMITSTATUS:
   {
      if (poVisitor->bDoExpand_SpeedLimitStatus(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_B8_SPEEDLIMITSTATUS,navifi_tclSemanticDomain::EN_STATUS));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_SPEEDTYPE,navifi_tclSemanticDomain::EN_SPEEDTYPE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_SPEEDUNIT,navifi_tclSemanticDomain::EN_SPEEDUNIT));
      }
      else
      {
         fi_tcl_SpeedLimitStatus o_SpeedLimitStatus;
         if (!bDoIt(o_SpeedLimitStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SpeedLimitStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SpeedLimitStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_SPEEDLIMIT:
   {
      if (poVisitor->bDoExpand_SpeedLimit(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_SPEEDLIMITSTATUS,navifi_tclSemanticDomain::EN_STATUS));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8,navifi_tclSemanticDomain::EN_SPEEDVALUE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_ROADCLASSCODE,navifi_tclSemanticDomain::EN_ROADCLASS));
      }
      else
      {
         fi_tcl_SpeedLimit o_SpeedLimit;
         if (!bDoIt(o_SpeedLimit))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SpeedLimit.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SpeedLimit.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_SPEEDLIMITROADAREATYPE:
   {
      if (poVisitor->bDoExpand_SpeedLimitRoadAreaType(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_SPEEDLIMIT,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_SPEEDLIMITROADCLASSLIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_ROADTYPEDESC,navifi_tclSemanticDomain::EN_ROADTYPEDESCRIPTION));
      }
      else
      {
         fi_tcl_SpeedLimitRoadAreaType o_SpeedLimitRoadAreaType;
         if (!bDoIt(o_SpeedLimitRoadAreaType))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SpeedLimitRoadAreaType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SpeedLimitRoadAreaType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_SPEEDLIMITSCOUNTRY:
   {
      if (poVisitor->bDoExpand_SpeedLimitsCountry(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_SPEEDLIMITROADAREATYPE,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_SPEEDLIMITSROADAREATYPELIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_ISOCOUNTRYCODE,navifi_tclSemanticDomain::EN_COUNTRYCODE));
      }
      else
      {
         fi_tcl_SpeedLimitsCountry o_SpeedLimitsCountry;
         if (!bDoIt(o_SpeedLimitsCountry))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SpeedLimitsCountry.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SpeedLimitsCountry.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_SPEEDLIMITSLIST:
   {
      if (poVisitor->bDoExpand_SpeedLimitsList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_SPEEDLIMITSCOUNTRY,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_SPEEDLIMITSCOUNTRYLIST));
      }
      else
      {
         fi_tcl_SpeedLimitsList o_SpeedLimitsList;
         if (!bDoIt(o_SpeedLimitsList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SpeedLimitsList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SpeedLimitsList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_PREFIXDESC:
   {
      if (poVisitor->bDoExpand_PrefixDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_STRING,navifi_tclSemanticDomain::EN_PREFIX));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_MODE));
      }
      else
      {
         fi_tcl_PrefixDesc o_PrefixDesc;
         if (!bDoIt(o_PrefixDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PrefixDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PrefixDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_PREFIXSTATE:
   {
      if (poVisitor->bDoExpand_PrefixState(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_PREFIXDESC,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_PREFIXDESCLIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_ISOCOUNTRYCODE,navifi_tclSemanticDomain::EN_COUNTRYCODE));
      }
      else
      {
         fi_tcl_PrefixState o_PrefixState;
         if (!bDoIt(o_PrefixState))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PrefixState.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PrefixState.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_PREFIXSTATELIST:
   {
      if (poVisitor->bDoExpand_PrefixStateList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_PREFIXSTATE,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_PREFIXSTATELIST));
      }
      else
      {
         fi_tcl_PrefixStateList o_PrefixStateList;
         if (!bDoIt(o_PrefixStateList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PrefixStateList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PrefixStateList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_E8_LANGUAGECAT:
   {
      fi_tcl_e8_LanguageCat o_e8_LanguageCat;
      if (!bDoIt(o_e8_LanguageCat))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_LANGUAGECATEGORY:
   {
      if (poVisitor->bDoExpand_LanguageCategory(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_STRING,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_WORD));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_LANGUAGECAT,navifi_tclSemanticDomain::EN_LANGUAGECAT));
      }
      else
      {
         fi_tcl_LanguageCategory o_LanguageCategory;
         if (!bDoIt(o_LanguageCategory))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LanguageCategory.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LanguageCategory.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_LANGUAGEDESC:
   {
      if (poVisitor->bDoExpand_LanguageDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LANGUAGECATEGORY,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_LANGUAGECATEGORYLIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_ISOLANGUAGECODE,navifi_tclSemanticDomain::EN_LANGUAGEID));
      }
      else
      {
         fi_tcl_LanguageDesc o_LanguageDesc;
         if (!bDoIt(o_LanguageDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LanguageDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LanguageDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_LANGUAGEDESCLIST:
   {
      if (poVisitor->bDoExpand_LanguageDescList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LANGUAGEDESC,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_LANGUAGEDESCLIST));
      }
      else
      {
         fi_tcl_LanguageDescList o_LanguageDescList;
         if (!bDoIt(o_LanguageDescList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LanguageDescList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LanguageDescList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_E8_GLOBALANNOTATIONCATEGORY:
   {
      fi_tcl_e8_GlobalAnnotationCategory o_e8_GlobalAnnotationCategory;
      if (!bDoIt(o_e8_GlobalAnnotationCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_GLOBALANNOTATIONTABLESUNIONUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_GlobalAnnotationCategory oDataType;
      oCallStack.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_GLOBALANNOTATIONCATEGORY,navifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_RESERVED:
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_RESERVED,navifi_tclSemanticDomain::EN_GLOBALANNOTATIONUNION));
         break;
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_TRAFFICSENSELIST:
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TRAFFICSENSELIST,navifi_tclSemanticDomain::EN_GLOBALANNOTATIONUNION));
         break;
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_SPEEDFACTORSLIST:
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_SPEEDFACTORSLIST,navifi_tclSemanticDomain::EN_GLOBALANNOTATIONUNION));
         break;
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_SPEEDLIMITSLIST:
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_SPEEDLIMITSLIST,navifi_tclSemanticDomain::EN_GLOBALANNOTATIONUNION));
         break;
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_REQUIREDPERMISSIONLIST:
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_REQUIREDPERMISSIONLIST,navifi_tclSemanticDomain::EN_GLOBALANNOTATIONUNION));
         break;
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_PREFIXSTATELIST:
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_PREFIXSTATELIST,navifi_tclSemanticDomain::EN_GLOBALANNOTATIONUNION));
         break;
      case fi_tcl_e8_GlobalAnnotationCategory::FI_EN_T_LANGUAGEDESCLIST:
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LANGUAGEDESCLIST,navifi_tclSemanticDomain::EN_GLOBALANNOTATIONUNION));
         break;
      }
   } break;
   case navifi_tclToken::EN_GLOBALANNOTATIONTABLESUNION:
   {
      if (poVisitor->bDoExpand_GlobalAnnotationTablesUnion(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_GLOBALANNOTATIONTABLESUNIONUNION0,navifi_tclSemanticDomain::EN_GLOBALANNOTATIONUNION));
      }
      else
      {
         fi_tcl_GlobalAnnotationTablesUnion o_GlobalAnnotationTablesUnion;
         if (!bDoIt(o_GlobalAnnotationTablesUnion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GlobalAnnotationTablesUnion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GlobalAnnotationTablesUnion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_TIMEZONENAME:
   {
      if (poVisitor->bDoExpand_TimeZoneName(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_MULTILANGUAGESTRING,navifi_tclSemanticDomain::EN_DSTNAME));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_MULTILANGUAGESTRING,navifi_tclSemanticDomain::EN_NORMALNAME));
      }
      else
      {
         fi_tcl_TimeZoneName o_TimeZoneName;
         if (!bDoIt(o_TimeZoneName))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeZoneName.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeZoneName.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_B16_UPOI_SOURCE:
   {
      fi_tcl_b16_UPOI_Source o_b16_UPOI_Source;
      if (!bDoIt(o_b16_UPOI_Source))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_E8_TMHANDLING:
   {
      fi_tcl_e8_TMHandling o_e8_TMHandling;
      if (!bDoIt(o_e8_TMHandling))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_E8_TMDIRECTIONINTERPRETATION:
   {
      fi_tcl_e8_TMDirectionInterpretation o_e8_TMDirectionInterpretation;
      if (!bDoIt(o_e8_TMDirectionInterpretation))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_B8_TMINTERSECTIONPATH:
   {
      fi_tcl_b8_TMIntersectionPath o_b8_TMIntersectionPath;
      if (!bDoIt(o_b8_TMIntersectionPath))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_TMPARAMAMBIGUOUSCLOSING:
   {
      if (poVisitor->bDoExpand_TMParamAmbiguousClosing(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_B8_TMINTERSECTIONPATH,navifi_tclSemanticDomain::EN_CLOSEDPATH));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_TMDIRECTIONINTERPRETATION,navifi_tclSemanticDomain::EN_DIRECTION));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_TMHANDLING,navifi_tclSemanticDomain::EN_HANDLING));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_BOOL,navifi_tclSemanticDomain::EN_USEDEFAULT));
      }
      else
      {
         fi_tcl_TMParamAmbiguousClosing o_TMParamAmbiguousClosing;
         if (!bDoIt(o_TMParamAmbiguousClosing))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMParamAmbiguousClosing.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMParamAmbiguousClosing.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_TMPARAMAMBIGUOUSDYNAMICDISRUPTION:
   {
      if (poVisitor->bDoExpand_TMParamAmbiguousDynamicDisruption(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_TMDIRECTIONINTERPRETATION,navifi_tclSemanticDomain::EN_DIRECTION));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_TMHANDLING,navifi_tclSemanticDomain::EN_HANDLING));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_BOOL,navifi_tclSemanticDomain::EN_USEDEFAULT));
      }
      else
      {
         fi_tcl_TMParamAmbiguousDynamicDisruption o_TMParamAmbiguousDynamicDisruption;
         if (!bDoIt(o_TMParamAmbiguousDynamicDisruption))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMParamAmbiguousDynamicDisruption.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMParamAmbiguousDynamicDisruption.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_TMPARAMAMBIGUOUSAREA:
   {
      if (poVisitor->bDoExpand_TMParamAmbiguousArea(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_TMHANDLING,navifi_tclSemanticDomain::EN_HANDLING));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_BOOL,navifi_tclSemanticDomain::EN_USEDEFAULT));
      }
      else
      {
         fi_tcl_TMParamAmbiguousArea o_TMParamAmbiguousArea;
         if (!bDoIt(o_TMParamAmbiguousArea))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMParamAmbiguousArea.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMParamAmbiguousArea.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_E8_SHAPETYPE:
   {
      fi_tcl_e8_ShapeType o_e8_ShapeType;
      if (!bDoIt(o_e8_ShapeType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_SHAPE:
   {
      if (poVisitor->bDoExpand_Shape(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_POSITIONWGS84,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_SHAPEPOINTS));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_SHAPETYPE,navifi_tclSemanticDomain::EN_SHAPETYPE));
      }
      else
      {
         fi_tcl_Shape o_Shape;
         if (!bDoIt(o_Shape))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Shape.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Shape.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_EXTENDEDLOCATION:
   {
      if (poVisitor->bDoExpand_ExtendedLocation(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8,navifi_tclSemanticDomain::EN_DIRANDEXTEND));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_PRIMARYLOCATION));
      }
      else
      {
         fi_tcl_ExtendedLocation o_ExtendedLocation;
         if (!bDoIt(o_ExtendedLocation))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ExtendedLocation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ExtendedLocation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_COUNTRYLOCATIONLIST:
   {
      if (poVisitor->bDoExpand_CountryLocationList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_EXTENDEDLOCATION,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_LOCATIONCODELIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_RDBID,navifi_tclSemanticDomain::EN_RDBID));
      }
      else
      {
         fi_tcl_CountryLocationList o_CountryLocationList;
         if (!bDoIt(o_CountryLocationList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryLocationList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryLocationList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_TMSERVICEPROVIDER:
   {
      if (poVisitor->bDoExpand_TMServiceProvider(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_STRING,navifi_tclSemanticDomain::EN_SERVICEPROVIDERNAME));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_ISOCOUNTRYCODE,navifi_tclSemanticDomain::EN_COUNTRYCODE));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32,navifi_tclSemanticDomain::EN_EXTENDEDSERVICEID));
         }
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8,navifi_tclSemanticDomain::EN_SERVICEID));
      }
      else
      {
         fi_tcl_TMServiceProvider o_TMServiceProvider;
         if (!bDoIt(o_TMServiceProvider))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMServiceProvider.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMServiceProvider.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_E8_TMCATEGORY:
   {
      fi_tcl_e8_TMCategory o_e8_TMCategory;
      if (!bDoIt(o_e8_TMCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_E8_TMFLOWIMPACT:
   {
      fi_tcl_e8_TMFlowImpact o_e8_TMFlowImpact;
      if (!bDoIt(o_e8_TMFlowImpact))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_B8_TMMAPPINGPOSSIBILITY:
   {
      fi_tcl_b8_TMMappingPossibility o_b8_TMMappingPossibility;
      if (!bDoIt(o_b8_TMMappingPossibility))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_B8_TMMAPPINGSTATUS:
   {
      fi_tcl_b8_TMMappingStatus o_b8_TMMappingStatus;
      if (!bDoIt(o_b8_TMMappingStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_B8_TMONECELLATTRIBUTE:
   {
      fi_tcl_b8_TMOneCellAttribute o_b8_TMOneCellAttribute;
      if (!bDoIt(o_b8_TMOneCellAttribute))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_TMONECELLPORTION:
   {
      if (poVisitor->bDoExpand_TMOneCellPortion(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8_PERCENT,navifi_tclSemanticDomain::EN_LENGTH));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8_PERCENT,navifi_tclSemanticDomain::EN_OFFSET));
      }
      else
      {
         fi_tcl_TMOneCellPortion o_TMOneCellPortion;
         if (!bDoIt(o_TMOneCellPortion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMOneCellPortion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMOneCellPortion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_TMONECELLDESC:
   {
      if (poVisitor->bDoExpand_TMOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_TMAFFECTIONTYPE,navifi_tclSemanticDomain::EN_AFFECTIONTYPE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMONECELLPORTION,navifi_tclSemanticDomain::EN_PORTION));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_B8_TMONECELLATTRIBUTE,navifi_tclSemanticDomain::EN_TMATTRIBUTES));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVONECELLDESC,navifi_tclSemanticDomain::EN_NAVONECELL));
      }
      else
      {
         fi_tcl_TMOneCellDesc o_TMOneCellDesc;
         if (!bDoIt(o_TMOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_E8_TMVALUESTATUS:
   {
      fi_tcl_e8_TMValueStatus o_e8_TMValueStatus;
      if (!bDoIt(o_e8_TMValueStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_TMCSTRUCTUREDTEXT:
   {
      if (poVisitor->bDoExpand_TMCStructuredText(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_STRING,navifi_tclSemanticDomain::EN_LONGSUFFIX));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_STRING,navifi_tclSemanticDomain::EN_SHORTSUFFIX));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_STRING,navifi_tclSemanticDomain::EN_LONGBODY));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_STRING,navifi_tclSemanticDomain::EN_SHORTBODY));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_STRING,navifi_tclSemanticDomain::EN_LONGPREFIX));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_STRING,navifi_tclSemanticDomain::EN_SHORTPREFIX));
      }
      else
      {
         fi_tcl_TMCStructuredText o_TMCStructuredText;
         if (!bDoIt(o_TMCStructuredText))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCStructuredText.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCStructuredText.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_TMCATEGORYSTATISTICS:
   {
      if (poVisitor->bDoExpand_TMCategoryStatistics(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_BOOL,navifi_tclSemanticDomain::EN_CHANGED));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_COUNT));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_TMCATEGORY,navifi_tclSemanticDomain::EN_TYPE));
      }
      else
      {
         fi_tcl_TMCategoryStatistics o_TMCategoryStatistics;
         if (!bDoIt(o_TMCategoryStatistics))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCategoryStatistics.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCategoryStatistics.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_TMFLOWIMPACTSTATISTICS:
   {
      if (poVisitor->bDoExpand_TMFlowImpactStatistics(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_BOOL,navifi_tclSemanticDomain::EN_CHANGED));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_COUNT));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_TMFLOWIMPACT,navifi_tclSemanticDomain::EN_TYPE));
      }
      else
      {
         fi_tcl_TMFlowImpactStatistics o_TMFlowImpactStatistics;
         if (!bDoIt(o_TMFlowImpactStatistics))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMFlowImpactStatistics.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMFlowImpactStatistics.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_TMURGENCYSTATISTICS:
   {
      if (poVisitor->bDoExpand_TMUrgencyStatistics(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_BOOL,navifi_tclSemanticDomain::EN_CHANGED));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_COUNT));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_TMURGENCY,navifi_tclSemanticDomain::EN_TYPE));
      }
      else
      {
         fi_tcl_TMUrgencyStatistics o_TMUrgencyStatistics;
         if (!bDoIt(o_TMUrgencyStatistics))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMUrgencyStatistics.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMUrgencyStatistics.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_UTMSTATISTICS:
   {
      if (poVisitor->bDoExpand_UTMStatistics(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_BOOL,navifi_tclSemanticDomain::EN_CHANGED));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_COUNT));
      }
      else
      {
         fi_tcl_UTMStatistics o_UTMStatistics;
         if (!bDoIt(o_UTMStatistics))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTMStatistics.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTMStatistics.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_TMSTATISTICS:
   {
      if (poVisitor->bDoExpand_TMStatistics(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_UTMSTATISTICS,navifi_tclSemanticDomain::EN_UTMSTATISTICS));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMFLOWIMPACTSTATISTICS,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_TMFLOWIMPACTSTATISTICS));
         }
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMCATEGORYSTATISTICS,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_TMCATEGORYSTATISTICS));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMURGENCYSTATISTICS,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_TMURGENCYSTATISTICS));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_B8_TMADDITIONALINFORMATION,navifi_tclSemanticDomain::EN_ADDITIONALINFORMATION));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_TMCOUNT));
      }
      else
      {
         fi_tcl_TMStatistics o_TMStatistics;
         if (!bDoIt(o_TMStatistics))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMStatistics.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMStatistics.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_E8_TMGEOGRAPHICALPATHRELATIONTYPE:
   {
      fi_tcl_e8_TMGeographicalPathRelationType o_e8_TMGeographicalPathRelationType;
      if (!bDoIt(o_e8_TMGeographicalPathRelationType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_B8_TMRELEVANCE:
   {
      fi_tcl_b8_TMRelevance o_b8_TMRelevance;
      if (!bDoIt(o_b8_TMRelevance))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_B8_ROADNUMBERSTATUS:
   {
      fi_tcl_b8_RoadNumberStatus o_b8_RoadNumberStatus;
      if (!bDoIt(o_b8_RoadNumberStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_COMPASSDIRECTION:
   {
      if (poVisitor->bDoExpand_CompassDirection(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_MULTILANGUAGESTRING,navifi_tclSemanticDomain::EN_DIRECTIONDESC));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8_DIRECTIONABSOLUTE,navifi_tclSemanticDomain::EN_DIRECTION));
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_BOOL,navifi_tclSemanticDomain::EN_DIRECTIONISVALID));
         }
      }
      else
      {
         fi_tcl_CompassDirection o_CompassDirection;
         if (!bDoIt(o_CompassDirection))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CompassDirection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CompassDirection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_TMBASEINFO:
   {
      if (poVisitor->bDoExpand_TMBaseInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_POSIXTIME,navifi_tclSemanticDomain::EN_LATESTDECODETIME));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_POSIXTIME,navifi_tclSemanticDomain::EN_STOPTIME));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_POSIXTIME,navifi_tclSemanticDomain::EN_STARTTIME));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16_INDEXINREFERENCELIST,navifi_tclSemanticDomain::EN_INDEXINSERVICEPROVIDERLIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16_INDEXINREFERENCELIST,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_INDICESINPROGRAMSERVICELIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32,navifi_tclSemanticDomain::EN_TRAFFICMESSAGEID));
      }
      else
      {
         fi_tcl_TMBaseInfo o_TMBaseInfo;
         if (!bDoIt(o_TMBaseInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMBaseInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMBaseInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_ROADNUMBER:
   {
      if (poVisitor->bDoExpand_RoadNumber(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_COMPASSDIRECTION,navifi_tclSemanticDomain::EN_COMPASSDIRECTION));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_STRING,navifi_tclSemanticDomain::EN_NUMBERSUFFIX));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_STRING,navifi_tclSemanticDomain::EN_ROADNUMBER));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_STRING,navifi_tclSemanticDomain::EN_NUMBERPREFIX));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8,navifi_tclSemanticDomain::EN_NUMBERHIERARCHY));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32,navifi_tclSemanticDomain::EN_STATECODE));
         }
         if (u16MajorVersion <= 10)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_STATE));
         }
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_ISOCOUNTRYCODE,navifi_tclSemanticDomain::EN_COUNTRYCODE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_B8_ROADNUMBERSTATUS,navifi_tclSemanticDomain::EN_STATUS));
      }
      else
      {
         fi_tcl_RoadNumber o_RoadNumber;
         if (!bDoIt(o_RoadNumber))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNumber.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNumber.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_E8_INFOSTATUS:
   {
      fi_tcl_e8_InfoStatus o_e8_InfoStatus;
      if (!bDoIt(o_e8_InfoStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_INFOSTATUS:
   {
      if (poVisitor->bDoExpand_InfoStatus(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_INFOSTATUS,navifi_tclSemanticDomain::EN_STATUS));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_INFOCOUNTER));
      }
      else
      {
         fi_tcl_InfoStatus o_InfoStatus;
         if (!bDoIt(o_InfoStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_InfoStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_InfoStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_REQUIREDTAXDISC:
   {
      if (poVisitor->bDoExpand_RequiredTaxDisc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_MULTILANGUAGESTRING,navifi_tclSemanticDomain::EN_DESCRIPTION));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_MULTILANGUAGESTRING,navifi_tclSemanticDomain::EN_REQUIREDPERMISSIONNAME));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_REGION));
         }
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_ISOCOUNTRYCODE,navifi_tclSemanticDomain::EN_COUNTRYCODE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S32,navifi_tclSemanticDomain::EN_REQUIREDPERMISSIONID));
      }
      else
      {
         fi_tcl_RequiredTaxDisc o_RequiredTaxDisc;
         if (!bDoIt(o_RequiredTaxDisc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredTaxDisc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredTaxDisc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_E8_REQUIREDPERMISSIONTYPE:
   {
      fi_tcl_e8_RequiredPermissionType o_e8_RequiredPermissionType;
      if (!bDoIt(o_e8_RequiredPermissionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_E8_REQUIREDPERMISSION:
   {
      fi_tcl_e8_RequiredPermission o_e8_RequiredPermission;
      if (!bDoIt(o_e8_RequiredPermission))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case navifi_tclToken::EN_GENERICREQUIREDPERMISSION:
   {
      if (poVisitor->bDoExpand_GenericRequiredPermission(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_REQUIREDPERMISSIONTYPE,navifi_tclSemanticDomain::EN_REQUIREDPERMISSIONTYPE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_MULTILANGUAGESTRING,navifi_tclSemanticDomain::EN_DESCRIPTION));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_MULTILANGUAGESTRING,navifi_tclSemanticDomain::EN_REQUIREDPERMISSIONNAME));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_REGIONID));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_ISOCOUNTRYCODE,navifi_tclSemanticDomain::EN_COUNTRYCODE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S32,navifi_tclSemanticDomain::EN_REQUIREDPERMISSIONID));
      }
      else
      {
         fi_tcl_GenericRequiredPermission o_GenericRequiredPermission;
         if (!bDoIt(o_GenericRequiredPermission))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GenericRequiredPermission.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GenericRequiredPermission.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_REQUIREDPERMISSIONUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_RequiredPermission oDataType;
      oCallStack.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_REQUIREDPERMISSION,navifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_RequiredPermission::FI_EN_T_GENERICREQUIREDPERMISSION) &&
          !(13 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_RequiredPermission::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_RequiredPermission::FI_EN_T_REQUIREDTAXDISC) &&
          !(u16MajorVersion <= 12))
      {
         oDataType.enType = fi_tcl_e8_RequiredPermission::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_RequiredPermission::FI_EN_T_RESERVED:
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_RESERVED,navifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RequiredPermission::FI_EN_T_REQUIREDTAXDISC:
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_REQUIREDTAXDISC,navifi_tclSemanticDomain::EN_CATEGORY));
         break;
      case fi_tcl_e8_RequiredPermission::FI_EN_T_GENERICREQUIREDPERMISSION:
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_GENERICREQUIREDPERMISSION,navifi_tclSemanticDomain::EN_CATEGORY));
         break;
      }
   } break;
   case navifi_tclToken::EN_REQUIREDPERMISSION:
   {
      if (poVisitor->bDoExpand_RequiredPermission(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_REQUIREDPERMISSIONUNION0,navifi_tclSemanticDomain::EN_CATEGORY));
      }
      else
      {
         fi_tcl_RequiredPermission o_RequiredPermission;
         if (!bDoIt(o_RequiredPermission))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredPermission.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredPermission.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_REQUIREDPERMISSIONLIST:
   {
      if (poVisitor->bDoExpand_RequiredPermissionList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_REQUIREDPERMISSION,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_REQUIREDPERMISSIONLIST));
      }
      else
      {
         fi_tcl_RequiredPermissionList o_RequiredPermissionList;
         if (!bDoIt(o_RequiredPermissionList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredPermissionList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequiredPermissionList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_TMINFO:
   {
      if (poVisitor->bDoExpand_TMInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_TMGEOGRAPHICALPATHRELATIONTYPE,navifi_tclSemanticDomain::EN_GEOGRAPHICALPATHRELATION));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_POSIXTIME,navifi_tclSemanticDomain::EN_LATESTDECODETIME));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_POSIXTIME,navifi_tclSemanticDomain::EN_STOPTIME));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_POSIXTIME,navifi_tclSemanticDomain::EN_STARTTIME));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16_INDEXINREFERENCELIST,navifi_tclSemanticDomain::EN_INDEXINSERVICEPROVIDERLIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16_INDEXINREFERENCELIST,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_INDICESINPROGRAMSERVICELIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_BOOL,navifi_tclSemanticDomain::EN_BIDIRECTIONAL));
         if (32 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_BOOL,navifi_tclSemanticDomain::EN_DIRECTIONAGAINSTTMC));
         }
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_RDBID,navifi_tclSemanticDomain::EN_RDBID));
         if (32 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMCSTRUCTUREDTEXT,navifi_tclSemanticDomain::EN_ROADNAME));
         }
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_ROADNUMBER,navifi_tclSemanticDomain::EN_ROADNUMBER));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_ROADCLASSCODE,navifi_tclSemanticDomain::EN_ROADCLASS));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8,navifi_tclSemanticDomain::EN_PREFIXPRIORITY));
         if (9 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_LOCATIONSEGMENTIDX));
         }
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_SEGMENTID));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_TMURGENCY,navifi_tclSemanticDomain::EN_URGENCYOFEVENT));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16_USERTRAFFICMESSAGEHANDLE,navifi_tclSemanticDomain::EN_UTMHANDLE));
         if (15 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_B8_TMRELEVANCE,navifi_tclSemanticDomain::EN_TMRELEVANCE));
         }
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_B32_TRAFFICMESSAGESOURCE,navifi_tclSemanticDomain::EN_TRAFFICINFOSOURCE));
         if (36 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_TMVALUESTATUS,navifi_tclSemanticDomain::EN_LENGTHSTATUS));
         }
         if (30 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S32_METER,navifi_tclSemanticDomain::EN_LENGTH));
         }
         if (36 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_TMVALUESTATUS,navifi_tclSemanticDomain::EN_DELAYSTATUS));
         }
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S32_SECOND,navifi_tclSemanticDomain::EN_DELAY));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_SHAPE,navifi_tclSemanticDomain::EN_SHAPE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_TMGEOMETRICMESSAGETYPE,navifi_tclSemanticDomain::EN_GEOMETRICMESSAGETYPE));
         if (36 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U8,navifi_tclSemanticDomain::EN_FLOWVALUE));
         }
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_TMFLOWIMPACT,navifi_tclSemanticDomain::EN_TMFLOWIMPACT));
         }
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_TMCATEGORY,navifi_tclSemanticDomain::EN_TMCATEGORY));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_B8_TMMAPPINGSTATUS,navifi_tclSemanticDomain::EN_TMMAPPINGSTATUS));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_B8_TMMAPPINGPOSSIBILITY,navifi_tclSemanticDomain::EN_TMMAPPINGPOSSIBILITY));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMEVENT,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_EVENTLIST));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_TRAFFICMSGTYPE,navifi_tclSemanticDomain::EN_MESSAGETYPE));
         }
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32,navifi_tclSemanticDomain::EN_TRAFFICMESSAGEID));
      }
      else
      {
         fi_tcl_TMInfo o_TMInfo;
         if (!bDoIt(o_TMInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_TMINFOREFERENCE:
   {
      if (poVisitor->bDoExpand_TMInfoReference(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMINFO,navifi_tclSemanticDomain::EN_TMINFO));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16_INDEXINREFERENCELIST,navifi_tclSemanticDomain::EN_INDEXINBASELIST));
      }
      else
      {
         fi_tcl_TMInfoReference o_TMInfoReference;
         if (!bDoIt(o_TMInfoReference))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMInfoReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMInfoReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_SPEEDFACTORSLIST:
   {
      if (poVisitor->bDoExpand_SpeedFactorsList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_SPEEDFACTORSCOUNTRY,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_SPEEDFACTORSCOUNTRYLIST));
      }
      else
      {
         fi_tcl_SpeedFactorsList o_SpeedFactorsList;
         if (!bDoIt(o_SpeedFactorsList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SpeedFactorsList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SpeedFactorsList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_VERSIONINFO:
   {
      if (poVisitor->bDoExpand_VersionInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_STRING,navifi_tclSemanticDomain::EN_PRODUCTVERSION));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_STRING,navifi_tclSemanticDomain::EN_PRODUCTIONDATE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_STRING,navifi_tclSemanticDomain::EN_MANUFACTURER));
      }
      else
      {
         fi_tcl_VersionInfo o_VersionInfo;
         if (!bDoIt(o_VersionInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VersionInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VersionInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_UTMDESC:
   {
      if (poVisitor->bDoExpand_UTMDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_BINCONTAINER,navifi_tclSemanticDomain::EN_NAVUTMCONTAINER));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S32_METER,navifi_tclSemanticDomain::EN_UTMLENGTH));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_S32_METER,navifi_tclSemanticDomain::EN_STARTOFFSET));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16_INDEXINREFERENCELIST,navifi_tclSemanticDomain::EN_STARTELEMENT));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_NAVIEVENTVALUE,navifi_tclSemanticDomain::EN_NAVIEVENTVALUE));
      }
      else
      {
         fi_tcl_UTMDesc o_UTMDesc;
         if (!bDoIt(o_UTMDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTMDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTMDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_UTMDESCBYTM:
   {
      if (poVisitor->bDoExpand_UTMDescByTM(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E16_NAVIEVENTVALUE,navifi_tclSemanticDomain::EN_NAVIEVENTVALUE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32,navifi_tclSemanticDomain::EN_TRAFFICMESSAGEID));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32,navifi_tclSemanticDomain::EN_TRAFFICMESSAGEREVISION));
      }
      else
      {
         fi_tcl_UTMDescByTM o_UTMDescByTM;
         if (!bDoIt(o_UTMDescByTM))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTMDescByTM.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UTMDescByTM.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case navifi_tclToken::EN_TMMAPONECELLLISTSET:
   {
      if (poVisitor->bDoExpand_TMMapOneCellListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_NAVCLUSTERDESC,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_CLUSTERLIST));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMONECELLDESC,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_TMONECELLLIST));
      }
      else
      {
         fi_tcl_TMMapOneCellListSet o_TMMapOneCellListSet;
         if (!bDoIt(o_TMMapOneCellListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMMapOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMMapOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#ifndef FI_S_EXTERNAL_FI
   case navifi_tclToken::EN_TMMAPBINCONTAINER:
   {
      if (poVisitor->bDoExpand_TMMapBinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         bInsideBinContainerVersion = true;
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_BINCONTAINER));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_TMMAPONECELLLISTSET,navifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_LIST,navifi_tclSemanticDomain::EN_TMLEVELMAPONECELLLISTSET));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32_DATASETID,navifi_tclSemanticDomain::EN_NAVDATASETID));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_E8_BINCONTAINERTYPES,navifi_tclSemanticDomain::EN_CONTAINERTYPE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_FIVERSION,navifi_tclSemanticDomain::EN_CONTAINERFIVERSION));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16,navifi_tclSemanticDomain::EN_SERVICEID));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U32,navifi_tclSemanticDomain::EN_CONTAINERLENGTH));
      }
      else
      {
         fi_tcl_TMMapBinContainer o_TMMapBinContainer;
         if (!bDoIt(o_TMMapBinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMMapBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMMapBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#endif // FI_S_EXTERNAL_FI
   case navifi_tclToken::EN_TMCODEDMAPREFERENCE:
   {
      if (poVisitor->bDoExpand_TMCodedMapReference(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_END_OF_STRUCT,navifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_BINCONTAINER,navifi_tclSemanticDomain::EN_TMCODEDMAPMESSAGE));
         oPath.bGoDown(navifi_tclKnot(navifi_tclToken::EN_U16_INDEXINREFERENCELIST,navifi_tclSemanticDomain::EN_INDEXINBASELIST));
      }
      else
      {
         fi_tcl_TMCodedMapReference o_TMCodedMapReference;
         if (!bDoIt(o_TMCodedMapReference))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMapReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMapReference.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case navifi_tclToken::EN_UNKNOWN:
      case navifi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

