#ifndef __NAVIFIDEBUGVISITOR_H__
#define __NAVIFIDEBUGVISITOR_H__

class MY_DECL navifi_tclPrintVisitor : public navifi_tclVisitorBase {

private:
   /* default constructor */ navifi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   navifi_tclPrintVisitor(fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Reserved(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u8_Percent(fi_tcl_u8_Percent& o_u8_Percent);
   virtual tVoid vVisit_u16_IndexInReferenceList(fi_tcl_u16_IndexInReferenceList& o_u16_IndexInReferenceList);
   virtual tVoid vVisit_u16_ErrorCode(fi_tcl_u16_ErrorCode& o_u16_ErrorCode);
   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& o_s32_Meter);
   virtual tVoid vVisit_s32_Second(fi_tcl_s32_Second& o_s32_Second);
   virtual tVoid vVisit_s32_MilliSecond(fi_tcl_s32_MilliSecond& o_s32_MilliSecond);
   virtual tBool bDoExpand_POSIXTime(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DST_State(fi_tcl_e8_DST_State& o_e8_DST_State);
   virtual tBool bDoExpand_TimeZoneElement(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s16_KmPerHour(fi_tcl_s16_KmPerHour& o_s16_KmPerHour);
   virtual tVoid vVisit_s16_CentimeterSecond(fi_tcl_s16_CentimeterSecond& o_s16_CentimeterSecond);
   virtual tBool bDoExpand_FIVersion(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tBool bDoExpand_PositionWGS84(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_e16_ISOLanguageCode(fi_tcl_e16_ISOLanguageCode& o_e16_ISOLanguageCode);
   virtual tVoid vVisit_u8_DirectionAbsolute(fi_tcl_u8_DirectionAbsolute& o_u8_DirectionAbsolute);
   virtual tVoid vVisit_e8_BinContainerTypes(fi_tcl_e8_BinContainerTypes& o_e8_BinContainerTypes);
   virtual tVoid vVisit_e16_NaviEventValue(fi_tcl_e16_NaviEventValue& o_e16_NaviEventValue);
   virtual tVoid vVisit_e8_TrafficMsgType(fi_tcl_e8_TrafficMsgType& o_e8_TrafficMsgType);
   virtual tVoid vVisit_e8_TMLocationType(fi_tcl_e8_TMLocationType& o_e8_TMLocationType);
   virtual tVoid vVisit_e8_EventType(fi_tcl_e8_EventType& o_e8_EventType);
   virtual tVoid vVisit_e16_EffectCode(fi_tcl_e16_EffectCode& o_e16_EffectCode);
   virtual tVoid vVisit_e16_CauseCode(fi_tcl_e16_CauseCode& o_e16_CauseCode);
   virtual tVoid vVisit_e8_Tendency(fi_tcl_e8_Tendency& o_e8_Tendency);
   virtual tBool bDoExpand_RDBId(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMEvent(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b32_TrafficMessageSource(fi_tcl_b32_TrafficMessageSource& o_b32_TrafficMessageSource);
   virtual tVoid vVisit_b8_TMAdditionalInformation(fi_tcl_b8_TMAdditionalInformation& o_b8_TMAdditionalInformation);
   virtual tVoid vVisit_b8_TrafficMessageSourceAvailability(fi_tcl_b8_TrafficMessageSourceAvailability& o_b8_TrafficMessageSourceAvailability);
   virtual tBool bDoExpand_TrafficMsgMemoryStatisticsPerType(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TrafficMsgMemoryStatistics(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ISORDBIdAvailability(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TMUrgency(fi_tcl_e8_TMUrgency& o_e8_TMUrgency);
   virtual tBool bDoExpand_TMCodedMessage(navifi_tclSemanticDomain::tenType enSemantic);
#ifndef FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_TMCodedMessageBinContainer(navifi_tclSemanticDomain::tenType enSemantic);
#endif // FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_TMProgramService(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u32_DataSetId(fi_tcl_u32_DataSetId& o_u32_DataSetId);
   virtual tVoid vVisit_u32_MediaId(fi_tcl_u32_MediaId& o_u32_MediaId);
   virtual tBool bDoExpand_NavClusterDesc(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_NavOneCellDirection(fi_tcl_e8_NavOneCellDirection& o_e8_NavOneCellDirection);
   virtual tBool bDoExpand_NavOneCellDesc(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_SideInfo(fi_tcl_e8_SideInfo& o_e8_SideInfo);
   virtual tVoid vVisit_s32_EMU(fi_tcl_s32_EMU& o_s32_EMU);
   virtual tBool bDoExpand_NavZeroCellDesc(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_NavLocationDescType(fi_tcl_e8_NavLocationDescType& o_e8_NavLocationDescType);
   virtual tBool bDoExpand_NavLocationDesc(navifi_tclSemanticDomain::tenType enSemantic);
#ifndef FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_NavLocationBinContainer(navifi_tclSemanticDomain::tenType enSemantic);
#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_e8_NavIndexZFDestinationType(fi_tcl_e8_NavIndexZFDestinationType& o_e8_NavIndexZFDestinationType);
   virtual tVoid vVisit_e8_NavLocationNavDataType(fi_tcl_e8_NavLocationNavDataType& o_e8_NavLocationNavDataType);
   virtual tBool bDoExpand_NavLocationDataDesc(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavSpotDestinationOneCellProperty(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavSpotDestinationOneCellDesc(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavSpotDestinationOneCellListSet(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavStreetDestinationOneCellProperty(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavStreetDestinationOneCellDesc(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavStreetDestinationOneCellListSet(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_NavIntersectionType(fi_tcl_e8_NavIntersectionType& o_e8_NavIntersectionType);
   virtual tBool bDoExpand_NavIntersectionDestinationZeroCellProperty(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavIntersectionDestinationZeroCellDesc(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavIntersectionDestinationZeroCellListSet(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavAreaDescriptionCircle(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavAreaDescriptionPolygon(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavDLDChainOneCellProperty(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavDLDChainOneCellDesc(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavDLDChainOneCellListSet(navifi_tclSemanticDomain::tenType enSemantic);
#ifndef FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_NavUTMBinContainer(navifi_tclSemanticDomain::tenType enSemantic);
#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_u16_UserTrafficMessageHandle(fi_tcl_u16_UserTrafficMessageHandle& o_u16_UserTrafficMessageHandle);
   virtual tBool bDoExpand_UTMHandleContainer(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_TrafficMessageContent(fi_tcl_b8_TrafficMessageContent& o_b8_TrafficMessageContent);
   virtual tVoid vVisit_e8_TMGeometricMessageType(fi_tcl_e8_TMGeometricMessageType& o_e8_TMGeometricMessageType);
   virtual tBool bDoExpand_TMCodedTextReference(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TMAffectionType(fi_tcl_e8_TMAffectionType& o_e8_TMAffectionType);
   virtual tBool bDoExpand_TrafficSense(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TrafficSenseList(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_RoadClassCode(fi_tcl_e8_RoadClassCode& o_e8_RoadClassCode);
   virtual tVoid vVisit_e8_RoadTypeDesc(fi_tcl_e8_RoadTypeDesc& o_e8_RoadTypeDesc);
   virtual tBool bDoExpand_SpeedFactor(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SpeedFactorRoadAreaType(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SpeedFactorsCountry(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_SpeedLimitStatus(fi_tcl_b8_SpeedLimitStatus& o_b8_SpeedLimitStatus);
   virtual tVoid vVisit_e8_SpeedUnit(fi_tcl_e8_SpeedUnit& o_e8_SpeedUnit);
   virtual tVoid vVisit_e8_SpeedType(fi_tcl_e8_SpeedType& o_e8_SpeedType);
   virtual tBool bDoExpand_SpeedLimitStatus(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SpeedLimit(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SpeedLimitRoadAreaType(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SpeedLimitsCountry(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SpeedLimitsList(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PrefixDesc(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PrefixState(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PrefixStateList(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_LanguageCat(fi_tcl_e8_LanguageCat& o_e8_LanguageCat);
   virtual tBool bDoExpand_LanguageCategory(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LanguageDesc(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LanguageDescList(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_GlobalAnnotationCategory(fi_tcl_e8_GlobalAnnotationCategory& o_e8_GlobalAnnotationCategory);
   virtual tBool bDoExpand_GlobalAnnotationTablesUnion(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TimeZoneName(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b16_UPOI_Source(fi_tcl_b16_UPOI_Source& o_b16_UPOI_Source);
   virtual tVoid vVisit_e8_TMHandling(fi_tcl_e8_TMHandling& o_e8_TMHandling);
   virtual tVoid vVisit_e8_TMDirectionInterpretation(fi_tcl_e8_TMDirectionInterpretation& o_e8_TMDirectionInterpretation);
   virtual tVoid vVisit_b8_TMIntersectionPath(fi_tcl_b8_TMIntersectionPath& o_b8_TMIntersectionPath);
   virtual tBool bDoExpand_TMParamAmbiguousClosing(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMParamAmbiguousDynamicDisruption(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMParamAmbiguousArea(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_ShapeType(fi_tcl_e8_ShapeType& o_e8_ShapeType);
   virtual tBool bDoExpand_Shape(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ExtendedLocation(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CountryLocationList(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMServiceProvider(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TMCategory(fi_tcl_e8_TMCategory& o_e8_TMCategory);
   virtual tVoid vVisit_e8_TMFlowImpact(fi_tcl_e8_TMFlowImpact& o_e8_TMFlowImpact);
   virtual tVoid vVisit_b8_TMMappingPossibility(fi_tcl_b8_TMMappingPossibility& o_b8_TMMappingPossibility);
   virtual tVoid vVisit_b8_TMMappingStatus(fi_tcl_b8_TMMappingStatus& o_b8_TMMappingStatus);
   virtual tVoid vVisit_b8_TMOneCellAttribute(fi_tcl_b8_TMOneCellAttribute& o_b8_TMOneCellAttribute);
   virtual tBool bDoExpand_TMOneCellPortion(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMOneCellDesc(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TMValueStatus(fi_tcl_e8_TMValueStatus& o_e8_TMValueStatus);
   virtual tBool bDoExpand_TMCStructuredText(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMCategoryStatistics(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMFlowImpactStatistics(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMUrgencyStatistics(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UTMStatistics(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMStatistics(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TMGeographicalPathRelationType(fi_tcl_e8_TMGeographicalPathRelationType& o_e8_TMGeographicalPathRelationType);
   virtual tVoid vVisit_b8_TMRelevance(fi_tcl_b8_TMRelevance& o_b8_TMRelevance);
   virtual tVoid vVisit_b8_RoadNumberStatus(fi_tcl_b8_RoadNumberStatus& o_b8_RoadNumberStatus);
   virtual tBool bDoExpand_CompassDirection(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMBaseInfo(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadNumber(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_InfoStatus(fi_tcl_e8_InfoStatus& o_e8_InfoStatus);
   virtual tBool bDoExpand_InfoStatus(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RequiredTaxDisc(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_RequiredPermissionType(fi_tcl_e8_RequiredPermissionType& o_e8_RequiredPermissionType);
   virtual tVoid vVisit_e8_RequiredPermission(fi_tcl_e8_RequiredPermission& o_e8_RequiredPermission);
   virtual tBool bDoExpand_GenericRequiredPermission(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RequiredPermission(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RequiredPermissionList(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMInfo(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMInfoReference(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SpeedFactorsList(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_VersionInfo(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UTMDesc(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UTMDescByTM(navifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMMapOneCellListSet(navifi_tclSemanticDomain::tenType enSemantic);
#ifndef FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_TMMapBinContainer(navifi_tclSemanticDomain::tenType enSemantic);
#endif // FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_TMCodedMapReference(navifi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   fi_tclOutput* poOutput;
};


class MY_DECL navifi_tclRandomInitVisitor : public navifi_tclVisitorBase {
public:

   navifi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_u8_Percent(fi_tcl_u8_Percent& o_u8_Percent);
   virtual tVoid vVisit_u16_IndexInReferenceList(fi_tcl_u16_IndexInReferenceList& o_u16_IndexInReferenceList);
   virtual tVoid vVisit_u16_ErrorCode(fi_tcl_u16_ErrorCode& o_u16_ErrorCode);
   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& o_s32_Meter);
   virtual tVoid vVisit_s32_Second(fi_tcl_s32_Second& o_s32_Second);
   virtual tVoid vVisit_s32_MilliSecond(fi_tcl_s32_MilliSecond& o_s32_MilliSecond);
   virtual tVoid vVisit_e8_DST_State(fi_tcl_e8_DST_State& o_e8_DST_State);
   virtual tVoid vVisit_s16_KmPerHour(fi_tcl_s16_KmPerHour& o_s16_KmPerHour);
   virtual tVoid vVisit_s16_CentimeterSecond(fi_tcl_s16_CentimeterSecond& o_s16_CentimeterSecond);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_e16_ISOLanguageCode(fi_tcl_e16_ISOLanguageCode& o_e16_ISOLanguageCode);
   virtual tVoid vVisit_u8_DirectionAbsolute(fi_tcl_u8_DirectionAbsolute& o_u8_DirectionAbsolute);
   virtual tVoid vVisit_e8_BinContainerTypes(fi_tcl_e8_BinContainerTypes& o_e8_BinContainerTypes);
   virtual tVoid vVisit_e16_NaviEventValue(fi_tcl_e16_NaviEventValue& o_e16_NaviEventValue);
   virtual tVoid vVisit_e8_TrafficMsgType(fi_tcl_e8_TrafficMsgType& o_e8_TrafficMsgType);
   virtual tVoid vVisit_e8_TMLocationType(fi_tcl_e8_TMLocationType& o_e8_TMLocationType);
   virtual tVoid vVisit_e8_EventType(fi_tcl_e8_EventType& o_e8_EventType);
   virtual tVoid vVisit_e16_EffectCode(fi_tcl_e16_EffectCode& o_e16_EffectCode);
   virtual tVoid vVisit_e16_CauseCode(fi_tcl_e16_CauseCode& o_e16_CauseCode);
   virtual tVoid vVisit_e8_Tendency(fi_tcl_e8_Tendency& o_e8_Tendency);
   virtual tVoid vVisit_b32_TrafficMessageSource(fi_tcl_b32_TrafficMessageSource& o_b32_TrafficMessageSource);
   virtual tVoid vVisit_b8_TMAdditionalInformation(fi_tcl_b8_TMAdditionalInformation& o_b8_TMAdditionalInformation);
   virtual tVoid vVisit_b8_TrafficMessageSourceAvailability(fi_tcl_b8_TrafficMessageSourceAvailability& o_b8_TrafficMessageSourceAvailability);
   virtual tVoid vVisit_e8_TMUrgency(fi_tcl_e8_TMUrgency& o_e8_TMUrgency);
#ifndef FI_S_EXTERNAL_FI
#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_u32_DataSetId(fi_tcl_u32_DataSetId& o_u32_DataSetId);
   virtual tVoid vVisit_u32_MediaId(fi_tcl_u32_MediaId& o_u32_MediaId);
   virtual tVoid vVisit_e8_NavOneCellDirection(fi_tcl_e8_NavOneCellDirection& o_e8_NavOneCellDirection);
   virtual tVoid vVisit_e8_SideInfo(fi_tcl_e8_SideInfo& o_e8_SideInfo);
   virtual tVoid vVisit_s32_EMU(fi_tcl_s32_EMU& o_s32_EMU);
   virtual tVoid vVisit_e8_NavLocationDescType(fi_tcl_e8_NavLocationDescType& o_e8_NavLocationDescType);
#ifndef FI_S_EXTERNAL_FI
#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_e8_NavIndexZFDestinationType(fi_tcl_e8_NavIndexZFDestinationType& o_e8_NavIndexZFDestinationType);
   virtual tVoid vVisit_e8_NavLocationNavDataType(fi_tcl_e8_NavLocationNavDataType& o_e8_NavLocationNavDataType);
   virtual tVoid vVisit_e8_NavIntersectionType(fi_tcl_e8_NavIntersectionType& o_e8_NavIntersectionType);
#ifndef FI_S_EXTERNAL_FI
#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_u16_UserTrafficMessageHandle(fi_tcl_u16_UserTrafficMessageHandle& o_u16_UserTrafficMessageHandle);
   virtual tVoid vVisit_b8_TrafficMessageContent(fi_tcl_b8_TrafficMessageContent& o_b8_TrafficMessageContent);
   virtual tVoid vVisit_e8_TMGeometricMessageType(fi_tcl_e8_TMGeometricMessageType& o_e8_TMGeometricMessageType);
   virtual tVoid vVisit_e8_TMAffectionType(fi_tcl_e8_TMAffectionType& o_e8_TMAffectionType);
   virtual tVoid vVisit_e8_RoadClassCode(fi_tcl_e8_RoadClassCode& o_e8_RoadClassCode);
   virtual tVoid vVisit_e8_RoadTypeDesc(fi_tcl_e8_RoadTypeDesc& o_e8_RoadTypeDesc);
   virtual tVoid vVisit_b8_SpeedLimitStatus(fi_tcl_b8_SpeedLimitStatus& o_b8_SpeedLimitStatus);
   virtual tVoid vVisit_e8_SpeedUnit(fi_tcl_e8_SpeedUnit& o_e8_SpeedUnit);
   virtual tVoid vVisit_e8_SpeedType(fi_tcl_e8_SpeedType& o_e8_SpeedType);
   virtual tVoid vVisit_e8_LanguageCat(fi_tcl_e8_LanguageCat& o_e8_LanguageCat);
   virtual tVoid vVisit_e8_GlobalAnnotationCategory(fi_tcl_e8_GlobalAnnotationCategory& o_e8_GlobalAnnotationCategory);
   virtual tVoid vVisit_b16_UPOI_Source(fi_tcl_b16_UPOI_Source& o_b16_UPOI_Source);
   virtual tVoid vVisit_e8_TMHandling(fi_tcl_e8_TMHandling& o_e8_TMHandling);
   virtual tVoid vVisit_e8_TMDirectionInterpretation(fi_tcl_e8_TMDirectionInterpretation& o_e8_TMDirectionInterpretation);
   virtual tVoid vVisit_b8_TMIntersectionPath(fi_tcl_b8_TMIntersectionPath& o_b8_TMIntersectionPath);
   virtual tVoid vVisit_e8_ShapeType(fi_tcl_e8_ShapeType& o_e8_ShapeType);
   virtual tVoid vVisit_e8_TMCategory(fi_tcl_e8_TMCategory& o_e8_TMCategory);
   virtual tVoid vVisit_e8_TMFlowImpact(fi_tcl_e8_TMFlowImpact& o_e8_TMFlowImpact);
   virtual tVoid vVisit_b8_TMMappingPossibility(fi_tcl_b8_TMMappingPossibility& o_b8_TMMappingPossibility);
   virtual tVoid vVisit_b8_TMMappingStatus(fi_tcl_b8_TMMappingStatus& o_b8_TMMappingStatus);
   virtual tVoid vVisit_b8_TMOneCellAttribute(fi_tcl_b8_TMOneCellAttribute& o_b8_TMOneCellAttribute);
   virtual tVoid vVisit_e8_TMValueStatus(fi_tcl_e8_TMValueStatus& o_e8_TMValueStatus);
   virtual tVoid vVisit_e8_TMGeographicalPathRelationType(fi_tcl_e8_TMGeographicalPathRelationType& o_e8_TMGeographicalPathRelationType);
   virtual tVoid vVisit_b8_TMRelevance(fi_tcl_b8_TMRelevance& o_b8_TMRelevance);
   virtual tVoid vVisit_b8_RoadNumberStatus(fi_tcl_b8_RoadNumberStatus& o_b8_RoadNumberStatus);
   virtual tVoid vVisit_e8_InfoStatus(fi_tcl_e8_InfoStatus& o_e8_InfoStatus);
   virtual tVoid vVisit_e8_RequiredPermissionType(fi_tcl_e8_RequiredPermissionType& o_e8_RequiredPermissionType);
   virtual tVoid vVisit_e8_RequiredPermission(fi_tcl_e8_RequiredPermission& o_e8_RequiredPermission);
#ifndef FI_S_EXTERNAL_FI
#endif // FI_S_EXTERNAL_FI
	tU32 u32ListSize;
};

#endif
