/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MOVIETIMESFITYPES_HEADER
#define MOVIETIMESFITYPES_HEADER

// #include <vector>
// 


class movietimesfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class movietimesfi_tclMsgGetMovieListMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   movietimesfi_tclMsgGetMovieListMethodStart():DetailGrade(),PreferredLanguage() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   movietimesfi_tclMsgGetMovieListMethodStart& operator=(const movietimesfi_tclMsgGetMovieListMethodStart& coRef);
   movietimesfi_tclMsgGetMovieListMethodStart(const movietimesfi_tclMsgGetMovieListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_MovieId, std::allocator<fi_tcl_MovieId> > MovieIdList;
   fi_tcl_e8_DetailGrade DetailGrade;
   fi_tcl_e16_ISOLanguageCode PreferredLanguage;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const movietimesfi_tclMsgGetMovieListMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return movietimesfi_tclToken::EN_MSG_GETMOVIELISTMETHODSTART;}
};

class movietimesfi_tclMsgGetMovieListMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   movietimesfi_tclMsgGetMovieListMethodResult():MovieListComplete(0),TimeStamp() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   movietimesfi_tclMsgGetMovieListMethodResult& operator=(const movietimesfi_tclMsgGetMovieListMethodResult& coRef);
   movietimesfi_tclMsgGetMovieListMethodResult(const movietimesfi_tclMsgGetMovieListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_MovieDescription, std::allocator<fi_tcl_MovieDescription> > MovieList;
   tBool MovieListComplete;
   fi_tcl_POSIXTime TimeStamp;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const movietimesfi_tclMsgGetMovieListMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return movietimesfi_tclToken::EN_MSG_GETMOVIELISTMETHODRESULT;}
};

class movietimesfi_tclMsgGetMovieTimesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   movietimesfi_tclMsgGetMovieTimesMethodStart():PreferredLanguage() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   movietimesfi_tclMsgGetMovieTimesMethodStart& operator=(const movietimesfi_tclMsgGetMovieTimesMethodStart& coRef);
   movietimesfi_tclMsgGetMovieTimesMethodStart(const movietimesfi_tclMsgGetMovieTimesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_TheaterId, std::allocator<fi_tcl_TheaterId> > TheaterList;
   fi_tcl_e16_ISOLanguageCode PreferredLanguage;
   std::vector<fi_tcl_MovieId, std::allocator<fi_tcl_MovieId> > ListOfMovies;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const movietimesfi_tclMsgGetMovieTimesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return movietimesfi_tclToken::EN_MSG_GETMOVIETIMESMETHODSTART;}
};

class movietimesfi_tclMsgGetMovieTimesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   movietimesfi_tclMsgGetMovieTimesMethodResult():TimeStamp() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   movietimesfi_tclMsgGetMovieTimesMethodResult& operator=(const movietimesfi_tclMsgGetMovieTimesMethodResult& coRef);
   movietimesfi_tclMsgGetMovieTimesMethodResult(const movietimesfi_tclMsgGetMovieTimesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_TheaterMovieTimes, std::allocator<fi_tcl_TheaterMovieTimes> > MovieTimesList;
   std::vector<fi_tcl_BriefMovieDescription, std::allocator<fi_tcl_BriefMovieDescription> > BriefMovieList;
   fi_tcl_POSIXTime TimeStamp;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const movietimesfi_tclMsgGetMovieTimesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return movietimesfi_tclToken::EN_MSG_GETMOVIETIMESMETHODRESULT;}
};

class movietimesfi_tclMsgGetListOfTheaterDescriptionMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   movietimesfi_tclMsgGetListOfTheaterDescriptionMethodStart():DescriptionRequest() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   movietimesfi_tclMsgGetListOfTheaterDescriptionMethodStart& operator=(const movietimesfi_tclMsgGetListOfTheaterDescriptionMethodStart& coRef);
   movietimesfi_tclMsgGetListOfTheaterDescriptionMethodStart(const movietimesfi_tclMsgGetListOfTheaterDescriptionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_TheaterId, std::allocator<fi_tcl_TheaterId> > TheaterList;
   fi_tcl_b16_TheaterDescriptionRequest DescriptionRequest;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const movietimesfi_tclMsgGetListOfTheaterDescriptionMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return movietimesfi_tclToken::EN_MSG_GETLISTOFTHEATERDESCRIPTIONMETHODSTART;}
};

class movietimesfi_tclMsgGetListOfTheaterDescriptionMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   movietimesfi_tclMsgGetListOfTheaterDescriptionMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   movietimesfi_tclMsgGetListOfTheaterDescriptionMethodResult& operator=(const movietimesfi_tclMsgGetListOfTheaterDescriptionMethodResult& coRef);
   movietimesfi_tclMsgGetListOfTheaterDescriptionMethodResult(const movietimesfi_tclMsgGetListOfTheaterDescriptionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_TheaterDescription, std::allocator<fi_tcl_TheaterDescription> > TheaterDescription;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const movietimesfi_tclMsgGetListOfTheaterDescriptionMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return movietimesfi_tclToken::EN_MSG_GETLISTOFTHEATERDESCRIPTIONMETHODRESULT;}
};

class movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodStart():Distance(),MaxNumberOfTheaters(0),PreferredLanguage() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodStart& operator=(const movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodStart& coRef);
   movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodStart(const movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_PositionWGS84, std::allocator<fi_tcl_PositionWGS84> > ListOfPosition;
   fi_tcl_s32_Meter Distance;
   tU16 MaxNumberOfTheaters;
   fi_tcl_e16_ISOLanguageCode PreferredLanguage;
   std::vector<fi_tcl_MovieId, std::allocator<fi_tcl_MovieId> > ListOfMovies;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return movietimesfi_tclToken::EN_MSG_GETLISTOFMOVIETIMESBYPOSITIONMETHODSTART;}
};

class movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodResult():TimeStamp() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodResult& operator=(const movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodResult& coRef);
   movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodResult(const movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_TheaterMovieTimesForPosition, std::allocator<fi_tcl_TheaterMovieTimesForPosition> > MovieTimesForPositionList;
   std::vector<fi_tcl_BriefMovieDescription, std::allocator<fi_tcl_BriefMovieDescription> > BriefMovieList;
   fi_tcl_POSIXTime TimeStamp;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const movietimesfi_tclMsgGetListOfMovieTimesByPositionMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return movietimesfi_tclToken::EN_MSG_GETLISTOFMOVIETIMESBYPOSITIONMETHODRESULT;}
};


#endif
