#ifndef __MOVIETIMESFIDEBUGVISITOR_H__
#define __MOVIETIMESFIDEBUGVISITOR_H__

class MY_DECL movietimesfi_tclPrintVisitor : public movietimesfi_tclVisitorBase {

private:
   /* default constructor */ movietimesfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   movietimesfi_tclPrintVisitor(fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(movietimesfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& o_s32_Meter);
   virtual tBool bDoExpand_POSIXTime(movietimesfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tBool bDoExpand_PositionWGS84(movietimesfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_ISOLanguageCode(fi_tcl_e16_ISOLanguageCode& o_e16_ISOLanguageCode);
   virtual tBool bDoExpand_State(movietimesfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Amenity(fi_tcl_e8_Amenity& o_e8_Amenity);
   virtual tBool bDoExpand_Amenity(movietimesfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b16_TheaterDescriptionRequest(fi_tcl_b16_TheaterDescriptionRequest& o_b16_TheaterDescriptionRequest);
   virtual tBool bDoExpand_TheaterInfo(movietimesfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MovieId(movietimesfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Rating(movietimesfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RunTime(movietimesfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MovieName(movietimesfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MovieDescription(movietimesfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TheaterId(movietimesfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Showing(movietimesfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MovieTimes(movietimesfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TheaterMovieTimes(movietimesfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TheaterMovieTimesForPosition(movietimesfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DetailGrade(fi_tcl_e8_DetailGrade& o_e8_DetailGrade);
   virtual tBool bDoExpand_BriefMovieDescription(movietimesfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TheaterDescription(movietimesfi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   fi_tclOutput* poOutput;
};


class MY_DECL movietimesfi_tclRandomInitVisitor : public movietimesfi_tclVisitorBase {
public:

   movietimesfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& o_s32_Meter);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tVoid vVisit_e16_ISOLanguageCode(fi_tcl_e16_ISOLanguageCode& o_e16_ISOLanguageCode);
   virtual tVoid vVisit_e8_Amenity(fi_tcl_e8_Amenity& o_e8_Amenity);
   virtual tVoid vVisit_b16_TheaterDescriptionRequest(fi_tcl_b16_TheaterDescriptionRequest& o_b16_TheaterDescriptionRequest);
   virtual tVoid vVisit_e8_DetailGrade(fi_tcl_e8_DetailGrade& o_e8_DetailGrade);
	tU32 u32ListSize;
};

#endif
