#ifndef __MAPCTRLFIDEBUGVISITOR_H__
#define __MAPCTRLFIDEBUGVISITOR_H__

class MY_DECL mapctrlfi_tclPrintVisitor : public mapctrlfi_tclVisitorBase {

private:
   /* default constructor */ mapctrlfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   mapctrlfi_tclPrintVisitor(fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(mapctrlfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tBool bDoExpand_PositionWGS84(mapctrlfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u8_DirectionAbsolute(fi_tcl_u8_DirectionAbsolute& o_u8_DirectionAbsolute);
   virtual tVoid vVisit_u8_DirectionRelative(fi_tcl_u8_DirectionRelative& o_u8_DirectionRelative);
   virtual tVoid vVisit_u32_DataSetId(fi_tcl_u32_DataSetId& o_u32_DataSetId);
   virtual tVoid vVisit_u32_MediaId(fi_tcl_u32_MediaId& o_u32_MediaId);
   virtual tBool bDoExpand_RoadId(mapctrlfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u16_TripHandle(fi_tcl_u16_TripHandle& o_u16_TripHandle);
   virtual tVoid vVisit_u16_RouteHandle(fi_tcl_u16_RouteHandle& o_u16_RouteHandle);
   virtual tVoid vVisit_s16_XPosScreen(fi_tcl_s16_XPosScreen& o_s16_XPosScreen);
   virtual tVoid vVisit_s16_YPosScreen(fi_tcl_s16_YPosScreen& o_s16_YPosScreen);
   virtual tVoid vVisit_u16_Direction(fi_tcl_u16_Direction& o_u16_Direction);
   virtual tVoid vVisit_b16_GlobalPreferences(fi_tcl_b16_GlobalPreferences& o_b16_GlobalPreferences);
   virtual tVoid vVisit_b32_POI1(fi_tcl_b32_POI1& o_b32_POI1);
   virtual tVoid vVisit_b32_POI2(fi_tcl_b32_POI2& o_b32_POI2);
   virtual tVoid vVisit_b32_ServiceStations(fi_tcl_b32_ServiceStations& o_b32_ServiceStations);
   virtual tVoid vVisit_b32_ServiceStations2(fi_tcl_b32_ServiceStations2& o_b32_ServiceStations2);
   virtual tVoid vVisit_b32_ServiceStations3(fi_tcl_b32_ServiceStations3& o_b32_ServiceStations3);
   virtual tVoid vVisit_b8_FreewayFacilities(fi_tcl_b8_FreewayFacilities& o_b8_FreewayFacilities);
   virtual tVoid vVisit_b8_ParkingAreas(fi_tcl_b8_ParkingAreas& o_b8_ParkingAreas);
   virtual tVoid vVisit_b8_BorderLines(fi_tcl_b8_BorderLines& o_b8_BorderLines);
   virtual tVoid vVisit_b8_RiverClass(fi_tcl_b8_RiverClass& o_b8_RiverClass);
   virtual tVoid vVisit_b8_Channels(fi_tcl_b8_Channels& o_b8_Channels);
   virtual tVoid vVisit_b32_Streets(fi_tcl_b32_Streets& o_b32_Streets);
   virtual tVoid vVisit_b8_Areas(fi_tcl_b8_Areas& o_b8_Areas);
   virtual tVoid vVisit_b32_CityCenters(fi_tcl_b32_CityCenters& o_b32_CityCenters);
   virtual tVoid vVisit_b8_DirInfoStatus(fi_tcl_b8_DirInfoStatus& o_b8_DirInfoStatus);
   virtual tVoid vVisit_e8_FilterAcceptance(fi_tcl_e8_FilterAcceptance& o_e8_FilterAcceptance);
   virtual tVoid vVisit_e8_DrawMode(fi_tcl_e8_DrawMode& o_e8_DrawMode);
   virtual tVoid vVisit_e8_MapState(fi_tcl_e8_MapState& o_e8_MapState);
   virtual tVoid vVisit_e8_MapMode(fi_tcl_e8_MapMode& o_e8_MapMode);
   virtual tVoid vVisit_e8_MapScale(fi_tcl_e8_MapScale& o_e8_MapScale);
   virtual tVoid vVisit_e8_MapAngle(fi_tcl_e8_MapAngle& o_e8_MapAngle);
   virtual tBool bDoExpand_MapTransMatrix(mapctrlfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_IdxType(fi_tcl_e16_IdxType& o_e16_IdxType);
   virtual tBool bDoExpand_PositionScreen(mapctrlfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IndexInfo(mapctrlfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_DrawOptions(fi_tcl_b8_DrawOptions& o_b8_DrawOptions);
   virtual tBool bDoExpand_RouteDescriptor(mapctrlfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_RouteDisplayType(fi_tcl_e8_RouteDisplayType& o_e8_RouteDisplayType);
   virtual tVoid vVisit_e16_USMarcLanguageCode(fi_tcl_e16_USMarcLanguageCode& o_e16_USMarcLanguageCode);
   virtual tVoid vVisit_u32CodePage(fi_tcl_u32CodePage& o_u32CodePage);
   virtual tVoid vVisit_e8_LanguageDefaultFlag(fi_tcl_e8_LanguageDefaultFlag& o_e8_LanguageDefaultFlag);
   virtual tBool bDoExpand_LanguageFilter(mapctrlfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ZoomLevelConfig(mapctrlfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DestinationFlag(mapctrlfi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   fi_tclOutput* poOutput;
};


class MY_DECL mapctrlfi_tclRandomInitVisitor : public mapctrlfi_tclVisitorBase {
public:

   mapctrlfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tVoid vVisit_u8_DirectionAbsolute(fi_tcl_u8_DirectionAbsolute& o_u8_DirectionAbsolute);
   virtual tVoid vVisit_u8_DirectionRelative(fi_tcl_u8_DirectionRelative& o_u8_DirectionRelative);
   virtual tVoid vVisit_u32_DataSetId(fi_tcl_u32_DataSetId& o_u32_DataSetId);
   virtual tVoid vVisit_u32_MediaId(fi_tcl_u32_MediaId& o_u32_MediaId);
   virtual tVoid vVisit_u16_TripHandle(fi_tcl_u16_TripHandle& o_u16_TripHandle);
   virtual tVoid vVisit_u16_RouteHandle(fi_tcl_u16_RouteHandle& o_u16_RouteHandle);
   virtual tVoid vVisit_s16_XPosScreen(fi_tcl_s16_XPosScreen& o_s16_XPosScreen);
   virtual tVoid vVisit_s16_YPosScreen(fi_tcl_s16_YPosScreen& o_s16_YPosScreen);
   virtual tVoid vVisit_u16_Direction(fi_tcl_u16_Direction& o_u16_Direction);
   virtual tVoid vVisit_b16_GlobalPreferences(fi_tcl_b16_GlobalPreferences& o_b16_GlobalPreferences);
   virtual tVoid vVisit_b32_POI1(fi_tcl_b32_POI1& o_b32_POI1);
   virtual tVoid vVisit_b32_POI2(fi_tcl_b32_POI2& o_b32_POI2);
   virtual tVoid vVisit_b32_ServiceStations(fi_tcl_b32_ServiceStations& o_b32_ServiceStations);
   virtual tVoid vVisit_b32_ServiceStations2(fi_tcl_b32_ServiceStations2& o_b32_ServiceStations2);
   virtual tVoid vVisit_b32_ServiceStations3(fi_tcl_b32_ServiceStations3& o_b32_ServiceStations3);
   virtual tVoid vVisit_b8_FreewayFacilities(fi_tcl_b8_FreewayFacilities& o_b8_FreewayFacilities);
   virtual tVoid vVisit_b8_ParkingAreas(fi_tcl_b8_ParkingAreas& o_b8_ParkingAreas);
   virtual tVoid vVisit_b8_BorderLines(fi_tcl_b8_BorderLines& o_b8_BorderLines);
   virtual tVoid vVisit_b8_RiverClass(fi_tcl_b8_RiverClass& o_b8_RiverClass);
   virtual tVoid vVisit_b8_Channels(fi_tcl_b8_Channels& o_b8_Channels);
   virtual tVoid vVisit_b32_Streets(fi_tcl_b32_Streets& o_b32_Streets);
   virtual tVoid vVisit_b8_Areas(fi_tcl_b8_Areas& o_b8_Areas);
   virtual tVoid vVisit_b32_CityCenters(fi_tcl_b32_CityCenters& o_b32_CityCenters);
   virtual tVoid vVisit_b8_DirInfoStatus(fi_tcl_b8_DirInfoStatus& o_b8_DirInfoStatus);
   virtual tVoid vVisit_e8_FilterAcceptance(fi_tcl_e8_FilterAcceptance& o_e8_FilterAcceptance);
   virtual tVoid vVisit_e8_DrawMode(fi_tcl_e8_DrawMode& o_e8_DrawMode);
   virtual tVoid vVisit_e8_MapState(fi_tcl_e8_MapState& o_e8_MapState);
   virtual tVoid vVisit_e8_MapMode(fi_tcl_e8_MapMode& o_e8_MapMode);
   virtual tVoid vVisit_e8_MapScale(fi_tcl_e8_MapScale& o_e8_MapScale);
   virtual tVoid vVisit_e8_MapAngle(fi_tcl_e8_MapAngle& o_e8_MapAngle);
   virtual tVoid vVisit_e16_IdxType(fi_tcl_e16_IdxType& o_e16_IdxType);
   virtual tVoid vVisit_b8_DrawOptions(fi_tcl_b8_DrawOptions& o_b8_DrawOptions);
   virtual tVoid vVisit_e8_RouteDisplayType(fi_tcl_e8_RouteDisplayType& o_e8_RouteDisplayType);
   virtual tVoid vVisit_e16_USMarcLanguageCode(fi_tcl_e16_USMarcLanguageCode& o_e16_USMarcLanguageCode);
   virtual tVoid vVisit_u32CodePage(fi_tcl_u32CodePage& o_u32CodePage);
   virtual tVoid vVisit_e8_LanguageDefaultFlag(fi_tcl_e8_LanguageDefaultFlag& o_e8_LanguageDefaultFlag);
	tU32 u32ListSize;
};

#endif
