/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef LIFITYPES_HEADER
#define LIFITYPES_HEADER

// #include <vector>
// 


class lifi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class lifi_tclMsgGetSelectionCriteriaDescriptionMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgGetSelectionCriteriaDescriptionMethodStart():UILanguage(),LocationDescription() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgGetSelectionCriteriaDescriptionMethodStart& operator=(const lifi_tclMsgGetSelectionCriteriaDescriptionMethodStart& coRef);
   lifi_tclMsgGetSelectionCriteriaDescriptionMethodStart(const lifi_tclMsgGetSelectionCriteriaDescriptionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_LocationDescription LocationDescription;
   std::vector<fi_tcl_e16_SelectionCriterionType, std::allocator<fi_tcl_e16_SelectionCriterionType> > SelectionCriteria;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgGetSelectionCriteriaDescriptionMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_GETSELECTIONCRITERIADESCRIPTIONMETHODSTART;}
};

class lifi_tclMsgGetSelectionCriteriaDescriptionMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgGetSelectionCriteriaDescriptionMethodResult():UILanguage() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgGetSelectionCriteriaDescriptionMethodResult& operator=(const lifi_tclMsgGetSelectionCriteriaDescriptionMethodResult& coRef);
   lifi_tclMsgGetSelectionCriteriaDescriptionMethodResult(const lifi_tclMsgGetSelectionCriteriaDescriptionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   std::vector<fi_tcl_SelectionCriterionDescription, std::allocator<fi_tcl_SelectionCriterionDescription> > SelectionCriteriaDescription;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgGetSelectionCriteriaDescriptionMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_GETSELECTIONCRITERIADESCRIPTIONMETHODRESULT;}
};

class lifi_tclMsgGetSelectionCriteriaMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgGetSelectionCriteriaMethodStart():LocationDescription(),UILanguage(),GetOption() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgGetSelectionCriteriaMethodStart& operator=(const lifi_tclMsgGetSelectionCriteriaMethodStart& coRef);
   lifi_tclMsgGetSelectionCriteriaMethodStart(const lifi_tclMsgGetSelectionCriteriaMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LocationDescription LocationDescription;
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_b8_CriteriaGetOptions GetOption;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgGetSelectionCriteriaMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_GETSELECTIONCRITERIAMETHODSTART;}
};

class lifi_tclMsgGetSelectionCriteriaMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgGetSelectionCriteriaMethodResult():DatabaseIncomplete(0),UILanguage() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgGetSelectionCriteriaMethodResult& operator=(const lifi_tclMsgGetSelectionCriteriaMethodResult& coRef);
   lifi_tclMsgGetSelectionCriteriaMethodResult(const lifi_tclMsgGetSelectionCriteriaMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_SelectableCriterion, std::allocator<fi_tcl_SelectableCriterion> > SelectionCriteriaList;
   tBool DatabaseIncomplete;
   fi_tcl_e16_ISOLanguageCode UILanguage;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgGetSelectionCriteriaMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_GETSELECTIONCRITERIAMETHODRESULT;}
};

class lifi_tclMsgTransformLocationDescriptionMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgTransformLocationDescriptionMethodStart():UILanguage(),LocationDescription(),Mode() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgTransformLocationDescriptionMethodStart& operator=(const lifi_tclMsgTransformLocationDescriptionMethodStart& coRef);
   lifi_tclMsgTransformLocationDescriptionMethodStart(const lifi_tclMsgTransformLocationDescriptionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_LocationDescription LocationDescription;
   fi_tcl_e8_TransformMode Mode;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgTransformLocationDescriptionMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_TRANSFORMLOCATIONDESCRIPTIONMETHODSTART;}
};

class lifi_tclMsgTransformLocationDescriptionMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgTransformLocationDescriptionMethodResult():UILanguage(),LocationDescription() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgTransformLocationDescriptionMethodResult& operator=(const lifi_tclMsgTransformLocationDescriptionMethodResult& coRef);
   lifi_tclMsgTransformLocationDescriptionMethodResult(const lifi_tclMsgTransformLocationDescriptionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_LocationDescription LocationDescription;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgTransformLocationDescriptionMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_TRANSFORMLOCATIONDESCRIPTIONMETHODRESULT;}
};

class lifi_tclMsgGetElementCountMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgGetElementCountMethodStart():LocationDescription(),Limit(0),UILanguage() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgGetElementCountMethodStart& operator=(const lifi_tclMsgGetElementCountMethodStart& coRef);
   lifi_tclMsgGetElementCountMethodStart(const lifi_tclMsgGetElementCountMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LocationDescription LocationDescription;
   tU32 Limit;
   std::vector<tU16, std::allocator<tU16> > AttributeCodes;
   fi_tcl_e16_ISOLanguageCode UILanguage;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgGetElementCountMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_GETELEMENTCOUNTMETHODSTART;}
};

class lifi_tclMsgGetElementCountMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgGetElementCountMethodResult():Count(0),UILanguage() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgGetElementCountMethodResult& operator=(const lifi_tclMsgGetElementCountMethodResult& coRef);
   lifi_tclMsgGetElementCountMethodResult(const lifi_tclMsgGetElementCountMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 Count;
   fi_tcl_e16_ISOLanguageCode UILanguage;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgGetElementCountMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_GETELEMENTCOUNTMETHODRESULT;}
};

class lifi_tclMsgGetElementNameListMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgGetElementNameListMethodStart():UILanguage(),LocationDescription(),Limit(0),GetOption(),SortOption(),ListOffset(0),NoMatchingChars(0),MaxRadius() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgGetElementNameListMethodStart& operator=(const lifi_tclMsgGetElementNameListMethodStart& coRef);
   lifi_tclMsgGetElementNameListMethodStart(const lifi_tclMsgGetElementNameListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_LocationDescription LocationDescription;
   tU32 Limit;
   fi_tcl_b8_ListGetOptions GetOption;
   fi_tcl_b8_ListSortOptions SortOption;
   tS32 ListOffset;
   std::vector<tU16, std::allocator<tU16> > AttributeCodes;
   tU32 NoMatchingChars;
   fi_tcl_s32_Meter MaxRadius;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgGetElementNameListMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_GETELEMENTNAMELISTMETHODSTART;}
};

class lifi_tclMsgGetElementNameListMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgGetElementNameListMethodResult():UILanguage(),ResultOption(),ElementList(),LocationDescription() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgGetElementNameListMethodResult& operator=(const lifi_tclMsgGetElementNameListMethodResult& coRef);
   lifi_tclMsgGetElementNameListMethodResult(const lifi_tclMsgGetElementNameListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_b8_ListResultOptions ResultOption;
   fi_tcl_LocationValueListUnion ElementList;
   fi_tcl_LocationDescription LocationDescription;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgGetElementNameListMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_GETELEMENTNAMELISTMETHODRESULT;}
};

class lifi_tclMsgGetSpellerCharactersMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgGetSpellerCharactersMethodStart():UILanguage(),LocationDescription(),PartialNameRotation(0),LowerCaseLetters(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgGetSpellerCharactersMethodStart& operator=(const lifi_tclMsgGetSpellerCharactersMethodStart& coRef);
   lifi_tclMsgGetSpellerCharactersMethodStart(const lifi_tclMsgGetSpellerCharactersMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_LocationDescription LocationDescription;
   std::vector<tU16, std::allocator<tU16> > AttributeCodes;
   tBool PartialNameRotation;
   tBool LowerCaseLetters;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgGetSpellerCharactersMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_GETSPELLERCHARACTERSMETHODSTART;}
};

class lifi_tclMsgGetSpellerCharactersMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgGetSpellerCharactersMethodResult():UILanguage(),UniqueCharacters(),ValidCharacters(),FullMatch(0),MatchingElements(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgGetSpellerCharactersMethodResult& operator=(const lifi_tclMsgGetSpellerCharactersMethodResult& coRef);
   lifi_tclMsgGetSpellerCharactersMethodResult(const lifi_tclMsgGetSpellerCharactersMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tclString UniqueCharacters;
   fi_tclString ValidCharacters;
   tBool FullMatch;
   tU16 MatchingElements;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgGetSpellerCharactersMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_GETSPELLERCHARACTERSMETHODRESULT;}
};

class lifi_tclMsgGetDetailedElementDescriptionMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgGetDetailedElementDescriptionMethodStart():UILanguage(),LocationDescription() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgGetDetailedElementDescriptionMethodStart& operator=(const lifi_tclMsgGetDetailedElementDescriptionMethodStart& coRef);
   lifi_tclMsgGetDetailedElementDescriptionMethodStart(const lifi_tclMsgGetDetailedElementDescriptionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_LocationDescription LocationDescription;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgGetDetailedElementDescriptionMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_GETDETAILEDELEMENTDESCRIPTIONMETHODSTART;}
};

class lifi_tclMsgGetDetailedElementDescriptionMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgGetDetailedElementDescriptionMethodResult():UILanguage() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgGetDetailedElementDescriptionMethodResult& operator=(const lifi_tclMsgGetDetailedElementDescriptionMethodResult& coRef);
   lifi_tclMsgGetDetailedElementDescriptionMethodResult(const lifi_tclMsgGetDetailedElementDescriptionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   std::vector<fi_tclString, std::allocator<fi_tclString> > Descriptions;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgGetDetailedElementDescriptionMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_GETDETAILEDELEMENTDESCRIPTIONMETHODRESULT;}
};

class lifi_tclMsgGetAttributeHierarchyMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgGetAttributeHierarchyMethodStart():UILanguage(),LocationDescription() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgGetAttributeHierarchyMethodStart& operator=(const lifi_tclMsgGetAttributeHierarchyMethodStart& coRef);
   lifi_tclMsgGetAttributeHierarchyMethodStart(const lifi_tclMsgGetAttributeHierarchyMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_LocationDescription LocationDescription;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgGetAttributeHierarchyMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_GETATTRIBUTEHIERARCHYMETHODSTART;}
};

class lifi_tclMsgGetAttributeHierarchyMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgGetAttributeHierarchyMethodResult():UILanguage() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgGetAttributeHierarchyMethodResult& operator=(const lifi_tclMsgGetAttributeHierarchyMethodResult& coRef);
   lifi_tclMsgGetAttributeHierarchyMethodResult(const lifi_tclMsgGetAttributeHierarchyMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   std::vector<fi_tcl_FilterAttribute, std::allocator<fi_tcl_FilterAttribute> > List;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgGetAttributeHierarchyMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_GETATTRIBUTEHIERARCHYMETHODRESULT;}
};

class lifi_tclMsgGetAvailableUILanguagesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgGetAvailableUILanguagesMethodStart():LocationDescription() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgGetAvailableUILanguagesMethodStart& operator=(const lifi_tclMsgGetAvailableUILanguagesMethodStart& coRef);
   lifi_tclMsgGetAvailableUILanguagesMethodStart(const lifi_tclMsgGetAvailableUILanguagesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LocationDescription LocationDescription;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgGetAvailableUILanguagesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_GETAVAILABLEUILANGUAGESMETHODSTART;}
};

class lifi_tclMsgGetAvailableUILanguagesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgGetAvailableUILanguagesMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgGetAvailableUILanguagesMethodResult& operator=(const lifi_tclMsgGetAvailableUILanguagesMethodResult& coRef);
   lifi_tclMsgGetAvailableUILanguagesMethodResult(const lifi_tclMsgGetAvailableUILanguagesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_e16_ISOLanguageCode, std::allocator<fi_tcl_e16_ISOLanguageCode> > LanguageList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgGetAvailableUILanguagesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_GETAVAILABLEUILANGUAGESMETHODRESULT;}
};

class lifi_tclMsgTransformLocationDescriptionMatchedPosMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgTransformLocationDescriptionMatchedPosMethodStart():UILanguage(),LocationDescription(),Mode(),LocationBinContainerVersion(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgTransformLocationDescriptionMatchedPosMethodStart& operator=(const lifi_tclMsgTransformLocationDescriptionMatchedPosMethodStart& coRef);
   lifi_tclMsgTransformLocationDescriptionMatchedPosMethodStart(const lifi_tclMsgTransformLocationDescriptionMatchedPosMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_LocationDescription LocationDescription;
   fi_tcl_e8_TransformMode Mode;
   tU16 LocationBinContainerVersion;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgTransformLocationDescriptionMatchedPosMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_TRANSFORMLOCATIONDESCRIPTIONMATCHEDPOSMETHODSTART;}
};

class lifi_tclMsgTransformLocationDescriptionMatchedPosMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgTransformLocationDescriptionMatchedPosMethodResult():UILanguage(),LocationDescription(),TransformedPosition() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgTransformLocationDescriptionMatchedPosMethodResult& operator=(const lifi_tclMsgTransformLocationDescriptionMatchedPosMethodResult& coRef);
   lifi_tclMsgTransformLocationDescriptionMatchedPosMethodResult(const lifi_tclMsgTransformLocationDescriptionMatchedPosMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_LocationDescription LocationDescription;
   fi_tcl_PositionWGS84 TransformedPosition;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgTransformLocationDescriptionMatchedPosMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_TRANSFORMLOCATIONDESCRIPTIONMATCHEDPOSMETHODRESULT;}
};

class lifi_tclMsgGetAllSpellerCharactersMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgGetAllSpellerCharactersMethodStart():LocationDescription(),UILanguage(),LowerCaseLetters(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgGetAllSpellerCharactersMethodStart& operator=(const lifi_tclMsgGetAllSpellerCharactersMethodStart& coRef);
   lifi_tclMsgGetAllSpellerCharactersMethodStart(const lifi_tclMsgGetAllSpellerCharactersMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LocationDescription LocationDescription;
   fi_tcl_e16_ISOLanguageCode UILanguage;
   std::vector<tU16, std::allocator<tU16> > AttributeCodes;
   tBool LowerCaseLetters;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgGetAllSpellerCharactersMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_GETALLSPELLERCHARACTERSMETHODSTART;}
};

class lifi_tclMsgGetAllSpellerCharactersMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgGetAllSpellerCharactersMethodResult():ValidCharacters() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgGetAllSpellerCharactersMethodResult& operator=(const lifi_tclMsgGetAllSpellerCharactersMethodResult& coRef);
   lifi_tclMsgGetAllSpellerCharactersMethodResult(const lifi_tclMsgGetAllSpellerCharactersMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString ValidCharacters;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgGetAllSpellerCharactersMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_GETALLSPELLERCHARACTERSMETHODRESULT;}
};

class lifi_tclMsgGetAddressFormatMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgGetAddressFormatMethodStart():LocationDescription(),UILanguage() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgGetAddressFormatMethodStart& operator=(const lifi_tclMsgGetAddressFormatMethodStart& coRef);
   lifi_tclMsgGetAddressFormatMethodStart(const lifi_tclMsgGetAddressFormatMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LocationDescription LocationDescription;
   fi_tcl_e16_ISOLanguageCode UILanguage;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgGetAddressFormatMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_GETADDRESSFORMATMETHODSTART;}
};

class lifi_tclMsgGetAddressFormatMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgGetAddressFormatMethodResult():UILanguage() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgGetAddressFormatMethodResult& operator=(const lifi_tclMsgGetAddressFormatMethodResult& coRef);
   lifi_tclMsgGetAddressFormatMethodResult(const lifi_tclMsgGetAddressFormatMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_e16_SelectionCriterionType, std::allocator<fi_tcl_e16_SelectionCriterionType> > SelectionCriteriaList;
   fi_tcl_e16_ISOLanguageCode UILanguage;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgGetAddressFormatMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_GETADDRESSFORMATMETHODRESULT;}
};

class lifi_tclMsgGetNearbyStatesOrCountriesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgGetNearbyStatesOrCountriesMethodStart():UILanguage(),LocationDescription(),MaxRadius() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgGetNearbyStatesOrCountriesMethodStart& operator=(const lifi_tclMsgGetNearbyStatesOrCountriesMethodStart& coRef);
   lifi_tclMsgGetNearbyStatesOrCountriesMethodStart(const lifi_tclMsgGetNearbyStatesOrCountriesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_LocationDescription LocationDescription;
   fi_tcl_s32_Meter MaxRadius;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgGetNearbyStatesOrCountriesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_GETNEARBYSTATESORCOUNTRIESMETHODSTART;}
};

class lifi_tclMsgGetNearbyStatesOrCountriesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgGetNearbyStatesOrCountriesMethodResult():UILanguage(),ElementList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgGetNearbyStatesOrCountriesMethodResult& operator=(const lifi_tclMsgGetNearbyStatesOrCountriesMethodResult& coRef);
   lifi_tclMsgGetNearbyStatesOrCountriesMethodResult(const lifi_tclMsgGetNearbyStatesOrCountriesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_LocationValueListUnion ElementList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgGetNearbyStatesOrCountriesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_GETNEARBYSTATESORCOUNTRIESMETHODRESULT;}
};

class lifi_tclMsgGetAddressFormatTableMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgGetAddressFormatTableMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgGetAddressFormatTableMethodStart& operator=(const lifi_tclMsgGetAddressFormatTableMethodStart& coRef);
   lifi_tclMsgGetAddressFormatTableMethodStart(const lifi_tclMsgGetAddressFormatTableMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgGetAddressFormatTableMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_GETADDRESSFORMATTABLEMETHODSTART;}
};

class lifi_tclMsgGetAddressFormatTableMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgGetAddressFormatTableMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgGetAddressFormatTableMethodResult& operator=(const lifi_tclMsgGetAddressFormatTableMethodResult& coRef);
   lifi_tclMsgGetAddressFormatTableMethodResult(const lifi_tclMsgGetAddressFormatTableMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_AddressTemplate, std::allocator<fi_tcl_AddressTemplate> > Templates;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgGetAddressFormatTableMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_GETADDRESSFORMATTABLEMETHODRESULT;}
};

class lifi_tclMsgDestinationInputInProgressGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgDestinationInputInProgressGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgDestinationInputInProgressGet& operator=(const lifi_tclMsgDestinationInputInProgressGet& coRef);
   lifi_tclMsgDestinationInputInProgressGet(const lifi_tclMsgDestinationInputInProgressGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgDestinationInputInProgressGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_DESTINATIONINPUTINPROGRESSGET;}
};

class lifi_tclMsgDestinationInputInProgressStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgDestinationInputInProgressStatus():DestinationInputIsInProgress(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgDestinationInputInProgressStatus& operator=(const lifi_tclMsgDestinationInputInProgressStatus& coRef);
   lifi_tclMsgDestinationInputInProgressStatus(const lifi_tclMsgDestinationInputInProgressStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool DestinationInputIsInProgress;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgDestinationInputInProgressStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_DESTINATIONINPUTINPROGRESSSTATUS;}
};

class lifi_tclMsgEngineeringTextGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgEngineeringTextGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgEngineeringTextGet& operator=(const lifi_tclMsgEngineeringTextGet& coRef);
   lifi_tclMsgEngineeringTextGet(const lifi_tclMsgEngineeringTextGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgEngineeringTextGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_ENGINEERINGTEXTGET;}
};

class lifi_tclMsgEngineeringTextUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgEngineeringTextUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgEngineeringTextUpReg& operator=(const lifi_tclMsgEngineeringTextUpReg& coRef);
   lifi_tclMsgEngineeringTextUpReg(const lifi_tclMsgEngineeringTextUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgEngineeringTextUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG;}
};

class lifi_tclMsgEngineeringTextRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgEngineeringTextRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgEngineeringTextRelUpReg& operator=(const lifi_tclMsgEngineeringTextRelUpReg& coRef);
   lifi_tclMsgEngineeringTextRelUpReg(const lifi_tclMsgEngineeringTextRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgEngineeringTextRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG;}
};

class lifi_tclMsgEngineeringTextStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgEngineeringTextStatus():Message() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgEngineeringTextStatus& operator=(const lifi_tclMsgEngineeringTextStatus& coRef);
   lifi_tclMsgEngineeringTextStatus(const lifi_tclMsgEngineeringTextStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString Message;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgEngineeringTextStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS;}
};

class lifi_tclMsgUsedDatasetGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgUsedDatasetGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgUsedDatasetGet& operator=(const lifi_tclMsgUsedDatasetGet& coRef);
   lifi_tclMsgUsedDatasetGet(const lifi_tclMsgUsedDatasetGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgUsedDatasetGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_USEDDATASETGET;}
};

class lifi_tclMsgUsedDatasetUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgUsedDatasetUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgUsedDatasetUpReg& operator=(const lifi_tclMsgUsedDatasetUpReg& coRef);
   lifi_tclMsgUsedDatasetUpReg(const lifi_tclMsgUsedDatasetUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgUsedDatasetUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_USEDDATASETUPREG;}
};

class lifi_tclMsgUsedDatasetRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgUsedDatasetRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgUsedDatasetRelUpReg& operator=(const lifi_tclMsgUsedDatasetRelUpReg& coRef);
   lifi_tclMsgUsedDatasetRelUpReg(const lifi_tclMsgUsedDatasetRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgUsedDatasetRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_USEDDATASETRELUPREG;}
};

class lifi_tclMsgUsedDatasetStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgUsedDatasetStatus():MediaId(),DataSetId() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgUsedDatasetStatus& operator=(const lifi_tclMsgUsedDatasetStatus& coRef);
   lifi_tclMsgUsedDatasetStatus(const lifi_tclMsgUsedDatasetStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_MediaId MediaId;
   fi_tcl_u32_DataSetId DataSetId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgUsedDatasetStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_USEDDATASETSTATUS;}
};

class lifi_tclMsgCurrentSearchProgressGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgCurrentSearchProgressGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgCurrentSearchProgressGet& operator=(const lifi_tclMsgCurrentSearchProgressGet& coRef);
   lifi_tclMsgCurrentSearchProgressGet(const lifi_tclMsgCurrentSearchProgressGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgCurrentSearchProgressGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_CURRENTSEARCHPROGRESSGET;}
};

class lifi_tclMsgCurrentSearchProgressUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgCurrentSearchProgressUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgCurrentSearchProgressUpReg& operator=(const lifi_tclMsgCurrentSearchProgressUpReg& coRef);
   lifi_tclMsgCurrentSearchProgressUpReg(const lifi_tclMsgCurrentSearchProgressUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgCurrentSearchProgressUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_CURRENTSEARCHPROGRESSUPREG;}
};

class lifi_tclMsgCurrentSearchProgressRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgCurrentSearchProgressRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgCurrentSearchProgressRelUpReg& operator=(const lifi_tclMsgCurrentSearchProgressRelUpReg& coRef);
   lifi_tclMsgCurrentSearchProgressRelUpReg(const lifi_tclMsgCurrentSearchProgressRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgCurrentSearchProgressRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_CURRENTSEARCHPROGRESSRELUPREG;}
};

class lifi_tclMsgCurrentSearchProgressStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   lifi_tclMsgCurrentSearchProgressStatus():Radius(),UILanguage(),ElementList(),LocationDescription() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lifi_tclMsgCurrentSearchProgressStatus& operator=(const lifi_tclMsgCurrentSearchProgressStatus& coRef);
   lifi_tclMsgCurrentSearchProgressStatus(const lifi_tclMsgCurrentSearchProgressStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_s32_Meter Radius;
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_LocationValueListUnion ElementList;
   fi_tcl_LocationDescription LocationDescription;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const lifi_tclMsgCurrentSearchProgressStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return lifi_tclToken::EN_MSG_CURRENTSEARCHPROGRESSSTATUS;}
};


#endif
