/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetSelectionCriteriaDescriptionMethodStart::lifi_tclMsgGetSelectionCriteriaDescriptionMethodStart(const lifi_tclMsgGetSelectionCriteriaDescriptionMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   SelectionCriteria = coRef.SelectionCriteria;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetSelectionCriteriaDescriptionMethodStart& lifi_tclMsgGetSelectionCriteriaDescriptionMethodStart::operator=(const lifi_tclMsgGetSelectionCriteriaDescriptionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   SelectionCriteria = coRef.SelectionCriteria;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgGetSelectionCriteriaDescriptionMethodStart::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgGetSelectionCriteriaDescriptionMethodStart::u16GetFunctionID() const {return LIFI_C_U16_GETSELECTIONCRITERIADESCRIPTION;}
tU8 lifi_tclMsgGetSelectionCriteriaDescriptionMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid lifi_tclMsgGetSelectionCriteriaDescriptionMethodStart::vDestroy()
{
   LocationDescription.vDestroy(); 
   SelectionCriteria.clear();
}

tU32 lifi_tclMsgGetSelectionCriteriaDescriptionMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+LocationDescription.u32GetSize(u16MajorVersion)+SelectionCriteria.size()*2;
}

tBool lifi_tclMsgGetSelectionCriteriaDescriptionMethodStart::operator==(const lifi_tclMsgGetSelectionCriteriaDescriptionMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
      bResult = bResult && (SelectionCriteria.size() == rfoCmp.SelectionCriteria.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SelectionCriteria.size()); ++u32Idx)
            bResult = bResult && (SelectionCriteria[u32Idx] == rfoCmp.SelectionCriteria[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& lifi_tclMsgGetSelectionCriteriaDescriptionMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   oIn >> LocationDescription;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      SelectionCriteria.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SelectionCriteria[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& lifi_tclMsgGetSelectionCriteriaDescriptionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << LocationDescription;
   oOut << (tU32)SelectionCriteria.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SelectionCriteria.size(); ++u32Idx)
         oOut << SelectionCriteria[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetSelectionCriteriaDescriptionMethodResult::lifi_tclMsgGetSelectionCriteriaDescriptionMethodResult(const lifi_tclMsgGetSelectionCriteriaDescriptionMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   SelectionCriteriaDescription = coRef.SelectionCriteriaDescription;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetSelectionCriteriaDescriptionMethodResult& lifi_tclMsgGetSelectionCriteriaDescriptionMethodResult::operator=(const lifi_tclMsgGetSelectionCriteriaDescriptionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   SelectionCriteriaDescription = coRef.SelectionCriteriaDescription;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgGetSelectionCriteriaDescriptionMethodResult::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgGetSelectionCriteriaDescriptionMethodResult::u16GetFunctionID() const {return LIFI_C_U16_GETSELECTIONCRITERIADESCRIPTION;}
tU8 lifi_tclMsgGetSelectionCriteriaDescriptionMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid lifi_tclMsgGetSelectionCriteriaDescriptionMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SelectionCriteriaDescription.size(); ++u32Idx)
         SelectionCriteriaDescription[u32Idx].vDestroy();
   }
   SelectionCriteriaDescription.clear();
}

tU32 lifi_tclMsgGetSelectionCriteriaDescriptionMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SelectionCriteriaDescription.size(); ++u32ListIdx)
      u32DynamicSize += SelectionCriteriaDescription[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

tBool lifi_tclMsgGetSelectionCriteriaDescriptionMethodResult::operator==(const lifi_tclMsgGetSelectionCriteriaDescriptionMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (SelectionCriteriaDescription.size() == rfoCmp.SelectionCriteriaDescription.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SelectionCriteriaDescription.size()); ++u32Idx)
            bResult = bResult && (SelectionCriteriaDescription[u32Idx] == rfoCmp.SelectionCriteriaDescription[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& lifi_tclMsgGetSelectionCriteriaDescriptionMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SelectionCriteriaDescription.size(); ++u32Idx)
      {
         SelectionCriteriaDescription[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SelectionCriteriaDescription.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SelectionCriteriaDescription[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& lifi_tclMsgGetSelectionCriteriaDescriptionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << (tU32)SelectionCriteriaDescription.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SelectionCriteriaDescription.size(); ++u32Idx)
         oOut << SelectionCriteriaDescription[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetSelectionCriteriaMethodStart::lifi_tclMsgGetSelectionCriteriaMethodStart(const lifi_tclMsgGetSelectionCriteriaMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   LocationDescription = coRef.LocationDescription;
   UILanguage = coRef.UILanguage;
   GetOption = coRef.GetOption;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetSelectionCriteriaMethodStart& lifi_tclMsgGetSelectionCriteriaMethodStart::operator=(const lifi_tclMsgGetSelectionCriteriaMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LocationDescription = coRef.LocationDescription;
   UILanguage = coRef.UILanguage;
   GetOption = coRef.GetOption;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgGetSelectionCriteriaMethodStart::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgGetSelectionCriteriaMethodStart::u16GetFunctionID() const {return LIFI_C_U16_GETSELECTIONCRITERIA;}
tU8 lifi_tclMsgGetSelectionCriteriaMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid lifi_tclMsgGetSelectionCriteriaMethodStart::vDestroy()
{
   LocationDescription.vDestroy(); 
}

tU32 lifi_tclMsgGetSelectionCriteriaMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (19 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+2+LocationDescription.u32GetSize(u16MajorVersion);
}

tBool lifi_tclMsgGetSelectionCriteriaMethodStart::operator==(const lifi_tclMsgGetSelectionCriteriaMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (GetOption == rfoCmp.GetOption);
   return bResult;
}

fi_tclInContext& lifi_tclMsgGetSelectionCriteriaMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> LocationDescription;
   oIn >> UILanguage;
   if (19 <= oIn.u16GetMajorVersion())
   {
      oIn >> GetOption;
   }
   return oIn;
}

fi_tclOutContext& lifi_tclMsgGetSelectionCriteriaMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << LocationDescription;
   oOut << UILanguage;
   if (19 <= oOut.u16GetMajorVersion())
   {
      oOut << GetOption;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetSelectionCriteriaMethodResult::lifi_tclMsgGetSelectionCriteriaMethodResult(const lifi_tclMsgGetSelectionCriteriaMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   SelectionCriteriaList = coRef.SelectionCriteriaList;
   DatabaseIncomplete = coRef.DatabaseIncomplete;
   UILanguage = coRef.UILanguage;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetSelectionCriteriaMethodResult& lifi_tclMsgGetSelectionCriteriaMethodResult::operator=(const lifi_tclMsgGetSelectionCriteriaMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SelectionCriteriaList = coRef.SelectionCriteriaList;
   DatabaseIncomplete = coRef.DatabaseIncomplete;
   UILanguage = coRef.UILanguage;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgGetSelectionCriteriaMethodResult::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgGetSelectionCriteriaMethodResult::u16GetFunctionID() const {return LIFI_C_U16_GETSELECTIONCRITERIA;}
tU8 lifi_tclMsgGetSelectionCriteriaMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid lifi_tclMsgGetSelectionCriteriaMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SelectionCriteriaList.size(); ++u32Idx)
         SelectionCriteriaList[u32Idx].vDestroy();
   }
   SelectionCriteriaList.clear();
}

tU32 lifi_tclMsgGetSelectionCriteriaMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SelectionCriteriaList.size(); ++u32ListIdx)
      u32DynamicSize += SelectionCriteriaList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+7;
}

tBool lifi_tclMsgGetSelectionCriteriaMethodResult::operator==(const lifi_tclMsgGetSelectionCriteriaMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SelectionCriteriaList.size() == rfoCmp.SelectionCriteriaList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SelectionCriteriaList.size()); ++u32Idx)
            bResult = bResult && (SelectionCriteriaList[u32Idx] == rfoCmp.SelectionCriteriaList[u32Idx]);
      }
      bResult = bResult && (DatabaseIncomplete == rfoCmp.DatabaseIncomplete);
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
   return bResult;
}

fi_tclInContext& lifi_tclMsgGetSelectionCriteriaMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SelectionCriteriaList.size(); ++u32Idx)
      {
         SelectionCriteriaList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SelectionCriteriaList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SelectionCriteriaList[u32Idx];
      }
   }
   oIn >> DatabaseIncomplete;
   oIn >> UILanguage;
   return oIn;
}

fi_tclOutContext& lifi_tclMsgGetSelectionCriteriaMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)SelectionCriteriaList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SelectionCriteriaList.size(); ++u32Idx)
         oOut << SelectionCriteriaList[u32Idx];
   }
   oOut << DatabaseIncomplete;
   oOut << UILanguage;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgTransformLocationDescriptionMethodStart::lifi_tclMsgTransformLocationDescriptionMethodStart(const lifi_tclMsgTransformLocationDescriptionMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   Mode = coRef.Mode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgTransformLocationDescriptionMethodStart& lifi_tclMsgTransformLocationDescriptionMethodStart::operator=(const lifi_tclMsgTransformLocationDescriptionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   Mode = coRef.Mode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgTransformLocationDescriptionMethodStart::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgTransformLocationDescriptionMethodStart::u16GetFunctionID() const {return LIFI_C_U16_TRANSFORMLOCATIONDESCRIPTION;}
tU8 lifi_tclMsgTransformLocationDescriptionMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid lifi_tclMsgTransformLocationDescriptionMethodStart::vDestroy()
{
   LocationDescription.vDestroy(); 
}

tU32 lifi_tclMsgTransformLocationDescriptionMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+LocationDescription.u32GetSize(u16MajorVersion);
}

tBool lifi_tclMsgTransformLocationDescriptionMethodStart::operator==(const lifi_tclMsgTransformLocationDescriptionMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
      bResult = bResult && (Mode == rfoCmp.Mode);
   return bResult;
}

fi_tclInContext& lifi_tclMsgTransformLocationDescriptionMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   oIn >> LocationDescription;
   oIn >> Mode;
   return oIn;
}

fi_tclOutContext& lifi_tclMsgTransformLocationDescriptionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << LocationDescription;
   oOut << Mode;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgTransformLocationDescriptionMethodResult::lifi_tclMsgTransformLocationDescriptionMethodResult(const lifi_tclMsgTransformLocationDescriptionMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgTransformLocationDescriptionMethodResult& lifi_tclMsgTransformLocationDescriptionMethodResult::operator=(const lifi_tclMsgTransformLocationDescriptionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgTransformLocationDescriptionMethodResult::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgTransformLocationDescriptionMethodResult::u16GetFunctionID() const {return LIFI_C_U16_TRANSFORMLOCATIONDESCRIPTION;}
tU8 lifi_tclMsgTransformLocationDescriptionMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid lifi_tclMsgTransformLocationDescriptionMethodResult::vDestroy()
{
   LocationDescription.vDestroy(); 
}

tU32 lifi_tclMsgTransformLocationDescriptionMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+LocationDescription.u32GetSize(u16MajorVersion);
}

tBool lifi_tclMsgTransformLocationDescriptionMethodResult::operator==(const lifi_tclMsgTransformLocationDescriptionMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
   return bResult;
}

fi_tclInContext& lifi_tclMsgTransformLocationDescriptionMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   oIn >> LocationDescription;
   return oIn;
}

fi_tclOutContext& lifi_tclMsgTransformLocationDescriptionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << LocationDescription;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetElementCountMethodStart::lifi_tclMsgGetElementCountMethodStart(const lifi_tclMsgGetElementCountMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   LocationDescription = coRef.LocationDescription;
   Limit = coRef.Limit;
   AttributeCodes = coRef.AttributeCodes;
   UILanguage = coRef.UILanguage;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetElementCountMethodStart& lifi_tclMsgGetElementCountMethodStart::operator=(const lifi_tclMsgGetElementCountMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LocationDescription = coRef.LocationDescription;
   Limit = coRef.Limit;
   AttributeCodes = coRef.AttributeCodes;
   UILanguage = coRef.UILanguage;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgGetElementCountMethodStart::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgGetElementCountMethodStart::u16GetFunctionID() const {return LIFI_C_U16_GETELEMENTCOUNT;}
tU8 lifi_tclMsgGetElementCountMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid lifi_tclMsgGetElementCountMethodStart::vDestroy()
{
   LocationDescription.vDestroy(); 
   AttributeCodes.clear();
}

tU32 lifi_tclMsgGetElementCountMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 10+LocationDescription.u32GetSize(u16MajorVersion)+AttributeCodes.size()*2;
}

tBool lifi_tclMsgGetElementCountMethodStart::operator==(const lifi_tclMsgGetElementCountMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
      bResult = bResult && (Limit == rfoCmp.Limit);
      bResult = bResult && (AttributeCodes.size() == rfoCmp.AttributeCodes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AttributeCodes.size()); ++u32Idx)
            bResult = bResult && (AttributeCodes[u32Idx] == rfoCmp.AttributeCodes[u32Idx]);
      }
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
   return bResult;
}

fi_tclInContext& lifi_tclMsgGetElementCountMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> LocationDescription;
   oIn >> Limit;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      AttributeCodes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AttributeCodes[u32Idx];
      }
   }
   oIn >> UILanguage;
   return oIn;
}

fi_tclOutContext& lifi_tclMsgGetElementCountMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << LocationDescription;
   oOut << Limit;
   oOut << (tU32)AttributeCodes.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AttributeCodes.size(); ++u32Idx)
         oOut << AttributeCodes[u32Idx];
   }
   oOut << UILanguage;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetElementCountMethodResult::lifi_tclMsgGetElementCountMethodResult(const lifi_tclMsgGetElementCountMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Count = coRef.Count;
   UILanguage = coRef.UILanguage;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetElementCountMethodResult& lifi_tclMsgGetElementCountMethodResult::operator=(const lifi_tclMsgGetElementCountMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Count = coRef.Count;
   UILanguage = coRef.UILanguage;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgGetElementCountMethodResult::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgGetElementCountMethodResult::u16GetFunctionID() const {return LIFI_C_U16_GETELEMENTCOUNT;}
tU8 lifi_tclMsgGetElementCountMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 lifi_tclMsgGetElementCountMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

tBool lifi_tclMsgGetElementCountMethodResult::operator==(const lifi_tclMsgGetElementCountMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Count == rfoCmp.Count);
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
   return bResult;
}

fi_tclInContext& lifi_tclMsgGetElementCountMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> Count;
   oIn >> UILanguage;
   return oIn;
}

fi_tclOutContext& lifi_tclMsgGetElementCountMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Count;
   oOut << UILanguage;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetElementNameListMethodStart::lifi_tclMsgGetElementNameListMethodStart(const lifi_tclMsgGetElementNameListMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   Limit = coRef.Limit;
   GetOption = coRef.GetOption;
   SortOption = coRef.SortOption;
   ListOffset = coRef.ListOffset;
   AttributeCodes = coRef.AttributeCodes;
   NoMatchingChars = coRef.NoMatchingChars;
   MaxRadius = coRef.MaxRadius;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetElementNameListMethodStart& lifi_tclMsgGetElementNameListMethodStart::operator=(const lifi_tclMsgGetElementNameListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   Limit = coRef.Limit;
   GetOption = coRef.GetOption;
   SortOption = coRef.SortOption;
   ListOffset = coRef.ListOffset;
   AttributeCodes = coRef.AttributeCodes;
   NoMatchingChars = coRef.NoMatchingChars;
   MaxRadius = coRef.MaxRadius;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgGetElementNameListMethodStart::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgGetElementNameListMethodStart::u16GetFunctionID() const {return LIFI_C_U16_GETELEMENTNAMELIST;}
tU8 lifi_tclMsgGetElementNameListMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid lifi_tclMsgGetElementNameListMethodStart::vDestroy()
{
   LocationDescription.vDestroy(); 
   AttributeCodes.clear();
}

tU32 lifi_tclMsgGetElementNameListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (15 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (19 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+16+LocationDescription.u32GetSize(u16MajorVersion)+AttributeCodes.size()*2;
}

tBool lifi_tclMsgGetElementNameListMethodStart::operator==(const lifi_tclMsgGetElementNameListMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
      bResult = bResult && (Limit == rfoCmp.Limit);
      bResult = bResult && (GetOption == rfoCmp.GetOption);
      bResult = bResult && (SortOption == rfoCmp.SortOption);
      bResult = bResult && (ListOffset == rfoCmp.ListOffset);
      bResult = bResult && (AttributeCodes.size() == rfoCmp.AttributeCodes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AttributeCodes.size()); ++u32Idx)
            bResult = bResult && (AttributeCodes[u32Idx] == rfoCmp.AttributeCodes[u32Idx]);
      }
      bResult = bResult && (NoMatchingChars == rfoCmp.NoMatchingChars);
      bResult = bResult && (MaxRadius == rfoCmp.MaxRadius);
   return bResult;
}

fi_tclInContext& lifi_tclMsgGetElementNameListMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   oIn >> LocationDescription;
   oIn >> Limit;
   oIn >> GetOption;
   oIn >> SortOption;
   oIn >> ListOffset;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      AttributeCodes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AttributeCodes[u32Idx];
      }
   }
   if (15 <= oIn.u16GetMajorVersion())
   {
      oIn >> NoMatchingChars;
   }
   if (19 <= oIn.u16GetMajorVersion())
   {
      oIn >> MaxRadius;
   }
   return oIn;
}

fi_tclOutContext& lifi_tclMsgGetElementNameListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << LocationDescription;
   oOut << Limit;
   oOut << GetOption;
   oOut << SortOption;
   oOut << ListOffset;
   oOut << (tU32)AttributeCodes.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AttributeCodes.size(); ++u32Idx)
         oOut << AttributeCodes[u32Idx];
   }
   if (15 <= oOut.u16GetMajorVersion())
   {
      oOut << NoMatchingChars;
   }
   if (19 <= oOut.u16GetMajorVersion())
   {
      oOut << MaxRadius;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetElementNameListMethodResult::lifi_tclMsgGetElementNameListMethodResult(const lifi_tclMsgGetElementNameListMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   ResultOption = coRef.ResultOption;
   ElementList = coRef.ElementList;
   LocationDescription = coRef.LocationDescription;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetElementNameListMethodResult& lifi_tclMsgGetElementNameListMethodResult::operator=(const lifi_tclMsgGetElementNameListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   ResultOption = coRef.ResultOption;
   ElementList = coRef.ElementList;
   LocationDescription = coRef.LocationDescription;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgGetElementNameListMethodResult::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgGetElementNameListMethodResult::u16GetFunctionID() const {return LIFI_C_U16_GETELEMENTNAMELIST;}
tU8 lifi_tclMsgGetElementNameListMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid lifi_tclMsgGetElementNameListMethodResult::vDestroy()
{
   ElementList.vDestroy(); 
   LocationDescription.vDestroy(); 
}

tU32 lifi_tclMsgGetElementNameListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (19 <= u16MajorVersion)
   {
      u32DynamicSize += LocationDescription.u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+3+ElementList.u32GetSize(u16MajorVersion);
}

tBool lifi_tclMsgGetElementNameListMethodResult::operator==(const lifi_tclMsgGetElementNameListMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (ResultOption == rfoCmp.ResultOption);
      bResult = bResult && (ElementList == rfoCmp.ElementList);
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
   return bResult;
}

fi_tclInContext& lifi_tclMsgGetElementNameListMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   oIn >> ResultOption;
   oIn >> ElementList;
   if (19 <= oIn.u16GetMajorVersion())
   {
      oIn >> LocationDescription;
   }
   return oIn;
}

fi_tclOutContext& lifi_tclMsgGetElementNameListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << ResultOption;
   oOut << ElementList;
   if (19 <= oOut.u16GetMajorVersion())
   {
      oOut << LocationDescription;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetSpellerCharactersMethodStart::lifi_tclMsgGetSpellerCharactersMethodStart(const lifi_tclMsgGetSpellerCharactersMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   AttributeCodes = coRef.AttributeCodes;
   PartialNameRotation = coRef.PartialNameRotation;
   LowerCaseLetters = coRef.LowerCaseLetters;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetSpellerCharactersMethodStart& lifi_tclMsgGetSpellerCharactersMethodStart::operator=(const lifi_tclMsgGetSpellerCharactersMethodStart& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   AttributeCodes = coRef.AttributeCodes;
   PartialNameRotation = coRef.PartialNameRotation;
   LowerCaseLetters = coRef.LowerCaseLetters;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgGetSpellerCharactersMethodStart::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgGetSpellerCharactersMethodStart::u16GetFunctionID() const {return LIFI_C_U16_GETSPELLERCHARACTERS;}
tU8 lifi_tclMsgGetSpellerCharactersMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid lifi_tclMsgGetSpellerCharactersMethodStart::vDestroy()
{
   LocationDescription.vDestroy(); 
   AttributeCodes.clear();
}

tU32 lifi_tclMsgGetSpellerCharactersMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (13 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+7+LocationDescription.u32GetSize(u16MajorVersion)+AttributeCodes.size()*2;
}

tBool lifi_tclMsgGetSpellerCharactersMethodStart::operator==(const lifi_tclMsgGetSpellerCharactersMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
      bResult = bResult && (AttributeCodes.size() == rfoCmp.AttributeCodes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AttributeCodes.size()); ++u32Idx)
            bResult = bResult && (AttributeCodes[u32Idx] == rfoCmp.AttributeCodes[u32Idx]);
      }
      bResult = bResult && (PartialNameRotation == rfoCmp.PartialNameRotation);
      bResult = bResult && (LowerCaseLetters == rfoCmp.LowerCaseLetters);
   return bResult;
}

fi_tclInContext& lifi_tclMsgGetSpellerCharactersMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   oIn >> LocationDescription;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      AttributeCodes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AttributeCodes[u32Idx];
      }
   }
   oIn >> PartialNameRotation;
   if (13 <= oIn.u16GetMajorVersion())
   {
      oIn >> LowerCaseLetters;
   }
   return oIn;
}

fi_tclOutContext& lifi_tclMsgGetSpellerCharactersMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << LocationDescription;
   oOut << (tU32)AttributeCodes.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AttributeCodes.size(); ++u32Idx)
         oOut << AttributeCodes[u32Idx];
   }
   oOut << PartialNameRotation;
   if (13 <= oOut.u16GetMajorVersion())
   {
      oOut << LowerCaseLetters;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetSpellerCharactersMethodResult::lifi_tclMsgGetSpellerCharactersMethodResult(const lifi_tclMsgGetSpellerCharactersMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   UniqueCharacters = coRef.UniqueCharacters;
   ValidCharacters = coRef.ValidCharacters;
   FullMatch = coRef.FullMatch;
   MatchingElements = coRef.MatchingElements;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetSpellerCharactersMethodResult& lifi_tclMsgGetSpellerCharactersMethodResult::operator=(const lifi_tclMsgGetSpellerCharactersMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   UniqueCharacters = coRef.UniqueCharacters;
   ValidCharacters = coRef.ValidCharacters;
   FullMatch = coRef.FullMatch;
   MatchingElements = coRef.MatchingElements;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgGetSpellerCharactersMethodResult::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgGetSpellerCharactersMethodResult::u16GetFunctionID() const {return LIFI_C_U16_GETSPELLERCHARACTERS;}
tU8 lifi_tclMsgGetSpellerCharactersMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid lifi_tclMsgGetSpellerCharactersMethodResult::vDestroy()
{
   UniqueCharacters.vDestroy();
   ValidCharacters.vDestroy();
}

tU32 lifi_tclMsgGetSpellerCharactersMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+UniqueCharacters.u32GetSize(u16MajorVersion)+ValidCharacters.u32GetSize(u16MajorVersion);
}

tBool lifi_tclMsgGetSpellerCharactersMethodResult::operator==(const lifi_tclMsgGetSpellerCharactersMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (UniqueCharacters == rfoCmp.UniqueCharacters);
      bResult = bResult && (ValidCharacters == rfoCmp.ValidCharacters);
      bResult = bResult && (FullMatch == rfoCmp.FullMatch);
      bResult = bResult && (MatchingElements == rfoCmp.MatchingElements);
   return bResult;
}

fi_tclInContext& lifi_tclMsgGetSpellerCharactersMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   oIn >> UniqueCharacters;
   oIn >> ValidCharacters;
   oIn >> FullMatch;
   oIn >> MatchingElements;
   return oIn;
}

fi_tclOutContext& lifi_tclMsgGetSpellerCharactersMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << UniqueCharacters;
   oOut << ValidCharacters;
   oOut << FullMatch;
   oOut << MatchingElements;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetDetailedElementDescriptionMethodStart::lifi_tclMsgGetDetailedElementDescriptionMethodStart(const lifi_tclMsgGetDetailedElementDescriptionMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetDetailedElementDescriptionMethodStart& lifi_tclMsgGetDetailedElementDescriptionMethodStart::operator=(const lifi_tclMsgGetDetailedElementDescriptionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgGetDetailedElementDescriptionMethodStart::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgGetDetailedElementDescriptionMethodStart::u16GetFunctionID() const {return LIFI_C_U16_GETDETAILEDELEMENTDESCRIPTION;}
tU8 lifi_tclMsgGetDetailedElementDescriptionMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid lifi_tclMsgGetDetailedElementDescriptionMethodStart::vDestroy()
{
   LocationDescription.vDestroy(); 
}

tU32 lifi_tclMsgGetDetailedElementDescriptionMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+LocationDescription.u32GetSize(u16MajorVersion);
}

tBool lifi_tclMsgGetDetailedElementDescriptionMethodStart::operator==(const lifi_tclMsgGetDetailedElementDescriptionMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
   return bResult;
}

fi_tclInContext& lifi_tclMsgGetDetailedElementDescriptionMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   oIn >> LocationDescription;
   return oIn;
}

fi_tclOutContext& lifi_tclMsgGetDetailedElementDescriptionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << LocationDescription;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetDetailedElementDescriptionMethodResult::lifi_tclMsgGetDetailedElementDescriptionMethodResult(const lifi_tclMsgGetDetailedElementDescriptionMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   Descriptions = coRef.Descriptions;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetDetailedElementDescriptionMethodResult& lifi_tclMsgGetDetailedElementDescriptionMethodResult::operator=(const lifi_tclMsgGetDetailedElementDescriptionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   Descriptions = coRef.Descriptions;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgGetDetailedElementDescriptionMethodResult::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgGetDetailedElementDescriptionMethodResult::u16GetFunctionID() const {return LIFI_C_U16_GETDETAILEDELEMENTDESCRIPTION;}
tU8 lifi_tclMsgGetDetailedElementDescriptionMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid lifi_tclMsgGetDetailedElementDescriptionMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Descriptions.size(); ++u32Idx)
         Descriptions[u32Idx].vDestroy();
   }
   Descriptions.clear();
}

tU32 lifi_tclMsgGetDetailedElementDescriptionMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Descriptions.size(); ++u32ListIdx)
      u32DynamicSize += Descriptions[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

tBool lifi_tclMsgGetDetailedElementDescriptionMethodResult::operator==(const lifi_tclMsgGetDetailedElementDescriptionMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (Descriptions.size() == rfoCmp.Descriptions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Descriptions.size()); ++u32Idx)
            bResult = bResult && (Descriptions[u32Idx] == rfoCmp.Descriptions[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& lifi_tclMsgGetDetailedElementDescriptionMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Descriptions.size(); ++u32Idx)
      {
         Descriptions[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Descriptions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Descriptions[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& lifi_tclMsgGetDetailedElementDescriptionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << (tU32)Descriptions.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Descriptions.size(); ++u32Idx)
         oOut << Descriptions[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetAttributeHierarchyMethodStart::lifi_tclMsgGetAttributeHierarchyMethodStart(const lifi_tclMsgGetAttributeHierarchyMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetAttributeHierarchyMethodStart& lifi_tclMsgGetAttributeHierarchyMethodStart::operator=(const lifi_tclMsgGetAttributeHierarchyMethodStart& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgGetAttributeHierarchyMethodStart::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgGetAttributeHierarchyMethodStart::u16GetFunctionID() const {return LIFI_C_U16_GETATTRIBUTEHIERARCHY;}
tU8 lifi_tclMsgGetAttributeHierarchyMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid lifi_tclMsgGetAttributeHierarchyMethodStart::vDestroy()
{
   LocationDescription.vDestroy(); 
}

tU32 lifi_tclMsgGetAttributeHierarchyMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+LocationDescription.u32GetSize(u16MajorVersion);
}

tBool lifi_tclMsgGetAttributeHierarchyMethodStart::operator==(const lifi_tclMsgGetAttributeHierarchyMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
   return bResult;
}

fi_tclInContext& lifi_tclMsgGetAttributeHierarchyMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   oIn >> LocationDescription;
   return oIn;
}

fi_tclOutContext& lifi_tclMsgGetAttributeHierarchyMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << LocationDescription;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetAttributeHierarchyMethodResult::lifi_tclMsgGetAttributeHierarchyMethodResult(const lifi_tclMsgGetAttributeHierarchyMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   List = coRef.List;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetAttributeHierarchyMethodResult& lifi_tclMsgGetAttributeHierarchyMethodResult::operator=(const lifi_tclMsgGetAttributeHierarchyMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   List = coRef.List;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgGetAttributeHierarchyMethodResult::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgGetAttributeHierarchyMethodResult::u16GetFunctionID() const {return LIFI_C_U16_GETATTRIBUTEHIERARCHY;}
tU8 lifi_tclMsgGetAttributeHierarchyMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid lifi_tclMsgGetAttributeHierarchyMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < List.size(); ++u32Idx)
         List[u32Idx].vDestroy();
   }
   List.clear();
}

tU32 lifi_tclMsgGetAttributeHierarchyMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < List.size(); ++u32ListIdx)
      u32DynamicSize += List[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

tBool lifi_tclMsgGetAttributeHierarchyMethodResult::operator==(const lifi_tclMsgGetAttributeHierarchyMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (List.size() == rfoCmp.List.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < List.size()); ++u32Idx)
            bResult = bResult && (List[u32Idx] == rfoCmp.List[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& lifi_tclMsgGetAttributeHierarchyMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < List.size(); ++u32Idx)
      {
         List[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      List.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> List[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& lifi_tclMsgGetAttributeHierarchyMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << (tU32)List.size();
   {
      for (tU32 u32Idx = 0; u32Idx < List.size(); ++u32Idx)
         oOut << List[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetAvailableUILanguagesMethodStart::lifi_tclMsgGetAvailableUILanguagesMethodStart(const lifi_tclMsgGetAvailableUILanguagesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   LocationDescription = coRef.LocationDescription;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetAvailableUILanguagesMethodStart& lifi_tclMsgGetAvailableUILanguagesMethodStart::operator=(const lifi_tclMsgGetAvailableUILanguagesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LocationDescription = coRef.LocationDescription;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgGetAvailableUILanguagesMethodStart::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgGetAvailableUILanguagesMethodStart::u16GetFunctionID() const {return LIFI_C_U16_GETAVAILABLEUILANGUAGES;}
tU8 lifi_tclMsgGetAvailableUILanguagesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid lifi_tclMsgGetAvailableUILanguagesMethodStart::vDestroy()
{
   LocationDescription.vDestroy(); 
}

tU32 lifi_tclMsgGetAvailableUILanguagesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+LocationDescription.u32GetSize(u16MajorVersion);
}

tBool lifi_tclMsgGetAvailableUILanguagesMethodStart::operator==(const lifi_tclMsgGetAvailableUILanguagesMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
   return bResult;
}

fi_tclInContext& lifi_tclMsgGetAvailableUILanguagesMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> LocationDescription;
   return oIn;
}

fi_tclOutContext& lifi_tclMsgGetAvailableUILanguagesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << LocationDescription;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetAvailableUILanguagesMethodResult::lifi_tclMsgGetAvailableUILanguagesMethodResult(const lifi_tclMsgGetAvailableUILanguagesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   LanguageList = coRef.LanguageList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetAvailableUILanguagesMethodResult& lifi_tclMsgGetAvailableUILanguagesMethodResult::operator=(const lifi_tclMsgGetAvailableUILanguagesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   LanguageList = coRef.LanguageList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgGetAvailableUILanguagesMethodResult::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgGetAvailableUILanguagesMethodResult::u16GetFunctionID() const {return LIFI_C_U16_GETAVAILABLEUILANGUAGES;}
tU8 lifi_tclMsgGetAvailableUILanguagesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid lifi_tclMsgGetAvailableUILanguagesMethodResult::vDestroy()
{
   LanguageList.clear();
}

tU32 lifi_tclMsgGetAvailableUILanguagesMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+LanguageList.size()*2;
}

tBool lifi_tclMsgGetAvailableUILanguagesMethodResult::operator==(const lifi_tclMsgGetAvailableUILanguagesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LanguageList.size() == rfoCmp.LanguageList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < LanguageList.size()); ++u32Idx)
            bResult = bResult && (LanguageList[u32Idx] == rfoCmp.LanguageList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& lifi_tclMsgGetAvailableUILanguagesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      LanguageList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> LanguageList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& lifi_tclMsgGetAvailableUILanguagesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)LanguageList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < LanguageList.size(); ++u32Idx)
         oOut << LanguageList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgTransformLocationDescriptionMatchedPosMethodStart::lifi_tclMsgTransformLocationDescriptionMatchedPosMethodStart(const lifi_tclMsgTransformLocationDescriptionMatchedPosMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   Mode = coRef.Mode;
   LocationBinContainerVersion = coRef.LocationBinContainerVersion;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgTransformLocationDescriptionMatchedPosMethodStart& lifi_tclMsgTransformLocationDescriptionMatchedPosMethodStart::operator=(const lifi_tclMsgTransformLocationDescriptionMatchedPosMethodStart& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   Mode = coRef.Mode;
   LocationBinContainerVersion = coRef.LocationBinContainerVersion;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgTransformLocationDescriptionMatchedPosMethodStart::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgTransformLocationDescriptionMatchedPosMethodStart::u16GetFunctionID() const {return LIFI_C_U16_TRANSFORMLOCATIONDESCRIPTIONMATCHEDPOS;}
tU8 lifi_tclMsgTransformLocationDescriptionMatchedPosMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid lifi_tclMsgTransformLocationDescriptionMatchedPosMethodStart::vDestroy()
{
   LocationDescription.vDestroy(); 
}

tU32 lifi_tclMsgTransformLocationDescriptionMatchedPosMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+3+LocationDescription.u32GetSize(u16MajorVersion);
}

tBool lifi_tclMsgTransformLocationDescriptionMatchedPosMethodStart::operator==(const lifi_tclMsgTransformLocationDescriptionMatchedPosMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
      bResult = bResult && (Mode == rfoCmp.Mode);
      bResult = bResult && (LocationBinContainerVersion == rfoCmp.LocationBinContainerVersion);
   return bResult;
}

fi_tclInContext& lifi_tclMsgTransformLocationDescriptionMatchedPosMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   oIn >> LocationDescription;
   oIn >> Mode;
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> LocationBinContainerVersion;
   }
   return oIn;
}

fi_tclOutContext& lifi_tclMsgTransformLocationDescriptionMatchedPosMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << LocationDescription;
   oOut << Mode;
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << LocationBinContainerVersion;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgTransformLocationDescriptionMatchedPosMethodResult::lifi_tclMsgTransformLocationDescriptionMatchedPosMethodResult(const lifi_tclMsgTransformLocationDescriptionMatchedPosMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   TransformedPosition = coRef.TransformedPosition;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgTransformLocationDescriptionMatchedPosMethodResult& lifi_tclMsgTransformLocationDescriptionMatchedPosMethodResult::operator=(const lifi_tclMsgTransformLocationDescriptionMatchedPosMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   TransformedPosition = coRef.TransformedPosition;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgTransformLocationDescriptionMatchedPosMethodResult::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgTransformLocationDescriptionMatchedPosMethodResult::u16GetFunctionID() const {return LIFI_C_U16_TRANSFORMLOCATIONDESCRIPTIONMATCHEDPOS;}
tU8 lifi_tclMsgTransformLocationDescriptionMatchedPosMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid lifi_tclMsgTransformLocationDescriptionMatchedPosMethodResult::vDestroy()
{
   LocationDescription.vDestroy(); 
   TransformedPosition.vDestroy(); 
}

tU32 lifi_tclMsgTransformLocationDescriptionMatchedPosMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 10+LocationDescription.u32GetSize(u16MajorVersion);
}

tBool lifi_tclMsgTransformLocationDescriptionMatchedPosMethodResult::operator==(const lifi_tclMsgTransformLocationDescriptionMatchedPosMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
      bResult = bResult && (TransformedPosition == rfoCmp.TransformedPosition);
   return bResult;
}

fi_tclInContext& lifi_tclMsgTransformLocationDescriptionMatchedPosMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   oIn >> LocationDescription;
   oIn >> TransformedPosition;
   return oIn;
}

fi_tclOutContext& lifi_tclMsgTransformLocationDescriptionMatchedPosMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << LocationDescription;
   oOut << TransformedPosition;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetAllSpellerCharactersMethodStart::lifi_tclMsgGetAllSpellerCharactersMethodStart(const lifi_tclMsgGetAllSpellerCharactersMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   LocationDescription = coRef.LocationDescription;
   UILanguage = coRef.UILanguage;
   AttributeCodes = coRef.AttributeCodes;
   LowerCaseLetters = coRef.LowerCaseLetters;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetAllSpellerCharactersMethodStart& lifi_tclMsgGetAllSpellerCharactersMethodStart::operator=(const lifi_tclMsgGetAllSpellerCharactersMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LocationDescription = coRef.LocationDescription;
   UILanguage = coRef.UILanguage;
   AttributeCodes = coRef.AttributeCodes;
   LowerCaseLetters = coRef.LowerCaseLetters;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgGetAllSpellerCharactersMethodStart::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgGetAllSpellerCharactersMethodStart::u16GetFunctionID() const {return LIFI_C_U16_GETALLSPELLERCHARACTERS;}
tU8 lifi_tclMsgGetAllSpellerCharactersMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid lifi_tclMsgGetAllSpellerCharactersMethodStart::vDestroy()
{
   LocationDescription.vDestroy(); 
   AttributeCodes.clear();
}

tU32 lifi_tclMsgGetAllSpellerCharactersMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (13 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (13 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      u32DynamicSize += AttributeCodes.size()*2;
   }
   if (13 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+0+LocationDescription.u32GetSize(u16MajorVersion);
}

tBool lifi_tclMsgGetAllSpellerCharactersMethodStart::operator==(const lifi_tclMsgGetAllSpellerCharactersMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (AttributeCodes.size() == rfoCmp.AttributeCodes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AttributeCodes.size()); ++u32Idx)
            bResult = bResult && (AttributeCodes[u32Idx] == rfoCmp.AttributeCodes[u32Idx]);
      }
      bResult = bResult && (LowerCaseLetters == rfoCmp.LowerCaseLetters);
   return bResult;
}

fi_tclInContext& lifi_tclMsgGetAllSpellerCharactersMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> LocationDescription;
   if (13 <= oIn.u16GetMajorVersion())
   {
      oIn >> UILanguage;
   }
   if (13 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
         oIn >> u32Length;
         AttributeCodes.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> AttributeCodes[u32Idx];
         }
      }
   }
   if (13 <= oIn.u16GetMajorVersion())
   {
      oIn >> LowerCaseLetters;
   }
   return oIn;
}

fi_tclOutContext& lifi_tclMsgGetAllSpellerCharactersMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << LocationDescription;
   if (13 <= oOut.u16GetMajorVersion())
   {
      oOut << UILanguage;
   }
   if (13 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)AttributeCodes.size();
      {
         for (tU32 u32Idx = 0; u32Idx < AttributeCodes.size(); ++u32Idx)
            oOut << AttributeCodes[u32Idx];
      }
   }
   if (13 <= oOut.u16GetMajorVersion())
   {
      oOut << LowerCaseLetters;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetAllSpellerCharactersMethodResult::lifi_tclMsgGetAllSpellerCharactersMethodResult(const lifi_tclMsgGetAllSpellerCharactersMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   ValidCharacters = coRef.ValidCharacters;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetAllSpellerCharactersMethodResult& lifi_tclMsgGetAllSpellerCharactersMethodResult::operator=(const lifi_tclMsgGetAllSpellerCharactersMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ValidCharacters = coRef.ValidCharacters;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgGetAllSpellerCharactersMethodResult::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgGetAllSpellerCharactersMethodResult::u16GetFunctionID() const {return LIFI_C_U16_GETALLSPELLERCHARACTERS;}
tU8 lifi_tclMsgGetAllSpellerCharactersMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid lifi_tclMsgGetAllSpellerCharactersMethodResult::vDestroy()
{
   ValidCharacters.vDestroy();
}

tU32 lifi_tclMsgGetAllSpellerCharactersMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+ValidCharacters.u32GetSize(u16MajorVersion);
}

tBool lifi_tclMsgGetAllSpellerCharactersMethodResult::operator==(const lifi_tclMsgGetAllSpellerCharactersMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ValidCharacters == rfoCmp.ValidCharacters);
   return bResult;
}

fi_tclInContext& lifi_tclMsgGetAllSpellerCharactersMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> ValidCharacters;
   return oIn;
}

fi_tclOutContext& lifi_tclMsgGetAllSpellerCharactersMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ValidCharacters;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetAddressFormatMethodStart::lifi_tclMsgGetAddressFormatMethodStart(const lifi_tclMsgGetAddressFormatMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   LocationDescription = coRef.LocationDescription;
   UILanguage = coRef.UILanguage;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetAddressFormatMethodStart& lifi_tclMsgGetAddressFormatMethodStart::operator=(const lifi_tclMsgGetAddressFormatMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LocationDescription = coRef.LocationDescription;
   UILanguage = coRef.UILanguage;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgGetAddressFormatMethodStart::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgGetAddressFormatMethodStart::u16GetFunctionID() const {return LIFI_C_U16_GETADDRESSFORMAT;}
tU8 lifi_tclMsgGetAddressFormatMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid lifi_tclMsgGetAddressFormatMethodStart::vDestroy()
{
   LocationDescription.vDestroy(); 
}

tU32 lifi_tclMsgGetAddressFormatMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+LocationDescription.u32GetSize(u16MajorVersion);
}

tBool lifi_tclMsgGetAddressFormatMethodStart::operator==(const lifi_tclMsgGetAddressFormatMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
   return bResult;
}

fi_tclInContext& lifi_tclMsgGetAddressFormatMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> LocationDescription;
   oIn >> UILanguage;
   return oIn;
}

fi_tclOutContext& lifi_tclMsgGetAddressFormatMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << LocationDescription;
   oOut << UILanguage;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetAddressFormatMethodResult::lifi_tclMsgGetAddressFormatMethodResult(const lifi_tclMsgGetAddressFormatMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   SelectionCriteriaList = coRef.SelectionCriteriaList;
   UILanguage = coRef.UILanguage;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetAddressFormatMethodResult& lifi_tclMsgGetAddressFormatMethodResult::operator=(const lifi_tclMsgGetAddressFormatMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SelectionCriteriaList = coRef.SelectionCriteriaList;
   UILanguage = coRef.UILanguage;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgGetAddressFormatMethodResult::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgGetAddressFormatMethodResult::u16GetFunctionID() const {return LIFI_C_U16_GETADDRESSFORMAT;}
tU8 lifi_tclMsgGetAddressFormatMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid lifi_tclMsgGetAddressFormatMethodResult::vDestroy()
{
   SelectionCriteriaList.clear();
}

tU32 lifi_tclMsgGetAddressFormatMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+SelectionCriteriaList.size()*2;
}

tBool lifi_tclMsgGetAddressFormatMethodResult::operator==(const lifi_tclMsgGetAddressFormatMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SelectionCriteriaList.size() == rfoCmp.SelectionCriteriaList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SelectionCriteriaList.size()); ++u32Idx)
            bResult = bResult && (SelectionCriteriaList[u32Idx] == rfoCmp.SelectionCriteriaList[u32Idx]);
      }
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
   return bResult;
}

fi_tclInContext& lifi_tclMsgGetAddressFormatMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      SelectionCriteriaList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SelectionCriteriaList[u32Idx];
      }
   }
   oIn >> UILanguage;
   return oIn;
}

fi_tclOutContext& lifi_tclMsgGetAddressFormatMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)SelectionCriteriaList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SelectionCriteriaList.size(); ++u32Idx)
         oOut << SelectionCriteriaList[u32Idx];
   }
   oOut << UILanguage;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetNearbyStatesOrCountriesMethodStart::lifi_tclMsgGetNearbyStatesOrCountriesMethodStart(const lifi_tclMsgGetNearbyStatesOrCountriesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   MaxRadius = coRef.MaxRadius;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetNearbyStatesOrCountriesMethodStart& lifi_tclMsgGetNearbyStatesOrCountriesMethodStart::operator=(const lifi_tclMsgGetNearbyStatesOrCountriesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   MaxRadius = coRef.MaxRadius;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgGetNearbyStatesOrCountriesMethodStart::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgGetNearbyStatesOrCountriesMethodStart::u16GetFunctionID() const {return LIFI_C_U16_GETNEARBYSTATESORCOUNTRIES;}
tU8 lifi_tclMsgGetNearbyStatesOrCountriesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid lifi_tclMsgGetNearbyStatesOrCountriesMethodStart::vDestroy()
{
   LocationDescription.vDestroy(); 
}

tU32 lifi_tclMsgGetNearbyStatesOrCountriesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+LocationDescription.u32GetSize(u16MajorVersion);
}

tBool lifi_tclMsgGetNearbyStatesOrCountriesMethodStart::operator==(const lifi_tclMsgGetNearbyStatesOrCountriesMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
      bResult = bResult && (MaxRadius == rfoCmp.MaxRadius);
   return bResult;
}

fi_tclInContext& lifi_tclMsgGetNearbyStatesOrCountriesMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   oIn >> LocationDescription;
   oIn >> MaxRadius;
   return oIn;
}

fi_tclOutContext& lifi_tclMsgGetNearbyStatesOrCountriesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << LocationDescription;
   oOut << MaxRadius;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetNearbyStatesOrCountriesMethodResult::lifi_tclMsgGetNearbyStatesOrCountriesMethodResult(const lifi_tclMsgGetNearbyStatesOrCountriesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   ElementList = coRef.ElementList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetNearbyStatesOrCountriesMethodResult& lifi_tclMsgGetNearbyStatesOrCountriesMethodResult::operator=(const lifi_tclMsgGetNearbyStatesOrCountriesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   ElementList = coRef.ElementList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgGetNearbyStatesOrCountriesMethodResult::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgGetNearbyStatesOrCountriesMethodResult::u16GetFunctionID() const {return LIFI_C_U16_GETNEARBYSTATESORCOUNTRIES;}
tU8 lifi_tclMsgGetNearbyStatesOrCountriesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid lifi_tclMsgGetNearbyStatesOrCountriesMethodResult::vDestroy()
{
   ElementList.vDestroy(); 
}

tU32 lifi_tclMsgGetNearbyStatesOrCountriesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+ElementList.u32GetSize(u16MajorVersion);
}

tBool lifi_tclMsgGetNearbyStatesOrCountriesMethodResult::operator==(const lifi_tclMsgGetNearbyStatesOrCountriesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (ElementList == rfoCmp.ElementList);
   return bResult;
}

fi_tclInContext& lifi_tclMsgGetNearbyStatesOrCountriesMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   oIn >> ElementList;
   return oIn;
}

fi_tclOutContext& lifi_tclMsgGetNearbyStatesOrCountriesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << ElementList;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetAddressFormatTableMethodStart::lifi_tclMsgGetAddressFormatTableMethodStart(const lifi_tclMsgGetAddressFormatTableMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetAddressFormatTableMethodStart& lifi_tclMsgGetAddressFormatTableMethodStart::operator=(const lifi_tclMsgGetAddressFormatTableMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgGetAddressFormatTableMethodStart::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgGetAddressFormatTableMethodStart::u16GetFunctionID() const {return LIFI_C_U16_GETADDRESSFORMATTABLE;}
tU8 lifi_tclMsgGetAddressFormatTableMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 lifi_tclMsgGetAddressFormatTableMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool lifi_tclMsgGetAddressFormatTableMethodStart::operator==(const lifi_tclMsgGetAddressFormatTableMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& lifi_tclMsgGetAddressFormatTableMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& lifi_tclMsgGetAddressFormatTableMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetAddressFormatTableMethodResult::lifi_tclMsgGetAddressFormatTableMethodResult(const lifi_tclMsgGetAddressFormatTableMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Templates = coRef.Templates;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgGetAddressFormatTableMethodResult& lifi_tclMsgGetAddressFormatTableMethodResult::operator=(const lifi_tclMsgGetAddressFormatTableMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Templates = coRef.Templates;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgGetAddressFormatTableMethodResult::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgGetAddressFormatTableMethodResult::u16GetFunctionID() const {return LIFI_C_U16_GETADDRESSFORMATTABLE;}
tU8 lifi_tclMsgGetAddressFormatTableMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid lifi_tclMsgGetAddressFormatTableMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Templates.size(); ++u32Idx)
         Templates[u32Idx].vDestroy();
   }
   Templates.clear();
}

tU32 lifi_tclMsgGetAddressFormatTableMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Templates.size(); ++u32ListIdx)
      u32DynamicSize += Templates[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool lifi_tclMsgGetAddressFormatTableMethodResult::operator==(const lifi_tclMsgGetAddressFormatTableMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Templates.size() == rfoCmp.Templates.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Templates.size()); ++u32Idx)
            bResult = bResult && (Templates[u32Idx] == rfoCmp.Templates[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& lifi_tclMsgGetAddressFormatTableMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Templates.size(); ++u32Idx)
      {
         Templates[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Templates.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Templates[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& lifi_tclMsgGetAddressFormatTableMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)Templates.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Templates.size(); ++u32Idx)
         oOut << Templates[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgDestinationInputInProgressGet::lifi_tclMsgDestinationInputInProgressGet(const lifi_tclMsgDestinationInputInProgressGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgDestinationInputInProgressGet& lifi_tclMsgDestinationInputInProgressGet::operator=(const lifi_tclMsgDestinationInputInProgressGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgDestinationInputInProgressGet::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgDestinationInputInProgressGet::u16GetFunctionID() const {return LIFI_C_U16_DESTINATIONINPUTINPROGRESS;}
tU8 lifi_tclMsgDestinationInputInProgressGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 lifi_tclMsgDestinationInputInProgressGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool lifi_tclMsgDestinationInputInProgressGet::operator==(const lifi_tclMsgDestinationInputInProgressGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& lifi_tclMsgDestinationInputInProgressGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& lifi_tclMsgDestinationInputInProgressGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgDestinationInputInProgressStatus::lifi_tclMsgDestinationInputInProgressStatus(const lifi_tclMsgDestinationInputInProgressStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   DestinationInputIsInProgress = coRef.DestinationInputIsInProgress;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgDestinationInputInProgressStatus& lifi_tclMsgDestinationInputInProgressStatus::operator=(const lifi_tclMsgDestinationInputInProgressStatus& coRef)
{
   if (this == &coRef) return *this;
   DestinationInputIsInProgress = coRef.DestinationInputIsInProgress;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgDestinationInputInProgressStatus::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgDestinationInputInProgressStatus::u16GetFunctionID() const {return LIFI_C_U16_DESTINATIONINPUTINPROGRESS;}
tU8 lifi_tclMsgDestinationInputInProgressStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 lifi_tclMsgDestinationInputInProgressStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool lifi_tclMsgDestinationInputInProgressStatus::operator==(const lifi_tclMsgDestinationInputInProgressStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DestinationInputIsInProgress == rfoCmp.DestinationInputIsInProgress);
   return bResult;
}

fi_tclInContext& lifi_tclMsgDestinationInputInProgressStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> DestinationInputIsInProgress;
   return oIn;
}

fi_tclOutContext& lifi_tclMsgDestinationInputInProgressStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DestinationInputIsInProgress;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgEngineeringTextGet::lifi_tclMsgEngineeringTextGet(const lifi_tclMsgEngineeringTextGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgEngineeringTextGet& lifi_tclMsgEngineeringTextGet::operator=(const lifi_tclMsgEngineeringTextGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgEngineeringTextGet::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgEngineeringTextGet::u16GetFunctionID() const {return LIFI_C_U16_ENGINEERINGTEXT;}
tU8 lifi_tclMsgEngineeringTextGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 lifi_tclMsgEngineeringTextGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool lifi_tclMsgEngineeringTextGet::operator==(const lifi_tclMsgEngineeringTextGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& lifi_tclMsgEngineeringTextGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& lifi_tclMsgEngineeringTextGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgEngineeringTextUpReg::lifi_tclMsgEngineeringTextUpReg(const lifi_tclMsgEngineeringTextUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgEngineeringTextUpReg& lifi_tclMsgEngineeringTextUpReg::operator=(const lifi_tclMsgEngineeringTextUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgEngineeringTextUpReg::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgEngineeringTextUpReg::u16GetFunctionID() const {return LIFI_C_U16_ENGINEERINGTEXT;}
tU8 lifi_tclMsgEngineeringTextUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 lifi_tclMsgEngineeringTextUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool lifi_tclMsgEngineeringTextUpReg::operator==(const lifi_tclMsgEngineeringTextUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& lifi_tclMsgEngineeringTextUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& lifi_tclMsgEngineeringTextUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgEngineeringTextRelUpReg::lifi_tclMsgEngineeringTextRelUpReg(const lifi_tclMsgEngineeringTextRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgEngineeringTextRelUpReg& lifi_tclMsgEngineeringTextRelUpReg::operator=(const lifi_tclMsgEngineeringTextRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgEngineeringTextRelUpReg::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgEngineeringTextRelUpReg::u16GetFunctionID() const {return LIFI_C_U16_ENGINEERINGTEXT;}
tU8 lifi_tclMsgEngineeringTextRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 lifi_tclMsgEngineeringTextRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool lifi_tclMsgEngineeringTextRelUpReg::operator==(const lifi_tclMsgEngineeringTextRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& lifi_tclMsgEngineeringTextRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& lifi_tclMsgEngineeringTextRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgEngineeringTextStatus::lifi_tclMsgEngineeringTextStatus(const lifi_tclMsgEngineeringTextStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Message = coRef.Message;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgEngineeringTextStatus& lifi_tclMsgEngineeringTextStatus::operator=(const lifi_tclMsgEngineeringTextStatus& coRef)
{
   if (this == &coRef) return *this;
   Message = coRef.Message;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgEngineeringTextStatus::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgEngineeringTextStatus::u16GetFunctionID() const {return LIFI_C_U16_ENGINEERINGTEXT;}
tU8 lifi_tclMsgEngineeringTextStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid lifi_tclMsgEngineeringTextStatus::vDestroy()
{
   Message.vDestroy();
}

tU32 lifi_tclMsgEngineeringTextStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Message.u32GetSize(u16MajorVersion);
}

tBool lifi_tclMsgEngineeringTextStatus::operator==(const lifi_tclMsgEngineeringTextStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Message == rfoCmp.Message);
   return bResult;
}

fi_tclInContext& lifi_tclMsgEngineeringTextStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Message;
   return oIn;
}

fi_tclOutContext& lifi_tclMsgEngineeringTextStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Message;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgUsedDatasetGet::lifi_tclMsgUsedDatasetGet(const lifi_tclMsgUsedDatasetGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgUsedDatasetGet& lifi_tclMsgUsedDatasetGet::operator=(const lifi_tclMsgUsedDatasetGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgUsedDatasetGet::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgUsedDatasetGet::u16GetFunctionID() const {return LIFI_C_U16_USEDDATASET;}
tU8 lifi_tclMsgUsedDatasetGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 lifi_tclMsgUsedDatasetGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool lifi_tclMsgUsedDatasetGet::operator==(const lifi_tclMsgUsedDatasetGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& lifi_tclMsgUsedDatasetGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& lifi_tclMsgUsedDatasetGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgUsedDatasetUpReg::lifi_tclMsgUsedDatasetUpReg(const lifi_tclMsgUsedDatasetUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgUsedDatasetUpReg& lifi_tclMsgUsedDatasetUpReg::operator=(const lifi_tclMsgUsedDatasetUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgUsedDatasetUpReg::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgUsedDatasetUpReg::u16GetFunctionID() const {return LIFI_C_U16_USEDDATASET;}
tU8 lifi_tclMsgUsedDatasetUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 lifi_tclMsgUsedDatasetUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool lifi_tclMsgUsedDatasetUpReg::operator==(const lifi_tclMsgUsedDatasetUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& lifi_tclMsgUsedDatasetUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& lifi_tclMsgUsedDatasetUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgUsedDatasetRelUpReg::lifi_tclMsgUsedDatasetRelUpReg(const lifi_tclMsgUsedDatasetRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgUsedDatasetRelUpReg& lifi_tclMsgUsedDatasetRelUpReg::operator=(const lifi_tclMsgUsedDatasetRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgUsedDatasetRelUpReg::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgUsedDatasetRelUpReg::u16GetFunctionID() const {return LIFI_C_U16_USEDDATASET;}
tU8 lifi_tclMsgUsedDatasetRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 lifi_tclMsgUsedDatasetRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool lifi_tclMsgUsedDatasetRelUpReg::operator==(const lifi_tclMsgUsedDatasetRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& lifi_tclMsgUsedDatasetRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& lifi_tclMsgUsedDatasetRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgUsedDatasetStatus::lifi_tclMsgUsedDatasetStatus(const lifi_tclMsgUsedDatasetStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   MediaId = coRef.MediaId;
   DataSetId = coRef.DataSetId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgUsedDatasetStatus& lifi_tclMsgUsedDatasetStatus::operator=(const lifi_tclMsgUsedDatasetStatus& coRef)
{
   if (this == &coRef) return *this;
   MediaId = coRef.MediaId;
   DataSetId = coRef.DataSetId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgUsedDatasetStatus::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgUsedDatasetStatus::u16GetFunctionID() const {return LIFI_C_U16_USEDDATASET;}
tU8 lifi_tclMsgUsedDatasetStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 lifi_tclMsgUsedDatasetStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool lifi_tclMsgUsedDatasetStatus::operator==(const lifi_tclMsgUsedDatasetStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MediaId == rfoCmp.MediaId);
      bResult = bResult && (DataSetId == rfoCmp.DataSetId);
   return bResult;
}

fi_tclInContext& lifi_tclMsgUsedDatasetStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> MediaId;
   oIn >> DataSetId;
   return oIn;
}

fi_tclOutContext& lifi_tclMsgUsedDatasetStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MediaId;
   oOut << DataSetId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgCurrentSearchProgressGet::lifi_tclMsgCurrentSearchProgressGet(const lifi_tclMsgCurrentSearchProgressGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgCurrentSearchProgressGet& lifi_tclMsgCurrentSearchProgressGet::operator=(const lifi_tclMsgCurrentSearchProgressGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgCurrentSearchProgressGet::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgCurrentSearchProgressGet::u16GetFunctionID() const {return LIFI_C_U16_CURRENTSEARCHPROGRESS;}
tU8 lifi_tclMsgCurrentSearchProgressGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 lifi_tclMsgCurrentSearchProgressGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool lifi_tclMsgCurrentSearchProgressGet::operator==(const lifi_tclMsgCurrentSearchProgressGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& lifi_tclMsgCurrentSearchProgressGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& lifi_tclMsgCurrentSearchProgressGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgCurrentSearchProgressUpReg::lifi_tclMsgCurrentSearchProgressUpReg(const lifi_tclMsgCurrentSearchProgressUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgCurrentSearchProgressUpReg& lifi_tclMsgCurrentSearchProgressUpReg::operator=(const lifi_tclMsgCurrentSearchProgressUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgCurrentSearchProgressUpReg::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgCurrentSearchProgressUpReg::u16GetFunctionID() const {return LIFI_C_U16_CURRENTSEARCHPROGRESS;}
tU8 lifi_tclMsgCurrentSearchProgressUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 lifi_tclMsgCurrentSearchProgressUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool lifi_tclMsgCurrentSearchProgressUpReg::operator==(const lifi_tclMsgCurrentSearchProgressUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& lifi_tclMsgCurrentSearchProgressUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& lifi_tclMsgCurrentSearchProgressUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgCurrentSearchProgressRelUpReg::lifi_tclMsgCurrentSearchProgressRelUpReg(const lifi_tclMsgCurrentSearchProgressRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgCurrentSearchProgressRelUpReg& lifi_tclMsgCurrentSearchProgressRelUpReg::operator=(const lifi_tclMsgCurrentSearchProgressRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgCurrentSearchProgressRelUpReg::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgCurrentSearchProgressRelUpReg::u16GetFunctionID() const {return LIFI_C_U16_CURRENTSEARCHPROGRESS;}
tU8 lifi_tclMsgCurrentSearchProgressRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 lifi_tclMsgCurrentSearchProgressRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool lifi_tclMsgCurrentSearchProgressRelUpReg::operator==(const lifi_tclMsgCurrentSearchProgressRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& lifi_tclMsgCurrentSearchProgressRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& lifi_tclMsgCurrentSearchProgressRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgCurrentSearchProgressStatus::lifi_tclMsgCurrentSearchProgressStatus(const lifi_tclMsgCurrentSearchProgressStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Radius = coRef.Radius;
   UILanguage = coRef.UILanguage;
   ElementList = coRef.ElementList;
   LocationDescription = coRef.LocationDescription;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lifi_tclMsgCurrentSearchProgressStatus& lifi_tclMsgCurrentSearchProgressStatus::operator=(const lifi_tclMsgCurrentSearchProgressStatus& coRef)
{
   if (this == &coRef) return *this;
   Radius = coRef.Radius;
   UILanguage = coRef.UILanguage;
   ElementList = coRef.ElementList;
   LocationDescription = coRef.LocationDescription;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 lifi_tclMsgCurrentSearchProgressStatus::u16GetServiceID() const {return LIFI_C_U16_SERVICE_ID;}
tU16 lifi_tclMsgCurrentSearchProgressStatus::u16GetFunctionID() const {return LIFI_C_U16_CURRENTSEARCHPROGRESS;}
tU8 lifi_tclMsgCurrentSearchProgressStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid lifi_tclMsgCurrentSearchProgressStatus::vDestroy()
{
   ElementList.vDestroy(); 
   LocationDescription.vDestroy(); 
}

tU32 lifi_tclMsgCurrentSearchProgressStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (19 <= u16MajorVersion)
   {
      u32DynamicSize += LocationDescription.u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+6+ElementList.u32GetSize(u16MajorVersion);
}

tBool lifi_tclMsgCurrentSearchProgressStatus::operator==(const lifi_tclMsgCurrentSearchProgressStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Radius == rfoCmp.Radius);
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (ElementList == rfoCmp.ElementList);
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
   return bResult;
}

fi_tclInContext& lifi_tclMsgCurrentSearchProgressStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Radius;
   oIn >> UILanguage;
   oIn >> ElementList;
   if (19 <= oIn.u16GetMajorVersion())
   {
      oIn >> LocationDescription;
   }
   return oIn;
}

fi_tclOutContext& lifi_tclMsgCurrentSearchProgressStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Radius;
   oOut << UILanguage;
   oOut << ElementList;
   if (19 <= oOut.u16GetMajorVersion())
   {
      oOut << LocationDescription;
   }
   return oOut;
}

