#ifndef INTWDBFILANGUAGE_HEADER
#define INTWDBFILANGUAGE_HEADER

class intwdbfi_tclInContext;
class intwdbfi_tclOutContext;
class intwdbfi_tclVisitorBase;

class MY_DECL intwdbfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  intwdbfi_tclDescription(fi_tclInContext* poIn, intwdbfi_tclVisitorBase* poVisit);
  intwdbfi_tclDescription(fi_tclOutContext* poOut, intwdbfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(intwdbfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ intwdbfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  intwdbfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<intwdbfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<intwdbfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline intwdbfi_tclDescription::intwdbfi_tclDescription(fi_tclInContext* poIn, intwdbfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline intwdbfi_tclDescription::intwdbfi_tclDescription(fi_tclOutContext* poOut, intwdbfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

