#ifndef __INTNAVIFIDEBUGVISITOR_H__
#define __INTNAVIFIDEBUGVISITOR_H__

class MY_DECL intnavifi_tclPrintVisitor : public intnavifi_tclVisitorBase {

private:
   /* default constructor */ intnavifi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   intnavifi_tclPrintVisitor(fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Reserved(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u8_Percent(fi_tcl_u8_Percent& o_u8_Percent);
   virtual tVoid vVisit_s16_PerThousand(fi_tcl_s16_PerThousand& o_s16_PerThousand);
   virtual tVoid vVisit_u16_IndexInReferenceList(fi_tcl_u16_IndexInReferenceList& o_u16_IndexInReferenceList);
   virtual tVoid vVisit_s32_Kilogram(fi_tcl_s32_Kilogram& o_s32_Kilogram);
   virtual tVoid vVisit_s32_Pound(fi_tcl_s32_Pound& o_s32_Pound);
   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& o_s32_Meter);
   virtual tVoid vVisit_s32_Yards(fi_tcl_s32_Yards& o_s32_Yards);
   virtual tVoid vVisit_s32_Centimeter(fi_tcl_s32_Centimeter& o_s32_Centimeter);
   virtual tVoid vVisit_s32_Inch(fi_tcl_s32_Inch& o_s32_Inch);
   virtual tVoid vVisit_s32_Second(fi_tcl_s32_Second& o_s32_Second);
   virtual tBool bDoExpand_POSIXTime(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DST_State(fi_tcl_e8_DST_State& o_e8_DST_State);
   virtual tBool bDoExpand_TimeZoneElement(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s16_KmPerHour(fi_tcl_s16_KmPerHour& o_s16_KmPerHour);
   virtual tVoid vVisit_s16_MilesPerHour(fi_tcl_s16_MilesPerHour& o_s16_MilesPerHour);
   virtual tVoid vVisit_s16_CentimeterSecond(fi_tcl_s16_CentimeterSecond& o_s16_CentimeterSecond);
   virtual tBool bDoExpand_FIVersion(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tBool bDoExpand_PositionWGS84(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RectangleWGS84(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_u8_DirectionAbsolute(fi_tcl_u8_DirectionAbsolute& o_u8_DirectionAbsolute);
   virtual tVoid vVisit_e8_BinContainerTypes(fi_tcl_e8_BinContainerTypes& o_e8_BinContainerTypes);
   virtual tVoid vVisit_e16_SelectionCriterionType(fi_tcl_e16_SelectionCriterionType& o_e16_SelectionCriterionType);
   virtual tVoid vVisit_e16_NaviEventValue(fi_tcl_e16_NaviEventValue& o_e16_NaviEventValue);
   virtual tVoid vVisit_e8_TrafficMsgType(fi_tcl_e8_TrafficMsgType& o_e8_TrafficMsgType);
   virtual tVoid vVisit_e8_TMLocationType(fi_tcl_e8_TMLocationType& o_e8_TMLocationType);
   virtual tVoid vVisit_e8_EventType(fi_tcl_e8_EventType& o_e8_EventType);
   virtual tVoid vVisit_e16_EffectCode(fi_tcl_e16_EffectCode& o_e16_EffectCode);
   virtual tVoid vVisit_e16_CauseCode(fi_tcl_e16_CauseCode& o_e16_CauseCode);
   virtual tVoid vVisit_e8_Tendency(fi_tcl_e8_Tendency& o_e8_Tendency);
   virtual tBool bDoExpand_RDBId(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMEvent(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b32_TrafficMessageSource(fi_tcl_b32_TrafficMessageSource& o_b32_TrafficMessageSource);
   virtual tVoid vVisit_e8_TMUrgency(fi_tcl_e8_TMUrgency& o_e8_TMUrgency);
   virtual tBool bDoExpand_TMCodedMessage(intnavifi_tclSemanticDomain::tenType enSemantic);
#ifndef FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_TMCodedMessageBinContainer(intnavifi_tclSemanticDomain::tenType enSemantic);
#endif // FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_TMProgramService(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MapCoordinates(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_PresenceIndicator(fi_tcl_b8_PresenceIndicator& o_b8_PresenceIndicator);
   virtual tVoid vVisit_s8_MapDisplayZLevel(fi_tcl_s8_MapDisplayZLevel& o_s8_MapDisplayZLevel);
   virtual tVoid vVisit_s8_MapDisplayPriority(fi_tcl_s8_MapDisplayPriority& o_s8_MapDisplayPriority);
   virtual tBool bDoExpand_MapCodedElement(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_MapElementDescrType(fi_tcl_e8_MapElementDescrType& o_e8_MapElementDescrType);
   virtual tBool bDoExpand_MapElementDescriptor(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MapElementDescription(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_MapGeometricType(fi_tcl_e8_MapGeometricType& o_e8_MapGeometricType);
   virtual tBool bDoExpand_MapGeographicType(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_SurfaceCoverCode(fi_tcl_e8_SurfaceCoverCode& o_e8_SurfaceCoverCode);
   virtual tVoid vVisit_e8_SignPostDestType(fi_tcl_e8_SignPostDestType& o_e8_SignPostDestType);
   virtual tVoid vVisit_e8_SignPostDestinationCategory(fi_tcl_e8_SignPostDestinationCategory& o_e8_SignPostDestinationCategory);
   virtual tVoid vVisit_e8_SignPostDestStatus(fi_tcl_e8_SignPostDestStatus& o_e8_SignPostDestStatus);
   virtual tVoid vVisit_e8_DirectionStatus(fi_tcl_e8_DirectionStatus& o_e8_DirectionStatus);
   virtual tBool bDoExpand_SignPostDestDirection(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DirectionCategory(fi_tcl_e8_DirectionCategory& o_e8_DirectionCategory);
   virtual tVoid vVisit_b8_DirectionInfoStatus(fi_tcl_b8_DirectionInfoStatus& o_b8_DirectionInfoStatus);
   virtual tBool bDoExpand_DirectionCategory(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DirectionInfo(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SignPostDestination(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ReferenceElement(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DirectionInfoListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u16_UserTrafficMessageHandle(fi_tcl_u16_UserTrafficMessageHandle& o_u16_UserTrafficMessageHandle);
   virtual tVoid vVisit_e8_LaneStatus(fi_tcl_e8_LaneStatus& o_e8_LaneStatus);
   virtual tVoid vVisit_b8_LaneType(fi_tcl_b8_LaneType& o_b8_LaneType);
   virtual tVoid vVisit_b8_LaneChangeRestriction(fi_tcl_b8_LaneChangeRestriction& o_b8_LaneChangeRestriction);
   virtual tVoid vVisit_u8_IndexInLaneInfoSegmentList(fi_tcl_u8_IndexInLaneInfoSegmentList& o_u8_IndexInLaneInfoSegmentList);
   virtual tVoid vVisit_u8_IndexInLaneInfoList(fi_tcl_u8_IndexInLaneInfoList& o_u8_IndexInLaneInfoList);
   virtual tVoid vVisit_u8_DrivingDirection(fi_tcl_u8_DrivingDirection& o_u8_DrivingDirection);
   virtual tBool bDoExpand_LaneDirection(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_NavOneCellDirection(fi_tcl_e8_NavOneCellDirection& o_e8_NavOneCellDirection);
   virtual tBool bDoExpand_LaneInfoOneCellIndexReference(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfoPathSectionIndexReference(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfoElementReference(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_LaneReferenceCategory(fi_tcl_e8_LaneReferenceCategory& o_e8_LaneReferenceCategory);
   virtual tBool bDoExpand_LaneReference(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfo(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s32_EMU(fi_tcl_s32_EMU& o_s32_EMU);
   virtual tBool bDoExpand_LaneInfoSegment(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfoSegmentList(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WGS84CoordinateList(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ShapePointListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TMGeometricMessageType(fi_tcl_e8_TMGeometricMessageType& o_e8_TMGeometricMessageType);
   virtual tBool bDoExpand_NavOneCellDesc(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_RoadClassCode(fi_tcl_e8_RoadClassCode& o_e8_RoadClassCode);
   virtual tBool bDoExpand_UPOI_Category(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_UPOI_Source(fi_tcl_e8_UPOI_Source& o_e8_UPOI_Source);
   virtual tVoid vVisit_b8_UPOI_FilterSetStatus(fi_tcl_b8_UPOI_FilterSetStatus& o_b8_UPOI_FilterSetStatus);
   virtual tVoid vVisit_b8_UPOI_Validity(fi_tcl_b8_UPOI_Validity& o_b8_UPOI_Validity);
   virtual tBool bDoExpand_UPOI_Element(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_UPOI_FilterSet_FieldRelevance(fi_tcl_b8_UPOI_FilterSet_FieldRelevance& o_b8_UPOI_FilterSet_FieldRelevance);
   virtual tBool bDoExpand_UPOI_FilterSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UPOI_FilterList(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_UPOI_Status(fi_tcl_b8_UPOI_Status& o_b8_UPOI_Status);
   virtual tBool bDoExpand_UPOI_Combination(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UPOI_ListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_NavOneCellCategory(fi_tcl_e8_NavOneCellCategory& o_e8_NavOneCellCategory);
   virtual tBool bDoExpand_ReferenceElementWithID(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StateNameElement(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CountyNameElement(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CityDistrictNameElement(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_BuildUpAreaNameElement(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_RoadNumberStatus(fi_tcl_b8_RoadNumberStatus& o_b8_RoadNumberStatus);
   virtual tBool bDoExpand_RequiredTaxDisc(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_RequiredPermissionType(fi_tcl_e8_RequiredPermissionType& o_e8_RequiredPermissionType);
   virtual tVoid vVisit_e8_RequiredPermission(fi_tcl_e8_RequiredPermission& o_e8_RequiredPermission);
   virtual tBool bDoExpand_GenericRequiredPermission(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RequiredPermission(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CountryNameElement(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StateNameListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CountyNameListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CityNameElement(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IndexInReferenceList(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_BuildUpAreaNameListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadNameListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CompassDirection(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RequiredPermissionListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_IntersectionType(fi_tcl_e8_IntersectionType& o_e8_IntersectionType);
   virtual tBool bDoExpand_TimeZoneListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IntersectionNameElement(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadNameElement(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadNumber(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IntersectionNumberElement(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MapDescriptionListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CountryNameListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CityNameListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SignPostElement(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadNumberListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b16_RoadAttribute(fi_tcl_b16_RoadAttribute& o_b16_RoadAttribute);
   virtual tVoid vVisit_b32_RoadProperty(fi_tcl_b32_RoadProperty& o_b32_RoadProperty);
   virtual tVoid vVisit_e8_NavStreetType(fi_tcl_e8_NavStreetType& o_e8_NavStreetType);
   virtual tVoid vVisit_e8_RoadNetworkClass(fi_tcl_e8_RoadNetworkClass& o_e8_RoadNetworkClass);
   virtual tBool bDoExpand_RoadAttributes(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u32_DataSetId(fi_tcl_u32_DataSetId& o_u32_DataSetId);
   virtual tVoid vVisit_e8_ExtraDescElementType(fi_tcl_e8_ExtraDescElementType& o_e8_ExtraDescElementType);
   virtual tBool bDoExpand_ExtraDescElement(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ExtraDescListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b32_DataProperties(fi_tcl_b32_DataProperties& o_b32_DataProperties);
   virtual tBool bDoExpand_DataDescElement(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DataDescListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_CrossroadProperties(fi_tcl_b8_CrossroadProperties& o_b8_CrossroadProperties);
   virtual tBool bDoExpand_CrossroadDesc(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_CrossroadInfoCategory(fi_tcl_e8_CrossroadInfoCategory& o_e8_CrossroadInfoCategory);
   virtual tBool bDoExpand_CrossroadInfo(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IntersectionDenotation(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IntersectionPathDenotation(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IntersectionPathDesc(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_BaseTrafficSignCategory(fi_tcl_e8_BaseTrafficSignCategory& o_e8_BaseTrafficSignCategory);
   virtual tVoid vVisit_e8_SpeedSign(fi_tcl_e8_SpeedSign& o_e8_SpeedSign);
   virtual tVoid vVisit_e16_WarningSign(fi_tcl_e16_WarningSign& o_e16_WarningSign);
   virtual tVoid vVisit_e16_RegulatorySign(fi_tcl_e16_RegulatorySign& o_e16_RegulatorySign);
   virtual tVoid vVisit_e16_AdditionalTrafficSign(fi_tcl_e16_AdditionalTrafficSign& o_e16_AdditionalTrafficSign);
   virtual tVoid vVisit_TimeDependentString(fi_tcl_TimeDependentString& o_TimeDependentString);
   virtual tVoid vVisit_b8_LaneDependentValidity(fi_tcl_b8_LaneDependentValidity& o_b8_LaneDependentValidity);
   virtual tVoid vVisit_e8_TrafficSignQuantifier(fi_tcl_e8_TrafficSignQuantifier& o_e8_TrafficSignQuantifier);
   virtual tBool bDoExpand_AdditionalTrafficSign(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TrafficSignElement(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadInfoCombination(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TrafficSignListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b32_POICategory(fi_tcl_b32_POICategory& o_b32_POICategory);
   virtual tBool bDoExpand_POIElement(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_POIListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TollBoothElement(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TollBoothListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CityDistrictNameListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PointOfInterestElement(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UnspecifiedText(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_ShapeType(fi_tcl_e8_ShapeType& o_e8_ShapeType);
   virtual tBool bDoExpand_Shape(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMServiceProvider(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TMCategory(fi_tcl_e8_TMCategory& o_e8_TMCategory);
   virtual tVoid vVisit_e8_TMFlowImpact(fi_tcl_e8_TMFlowImpact& o_e8_TMFlowImpact);
   virtual tVoid vVisit_b8_TMMappingPossibility(fi_tcl_b8_TMMappingPossibility& o_b8_TMMappingPossibility);
   virtual tVoid vVisit_b8_TMMappingStatus(fi_tcl_b8_TMMappingStatus& o_b8_TMMappingStatus);
   virtual tVoid vVisit_e8_TMAffectionType(fi_tcl_e8_TMAffectionType& o_e8_TMAffectionType);
   virtual tVoid vVisit_b8_TMOneCellAttribute(fi_tcl_b8_TMOneCellAttribute& o_b8_TMOneCellAttribute);
   virtual tBool bDoExpand_TMOneCellPortion(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TMValueStatus(fi_tcl_e8_TMValueStatus& o_e8_TMValueStatus);
   virtual tVoid vVisit_e8_TMCIntersectionPathType(fi_tcl_e8_TMCIntersectionPathType& o_e8_TMCIntersectionPathType);
   virtual tBool bDoExpand_TMCStructuredText(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TMGeographicalPathRelationType(fi_tcl_e8_TMGeographicalPathRelationType& o_e8_TMGeographicalPathRelationType);
   virtual tVoid vVisit_b8_TMRelevance(fi_tcl_b8_TMRelevance& o_b8_TMRelevance);
   virtual tBool bDoExpand_TMInfo(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMCombination(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavClusterDesc(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavOneCell(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfoListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LaneInfoOneCellReference(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SignPostListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavPlainPathListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_RoadInfoPriority(fi_tcl_e8_RoadInfoPriority& o_e8_RoadInfoPriority);
   virtual tVoid vVisit_e8_RoadPathInfoCategory(fi_tcl_e8_RoadPathInfoCategory& o_e8_RoadPathInfoCategory);
   virtual tBool bDoExpand_NavIntersectionListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadPathInfoCategory(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadPathInfoListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DataAvailable(fi_tcl_e8_DataAvailable& o_e8_DataAvailable);
   virtual tBool bDoExpand_TMInfoListSet(intnavifi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   fi_tclOutput* poOutput;
};


class MY_DECL intnavifi_tclRandomInitVisitor : public intnavifi_tclVisitorBase {
public:

   intnavifi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_u8_Percent(fi_tcl_u8_Percent& o_u8_Percent);
   virtual tVoid vVisit_s16_PerThousand(fi_tcl_s16_PerThousand& o_s16_PerThousand);
   virtual tVoid vVisit_u16_IndexInReferenceList(fi_tcl_u16_IndexInReferenceList& o_u16_IndexInReferenceList);
   virtual tVoid vVisit_s32_Kilogram(fi_tcl_s32_Kilogram& o_s32_Kilogram);
   virtual tVoid vVisit_s32_Pound(fi_tcl_s32_Pound& o_s32_Pound);
   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& o_s32_Meter);
   virtual tVoid vVisit_s32_Yards(fi_tcl_s32_Yards& o_s32_Yards);
   virtual tVoid vVisit_s32_Centimeter(fi_tcl_s32_Centimeter& o_s32_Centimeter);
   virtual tVoid vVisit_s32_Inch(fi_tcl_s32_Inch& o_s32_Inch);
   virtual tVoid vVisit_s32_Second(fi_tcl_s32_Second& o_s32_Second);
   virtual tVoid vVisit_e8_DST_State(fi_tcl_e8_DST_State& o_e8_DST_State);
   virtual tVoid vVisit_s16_KmPerHour(fi_tcl_s16_KmPerHour& o_s16_KmPerHour);
   virtual tVoid vVisit_s16_MilesPerHour(fi_tcl_s16_MilesPerHour& o_s16_MilesPerHour);
   virtual tVoid vVisit_s16_CentimeterSecond(fi_tcl_s16_CentimeterSecond& o_s16_CentimeterSecond);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_u8_DirectionAbsolute(fi_tcl_u8_DirectionAbsolute& o_u8_DirectionAbsolute);
   virtual tVoid vVisit_e8_BinContainerTypes(fi_tcl_e8_BinContainerTypes& o_e8_BinContainerTypes);
   virtual tVoid vVisit_e16_SelectionCriterionType(fi_tcl_e16_SelectionCriterionType& o_e16_SelectionCriterionType);
   virtual tVoid vVisit_e16_NaviEventValue(fi_tcl_e16_NaviEventValue& o_e16_NaviEventValue);
   virtual tVoid vVisit_e8_TrafficMsgType(fi_tcl_e8_TrafficMsgType& o_e8_TrafficMsgType);
   virtual tVoid vVisit_e8_TMLocationType(fi_tcl_e8_TMLocationType& o_e8_TMLocationType);
   virtual tVoid vVisit_e8_EventType(fi_tcl_e8_EventType& o_e8_EventType);
   virtual tVoid vVisit_e16_EffectCode(fi_tcl_e16_EffectCode& o_e16_EffectCode);
   virtual tVoid vVisit_e16_CauseCode(fi_tcl_e16_CauseCode& o_e16_CauseCode);
   virtual tVoid vVisit_e8_Tendency(fi_tcl_e8_Tendency& o_e8_Tendency);
   virtual tVoid vVisit_b32_TrafficMessageSource(fi_tcl_b32_TrafficMessageSource& o_b32_TrafficMessageSource);
   virtual tVoid vVisit_e8_TMUrgency(fi_tcl_e8_TMUrgency& o_e8_TMUrgency);
#ifndef FI_S_EXTERNAL_FI
#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_b8_PresenceIndicator(fi_tcl_b8_PresenceIndicator& o_b8_PresenceIndicator);
   virtual tVoid vVisit_s8_MapDisplayZLevel(fi_tcl_s8_MapDisplayZLevel& o_s8_MapDisplayZLevel);
   virtual tVoid vVisit_s8_MapDisplayPriority(fi_tcl_s8_MapDisplayPriority& o_s8_MapDisplayPriority);
   virtual tVoid vVisit_e8_MapElementDescrType(fi_tcl_e8_MapElementDescrType& o_e8_MapElementDescrType);
   virtual tVoid vVisit_e8_MapGeometricType(fi_tcl_e8_MapGeometricType& o_e8_MapGeometricType);
   virtual tVoid vVisit_e8_SurfaceCoverCode(fi_tcl_e8_SurfaceCoverCode& o_e8_SurfaceCoverCode);
   virtual tVoid vVisit_e8_SignPostDestType(fi_tcl_e8_SignPostDestType& o_e8_SignPostDestType);
   virtual tVoid vVisit_e8_SignPostDestinationCategory(fi_tcl_e8_SignPostDestinationCategory& o_e8_SignPostDestinationCategory);
   virtual tVoid vVisit_e8_SignPostDestStatus(fi_tcl_e8_SignPostDestStatus& o_e8_SignPostDestStatus);
   virtual tVoid vVisit_e8_DirectionStatus(fi_tcl_e8_DirectionStatus& o_e8_DirectionStatus);
   virtual tVoid vVisit_e8_DirectionCategory(fi_tcl_e8_DirectionCategory& o_e8_DirectionCategory);
   virtual tVoid vVisit_b8_DirectionInfoStatus(fi_tcl_b8_DirectionInfoStatus& o_b8_DirectionInfoStatus);
   virtual tVoid vVisit_u16_UserTrafficMessageHandle(fi_tcl_u16_UserTrafficMessageHandle& o_u16_UserTrafficMessageHandle);
   virtual tVoid vVisit_e8_LaneStatus(fi_tcl_e8_LaneStatus& o_e8_LaneStatus);
   virtual tVoid vVisit_b8_LaneType(fi_tcl_b8_LaneType& o_b8_LaneType);
   virtual tVoid vVisit_b8_LaneChangeRestriction(fi_tcl_b8_LaneChangeRestriction& o_b8_LaneChangeRestriction);
   virtual tVoid vVisit_u8_IndexInLaneInfoSegmentList(fi_tcl_u8_IndexInLaneInfoSegmentList& o_u8_IndexInLaneInfoSegmentList);
   virtual tVoid vVisit_u8_IndexInLaneInfoList(fi_tcl_u8_IndexInLaneInfoList& o_u8_IndexInLaneInfoList);
   virtual tVoid vVisit_u8_DrivingDirection(fi_tcl_u8_DrivingDirection& o_u8_DrivingDirection);
   virtual tVoid vVisit_e8_NavOneCellDirection(fi_tcl_e8_NavOneCellDirection& o_e8_NavOneCellDirection);
   virtual tVoid vVisit_e8_LaneReferenceCategory(fi_tcl_e8_LaneReferenceCategory& o_e8_LaneReferenceCategory);
   virtual tVoid vVisit_s32_EMU(fi_tcl_s32_EMU& o_s32_EMU);
   virtual tVoid vVisit_e8_TMGeometricMessageType(fi_tcl_e8_TMGeometricMessageType& o_e8_TMGeometricMessageType);
   virtual tVoid vVisit_e8_RoadClassCode(fi_tcl_e8_RoadClassCode& o_e8_RoadClassCode);
   virtual tVoid vVisit_e8_UPOI_Source(fi_tcl_e8_UPOI_Source& o_e8_UPOI_Source);
   virtual tVoid vVisit_b8_UPOI_FilterSetStatus(fi_tcl_b8_UPOI_FilterSetStatus& o_b8_UPOI_FilterSetStatus);
   virtual tVoid vVisit_b8_UPOI_Validity(fi_tcl_b8_UPOI_Validity& o_b8_UPOI_Validity);
   virtual tVoid vVisit_b8_UPOI_FilterSet_FieldRelevance(fi_tcl_b8_UPOI_FilterSet_FieldRelevance& o_b8_UPOI_FilterSet_FieldRelevance);
   virtual tVoid vVisit_b8_UPOI_Status(fi_tcl_b8_UPOI_Status& o_b8_UPOI_Status);
   virtual tVoid vVisit_e8_NavOneCellCategory(fi_tcl_e8_NavOneCellCategory& o_e8_NavOneCellCategory);
   virtual tVoid vVisit_b8_RoadNumberStatus(fi_tcl_b8_RoadNumberStatus& o_b8_RoadNumberStatus);
   virtual tVoid vVisit_e8_RequiredPermissionType(fi_tcl_e8_RequiredPermissionType& o_e8_RequiredPermissionType);
   virtual tVoid vVisit_e8_RequiredPermission(fi_tcl_e8_RequiredPermission& o_e8_RequiredPermission);
   virtual tVoid vVisit_e8_IntersectionType(fi_tcl_e8_IntersectionType& o_e8_IntersectionType);
   virtual tVoid vVisit_b16_RoadAttribute(fi_tcl_b16_RoadAttribute& o_b16_RoadAttribute);
   virtual tVoid vVisit_b32_RoadProperty(fi_tcl_b32_RoadProperty& o_b32_RoadProperty);
   virtual tVoid vVisit_e8_NavStreetType(fi_tcl_e8_NavStreetType& o_e8_NavStreetType);
   virtual tVoid vVisit_e8_RoadNetworkClass(fi_tcl_e8_RoadNetworkClass& o_e8_RoadNetworkClass);
   virtual tVoid vVisit_u32_DataSetId(fi_tcl_u32_DataSetId& o_u32_DataSetId);
   virtual tVoid vVisit_e8_ExtraDescElementType(fi_tcl_e8_ExtraDescElementType& o_e8_ExtraDescElementType);
   virtual tVoid vVisit_b32_DataProperties(fi_tcl_b32_DataProperties& o_b32_DataProperties);
   virtual tVoid vVisit_b8_CrossroadProperties(fi_tcl_b8_CrossroadProperties& o_b8_CrossroadProperties);
   virtual tVoid vVisit_e8_CrossroadInfoCategory(fi_tcl_e8_CrossroadInfoCategory& o_e8_CrossroadInfoCategory);
   virtual tVoid vVisit_e8_BaseTrafficSignCategory(fi_tcl_e8_BaseTrafficSignCategory& o_e8_BaseTrafficSignCategory);
   virtual tVoid vVisit_e8_SpeedSign(fi_tcl_e8_SpeedSign& o_e8_SpeedSign);
   virtual tVoid vVisit_e16_WarningSign(fi_tcl_e16_WarningSign& o_e16_WarningSign);
   virtual tVoid vVisit_e16_RegulatorySign(fi_tcl_e16_RegulatorySign& o_e16_RegulatorySign);
   virtual tVoid vVisit_e16_AdditionalTrafficSign(fi_tcl_e16_AdditionalTrafficSign& o_e16_AdditionalTrafficSign);
   virtual tVoid vVisit_TimeDependentString(fi_tcl_TimeDependentString& o_TimeDependentString);
   virtual tVoid vVisit_b8_LaneDependentValidity(fi_tcl_b8_LaneDependentValidity& o_b8_LaneDependentValidity);
   virtual tVoid vVisit_e8_TrafficSignQuantifier(fi_tcl_e8_TrafficSignQuantifier& o_e8_TrafficSignQuantifier);
   virtual tVoid vVisit_b32_POICategory(fi_tcl_b32_POICategory& o_b32_POICategory);
   virtual tVoid vVisit_e8_ShapeType(fi_tcl_e8_ShapeType& o_e8_ShapeType);
   virtual tVoid vVisit_e8_TMCategory(fi_tcl_e8_TMCategory& o_e8_TMCategory);
   virtual tVoid vVisit_e8_TMFlowImpact(fi_tcl_e8_TMFlowImpact& o_e8_TMFlowImpact);
   virtual tVoid vVisit_b8_TMMappingPossibility(fi_tcl_b8_TMMappingPossibility& o_b8_TMMappingPossibility);
   virtual tVoid vVisit_b8_TMMappingStatus(fi_tcl_b8_TMMappingStatus& o_b8_TMMappingStatus);
   virtual tVoid vVisit_e8_TMAffectionType(fi_tcl_e8_TMAffectionType& o_e8_TMAffectionType);
   virtual tVoid vVisit_b8_TMOneCellAttribute(fi_tcl_b8_TMOneCellAttribute& o_b8_TMOneCellAttribute);
   virtual tVoid vVisit_e8_TMValueStatus(fi_tcl_e8_TMValueStatus& o_e8_TMValueStatus);
   virtual tVoid vVisit_e8_TMCIntersectionPathType(fi_tcl_e8_TMCIntersectionPathType& o_e8_TMCIntersectionPathType);
   virtual tVoid vVisit_e8_TMGeographicalPathRelationType(fi_tcl_e8_TMGeographicalPathRelationType& o_e8_TMGeographicalPathRelationType);
   virtual tVoid vVisit_b8_TMRelevance(fi_tcl_b8_TMRelevance& o_b8_TMRelevance);
   virtual tVoid vVisit_e8_RoadInfoPriority(fi_tcl_e8_RoadInfoPriority& o_e8_RoadInfoPriority);
   virtual tVoid vVisit_e8_RoadPathInfoCategory(fi_tcl_e8_RoadPathInfoCategory& o_e8_RoadPathInfoCategory);
   virtual tVoid vVisit_e8_DataAvailable(fi_tcl_e8_DataAvailable& o_e8_DataAvailable);
	tU32 u32ListSize;
};

#endif
