#ifndef INTMAPFILANGUAGE_HEADER
#define INTMAPFILANGUAGE_HEADER

class intmapfi_tclInContext;
class intmapfi_tclOutContext;
class intmapfi_tclVisitorBase;

class MY_DECL intmapfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  intmapfi_tclDescription(fi_tclInContext* poIn, intmapfi_tclVisitorBase* poVisit);
  intmapfi_tclDescription(fi_tclOutContext* poOut, intmapfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(intmapfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ intmapfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  intmapfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<intmapfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<intmapfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline intmapfi_tclDescription::intmapfi_tclDescription(fi_tclInContext* poIn, intmapfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline intmapfi_tclDescription::intmapfi_tclDescription(fi_tclOutContext* poOut, intmapfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

