#include "precompiled.hh"

tBool intmapfi_tclDescription::bInitMessage(intmapfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case intmapfi_tclToken::EN_LAST_TOKEN:
   case intmapfi_tclToken::EN_LIST:
   case intmapfi_tclToken::EN_END_OF_STRUCT:
   case intmapfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case intmapfi_tclToken::EN_MSG_GETDIRECTORYMETHODRESULT:
   {
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_MAPDATALEVELDIRECTORY,intmapfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_LIST,intmapfi_tclSemanticDomain::EN_MSG_MAPDATALEVELDIRECTORYLIST));
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_MAPDIRECTORY,intmapfi_tclSemanticDomain::EN_MSG_MAPDIRECTORY));
   } break;
   case intmapfi_tclToken::EN_MSG_GETREGIONMETHODSTART:
   {
      if (7 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_MAPREGION,intmapfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_LIST,intmapfi_tclSemanticDomain::EN_MSG_REGIONS));
      }
      if (poOutContext->u16GetMajorVersion() <= 6)
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONWGS84,intmapfi_tclSemanticDomain::EN_MSG_EXCLUDEPOSSOUTHEAST));
      }
      if (poOutContext->u16GetMajorVersion() <= 6)
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONWGS84,intmapfi_tclSemanticDomain::EN_MSG_EXCLUDEPOSNORTHWEST));
      }
      if (poOutContext->u16GetMajorVersion() <= 6)
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONWGS84,intmapfi_tclSemanticDomain::EN_MSG_EXTPOSSOUTHEAST));
      }
      if (poOutContext->u16GetMajorVersion() <= 6)
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONWGS84,intmapfi_tclSemanticDomain::EN_MSG_EXTPOSNORTHWEST));
      }
      if (poOutContext->u16GetMajorVersion() <= 6)
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_E8_MAPDATALEVEL,intmapfi_tclSemanticDomain::EN_MSG_DATALEVEL));
      }
      if (poOutContext->u16GetMajorVersion() <= 6)
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_E16_ISOLANGUAGECODE,intmapfi_tclSemanticDomain::EN_MSG_DATABASELANGUAGE));
      }
   } break;
   case intmapfi_tclToken::EN_MSG_GETREGIONMETHODRESULT:
   {
      if (7 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_MAPREGION,intmapfi_tclSemanticDomain::EN_MSG_REGION));
      }
      if (poOutContext->u16GetMajorVersion() <= 6)
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_MAPCONTAINER,intmapfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_LIST,intmapfi_tclSemanticDomain::EN_MSG_REGIONDATA));
      }
      if (poOutContext->u16GetMajorVersion() <= 6)
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_E16_ISOLANGUAGECODE,intmapfi_tclSemanticDomain::EN_MSG_DATABASELANGUAGE));
      }
   } break;
   case intmapfi_tclToken::EN_MSG_SETRESERVEDCACHINGAREASMETHODSTART:
   {
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_MAPREGION,intmapfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_LIST,intmapfi_tclSemanticDomain::EN_MSG_REGIONS));
   } break;
   case intmapfi_tclToken::EN_MSG_SETRESERVEDCACHINGAREASMETHODRESULT:
   {
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_MAPREGION,intmapfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_LIST,intmapfi_tclSemanticDomain::EN_MSG_REGIONS));
   } break;
   case intmapfi_tclToken::EN_MSG_DRAWMAPMETHODSTART:
   {
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_S16,intmapfi_tclSemanticDomain::EN_MSG_ONEWAYMARKS_YLIMIT));
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_S16,intmapfi_tclSemanticDomain::EN_MSG_POI_YLIMIT));
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_S16,intmapfi_tclSemanticDomain::EN_MSG_CITYCENTRE_YLIMIT));
      }
      if (9 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_S16,intmapfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_LIST,intmapfi_tclSemanticDomain::EN_MSG_MAPSTREETFILTERLIMIT));
      }
      if (8 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U8,intmapfi_tclSemanticDomain::EN_MSG_SCALEFACTOR));
      }
      if (7 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONSCREEN,intmapfi_tclSemanticDomain::EN_MSG_UPPERRIGHTMAPBOUNDARY));
      }
      if (7 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONSCREEN,intmapfi_tclSemanticDomain::EN_MSG_LOWERLEFTMAPBOUNDARY));
      }
      if (7 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONSCREEN,intmapfi_tclSemanticDomain::EN_MSG_UPPERRIGHTSCREENBOUNDARY));
      }
      if (7 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONSCREEN,intmapfi_tclSemanticDomain::EN_MSG_LOWERLEFTSCREENBOUNDARY));
      }
      if (7 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U16,intmapfi_tclSemanticDomain::EN_MSG_TILTANGLE));
      }
      if (7 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U32,intmapfi_tclSemanticDomain::EN_MSG_VALUE2));
      }
      if (7 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U32,intmapfi_tclSemanticDomain::EN_MSG_VALUE1));
      }
      if (7 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U16,intmapfi_tclSemanticDomain::EN_MSG_MOREOPTIONS));
      }
      if (7 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U16,intmapfi_tclSemanticDomain::EN_MSG_SCENEDIRECTION));
      }
      if (7 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U8,intmapfi_tclSemanticDomain::EN_MSG_CUSTOMZOOMLEVEL));
      }
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U16,intmapfi_tclSemanticDomain::EN_MSG_MAPDIRECTION));
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONWGS84,intmapfi_tclSemanticDomain::EN_MSG_POSITION));
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U16,intmapfi_tclSemanticDomain::EN_MSG_SCALEBARSIZE));
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONSCREEN,intmapfi_tclSemanticDomain::EN_MSG_UPPERRIGHTUPDATEFRAME));
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONSCREEN,intmapfi_tclSemanticDomain::EN_MSG_LOWERLEFTUPDATEFRAME));
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONSCREEN,intmapfi_tclSemanticDomain::EN_MSG_UPPERRIGHTUPDATEBOUNDARY));
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONSCREEN,intmapfi_tclSemanticDomain::EN_MSG_LOWERLEFTUPDATEBOUNDARY));
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U8,intmapfi_tclSemanticDomain::EN_MSG_CMDID));
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_B8_DRAWOPTIONS,intmapfi_tclSemanticDomain::EN_MSG_OPTIONS));
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONWGS84,intmapfi_tclSemanticDomain::EN_MSG_INDEXPOSITION));
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONSCREEN,intmapfi_tclSemanticDomain::EN_MSG_REFPOS));
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_E8_MAPMODE,intmapfi_tclSemanticDomain::EN_MSG_MAPMODE));
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_E8_MAPANGLE,intmapfi_tclSemanticDomain::EN_MSG_MAPANGLE));
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_E8_MAPSCALE,intmapfi_tclSemanticDomain::EN_MSG_MAPSCALE));
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_E8_MAPSTATE,intmapfi_tclSemanticDomain::EN_MSG_MAPSTATE));
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_E8_DRAWMODE,intmapfi_tclSemanticDomain::EN_MSG_DRAWMODE));
   } break;
   case intmapfi_tclToken::EN_MSG_SETSCALECONFIGMETHODSTART:
   {
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_SCALECONFIG,intmapfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_LIST,intmapfi_tclSemanticDomain::EN_MSG_T_SCALECONFIG));
   } break;
   case intmapfi_tclToken::EN_MSG_ENGENABLEFEATUREMETHODSTART:
   {
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U32,intmapfi_tclSemanticDomain::EN_MSG_FEATUREMASK));
   } break;
   case intmapfi_tclToken::EN_MSG_ENGCONFIGFEATUREMETHODSTART:
   {
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U32,intmapfi_tclSemanticDomain::EN_MSG_VALUE));
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U16,intmapfi_tclSemanticDomain::EN_MSG_KEY));
   } break;
   case intmapfi_tclToken::EN_MSG_DIRECTORYSTATUS:
   {
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U32,intmapfi_tclSemanticDomain::EN_MSG_DATABASEID));
   } break;
   case intmapfi_tclToken::EN_MSG_PARAMETERCHANGESTATUS:
   {
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U8,intmapfi_tclSemanticDomain::EN_MSG_DETAIL));
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U8,intmapfi_tclSemanticDomain::EN_MSG_COUNTER));
   } break;
   case intmapfi_tclToken::EN_MSG_DATAUPDATESTATUS:
   {
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U8,intmapfi_tclSemanticDomain::EN_MSG_UPDATECAUSE));
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U8,intmapfi_tclSemanticDomain::EN_MSG_COUNTER));
   } break;
   case intmapfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
   {
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_STRING,intmapfi_tclSemanticDomain::EN_MSG_MESSAGE));
   } break;
   case intmapfi_tclToken::EN_MSG_USEDDATASETSTATUS:
   {
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U32_DATASETID,intmapfi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U32_MEDIAID,intmapfi_tclSemanticDomain::EN_MSG_MEDIAID));
   } break;
   case intmapfi_tclToken::EN_BINCONTAINER:
   case intmapfi_tclToken::EN_RESERVED:
   case intmapfi_tclToken::EN_S32_LONGITUDE:
   case intmapfi_tclToken::EN_S32_LATITUDE:
   case intmapfi_tclToken::EN_POSITIONWGS84:
   case intmapfi_tclToken::EN_E16_ISOCOUNTRYCODE:
   case intmapfi_tclToken::EN_E16_ISOLANGUAGECODE:
   case intmapfi_tclToken::EN_U8_DIRECTIONABSOLUTE:
   case intmapfi_tclToken::EN_E16_SELECTIONCRITERIONTYPE:
   case intmapfi_tclToken::EN_U32_DATASETID:
   case intmapfi_tclToken::EN_U32_MEDIAID:
   case intmapfi_tclToken::EN_E16_NAVIEVENTVALUE:
   case intmapfi_tclToken::EN_B8_ROADNUMBERSTATUS:
   case intmapfi_tclToken::EN_COMPASSDIRECTION:
   case intmapfi_tclToken::EN_ROADNUMBER:
   case intmapfi_tclToken::EN_B8_PRESENCEINDICATOR:
   case intmapfi_tclToken::EN_B16_ROADATTRIBUTE:
   case intmapfi_tclToken::EN_E8_ROADCLASSCODE:
   case intmapfi_tclToken::EN_MAPCODEDELEMENT:
   case intmapfi_tclToken::EN_MAPCODEDELEMENTUNION0:
   case intmapfi_tclToken::EN_E8_MAPDATALEVEL:
   case intmapfi_tclToken::EN_MAPCOORDINATES:
   case intmapfi_tclToken::EN_RELATIVECOORD_8BIT:
   case intmapfi_tclToken::EN_RELATIVECOORD_16BIT:
   case intmapfi_tclToken::EN_RELATIVECOORD_24BIT:
   case intmapfi_tclToken::EN_S16_LONGITUDE:
   case intmapfi_tclToken::EN_S16_LATITUDE:
   case intmapfi_tclToken::EN_S24_LONGITUDE:
   case intmapfi_tclToken::EN_S24_LATITUDE:
   case intmapfi_tclToken::EN_POSITIONWGS84_16BIT:
   case intmapfi_tclToken::EN_POSITIONWGS84_24BIT:
   case intmapfi_tclToken::EN_E8_COORDCODE:
   case intmapfi_tclToken::EN_CODEDCOORD:
   case intmapfi_tclToken::EN_CODEDCOORDUNION0:
   case intmapfi_tclToken::EN_COORDCODINGSCHEME:
   case intmapfi_tclToken::EN_S8_MAPDISPLAYZLEVEL:
   case intmapfi_tclToken::EN_S8_MAPDISPLAYPRIORITY:
   case intmapfi_tclToken::EN_MAPCONTAINER:
   case intmapfi_tclToken::EN_E8_MAPELEMENTDESCRTYPE:
   case intmapfi_tclToken::EN_MAPELEMENTDESCRIPTOR:
   case intmapfi_tclToken::EN_MAPELEMENTDESCRIPTORUNION0:
   case intmapfi_tclToken::EN_MAPELEMENTDESCRIPTION:
   case intmapfi_tclToken::EN_E8_MAPGEOMETRICTYPE:
   case intmapfi_tclToken::EN_MAPGEOGRAPHICTYPE:
   case intmapfi_tclToken::EN_E8_SURFACECOVERCODE:
   case intmapfi_tclToken::EN_MAPREGION:
   case intmapfi_tclToken::EN_S16_XPOSSCREEN:
   case intmapfi_tclToken::EN_S16_YPOSSCREEN:
   case intmapfi_tclToken::EN_E8_DRAWMODE:
   case intmapfi_tclToken::EN_E8_MAPSTATE:
   case intmapfi_tclToken::EN_E8_MAPMODE:
   case intmapfi_tclToken::EN_E8_MAPSCALE:
   case intmapfi_tclToken::EN_E8_MAPANGLE:
   case intmapfi_tclToken::EN_POSITIONSCREEN:
   case intmapfi_tclToken::EN_B8_DRAWOPTIONS:
   case intmapfi_tclToken::EN_MAPDIRECTORY:
   case intmapfi_tclToken::EN_U16_MAPSCALE:
   case intmapfi_tclToken::EN_MAPDATALEVELDIRECTORY:
   case intmapfi_tclToken::EN_SCALECONFIG:
   case intmapfi_tclToken::EN_U8:   
   case intmapfi_tclToken::EN_S8:   
   case intmapfi_tclToken::EN_U16:   
   case intmapfi_tclToken::EN_S16:   
   case intmapfi_tclToken::EN_U24:   
   case intmapfi_tclToken::EN_S24:   
   case intmapfi_tclToken::EN_U32:   
   case intmapfi_tclToken::EN_S32:   
   case intmapfi_tclToken::EN_U64:   
   case intmapfi_tclToken::EN_S64:   
   case intmapfi_tclToken::EN_F32:   
   case intmapfi_tclToken::EN_F64:   
   case intmapfi_tclToken::EN_BOOL:   
   case intmapfi_tclToken::EN_STRING:   
   case intmapfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(intmapfi_tclKnot(enMsgToken,intmapfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool intmapfi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool intmapfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      intmapfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      intmapfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      intmapfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == intmapfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(intmapfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(intmapfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(intmapfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case intmapfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == intmapfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case intmapfi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            intmapfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(intmapfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            intmapfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(intmapfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case intmapfi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case intmapfi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intmapfi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intmapfi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intmapfi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intmapfi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intmapfi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intmapfi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intmapfi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intmapfi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intmapfi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intmapfi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intmapfi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intmapfi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case intmapfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case intmapfi_tclToken::EN_MSG_GETDIRECTORYMETHODSTART:
   case intmapfi_tclToken::EN_MSG_GETDIRECTORYMETHODRESULT:
   case intmapfi_tclToken::EN_MSG_GETREGIONMETHODSTART:
   case intmapfi_tclToken::EN_MSG_GETREGIONMETHODRESULT:
   case intmapfi_tclToken::EN_MSG_SETRESERVEDCACHINGAREASMETHODSTART:
   case intmapfi_tclToken::EN_MSG_SETRESERVEDCACHINGAREASMETHODRESULT:
   case intmapfi_tclToken::EN_MSG_DRAWMAPMETHODSTART:
   case intmapfi_tclToken::EN_MSG_DRAWMAPMETHODRESULT:
   case intmapfi_tclToken::EN_MSG_SETSCALECONFIGMETHODSTART:
   case intmapfi_tclToken::EN_MSG_SETSCALECONFIGMETHODRESULT:
   case intmapfi_tclToken::EN_MSG_ENGENABLEFEATUREMETHODSTART:
   case intmapfi_tclToken::EN_MSG_ENGENABLEFEATUREMETHODRESULT:
   case intmapfi_tclToken::EN_MSG_ENGCONFIGFEATUREMETHODSTART:
   case intmapfi_tclToken::EN_MSG_ENGCONFIGFEATUREMETHODRESULT:
   case intmapfi_tclToken::EN_MSG_DIRECTORYGET:
   case intmapfi_tclToken::EN_MSG_DIRECTORYSTATUS:
   case intmapfi_tclToken::EN_MSG_PARAMETERCHANGEGET:
   case intmapfi_tclToken::EN_MSG_PARAMETERCHANGESTATUS:
   case intmapfi_tclToken::EN_MSG_DATAUPDATEGET:
   case intmapfi_tclToken::EN_MSG_DATAUPDATESTATUS:
   case intmapfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
   case intmapfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
   case intmapfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
   case intmapfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
   case intmapfi_tclToken::EN_MSG_USEDDATASETGET:
   case intmapfi_tclToken::EN_MSG_USEDDATASETUPREG:
   case intmapfi_tclToken::EN_MSG_USEDDATASETRELUPREG:
   case intmapfi_tclToken::EN_MSG_USEDDATASETSTATUS:
      bInitMessage(enToken);
      break;
   case intmapfi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_END_OF_STRUCT,intmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U8,intmapfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_LIST,intmapfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intmapfi_tclToken::EN_RESERVED:
   {
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_S32_LONGITUDE:
   {
      fi_tcl_s32_Longitude o_s32_Longitude;
      if (!bDoIt(o_s32_Longitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_S32_LATITUDE:
   {
      fi_tcl_s32_Latitude o_s32_Latitude;
      if (!bDoIt(o_s32_Latitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_POSITIONWGS84:
   {
      if (poVisitor->bDoExpand_PositionWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_END_OF_STRUCT,intmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_S32_LATITUDE,intmapfi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_S32_LONGITUDE,intmapfi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_PositionWGS84 o_PositionWGS84;
         if (!bDoIt(o_PositionWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intmapfi_tclToken::EN_E16_ISOCOUNTRYCODE:
   {
      fi_tcl_e16_ISOCountryCode o_e16_ISOCountryCode;
      if (!bDoIt(o_e16_ISOCountryCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_E16_ISOLANGUAGECODE:
   {
      fi_tcl_e16_ISOLanguageCode o_e16_ISOLanguageCode;
      if (!bDoIt(o_e16_ISOLanguageCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_U8_DIRECTIONABSOLUTE:
   {
      fi_tcl_u8_DirectionAbsolute o_u8_DirectionAbsolute;
      if (!bDoIt(o_u8_DirectionAbsolute))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_E16_SELECTIONCRITERIONTYPE:
   {
      fi_tcl_e16_SelectionCriterionType o_e16_SelectionCriterionType;
      if (!bDoIt(o_e16_SelectionCriterionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_U32_DATASETID:
   {
      fi_tcl_u32_DataSetId o_u32_DataSetId;
      if (!bDoIt(o_u32_DataSetId))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_U32_MEDIAID:
   {
      fi_tcl_u32_MediaId o_u32_MediaId;
      if (!bDoIt(o_u32_MediaId))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_E16_NAVIEVENTVALUE:
   {
      fi_tcl_e16_NaviEventValue o_e16_NaviEventValue;
      if (!bDoIt(o_e16_NaviEventValue))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_B8_ROADNUMBERSTATUS:
   {
      fi_tcl_b8_RoadNumberStatus o_b8_RoadNumberStatus;
      if (!bDoIt(o_b8_RoadNumberStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_COMPASSDIRECTION:
   {
      if (poVisitor->bDoExpand_CompassDirection(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_END_OF_STRUCT,intmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_MULTILANGUAGESTRING,intmapfi_tclSemanticDomain::EN_DIRECTIONDESC));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U8_DIRECTIONABSOLUTE,intmapfi_tclSemanticDomain::EN_DIRECTION));
         if (u16MajorVersion <= 8)
         {
            oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_BOOL,intmapfi_tclSemanticDomain::EN_DIRECTIONISVALID));
         }
      }
      else
      {
         fi_tcl_CompassDirection o_CompassDirection;
         if (!bDoIt(o_CompassDirection))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CompassDirection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CompassDirection.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intmapfi_tclToken::EN_ROADNUMBER:
   {
      if (poVisitor->bDoExpand_RoadNumber(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_END_OF_STRUCT,intmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_COMPASSDIRECTION,intmapfi_tclSemanticDomain::EN_COMPASSDIRECTION));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_STRING,intmapfi_tclSemanticDomain::EN_NUMBERSUFFIX));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_STRING,intmapfi_tclSemanticDomain::EN_ROADNUMBER));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_STRING,intmapfi_tclSemanticDomain::EN_NUMBERPREFIX));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U8,intmapfi_tclSemanticDomain::EN_NUMBERHIERARCHY));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U32,intmapfi_tclSemanticDomain::EN_STATECODE));
         }
         if (u16MajorVersion <= 10)
         {
            oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U16,intmapfi_tclSemanticDomain::EN_STATE));
         }
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_E16_ISOCOUNTRYCODE,intmapfi_tclSemanticDomain::EN_COUNTRYCODE));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_B8_ROADNUMBERSTATUS,intmapfi_tclSemanticDomain::EN_STATUS));
      }
      else
      {
         fi_tcl_RoadNumber o_RoadNumber;
         if (!bDoIt(o_RoadNumber))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNumber.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RoadNumber.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intmapfi_tclToken::EN_B8_PRESENCEINDICATOR:
   {
      fi_tcl_b8_PresenceIndicator o_b8_PresenceIndicator;
      if (!bDoIt(o_b8_PresenceIndicator))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_B16_ROADATTRIBUTE:
   {
      fi_tcl_b16_RoadAttribute o_b16_RoadAttribute;
      if (!bDoIt(o_b16_RoadAttribute))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_E8_ROADCLASSCODE:
   {
      fi_tcl_e8_RoadClassCode o_e8_RoadClassCode;
      if (!bDoIt(o_e8_RoadClassCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_MAPCODEDELEMENTUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_b8_PresenceIndicator oDataMask;
      oCallStack.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_B8_PRESENCEINDICATOR,intmapfi_tclSemanticDomain::EN_DATA_MASK));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataMask);
      oCallStack.bGoUp();
      if (oDataMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPCOORDINATES)
      {
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_MAPCOORDINATES,intmapfi_tclSemanticDomain::EN_MAPCODEDELEMENT));
      }
      if (oDataMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_S8_MAPDISPLAYZLEVEL)
      {
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_S8_MAPDISPLAYZLEVEL,intmapfi_tclSemanticDomain::EN_MAPCODEDELEMENT));
      }
      if (oDataMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_S8_MAPDISPLAYPRIORITY)
      {
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_S8_MAPDISPLAYPRIORITY,intmapfi_tclSemanticDomain::EN_MAPCODEDELEMENT));
      }
      if (oDataMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPELEMENTDESCRIPTION)
      {
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_MAPELEMENTDESCRIPTION,intmapfi_tclSemanticDomain::EN_MAPCODEDELEMENT));
      }
      if (oDataMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_MAPGEOGRAPHICTYPE)
      {
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_MAPGEOGRAPHICTYPE,intmapfi_tclSemanticDomain::EN_MAPCODEDELEMENT));
      }
      if (oDataMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_E8_MAPGEOMETRICTYPE)
      {
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_E8_MAPGEOMETRICTYPE,intmapfi_tclSemanticDomain::EN_MAPCODEDELEMENT));
      }
      if (oDataMask.u8Value & fi_tcl_b8_PresenceIndicator::FI_C_U8_BIT_T_E16_ISOCOUNTRYCODE)
      {
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_E16_ISOCOUNTRYCODE,intmapfi_tclSemanticDomain::EN_MAPCODEDELEMENT));
      }
   } break;
   case intmapfi_tclToken::EN_MAPCODEDELEMENT:
   {
      if (poVisitor->bDoExpand_MapCodedElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_END_OF_STRUCT,intmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_MAPCODEDELEMENTUNION0,intmapfi_tclSemanticDomain::EN_MAPCODEDELEMENT));
      }
      else
      {
         fi_tcl_MapCodedElement o_MapCodedElement;
         if (!bDoIt(o_MapCodedElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapCodedElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapCodedElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intmapfi_tclToken::EN_E8_MAPDATALEVEL:
   {
      fi_tcl_e8_MapDataLevel o_e8_MapDataLevel;
      if (!bDoIt(o_e8_MapDataLevel))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_MAPCOORDINATES:
   {
      if (poVisitor->bDoExpand_MapCoordinates(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_END_OF_STRUCT,intmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONWGS84,intmapfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_LIST,intmapfi_tclSemanticDomain::EN_COORDINATES));
      }
      else
      {
         fi_tcl_MapCoordinates o_MapCoordinates;
         if (!bDoIt(o_MapCoordinates))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapCoordinates.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapCoordinates.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intmapfi_tclToken::EN_RELATIVECOORD_8BIT:
   {
      if (poVisitor->bDoExpand_RelativeCoord_8Bit(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_END_OF_STRUCT,intmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_S8,intmapfi_tclSemanticDomain::EN_S8_RELATIVELATITUDE));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_S8,intmapfi_tclSemanticDomain::EN_S8_RELATIVELONGITUDE));
      }
      else
      {
         fi_tcl_RelativeCoord_8Bit o_RelativeCoord_8Bit;
         if (!bDoIt(o_RelativeCoord_8Bit))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RelativeCoord_8Bit.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RelativeCoord_8Bit.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intmapfi_tclToken::EN_RELATIVECOORD_16BIT:
   {
      if (poVisitor->bDoExpand_RelativeCoord_16Bit(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_END_OF_STRUCT,intmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_S16,intmapfi_tclSemanticDomain::EN_S16_RELATIVELATITUDE));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_S16,intmapfi_tclSemanticDomain::EN_S16_RELATIVELONGITUDE));
      }
      else
      {
         fi_tcl_RelativeCoord_16Bit o_RelativeCoord_16Bit;
         if (!bDoIt(o_RelativeCoord_16Bit))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RelativeCoord_16Bit.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RelativeCoord_16Bit.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intmapfi_tclToken::EN_RELATIVECOORD_24BIT:
   {
      if (poVisitor->bDoExpand_RelativeCoord_24Bit(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_END_OF_STRUCT,intmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_S24,intmapfi_tclSemanticDomain::EN_S24_RELATIVELATITUDE));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_S24,intmapfi_tclSemanticDomain::EN_S24_RELATIVELONGITUDE));
      }
      else
      {
         fi_tcl_RelativeCoord_24Bit o_RelativeCoord_24Bit;
         if (!bDoIt(o_RelativeCoord_24Bit))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RelativeCoord_24Bit.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RelativeCoord_24Bit.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intmapfi_tclToken::EN_S16_LONGITUDE:
   {
      fi_tcl_s16_Longitude o_s16_Longitude;
      if (!bDoIt(o_s16_Longitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_S16_LATITUDE:
   {
      fi_tcl_s16_Latitude o_s16_Latitude;
      if (!bDoIt(o_s16_Latitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_S24_LONGITUDE:
   {
      fi_tcl_s24_Longitude o_s24_Longitude;
      if (!bDoIt(o_s24_Longitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_S24_LATITUDE:
   {
      fi_tcl_s24_Latitude o_s24_Latitude;
      if (!bDoIt(o_s24_Latitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_POSITIONWGS84_16BIT:
   {
      if (poVisitor->bDoExpand_PositionWGS84_16Bit(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_END_OF_STRUCT,intmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_S16_LATITUDE,intmapfi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_S16_LONGITUDE,intmapfi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_PositionWGS84_16Bit o_PositionWGS84_16Bit;
         if (!bDoIt(o_PositionWGS84_16Bit))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84_16Bit.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84_16Bit.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intmapfi_tclToken::EN_POSITIONWGS84_24BIT:
   {
      if (poVisitor->bDoExpand_PositionWGS84_24Bit(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_END_OF_STRUCT,intmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_S24_LATITUDE,intmapfi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_S24_LONGITUDE,intmapfi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_PositionWGS84_24Bit o_PositionWGS84_24Bit;
         if (!bDoIt(o_PositionWGS84_24Bit))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84_24Bit.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84_24Bit.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intmapfi_tclToken::EN_E8_COORDCODE:
   {
      fi_tcl_e8_CoordCode o_e8_CoordCode;
      if (!bDoIt(o_e8_CoordCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_CODEDCOORDUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_CoordCode oDataType;
      oCallStack.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_E8_COORDCODE,intmapfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_CoordCode::FI_EN_T_RESERVED:
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_RESERVED,intmapfi_tclSemanticDomain::EN_CODEDCOORDINATE));
         break;
      case fi_tcl_e8_CoordCode::FI_EN_T_POSITIONWGS84:
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONWGS84,intmapfi_tclSemanticDomain::EN_CODEDCOORDINATE));
         break;
      case fi_tcl_e8_CoordCode::FI_EN_T_POSITIONWGS84_24BIT:
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONWGS84_24BIT,intmapfi_tclSemanticDomain::EN_CODEDCOORDINATE));
         break;
      case fi_tcl_e8_CoordCode::FI_EN_T_POSITIONWGS84_16BIT:
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONWGS84_16BIT,intmapfi_tclSemanticDomain::EN_CODEDCOORDINATE));
         break;
      case fi_tcl_e8_CoordCode::FI_EN_T_RELATIVECOORD_24BIT:
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_RELATIVECOORD_24BIT,intmapfi_tclSemanticDomain::EN_CODEDCOORDINATE));
         break;
      case fi_tcl_e8_CoordCode::FI_EN_T_RELATIVECOORD_16BIT:
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_RELATIVECOORD_16BIT,intmapfi_tclSemanticDomain::EN_CODEDCOORDINATE));
         break;
      case fi_tcl_e8_CoordCode::FI_EN_T_RELATIVECOORD_8BIT:
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_RELATIVECOORD_8BIT,intmapfi_tclSemanticDomain::EN_CODEDCOORDINATE));
         break;
      }
   } break;
   case intmapfi_tclToken::EN_CODEDCOORD:
   {
      if (poVisitor->bDoExpand_CodedCoord(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_END_OF_STRUCT,intmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_CODEDCOORDUNION0,intmapfi_tclSemanticDomain::EN_CODEDCOORDINATE));
      }
      else
      {
         fi_tcl_CodedCoord o_CodedCoord;
         if (!bDoIt(o_CodedCoord))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CodedCoord.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CodedCoord.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intmapfi_tclToken::EN_COORDCODINGSCHEME:
   {
      if (poVisitor->bDoExpand_CoordCodingScheme(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_END_OF_STRUCT,intmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_CODEDCOORD,intmapfi_tclSemanticDomain::EN_BASECOORDINATE));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_E8_COORDCODE,intmapfi_tclSemanticDomain::EN_DATACOORDCODE));
      }
      else
      {
         fi_tcl_CoordCodingScheme o_CoordCodingScheme;
         if (!bDoIt(o_CoordCodingScheme))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CoordCodingScheme.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CoordCodingScheme.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intmapfi_tclToken::EN_S8_MAPDISPLAYZLEVEL:
   {
      fi_tcl_s8_MapDisplayZLevel o_s8_MapDisplayZLevel;
      if (!bDoIt(o_s8_MapDisplayZLevel))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_S8_MAPDISPLAYPRIORITY:
   {
      fi_tcl_s8_MapDisplayPriority o_s8_MapDisplayPriority;
      if (!bDoIt(o_s8_MapDisplayPriority))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_MAPCONTAINER:
   {
      if (poVisitor->bDoExpand_MapContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_END_OF_STRUCT,intmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_MAPCODEDELEMENT,intmapfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_LIST,intmapfi_tclSemanticDomain::EN_MAPCODEDELEMENTS));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_COORDCODINGSCHEME,intmapfi_tclSemanticDomain::EN_COORDCODINGSCHEME));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_E8_MAPDATALEVEL,intmapfi_tclSemanticDomain::EN_DATALEVEL));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONWGS84,intmapfi_tclSemanticDomain::EN_FULLCOVERSOUTHEAST));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONWGS84,intmapfi_tclSemanticDomain::EN_FULLCOVERNORTHWEST));
      }
      else
      {
         fi_tcl_MapContainer o_MapContainer;
         if (!bDoIt(o_MapContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intmapfi_tclToken::EN_E8_MAPELEMENTDESCRTYPE:
   {
      fi_tcl_e8_MapElementDescrType o_e8_MapElementDescrType;
      if (!bDoIt(o_e8_MapElementDescrType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_MAPELEMENTDESCRIPTORUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_MapElementDescrType oDataType;
      oCallStack.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_E8_MAPELEMENTDESCRTYPE,intmapfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_RESERVED:
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_RESERVED,intmapfi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_TSTRING:
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_STRING,intmapfi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_MAPGEOGRAPHICTYPE:
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_MAPGEOGRAPHICTYPE,intmapfi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_E8_ROADCLASSCODE:
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_E8_ROADCLASSCODE,intmapfi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_B16_ROADATTRIBUTE:
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_B16_ROADATTRIBUTE,intmapfi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_ROADNUMBER:
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_ROADNUMBER,intmapfi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_E8_SURFACECOVERCODE:
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_E8_SURFACECOVERCODE,intmapfi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_T_E16_NAVIEVENTVALUE:
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_E16_NAVIEVENTVALUE,intmapfi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      case fi_tcl_e8_MapElementDescrType::FI_EN_TMULTILANGUAGESTRING:
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_MULTILANGUAGESTRING,intmapfi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
         break;
      }
   } break;
   case intmapfi_tclToken::EN_MAPELEMENTDESCRIPTOR:
   {
      if (poVisitor->bDoExpand_MapElementDescriptor(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_END_OF_STRUCT,intmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_MAPELEMENTDESCRIPTORUNION0,intmapfi_tclSemanticDomain::EN_MAPELEMENTDESCRDATA));
      }
      else
      {
         fi_tcl_MapElementDescriptor o_MapElementDescriptor;
         if (!bDoIt(o_MapElementDescriptor))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapElementDescriptor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapElementDescriptor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intmapfi_tclToken::EN_MAPELEMENTDESCRIPTION:
   {
      if (poVisitor->bDoExpand_MapElementDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_END_OF_STRUCT,intmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_MAPELEMENTDESCRIPTOR,intmapfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_LIST,intmapfi_tclSemanticDomain::EN_DESCRIPTION));
      }
      else
      {
         fi_tcl_MapElementDescription o_MapElementDescription;
         if (!bDoIt(o_MapElementDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapElementDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapElementDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intmapfi_tclToken::EN_E8_MAPGEOMETRICTYPE:
   {
      fi_tcl_e8_MapGeometricType o_e8_MapGeometricType;
      if (!bDoIt(o_e8_MapGeometricType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_MAPGEOGRAPHICTYPE:
   {
      if (poVisitor->bDoExpand_MapGeographicType(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_END_OF_STRUCT,intmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_E16_SELECTIONCRITERIONTYPE,intmapfi_tclSemanticDomain::EN_MAPGEOGRAPHICTYPE));
      }
      else
      {
         fi_tcl_MapGeographicType o_MapGeographicType;
         if (!bDoIt(o_MapGeographicType))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapGeographicType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapGeographicType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intmapfi_tclToken::EN_E8_SURFACECOVERCODE:
   {
      fi_tcl_e8_SurfaceCoverCode o_e8_SurfaceCoverCode;
      if (!bDoIt(o_e8_SurfaceCoverCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_MAPREGION:
   {
      if (poVisitor->bDoExpand_MapRegion(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_END_OF_STRUCT,intmapfi_tclSemanticDomain::EN_UNKNOWN));
         if (7 <= u16MajorVersion)
         {
            oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U32,intmapfi_tclSemanticDomain::EN_IDENTIFIER));
         }
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONWGS84,intmapfi_tclSemanticDomain::EN_EXTPOSSOUTHEAST));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONWGS84,intmapfi_tclSemanticDomain::EN_EXTPOSNORTHWEST));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_E8_MAPDATALEVEL,intmapfi_tclSemanticDomain::EN_DATALEVEL));
      }
      else
      {
         fi_tcl_MapRegion o_MapRegion;
         if (!bDoIt(o_MapRegion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapRegion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapRegion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intmapfi_tclToken::EN_S16_XPOSSCREEN:
   {
      fi_tcl_s16_XPosScreen o_s16_XPosScreen;
      if (!bDoIt(o_s16_XPosScreen))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_S16_YPOSSCREEN:
   {
      fi_tcl_s16_YPosScreen o_s16_YPosScreen;
      if (!bDoIt(o_s16_YPosScreen))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_E8_DRAWMODE:
   {
      fi_tcl_e8_DrawMode o_e8_DrawMode;
      if (!bDoIt(o_e8_DrawMode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_E8_MAPSTATE:
   {
      fi_tcl_e8_MapState o_e8_MapState;
      if (!bDoIt(o_e8_MapState))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_E8_MAPMODE:
   {
      fi_tcl_e8_MapMode o_e8_MapMode;
      if (!bDoIt(o_e8_MapMode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_E8_MAPSCALE:
   {
      fi_tcl_e8_MapScale o_e8_MapScale;
      if (!bDoIt(o_e8_MapScale))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_E8_MAPANGLE:
   {
      fi_tcl_e8_MapAngle o_e8_MapAngle;
      if (!bDoIt(o_e8_MapAngle))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_POSITIONSCREEN:
   {
      if (poVisitor->bDoExpand_PositionScreen(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_END_OF_STRUCT,intmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_S16_YPOSSCREEN,intmapfi_tclSemanticDomain::EN_YPOS));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_S16_XPOSSCREEN,intmapfi_tclSemanticDomain::EN_XPOS));
      }
      else
      {
         fi_tcl_PositionScreen o_PositionScreen;
         if (!bDoIt(o_PositionScreen))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionScreen.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionScreen.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intmapfi_tclToken::EN_B8_DRAWOPTIONS:
   {
      fi_tcl_b8_DrawOptions o_b8_DrawOptions;
      if (!bDoIt(o_b8_DrawOptions))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_MAPDIRECTORY:
   {
      if (poVisitor->bDoExpand_MapDirectory(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_END_OF_STRUCT,intmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONWGS84,intmapfi_tclSemanticDomain::EN_EXTPOSSOUTHEAST));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_POSITIONWGS84,intmapfi_tclSemanticDomain::EN_EXTPOSNORTHWEST));
      }
      else
      {
         fi_tcl_MapDirectory o_MapDirectory;
         if (!bDoIt(o_MapDirectory))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapDirectory.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapDirectory.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intmapfi_tclToken::EN_U16_MAPSCALE:
   {
      fi_tcl_u16_MapScale o_u16_MapScale;
      if (!bDoIt(o_u16_MapScale))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case intmapfi_tclToken::EN_MAPDATALEVELDIRECTORY:
   {
      if (poVisitor->bDoExpand_MapDataLevelDirectory(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_END_OF_STRUCT,intmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U16_MAPSCALE,intmapfi_tclSemanticDomain::EN_MAXSCALE));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U16_MAPSCALE,intmapfi_tclSemanticDomain::EN_MINSCALE));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_E8_MAPDATALEVEL,intmapfi_tclSemanticDomain::EN_DATALEVEL));
      }
      else
      {
         fi_tcl_MapDataLevelDirectory o_MapDataLevelDirectory;
         if (!bDoIt(o_MapDataLevelDirectory))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapDataLevelDirectory.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapDataLevelDirectory.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case intmapfi_tclToken::EN_SCALECONFIG:
   {
      if (poVisitor->bDoExpand_ScaleConfig(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_END_OF_STRUCT,intmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U32,intmapfi_tclSemanticDomain::EN_CACHERADIUS));
         oPath.bGoDown(intmapfi_tclKnot(intmapfi_tclToken::EN_U16,intmapfi_tclSemanticDomain::EN_SCALEBARSIZE));
      }
      else
      {
         fi_tcl_ScaleConfig o_ScaleConfig;
         if (!bDoIt(o_ScaleConfig))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ScaleConfig.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ScaleConfig.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case intmapfi_tclToken::EN_UNKNOWN:
      case intmapfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

