#ifndef __INTMAPFIDEBUGVISITOR_H__
#define __INTMAPFIDEBUGVISITOR_H__

class MY_DECL intmapfi_tclPrintVisitor : public intmapfi_tclVisitorBase {

private:
   /* default constructor */ intmapfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   intmapfi_tclPrintVisitor(fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(intmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Reserved(intmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tBool bDoExpand_PositionWGS84(intmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_e16_ISOLanguageCode(fi_tcl_e16_ISOLanguageCode& o_e16_ISOLanguageCode);
   virtual tVoid vVisit_u8_DirectionAbsolute(fi_tcl_u8_DirectionAbsolute& o_u8_DirectionAbsolute);
   virtual tVoid vVisit_e16_SelectionCriterionType(fi_tcl_e16_SelectionCriterionType& o_e16_SelectionCriterionType);
   virtual tVoid vVisit_u32_DataSetId(fi_tcl_u32_DataSetId& o_u32_DataSetId);
   virtual tVoid vVisit_u32_MediaId(fi_tcl_u32_MediaId& o_u32_MediaId);
   virtual tVoid vVisit_e16_NaviEventValue(fi_tcl_e16_NaviEventValue& o_e16_NaviEventValue);
   virtual tVoid vVisit_b8_RoadNumberStatus(fi_tcl_b8_RoadNumberStatus& o_b8_RoadNumberStatus);
   virtual tBool bDoExpand_CompassDirection(intmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RoadNumber(intmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_PresenceIndicator(fi_tcl_b8_PresenceIndicator& o_b8_PresenceIndicator);
   virtual tVoid vVisit_b16_RoadAttribute(fi_tcl_b16_RoadAttribute& o_b16_RoadAttribute);
   virtual tVoid vVisit_e8_RoadClassCode(fi_tcl_e8_RoadClassCode& o_e8_RoadClassCode);
   virtual tBool bDoExpand_MapCodedElement(intmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_MapDataLevel(fi_tcl_e8_MapDataLevel& o_e8_MapDataLevel);
   virtual tBool bDoExpand_MapCoordinates(intmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RelativeCoord_8Bit(intmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RelativeCoord_16Bit(intmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RelativeCoord_24Bit(intmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s16_Longitude(fi_tcl_s16_Longitude& o_s16_Longitude);
   virtual tVoid vVisit_s16_Latitude(fi_tcl_s16_Latitude& o_s16_Latitude);
   virtual tVoid vVisit_s24_Longitude(fi_tcl_s24_Longitude& o_s24_Longitude);
   virtual tVoid vVisit_s24_Latitude(fi_tcl_s24_Latitude& o_s24_Latitude);
   virtual tBool bDoExpand_PositionWGS84_16Bit(intmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PositionWGS84_24Bit(intmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_CoordCode(fi_tcl_e8_CoordCode& o_e8_CoordCode);
   virtual tBool bDoExpand_CodedCoord(intmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CoordCodingScheme(intmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s8_MapDisplayZLevel(fi_tcl_s8_MapDisplayZLevel& o_s8_MapDisplayZLevel);
   virtual tVoid vVisit_s8_MapDisplayPriority(fi_tcl_s8_MapDisplayPriority& o_s8_MapDisplayPriority);
   virtual tBool bDoExpand_MapContainer(intmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_MapElementDescrType(fi_tcl_e8_MapElementDescrType& o_e8_MapElementDescrType);
   virtual tBool bDoExpand_MapElementDescriptor(intmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MapElementDescription(intmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_MapGeometricType(fi_tcl_e8_MapGeometricType& o_e8_MapGeometricType);
   virtual tBool bDoExpand_MapGeographicType(intmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_SurfaceCoverCode(fi_tcl_e8_SurfaceCoverCode& o_e8_SurfaceCoverCode);
   virtual tBool bDoExpand_MapRegion(intmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s16_XPosScreen(fi_tcl_s16_XPosScreen& o_s16_XPosScreen);
   virtual tVoid vVisit_s16_YPosScreen(fi_tcl_s16_YPosScreen& o_s16_YPosScreen);
   virtual tVoid vVisit_e8_DrawMode(fi_tcl_e8_DrawMode& o_e8_DrawMode);
   virtual tVoid vVisit_e8_MapState(fi_tcl_e8_MapState& o_e8_MapState);
   virtual tVoid vVisit_e8_MapMode(fi_tcl_e8_MapMode& o_e8_MapMode);
   virtual tVoid vVisit_e8_MapScale(fi_tcl_e8_MapScale& o_e8_MapScale);
   virtual tVoid vVisit_e8_MapAngle(fi_tcl_e8_MapAngle& o_e8_MapAngle);
   virtual tBool bDoExpand_PositionScreen(intmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_DrawOptions(fi_tcl_b8_DrawOptions& o_b8_DrawOptions);
   virtual tBool bDoExpand_MapDirectory(intmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u16_MapScale(fi_tcl_u16_MapScale& o_u16_MapScale);
   virtual tBool bDoExpand_MapDataLevelDirectory(intmapfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ScaleConfig(intmapfi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   fi_tclOutput* poOutput;
};


class MY_DECL intmapfi_tclRandomInitVisitor : public intmapfi_tclVisitorBase {
public:

   intmapfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_e16_ISOLanguageCode(fi_tcl_e16_ISOLanguageCode& o_e16_ISOLanguageCode);
   virtual tVoid vVisit_u8_DirectionAbsolute(fi_tcl_u8_DirectionAbsolute& o_u8_DirectionAbsolute);
   virtual tVoid vVisit_e16_SelectionCriterionType(fi_tcl_e16_SelectionCriterionType& o_e16_SelectionCriterionType);
   virtual tVoid vVisit_u32_DataSetId(fi_tcl_u32_DataSetId& o_u32_DataSetId);
   virtual tVoid vVisit_u32_MediaId(fi_tcl_u32_MediaId& o_u32_MediaId);
   virtual tVoid vVisit_e16_NaviEventValue(fi_tcl_e16_NaviEventValue& o_e16_NaviEventValue);
   virtual tVoid vVisit_b8_RoadNumberStatus(fi_tcl_b8_RoadNumberStatus& o_b8_RoadNumberStatus);
   virtual tVoid vVisit_b8_PresenceIndicator(fi_tcl_b8_PresenceIndicator& o_b8_PresenceIndicator);
   virtual tVoid vVisit_b16_RoadAttribute(fi_tcl_b16_RoadAttribute& o_b16_RoadAttribute);
   virtual tVoid vVisit_e8_RoadClassCode(fi_tcl_e8_RoadClassCode& o_e8_RoadClassCode);
   virtual tVoid vVisit_e8_MapDataLevel(fi_tcl_e8_MapDataLevel& o_e8_MapDataLevel);
   virtual tVoid vVisit_s16_Longitude(fi_tcl_s16_Longitude& o_s16_Longitude);
   virtual tVoid vVisit_s16_Latitude(fi_tcl_s16_Latitude& o_s16_Latitude);
   virtual tVoid vVisit_s24_Longitude(fi_tcl_s24_Longitude& o_s24_Longitude);
   virtual tVoid vVisit_s24_Latitude(fi_tcl_s24_Latitude& o_s24_Latitude);
   virtual tVoid vVisit_e8_CoordCode(fi_tcl_e8_CoordCode& o_e8_CoordCode);
   virtual tVoid vVisit_s8_MapDisplayZLevel(fi_tcl_s8_MapDisplayZLevel& o_s8_MapDisplayZLevel);
   virtual tVoid vVisit_s8_MapDisplayPriority(fi_tcl_s8_MapDisplayPriority& o_s8_MapDisplayPriority);
   virtual tVoid vVisit_e8_MapElementDescrType(fi_tcl_e8_MapElementDescrType& o_e8_MapElementDescrType);
   virtual tVoid vVisit_e8_MapGeometricType(fi_tcl_e8_MapGeometricType& o_e8_MapGeometricType);
   virtual tVoid vVisit_e8_SurfaceCoverCode(fi_tcl_e8_SurfaceCoverCode& o_e8_SurfaceCoverCode);
   virtual tVoid vVisit_s16_XPosScreen(fi_tcl_s16_XPosScreen& o_s16_XPosScreen);
   virtual tVoid vVisit_s16_YPosScreen(fi_tcl_s16_YPosScreen& o_s16_YPosScreen);
   virtual tVoid vVisit_e8_DrawMode(fi_tcl_e8_DrawMode& o_e8_DrawMode);
   virtual tVoid vVisit_e8_MapState(fi_tcl_e8_MapState& o_e8_MapState);
   virtual tVoid vVisit_e8_MapMode(fi_tcl_e8_MapMode& o_e8_MapMode);
   virtual tVoid vVisit_e8_MapScale(fi_tcl_e8_MapScale& o_e8_MapScale);
   virtual tVoid vVisit_e8_MapAngle(fi_tcl_e8_MapAngle& o_e8_MapAngle);
   virtual tVoid vVisit_b8_DrawOptions(fi_tcl_b8_DrawOptions& o_b8_DrawOptions);
   virtual tVoid vVisit_u16_MapScale(fi_tcl_u16_MapScale& o_u16_MapScale);
	tU32 u32ListSize;
};

#endif
