/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef INTEDMFITYPES_HEADER
#define INTEDMFITYPES_HEADER

// #include <vector>
// 


class intedmfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodStart():NavDataSetID(),RDBId(),CountryCodeOfMessage(),LocationType(),PrimaryLocation(0),SecondaryLocation(0),Extent(0),Direction(0),BiDirectional(0),IntersectionPath() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodStart& operator=(const intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodStart& coRef);
   intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodStart(const intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId NavDataSetID;
   fi_tcl_RDBId RDBId;
   fi_tcl_e16_ISOCountryCode CountryCodeOfMessage;
   fi_tcl_e8_TMLocationType LocationType;
   tU16 PrimaryLocation;
   tU16 SecondaryLocation;
   tU8 Extent;
   tBool Direction;
   tBool BiDirectional;
   fi_tcl_b8_TMCIntersectionPath IntersectionPath;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intedmfi_tclToken::EN_MSG_GETTRAFFICMESSAGEINTERSECTIONONECELLSMETHODSTART;}
};

class intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodResult():NavDataSetID(),Shape(),RoadClass(),PrefixPriority(0),RoadNumberPrefix(),RoadNumber(),RoadNumberSuffix(),RoadName(),StateCode(0),NumberHierarchy(0),SegmentId(0),LocationSegmentIdx(0),Delay(),Length() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodResult& operator=(const intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodResult& coRef);
   intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodResult(const intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId NavDataSetID;
   fi_tcl_Shape Shape;
   fi_tcl_e8_RoadClassCode RoadClass;
   tU8 PrefixPriority;
   fi_tclString RoadNumberPrefix;
   fi_tclString RoadNumber;
   fi_tclString RoadNumberSuffix;
   fi_tcl_TMCStructuredText RoadName;
   tU32 StateCode;
   tU8 NumberHierarchy;
   tU16 SegmentId;
   tU16 LocationSegmentIdx;
   fi_tcl_s32_Second Delay;
   fi_tcl_s32_Meter Length;
   std::vector<fi_tcl_TMIntersectionPath, std::allocator<fi_tcl_TMIntersectionPath> > IntersectionPath;
   std::vector<fi_tcl_NavClusterDesc, std::allocator<fi_tcl_NavClusterDesc> > Cluster;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intedmfi_tclMsgGetTrafficMessageIntersectionOneCellsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intedmfi_tclToken::EN_MSG_GETTRAFFICMESSAGEINTERSECTIONONECELLSMETHODRESULT;}
};

class intedmfi_tclMsgGetTrafficMessageOneCellsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intedmfi_tclMsgGetTrafficMessageOneCellsMethodStart():NavDataSetID(),RDBId(),CountryCodeOfMessage(),LocationType(),PrimaryLocation(0),SecondaryLocation(0),Extent(0),Direction(0),BiDirectional(0),PreciseLocationDescription(),TMFlowImpact(),Speed(),VLI(),Delay(),EventLength() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intedmfi_tclMsgGetTrafficMessageOneCellsMethodStart& operator=(const intedmfi_tclMsgGetTrafficMessageOneCellsMethodStart& coRef);
   intedmfi_tclMsgGetTrafficMessageOneCellsMethodStart(const intedmfi_tclMsgGetTrafficMessageOneCellsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId NavDataSetID;
   fi_tcl_RDBId RDBId;
   fi_tcl_e16_ISOCountryCode CountryCodeOfMessage;
   fi_tcl_e8_TMLocationType LocationType;
   tU16 PrimaryLocation;
   tU16 SecondaryLocation;
   tU8 Extent;
   tBool Direction;
   tBool BiDirectional;
   fi_tcl_TMPreciseLocationDescription PreciseLocationDescription;
   fi_tcl_e8_TMExtendedFlowImpact TMFlowImpact;
   fi_tcl_s16_KmPerHour Speed;
   fi_tcl_u8_Percent VLI;
   fi_tcl_s32_Second Delay;
   fi_tcl_s32_Meter EventLength;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intedmfi_tclMsgGetTrafficMessageOneCellsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intedmfi_tclToken::EN_MSG_GETTRAFFICMESSAGEONECELLSMETHODSTART;}
};

class intedmfi_tclMsgGetTrafficMessageOneCellsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intedmfi_tclMsgGetTrafficMessageOneCellsMethodResult():NavDataSetID(),Shape(),RoadClass(),PrefixPriority(0),RoadNumberPrefix(),RoadNumber(),RoadNumberSuffix(),RoadName(),StateCode(0),NumberHierarchy(0),SegmentId(0),LocationSegmentIdx(0),Delay(),DelayStatus(),Length(),LengthStatus(),FlowValue(0),NonGeneralisedExtent(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intedmfi_tclMsgGetTrafficMessageOneCellsMethodResult& operator=(const intedmfi_tclMsgGetTrafficMessageOneCellsMethodResult& coRef);
   intedmfi_tclMsgGetTrafficMessageOneCellsMethodResult(const intedmfi_tclMsgGetTrafficMessageOneCellsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId NavDataSetID;
   fi_tcl_Shape Shape;
   fi_tcl_e8_RoadClassCode RoadClass;
   tU8 PrefixPriority;
   fi_tclString RoadNumberPrefix;
   fi_tclString RoadNumber;
   fi_tclString RoadNumberSuffix;
   fi_tcl_TMCStructuredText RoadName;
   tU32 StateCode;
   tU8 NumberHierarchy;
   tU16 SegmentId;
   tU16 LocationSegmentIdx;
   fi_tcl_s32_Second Delay;
   fi_tcl_e8_TMValueStatus DelayStatus;
   fi_tcl_s32_Meter Length;
   fi_tcl_e8_TMValueStatus LengthStatus;
   tU8 FlowValue;
   tU32 NonGeneralisedExtent;
   std::vector<fi_tcl_EDMLevelOCList, std::allocator<fi_tcl_EDMLevelOCList> > EDMLevelOCList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intedmfi_tclMsgGetTrafficMessageOneCellsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intedmfi_tclToken::EN_MSG_GETTRAFFICMESSAGEONECELLSMETHODRESULT;}
};

class intedmfi_tclMsgGetExistingRDBsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intedmfi_tclMsgGetExistingRDBsMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intedmfi_tclMsgGetExistingRDBsMethodStart& operator=(const intedmfi_tclMsgGetExistingRDBsMethodStart& coRef);
   intedmfi_tclMsgGetExistingRDBsMethodStart(const intedmfi_tclMsgGetExistingRDBsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intedmfi_tclMsgGetExistingRDBsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intedmfi_tclToken::EN_MSG_GETEXISTINGRDBSMETHODSTART;}
};

class intedmfi_tclMsgGetExistingRDBsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intedmfi_tclMsgGetExistingRDBsMethodResult():NavDataSetID() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intedmfi_tclMsgGetExistingRDBsMethodResult& operator=(const intedmfi_tclMsgGetExistingRDBsMethodResult& coRef);
   intedmfi_tclMsgGetExistingRDBsMethodResult(const intedmfi_tclMsgGetExistingRDBsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId NavDataSetID;
   std::vector<fi_tcl_ISORDBId, std::allocator<fi_tcl_ISORDBId> > RDBList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intedmfi_tclMsgGetExistingRDBsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intedmfi_tclToken::EN_MSG_GETEXISTINGRDBSMETHODRESULT;}
};

class intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodStart():NavDataSetID(),ResetTMCCache(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodStart& operator=(const intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodStart& coRef);
   intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodStart(const intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_DataSetId NavDataSetID;
   tBool ResetTMCCache;
   std::vector<fi_tcl_TMDescription, std::allocator<fi_tcl_TMDescription> > TrafficMessages;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intedmfi_tclToken::EN_MSG_CHECKTRAFFICMESSAGESTRANSLATABLETOTEXTMETHODSTART;}
};

class intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodResult& operator=(const intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodResult& coRef);
   intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodResult(const intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_TMRequirementFulfilment, std::allocator<fi_tcl_TMRequirementFulfilment> > TrafficMessages;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intedmfi_tclMsgCheckTrafficMessagesTranslatableToTextMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intedmfi_tclToken::EN_MSG_CHECKTRAFFICMESSAGESTRANSLATABLETOTEXTMETHODRESULT;}
};

class intedmfi_tclMsgCheckMOCDBClientsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intedmfi_tclMsgCheckMOCDBClientsMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intedmfi_tclMsgCheckMOCDBClientsMethodStart& operator=(const intedmfi_tclMsgCheckMOCDBClientsMethodStart& coRef);
   intedmfi_tclMsgCheckMOCDBClientsMethodStart(const intedmfi_tclMsgCheckMOCDBClientsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intedmfi_tclMsgCheckMOCDBClientsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intedmfi_tclToken::EN_MSG_CHECKMOCDBCLIENTSMETHODSTART;}
};

class intedmfi_tclMsgCheckMOCDBClientsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intedmfi_tclMsgCheckMOCDBClientsMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intedmfi_tclMsgCheckMOCDBClientsMethodResult& operator=(const intedmfi_tclMsgCheckMOCDBClientsMethodResult& coRef);
   intedmfi_tclMsgCheckMOCDBClientsMethodResult(const intedmfi_tclMsgCheckMOCDBClientsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intedmfi_tclMsgCheckMOCDBClientsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intedmfi_tclToken::EN_MSG_CHECKMOCDBCLIENTSMETHODRESULT;}
};

class intedmfi_tclMsgTrafficMessageDataSetGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intedmfi_tclMsgTrafficMessageDataSetGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intedmfi_tclMsgTrafficMessageDataSetGet& operator=(const intedmfi_tclMsgTrafficMessageDataSetGet& coRef);
   intedmfi_tclMsgTrafficMessageDataSetGet(const intedmfi_tclMsgTrafficMessageDataSetGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intedmfi_tclMsgTrafficMessageDataSetGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intedmfi_tclToken::EN_MSG_TRAFFICMESSAGEDATASETGET;}
};

class intedmfi_tclMsgTrafficMessageDataSetStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intedmfi_tclMsgTrafficMessageDataSetStatus():MediaId(),DataSetId(),Availability() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intedmfi_tclMsgTrafficMessageDataSetStatus& operator=(const intedmfi_tclMsgTrafficMessageDataSetStatus& coRef);
   intedmfi_tclMsgTrafficMessageDataSetStatus(const intedmfi_tclMsgTrafficMessageDataSetStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u32_MediaId MediaId;
   fi_tcl_u32_DataSetId DataSetId;
   fi_tcl_e8_DataAvailable Availability;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intedmfi_tclMsgTrafficMessageDataSetStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intedmfi_tclToken::EN_MSG_TRAFFICMESSAGEDATASETSTATUS;}
};

class intedmfi_tclMsgEngineeringTextGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intedmfi_tclMsgEngineeringTextGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intedmfi_tclMsgEngineeringTextGet& operator=(const intedmfi_tclMsgEngineeringTextGet& coRef);
   intedmfi_tclMsgEngineeringTextGet(const intedmfi_tclMsgEngineeringTextGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intedmfi_tclMsgEngineeringTextGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intedmfi_tclToken::EN_MSG_ENGINEERINGTEXTGET;}
};

class intedmfi_tclMsgEngineeringTextUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intedmfi_tclMsgEngineeringTextUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intedmfi_tclMsgEngineeringTextUpReg& operator=(const intedmfi_tclMsgEngineeringTextUpReg& coRef);
   intedmfi_tclMsgEngineeringTextUpReg(const intedmfi_tclMsgEngineeringTextUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intedmfi_tclMsgEngineeringTextUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intedmfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG;}
};

class intedmfi_tclMsgEngineeringTextRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intedmfi_tclMsgEngineeringTextRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intedmfi_tclMsgEngineeringTextRelUpReg& operator=(const intedmfi_tclMsgEngineeringTextRelUpReg& coRef);
   intedmfi_tclMsgEngineeringTextRelUpReg(const intedmfi_tclMsgEngineeringTextRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intedmfi_tclMsgEngineeringTextRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intedmfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG;}
};

class intedmfi_tclMsgEngineeringTextStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   intedmfi_tclMsgEngineeringTextStatus():Message() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   intedmfi_tclMsgEngineeringTextStatus& operator=(const intedmfi_tclMsgEngineeringTextStatus& coRef);
   intedmfi_tclMsgEngineeringTextStatus(const intedmfi_tclMsgEngineeringTextStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString Message;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const intedmfi_tclMsgEngineeringTextStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return intedmfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS;}
};


#endif
