/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef FUELFITYPES_HEADER
#define FUELFITYPES_HEADER

// #include <vector>
// 


class fuelfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class fuelfi_tclMsgGetFuelPriceDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fuelfi_tclMsgGetFuelPriceDataMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fuelfi_tclMsgGetFuelPriceDataMethodStart& operator=(const fuelfi_tclMsgGetFuelPriceDataMethodStart& coRef);
   fuelfi_tclMsgGetFuelPriceDataMethodStart(const fuelfi_tclMsgGetFuelPriceDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_FuelStation, std::allocator<fi_tcl_FuelStation> > FuelStationList;
   std::vector<fi_tcl_FuelTypeCode, std::allocator<fi_tcl_FuelTypeCode> > FuelTypeList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fuelfi_tclMsgGetFuelPriceDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fuelfi_tclToken::EN_MSG_GETFUELPRICEDATAMETHODSTART;}
};

class fuelfi_tclMsgGetFuelPriceDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fuelfi_tclMsgGetFuelPriceDataMethodResult():UpdateId() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fuelfi_tclMsgGetFuelPriceDataMethodResult& operator=(const fuelfi_tclMsgGetFuelPriceDataMethodResult& coRef);
   fuelfi_tclMsgGetFuelPriceDataMethodResult(const fuelfi_tclMsgGetFuelPriceDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UpdateId UpdateId;
   std::vector<fi_tcl_FuelType, std::allocator<fi_tcl_FuelType> > FuelTypeList;
   std::vector<fi_tcl_FuelStationPrices, std::allocator<fi_tcl_FuelStationPrices> > FuelStationPricesList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fuelfi_tclMsgGetFuelPriceDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fuelfi_tclToken::EN_MSG_GETFUELPRICEDATAMETHODRESULT;}
};

class fuelfi_tclMsgGetListOfFuelTypesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fuelfi_tclMsgGetListOfFuelTypesMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fuelfi_tclMsgGetListOfFuelTypesMethodStart& operator=(const fuelfi_tclMsgGetListOfFuelTypesMethodStart& coRef);
   fuelfi_tclMsgGetListOfFuelTypesMethodStart(const fuelfi_tclMsgGetListOfFuelTypesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fuelfi_tclMsgGetListOfFuelTypesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fuelfi_tclToken::EN_MSG_GETLISTOFFUELTYPESMETHODSTART;}
};

class fuelfi_tclMsgGetListOfFuelTypesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fuelfi_tclMsgGetListOfFuelTypesMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fuelfi_tclMsgGetListOfFuelTypesMethodResult& operator=(const fuelfi_tclMsgGetListOfFuelTypesMethodResult& coRef);
   fuelfi_tclMsgGetListOfFuelTypesMethodResult(const fuelfi_tclMsgGetListOfFuelTypesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_FuelType, std::allocator<fi_tcl_FuelType> > FuelTypeList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fuelfi_tclMsgGetListOfFuelTypesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fuelfi_tclToken::EN_MSG_GETLISTOFFUELTYPESMETHODRESULT;}
};

class fuelfi_tclMsgGetListOfFuelStationDescriptionMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fuelfi_tclMsgGetListOfFuelStationDescriptionMethodStart():DescriptionRequest() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fuelfi_tclMsgGetListOfFuelStationDescriptionMethodStart& operator=(const fuelfi_tclMsgGetListOfFuelStationDescriptionMethodStart& coRef);
   fuelfi_tclMsgGetListOfFuelStationDescriptionMethodStart(const fuelfi_tclMsgGetListOfFuelStationDescriptionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_FuelStation, std::allocator<fi_tcl_FuelStation> > FuelStationList;
   fi_tcl_b16_StationDescriptionRequest DescriptionRequest;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fuelfi_tclMsgGetListOfFuelStationDescriptionMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fuelfi_tclToken::EN_MSG_GETLISTOFFUELSTATIONDESCRIPTIONMETHODSTART;}
};

class fuelfi_tclMsgGetListOfFuelStationDescriptionMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fuelfi_tclMsgGetListOfFuelStationDescriptionMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fuelfi_tclMsgGetListOfFuelStationDescriptionMethodResult& operator=(const fuelfi_tclMsgGetListOfFuelStationDescriptionMethodResult& coRef);
   fuelfi_tclMsgGetListOfFuelStationDescriptionMethodResult(const fuelfi_tclMsgGetListOfFuelStationDescriptionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_FuelStationDescription, std::allocator<fi_tcl_FuelStationDescription> > FuelStationDescription;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fuelfi_tclMsgGetListOfFuelStationDescriptionMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fuelfi_tclToken::EN_MSG_GETLISTOFFUELSTATIONDESCRIPTIONMETHODRESULT;}
};

class fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodStart():Distance(),MaxNumberOfStations(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodStart& operator=(const fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodStart& coRef);
   fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodStart(const fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_PositionWGS84, std::allocator<fi_tcl_PositionWGS84> > ListOfPosition;
   fi_tcl_s32_Meter Distance;
   tU16 MaxNumberOfStations;
   std::vector<fi_tcl_FuelTypeCode, std::allocator<fi_tcl_FuelTypeCode> > FuelTypeList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fuelfi_tclToken::EN_MSG_GETLISTOFFUELPRICEDATABYPOSITIONMETHODSTART;}
};

class fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodResult():UpdateId() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodResult& operator=(const fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodResult& coRef);
   fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodResult(const fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UpdateId UpdateId;
   std::vector<fi_tcl_FuelType, std::allocator<fi_tcl_FuelType> > FuelTypeList;
   std::vector<fi_tcl_FuelStationPricesForPosition, std::allocator<fi_tcl_FuelStationPricesForPosition> > FuelStationPricesForPositionList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fuelfi_tclToken::EN_MSG_GETLISTOFFUELPRICEDATABYPOSITIONMETHODRESULT;}
};

class fuelfi_tclMsgNewFuelPricesAvailableGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fuelfi_tclMsgNewFuelPricesAvailableGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fuelfi_tclMsgNewFuelPricesAvailableGet& operator=(const fuelfi_tclMsgNewFuelPricesAvailableGet& coRef);
   fuelfi_tclMsgNewFuelPricesAvailableGet(const fuelfi_tclMsgNewFuelPricesAvailableGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fuelfi_tclMsgNewFuelPricesAvailableGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fuelfi_tclToken::EN_MSG_NEWFUELPRICESAVAILABLEGET;}
};

class fuelfi_tclMsgNewFuelPricesAvailableUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fuelfi_tclMsgNewFuelPricesAvailableUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fuelfi_tclMsgNewFuelPricesAvailableUpReg& operator=(const fuelfi_tclMsgNewFuelPricesAvailableUpReg& coRef);
   fuelfi_tclMsgNewFuelPricesAvailableUpReg(const fuelfi_tclMsgNewFuelPricesAvailableUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fuelfi_tclMsgNewFuelPricesAvailableUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fuelfi_tclToken::EN_MSG_NEWFUELPRICESAVAILABLEUPREG;}
};

class fuelfi_tclMsgNewFuelPricesAvailableRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fuelfi_tclMsgNewFuelPricesAvailableRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fuelfi_tclMsgNewFuelPricesAvailableRelUpReg& operator=(const fuelfi_tclMsgNewFuelPricesAvailableRelUpReg& coRef);
   fuelfi_tclMsgNewFuelPricesAvailableRelUpReg(const fuelfi_tclMsgNewFuelPricesAvailableRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fuelfi_tclMsgNewFuelPricesAvailableRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fuelfi_tclToken::EN_MSG_NEWFUELPRICESAVAILABLERELUPREG;}
};

class fuelfi_tclMsgNewFuelPricesAvailableStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fuelfi_tclMsgNewFuelPricesAvailableStatus():UpdateId() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fuelfi_tclMsgNewFuelPricesAvailableStatus& operator=(const fuelfi_tclMsgNewFuelPricesAvailableStatus& coRef);
   fuelfi_tclMsgNewFuelPricesAvailableStatus(const fuelfi_tclMsgNewFuelPricesAvailableStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UpdateId UpdateId;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fuelfi_tclMsgNewFuelPricesAvailableStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fuelfi_tclToken::EN_MSG_NEWFUELPRICESAVAILABLESTATUS;}
};

class fuelfi_tclMsgEngineeringTextGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fuelfi_tclMsgEngineeringTextGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fuelfi_tclMsgEngineeringTextGet& operator=(const fuelfi_tclMsgEngineeringTextGet& coRef);
   fuelfi_tclMsgEngineeringTextGet(const fuelfi_tclMsgEngineeringTextGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fuelfi_tclMsgEngineeringTextGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fuelfi_tclToken::EN_MSG_ENGINEERINGTEXTGET;}
};

class fuelfi_tclMsgEngineeringTextUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fuelfi_tclMsgEngineeringTextUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fuelfi_tclMsgEngineeringTextUpReg& operator=(const fuelfi_tclMsgEngineeringTextUpReg& coRef);
   fuelfi_tclMsgEngineeringTextUpReg(const fuelfi_tclMsgEngineeringTextUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fuelfi_tclMsgEngineeringTextUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fuelfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG;}
};

class fuelfi_tclMsgEngineeringTextRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fuelfi_tclMsgEngineeringTextRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fuelfi_tclMsgEngineeringTextRelUpReg& operator=(const fuelfi_tclMsgEngineeringTextRelUpReg& coRef);
   fuelfi_tclMsgEngineeringTextRelUpReg(const fuelfi_tclMsgEngineeringTextRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fuelfi_tclMsgEngineeringTextRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fuelfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG;}
};

class fuelfi_tclMsgEngineeringTextStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   fuelfi_tclMsgEngineeringTextStatus():Message() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fuelfi_tclMsgEngineeringTextStatus& operator=(const fuelfi_tclMsgEngineeringTextStatus& coRef);
   fuelfi_tclMsgEngineeringTextStatus(const fuelfi_tclMsgEngineeringTextStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString Message;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const fuelfi_tclMsgEngineeringTextStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return fuelfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS;}
};


#endif
