/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgGetFuelPriceDataMethodStart::fuelfi_tclMsgGetFuelPriceDataMethodStart(const fuelfi_tclMsgGetFuelPriceDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   FuelStationList = coRef.FuelStationList;
   FuelTypeList = coRef.FuelTypeList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgGetFuelPriceDataMethodStart& fuelfi_tclMsgGetFuelPriceDataMethodStart::operator=(const fuelfi_tclMsgGetFuelPriceDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FuelStationList = coRef.FuelStationList;
   FuelTypeList = coRef.FuelTypeList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fuelfi_tclMsgGetFuelPriceDataMethodStart::u16GetServiceID() const {return FUELFI_C_U16_SERVICE_ID;}
tU16 fuelfi_tclMsgGetFuelPriceDataMethodStart::u16GetFunctionID() const {return FUELFI_C_U16_GETFUELPRICEDATA;}
tU8 fuelfi_tclMsgGetFuelPriceDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid fuelfi_tclMsgGetFuelPriceDataMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < FuelStationList.size(); ++u32Idx)
         FuelStationList[u32Idx].vDestroy();
   }
   FuelStationList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < FuelTypeList.size(); ++u32Idx)
         FuelTypeList[u32Idx].vDestroy();
   }
   FuelTypeList.clear();
}

tU32 fuelfi_tclMsgGetFuelPriceDataMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      u32DynamicSize += FuelTypeList.size()*1;
   }
   return u32DynamicSize+4+FuelStationList.size()*4;
}

tBool fuelfi_tclMsgGetFuelPriceDataMethodStart::operator==(const fuelfi_tclMsgGetFuelPriceDataMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FuelStationList.size() == rfoCmp.FuelStationList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FuelStationList.size()); ++u32Idx)
            bResult = bResult && (FuelStationList[u32Idx] == rfoCmp.FuelStationList[u32Idx]);
      }
      bResult = bResult && (FuelTypeList.size() == rfoCmp.FuelTypeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FuelTypeList.size()); ++u32Idx)
            bResult = bResult && (FuelTypeList[u32Idx] == rfoCmp.FuelTypeList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fuelfi_tclMsgGetFuelPriceDataMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FuelStationList.size(); ++u32Idx)
      {
         FuelStationList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      FuelStationList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> FuelStationList[u32Idx];
      }
   }
   if (3 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < FuelTypeList.size(); ++u32Idx)
         {
            FuelTypeList[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         FuelTypeList.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> FuelTypeList[u32Idx];
         }
      }
   }
   return oIn;
}

fi_tclOutContext& fuelfi_tclMsgGetFuelPriceDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)FuelStationList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < FuelStationList.size(); ++u32Idx)
         oOut << FuelStationList[u32Idx];
   }
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)FuelTypeList.size();
      {
         for (tU32 u32Idx = 0; u32Idx < FuelTypeList.size(); ++u32Idx)
            oOut << FuelTypeList[u32Idx];
      }
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgGetFuelPriceDataMethodResult::fuelfi_tclMsgGetFuelPriceDataMethodResult(const fuelfi_tclMsgGetFuelPriceDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateId = coRef.UpdateId;
   FuelTypeList = coRef.FuelTypeList;
   FuelStationPricesList = coRef.FuelStationPricesList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgGetFuelPriceDataMethodResult& fuelfi_tclMsgGetFuelPriceDataMethodResult::operator=(const fuelfi_tclMsgGetFuelPriceDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UpdateId = coRef.UpdateId;
   FuelTypeList = coRef.FuelTypeList;
   FuelStationPricesList = coRef.FuelStationPricesList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fuelfi_tclMsgGetFuelPriceDataMethodResult::u16GetServiceID() const {return FUELFI_C_U16_SERVICE_ID;}
tU16 fuelfi_tclMsgGetFuelPriceDataMethodResult::u16GetFunctionID() const {return FUELFI_C_U16_GETFUELPRICEDATA;}
tU8 fuelfi_tclMsgGetFuelPriceDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid fuelfi_tclMsgGetFuelPriceDataMethodResult::vDestroy()
{
   UpdateId.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < FuelTypeList.size(); ++u32Idx)
         FuelTypeList[u32Idx].vDestroy();
   }
   FuelTypeList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < FuelStationPricesList.size(); ++u32Idx)
         FuelStationPricesList[u32Idx].vDestroy();
   }
   FuelStationPricesList.clear();
}

tU32 fuelfi_tclMsgGetFuelPriceDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < FuelTypeList.size(); ++u32ListIdx)
      u32DynamicSize += FuelTypeList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < FuelStationPricesList.size(); ++u32ListIdx)
      u32DynamicSize += FuelStationPricesList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+10;
}

tBool fuelfi_tclMsgGetFuelPriceDataMethodResult::operator==(const fuelfi_tclMsgGetFuelPriceDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateId == rfoCmp.UpdateId);
      bResult = bResult && (FuelTypeList.size() == rfoCmp.FuelTypeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FuelTypeList.size()); ++u32Idx)
            bResult = bResult && (FuelTypeList[u32Idx] == rfoCmp.FuelTypeList[u32Idx]);
      }
      bResult = bResult && (FuelStationPricesList.size() == rfoCmp.FuelStationPricesList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FuelStationPricesList.size()); ++u32Idx)
            bResult = bResult && (FuelStationPricesList[u32Idx] == rfoCmp.FuelStationPricesList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fuelfi_tclMsgGetFuelPriceDataMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UpdateId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FuelTypeList.size(); ++u32Idx)
      {
         FuelTypeList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      FuelTypeList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> FuelTypeList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FuelStationPricesList.size(); ++u32Idx)
      {
         FuelStationPricesList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      FuelStationPricesList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> FuelStationPricesList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fuelfi_tclMsgGetFuelPriceDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UpdateId;
   oOut << (tU32)FuelTypeList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < FuelTypeList.size(); ++u32Idx)
         oOut << FuelTypeList[u32Idx];
   }
   oOut << (tU32)FuelStationPricesList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < FuelStationPricesList.size(); ++u32Idx)
         oOut << FuelStationPricesList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgGetListOfFuelTypesMethodStart::fuelfi_tclMsgGetListOfFuelTypesMethodStart(const fuelfi_tclMsgGetListOfFuelTypesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgGetListOfFuelTypesMethodStart& fuelfi_tclMsgGetListOfFuelTypesMethodStart::operator=(const fuelfi_tclMsgGetListOfFuelTypesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fuelfi_tclMsgGetListOfFuelTypesMethodStart::u16GetServiceID() const {return FUELFI_C_U16_SERVICE_ID;}
tU16 fuelfi_tclMsgGetListOfFuelTypesMethodStart::u16GetFunctionID() const {return FUELFI_C_U16_GETLISTOFFUELTYPES;}
tU8 fuelfi_tclMsgGetListOfFuelTypesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 fuelfi_tclMsgGetListOfFuelTypesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool fuelfi_tclMsgGetListOfFuelTypesMethodStart::operator==(const fuelfi_tclMsgGetListOfFuelTypesMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& fuelfi_tclMsgGetListOfFuelTypesMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& fuelfi_tclMsgGetListOfFuelTypesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgGetListOfFuelTypesMethodResult::fuelfi_tclMsgGetListOfFuelTypesMethodResult(const fuelfi_tclMsgGetListOfFuelTypesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   FuelTypeList = coRef.FuelTypeList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgGetListOfFuelTypesMethodResult& fuelfi_tclMsgGetListOfFuelTypesMethodResult::operator=(const fuelfi_tclMsgGetListOfFuelTypesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   FuelTypeList = coRef.FuelTypeList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fuelfi_tclMsgGetListOfFuelTypesMethodResult::u16GetServiceID() const {return FUELFI_C_U16_SERVICE_ID;}
tU16 fuelfi_tclMsgGetListOfFuelTypesMethodResult::u16GetFunctionID() const {return FUELFI_C_U16_GETLISTOFFUELTYPES;}
tU8 fuelfi_tclMsgGetListOfFuelTypesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid fuelfi_tclMsgGetListOfFuelTypesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < FuelTypeList.size(); ++u32Idx)
         FuelTypeList[u32Idx].vDestroy();
   }
   FuelTypeList.clear();
}

tU32 fuelfi_tclMsgGetListOfFuelTypesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < FuelTypeList.size(); ++u32ListIdx)
      u32DynamicSize += FuelTypeList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool fuelfi_tclMsgGetListOfFuelTypesMethodResult::operator==(const fuelfi_tclMsgGetListOfFuelTypesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FuelTypeList.size() == rfoCmp.FuelTypeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FuelTypeList.size()); ++u32Idx)
            bResult = bResult && (FuelTypeList[u32Idx] == rfoCmp.FuelTypeList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fuelfi_tclMsgGetListOfFuelTypesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FuelTypeList.size(); ++u32Idx)
      {
         FuelTypeList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      FuelTypeList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> FuelTypeList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fuelfi_tclMsgGetListOfFuelTypesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)FuelTypeList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < FuelTypeList.size(); ++u32Idx)
         oOut << FuelTypeList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgGetListOfFuelStationDescriptionMethodStart::fuelfi_tclMsgGetListOfFuelStationDescriptionMethodStart(const fuelfi_tclMsgGetListOfFuelStationDescriptionMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   FuelStationList = coRef.FuelStationList;
   DescriptionRequest = coRef.DescriptionRequest;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgGetListOfFuelStationDescriptionMethodStart& fuelfi_tclMsgGetListOfFuelStationDescriptionMethodStart::operator=(const fuelfi_tclMsgGetListOfFuelStationDescriptionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FuelStationList = coRef.FuelStationList;
   DescriptionRequest = coRef.DescriptionRequest;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fuelfi_tclMsgGetListOfFuelStationDescriptionMethodStart::u16GetServiceID() const {return FUELFI_C_U16_SERVICE_ID;}
tU16 fuelfi_tclMsgGetListOfFuelStationDescriptionMethodStart::u16GetFunctionID() const {return FUELFI_C_U16_GETLISTOFFUELSTATIONDESCRIPTION;}
tU8 fuelfi_tclMsgGetListOfFuelStationDescriptionMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid fuelfi_tclMsgGetListOfFuelStationDescriptionMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < FuelStationList.size(); ++u32Idx)
         FuelStationList[u32Idx].vDestroy();
   }
   FuelStationList.clear();
}

tU32 fuelfi_tclMsgGetListOfFuelStationDescriptionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+FuelStationList.size()*4;
}

tBool fuelfi_tclMsgGetListOfFuelStationDescriptionMethodStart::operator==(const fuelfi_tclMsgGetListOfFuelStationDescriptionMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FuelStationList.size() == rfoCmp.FuelStationList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FuelStationList.size()); ++u32Idx)
            bResult = bResult && (FuelStationList[u32Idx] == rfoCmp.FuelStationList[u32Idx]);
      }
      bResult = bResult && (DescriptionRequest == rfoCmp.DescriptionRequest);
   return bResult;
}

fi_tclInContext& fuelfi_tclMsgGetListOfFuelStationDescriptionMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FuelStationList.size(); ++u32Idx)
      {
         FuelStationList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      FuelStationList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> FuelStationList[u32Idx];
      }
   }
   oIn >> DescriptionRequest;
   return oIn;
}

fi_tclOutContext& fuelfi_tclMsgGetListOfFuelStationDescriptionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)FuelStationList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < FuelStationList.size(); ++u32Idx)
         oOut << FuelStationList[u32Idx];
   }
   oOut << DescriptionRequest;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgGetListOfFuelStationDescriptionMethodResult::fuelfi_tclMsgGetListOfFuelStationDescriptionMethodResult(const fuelfi_tclMsgGetListOfFuelStationDescriptionMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   FuelStationDescription = coRef.FuelStationDescription;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgGetListOfFuelStationDescriptionMethodResult& fuelfi_tclMsgGetListOfFuelStationDescriptionMethodResult::operator=(const fuelfi_tclMsgGetListOfFuelStationDescriptionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   FuelStationDescription = coRef.FuelStationDescription;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fuelfi_tclMsgGetListOfFuelStationDescriptionMethodResult::u16GetServiceID() const {return FUELFI_C_U16_SERVICE_ID;}
tU16 fuelfi_tclMsgGetListOfFuelStationDescriptionMethodResult::u16GetFunctionID() const {return FUELFI_C_U16_GETLISTOFFUELSTATIONDESCRIPTION;}
tU8 fuelfi_tclMsgGetListOfFuelStationDescriptionMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid fuelfi_tclMsgGetListOfFuelStationDescriptionMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < FuelStationDescription.size(); ++u32Idx)
         FuelStationDescription[u32Idx].vDestroy();
   }
   FuelStationDescription.clear();
}

tU32 fuelfi_tclMsgGetListOfFuelStationDescriptionMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < FuelStationDescription.size(); ++u32ListIdx)
      u32DynamicSize += FuelStationDescription[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool fuelfi_tclMsgGetListOfFuelStationDescriptionMethodResult::operator==(const fuelfi_tclMsgGetListOfFuelStationDescriptionMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FuelStationDescription.size() == rfoCmp.FuelStationDescription.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FuelStationDescription.size()); ++u32Idx)
            bResult = bResult && (FuelStationDescription[u32Idx] == rfoCmp.FuelStationDescription[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fuelfi_tclMsgGetListOfFuelStationDescriptionMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FuelStationDescription.size(); ++u32Idx)
      {
         FuelStationDescription[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      FuelStationDescription.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> FuelStationDescription[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fuelfi_tclMsgGetListOfFuelStationDescriptionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)FuelStationDescription.size();
   {
      for (tU32 u32Idx = 0; u32Idx < FuelStationDescription.size(); ++u32Idx)
         oOut << FuelStationDescription[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodStart::fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodStart(const fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   ListOfPosition = coRef.ListOfPosition;
   Distance = coRef.Distance;
   MaxNumberOfStations = coRef.MaxNumberOfStations;
   FuelTypeList = coRef.FuelTypeList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodStart& fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodStart::operator=(const fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ListOfPosition = coRef.ListOfPosition;
   Distance = coRef.Distance;
   MaxNumberOfStations = coRef.MaxNumberOfStations;
   FuelTypeList = coRef.FuelTypeList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodStart::u16GetServiceID() const {return FUELFI_C_U16_SERVICE_ID;}
tU16 fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodStart::u16GetFunctionID() const {return FUELFI_C_U16_GETLISTOFFUELPRICEDATABYPOSITION;}
tU8 fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfPosition.size(); ++u32Idx)
         ListOfPosition[u32Idx].vDestroy();
   }
   ListOfPosition.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < FuelTypeList.size(); ++u32Idx)
         FuelTypeList[u32Idx].vDestroy();
   }
   FuelTypeList.clear();
}

tU32 fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 14+ListOfPosition.size()*8+FuelTypeList.size()*1;
}

tBool fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodStart::operator==(const fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ListOfPosition.size() == rfoCmp.ListOfPosition.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfPosition.size()); ++u32Idx)
            bResult = bResult && (ListOfPosition[u32Idx] == rfoCmp.ListOfPosition[u32Idx]);
      }
      bResult = bResult && (Distance == rfoCmp.Distance);
      bResult = bResult && (MaxNumberOfStations == rfoCmp.MaxNumberOfStations);
      bResult = bResult && (FuelTypeList.size() == rfoCmp.FuelTypeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FuelTypeList.size()); ++u32Idx)
            bResult = bResult && (FuelTypeList[u32Idx] == rfoCmp.FuelTypeList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfPosition.size(); ++u32Idx)
      {
         ListOfPosition[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ListOfPosition.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ListOfPosition[u32Idx];
      }
   }
   oIn >> Distance;
   oIn >> MaxNumberOfStations;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FuelTypeList.size(); ++u32Idx)
      {
         FuelTypeList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      FuelTypeList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> FuelTypeList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ListOfPosition.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfPosition.size(); ++u32Idx)
         oOut << ListOfPosition[u32Idx];
   }
   oOut << Distance;
   oOut << MaxNumberOfStations;
   oOut << (tU32)FuelTypeList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < FuelTypeList.size(); ++u32Idx)
         oOut << FuelTypeList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodResult::fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodResult(const fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateId = coRef.UpdateId;
   FuelTypeList = coRef.FuelTypeList;
   FuelStationPricesForPositionList = coRef.FuelStationPricesForPositionList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodResult& fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodResult::operator=(const fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UpdateId = coRef.UpdateId;
   FuelTypeList = coRef.FuelTypeList;
   FuelStationPricesForPositionList = coRef.FuelStationPricesForPositionList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodResult::u16GetServiceID() const {return FUELFI_C_U16_SERVICE_ID;}
tU16 fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodResult::u16GetFunctionID() const {return FUELFI_C_U16_GETLISTOFFUELPRICEDATABYPOSITION;}
tU8 fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodResult::vDestroy()
{
   UpdateId.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < FuelTypeList.size(); ++u32Idx)
         FuelTypeList[u32Idx].vDestroy();
   }
   FuelTypeList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < FuelStationPricesForPositionList.size(); ++u32Idx)
         FuelStationPricesForPositionList[u32Idx].vDestroy();
   }
   FuelStationPricesForPositionList.clear();
}

tU32 fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < FuelTypeList.size(); ++u32ListIdx)
      u32DynamicSize += FuelTypeList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < FuelStationPricesForPositionList.size(); ++u32ListIdx)
      u32DynamicSize += FuelStationPricesForPositionList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+10;
}

tBool fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodResult::operator==(const fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateId == rfoCmp.UpdateId);
      bResult = bResult && (FuelTypeList.size() == rfoCmp.FuelTypeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FuelTypeList.size()); ++u32Idx)
            bResult = bResult && (FuelTypeList[u32Idx] == rfoCmp.FuelTypeList[u32Idx]);
      }
      bResult = bResult && (FuelStationPricesForPositionList.size() == rfoCmp.FuelStationPricesForPositionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FuelStationPricesForPositionList.size()); ++u32Idx)
            bResult = bResult && (FuelStationPricesForPositionList[u32Idx] == rfoCmp.FuelStationPricesForPositionList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UpdateId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FuelTypeList.size(); ++u32Idx)
      {
         FuelTypeList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      FuelTypeList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> FuelTypeList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FuelStationPricesForPositionList.size(); ++u32Idx)
      {
         FuelStationPricesForPositionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      FuelStationPricesForPositionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> FuelStationPricesForPositionList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& fuelfi_tclMsgGetListOfFuelPriceDataByPositionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UpdateId;
   oOut << (tU32)FuelTypeList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < FuelTypeList.size(); ++u32Idx)
         oOut << FuelTypeList[u32Idx];
   }
   oOut << (tU32)FuelStationPricesForPositionList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < FuelStationPricesForPositionList.size(); ++u32Idx)
         oOut << FuelStationPricesForPositionList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgNewFuelPricesAvailableGet::fuelfi_tclMsgNewFuelPricesAvailableGet(const fuelfi_tclMsgNewFuelPricesAvailableGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgNewFuelPricesAvailableGet& fuelfi_tclMsgNewFuelPricesAvailableGet::operator=(const fuelfi_tclMsgNewFuelPricesAvailableGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fuelfi_tclMsgNewFuelPricesAvailableGet::u16GetServiceID() const {return FUELFI_C_U16_SERVICE_ID;}
tU16 fuelfi_tclMsgNewFuelPricesAvailableGet::u16GetFunctionID() const {return FUELFI_C_U16_NEWFUELPRICESAVAILABLE;}
tU8 fuelfi_tclMsgNewFuelPricesAvailableGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 fuelfi_tclMsgNewFuelPricesAvailableGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool fuelfi_tclMsgNewFuelPricesAvailableGet::operator==(const fuelfi_tclMsgNewFuelPricesAvailableGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& fuelfi_tclMsgNewFuelPricesAvailableGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& fuelfi_tclMsgNewFuelPricesAvailableGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgNewFuelPricesAvailableUpReg::fuelfi_tclMsgNewFuelPricesAvailableUpReg(const fuelfi_tclMsgNewFuelPricesAvailableUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgNewFuelPricesAvailableUpReg& fuelfi_tclMsgNewFuelPricesAvailableUpReg::operator=(const fuelfi_tclMsgNewFuelPricesAvailableUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fuelfi_tclMsgNewFuelPricesAvailableUpReg::u16GetServiceID() const {return FUELFI_C_U16_SERVICE_ID;}
tU16 fuelfi_tclMsgNewFuelPricesAvailableUpReg::u16GetFunctionID() const {return FUELFI_C_U16_NEWFUELPRICESAVAILABLE;}
tU8 fuelfi_tclMsgNewFuelPricesAvailableUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 fuelfi_tclMsgNewFuelPricesAvailableUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool fuelfi_tclMsgNewFuelPricesAvailableUpReg::operator==(const fuelfi_tclMsgNewFuelPricesAvailableUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& fuelfi_tclMsgNewFuelPricesAvailableUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& fuelfi_tclMsgNewFuelPricesAvailableUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgNewFuelPricesAvailableRelUpReg::fuelfi_tclMsgNewFuelPricesAvailableRelUpReg(const fuelfi_tclMsgNewFuelPricesAvailableRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgNewFuelPricesAvailableRelUpReg& fuelfi_tclMsgNewFuelPricesAvailableRelUpReg::operator=(const fuelfi_tclMsgNewFuelPricesAvailableRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fuelfi_tclMsgNewFuelPricesAvailableRelUpReg::u16GetServiceID() const {return FUELFI_C_U16_SERVICE_ID;}
tU16 fuelfi_tclMsgNewFuelPricesAvailableRelUpReg::u16GetFunctionID() const {return FUELFI_C_U16_NEWFUELPRICESAVAILABLE;}
tU8 fuelfi_tclMsgNewFuelPricesAvailableRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 fuelfi_tclMsgNewFuelPricesAvailableRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool fuelfi_tclMsgNewFuelPricesAvailableRelUpReg::operator==(const fuelfi_tclMsgNewFuelPricesAvailableRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& fuelfi_tclMsgNewFuelPricesAvailableRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& fuelfi_tclMsgNewFuelPricesAvailableRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgNewFuelPricesAvailableStatus::fuelfi_tclMsgNewFuelPricesAvailableStatus(const fuelfi_tclMsgNewFuelPricesAvailableStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateId = coRef.UpdateId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgNewFuelPricesAvailableStatus& fuelfi_tclMsgNewFuelPricesAvailableStatus::operator=(const fuelfi_tclMsgNewFuelPricesAvailableStatus& coRef)
{
   if (this == &coRef) return *this;
   UpdateId = coRef.UpdateId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fuelfi_tclMsgNewFuelPricesAvailableStatus::u16GetServiceID() const {return FUELFI_C_U16_SERVICE_ID;}
tU16 fuelfi_tclMsgNewFuelPricesAvailableStatus::u16GetFunctionID() const {return FUELFI_C_U16_NEWFUELPRICESAVAILABLE;}
tU8 fuelfi_tclMsgNewFuelPricesAvailableStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid fuelfi_tclMsgNewFuelPricesAvailableStatus::vDestroy()
{
   UpdateId.vDestroy(); 
}

tU32 fuelfi_tclMsgNewFuelPricesAvailableStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool fuelfi_tclMsgNewFuelPricesAvailableStatus::operator==(const fuelfi_tclMsgNewFuelPricesAvailableStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateId == rfoCmp.UpdateId);
   return bResult;
}

fi_tclInContext& fuelfi_tclMsgNewFuelPricesAvailableStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> UpdateId;
   return oIn;
}

fi_tclOutContext& fuelfi_tclMsgNewFuelPricesAvailableStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UpdateId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgEngineeringTextGet::fuelfi_tclMsgEngineeringTextGet(const fuelfi_tclMsgEngineeringTextGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgEngineeringTextGet& fuelfi_tclMsgEngineeringTextGet::operator=(const fuelfi_tclMsgEngineeringTextGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fuelfi_tclMsgEngineeringTextGet::u16GetServiceID() const {return FUELFI_C_U16_SERVICE_ID;}
tU16 fuelfi_tclMsgEngineeringTextGet::u16GetFunctionID() const {return FUELFI_C_U16_ENGINEERINGTEXT;}
tU8 fuelfi_tclMsgEngineeringTextGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 fuelfi_tclMsgEngineeringTextGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool fuelfi_tclMsgEngineeringTextGet::operator==(const fuelfi_tclMsgEngineeringTextGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& fuelfi_tclMsgEngineeringTextGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& fuelfi_tclMsgEngineeringTextGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgEngineeringTextUpReg::fuelfi_tclMsgEngineeringTextUpReg(const fuelfi_tclMsgEngineeringTextUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgEngineeringTextUpReg& fuelfi_tclMsgEngineeringTextUpReg::operator=(const fuelfi_tclMsgEngineeringTextUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fuelfi_tclMsgEngineeringTextUpReg::u16GetServiceID() const {return FUELFI_C_U16_SERVICE_ID;}
tU16 fuelfi_tclMsgEngineeringTextUpReg::u16GetFunctionID() const {return FUELFI_C_U16_ENGINEERINGTEXT;}
tU8 fuelfi_tclMsgEngineeringTextUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 fuelfi_tclMsgEngineeringTextUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool fuelfi_tclMsgEngineeringTextUpReg::operator==(const fuelfi_tclMsgEngineeringTextUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& fuelfi_tclMsgEngineeringTextUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& fuelfi_tclMsgEngineeringTextUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgEngineeringTextRelUpReg::fuelfi_tclMsgEngineeringTextRelUpReg(const fuelfi_tclMsgEngineeringTextRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgEngineeringTextRelUpReg& fuelfi_tclMsgEngineeringTextRelUpReg::operator=(const fuelfi_tclMsgEngineeringTextRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fuelfi_tclMsgEngineeringTextRelUpReg::u16GetServiceID() const {return FUELFI_C_U16_SERVICE_ID;}
tU16 fuelfi_tclMsgEngineeringTextRelUpReg::u16GetFunctionID() const {return FUELFI_C_U16_ENGINEERINGTEXT;}
tU8 fuelfi_tclMsgEngineeringTextRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 fuelfi_tclMsgEngineeringTextRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool fuelfi_tclMsgEngineeringTextRelUpReg::operator==(const fuelfi_tclMsgEngineeringTextRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& fuelfi_tclMsgEngineeringTextRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& fuelfi_tclMsgEngineeringTextRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgEngineeringTextStatus::fuelfi_tclMsgEngineeringTextStatus(const fuelfi_tclMsgEngineeringTextStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Message = coRef.Message;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fuelfi_tclMsgEngineeringTextStatus& fuelfi_tclMsgEngineeringTextStatus::operator=(const fuelfi_tclMsgEngineeringTextStatus& coRef)
{
   if (this == &coRef) return *this;
   Message = coRef.Message;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 fuelfi_tclMsgEngineeringTextStatus::u16GetServiceID() const {return FUELFI_C_U16_SERVICE_ID;}
tU16 fuelfi_tclMsgEngineeringTextStatus::u16GetFunctionID() const {return FUELFI_C_U16_ENGINEERINGTEXT;}
tU8 fuelfi_tclMsgEngineeringTextStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid fuelfi_tclMsgEngineeringTextStatus::vDestroy()
{
   Message.vDestroy();
}

tU32 fuelfi_tclMsgEngineeringTextStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Message.u32GetSize(u16MajorVersion);
}

tBool fuelfi_tclMsgEngineeringTextStatus::operator==(const fuelfi_tclMsgEngineeringTextStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Message == rfoCmp.Message);
   return bResult;
}

fi_tclInContext& fuelfi_tclMsgEngineeringTextStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Message;
   return oIn;
}

fi_tclOutContext& fuelfi_tclMsgEngineeringTextStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Message;
   return oOut;
}

