#ifndef FUELFILANGUAGE_HEADER
#define FUELFILANGUAGE_HEADER

class fuelfi_tclInContext;
class fuelfi_tclOutContext;
class fuelfi_tclVisitorBase;

class MY_DECL fuelfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  fuelfi_tclDescription(fi_tclInContext* poIn, fuelfi_tclVisitorBase* poVisit);
  fuelfi_tclDescription(fi_tclOutContext* poOut, fuelfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(fuelfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ fuelfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  fuelfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<fuelfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<fuelfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline fuelfi_tclDescription::fuelfi_tclDescription(fi_tclInContext* poIn, fuelfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline fuelfi_tclDescription::fuelfi_tclDescription(fi_tclOutContext* poOut, fuelfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

