#include "precompiled.hh"

tBool fuelfi_tclDescription::bInitMessage(fuelfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case fuelfi_tclToken::EN_LAST_TOKEN:
   case fuelfi_tclToken::EN_LIST:
   case fuelfi_tclToken::EN_END_OF_STRUCT:
   case fuelfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case fuelfi_tclToken::EN_MSG_GETFUELPRICEDATAMETHODSTART:
   {
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_FUELTYPECODE,fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_LIST,fuelfi_tclSemanticDomain::EN_MSG_FUELTYPELIST));
      }
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_FUELSTATION,fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_LIST,fuelfi_tclSemanticDomain::EN_MSG_FUELSTATIONLIST));
   } break;
   case fuelfi_tclToken::EN_MSG_GETFUELPRICEDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_FUELSTATIONPRICES,fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_LIST,fuelfi_tclSemanticDomain::EN_MSG_FUELSTATIONPRICESLIST));
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_FUELTYPE,fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_LIST,fuelfi_tclSemanticDomain::EN_MSG_FUELTYPELIST));
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_UPDATEID,fuelfi_tclSemanticDomain::EN_MSG_UPDATEID));
   } break;
   case fuelfi_tclToken::EN_MSG_GETLISTOFFUELTYPESMETHODRESULT:
   {
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_FUELTYPE,fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_LIST,fuelfi_tclSemanticDomain::EN_MSG_FUELTYPELIST));
   } break;
   case fuelfi_tclToken::EN_MSG_GETLISTOFFUELSTATIONDESCRIPTIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_B16_STATIONDESCRIPTIONREQUEST,fuelfi_tclSemanticDomain::EN_MSG_DESCRIPTIONREQUEST));
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_FUELSTATION,fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_LIST,fuelfi_tclSemanticDomain::EN_MSG_FUELSTATIONLIST));
   } break;
   case fuelfi_tclToken::EN_MSG_GETLISTOFFUELSTATIONDESCRIPTIONMETHODRESULT:
   {
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_FUELSTATIONDESCRIPTION,fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_LIST,fuelfi_tclSemanticDomain::EN_MSG_FUELSTATIONDESCRIPTION));
   } break;
   case fuelfi_tclToken::EN_MSG_GETLISTOFFUELPRICEDATABYPOSITIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_FUELTYPECODE,fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_LIST,fuelfi_tclSemanticDomain::EN_MSG_FUELTYPELIST));
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_U16,fuelfi_tclSemanticDomain::EN_MSG_MAXNUMBEROFSTATIONS));
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_S32_METER,fuelfi_tclSemanticDomain::EN_MSG_DISTANCE));
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_POSITIONWGS84,fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_LIST,fuelfi_tclSemanticDomain::EN_MSG_LISTOFPOSITION));
   } break;
   case fuelfi_tclToken::EN_MSG_GETLISTOFFUELPRICEDATABYPOSITIONMETHODRESULT:
   {
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_FUELSTATIONPRICESFORPOSITION,fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_LIST,fuelfi_tclSemanticDomain::EN_MSG_FUELSTATIONPRICESFORPOSITIONLIST));
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_FUELTYPE,fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_LIST,fuelfi_tclSemanticDomain::EN_MSG_FUELTYPELIST));
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_UPDATEID,fuelfi_tclSemanticDomain::EN_MSG_UPDATEID));
   } break;
   case fuelfi_tclToken::EN_MSG_NEWFUELPRICESAVAILABLESTATUS:
   {
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_UPDATEID,fuelfi_tclSemanticDomain::EN_MSG_UPDATEID));
   } break;
   case fuelfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
   {
      bResult &= oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_STRING,fuelfi_tclSemanticDomain::EN_MSG_MESSAGE));
   } break;
   case fuelfi_tclToken::EN_BINCONTAINER:
   case fuelfi_tclToken::EN_S32_METER:
   case fuelfi_tclToken::EN_S32_LONGITUDE:
   case fuelfi_tclToken::EN_S32_LATITUDE:
   case fuelfi_tclToken::EN_POSITIONWGS84:
   case fuelfi_tclToken::EN_STATE:
   case fuelfi_tclToken::EN_E8_AMENITY:
   case fuelfi_tclToken::EN_AMENITY:
   case fuelfi_tclToken::EN_FUELSTATIONINFO:
   case fuelfi_tclToken::EN_E8_FUELAGE:
   case fuelfi_tclToken::EN_FUELTYPECODE:
   case fuelfi_tclToken::EN_REGIONID:
   case fuelfi_tclToken::EN_FUELAGE:
   case fuelfi_tclToken::EN_FUELPRICE:
   case fuelfi_tclToken::EN_FUELSTATIONID:
   case fuelfi_tclToken::EN_FUELTYPE:
   case fuelfi_tclToken::EN_FUELSTATION:
   case fuelfi_tclToken::EN_FUELSTATIONPRICES:
   case fuelfi_tclToken::EN_B16_STATIONDESCRIPTIONREQUEST:
   case fuelfi_tclToken::EN_FUELSTATIONDESCRIPTION:
   case fuelfi_tclToken::EN_FUELSTATIONPRICESFORPOSITION:
   case fuelfi_tclToken::EN_UPDATEID:
   case fuelfi_tclToken::EN_U8:   
   case fuelfi_tclToken::EN_S8:   
   case fuelfi_tclToken::EN_U16:   
   case fuelfi_tclToken::EN_S16:   
   case fuelfi_tclToken::EN_U24:   
   case fuelfi_tclToken::EN_S24:   
   case fuelfi_tclToken::EN_U32:   
   case fuelfi_tclToken::EN_S32:   
   case fuelfi_tclToken::EN_U64:   
   case fuelfi_tclToken::EN_S64:   
   case fuelfi_tclToken::EN_F32:   
   case fuelfi_tclToken::EN_F64:   
   case fuelfi_tclToken::EN_BOOL:   
   case fuelfi_tclToken::EN_STRING:   
   case fuelfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(fuelfi_tclKnot(enMsgToken,fuelfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool fuelfi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool fuelfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      fuelfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      fuelfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      fuelfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == fuelfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(fuelfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(fuelfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(fuelfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case fuelfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == fuelfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case fuelfi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            fuelfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(fuelfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            fuelfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(fuelfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case fuelfi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case fuelfi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fuelfi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fuelfi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fuelfi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fuelfi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fuelfi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fuelfi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fuelfi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fuelfi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fuelfi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fuelfi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fuelfi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fuelfi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fuelfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case fuelfi_tclToken::EN_MSG_GETFUELPRICEDATAMETHODSTART:
   case fuelfi_tclToken::EN_MSG_GETFUELPRICEDATAMETHODRESULT:
   case fuelfi_tclToken::EN_MSG_GETLISTOFFUELTYPESMETHODSTART:
   case fuelfi_tclToken::EN_MSG_GETLISTOFFUELTYPESMETHODRESULT:
   case fuelfi_tclToken::EN_MSG_GETLISTOFFUELSTATIONDESCRIPTIONMETHODSTART:
   case fuelfi_tclToken::EN_MSG_GETLISTOFFUELSTATIONDESCRIPTIONMETHODRESULT:
   case fuelfi_tclToken::EN_MSG_GETLISTOFFUELPRICEDATABYPOSITIONMETHODSTART:
   case fuelfi_tclToken::EN_MSG_GETLISTOFFUELPRICEDATABYPOSITIONMETHODRESULT:
   case fuelfi_tclToken::EN_MSG_NEWFUELPRICESAVAILABLEGET:
   case fuelfi_tclToken::EN_MSG_NEWFUELPRICESAVAILABLEUPREG:
   case fuelfi_tclToken::EN_MSG_NEWFUELPRICESAVAILABLERELUPREG:
   case fuelfi_tclToken::EN_MSG_NEWFUELPRICESAVAILABLESTATUS:
   case fuelfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
   case fuelfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
   case fuelfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
   case fuelfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
      bInitMessage(enToken);
      break;
   case fuelfi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_END_OF_STRUCT,fuelfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_U8,fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_LIST,fuelfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fuelfi_tclToken::EN_S32_METER:
   {
      fi_tcl_s32_Meter o_s32_Meter;
      if (!bDoIt(o_s32_Meter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case fuelfi_tclToken::EN_S32_LONGITUDE:
   {
      fi_tcl_s32_Longitude o_s32_Longitude;
      if (!bDoIt(o_s32_Longitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case fuelfi_tclToken::EN_S32_LATITUDE:
   {
      fi_tcl_s32_Latitude o_s32_Latitude;
      if (!bDoIt(o_s32_Latitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case fuelfi_tclToken::EN_POSITIONWGS84:
   {
      if (poVisitor->bDoExpand_PositionWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_END_OF_STRUCT,fuelfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_S32_LATITUDE,fuelfi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_S32_LONGITUDE,fuelfi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_PositionWGS84 o_PositionWGS84;
         if (!bDoIt(o_PositionWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fuelfi_tclToken::EN_STATE:
   {
      if (poVisitor->bDoExpand_State(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_END_OF_STRUCT,fuelfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_STRING,fuelfi_tclSemanticDomain::EN_STATENAME));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_STRING,fuelfi_tclSemanticDomain::EN_STATEID));
      }
      else
      {
         fi_tcl_State o_State;
         if (!bDoIt(o_State))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_State.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_State.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fuelfi_tclToken::EN_E8_AMENITY:
   {
      fi_tcl_e8_Amenity o_e8_Amenity;
      if (!bDoIt(o_e8_Amenity))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case fuelfi_tclToken::EN_AMENITY:
   {
      if (poVisitor->bDoExpand_Amenity(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_END_OF_STRUCT,fuelfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_E8_AMENITY,fuelfi_tclSemanticDomain::EN_AMENITY));
      }
      else
      {
         fi_tcl_Amenity o_Amenity;
         if (!bDoIt(o_Amenity))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Amenity.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Amenity.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fuelfi_tclToken::EN_FUELSTATIONINFO:
   {
      if (poVisitor->bDoExpand_FuelStationInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_END_OF_STRUCT,fuelfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_STRING,fuelfi_tclSemanticDomain::EN_ZIP));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_STATE,fuelfi_tclSemanticDomain::EN_STATE));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_POSITIONWGS84,fuelfi_tclSemanticDomain::EN_POSITION));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_STRING,fuelfi_tclSemanticDomain::EN_PHONE));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_STRING,fuelfi_tclSemanticDomain::EN_NAME));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_AMENITY,fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_LIST,fuelfi_tclSemanticDomain::EN_LISTOFAMENITIES));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_STRING,fuelfi_tclSemanticDomain::EN_CITY));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_STRING,fuelfi_tclSemanticDomain::EN_BRAND));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_STRING,fuelfi_tclSemanticDomain::EN_ADDRESS));
      }
      else
      {
         fi_tcl_FuelStationInfo o_FuelStationInfo;
         if (!bDoIt(o_FuelStationInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelStationInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelStationInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fuelfi_tclToken::EN_E8_FUELAGE:
   {
      fi_tcl_e8_FuelAge o_e8_FuelAge;
      if (!bDoIt(o_e8_FuelAge))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case fuelfi_tclToken::EN_FUELTYPECODE:
   {
      if (poVisitor->bDoExpand_FuelTypeCode(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_END_OF_STRUCT,fuelfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_U8,fuelfi_tclSemanticDomain::EN_FUELTYPECODE));
      }
      else
      {
         fi_tcl_FuelTypeCode o_FuelTypeCode;
         if (!bDoIt(o_FuelTypeCode))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelTypeCode.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelTypeCode.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fuelfi_tclToken::EN_REGIONID:
   {
      if (poVisitor->bDoExpand_RegionId(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_END_OF_STRUCT,fuelfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_U16,fuelfi_tclSemanticDomain::EN_REGIONID));
      }
      else
      {
         fi_tcl_RegionId o_RegionId;
         if (!bDoIt(o_RegionId))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RegionId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RegionId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fuelfi_tclToken::EN_FUELAGE:
   {
      if (poVisitor->bDoExpand_FuelAge(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_END_OF_STRUCT,fuelfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_E8_FUELAGE,fuelfi_tclSemanticDomain::EN_AGETYPE));
      }
      else
      {
         fi_tcl_FuelAge o_FuelAge;
         if (!bDoIt(o_FuelAge))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelAge.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelAge.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fuelfi_tclToken::EN_FUELPRICE:
   {
      if (poVisitor->bDoExpand_FuelPrice(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_END_OF_STRUCT,fuelfi_tclSemanticDomain::EN_UNKNOWN));
         if (2 <= u16MajorVersion)
         {
            oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_FUELAGE,fuelfi_tclSemanticDomain::EN_AGE));
         }
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_STRING,fuelfi_tclSemanticDomain::EN_CURRENCY));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_U16,fuelfi_tclSemanticDomain::EN_PRICE));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_FUELTYPECODE,fuelfi_tclSemanticDomain::EN_FUELTYPE));
      }
      else
      {
         fi_tcl_FuelPrice o_FuelPrice;
         if (!bDoIt(o_FuelPrice))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelPrice.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelPrice.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fuelfi_tclToken::EN_FUELSTATIONID:
   {
      if (poVisitor->bDoExpand_FuelStationId(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_END_OF_STRUCT,fuelfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_U16,fuelfi_tclSemanticDomain::EN_STATIONID));
      }
      else
      {
         fi_tcl_FuelStationId o_FuelStationId;
         if (!bDoIt(o_FuelStationId))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelStationId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelStationId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fuelfi_tclToken::EN_FUELTYPE:
   {
      if (poVisitor->bDoExpand_FuelType(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_END_OF_STRUCT,fuelfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_BOOL,fuelfi_tclSemanticDomain::EN_WELLKNOWNTYPE));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_MULTILANGUAGESTRING,fuelfi_tclSemanticDomain::EN_NAME));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_FUELTYPECODE,fuelfi_tclSemanticDomain::EN_CODE));
      }
      else
      {
         fi_tcl_FuelType o_FuelType;
         if (!bDoIt(o_FuelType))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fuelfi_tclToken::EN_FUELSTATION:
   {
      if (poVisitor->bDoExpand_FuelStation(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_END_OF_STRUCT,fuelfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_FUELSTATIONID,fuelfi_tclSemanticDomain::EN_STATIONID));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_REGIONID,fuelfi_tclSemanticDomain::EN_REGIONID));
      }
      else
      {
         fi_tcl_FuelStation o_FuelStation;
         if (!bDoIt(o_FuelStation))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelStation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelStation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fuelfi_tclToken::EN_FUELSTATIONPRICES:
   {
      if (poVisitor->bDoExpand_FuelStationPrices(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_END_OF_STRUCT,fuelfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_FUELPRICE,fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_LIST,fuelfi_tclSemanticDomain::EN_FUELPRICES));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_FUELSTATION,fuelfi_tclSemanticDomain::EN_FUELSTATION));
      }
      else
      {
         fi_tcl_FuelStationPrices o_FuelStationPrices;
         if (!bDoIt(o_FuelStationPrices))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelStationPrices.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelStationPrices.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fuelfi_tclToken::EN_B16_STATIONDESCRIPTIONREQUEST:
   {
      fi_tcl_b16_StationDescriptionRequest o_b16_StationDescriptionRequest;
      if (!bDoIt(o_b16_StationDescriptionRequest))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case fuelfi_tclToken::EN_FUELSTATIONDESCRIPTION:
   {
      if (poVisitor->bDoExpand_FuelStationDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_END_OF_STRUCT,fuelfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_FUELSTATION,fuelfi_tclSemanticDomain::EN_FUELSTATION));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_FUELSTATIONINFO,fuelfi_tclSemanticDomain::EN_FUELSTATIONDESCRIPTION));
      }
      else
      {
         fi_tcl_FuelStationDescription o_FuelStationDescription;
         if (!bDoIt(o_FuelStationDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelStationDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelStationDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fuelfi_tclToken::EN_FUELSTATIONPRICESFORPOSITION:
   {
      if (poVisitor->bDoExpand_FuelStationPricesForPosition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_END_OF_STRUCT,fuelfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_FUELSTATIONPRICES,fuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_LIST,fuelfi_tclSemanticDomain::EN_FUELSTATIONPRICES));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_POSITIONWGS84,fuelfi_tclSemanticDomain::EN_POSITION));
      }
      else
      {
         fi_tcl_FuelStationPricesForPosition o_FuelStationPricesForPosition;
         if (!bDoIt(o_FuelStationPricesForPosition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelStationPricesForPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelStationPricesForPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fuelfi_tclToken::EN_UPDATEID:
   {
      if (poVisitor->bDoExpand_UpdateId(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_END_OF_STRUCT,fuelfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fuelfi_tclKnot(fuelfi_tclToken::EN_U16,fuelfi_tclSemanticDomain::EN_UPDATEID));
      }
      else
      {
         fi_tcl_UpdateId o_UpdateId;
         if (!bDoIt(o_UpdateId))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UpdateId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UpdateId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case fuelfi_tclToken::EN_UNKNOWN:
      case fuelfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

