#include "precompiled.hh"

tBool fastmapfi_tclDescription::bInitMessage(fastmapfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case fastmapfi_tclToken::EN_LAST_TOKEN:
   case fastmapfi_tclToken::EN_LIST:
   case fastmapfi_tclToken::EN_END_OF_STRUCT:
   case fastmapfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case fastmapfi_tclToken::EN_MSG_OPENFASTMAPCHANNELMETHODSTART:
   {
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U32,fastmapfi_tclSemanticDomain::EN_MSG_CHANNELSIZE));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_STRING,fastmapfi_tclSemanticDomain::EN_MSG_CHANNELNAME));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U8,fastmapfi_tclSemanticDomain::EN_MSG_MINORVERSION));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U8,fastmapfi_tclSemanticDomain::EN_MSG_MAJORVERSION));
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_E8_DAPORDERTYPE,fastmapfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_E8_TRANSFERTYPE,fastmapfi_tclSemanticDomain::EN_MSG_TRANSFERTYPE));
   } break;
   case fastmapfi_tclToken::EN_MSG_OPENFASTMAPCHANNELMETHODRESULT:
   {
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_E8_COORDINATECODING,fastmapfi_tclSemanticDomain::EN_MSG_COORDINATECODING));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U16,fastmapfi_tclSemanticDomain::EN_MSG_HANDLE));
   } break;
   case fastmapfi_tclToken::EN_MSG_CLOSEFASTMAPCHANNELMETHODSTART:
   {
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U16,fastmapfi_tclSemanticDomain::EN_MSG_HANDLE));
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_E8_DAPORDERTYPE,fastmapfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case fastmapfi_tclToken::EN_MSG_GETBLOCKIDSMETHODSTART:
   {
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_BOUNDINGBOX,fastmapfi_tclSemanticDomain::EN_MSG_BOUNDINGBOX));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_MAPSCALE,fastmapfi_tclSemanticDomain::EN_MSG_MAPSCALE));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U32,fastmapfi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_E16_DATATYPE,fastmapfi_tclSemanticDomain::EN_MSG_DATATYPE));
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_E8_DAPORDERTYPE,fastmapfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case fastmapfi_tclToken::EN_MSG_GETBLOCKIDSMETHODRESULT:
   {
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_UNIQUEID,fastmapfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_LIST,fastmapfi_tclSemanticDomain::EN_MSG_UNIQUEIDS));
   } break;
   case fastmapfi_tclToken::EN_MSG_LOADBLOCKSMETHODSTART:
   {
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U32,fastmapfi_tclSemanticDomain::EN_MSG_MAXSIZE));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U32,fastmapfi_tclSemanticDomain::EN_MSG_OFFSET));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U16,fastmapfi_tclSemanticDomain::EN_MSG_HANDLE));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U32,fastmapfi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_UNIQUEID,fastmapfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_LIST,fastmapfi_tclSemanticDomain::EN_MSG_UNIQUEIDS));
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_E8_DAPORDERTYPE,fastmapfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case fastmapfi_tclToken::EN_MSG_LOADBLOCKSMETHODRESULT:
   {
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_RESULTBLOCKS,fastmapfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_LIST,fastmapfi_tclSemanticDomain::EN_MSG_RESULTBLOCKS));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U32,fastmapfi_tclSemanticDomain::EN_MSG_SIZE));
   } break;
   case fastmapfi_tclToken::EN_MSG_CONVERTONECELLLISTMETHODSTART:
   {
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_LOCALONECELLID,fastmapfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_LIST,fastmapfi_tclSemanticDomain::EN_MSG_ONECELLIDLIST));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_NAVCLUSTERID,fastmapfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_LIST,fastmapfi_tclSemanticDomain::EN_MSG_CLUSTERIDLIST));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U32,fastmapfi_tclSemanticDomain::EN_MSG_MAXSIZE));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U32,fastmapfi_tclSemanticDomain::EN_MSG_OFFSET));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U16,fastmapfi_tclSemanticDomain::EN_MSG_HANDLE));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U32,fastmapfi_tclSemanticDomain::EN_MSG_DATASETID));
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_E8_DAPORDERTYPE,fastmapfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case fastmapfi_tclToken::EN_MSG_CONVERTONECELLLISTMETHODRESULT:
   {
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_RESULTBLOCKS,fastmapfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_LIST,fastmapfi_tclSemanticDomain::EN_MSG_RESULTBLOCKLIST));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U32,fastmapfi_tclSemanticDomain::EN_MSG_SIZE));
   } break;
   case fastmapfi_tclToken::EN_MSG_BREAKDOWNROUTEOCMETHODSTART:
   {
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_NAVONECELLDESC,fastmapfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_LIST,fastmapfi_tclSemanticDomain::EN_MSG_ONECELLIDLIST));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_NAVCLUSTERDESC,fastmapfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_LIST,fastmapfi_tclSemanticDomain::EN_MSG_CLUSTERIDLIST));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_BOUNDINGBOX,fastmapfi_tclSemanticDomain::EN_MSG_BOUNDINGBOX));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U8,fastmapfi_tclSemanticDomain::EN_MSG_BREAKDOWNLEVEL));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_E8_REQUESTTYPE,fastmapfi_tclSemanticDomain::EN_MSG_REQUESTTYPE));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U32,fastmapfi_tclSemanticDomain::EN_MSG_DATASETID));
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_E8_DAPORDERTYPE,fastmapfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case fastmapfi_tclToken::EN_MSG_BREAKDOWNROUTEOCMETHODRESULT:
   {
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_SAMELEVELONECELLBLOCK,fastmapfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_LIST,fastmapfi_tclSemanticDomain::EN_MSG_ROUTEBREAKDOWNLIST));
   } break;
   case fastmapfi_tclToken::EN_MSG_RESERVECLIENTUSEIDRANGEMETHODSTART:
   {
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U32,fastmapfi_tclSemanticDomain::EN_MSG_NOREQID));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_STRING,fastmapfi_tclSemanticDomain::EN_MSG_CLIENTNAME));
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_E8_DAPORDERTYPE,fastmapfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case fastmapfi_tclToken::EN_MSG_RESERVECLIENTUSEIDRANGEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_UNIQUEID,fastmapfi_tclSemanticDomain::EN_MSG_LASTID));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_UNIQUEID,fastmapfi_tclSemanticDomain::EN_MSG_FIRSTID));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U32,fastmapfi_tclSemanticDomain::EN_MSG_HANDLE));
   } break;
   case fastmapfi_tclToken::EN_MSG_FREECLIENTUSEDIDRANGEMETHODSTART:
   {
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U32,fastmapfi_tclSemanticDomain::EN_MSG_HANDLE));
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_E8_DAPORDERTYPE,fastmapfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case fastmapfi_tclToken::EN_MSG_GETCLIENTIDRANGEBYNAMEMETHODSTART:
   {
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_STRING,fastmapfi_tclSemanticDomain::EN_MSG_CLIENTNAME));
      if (3 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_E8_DAPORDERTYPE,fastmapfi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case fastmapfi_tclToken::EN_MSG_GETCLIENTIDRANGEBYNAMEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_UNIQUEID,fastmapfi_tclSemanticDomain::EN_MSG_LASTID));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_UNIQUEID,fastmapfi_tclSemanticDomain::EN_MSG_FIRSTID));
   } break;
   case fastmapfi_tclToken::EN_MSG_DATABLOCKSCHANGEDSTATUS:
   {
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_UNIQUEID,fastmapfi_tclSemanticDomain::EN_MSG_COMPAREVALUE));
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_UNIQUEID,fastmapfi_tclSemanticDomain::EN_MSG_MASK));
   } break;
   case fastmapfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
   {
      bResult &= oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_STRING,fastmapfi_tclSemanticDomain::EN_MSG_MESSAGE));
   } break;
   case fastmapfi_tclToken::EN_BINCONTAINER:
   case fastmapfi_tclToken::EN_U16_INDEXINREFERENCELIST:
   case fastmapfi_tclToken::EN_S32_LONGITUDE:
   case fastmapfi_tclToken::EN_S32_LATITUDE:
   case fastmapfi_tclToken::EN_POSITIONWGS84:
   case fastmapfi_tclToken::EN_NAVCLUSTERDESC:
   case fastmapfi_tclToken::EN_E8_NAVONECELLDIRECTION:
   case fastmapfi_tclToken::EN_NAVONECELLDESC:
   case fastmapfi_tclToken::EN_E8_DAPORDERTYPE:
   case fastmapfi_tclToken::EN_NAVCLUSTERID:
   case fastmapfi_tclToken::EN_LOCALONECELLID:
   case fastmapfi_tclToken::EN_E8_TRANSFERTYPE:
   case fastmapfi_tclToken::EN_E8_COORDINATECODING:
   case fastmapfi_tclToken::EN_E16_DATATYPE:
   case fastmapfi_tclToken::EN_UNIQUEID:
   case fastmapfi_tclToken::EN_MAPSCALE:
   case fastmapfi_tclToken::EN_BOUNDINGBOX:
   case fastmapfi_tclToken::EN_RESULTBLOCKS:
   case fastmapfi_tclToken::EN_E8_REQUESTTYPE:
   case fastmapfi_tclToken::EN_E16_ONECELLINDEX:
   case fastmapfi_tclToken::EN_ONECELLRELATION:
   case fastmapfi_tclToken::EN_SAMELEVELONECELLBLOCK:
   case fastmapfi_tclToken::EN_U8:   
   case fastmapfi_tclToken::EN_S8:   
   case fastmapfi_tclToken::EN_U16:   
   case fastmapfi_tclToken::EN_S16:   
   case fastmapfi_tclToken::EN_U24:   
   case fastmapfi_tclToken::EN_S24:   
   case fastmapfi_tclToken::EN_U32:   
   case fastmapfi_tclToken::EN_S32:   
   case fastmapfi_tclToken::EN_U64:   
   case fastmapfi_tclToken::EN_S64:   
   case fastmapfi_tclToken::EN_F32:   
   case fastmapfi_tclToken::EN_F64:   
   case fastmapfi_tclToken::EN_BOOL:   
   case fastmapfi_tclToken::EN_STRING:   
   case fastmapfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(fastmapfi_tclKnot(enMsgToken,fastmapfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool fastmapfi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool fastmapfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      fastmapfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      fastmapfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      fastmapfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == fastmapfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(fastmapfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(fastmapfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(fastmapfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case fastmapfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == fastmapfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case fastmapfi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            fastmapfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(fastmapfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            fastmapfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(fastmapfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case fastmapfi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case fastmapfi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fastmapfi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fastmapfi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fastmapfi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fastmapfi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fastmapfi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fastmapfi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fastmapfi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fastmapfi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fastmapfi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fastmapfi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fastmapfi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fastmapfi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case fastmapfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case fastmapfi_tclToken::EN_MSG_OPENFASTMAPCHANNELMETHODSTART:
   case fastmapfi_tclToken::EN_MSG_OPENFASTMAPCHANNELMETHODRESULT:
   case fastmapfi_tclToken::EN_MSG_CLOSEFASTMAPCHANNELMETHODSTART:
   case fastmapfi_tclToken::EN_MSG_CLOSEFASTMAPCHANNELMETHODRESULT:
   case fastmapfi_tclToken::EN_MSG_GETBLOCKIDSMETHODSTART:
   case fastmapfi_tclToken::EN_MSG_GETBLOCKIDSMETHODRESULT:
   case fastmapfi_tclToken::EN_MSG_LOADBLOCKSMETHODSTART:
   case fastmapfi_tclToken::EN_MSG_LOADBLOCKSMETHODRESULT:
   case fastmapfi_tclToken::EN_MSG_LOADBLOCKSMETHODABORT:
   case fastmapfi_tclToken::EN_MSG_LOADBLOCKSABORTRESULT:
   case fastmapfi_tclToken::EN_MSG_CONVERTONECELLLISTMETHODSTART:
   case fastmapfi_tclToken::EN_MSG_CONVERTONECELLLISTMETHODRESULT:
   case fastmapfi_tclToken::EN_MSG_BREAKDOWNROUTEOCMETHODSTART:
   case fastmapfi_tclToken::EN_MSG_BREAKDOWNROUTEOCMETHODRESULT:
   case fastmapfi_tclToken::EN_MSG_RESERVECLIENTUSEIDRANGEMETHODSTART:
   case fastmapfi_tclToken::EN_MSG_RESERVECLIENTUSEIDRANGEMETHODRESULT:
   case fastmapfi_tclToken::EN_MSG_FREECLIENTUSEDIDRANGEMETHODSTART:
   case fastmapfi_tclToken::EN_MSG_FREECLIENTUSEDIDRANGEMETHODRESULT:
   case fastmapfi_tclToken::EN_MSG_GETCLIENTIDRANGEBYNAMEMETHODSTART:
   case fastmapfi_tclToken::EN_MSG_GETCLIENTIDRANGEBYNAMEMETHODRESULT:
   case fastmapfi_tclToken::EN_MSG_DATABLOCKSCHANGEDUPREG:
   case fastmapfi_tclToken::EN_MSG_DATABLOCKSCHANGEDRELUPREG:
   case fastmapfi_tclToken::EN_MSG_DATABLOCKSCHANGEDSTATUS:
   case fastmapfi_tclToken::EN_MSG_ENGINEERINGTEXTGET:
   case fastmapfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG:
   case fastmapfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG:
   case fastmapfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS:
      bInitMessage(enToken);
      break;
   case fastmapfi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_END_OF_STRUCT,fastmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U8,fastmapfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_LIST,fastmapfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fastmapfi_tclToken::EN_U16_INDEXINREFERENCELIST:
   {
      fi_tcl_u16_IndexInReferenceList o_u16_IndexInReferenceList;
      if (!bDoIt(o_u16_IndexInReferenceList))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case fastmapfi_tclToken::EN_S32_LONGITUDE:
   {
      fi_tcl_s32_Longitude o_s32_Longitude;
      if (!bDoIt(o_s32_Longitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case fastmapfi_tclToken::EN_S32_LATITUDE:
   {
      fi_tcl_s32_Latitude o_s32_Latitude;
      if (!bDoIt(o_s32_Latitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case fastmapfi_tclToken::EN_POSITIONWGS84:
   {
      if (poVisitor->bDoExpand_PositionWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_END_OF_STRUCT,fastmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_S32_LATITUDE,fastmapfi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_S32_LONGITUDE,fastmapfi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_PositionWGS84 o_PositionWGS84;
         if (!bDoIt(o_PositionWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fastmapfi_tclToken::EN_NAVCLUSTERDESC:
   {
      if (poVisitor->bDoExpand_NavClusterDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_END_OF_STRUCT,fastmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U16,fastmapfi_tclSemanticDomain::EN_LENGTH));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U32,fastmapfi_tclSemanticDomain::EN_FILEOFFSET));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U16,fastmapfi_tclSemanticDomain::EN_FILEID));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U8,fastmapfi_tclSemanticDomain::EN_LEVEL));
      }
      else
      {
         fi_tcl_NavClusterDesc o_NavClusterDesc;
         if (!bDoIt(o_NavClusterDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fastmapfi_tclToken::EN_E8_NAVONECELLDIRECTION:
   {
      fi_tcl_e8_NavOneCellDirection o_e8_NavOneCellDirection;
      if (!bDoIt(o_e8_NavOneCellDirection))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case fastmapfi_tclToken::EN_NAVONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_END_OF_STRUCT,fastmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U16_INDEXINREFERENCELIST,fastmapfi_tclSemanticDomain::EN_INDEXINCLUSTERREFLIST));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_E8_NAVONECELLDIRECTION,fastmapfi_tclSemanticDomain::EN_USEDIRECTION));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U16,fastmapfi_tclSemanticDomain::EN_ONECELLID));
      }
      else
      {
         fi_tcl_NavOneCellDesc o_NavOneCellDesc;
         if (!bDoIt(o_NavOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fastmapfi_tclToken::EN_E8_DAPORDERTYPE:
   {
      fi_tcl_e8_DapOrderType o_e8_DapOrderType;
      if (!bDoIt(o_e8_DapOrderType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case fastmapfi_tclToken::EN_NAVCLUSTERID:
   {
      if (poVisitor->bDoExpand_NavClusterId(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_END_OF_STRUCT,fastmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U16,fastmapfi_tclSemanticDomain::EN_FILEID));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U16,fastmapfi_tclSemanticDomain::EN_CLUSTERLENGTH));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U32,fastmapfi_tclSemanticDomain::EN_FILEOFFSET));
      }
      else
      {
         fi_tcl_NavClusterId o_NavClusterId;
         if (!bDoIt(o_NavClusterId))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fastmapfi_tclToken::EN_LOCALONECELLID:
   {
      if (poVisitor->bDoExpand_LocalOneCellID(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_END_OF_STRUCT,fastmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U16,fastmapfi_tclSemanticDomain::EN_ONECELLINDEX));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U16,fastmapfi_tclSemanticDomain::EN_CLUSTERINDEX));
      }
      else
      {
         fi_tcl_LocalOneCellID o_LocalOneCellID;
         if (!bDoIt(o_LocalOneCellID))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocalOneCellID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocalOneCellID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fastmapfi_tclToken::EN_E8_TRANSFERTYPE:
   {
      fi_tcl_e8_TransferType o_e8_TransferType;
      if (!bDoIt(o_e8_TransferType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case fastmapfi_tclToken::EN_E8_COORDINATECODING:
   {
      fi_tcl_e8_CoordinateCoding o_e8_CoordinateCoding;
      if (!bDoIt(o_e8_CoordinateCoding))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case fastmapfi_tclToken::EN_E16_DATATYPE:
   {
      fi_tcl_e16_DataType o_e16_DataType;
      if (!bDoIt(o_e16_DataType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case fastmapfi_tclToken::EN_UNIQUEID:
   {
      if (poVisitor->bDoExpand_UniqueID(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_END_OF_STRUCT,fastmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U32,fastmapfi_tclSemanticDomain::EN_SECONDELEMENT));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U32,fastmapfi_tclSemanticDomain::EN_FIRSTELEMENT));
      }
      else
      {
         fi_tcl_UniqueID o_UniqueID;
         if (!bDoIt(o_UniqueID))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UniqueID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_UniqueID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fastmapfi_tclToken::EN_MAPSCALE:
   {
      fi_tcl_MapScale o_MapScale;
      if (!bDoIt(o_MapScale))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case fastmapfi_tclToken::EN_BOUNDINGBOX:
   {
      if (poVisitor->bDoExpand_BoundingBox(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_END_OF_STRUCT,fastmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_POSITIONWGS84,fastmapfi_tclSemanticDomain::EN_BOUNDINGBOXUPPERRIGHT));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_POSITIONWGS84,fastmapfi_tclSemanticDomain::EN_BOUNDINGBOXLOWERLEFT));
      }
      else
      {
         fi_tcl_BoundingBox o_BoundingBox;
         if (!bDoIt(o_BoundingBox))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BoundingBox.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BoundingBox.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fastmapfi_tclToken::EN_RESULTBLOCKS:
   {
      if (poVisitor->bDoExpand_ResultBlocks(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_END_OF_STRUCT,fastmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U32,fastmapfi_tclSemanticDomain::EN_ERRORCODE));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U32,fastmapfi_tclSemanticDomain::EN_OFFSET));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_UNIQUEID,fastmapfi_tclSemanticDomain::EN_UNIQUEID));
      }
      else
      {
         fi_tcl_ResultBlocks o_ResultBlocks;
         if (!bDoIt(o_ResultBlocks))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ResultBlocks.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ResultBlocks.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fastmapfi_tclToken::EN_E8_REQUESTTYPE:
   {
      fi_tcl_e8_RequestType o_e8_RequestType;
      if (!bDoIt(o_e8_RequestType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case fastmapfi_tclToken::EN_E16_ONECELLINDEX:
   {
      fi_tcl_e16_OneCellIndex o_e16_OneCellIndex;
      if (!bDoIt(o_e16_OneCellIndex))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case fastmapfi_tclToken::EN_ONECELLRELATION:
   {
      if (poVisitor->bDoExpand_OneCellRelation(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_END_OF_STRUCT,fastmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_E8_NAVONECELLDIRECTION,fastmapfi_tclSemanticDomain::EN_USEDIRECTION));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_E16_ONECELLINDEX,fastmapfi_tclSemanticDomain::EN_PARENTONECELLINDEX));
      }
      else
      {
         fi_tcl_OneCellRelation o_OneCellRelation;
         if (!bDoIt(o_OneCellRelation))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_OneCellRelation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_OneCellRelation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case fastmapfi_tclToken::EN_SAMELEVELONECELLBLOCK:
   {
      if (poVisitor->bDoExpand_SameLevelOneCellBlock(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_END_OF_STRUCT,fastmapfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_ONECELLRELATION,fastmapfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_LIST,fastmapfi_tclSemanticDomain::EN_ONECELLRELATIONLIST));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_LOCALONECELLID,fastmapfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_LIST,fastmapfi_tclSemanticDomain::EN_ONECELLIDLIST));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_NAVCLUSTERID,fastmapfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_LIST,fastmapfi_tclSemanticDomain::EN_CLUSTERIDLIST));
         oPath.bGoDown(fastmapfi_tclKnot(fastmapfi_tclToken::EN_U8,fastmapfi_tclSemanticDomain::EN_LEVEL));
      }
      else
      {
         fi_tcl_SameLevelOneCellBlock o_SameLevelOneCellBlock;
         if (!bDoIt(o_SameLevelOneCellBlock))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SameLevelOneCellBlock.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SameLevelOneCellBlock.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case fastmapfi_tclToken::EN_UNKNOWN:
      case fastmapfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

