/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef DAP_TMCFITYPES_HEADER
#define DAP_TMCFITYPES_HEADER

// #include <vector>
// 


class dap_tmcfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class dap_tmcfi_tclMsgLocationTableListMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_tmcfi_tclMsgLocationTableListMethodStart():Priority(0),DataSize(0),u8OrderType(),u32DatasetId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_tmcfi_tclMsgLocationTableListMethodStart& operator=(const dap_tmcfi_tclMsgLocationTableListMethodStart& coRef);
   dap_tmcfi_tclMsgLocationTableListMethodStart(const dap_tmcfi_tclMsgLocationTableListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 Priority;
   tU32 DataSize;
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 u32DatasetId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_tmcfi_tclMsgLocationTableListMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_tmcfi_tclToken::EN_MSG_LOCATIONTABLELISTMETHODSTART;}
};

class dap_tmcfi_tclMsgLocationTableListMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_tmcfi_tclMsgLocationTableListMethodResult():Priority(0),DataSize(0),u32DatasetId(0),u32MaxLocationSizeWithOC(0),u32MaxLocationSizeWithoutOC(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_tmcfi_tclMsgLocationTableListMethodResult& operator=(const dap_tmcfi_tclMsgLocationTableListMethodResult& coRef);
   dap_tmcfi_tclMsgLocationTableListMethodResult(const dap_tmcfi_tclMsgLocationTableListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 Priority;
   tU32 DataSize;
   tU32 u32DatasetId;
   tU32 u32MaxLocationSizeWithOC;
   tU32 u32MaxLocationSizeWithoutOC;
   std::vector<fi_tcl_LocTableDesc, std::allocator<fi_tcl_LocTableDesc> > aoLocTables;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_tmcfi_tclMsgLocationTableListMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_tmcfi_tclToken::EN_MSG_LOCATIONTABLELISTMETHODRESULT;}
};

class dap_tmcfi_tclMsgGetLocationMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_tmcfi_tclMsgGetLocationMethodStart():Priority(0),DataSize(0),u8OrderType(),u32DatasetId(0),u16LocationId(0),T_LocTableIdent(),T_e8_LocClass(),bWithOCs(0),bFoundSecundary(0),u8Direction(0),u8Distance(0),u32SharedMemSize(0),szSharedMemory() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_tmcfi_tclMsgGetLocationMethodStart& operator=(const dap_tmcfi_tclMsgGetLocationMethodStart& coRef);
   dap_tmcfi_tclMsgGetLocationMethodStart(const dap_tmcfi_tclMsgGetLocationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 Priority;
   tU32 DataSize;
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 u32DatasetId;
   tU16 u16LocationId;
   fi_tcl_LocTableIdent T_LocTableIdent;
   fi_tcl_e8_LocClass T_e8_LocClass;
   tBool bWithOCs;
   tBool bFoundSecundary;
   tU8 u8Direction;
   tU8 u8Distance;
   tU32 u32SharedMemSize;
   fi_tclString szSharedMemory;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_tmcfi_tclMsgGetLocationMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_tmcfi_tclToken::EN_MSG_GETLOCATIONMETHODSTART;}
};

class dap_tmcfi_tclMsgGetLocationMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_tmcfi_tclMsgGetLocationMethodResult():Priority(0),DataSize(0),u32DatasetId(0),u16LocationId(0),oLocTableIdent(),enLocClass(),bWithOCs(0),bFoundSecundary(0),enDirection(),u8Distance(0),u32LocationSize(0),szSharedMemory(),oBBox() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_tmcfi_tclMsgGetLocationMethodResult& operator=(const dap_tmcfi_tclMsgGetLocationMethodResult& coRef);
   dap_tmcfi_tclMsgGetLocationMethodResult(const dap_tmcfi_tclMsgGetLocationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 Priority;
   tU32 DataSize;
   tU32 u32DatasetId;
   tU16 u16LocationId;
   fi_tcl_LocTableIdent oLocTableIdent;
   fi_tcl_e8_LocClass enLocClass;
   tBool bWithOCs;
   tBool bFoundSecundary;
   fi_tcl_e8_FollowDirection enDirection;
   tU8 u8Distance;
   tU32 u32LocationSize;
   fi_tclString szSharedMemory;
   fi_tcl_BBox oBBox;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_tmcfi_tclMsgGetLocationMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_tmcfi_tclToken::EN_MSG_GETLOCATIONMETHODRESULT;}
};

class dap_tmcfi_tclMsgLanguageIdListMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_tmcfi_tclMsgLanguageIdListMethodStart():Priority(0),DataSize(0),u8OrderType(),u32DatasetId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_tmcfi_tclMsgLanguageIdListMethodStart& operator=(const dap_tmcfi_tclMsgLanguageIdListMethodStart& coRef);
   dap_tmcfi_tclMsgLanguageIdListMethodStart(const dap_tmcfi_tclMsgLanguageIdListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 Priority;
   tU32 DataSize;
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 u32DatasetId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_tmcfi_tclMsgLanguageIdListMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_tmcfi_tclToken::EN_MSG_LANGUAGEIDLISTMETHODSTART;}
};

class dap_tmcfi_tclMsgLanguageIdListMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_tmcfi_tclMsgLanguageIdListMethodResult():Priority(0),DataSize(0),u32DatasetId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_tmcfi_tclMsgLanguageIdListMethodResult& operator=(const dap_tmcfi_tclMsgLanguageIdListMethodResult& coRef);
   dap_tmcfi_tclMsgLanguageIdListMethodResult(const dap_tmcfi_tclMsgLanguageIdListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 Priority;
   tU32 DataSize;
   tU32 u32DatasetId;
   std::vector<fi_tcl_LanguageIdElem, std::allocator<fi_tcl_LanguageIdElem> > aoLanguageIds;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_tmcfi_tclMsgLanguageIdListMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_tmcfi_tclToken::EN_MSG_LANGUAGEIDLISTMETHODRESULT;}
};

class dap_tmcfi_tclMsgBSAIdListMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_tmcfi_tclMsgBSAIdListMethodStart():Priority(0),DataSize(0),u8OrderType(),u32DatasetId(0),oLocTableIdent() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_tmcfi_tclMsgBSAIdListMethodStart& operator=(const dap_tmcfi_tclMsgBSAIdListMethodStart& coRef);
   dap_tmcfi_tclMsgBSAIdListMethodStart(const dap_tmcfi_tclMsgBSAIdListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 Priority;
   tU32 DataSize;
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 u32DatasetId;
   fi_tcl_LocTableIdent oLocTableIdent;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_tmcfi_tclMsgBSAIdListMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_tmcfi_tclToken::EN_MSG_BSAIDLISTMETHODSTART;}
};

class dap_tmcfi_tclMsgBSAIdListMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_tmcfi_tclMsgBSAIdListMethodResult():Priority(0),DataSize(0),u32DatasetId(0),oLocTableIdent() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_tmcfi_tclMsgBSAIdListMethodResult& operator=(const dap_tmcfi_tclMsgBSAIdListMethodResult& coRef);
   dap_tmcfi_tclMsgBSAIdListMethodResult(const dap_tmcfi_tclMsgBSAIdListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 Priority;
   tU32 DataSize;
   tU32 u32DatasetId;
   fi_tcl_LocTableIdent oLocTableIdent;
   std::vector<tU16, std::allocator<tU16> > au16BSAIds;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_tmcfi_tclMsgBSAIdListMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_tmcfi_tclToken::EN_MSG_BSAIDLISTMETHODRESULT;}
};

class dap_tmcfi_tclMsgPrefixTableMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_tmcfi_tclMsgPrefixTableMethodStart():Priority(0),DataSize(0),u8OrderType(),u32DatasetId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_tmcfi_tclMsgPrefixTableMethodStart& operator=(const dap_tmcfi_tclMsgPrefixTableMethodStart& coRef);
   dap_tmcfi_tclMsgPrefixTableMethodStart(const dap_tmcfi_tclMsgPrefixTableMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 Priority;
   tU32 DataSize;
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 u32DatasetId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_tmcfi_tclMsgPrefixTableMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_tmcfi_tclToken::EN_MSG_PREFIXTABLEMETHODSTART;}
};

class dap_tmcfi_tclMsgPrefixTableMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_tmcfi_tclMsgPrefixTableMethodResult():Priority(0),DataSize(0),u32DatasetId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_tmcfi_tclMsgPrefixTableMethodResult& operator=(const dap_tmcfi_tclMsgPrefixTableMethodResult& coRef);
   dap_tmcfi_tclMsgPrefixTableMethodResult(const dap_tmcfi_tclMsgPrefixTableMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 Priority;
   tU32 DataSize;
   tU32 u32DatasetId;
   std::vector<fi_tcl_PrefixTable, std::allocator<fi_tcl_PrefixTable> > aoPrefixTable;
   std::vector<fi_tcl_PrefixElem, std::allocator<fi_tcl_PrefixElem> > aoPrefixElems;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_tmcfi_tclMsgPrefixTableMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_tmcfi_tclToken::EN_MSG_PREFIXTABLEMETHODRESULT;}
};


#endif
