#ifndef __DAP_TMCFIDEBUGVISITOR_H__
#define __DAP_TMCFIDEBUGVISITOR_H__

class MY_DECL dap_tmcfi_tclPrintVisitor : public dap_tmcfi_tclVisitorBase {

private:
   /* default constructor */ dap_tmcfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   dap_tmcfi_tclPrintVisitor(fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(dap_tmcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tBool bDoExpand_PositionWGS84(dap_tmcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_e16_ISOLanguageCode(fi_tcl_e16_ISOLanguageCode& o_e16_ISOLanguageCode);
   virtual tVoid vVisit_e8_DapOrderType(fi_tcl_e8_DapOrderType& o_e8_DapOrderType);
   virtual tBool bDoExpand_BBox(dap_tmcfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_LocClass(fi_tcl_e8_LocClass& o_e8_LocClass);
   virtual tVoid vVisit_e8_FollowDirection(fi_tcl_e8_FollowDirection& o_e8_FollowDirection);
   virtual tBool bDoExpand_LocTableIdent(dap_tmcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Outline(dap_tmcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LanguageIdElem(dap_tmcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PrefixElem(dap_tmcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PrefixTable(dap_tmcfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LocTableDesc(dap_tmcfi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   fi_tclOutput* poOutput;
};


class MY_DECL dap_tmcfi_tclRandomInitVisitor : public dap_tmcfi_tclVisitorBase {
public:

   dap_tmcfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_e16_ISOLanguageCode(fi_tcl_e16_ISOLanguageCode& o_e16_ISOLanguageCode);
   virtual tVoid vVisit_e8_DapOrderType(fi_tcl_e8_DapOrderType& o_e8_DapOrderType);
   virtual tVoid vVisit_e8_LocClass(fi_tcl_e8_LocClass& o_e8_LocClass);
   virtual tVoid vVisit_e8_FollowDirection(fi_tcl_e8_FollowDirection& o_e8_FollowDirection);
	tU32 u32ListSize;
};

#endif
