/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef DAP_RNWFITYPES_HEADER
#define DAP_RNWFITYPES_HEADER

// #include <vector>
// 


class dap_rnwfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class dap_rnwfi_tclMsgGetMapBlocksMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgGetMapBlocksMethodStart():u8OrderType(),u32DatasetId(0),u32MemAdr(0),u32MemSize(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgGetMapBlocksMethodStart& operator=(const dap_rnwfi_tclMsgGetMapBlocksMethodStart& coRef);
   dap_rnwfi_tclMsgGetMapBlocksMethodStart(const dap_rnwfi_tclMsgGetMapBlocksMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 u32DatasetId;
   tU32 u32MemAdr;
   tU32 u32MemSize;
   std::vector<fi_tcl_UniqueID, std::allocator<fi_tcl_UniqueID> > aoUniqueIds;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgGetMapBlocksMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_GETMAPBLOCKSMETHODSTART;}
};

class dap_rnwfi_tclMsgGetMapBlocksMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgGetMapBlocksMethodResult():u32UsedMemSize(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgGetMapBlocksMethodResult& operator=(const dap_rnwfi_tclMsgGetMapBlocksMethodResult& coRef);
   dap_rnwfi_tclMsgGetMapBlocksMethodResult(const dap_rnwfi_tclMsgGetMapBlocksMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 u32UsedMemSize;
   std::vector<fi_tcl_ResultBlocks, std::allocator<fi_tcl_ResultBlocks> > aoResults;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgGetMapBlocksMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_GETMAPBLOCKSMETHODRESULT;}
};

class dap_rnwfi_tclMsgGetPrefixTableMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgGetPrefixTableMethodStart():u8OrderType(),u32DatasetId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgGetPrefixTableMethodStart& operator=(const dap_rnwfi_tclMsgGetPrefixTableMethodStart& coRef);
   dap_rnwfi_tclMsgGetPrefixTableMethodStart(const dap_rnwfi_tclMsgGetPrefixTableMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 u32DatasetId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgGetPrefixTableMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_GETPREFIXTABLEMETHODSTART;}
};

class dap_rnwfi_tclMsgGetPrefixTableMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgGetPrefixTableMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgGetPrefixTableMethodResult& operator=(const dap_rnwfi_tclMsgGetPrefixTableMethodResult& coRef);
   dap_rnwfi_tclMsgGetPrefixTableMethodResult(const dap_rnwfi_tclMsgGetPrefixTableMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_DapPrefixState, std::allocator<fi_tcl_DapPrefixState> > oPrefixTable;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgGetPrefixTableMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_GETPREFIXTABLEMETHODRESULT;}
};

class dap_rnwfi_tclMsgConvertOnecellListMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgConvertOnecellListMethodStart():u8OrderType(),DatasetId(0),u16HandleDummy(0),u32MemAdr(0),u32MemSize(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgConvertOnecellListMethodStart& operator=(const dap_rnwfi_tclMsgConvertOnecellListMethodStart& coRef);
   dap_rnwfi_tclMsgConvertOnecellListMethodStart(const dap_rnwfi_tclMsgConvertOnecellListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 DatasetId;
   tU16 u16HandleDummy;
   tU32 u32MemAdr;
   tU32 u32MemSize;
   std::vector<fi_tcl_NavClusterId, std::allocator<fi_tcl_NavClusterId> > ClusterIdList;
   std::vector<fi_tcl_LocalOneCellID, std::allocator<fi_tcl_LocalOneCellID> > OnecellIdList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgConvertOnecellListMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_CONVERTONECELLLISTMETHODSTART;}
};

class dap_rnwfi_tclMsgConvertOnecellListMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgConvertOnecellListMethodResult():Size(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgConvertOnecellListMethodResult& operator=(const dap_rnwfi_tclMsgConvertOnecellListMethodResult& coRef);
   dap_rnwfi_tclMsgConvertOnecellListMethodResult(const dap_rnwfi_tclMsgConvertOnecellListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 Size;
   std::vector<fi_tcl_ResultBlocks, std::allocator<fi_tcl_ResultBlocks> > ResultBlockList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgConvertOnecellListMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_CONVERTONECELLLISTMETHODRESULT;}
};

class dap_rnwfi_tclMsgBreakDownRouteOCMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgBreakDownRouteOCMethodStart():u8OrderType(),DatasetId(0),RequestType(),BreakDownLevel(0),BoundingBox() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgBreakDownRouteOCMethodStart& operator=(const dap_rnwfi_tclMsgBreakDownRouteOCMethodStart& coRef);
   dap_rnwfi_tclMsgBreakDownRouteOCMethodStart(const dap_rnwfi_tclMsgBreakDownRouteOCMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 DatasetId;
   fi_tcl_e8_RequestType RequestType;
   tU8 BreakDownLevel;
   fi_tcl_BoundingBox BoundingBox;
   std::vector<fi_tcl_NavClusterDesc, std::allocator<fi_tcl_NavClusterDesc> > ClusterIdList;
   std::vector<fi_tcl_NavOneCellDesc, std::allocator<fi_tcl_NavOneCellDesc> > OnecellIdList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgBreakDownRouteOCMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_BREAKDOWNROUTEOCMETHODSTART;}
};

class dap_rnwfi_tclMsgBreakDownRouteOCMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgBreakDownRouteOCMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgBreakDownRouteOCMethodResult& operator=(const dap_rnwfi_tclMsgBreakDownRouteOCMethodResult& coRef);
   dap_rnwfi_tclMsgBreakDownRouteOCMethodResult(const dap_rnwfi_tclMsgBreakDownRouteOCMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_SameLevelOneCellBlock, std::allocator<fi_tcl_SameLevelOneCellBlock> > RouteBreakDownList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgBreakDownRouteOCMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_BREAKDOWNROUTEOCMETHODRESULT;}
};

class dap_rnwfi_tclMsgGetRegProfOutlineMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgGetRegProfOutlineMethodStart():u8OrderType(),DatasetId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgGetRegProfOutlineMethodStart& operator=(const dap_rnwfi_tclMsgGetRegProfOutlineMethodStart& coRef);
   dap_rnwfi_tclMsgGetRegProfOutlineMethodStart(const dap_rnwfi_tclMsgGetRegProfOutlineMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 DatasetId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgGetRegProfOutlineMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_GETREGPROFOUTLINEMETHODSTART;}
};

class dap_rnwfi_tclMsgGetRegProfOutlineMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgGetRegProfOutlineMethodResult():DatasetId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgGetRegProfOutlineMethodResult& operator=(const dap_rnwfi_tclMsgGetRegProfOutlineMethodResult& coRef);
   dap_rnwfi_tclMsgGetRegProfOutlineMethodResult(const dap_rnwfi_tclMsgGetRegProfOutlineMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 DatasetId;
   std::vector<fi_tcl_RegProfOutline, std::allocator<fi_tcl_RegProfOutline> > oRegProfOutlineList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgGetRegProfOutlineMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_GETREGPROFOUTLINEMETHODRESULT;}
};

class dap_rnwfi_tclMsgGetRootFileHeaderMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgGetRootFileHeaderMethodStart():u8OrderType(),DatasetId(0),MemPos(),SharedMemory(),Semaphore() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgGetRootFileHeaderMethodStart& operator=(const dap_rnwfi_tclMsgGetRootFileHeaderMethodStart& coRef);
   dap_rnwfi_tclMsgGetRootFileHeaderMethodStart(const dap_rnwfi_tclMsgGetRootFileHeaderMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 DatasetId;
   fi_tcl_MemPos MemPos;
   fi_tclString SharedMemory;
   fi_tclString Semaphore;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgGetRootFileHeaderMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_GETROOTFILEHEADERMETHODSTART;}
};

class dap_rnwfi_tclMsgGetRootFileHeaderMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgGetRootFileHeaderMethodResult():MemPos() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgGetRootFileHeaderMethodResult& operator=(const dap_rnwfi_tclMsgGetRootFileHeaderMethodResult& coRef);
   dap_rnwfi_tclMsgGetRootFileHeaderMethodResult(const dap_rnwfi_tclMsgGetRootFileHeaderMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MemPos MemPos;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgGetRootFileHeaderMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_GETROOTFILEHEADERMETHODRESULT;}
};

class dap_rnwfi_tclMsgdap_rnw_readclusterMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgdap_rnw_readclusterMethodStart():u8OrderType(),DatasetId(0),MemPos(),SharedMemory(),Semaphore() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgdap_rnw_readclusterMethodStart& operator=(const dap_rnwfi_tclMsgdap_rnw_readclusterMethodStart& coRef);
   dap_rnwfi_tclMsgdap_rnw_readclusterMethodStart(const dap_rnwfi_tclMsgdap_rnw_readclusterMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 DatasetId;
   fi_tcl_MemPos MemPos;
   fi_tclString SharedMemory;
   fi_tclString Semaphore;
   std::vector<fi_tcl_ClusterStartInfo, std::allocator<fi_tcl_ClusterStartInfo> > ClusterInfos;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgdap_rnw_readclusterMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_DAP_RNW_READCLUSTERMETHODSTART;}
};

class dap_rnwfi_tclMsgdap_rnw_readclusterMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgdap_rnw_readclusterMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgdap_rnw_readclusterMethodResult& operator=(const dap_rnwfi_tclMsgdap_rnw_readclusterMethodResult& coRef);
   dap_rnwfi_tclMsgdap_rnw_readclusterMethodResult(const dap_rnwfi_tclMsgdap_rnw_readclusterMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_ClusterResultInfo, std::allocator<fi_tcl_ClusterResultInfo> > ClusterInfos;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgdap_rnw_readclusterMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_DAP_RNW_READCLUSTERMETHODRESULT;}
};

class dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodStart():u8OrderType(),DatasetId(0),MemPos(),SharedMemory(),Semaphore() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodStart& operator=(const dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodStart& coRef);
   dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodStart(const dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 DatasetId;
   fi_tcl_MemPos MemPos;
   fi_tclString SharedMemory;
   fi_tclString Semaphore;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_GETGLOBALINSTRUCTIONRECORDMETHODSTART;}
};

class dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodResult():MemPos() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodResult& operator=(const dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodResult& coRef);
   dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodResult(const dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MemPos MemPos;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_GETGLOBALINSTRUCTIONRECORDMETHODRESULT;}
};

class dap_rnwfi_tclMsgGetGlobalAreaRecordMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgGetGlobalAreaRecordMethodStart():u8OrderType(),DatasetId(0),MemPos(),SharedMemory(),Semaphore() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgGetGlobalAreaRecordMethodStart& operator=(const dap_rnwfi_tclMsgGetGlobalAreaRecordMethodStart& coRef);
   dap_rnwfi_tclMsgGetGlobalAreaRecordMethodStart(const dap_rnwfi_tclMsgGetGlobalAreaRecordMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 DatasetId;
   fi_tcl_MemPos MemPos;
   fi_tclString SharedMemory;
   fi_tclString Semaphore;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgGetGlobalAreaRecordMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_GETGLOBALAREARECORDMETHODSTART;}
};

class dap_rnwfi_tclMsgGetGlobalAreaRecordMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgGetGlobalAreaRecordMethodResult():MemPos() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgGetGlobalAreaRecordMethodResult& operator=(const dap_rnwfi_tclMsgGetGlobalAreaRecordMethodResult& coRef);
   dap_rnwfi_tclMsgGetGlobalAreaRecordMethodResult(const dap_rnwfi_tclMsgGetGlobalAreaRecordMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_MemPos MemPos;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgGetGlobalAreaRecordMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_GETGLOBALAREARECORDMETHODRESULT;}
};

class dap_rnwfi_tclMsgRequestUserIdentMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgRequestUserIdentMethodStart():u8OrderType(),MinUserMemory(0),MaxUserMemory(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgRequestUserIdentMethodStart& operator=(const dap_rnwfi_tclMsgRequestUserIdentMethodStart& coRef);
   dap_rnwfi_tclMsgRequestUserIdentMethodStart(const dap_rnwfi_tclMsgRequestUserIdentMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 MinUserMemory;
   tU32 MaxUserMemory;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgRequestUserIdentMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_REQUESTUSERIDENTMETHODSTART;}
};

class dap_rnwfi_tclMsgRequestUserIdentMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgRequestUserIdentMethodResult():UserIdent(0),SharedMemoryName(),SharedMemorySize(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgRequestUserIdentMethodResult& operator=(const dap_rnwfi_tclMsgRequestUserIdentMethodResult& coRef);
   dap_rnwfi_tclMsgRequestUserIdentMethodResult(const dap_rnwfi_tclMsgRequestUserIdentMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 UserIdent;
   fi_tclString SharedMemoryName;
   tU32 SharedMemorySize;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgRequestUserIdentMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_REQUESTUSERIDENTMETHODRESULT;}
};

class dap_rnwfi_tclMsgReleaseUserIdentMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgReleaseUserIdentMethodStart():u8OrderType(),UserIdent(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgReleaseUserIdentMethodStart& operator=(const dap_rnwfi_tclMsgReleaseUserIdentMethodStart& coRef);
   dap_rnwfi_tclMsgReleaseUserIdentMethodStart(const dap_rnwfi_tclMsgReleaseUserIdentMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 UserIdent;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgReleaseUserIdentMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_RELEASEUSERIDENTMETHODSTART;}
};

class dap_rnwfi_tclMsgReleaseUserIdentMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgReleaseUserIdentMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgReleaseUserIdentMethodResult& operator=(const dap_rnwfi_tclMsgReleaseUserIdentMethodResult& coRef);
   dap_rnwfi_tclMsgReleaseUserIdentMethodResult(const dap_rnwfi_tclMsgReleaseUserIdentMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgReleaseUserIdentMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_RELEASEUSERIDENTMETHODRESULT;}
};

class dap_rnwfi_tclMsgRequestGlobalDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgRequestGlobalDataMethodStart():u8OrderType(),UserIdent(0),DatasetId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgRequestGlobalDataMethodStart& operator=(const dap_rnwfi_tclMsgRequestGlobalDataMethodStart& coRef);
   dap_rnwfi_tclMsgRequestGlobalDataMethodStart(const dap_rnwfi_tclMsgRequestGlobalDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 UserIdent;
   tU32 DatasetId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgRequestGlobalDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_REQUESTGLOBALDATAMETHODSTART;}
};

class dap_rnwfi_tclMsgRequestGlobalDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgRequestGlobalDataMethodResult():UserIdent(0),DatasetId(0),RelOffset(0),MemoryUsage(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgRequestGlobalDataMethodResult& operator=(const dap_rnwfi_tclMsgRequestGlobalDataMethodResult& coRef);
   dap_rnwfi_tclMsgRequestGlobalDataMethodResult(const dap_rnwfi_tclMsgRequestGlobalDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 UserIdent;
   tU32 DatasetId;
   tU32 RelOffset;
   tU8 MemoryUsage;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgRequestGlobalDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_REQUESTGLOBALDATAMETHODRESULT;}
};

class dap_rnwfi_tclMsgReleaseGlobalDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgReleaseGlobalDataMethodStart():u8OrderType(),UserIdent(0),DatasetId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgReleaseGlobalDataMethodStart& operator=(const dap_rnwfi_tclMsgReleaseGlobalDataMethodStart& coRef);
   dap_rnwfi_tclMsgReleaseGlobalDataMethodStart(const dap_rnwfi_tclMsgReleaseGlobalDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 UserIdent;
   tU32 DatasetId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgReleaseGlobalDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_RELEASEGLOBALDATAMETHODSTART;}
};

class dap_rnwfi_tclMsgReleaseGlobalDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgReleaseGlobalDataMethodResult():UserIdent(0),DatasetId(0),MemoryUsage(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgReleaseGlobalDataMethodResult& operator=(const dap_rnwfi_tclMsgReleaseGlobalDataMethodResult& coRef);
   dap_rnwfi_tclMsgReleaseGlobalDataMethodResult(const dap_rnwfi_tclMsgReleaseGlobalDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 UserIdent;
   tU32 DatasetId;
   tU8 MemoryUsage;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgReleaseGlobalDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_RELEASEGLOBALDATAMETHODRESULT;}
};

class dap_rnwfi_tclMsgRequestDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgRequestDataMethodStart():u8OrderType(),UserIdent(0),DatasetId(0),ClusterId() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgRequestDataMethodStart& operator=(const dap_rnwfi_tclMsgRequestDataMethodStart& coRef);
   dap_rnwfi_tclMsgRequestDataMethodStart(const dap_rnwfi_tclMsgRequestDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 UserIdent;
   tU32 DatasetId;
   fi_tcl_NavClusterId ClusterId;
   std::vector<fi_tcl_e32_RNWExtensionType, std::allocator<fi_tcl_e32_RNWExtensionType> > Extensions;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgRequestDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_REQUESTDATAMETHODSTART;}
};

class dap_rnwfi_tclMsgRequestDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgRequestDataMethodResult():UserIdent(0),DatasetId(0),ClusterId(),RelOffsetCluster(0),MemoryUsage(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgRequestDataMethodResult& operator=(const dap_rnwfi_tclMsgRequestDataMethodResult& coRef);
   dap_rnwfi_tclMsgRequestDataMethodResult(const dap_rnwfi_tclMsgRequestDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 UserIdent;
   tU32 DatasetId;
   fi_tcl_NavClusterId ClusterId;
   std::vector<fi_tcl_e32_RNWExtensionType, std::allocator<fi_tcl_e32_RNWExtensionType> > Extensions;
   tU32 RelOffsetCluster;
   std::vector<tU32, std::allocator<tU32> > RelOffsetExtensions;
   tU8 MemoryUsage;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgRequestDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_REQUESTDATAMETHODRESULT;}
};

class dap_rnwfi_tclMsgReleaseDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgReleaseDataMethodStart():u8OrderType(),UserIdent(0),DatasetId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgReleaseDataMethodStart& operator=(const dap_rnwfi_tclMsgReleaseDataMethodStart& coRef);
   dap_rnwfi_tclMsgReleaseDataMethodStart(const dap_rnwfi_tclMsgReleaseDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 UserIdent;
   tU32 DatasetId;
   std::vector<fi_tcl_NavClusterId, std::allocator<fi_tcl_NavClusterId> > ClusterIds;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgReleaseDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_RELEASEDATAMETHODSTART;}
};

class dap_rnwfi_tclMsgReleaseDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgReleaseDataMethodResult():UserIdent(0),DatasetId(0),MemoryUsage(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgReleaseDataMethodResult& operator=(const dap_rnwfi_tclMsgReleaseDataMethodResult& coRef);
   dap_rnwfi_tclMsgReleaseDataMethodResult(const dap_rnwfi_tclMsgReleaseDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 UserIdent;
   tU32 DatasetId;
   std::vector<fi_tcl_RNWDataStorageInfo, std::allocator<fi_tcl_RNWDataStorageInfo> > ReleaseInfos;
   tU8 MemoryUsage;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgReleaseDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_RELEASEDATAMETHODRESULT;}
};

class dap_rnwfi_tclMsgGetDataStorageInfoMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgGetDataStorageInfoMethodStart():u8OrderType(),UserIdent(0),DatasetId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgGetDataStorageInfoMethodStart& operator=(const dap_rnwfi_tclMsgGetDataStorageInfoMethodStart& coRef);
   dap_rnwfi_tclMsgGetDataStorageInfoMethodStart(const dap_rnwfi_tclMsgGetDataStorageInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 UserIdent;
   tU32 DatasetId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgGetDataStorageInfoMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_GETDATASTORAGEINFOMETHODSTART;}
};

class dap_rnwfi_tclMsgGetDataStorageInfoMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgGetDataStorageInfoMethodResult():UserIdent(0),DatasetId(0),MemoryUsage(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgGetDataStorageInfoMethodResult& operator=(const dap_rnwfi_tclMsgGetDataStorageInfoMethodResult& coRef);
   dap_rnwfi_tclMsgGetDataStorageInfoMethodResult(const dap_rnwfi_tclMsgGetDataStorageInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 UserIdent;
   tU32 DatasetId;
   std::vector<fi_tcl_RNWDataStorageInfo, std::allocator<fi_tcl_RNWDataStorageInfo> > DataStorageInfos;
   tU8 MemoryUsage;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgGetDataStorageInfoMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_GETDATASTORAGEINFOMETHODRESULT;}
};

class dap_rnwfi_tclMsgDefaultDatasetIdGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgDefaultDatasetIdGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgDefaultDatasetIdGet& operator=(const dap_rnwfi_tclMsgDefaultDatasetIdGet& coRef);
   dap_rnwfi_tclMsgDefaultDatasetIdGet(const dap_rnwfi_tclMsgDefaultDatasetIdGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgDefaultDatasetIdGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_DEFAULTDATASETIDGET;}
};

class dap_rnwfi_tclMsgDefaultDatasetIdUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgDefaultDatasetIdUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgDefaultDatasetIdUpReg& operator=(const dap_rnwfi_tclMsgDefaultDatasetIdUpReg& coRef);
   dap_rnwfi_tclMsgDefaultDatasetIdUpReg(const dap_rnwfi_tclMsgDefaultDatasetIdUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgDefaultDatasetIdUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_DEFAULTDATASETIDUPREG;}
};

class dap_rnwfi_tclMsgDefaultDatasetIdRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgDefaultDatasetIdRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgDefaultDatasetIdRelUpReg& operator=(const dap_rnwfi_tclMsgDefaultDatasetIdRelUpReg& coRef);
   dap_rnwfi_tclMsgDefaultDatasetIdRelUpReg(const dap_rnwfi_tclMsgDefaultDatasetIdRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgDefaultDatasetIdRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_DEFAULTDATASETIDRELUPREG;}
};

class dap_rnwfi_tclMsgDefaultDatasetIdStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rnwfi_tclMsgDefaultDatasetIdStatus():u32DatasetId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rnwfi_tclMsgDefaultDatasetIdStatus& operator=(const dap_rnwfi_tclMsgDefaultDatasetIdStatus& coRef);
   dap_rnwfi_tclMsgDefaultDatasetIdStatus(const dap_rnwfi_tclMsgDefaultDatasetIdStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 u32DatasetId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rnwfi_tclMsgDefaultDatasetIdStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rnwfi_tclToken::EN_MSG_DEFAULTDATASETIDSTATUS;}
};


#endif
