/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetMapBlocksMethodStart::dap_rnwfi_tclMsgGetMapBlocksMethodStart(const dap_rnwfi_tclMsgGetMapBlocksMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   u32DatasetId = coRef.u32DatasetId;
   u32MemAdr = coRef.u32MemAdr;
   u32MemSize = coRef.u32MemSize;
   aoUniqueIds = coRef.aoUniqueIds;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetMapBlocksMethodStart& dap_rnwfi_tclMsgGetMapBlocksMethodStart::operator=(const dap_rnwfi_tclMsgGetMapBlocksMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   u32DatasetId = coRef.u32DatasetId;
   u32MemAdr = coRef.u32MemAdr;
   u32MemSize = coRef.u32MemSize;
   aoUniqueIds = coRef.aoUniqueIds;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgGetMapBlocksMethodStart::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgGetMapBlocksMethodStart::u16GetFunctionID() const {return DAP_RNWFI_C_U16_GETMAPBLOCKS;}
tU8 dap_rnwfi_tclMsgGetMapBlocksMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_rnwfi_tclMsgGetMapBlocksMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < aoUniqueIds.size(); ++u32Idx)
         aoUniqueIds[u32Idx].vDestroy();
   }
   aoUniqueIds.clear();
}

tU32 dap_rnwfi_tclMsgGetMapBlocksMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+16+aoUniqueIds.size()*8;
}

tBool dap_rnwfi_tclMsgGetMapBlocksMethodStart::operator==(const dap_rnwfi_tclMsgGetMapBlocksMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (u32DatasetId == rfoCmp.u32DatasetId);
      bResult = bResult && (u32MemAdr == rfoCmp.u32MemAdr);
      bResult = bResult && (u32MemSize == rfoCmp.u32MemSize);
      bResult = bResult && (aoUniqueIds.size() == rfoCmp.aoUniqueIds.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoUniqueIds.size()); ++u32Idx)
            bResult = bResult && (aoUniqueIds[u32Idx] == rfoCmp.aoUniqueIds[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgGetMapBlocksMethodStart::oRead(fi_tclInContext& oIn)
{
   if (2 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> u32DatasetId;
   oIn >> u32MemAdr;
   oIn >> u32MemSize;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoUniqueIds.size(); ++u32Idx)
      {
         aoUniqueIds[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoUniqueIds.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoUniqueIds[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgGetMapBlocksMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << u32DatasetId;
   oOut << u32MemAdr;
   oOut << u32MemSize;
   oOut << (tU32)aoUniqueIds.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoUniqueIds.size(); ++u32Idx)
         oOut << aoUniqueIds[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetMapBlocksMethodResult::dap_rnwfi_tclMsgGetMapBlocksMethodResult(const dap_rnwfi_tclMsgGetMapBlocksMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   u32UsedMemSize = coRef.u32UsedMemSize;
   aoResults = coRef.aoResults;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetMapBlocksMethodResult& dap_rnwfi_tclMsgGetMapBlocksMethodResult::operator=(const dap_rnwfi_tclMsgGetMapBlocksMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32UsedMemSize = coRef.u32UsedMemSize;
   aoResults = coRef.aoResults;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgGetMapBlocksMethodResult::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgGetMapBlocksMethodResult::u16GetFunctionID() const {return DAP_RNWFI_C_U16_GETMAPBLOCKS;}
tU8 dap_rnwfi_tclMsgGetMapBlocksMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_rnwfi_tclMsgGetMapBlocksMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < aoResults.size(); ++u32Idx)
         aoResults[u32Idx].vDestroy();
   }
   aoResults.clear();
}

tU32 dap_rnwfi_tclMsgGetMapBlocksMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+aoResults.size()*16;
}

tBool dap_rnwfi_tclMsgGetMapBlocksMethodResult::operator==(const dap_rnwfi_tclMsgGetMapBlocksMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u32UsedMemSize == rfoCmp.u32UsedMemSize);
      bResult = bResult && (aoResults.size() == rfoCmp.aoResults.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoResults.size()); ++u32Idx)
            bResult = bResult && (aoResults[u32Idx] == rfoCmp.aoResults[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgGetMapBlocksMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> u32UsedMemSize;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoResults.size(); ++u32Idx)
      {
         aoResults[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoResults.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoResults[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgGetMapBlocksMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u32UsedMemSize;
   oOut << (tU32)aoResults.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoResults.size(); ++u32Idx)
         oOut << aoResults[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetPrefixTableMethodStart::dap_rnwfi_tclMsgGetPrefixTableMethodStart(const dap_rnwfi_tclMsgGetPrefixTableMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   u32DatasetId = coRef.u32DatasetId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetPrefixTableMethodStart& dap_rnwfi_tclMsgGetPrefixTableMethodStart::operator=(const dap_rnwfi_tclMsgGetPrefixTableMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   u32DatasetId = coRef.u32DatasetId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgGetPrefixTableMethodStart::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgGetPrefixTableMethodStart::u16GetFunctionID() const {return DAP_RNWFI_C_U16_GETPREFIXTABLE;}
tU8 dap_rnwfi_tclMsgGetPrefixTableMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 dap_rnwfi_tclMsgGetPrefixTableMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+4;
}

tBool dap_rnwfi_tclMsgGetPrefixTableMethodStart::operator==(const dap_rnwfi_tclMsgGetPrefixTableMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (u32DatasetId == rfoCmp.u32DatasetId);
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgGetPrefixTableMethodStart::oRead(fi_tclInContext& oIn)
{
   if (2 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> u32DatasetId;
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgGetPrefixTableMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << u32DatasetId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetPrefixTableMethodResult::dap_rnwfi_tclMsgGetPrefixTableMethodResult(const dap_rnwfi_tclMsgGetPrefixTableMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   oPrefixTable = coRef.oPrefixTable;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetPrefixTableMethodResult& dap_rnwfi_tclMsgGetPrefixTableMethodResult::operator=(const dap_rnwfi_tclMsgGetPrefixTableMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oPrefixTable = coRef.oPrefixTable;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgGetPrefixTableMethodResult::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgGetPrefixTableMethodResult::u16GetFunctionID() const {return DAP_RNWFI_C_U16_GETPREFIXTABLE;}
tU8 dap_rnwfi_tclMsgGetPrefixTableMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_rnwfi_tclMsgGetPrefixTableMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oPrefixTable.size(); ++u32Idx)
         oPrefixTable[u32Idx].vDestroy();
   }
   oPrefixTable.clear();
}

tU32 dap_rnwfi_tclMsgGetPrefixTableMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oPrefixTable.size(); ++u32ListIdx)
      u32DynamicSize += oPrefixTable[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool dap_rnwfi_tclMsgGetPrefixTableMethodResult::operator==(const dap_rnwfi_tclMsgGetPrefixTableMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (oPrefixTable.size() == rfoCmp.oPrefixTable.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oPrefixTable.size()); ++u32Idx)
            bResult = bResult && (oPrefixTable[u32Idx] == rfoCmp.oPrefixTable[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgGetPrefixTableMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oPrefixTable.size(); ++u32Idx)
      {
         oPrefixTable[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      oPrefixTable.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> oPrefixTable[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgGetPrefixTableMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)oPrefixTable.size();
   {
      for (tU32 u32Idx = 0; u32Idx < oPrefixTable.size(); ++u32Idx)
         oOut << oPrefixTable[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgConvertOnecellListMethodStart::dap_rnwfi_tclMsgConvertOnecellListMethodStart(const dap_rnwfi_tclMsgConvertOnecellListMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   u16HandleDummy = coRef.u16HandleDummy;
   u32MemAdr = coRef.u32MemAdr;
   u32MemSize = coRef.u32MemSize;
   ClusterIdList = coRef.ClusterIdList;
   OnecellIdList = coRef.OnecellIdList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgConvertOnecellListMethodStart& dap_rnwfi_tclMsgConvertOnecellListMethodStart::operator=(const dap_rnwfi_tclMsgConvertOnecellListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   u16HandleDummy = coRef.u16HandleDummy;
   u32MemAdr = coRef.u32MemAdr;
   u32MemSize = coRef.u32MemSize;
   ClusterIdList = coRef.ClusterIdList;
   OnecellIdList = coRef.OnecellIdList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgConvertOnecellListMethodStart::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgConvertOnecellListMethodStart::u16GetFunctionID() const {return DAP_RNWFI_C_U16_CONVERTONECELLLIST;}
tU8 dap_rnwfi_tclMsgConvertOnecellListMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_rnwfi_tclMsgConvertOnecellListMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterIdList.size(); ++u32Idx)
         ClusterIdList[u32Idx].vDestroy();
   }
   ClusterIdList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < OnecellIdList.size(); ++u32Idx)
         OnecellIdList[u32Idx].vDestroy();
   }
   OnecellIdList.clear();
}

tU32 dap_rnwfi_tclMsgConvertOnecellListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (u16MajorVersion <= 1)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+20+ClusterIdList.size()*8+OnecellIdList.size()*4;
}

tBool dap_rnwfi_tclMsgConvertOnecellListMethodStart::operator==(const dap_rnwfi_tclMsgConvertOnecellListMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (u16HandleDummy == rfoCmp.u16HandleDummy);
      bResult = bResult && (u32MemAdr == rfoCmp.u32MemAdr);
      bResult = bResult && (u32MemSize == rfoCmp.u32MemSize);
      bResult = bResult && (ClusterIdList.size() == rfoCmp.ClusterIdList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClusterIdList.size()); ++u32Idx)
            bResult = bResult && (ClusterIdList[u32Idx] == rfoCmp.ClusterIdList[u32Idx]);
      }
      bResult = bResult && (OnecellIdList.size() == rfoCmp.OnecellIdList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OnecellIdList.size()); ++u32Idx)
            bResult = bResult && (OnecellIdList[u32Idx] == rfoCmp.OnecellIdList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgConvertOnecellListMethodStart::oRead(fi_tclInContext& oIn)
{
   if (2 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> DatasetId;
   if (oIn.u16GetMajorVersion() <= 1)
   {
      oIn >> u16HandleDummy;
   }
   oIn >> u32MemAdr;
   oIn >> u32MemSize;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ClusterIdList.size(); ++u32Idx)
      {
         ClusterIdList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ClusterIdList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ClusterIdList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OnecellIdList.size(); ++u32Idx)
      {
         OnecellIdList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      OnecellIdList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> OnecellIdList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgConvertOnecellListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << DatasetId;
   if (oOut.u16GetMajorVersion() <= 1)
   {
      oOut << u16HandleDummy;
   }
   oOut << u32MemAdr;
   oOut << u32MemSize;
   oOut << (tU32)ClusterIdList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterIdList.size(); ++u32Idx)
         oOut << ClusterIdList[u32Idx];
   }
   oOut << (tU32)OnecellIdList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < OnecellIdList.size(); ++u32Idx)
         oOut << OnecellIdList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgConvertOnecellListMethodResult::dap_rnwfi_tclMsgConvertOnecellListMethodResult(const dap_rnwfi_tclMsgConvertOnecellListMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Size = coRef.Size;
   ResultBlockList = coRef.ResultBlockList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgConvertOnecellListMethodResult& dap_rnwfi_tclMsgConvertOnecellListMethodResult::operator=(const dap_rnwfi_tclMsgConvertOnecellListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Size = coRef.Size;
   ResultBlockList = coRef.ResultBlockList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgConvertOnecellListMethodResult::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgConvertOnecellListMethodResult::u16GetFunctionID() const {return DAP_RNWFI_C_U16_CONVERTONECELLLIST;}
tU8 dap_rnwfi_tclMsgConvertOnecellListMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_rnwfi_tclMsgConvertOnecellListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ResultBlockList.size(); ++u32Idx)
         ResultBlockList[u32Idx].vDestroy();
   }
   ResultBlockList.clear();
}

tU32 dap_rnwfi_tclMsgConvertOnecellListMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ResultBlockList.size()*16;
}

tBool dap_rnwfi_tclMsgConvertOnecellListMethodResult::operator==(const dap_rnwfi_tclMsgConvertOnecellListMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Size == rfoCmp.Size);
      bResult = bResult && (ResultBlockList.size() == rfoCmp.ResultBlockList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ResultBlockList.size()); ++u32Idx)
            bResult = bResult && (ResultBlockList[u32Idx] == rfoCmp.ResultBlockList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgConvertOnecellListMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> Size;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ResultBlockList.size(); ++u32Idx)
      {
         ResultBlockList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ResultBlockList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ResultBlockList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgConvertOnecellListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Size;
   oOut << (tU32)ResultBlockList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ResultBlockList.size(); ++u32Idx)
         oOut << ResultBlockList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgBreakDownRouteOCMethodStart::dap_rnwfi_tclMsgBreakDownRouteOCMethodStart(const dap_rnwfi_tclMsgBreakDownRouteOCMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   RequestType = coRef.RequestType;
   BreakDownLevel = coRef.BreakDownLevel;
   BoundingBox = coRef.BoundingBox;
   ClusterIdList = coRef.ClusterIdList;
   OnecellIdList = coRef.OnecellIdList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgBreakDownRouteOCMethodStart& dap_rnwfi_tclMsgBreakDownRouteOCMethodStart::operator=(const dap_rnwfi_tclMsgBreakDownRouteOCMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   RequestType = coRef.RequestType;
   BreakDownLevel = coRef.BreakDownLevel;
   BoundingBox = coRef.BoundingBox;
   ClusterIdList = coRef.ClusterIdList;
   OnecellIdList = coRef.OnecellIdList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgBreakDownRouteOCMethodStart::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgBreakDownRouteOCMethodStart::u16GetFunctionID() const {return DAP_RNWFI_C_U16_BREAKDOWNROUTEOC;}
tU8 dap_rnwfi_tclMsgBreakDownRouteOCMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_rnwfi_tclMsgBreakDownRouteOCMethodStart::vDestroy()
{
   BoundingBox.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterIdList.size(); ++u32Idx)
         ClusterIdList[u32Idx].vDestroy();
   }
   ClusterIdList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < OnecellIdList.size(); ++u32Idx)
         OnecellIdList[u32Idx].vDestroy();
   }
   OnecellIdList.clear();
}

tU32 dap_rnwfi_tclMsgBreakDownRouteOCMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+30+ClusterIdList.size()*9+OnecellIdList.size()*5;
}

tBool dap_rnwfi_tclMsgBreakDownRouteOCMethodStart::operator==(const dap_rnwfi_tclMsgBreakDownRouteOCMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (RequestType == rfoCmp.RequestType);
      bResult = bResult && (BreakDownLevel == rfoCmp.BreakDownLevel);
      bResult = bResult && (BoundingBox == rfoCmp.BoundingBox);
      bResult = bResult && (ClusterIdList.size() == rfoCmp.ClusterIdList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClusterIdList.size()); ++u32Idx)
            bResult = bResult && (ClusterIdList[u32Idx] == rfoCmp.ClusterIdList[u32Idx]);
      }
      bResult = bResult && (OnecellIdList.size() == rfoCmp.OnecellIdList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OnecellIdList.size()); ++u32Idx)
            bResult = bResult && (OnecellIdList[u32Idx] == rfoCmp.OnecellIdList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgBreakDownRouteOCMethodStart::oRead(fi_tclInContext& oIn)
{
   if (2 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> DatasetId;
   oIn >> RequestType;
   oIn >> BreakDownLevel;
   oIn >> BoundingBox;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ClusterIdList.size(); ++u32Idx)
      {
         ClusterIdList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ClusterIdList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ClusterIdList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OnecellIdList.size(); ++u32Idx)
      {
         OnecellIdList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      OnecellIdList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> OnecellIdList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgBreakDownRouteOCMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << DatasetId;
   oOut << RequestType;
   oOut << BreakDownLevel;
   oOut << BoundingBox;
   oOut << (tU32)ClusterIdList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterIdList.size(); ++u32Idx)
         oOut << ClusterIdList[u32Idx];
   }
   oOut << (tU32)OnecellIdList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < OnecellIdList.size(); ++u32Idx)
         oOut << OnecellIdList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgBreakDownRouteOCMethodResult::dap_rnwfi_tclMsgBreakDownRouteOCMethodResult(const dap_rnwfi_tclMsgBreakDownRouteOCMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   RouteBreakDownList = coRef.RouteBreakDownList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgBreakDownRouteOCMethodResult& dap_rnwfi_tclMsgBreakDownRouteOCMethodResult::operator=(const dap_rnwfi_tclMsgBreakDownRouteOCMethodResult& coRef)
{
   if (this == &coRef) return *this;
   RouteBreakDownList = coRef.RouteBreakDownList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgBreakDownRouteOCMethodResult::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgBreakDownRouteOCMethodResult::u16GetFunctionID() const {return DAP_RNWFI_C_U16_BREAKDOWNROUTEOC;}
tU8 dap_rnwfi_tclMsgBreakDownRouteOCMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_rnwfi_tclMsgBreakDownRouteOCMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RouteBreakDownList.size(); ++u32Idx)
         RouteBreakDownList[u32Idx].vDestroy();
   }
   RouteBreakDownList.clear();
}

tU32 dap_rnwfi_tclMsgBreakDownRouteOCMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RouteBreakDownList.size(); ++u32ListIdx)
      u32DynamicSize += RouteBreakDownList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool dap_rnwfi_tclMsgBreakDownRouteOCMethodResult::operator==(const dap_rnwfi_tclMsgBreakDownRouteOCMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RouteBreakDownList.size() == rfoCmp.RouteBreakDownList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RouteBreakDownList.size()); ++u32Idx)
            bResult = bResult && (RouteBreakDownList[u32Idx] == rfoCmp.RouteBreakDownList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgBreakDownRouteOCMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RouteBreakDownList.size(); ++u32Idx)
      {
         RouteBreakDownList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RouteBreakDownList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RouteBreakDownList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgBreakDownRouteOCMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)RouteBreakDownList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RouteBreakDownList.size(); ++u32Idx)
         oOut << RouteBreakDownList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetRegProfOutlineMethodStart::dap_rnwfi_tclMsgGetRegProfOutlineMethodStart(const dap_rnwfi_tclMsgGetRegProfOutlineMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetRegProfOutlineMethodStart& dap_rnwfi_tclMsgGetRegProfOutlineMethodStart::operator=(const dap_rnwfi_tclMsgGetRegProfOutlineMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgGetRegProfOutlineMethodStart::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgGetRegProfOutlineMethodStart::u16GetFunctionID() const {return DAP_RNWFI_C_U16_GETREGPROFOUTLINE;}
tU8 dap_rnwfi_tclMsgGetRegProfOutlineMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 dap_rnwfi_tclMsgGetRegProfOutlineMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+4;
}

tBool dap_rnwfi_tclMsgGetRegProfOutlineMethodStart::operator==(const dap_rnwfi_tclMsgGetRegProfOutlineMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgGetRegProfOutlineMethodStart::oRead(fi_tclInContext& oIn)
{
   if (2 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> DatasetId;
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgGetRegProfOutlineMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << DatasetId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetRegProfOutlineMethodResult::dap_rnwfi_tclMsgGetRegProfOutlineMethodResult(const dap_rnwfi_tclMsgGetRegProfOutlineMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   DatasetId = coRef.DatasetId;
   oRegProfOutlineList = coRef.oRegProfOutlineList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetRegProfOutlineMethodResult& dap_rnwfi_tclMsgGetRegProfOutlineMethodResult::operator=(const dap_rnwfi_tclMsgGetRegProfOutlineMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DatasetId = coRef.DatasetId;
   oRegProfOutlineList = coRef.oRegProfOutlineList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgGetRegProfOutlineMethodResult::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgGetRegProfOutlineMethodResult::u16GetFunctionID() const {return DAP_RNWFI_C_U16_GETREGPROFOUTLINE;}
tU8 dap_rnwfi_tclMsgGetRegProfOutlineMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_rnwfi_tclMsgGetRegProfOutlineMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oRegProfOutlineList.size(); ++u32Idx)
         oRegProfOutlineList[u32Idx].vDestroy();
   }
   oRegProfOutlineList.clear();
}

tU32 dap_rnwfi_tclMsgGetRegProfOutlineMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oRegProfOutlineList.size(); ++u32ListIdx)
      u32DynamicSize += oRegProfOutlineList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool dap_rnwfi_tclMsgGetRegProfOutlineMethodResult::operator==(const dap_rnwfi_tclMsgGetRegProfOutlineMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (oRegProfOutlineList.size() == rfoCmp.oRegProfOutlineList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oRegProfOutlineList.size()); ++u32Idx)
            bResult = bResult && (oRegProfOutlineList[u32Idx] == rfoCmp.oRegProfOutlineList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgGetRegProfOutlineMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> DatasetId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oRegProfOutlineList.size(); ++u32Idx)
      {
         oRegProfOutlineList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      oRegProfOutlineList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> oRegProfOutlineList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgGetRegProfOutlineMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << DatasetId;
   oOut << (tU32)oRegProfOutlineList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < oRegProfOutlineList.size(); ++u32Idx)
         oOut << oRegProfOutlineList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetRootFileHeaderMethodStart::dap_rnwfi_tclMsgGetRootFileHeaderMethodStart(const dap_rnwfi_tclMsgGetRootFileHeaderMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   MemPos = coRef.MemPos;
   SharedMemory = coRef.SharedMemory;
   Semaphore = coRef.Semaphore;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetRootFileHeaderMethodStart& dap_rnwfi_tclMsgGetRootFileHeaderMethodStart::operator=(const dap_rnwfi_tclMsgGetRootFileHeaderMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   MemPos = coRef.MemPos;
   SharedMemory = coRef.SharedMemory;
   Semaphore = coRef.Semaphore;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgGetRootFileHeaderMethodStart::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgGetRootFileHeaderMethodStart::u16GetFunctionID() const {return DAP_RNWFI_C_U16_GETROOTFILEHEADER;}
tU8 dap_rnwfi_tclMsgGetRootFileHeaderMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_rnwfi_tclMsgGetRootFileHeaderMethodStart::vDestroy()
{
   MemPos.vDestroy(); 
   SharedMemory.vDestroy();
   Semaphore.vDestroy();
}

tU32 dap_rnwfi_tclMsgGetRootFileHeaderMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+12+SharedMemory.u32GetSize(u16MajorVersion)+Semaphore.u32GetSize(u16MajorVersion);
}

tBool dap_rnwfi_tclMsgGetRootFileHeaderMethodStart::operator==(const dap_rnwfi_tclMsgGetRootFileHeaderMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (MemPos == rfoCmp.MemPos);
      bResult = bResult && (SharedMemory == rfoCmp.SharedMemory);
      bResult = bResult && (Semaphore == rfoCmp.Semaphore);
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgGetRootFileHeaderMethodStart::oRead(fi_tclInContext& oIn)
{
   if (2 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> DatasetId;
   oIn >> MemPos;
   oIn >> SharedMemory;
   oIn >> Semaphore;
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgGetRootFileHeaderMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << DatasetId;
   oOut << MemPos;
   oOut << SharedMemory;
   oOut << Semaphore;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetRootFileHeaderMethodResult::dap_rnwfi_tclMsgGetRootFileHeaderMethodResult(const dap_rnwfi_tclMsgGetRootFileHeaderMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   MemPos = coRef.MemPos;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetRootFileHeaderMethodResult& dap_rnwfi_tclMsgGetRootFileHeaderMethodResult::operator=(const dap_rnwfi_tclMsgGetRootFileHeaderMethodResult& coRef)
{
   if (this == &coRef) return *this;
   MemPos = coRef.MemPos;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgGetRootFileHeaderMethodResult::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgGetRootFileHeaderMethodResult::u16GetFunctionID() const {return DAP_RNWFI_C_U16_GETROOTFILEHEADER;}
tU8 dap_rnwfi_tclMsgGetRootFileHeaderMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_rnwfi_tclMsgGetRootFileHeaderMethodResult::vDestroy()
{
   MemPos.vDestroy(); 
}

tU32 dap_rnwfi_tclMsgGetRootFileHeaderMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool dap_rnwfi_tclMsgGetRootFileHeaderMethodResult::operator==(const dap_rnwfi_tclMsgGetRootFileHeaderMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MemPos == rfoCmp.MemPos);
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgGetRootFileHeaderMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> MemPos;
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgGetRootFileHeaderMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MemPos;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgdap_rnw_readclusterMethodStart::dap_rnwfi_tclMsgdap_rnw_readclusterMethodStart(const dap_rnwfi_tclMsgdap_rnw_readclusterMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   MemPos = coRef.MemPos;
   SharedMemory = coRef.SharedMemory;
   Semaphore = coRef.Semaphore;
   ClusterInfos = coRef.ClusterInfos;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgdap_rnw_readclusterMethodStart& dap_rnwfi_tclMsgdap_rnw_readclusterMethodStart::operator=(const dap_rnwfi_tclMsgdap_rnw_readclusterMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   MemPos = coRef.MemPos;
   SharedMemory = coRef.SharedMemory;
   Semaphore = coRef.Semaphore;
   ClusterInfos = coRef.ClusterInfos;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgdap_rnw_readclusterMethodStart::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgdap_rnw_readclusterMethodStart::u16GetFunctionID() const {return DAP_RNWFI_C_U16_DAP_RNW_READCLUSTER;}
tU8 dap_rnwfi_tclMsgdap_rnw_readclusterMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_rnwfi_tclMsgdap_rnw_readclusterMethodStart::vDestroy()
{
   MemPos.vDestroy(); 
   SharedMemory.vDestroy();
   Semaphore.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterInfos.size(); ++u32Idx)
         ClusterInfos[u32Idx].vDestroy();
   }
   ClusterInfos.clear();
}

tU32 dap_rnwfi_tclMsgdap_rnw_readclusterMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+16+SharedMemory.u32GetSize(u16MajorVersion)+Semaphore.u32GetSize(u16MajorVersion)+ClusterInfos.size()*9;
}

tBool dap_rnwfi_tclMsgdap_rnw_readclusterMethodStart::operator==(const dap_rnwfi_tclMsgdap_rnw_readclusterMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (MemPos == rfoCmp.MemPos);
      bResult = bResult && (SharedMemory == rfoCmp.SharedMemory);
      bResult = bResult && (Semaphore == rfoCmp.Semaphore);
      bResult = bResult && (ClusterInfos.size() == rfoCmp.ClusterInfos.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClusterInfos.size()); ++u32Idx)
            bResult = bResult && (ClusterInfos[u32Idx] == rfoCmp.ClusterInfos[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgdap_rnw_readclusterMethodStart::oRead(fi_tclInContext& oIn)
{
   if (2 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> DatasetId;
   oIn >> MemPos;
   oIn >> SharedMemory;
   oIn >> Semaphore;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ClusterInfos.size(); ++u32Idx)
      {
         ClusterInfos[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ClusterInfos.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ClusterInfos[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgdap_rnw_readclusterMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << DatasetId;
   oOut << MemPos;
   oOut << SharedMemory;
   oOut << Semaphore;
   oOut << (tU32)ClusterInfos.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterInfos.size(); ++u32Idx)
         oOut << ClusterInfos[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgdap_rnw_readclusterMethodResult::dap_rnwfi_tclMsgdap_rnw_readclusterMethodResult(const dap_rnwfi_tclMsgdap_rnw_readclusterMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   ClusterInfos = coRef.ClusterInfos;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgdap_rnw_readclusterMethodResult& dap_rnwfi_tclMsgdap_rnw_readclusterMethodResult::operator=(const dap_rnwfi_tclMsgdap_rnw_readclusterMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ClusterInfos = coRef.ClusterInfos;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgdap_rnw_readclusterMethodResult::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgdap_rnw_readclusterMethodResult::u16GetFunctionID() const {return DAP_RNWFI_C_U16_DAP_RNW_READCLUSTER;}
tU8 dap_rnwfi_tclMsgdap_rnw_readclusterMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_rnwfi_tclMsgdap_rnw_readclusterMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterInfos.size(); ++u32Idx)
         ClusterInfos[u32Idx].vDestroy();
   }
   ClusterInfos.clear();
}

tU32 dap_rnwfi_tclMsgdap_rnw_readclusterMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ClusterInfos.size()*42;
}

tBool dap_rnwfi_tclMsgdap_rnw_readclusterMethodResult::operator==(const dap_rnwfi_tclMsgdap_rnw_readclusterMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ClusterInfos.size() == rfoCmp.ClusterInfos.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClusterInfos.size()); ++u32Idx)
            bResult = bResult && (ClusterInfos[u32Idx] == rfoCmp.ClusterInfos[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgdap_rnw_readclusterMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ClusterInfos.size(); ++u32Idx)
      {
         ClusterInfos[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ClusterInfos.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ClusterInfos[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgdap_rnw_readclusterMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ClusterInfos.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterInfos.size(); ++u32Idx)
         oOut << ClusterInfos[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodStart::dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodStart(const dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   MemPos = coRef.MemPos;
   SharedMemory = coRef.SharedMemory;
   Semaphore = coRef.Semaphore;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodStart& dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodStart::operator=(const dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   MemPos = coRef.MemPos;
   SharedMemory = coRef.SharedMemory;
   Semaphore = coRef.Semaphore;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodStart::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodStart::u16GetFunctionID() const {return DAP_RNWFI_C_U16_GETGLOBALINSTRUCTIONRECORD;}
tU8 dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodStart::vDestroy()
{
   MemPos.vDestroy(); 
   SharedMemory.vDestroy();
   Semaphore.vDestroy();
}

tU32 dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+12+SharedMemory.u32GetSize(u16MajorVersion)+Semaphore.u32GetSize(u16MajorVersion);
}

tBool dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodStart::operator==(const dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (MemPos == rfoCmp.MemPos);
      bResult = bResult && (SharedMemory == rfoCmp.SharedMemory);
      bResult = bResult && (Semaphore == rfoCmp.Semaphore);
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodStart::oRead(fi_tclInContext& oIn)
{
   if (2 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> DatasetId;
   oIn >> MemPos;
   oIn >> SharedMemory;
   oIn >> Semaphore;
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << DatasetId;
   oOut << MemPos;
   oOut << SharedMemory;
   oOut << Semaphore;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodResult::dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodResult(const dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   MemPos = coRef.MemPos;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodResult& dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodResult::operator=(const dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodResult& coRef)
{
   if (this == &coRef) return *this;
   MemPos = coRef.MemPos;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodResult::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodResult::u16GetFunctionID() const {return DAP_RNWFI_C_U16_GETGLOBALINSTRUCTIONRECORD;}
tU8 dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodResult::vDestroy()
{
   MemPos.vDestroy(); 
}

tU32 dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodResult::operator==(const dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MemPos == rfoCmp.MemPos);
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> MemPos;
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgGetGlobalInstructionRecordMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MemPos;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetGlobalAreaRecordMethodStart::dap_rnwfi_tclMsgGetGlobalAreaRecordMethodStart(const dap_rnwfi_tclMsgGetGlobalAreaRecordMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   MemPos = coRef.MemPos;
   SharedMemory = coRef.SharedMemory;
   Semaphore = coRef.Semaphore;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetGlobalAreaRecordMethodStart& dap_rnwfi_tclMsgGetGlobalAreaRecordMethodStart::operator=(const dap_rnwfi_tclMsgGetGlobalAreaRecordMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   MemPos = coRef.MemPos;
   SharedMemory = coRef.SharedMemory;
   Semaphore = coRef.Semaphore;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgGetGlobalAreaRecordMethodStart::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgGetGlobalAreaRecordMethodStart::u16GetFunctionID() const {return DAP_RNWFI_C_U16_GETGLOBALAREARECORD;}
tU8 dap_rnwfi_tclMsgGetGlobalAreaRecordMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_rnwfi_tclMsgGetGlobalAreaRecordMethodStart::vDestroy()
{
   MemPos.vDestroy(); 
   SharedMemory.vDestroy();
   Semaphore.vDestroy();
}

tU32 dap_rnwfi_tclMsgGetGlobalAreaRecordMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+12+SharedMemory.u32GetSize(u16MajorVersion)+Semaphore.u32GetSize(u16MajorVersion);
}

tBool dap_rnwfi_tclMsgGetGlobalAreaRecordMethodStart::operator==(const dap_rnwfi_tclMsgGetGlobalAreaRecordMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (MemPos == rfoCmp.MemPos);
      bResult = bResult && (SharedMemory == rfoCmp.SharedMemory);
      bResult = bResult && (Semaphore == rfoCmp.Semaphore);
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgGetGlobalAreaRecordMethodStart::oRead(fi_tclInContext& oIn)
{
   if (2 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> DatasetId;
   oIn >> MemPos;
   oIn >> SharedMemory;
   oIn >> Semaphore;
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgGetGlobalAreaRecordMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << DatasetId;
   oOut << MemPos;
   oOut << SharedMemory;
   oOut << Semaphore;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetGlobalAreaRecordMethodResult::dap_rnwfi_tclMsgGetGlobalAreaRecordMethodResult(const dap_rnwfi_tclMsgGetGlobalAreaRecordMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   MemPos = coRef.MemPos;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetGlobalAreaRecordMethodResult& dap_rnwfi_tclMsgGetGlobalAreaRecordMethodResult::operator=(const dap_rnwfi_tclMsgGetGlobalAreaRecordMethodResult& coRef)
{
   if (this == &coRef) return *this;
   MemPos = coRef.MemPos;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgGetGlobalAreaRecordMethodResult::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgGetGlobalAreaRecordMethodResult::u16GetFunctionID() const {return DAP_RNWFI_C_U16_GETGLOBALAREARECORD;}
tU8 dap_rnwfi_tclMsgGetGlobalAreaRecordMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_rnwfi_tclMsgGetGlobalAreaRecordMethodResult::vDestroy()
{
   MemPos.vDestroy(); 
}

tU32 dap_rnwfi_tclMsgGetGlobalAreaRecordMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool dap_rnwfi_tclMsgGetGlobalAreaRecordMethodResult::operator==(const dap_rnwfi_tclMsgGetGlobalAreaRecordMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MemPos == rfoCmp.MemPos);
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgGetGlobalAreaRecordMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> MemPos;
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgGetGlobalAreaRecordMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MemPos;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgRequestUserIdentMethodStart::dap_rnwfi_tclMsgRequestUserIdentMethodStart(const dap_rnwfi_tclMsgRequestUserIdentMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   MinUserMemory = coRef.MinUserMemory;
   MaxUserMemory = coRef.MaxUserMemory;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgRequestUserIdentMethodStart& dap_rnwfi_tclMsgRequestUserIdentMethodStart::operator=(const dap_rnwfi_tclMsgRequestUserIdentMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   MinUserMemory = coRef.MinUserMemory;
   MaxUserMemory = coRef.MaxUserMemory;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgRequestUserIdentMethodStart::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgRequestUserIdentMethodStart::u16GetFunctionID() const {return DAP_RNWFI_C_U16_REQUESTUSERIDENT;}
tU8 dap_rnwfi_tclMsgRequestUserIdentMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 dap_rnwfi_tclMsgRequestUserIdentMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

tBool dap_rnwfi_tclMsgRequestUserIdentMethodStart::operator==(const dap_rnwfi_tclMsgRequestUserIdentMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (MinUserMemory == rfoCmp.MinUserMemory);
      bResult = bResult && (MaxUserMemory == rfoCmp.MaxUserMemory);
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgRequestUserIdentMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> u8OrderType;
   oIn >> MinUserMemory;
   oIn >> MaxUserMemory;
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgRequestUserIdentMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8OrderType;
   oOut << MinUserMemory;
   oOut << MaxUserMemory;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgRequestUserIdentMethodResult::dap_rnwfi_tclMsgRequestUserIdentMethodResult(const dap_rnwfi_tclMsgRequestUserIdentMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UserIdent = coRef.UserIdent;
   SharedMemoryName = coRef.SharedMemoryName;
   SharedMemorySize = coRef.SharedMemorySize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgRequestUserIdentMethodResult& dap_rnwfi_tclMsgRequestUserIdentMethodResult::operator=(const dap_rnwfi_tclMsgRequestUserIdentMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UserIdent = coRef.UserIdent;
   SharedMemoryName = coRef.SharedMemoryName;
   SharedMemorySize = coRef.SharedMemorySize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgRequestUserIdentMethodResult::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgRequestUserIdentMethodResult::u16GetFunctionID() const {return DAP_RNWFI_C_U16_REQUESTUSERIDENT;}
tU8 dap_rnwfi_tclMsgRequestUserIdentMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_rnwfi_tclMsgRequestUserIdentMethodResult::vDestroy()
{
   SharedMemoryName.vDestroy();
}

tU32 dap_rnwfi_tclMsgRequestUserIdentMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+SharedMemoryName.u32GetSize(u16MajorVersion);
}

tBool dap_rnwfi_tclMsgRequestUserIdentMethodResult::operator==(const dap_rnwfi_tclMsgRequestUserIdentMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UserIdent == rfoCmp.UserIdent);
      bResult = bResult && (SharedMemoryName == rfoCmp.SharedMemoryName);
      bResult = bResult && (SharedMemorySize == rfoCmp.SharedMemorySize);
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgRequestUserIdentMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UserIdent;
   oIn >> SharedMemoryName;
   oIn >> SharedMemorySize;
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgRequestUserIdentMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UserIdent;
   oOut << SharedMemoryName;
   oOut << SharedMemorySize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgReleaseUserIdentMethodStart::dap_rnwfi_tclMsgReleaseUserIdentMethodStart(const dap_rnwfi_tclMsgReleaseUserIdentMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   UserIdent = coRef.UserIdent;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgReleaseUserIdentMethodStart& dap_rnwfi_tclMsgReleaseUserIdentMethodStart::operator=(const dap_rnwfi_tclMsgReleaseUserIdentMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   UserIdent = coRef.UserIdent;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgReleaseUserIdentMethodStart::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgReleaseUserIdentMethodStart::u16GetFunctionID() const {return DAP_RNWFI_C_U16_RELEASEUSERIDENT;}
tU8 dap_rnwfi_tclMsgReleaseUserIdentMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 dap_rnwfi_tclMsgReleaseUserIdentMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

tBool dap_rnwfi_tclMsgReleaseUserIdentMethodStart::operator==(const dap_rnwfi_tclMsgReleaseUserIdentMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (UserIdent == rfoCmp.UserIdent);
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgReleaseUserIdentMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> u8OrderType;
   oIn >> UserIdent;
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgReleaseUserIdentMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8OrderType;
   oOut << UserIdent;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgReleaseUserIdentMethodResult::dap_rnwfi_tclMsgReleaseUserIdentMethodResult(const dap_rnwfi_tclMsgReleaseUserIdentMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgReleaseUserIdentMethodResult& dap_rnwfi_tclMsgReleaseUserIdentMethodResult::operator=(const dap_rnwfi_tclMsgReleaseUserIdentMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgReleaseUserIdentMethodResult::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgReleaseUserIdentMethodResult::u16GetFunctionID() const {return DAP_RNWFI_C_U16_RELEASEUSERIDENT;}
tU8 dap_rnwfi_tclMsgReleaseUserIdentMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 dap_rnwfi_tclMsgReleaseUserIdentMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_rnwfi_tclMsgReleaseUserIdentMethodResult::operator==(const dap_rnwfi_tclMsgReleaseUserIdentMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgReleaseUserIdentMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgReleaseUserIdentMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgRequestGlobalDataMethodStart::dap_rnwfi_tclMsgRequestGlobalDataMethodStart(const dap_rnwfi_tclMsgRequestGlobalDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   UserIdent = coRef.UserIdent;
   DatasetId = coRef.DatasetId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgRequestGlobalDataMethodStart& dap_rnwfi_tclMsgRequestGlobalDataMethodStart::operator=(const dap_rnwfi_tclMsgRequestGlobalDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   UserIdent = coRef.UserIdent;
   DatasetId = coRef.DatasetId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgRequestGlobalDataMethodStart::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgRequestGlobalDataMethodStart::u16GetFunctionID() const {return DAP_RNWFI_C_U16_REQUESTGLOBALDATA;}
tU8 dap_rnwfi_tclMsgRequestGlobalDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 dap_rnwfi_tclMsgRequestGlobalDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

tBool dap_rnwfi_tclMsgRequestGlobalDataMethodStart::operator==(const dap_rnwfi_tclMsgRequestGlobalDataMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (UserIdent == rfoCmp.UserIdent);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgRequestGlobalDataMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> u8OrderType;
   oIn >> UserIdent;
   oIn >> DatasetId;
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgRequestGlobalDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8OrderType;
   oOut << UserIdent;
   oOut << DatasetId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgRequestGlobalDataMethodResult::dap_rnwfi_tclMsgRequestGlobalDataMethodResult(const dap_rnwfi_tclMsgRequestGlobalDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UserIdent = coRef.UserIdent;
   DatasetId = coRef.DatasetId;
   RelOffset = coRef.RelOffset;
   MemoryUsage = coRef.MemoryUsage;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgRequestGlobalDataMethodResult& dap_rnwfi_tclMsgRequestGlobalDataMethodResult::operator=(const dap_rnwfi_tclMsgRequestGlobalDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UserIdent = coRef.UserIdent;
   DatasetId = coRef.DatasetId;
   RelOffset = coRef.RelOffset;
   MemoryUsage = coRef.MemoryUsage;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgRequestGlobalDataMethodResult::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgRequestGlobalDataMethodResult::u16GetFunctionID() const {return DAP_RNWFI_C_U16_REQUESTGLOBALDATA;}
tU8 dap_rnwfi_tclMsgRequestGlobalDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 dap_rnwfi_tclMsgRequestGlobalDataMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

tBool dap_rnwfi_tclMsgRequestGlobalDataMethodResult::operator==(const dap_rnwfi_tclMsgRequestGlobalDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UserIdent == rfoCmp.UserIdent);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (RelOffset == rfoCmp.RelOffset);
      bResult = bResult && (MemoryUsage == rfoCmp.MemoryUsage);
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgRequestGlobalDataMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UserIdent;
   oIn >> DatasetId;
   oIn >> RelOffset;
   oIn >> MemoryUsage;
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgRequestGlobalDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UserIdent;
   oOut << DatasetId;
   oOut << RelOffset;
   oOut << MemoryUsage;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgReleaseGlobalDataMethodStart::dap_rnwfi_tclMsgReleaseGlobalDataMethodStart(const dap_rnwfi_tclMsgReleaseGlobalDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   UserIdent = coRef.UserIdent;
   DatasetId = coRef.DatasetId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgReleaseGlobalDataMethodStart& dap_rnwfi_tclMsgReleaseGlobalDataMethodStart::operator=(const dap_rnwfi_tclMsgReleaseGlobalDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   UserIdent = coRef.UserIdent;
   DatasetId = coRef.DatasetId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgReleaseGlobalDataMethodStart::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgReleaseGlobalDataMethodStart::u16GetFunctionID() const {return DAP_RNWFI_C_U16_RELEASEGLOBALDATA;}
tU8 dap_rnwfi_tclMsgReleaseGlobalDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 dap_rnwfi_tclMsgReleaseGlobalDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

tBool dap_rnwfi_tclMsgReleaseGlobalDataMethodStart::operator==(const dap_rnwfi_tclMsgReleaseGlobalDataMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (UserIdent == rfoCmp.UserIdent);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgReleaseGlobalDataMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> u8OrderType;
   oIn >> UserIdent;
   oIn >> DatasetId;
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgReleaseGlobalDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8OrderType;
   oOut << UserIdent;
   oOut << DatasetId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgReleaseGlobalDataMethodResult::dap_rnwfi_tclMsgReleaseGlobalDataMethodResult(const dap_rnwfi_tclMsgReleaseGlobalDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UserIdent = coRef.UserIdent;
   DatasetId = coRef.DatasetId;
   MemoryUsage = coRef.MemoryUsage;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgReleaseGlobalDataMethodResult& dap_rnwfi_tclMsgReleaseGlobalDataMethodResult::operator=(const dap_rnwfi_tclMsgReleaseGlobalDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UserIdent = coRef.UserIdent;
   DatasetId = coRef.DatasetId;
   MemoryUsage = coRef.MemoryUsage;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgReleaseGlobalDataMethodResult::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgReleaseGlobalDataMethodResult::u16GetFunctionID() const {return DAP_RNWFI_C_U16_RELEASEGLOBALDATA;}
tU8 dap_rnwfi_tclMsgReleaseGlobalDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 dap_rnwfi_tclMsgReleaseGlobalDataMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

tBool dap_rnwfi_tclMsgReleaseGlobalDataMethodResult::operator==(const dap_rnwfi_tclMsgReleaseGlobalDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UserIdent == rfoCmp.UserIdent);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (MemoryUsage == rfoCmp.MemoryUsage);
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgReleaseGlobalDataMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UserIdent;
   oIn >> DatasetId;
   oIn >> MemoryUsage;
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgReleaseGlobalDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UserIdent;
   oOut << DatasetId;
   oOut << MemoryUsage;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgRequestDataMethodStart::dap_rnwfi_tclMsgRequestDataMethodStart(const dap_rnwfi_tclMsgRequestDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   UserIdent = coRef.UserIdent;
   DatasetId = coRef.DatasetId;
   ClusterId = coRef.ClusterId;
   Extensions = coRef.Extensions;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgRequestDataMethodStart& dap_rnwfi_tclMsgRequestDataMethodStart::operator=(const dap_rnwfi_tclMsgRequestDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   UserIdent = coRef.UserIdent;
   DatasetId = coRef.DatasetId;
   ClusterId = coRef.ClusterId;
   Extensions = coRef.Extensions;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgRequestDataMethodStart::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgRequestDataMethodStart::u16GetFunctionID() const {return DAP_RNWFI_C_U16_REQUESTDATA;}
tU8 dap_rnwfi_tclMsgRequestDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_rnwfi_tclMsgRequestDataMethodStart::vDestroy()
{
   ClusterId.vDestroy(); 
   Extensions.clear();
}

tU32 dap_rnwfi_tclMsgRequestDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 21+Extensions.size()*1;
}

tBool dap_rnwfi_tclMsgRequestDataMethodStart::operator==(const dap_rnwfi_tclMsgRequestDataMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (UserIdent == rfoCmp.UserIdent);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (ClusterId == rfoCmp.ClusterId);
      bResult = bResult && (Extensions.size() == rfoCmp.Extensions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Extensions.size()); ++u32Idx)
            bResult = bResult && (Extensions[u32Idx] == rfoCmp.Extensions[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgRequestDataMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> u8OrderType;
   oIn >> UserIdent;
   oIn >> DatasetId;
   oIn >> ClusterId;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      Extensions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Extensions[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgRequestDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8OrderType;
   oOut << UserIdent;
   oOut << DatasetId;
   oOut << ClusterId;
   oOut << (tU32)Extensions.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Extensions.size(); ++u32Idx)
         oOut << Extensions[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgRequestDataMethodResult::dap_rnwfi_tclMsgRequestDataMethodResult(const dap_rnwfi_tclMsgRequestDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UserIdent = coRef.UserIdent;
   DatasetId = coRef.DatasetId;
   ClusterId = coRef.ClusterId;
   Extensions = coRef.Extensions;
   RelOffsetCluster = coRef.RelOffsetCluster;
   RelOffsetExtensions = coRef.RelOffsetExtensions;
   MemoryUsage = coRef.MemoryUsage;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgRequestDataMethodResult& dap_rnwfi_tclMsgRequestDataMethodResult::operator=(const dap_rnwfi_tclMsgRequestDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UserIdent = coRef.UserIdent;
   DatasetId = coRef.DatasetId;
   ClusterId = coRef.ClusterId;
   Extensions = coRef.Extensions;
   RelOffsetCluster = coRef.RelOffsetCluster;
   RelOffsetExtensions = coRef.RelOffsetExtensions;
   MemoryUsage = coRef.MemoryUsage;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgRequestDataMethodResult::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgRequestDataMethodResult::u16GetFunctionID() const {return DAP_RNWFI_C_U16_REQUESTDATA;}
tU8 dap_rnwfi_tclMsgRequestDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_rnwfi_tclMsgRequestDataMethodResult::vDestroy()
{
   ClusterId.vDestroy(); 
   Extensions.clear();
   RelOffsetExtensions.clear();
}

tU32 dap_rnwfi_tclMsgRequestDataMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 29+Extensions.size()*1+RelOffsetExtensions.size()*4;
}

tBool dap_rnwfi_tclMsgRequestDataMethodResult::operator==(const dap_rnwfi_tclMsgRequestDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UserIdent == rfoCmp.UserIdent);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (ClusterId == rfoCmp.ClusterId);
      bResult = bResult && (Extensions.size() == rfoCmp.Extensions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Extensions.size()); ++u32Idx)
            bResult = bResult && (Extensions[u32Idx] == rfoCmp.Extensions[u32Idx]);
      }
      bResult = bResult && (RelOffsetCluster == rfoCmp.RelOffsetCluster);
      bResult = bResult && (RelOffsetExtensions.size() == rfoCmp.RelOffsetExtensions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RelOffsetExtensions.size()); ++u32Idx)
            bResult = bResult && (RelOffsetExtensions[u32Idx] == rfoCmp.RelOffsetExtensions[u32Idx]);
      }
      bResult = bResult && (MemoryUsage == rfoCmp.MemoryUsage);
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgRequestDataMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UserIdent;
   oIn >> DatasetId;
   oIn >> ClusterId;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      Extensions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Extensions[u32Idx];
      }
   }
   oIn >> RelOffsetCluster;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      RelOffsetExtensions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RelOffsetExtensions[u32Idx];
      }
   }
   oIn >> MemoryUsage;
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgRequestDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UserIdent;
   oOut << DatasetId;
   oOut << ClusterId;
   oOut << (tU32)Extensions.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Extensions.size(); ++u32Idx)
         oOut << Extensions[u32Idx];
   }
   oOut << RelOffsetCluster;
   oOut << (tU32)RelOffsetExtensions.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RelOffsetExtensions.size(); ++u32Idx)
         oOut << RelOffsetExtensions[u32Idx];
   }
   oOut << MemoryUsage;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgReleaseDataMethodStart::dap_rnwfi_tclMsgReleaseDataMethodStart(const dap_rnwfi_tclMsgReleaseDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   UserIdent = coRef.UserIdent;
   DatasetId = coRef.DatasetId;
   ClusterIds = coRef.ClusterIds;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgReleaseDataMethodStart& dap_rnwfi_tclMsgReleaseDataMethodStart::operator=(const dap_rnwfi_tclMsgReleaseDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   UserIdent = coRef.UserIdent;
   DatasetId = coRef.DatasetId;
   ClusterIds = coRef.ClusterIds;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgReleaseDataMethodStart::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgReleaseDataMethodStart::u16GetFunctionID() const {return DAP_RNWFI_C_U16_RELEASEDATA;}
tU8 dap_rnwfi_tclMsgReleaseDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_rnwfi_tclMsgReleaseDataMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterIds.size(); ++u32Idx)
         ClusterIds[u32Idx].vDestroy();
   }
   ClusterIds.clear();
}

tU32 dap_rnwfi_tclMsgReleaseDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13+ClusterIds.size()*8;
}

tBool dap_rnwfi_tclMsgReleaseDataMethodStart::operator==(const dap_rnwfi_tclMsgReleaseDataMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (UserIdent == rfoCmp.UserIdent);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (ClusterIds.size() == rfoCmp.ClusterIds.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClusterIds.size()); ++u32Idx)
            bResult = bResult && (ClusterIds[u32Idx] == rfoCmp.ClusterIds[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgReleaseDataMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> u8OrderType;
   oIn >> UserIdent;
   oIn >> DatasetId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ClusterIds.size(); ++u32Idx)
      {
         ClusterIds[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ClusterIds.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ClusterIds[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgReleaseDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8OrderType;
   oOut << UserIdent;
   oOut << DatasetId;
   oOut << (tU32)ClusterIds.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterIds.size(); ++u32Idx)
         oOut << ClusterIds[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgReleaseDataMethodResult::dap_rnwfi_tclMsgReleaseDataMethodResult(const dap_rnwfi_tclMsgReleaseDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UserIdent = coRef.UserIdent;
   DatasetId = coRef.DatasetId;
   ReleaseInfos = coRef.ReleaseInfos;
   MemoryUsage = coRef.MemoryUsage;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgReleaseDataMethodResult& dap_rnwfi_tclMsgReleaseDataMethodResult::operator=(const dap_rnwfi_tclMsgReleaseDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UserIdent = coRef.UserIdent;
   DatasetId = coRef.DatasetId;
   ReleaseInfos = coRef.ReleaseInfos;
   MemoryUsage = coRef.MemoryUsage;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgReleaseDataMethodResult::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgReleaseDataMethodResult::u16GetFunctionID() const {return DAP_RNWFI_C_U16_RELEASEDATA;}
tU8 dap_rnwfi_tclMsgReleaseDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_rnwfi_tclMsgReleaseDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ReleaseInfos.size(); ++u32Idx)
         ReleaseInfos[u32Idx].vDestroy();
   }
   ReleaseInfos.clear();
}

tU32 dap_rnwfi_tclMsgReleaseDataMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13+ReleaseInfos.size()*9;
}

tBool dap_rnwfi_tclMsgReleaseDataMethodResult::operator==(const dap_rnwfi_tclMsgReleaseDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UserIdent == rfoCmp.UserIdent);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (ReleaseInfos.size() == rfoCmp.ReleaseInfos.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ReleaseInfos.size()); ++u32Idx)
            bResult = bResult && (ReleaseInfos[u32Idx] == rfoCmp.ReleaseInfos[u32Idx]);
      }
      bResult = bResult && (MemoryUsage == rfoCmp.MemoryUsage);
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgReleaseDataMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UserIdent;
   oIn >> DatasetId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ReleaseInfos.size(); ++u32Idx)
      {
         ReleaseInfos[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ReleaseInfos.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ReleaseInfos[u32Idx];
      }
   }
   oIn >> MemoryUsage;
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgReleaseDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UserIdent;
   oOut << DatasetId;
   oOut << (tU32)ReleaseInfos.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ReleaseInfos.size(); ++u32Idx)
         oOut << ReleaseInfos[u32Idx];
   }
   oOut << MemoryUsage;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetDataStorageInfoMethodStart::dap_rnwfi_tclMsgGetDataStorageInfoMethodStart(const dap_rnwfi_tclMsgGetDataStorageInfoMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   UserIdent = coRef.UserIdent;
   DatasetId = coRef.DatasetId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetDataStorageInfoMethodStart& dap_rnwfi_tclMsgGetDataStorageInfoMethodStart::operator=(const dap_rnwfi_tclMsgGetDataStorageInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   UserIdent = coRef.UserIdent;
   DatasetId = coRef.DatasetId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgGetDataStorageInfoMethodStart::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgGetDataStorageInfoMethodStart::u16GetFunctionID() const {return DAP_RNWFI_C_U16_GETDATASTORAGEINFO;}
tU8 dap_rnwfi_tclMsgGetDataStorageInfoMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 dap_rnwfi_tclMsgGetDataStorageInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

tBool dap_rnwfi_tclMsgGetDataStorageInfoMethodStart::operator==(const dap_rnwfi_tclMsgGetDataStorageInfoMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (UserIdent == rfoCmp.UserIdent);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgGetDataStorageInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> u8OrderType;
   oIn >> UserIdent;
   oIn >> DatasetId;
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgGetDataStorageInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8OrderType;
   oOut << UserIdent;
   oOut << DatasetId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetDataStorageInfoMethodResult::dap_rnwfi_tclMsgGetDataStorageInfoMethodResult(const dap_rnwfi_tclMsgGetDataStorageInfoMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UserIdent = coRef.UserIdent;
   DatasetId = coRef.DatasetId;
   DataStorageInfos = coRef.DataStorageInfos;
   MemoryUsage = coRef.MemoryUsage;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgGetDataStorageInfoMethodResult& dap_rnwfi_tclMsgGetDataStorageInfoMethodResult::operator=(const dap_rnwfi_tclMsgGetDataStorageInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UserIdent = coRef.UserIdent;
   DatasetId = coRef.DatasetId;
   DataStorageInfos = coRef.DataStorageInfos;
   MemoryUsage = coRef.MemoryUsage;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgGetDataStorageInfoMethodResult::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgGetDataStorageInfoMethodResult::u16GetFunctionID() const {return DAP_RNWFI_C_U16_GETDATASTORAGEINFO;}
tU8 dap_rnwfi_tclMsgGetDataStorageInfoMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_rnwfi_tclMsgGetDataStorageInfoMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DataStorageInfos.size(); ++u32Idx)
         DataStorageInfos[u32Idx].vDestroy();
   }
   DataStorageInfos.clear();
}

tU32 dap_rnwfi_tclMsgGetDataStorageInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13+DataStorageInfos.size()*9;
}

tBool dap_rnwfi_tclMsgGetDataStorageInfoMethodResult::operator==(const dap_rnwfi_tclMsgGetDataStorageInfoMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UserIdent == rfoCmp.UserIdent);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (DataStorageInfos.size() == rfoCmp.DataStorageInfos.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DataStorageInfos.size()); ++u32Idx)
            bResult = bResult && (DataStorageInfos[u32Idx] == rfoCmp.DataStorageInfos[u32Idx]);
      }
      bResult = bResult && (MemoryUsage == rfoCmp.MemoryUsage);
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgGetDataStorageInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UserIdent;
   oIn >> DatasetId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DataStorageInfos.size(); ++u32Idx)
      {
         DataStorageInfos[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      DataStorageInfos.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> DataStorageInfos[u32Idx];
      }
   }
   oIn >> MemoryUsage;
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgGetDataStorageInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UserIdent;
   oOut << DatasetId;
   oOut << (tU32)DataStorageInfos.size();
   {
      for (tU32 u32Idx = 0; u32Idx < DataStorageInfos.size(); ++u32Idx)
         oOut << DataStorageInfos[u32Idx];
   }
   oOut << MemoryUsage;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgDefaultDatasetIdGet::dap_rnwfi_tclMsgDefaultDatasetIdGet(const dap_rnwfi_tclMsgDefaultDatasetIdGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgDefaultDatasetIdGet& dap_rnwfi_tclMsgDefaultDatasetIdGet::operator=(const dap_rnwfi_tclMsgDefaultDatasetIdGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgDefaultDatasetIdGet::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgDefaultDatasetIdGet::u16GetFunctionID() const {return DAP_RNWFI_C_U16_DEFAULTDATASETID;}
tU8 dap_rnwfi_tclMsgDefaultDatasetIdGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 dap_rnwfi_tclMsgDefaultDatasetIdGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_rnwfi_tclMsgDefaultDatasetIdGet::operator==(const dap_rnwfi_tclMsgDefaultDatasetIdGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgDefaultDatasetIdGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgDefaultDatasetIdGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgDefaultDatasetIdUpReg::dap_rnwfi_tclMsgDefaultDatasetIdUpReg(const dap_rnwfi_tclMsgDefaultDatasetIdUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgDefaultDatasetIdUpReg& dap_rnwfi_tclMsgDefaultDatasetIdUpReg::operator=(const dap_rnwfi_tclMsgDefaultDatasetIdUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgDefaultDatasetIdUpReg::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgDefaultDatasetIdUpReg::u16GetFunctionID() const {return DAP_RNWFI_C_U16_DEFAULTDATASETID;}
tU8 dap_rnwfi_tclMsgDefaultDatasetIdUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 dap_rnwfi_tclMsgDefaultDatasetIdUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_rnwfi_tclMsgDefaultDatasetIdUpReg::operator==(const dap_rnwfi_tclMsgDefaultDatasetIdUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgDefaultDatasetIdUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgDefaultDatasetIdUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgDefaultDatasetIdRelUpReg::dap_rnwfi_tclMsgDefaultDatasetIdRelUpReg(const dap_rnwfi_tclMsgDefaultDatasetIdRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgDefaultDatasetIdRelUpReg& dap_rnwfi_tclMsgDefaultDatasetIdRelUpReg::operator=(const dap_rnwfi_tclMsgDefaultDatasetIdRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgDefaultDatasetIdRelUpReg::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgDefaultDatasetIdRelUpReg::u16GetFunctionID() const {return DAP_RNWFI_C_U16_DEFAULTDATASETID;}
tU8 dap_rnwfi_tclMsgDefaultDatasetIdRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 dap_rnwfi_tclMsgDefaultDatasetIdRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_rnwfi_tclMsgDefaultDatasetIdRelUpReg::operator==(const dap_rnwfi_tclMsgDefaultDatasetIdRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgDefaultDatasetIdRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgDefaultDatasetIdRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgDefaultDatasetIdStatus::dap_rnwfi_tclMsgDefaultDatasetIdStatus(const dap_rnwfi_tclMsgDefaultDatasetIdStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   u32DatasetId = coRef.u32DatasetId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rnwfi_tclMsgDefaultDatasetIdStatus& dap_rnwfi_tclMsgDefaultDatasetIdStatus::operator=(const dap_rnwfi_tclMsgDefaultDatasetIdStatus& coRef)
{
   if (this == &coRef) return *this;
   u32DatasetId = coRef.u32DatasetId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rnwfi_tclMsgDefaultDatasetIdStatus::u16GetServiceID() const {return DAP_RNWFI_C_U16_SERVICE_ID;}
tU16 dap_rnwfi_tclMsgDefaultDatasetIdStatus::u16GetFunctionID() const {return DAP_RNWFI_C_U16_DEFAULTDATASETID;}
tU8 dap_rnwfi_tclMsgDefaultDatasetIdStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 dap_rnwfi_tclMsgDefaultDatasetIdStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool dap_rnwfi_tclMsgDefaultDatasetIdStatus::operator==(const dap_rnwfi_tclMsgDefaultDatasetIdStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u32DatasetId == rfoCmp.u32DatasetId);
   return bResult;
}

fi_tclInContext& dap_rnwfi_tclMsgDefaultDatasetIdStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> u32DatasetId;
   return oIn;
}

fi_tclOutContext& dap_rnwfi_tclMsgDefaultDatasetIdStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u32DatasetId;
   return oOut;
}

