#ifndef __DAP_RESINFFIDEBUGVISITOR_H__
#define __DAP_RESINFFIDEBUGVISITOR_H__

class MY_DECL dap_resinffi_tclPrintVisitor : public dap_resinffi_tclVisitorBase {

private:
   /* default constructor */ dap_resinffi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   dap_resinffi_tclPrintVisitor(fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(dap_resinffi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DapPrioritaet(fi_tcl_e8_DapPrioritaet& o_e8_DapPrioritaet);
   virtual tVoid vVisit_u32_DapContainerSize(fi_tcl_u32_DapContainerSize& o_u32_DapContainerSize);
   virtual tVoid vVisit_e8_DapDataAvailable(fi_tcl_e8_DapDataAvailable& o_e8_DapDataAvailable);
   virtual tVoid vVisit_e8_DapDataType(fi_tcl_e8_DapDataType& o_e8_DapDataType);
   virtual tVoid vVisit_e8_DapMediaType(fi_tcl_e8_DapMediaType& o_e8_DapMediaType);
   virtual tVoid vVisit_e8_DapDeviceError(fi_tcl_e8_DapDeviceError& o_e8_DapDeviceError);
   virtual tVoid vVisit_e8_DapAccessMode(fi_tcl_e8_DapAccessMode& o_e8_DapAccessMode);
   virtual tVoid vVisit_e8_DapWriteProt(fi_tcl_e8_DapWriteProt& o_e8_DapWriteProt);
   virtual tVoid vVisit_e16_DapFileType(fi_tcl_e16_DapFileType& o_e16_DapFileType);
   virtual tVoid vVisit_e16_DapNumberRepr(fi_tcl_e16_DapNumberRepr& o_e16_DapNumberRepr);
   virtual tBool bDoExpand_DapDeviceInfo(dap_resinffi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DapFileType(dap_resinffi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DapCodePageDescr(dap_resinffi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DapLanguageDescr(dap_resinffi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DapVirtualMediaInfo(dap_resinffi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DapMediaInfo(dap_resinffi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DapDataInfo(dap_resinffi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DapDataSetInfo(dap_resinffi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DapDefaultControl(dap_resinffi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DapRegionMetaInfo(dap_resinffi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DapProfileMetaInfo(dap_resinffi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DapRegionDescription(dap_resinffi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   fi_tclOutput* poOutput;
};


class MY_DECL dap_resinffi_tclRandomInitVisitor : public dap_resinffi_tclVisitorBase {
public:

   dap_resinffi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_e8_DapPrioritaet(fi_tcl_e8_DapPrioritaet& o_e8_DapPrioritaet);
   virtual tVoid vVisit_u32_DapContainerSize(fi_tcl_u32_DapContainerSize& o_u32_DapContainerSize);
   virtual tVoid vVisit_e8_DapDataAvailable(fi_tcl_e8_DapDataAvailable& o_e8_DapDataAvailable);
   virtual tVoid vVisit_e8_DapDataType(fi_tcl_e8_DapDataType& o_e8_DapDataType);
   virtual tVoid vVisit_e8_DapMediaType(fi_tcl_e8_DapMediaType& o_e8_DapMediaType);
   virtual tVoid vVisit_e8_DapDeviceError(fi_tcl_e8_DapDeviceError& o_e8_DapDeviceError);
   virtual tVoid vVisit_e8_DapAccessMode(fi_tcl_e8_DapAccessMode& o_e8_DapAccessMode);
   virtual tVoid vVisit_e8_DapWriteProt(fi_tcl_e8_DapWriteProt& o_e8_DapWriteProt);
   virtual tVoid vVisit_e16_DapFileType(fi_tcl_e16_DapFileType& o_e16_DapFileType);
   virtual tVoid vVisit_e16_DapNumberRepr(fi_tcl_e16_DapNumberRepr& o_e16_DapNumberRepr);
	tU32 u32ListSize;
};

#endif
