/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef DAP_RAWDATAFITYPES_HEADER
#define DAP_RAWDATAFITYPES_HEADER

// #include <vector>
// 


class dap_rawdatafi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class dap_rawdatafi_tclMsgdap_rd_filesizeMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rawdatafi_tclMsgdap_rd_filesizeMethodStart():u8Priority(),u32DataSize(0),u8OrderType(),u32MediaId(0),szPath(),szFilename() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rawdatafi_tclMsgdap_rd_filesizeMethodStart& operator=(const dap_rawdatafi_tclMsgdap_rd_filesizeMethodStart& coRef);
   dap_rawdatafi_tclMsgdap_rd_filesizeMethodStart(const dap_rawdatafi_tclMsgdap_rd_filesizeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   tU32 u32DataSize;
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 u32MediaId;
   fi_tclString szPath;
   fi_tclString szFilename;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rawdatafi_tclMsgdap_rd_filesizeMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rawdatafi_tclToken::EN_MSG_DAP_RD_FILESIZEMETHODSTART;}
};

class dap_rawdatafi_tclMsgdap_rd_filesizeMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rawdatafi_tclMsgdap_rd_filesizeMethodResult():u8Priority(),u32DataSize(0),u32MediaId(0),szPath(),szFilename(),u32Filesize(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rawdatafi_tclMsgdap_rd_filesizeMethodResult& operator=(const dap_rawdatafi_tclMsgdap_rd_filesizeMethodResult& coRef);
   dap_rawdatafi_tclMsgdap_rd_filesizeMethodResult(const dap_rawdatafi_tclMsgdap_rd_filesizeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   tU32 u32DataSize;
   tU32 u32MediaId;
   fi_tclString szPath;
   fi_tclString szFilename;
   tU32 u32Filesize;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rawdatafi_tclMsgdap_rd_filesizeMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rawdatafi_tclToken::EN_MSG_DAP_RD_FILESIZEMETHODRESULT;}
};

class dap_rawdatafi_tclMsgdap_rd_readblockMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rawdatafi_tclMsgdap_rd_readblockMethodStart():u8Priority(),u32DataSize(0),u8OrderType(),u32MediaId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rawdatafi_tclMsgdap_rd_readblockMethodStart& operator=(const dap_rawdatafi_tclMsgdap_rd_readblockMethodStart& coRef);
   dap_rawdatafi_tclMsgdap_rd_readblockMethodStart(const dap_rawdatafi_tclMsgdap_rd_readblockMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   tU32 u32DataSize;
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 u32MediaId;
   std::vector<fi_tcl_DataBlockStartInfo, std::allocator<fi_tcl_DataBlockStartInfo> > aoDataBlockInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rawdatafi_tclMsgdap_rd_readblockMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rawdatafi_tclToken::EN_MSG_DAP_RD_READBLOCKMETHODSTART;}
};

class dap_rawdatafi_tclMsgdap_rd_readblockMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rawdatafi_tclMsgdap_rd_readblockMethodResult():u8Priority(),u32DataSize(0),u32MediaId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rawdatafi_tclMsgdap_rd_readblockMethodResult& operator=(const dap_rawdatafi_tclMsgdap_rd_readblockMethodResult& coRef);
   dap_rawdatafi_tclMsgdap_rd_readblockMethodResult(const dap_rawdatafi_tclMsgdap_rd_readblockMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   tU32 u32DataSize;
   tU32 u32MediaId;
   std::vector<fi_tcl_DataBlockResultInfo, std::allocator<fi_tcl_DataBlockResultInfo> > aoDataBlockInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rawdatafi_tclMsgdap_rd_readblockMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rawdatafi_tclToken::EN_MSG_DAP_RD_READBLOCKMETHODRESULT;}
};

class dap_rawdatafi_tclMsgdap_rd_directoryMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rawdatafi_tclMsgdap_rd_directoryMethodStart():u8Priority(),u32DataSize(0),u8OrderType(),u32MediaId(0),szPath(),szMask(),u32MaxResultSize(0),u16FirstEntry(0),szSharedMemory() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rawdatafi_tclMsgdap_rd_directoryMethodStart& operator=(const dap_rawdatafi_tclMsgdap_rd_directoryMethodStart& coRef);
   dap_rawdatafi_tclMsgdap_rd_directoryMethodStart(const dap_rawdatafi_tclMsgdap_rd_directoryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   tU32 u32DataSize;
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 u32MediaId;
   fi_tclString szPath;
   fi_tclString szMask;
   tU32 u32MaxResultSize;
   tU16 u16FirstEntry;
   fi_tclString szSharedMemory;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rawdatafi_tclMsgdap_rd_directoryMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rawdatafi_tclToken::EN_MSG_DAP_RD_DIRECTORYMETHODSTART;}
};

class dap_rawdatafi_tclMsgdap_rd_directoryMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rawdatafi_tclMsgdap_rd_directoryMethodResult():u8Priority(),u32DataSize(0),u32MediaId(0),szPath(),szMask(),u32RealResultSize(0),u16LastEntry(0),bComplete(0),szSharedMemory() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rawdatafi_tclMsgdap_rd_directoryMethodResult& operator=(const dap_rawdatafi_tclMsgdap_rd_directoryMethodResult& coRef);
   dap_rawdatafi_tclMsgdap_rd_directoryMethodResult(const dap_rawdatafi_tclMsgdap_rd_directoryMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   tU32 u32DataSize;
   tU32 u32MediaId;
   fi_tclString szPath;
   fi_tclString szMask;
   tU32 u32RealResultSize;
   tU16 u16LastEntry;
   tBool bComplete;
   fi_tclString szSharedMemory;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rawdatafi_tclMsgdap_rd_directoryMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rawdatafi_tclToken::EN_MSG_DAP_RD_DIRECTORYMETHODRESULT;}
};

class dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodStart():u8Priority(),u32DataSize(0),u8OrderType(),u32MediaId(0),szDevice() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodStart& operator=(const dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodStart& coRef);
   dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodStart(const dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   tU32 u32DataSize;
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 u32MediaId;
   fi_tclString szDevice;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rawdatafi_tclToken::EN_MSG_DAP_RD_MEDIASPACEMETHODSTART;}
};

class dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodResult():u8Priority(),u32DataSize(0),u32MediaId(0),szDevice(),u32MediaSpaceLow(0),u32MediaSpaceHigh(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodResult& operator=(const dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodResult& coRef);
   dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodResult(const dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   tU32 u32DataSize;
   tU32 u32MediaId;
   fi_tclString szDevice;
   tU32 u32MediaSpaceLow;
   tU32 u32MediaSpaceHigh;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rawdatafi_tclToken::EN_MSG_DAP_RD_MEDIASPACEMETHODRESULT;}
};

class dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodStart():u8Priority(),u32DataSize(0),u8OrderType(),u32MediaId(0),szDevice() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodStart& operator=(const dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodStart& coRef);
   dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodStart(const dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   tU32 u32DataSize;
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 u32MediaId;
   fi_tclString szDevice;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rawdatafi_tclToken::EN_MSG_DAP_RD_FREEMEDIASPACEMETHODSTART;}
};

class dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodResult():u8Priority(),u32DataSize(0),u32MediaId(0),szDevice(),u32MediaSpaceLow(0),u32MediaSpaceHigh(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodResult& operator=(const dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodResult& coRef);
   dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodResult(const dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapPrioritaet u8Priority;
   tU32 u32DataSize;
   tU32 u32MediaId;
   fi_tclString szDevice;
   tU32 u32MediaSpaceLow;
   tU32 u32MediaSpaceHigh;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_rawdatafi_tclToken::EN_MSG_DAP_RD_FREEMEDIASPACEMETHODRESULT;}
};


#endif
