/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rawdatafi_tclMsgdap_rd_filesizeMethodStart::dap_rawdatafi_tclMsgdap_rd_filesizeMethodStart(const dap_rawdatafi_tclMsgdap_rd_filesizeMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u8OrderType = coRef.u8OrderType;
   u32MediaId = coRef.u32MediaId;
   szPath = coRef.szPath;
   szFilename = coRef.szFilename;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rawdatafi_tclMsgdap_rd_filesizeMethodStart& dap_rawdatafi_tclMsgdap_rd_filesizeMethodStart::operator=(const dap_rawdatafi_tclMsgdap_rd_filesizeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u8OrderType = coRef.u8OrderType;
   u32MediaId = coRef.u32MediaId;
   szPath = coRef.szPath;
   szFilename = coRef.szFilename;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rawdatafi_tclMsgdap_rd_filesizeMethodStart::u16GetServiceID() const {return DAP_RAWDATAFI_C_U16_SERVICE_ID;}
tU16 dap_rawdatafi_tclMsgdap_rd_filesizeMethodStart::u16GetFunctionID() const {return DAP_RAWDATAFI_C_U16_DAP_RD_FILESIZE;}
tU8 dap_rawdatafi_tclMsgdap_rd_filesizeMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_rawdatafi_tclMsgdap_rd_filesizeMethodStart::vDestroy()
{
   szPath.vDestroy();
   szFilename.vDestroy();
}

tU32 dap_rawdatafi_tclMsgdap_rd_filesizeMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+9+szPath.u32GetSize(u16MajorVersion)+szFilename.u32GetSize(u16MajorVersion);
}

tBool dap_rawdatafi_tclMsgdap_rd_filesizeMethodStart::operator==(const dap_rawdatafi_tclMsgdap_rd_filesizeMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (u32MediaId == rfoCmp.u32MediaId);
      bResult = bResult && (szPath == rfoCmp.szPath);
      bResult = bResult && (szFilename == rfoCmp.szFilename);
   return bResult;
}

fi_tclInContext& dap_rawdatafi_tclMsgdap_rd_filesizeMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   if (3 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> u32MediaId;
   oIn >> szPath;
   oIn >> szFilename;
   return oIn;
}

fi_tclOutContext& dap_rawdatafi_tclMsgdap_rd_filesizeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << u32MediaId;
   oOut << szPath;
   oOut << szFilename;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rawdatafi_tclMsgdap_rd_filesizeMethodResult::dap_rawdatafi_tclMsgdap_rd_filesizeMethodResult(const dap_rawdatafi_tclMsgdap_rd_filesizeMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u32MediaId = coRef.u32MediaId;
   szPath = coRef.szPath;
   szFilename = coRef.szFilename;
   u32Filesize = coRef.u32Filesize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rawdatafi_tclMsgdap_rd_filesizeMethodResult& dap_rawdatafi_tclMsgdap_rd_filesizeMethodResult::operator=(const dap_rawdatafi_tclMsgdap_rd_filesizeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u32MediaId = coRef.u32MediaId;
   szPath = coRef.szPath;
   szFilename = coRef.szFilename;
   u32Filesize = coRef.u32Filesize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rawdatafi_tclMsgdap_rd_filesizeMethodResult::u16GetServiceID() const {return DAP_RAWDATAFI_C_U16_SERVICE_ID;}
tU16 dap_rawdatafi_tclMsgdap_rd_filesizeMethodResult::u16GetFunctionID() const {return DAP_RAWDATAFI_C_U16_DAP_RD_FILESIZE;}
tU8 dap_rawdatafi_tclMsgdap_rd_filesizeMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_rawdatafi_tclMsgdap_rd_filesizeMethodResult::vDestroy()
{
   szPath.vDestroy();
   szFilename.vDestroy();
}

tU32 dap_rawdatafi_tclMsgdap_rd_filesizeMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 13+szPath.u32GetSize(u16MajorVersion)+szFilename.u32GetSize(u16MajorVersion);
}

tBool dap_rawdatafi_tclMsgdap_rd_filesizeMethodResult::operator==(const dap_rawdatafi_tclMsgdap_rd_filesizeMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (u32MediaId == rfoCmp.u32MediaId);
      bResult = bResult && (szPath == rfoCmp.szPath);
      bResult = bResult && (szFilename == rfoCmp.szFilename);
      bResult = bResult && (u32Filesize == rfoCmp.u32Filesize);
   return bResult;
}

fi_tclInContext& dap_rawdatafi_tclMsgdap_rd_filesizeMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> u32MediaId;
   oIn >> szPath;
   oIn >> szFilename;
   oIn >> u32Filesize;
   return oIn;
}

fi_tclOutContext& dap_rawdatafi_tclMsgdap_rd_filesizeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << u32MediaId;
   oOut << szPath;
   oOut << szFilename;
   oOut << u32Filesize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rawdatafi_tclMsgdap_rd_readblockMethodStart::dap_rawdatafi_tclMsgdap_rd_readblockMethodStart(const dap_rawdatafi_tclMsgdap_rd_readblockMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u8OrderType = coRef.u8OrderType;
   u32MediaId = coRef.u32MediaId;
   aoDataBlockInfo = coRef.aoDataBlockInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rawdatafi_tclMsgdap_rd_readblockMethodStart& dap_rawdatafi_tclMsgdap_rd_readblockMethodStart::operator=(const dap_rawdatafi_tclMsgdap_rd_readblockMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u8OrderType = coRef.u8OrderType;
   u32MediaId = coRef.u32MediaId;
   aoDataBlockInfo = coRef.aoDataBlockInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rawdatafi_tclMsgdap_rd_readblockMethodStart::u16GetServiceID() const {return DAP_RAWDATAFI_C_U16_SERVICE_ID;}
tU16 dap_rawdatafi_tclMsgdap_rd_readblockMethodStart::u16GetFunctionID() const {return DAP_RAWDATAFI_C_U16_DAP_RD_READBLOCK;}
tU8 dap_rawdatafi_tclMsgdap_rd_readblockMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_rawdatafi_tclMsgdap_rd_readblockMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < aoDataBlockInfo.size(); ++u32Idx)
         aoDataBlockInfo[u32Idx].vDestroy();
   }
   aoDataBlockInfo.clear();
}

tU32 dap_rawdatafi_tclMsgdap_rd_readblockMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < aoDataBlockInfo.size(); ++u32ListIdx)
      u32DynamicSize += aoDataBlockInfo[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+13;
}

tBool dap_rawdatafi_tclMsgdap_rd_readblockMethodStart::operator==(const dap_rawdatafi_tclMsgdap_rd_readblockMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (u32MediaId == rfoCmp.u32MediaId);
      bResult = bResult && (aoDataBlockInfo.size() == rfoCmp.aoDataBlockInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoDataBlockInfo.size()); ++u32Idx)
            bResult = bResult && (aoDataBlockInfo[u32Idx] == rfoCmp.aoDataBlockInfo[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_rawdatafi_tclMsgdap_rd_readblockMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   if (3 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> u32MediaId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoDataBlockInfo.size(); ++u32Idx)
      {
         aoDataBlockInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoDataBlockInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoDataBlockInfo[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_rawdatafi_tclMsgdap_rd_readblockMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << u32MediaId;
   oOut << (tU32)aoDataBlockInfo.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoDataBlockInfo.size(); ++u32Idx)
         oOut << aoDataBlockInfo[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rawdatafi_tclMsgdap_rd_readblockMethodResult::dap_rawdatafi_tclMsgdap_rd_readblockMethodResult(const dap_rawdatafi_tclMsgdap_rd_readblockMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u32MediaId = coRef.u32MediaId;
   aoDataBlockInfo = coRef.aoDataBlockInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rawdatafi_tclMsgdap_rd_readblockMethodResult& dap_rawdatafi_tclMsgdap_rd_readblockMethodResult::operator=(const dap_rawdatafi_tclMsgdap_rd_readblockMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u32MediaId = coRef.u32MediaId;
   aoDataBlockInfo = coRef.aoDataBlockInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rawdatafi_tclMsgdap_rd_readblockMethodResult::u16GetServiceID() const {return DAP_RAWDATAFI_C_U16_SERVICE_ID;}
tU16 dap_rawdatafi_tclMsgdap_rd_readblockMethodResult::u16GetFunctionID() const {return DAP_RAWDATAFI_C_U16_DAP_RD_READBLOCK;}
tU8 dap_rawdatafi_tclMsgdap_rd_readblockMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_rawdatafi_tclMsgdap_rd_readblockMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < aoDataBlockInfo.size(); ++u32Idx)
         aoDataBlockInfo[u32Idx].vDestroy();
   }
   aoDataBlockInfo.clear();
}

tU32 dap_rawdatafi_tclMsgdap_rd_readblockMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < aoDataBlockInfo.size(); ++u32ListIdx)
      u32DynamicSize += aoDataBlockInfo[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+13;
}

tBool dap_rawdatafi_tclMsgdap_rd_readblockMethodResult::operator==(const dap_rawdatafi_tclMsgdap_rd_readblockMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (u32MediaId == rfoCmp.u32MediaId);
      bResult = bResult && (aoDataBlockInfo.size() == rfoCmp.aoDataBlockInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoDataBlockInfo.size()); ++u32Idx)
            bResult = bResult && (aoDataBlockInfo[u32Idx] == rfoCmp.aoDataBlockInfo[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_rawdatafi_tclMsgdap_rd_readblockMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> u32MediaId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoDataBlockInfo.size(); ++u32Idx)
      {
         aoDataBlockInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoDataBlockInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoDataBlockInfo[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_rawdatafi_tclMsgdap_rd_readblockMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << u32MediaId;
   oOut << (tU32)aoDataBlockInfo.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoDataBlockInfo.size(); ++u32Idx)
         oOut << aoDataBlockInfo[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rawdatafi_tclMsgdap_rd_directoryMethodStart::dap_rawdatafi_tclMsgdap_rd_directoryMethodStart(const dap_rawdatafi_tclMsgdap_rd_directoryMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u8OrderType = coRef.u8OrderType;
   u32MediaId = coRef.u32MediaId;
   szPath = coRef.szPath;
   szMask = coRef.szMask;
   u32MaxResultSize = coRef.u32MaxResultSize;
   u16FirstEntry = coRef.u16FirstEntry;
   szSharedMemory = coRef.szSharedMemory;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rawdatafi_tclMsgdap_rd_directoryMethodStart& dap_rawdatafi_tclMsgdap_rd_directoryMethodStart::operator=(const dap_rawdatafi_tclMsgdap_rd_directoryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u8OrderType = coRef.u8OrderType;
   u32MediaId = coRef.u32MediaId;
   szPath = coRef.szPath;
   szMask = coRef.szMask;
   u32MaxResultSize = coRef.u32MaxResultSize;
   u16FirstEntry = coRef.u16FirstEntry;
   szSharedMemory = coRef.szSharedMemory;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rawdatafi_tclMsgdap_rd_directoryMethodStart::u16GetServiceID() const {return DAP_RAWDATAFI_C_U16_SERVICE_ID;}
tU16 dap_rawdatafi_tclMsgdap_rd_directoryMethodStart::u16GetFunctionID() const {return DAP_RAWDATAFI_C_U16_DAP_RD_DIRECTORY;}
tU8 dap_rawdatafi_tclMsgdap_rd_directoryMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_rawdatafi_tclMsgdap_rd_directoryMethodStart::vDestroy()
{
   szPath.vDestroy();
   szMask.vDestroy();
   szSharedMemory.vDestroy();
}

tU32 dap_rawdatafi_tclMsgdap_rd_directoryMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+15+szPath.u32GetSize(u16MajorVersion)+szMask.u32GetSize(u16MajorVersion)+szSharedMemory.u32GetSize(u16MajorVersion);
}

tBool dap_rawdatafi_tclMsgdap_rd_directoryMethodStart::operator==(const dap_rawdatafi_tclMsgdap_rd_directoryMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (u32MediaId == rfoCmp.u32MediaId);
      bResult = bResult && (szPath == rfoCmp.szPath);
      bResult = bResult && (szMask == rfoCmp.szMask);
      bResult = bResult && (u32MaxResultSize == rfoCmp.u32MaxResultSize);
      bResult = bResult && (u16FirstEntry == rfoCmp.u16FirstEntry);
      bResult = bResult && (szSharedMemory == rfoCmp.szSharedMemory);
   return bResult;
}

fi_tclInContext& dap_rawdatafi_tclMsgdap_rd_directoryMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   if (3 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> u32MediaId;
   oIn >> szPath;
   oIn >> szMask;
   oIn >> u32MaxResultSize;
   oIn >> u16FirstEntry;
   oIn >> szSharedMemory;
   return oIn;
}

fi_tclOutContext& dap_rawdatafi_tclMsgdap_rd_directoryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << u32MediaId;
   oOut << szPath;
   oOut << szMask;
   oOut << u32MaxResultSize;
   oOut << u16FirstEntry;
   oOut << szSharedMemory;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rawdatafi_tclMsgdap_rd_directoryMethodResult::dap_rawdatafi_tclMsgdap_rd_directoryMethodResult(const dap_rawdatafi_tclMsgdap_rd_directoryMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u32MediaId = coRef.u32MediaId;
   szPath = coRef.szPath;
   szMask = coRef.szMask;
   u32RealResultSize = coRef.u32RealResultSize;
   u16LastEntry = coRef.u16LastEntry;
   bComplete = coRef.bComplete;
   szSharedMemory = coRef.szSharedMemory;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rawdatafi_tclMsgdap_rd_directoryMethodResult& dap_rawdatafi_tclMsgdap_rd_directoryMethodResult::operator=(const dap_rawdatafi_tclMsgdap_rd_directoryMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u32MediaId = coRef.u32MediaId;
   szPath = coRef.szPath;
   szMask = coRef.szMask;
   u32RealResultSize = coRef.u32RealResultSize;
   u16LastEntry = coRef.u16LastEntry;
   bComplete = coRef.bComplete;
   szSharedMemory = coRef.szSharedMemory;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rawdatafi_tclMsgdap_rd_directoryMethodResult::u16GetServiceID() const {return DAP_RAWDATAFI_C_U16_SERVICE_ID;}
tU16 dap_rawdatafi_tclMsgdap_rd_directoryMethodResult::u16GetFunctionID() const {return DAP_RAWDATAFI_C_U16_DAP_RD_DIRECTORY;}
tU8 dap_rawdatafi_tclMsgdap_rd_directoryMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_rawdatafi_tclMsgdap_rd_directoryMethodResult::vDestroy()
{
   szPath.vDestroy();
   szMask.vDestroy();
   szSharedMemory.vDestroy();
}

tU32 dap_rawdatafi_tclMsgdap_rd_directoryMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 16+szPath.u32GetSize(u16MajorVersion)+szMask.u32GetSize(u16MajorVersion)+szSharedMemory.u32GetSize(u16MajorVersion);
}

tBool dap_rawdatafi_tclMsgdap_rd_directoryMethodResult::operator==(const dap_rawdatafi_tclMsgdap_rd_directoryMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (u32MediaId == rfoCmp.u32MediaId);
      bResult = bResult && (szPath == rfoCmp.szPath);
      bResult = bResult && (szMask == rfoCmp.szMask);
      bResult = bResult && (u32RealResultSize == rfoCmp.u32RealResultSize);
      bResult = bResult && (u16LastEntry == rfoCmp.u16LastEntry);
      bResult = bResult && (bComplete == rfoCmp.bComplete);
      bResult = bResult && (szSharedMemory == rfoCmp.szSharedMemory);
   return bResult;
}

fi_tclInContext& dap_rawdatafi_tclMsgdap_rd_directoryMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> u32MediaId;
   oIn >> szPath;
   oIn >> szMask;
   oIn >> u32RealResultSize;
   oIn >> u16LastEntry;
   oIn >> bComplete;
   oIn >> szSharedMemory;
   return oIn;
}

fi_tclOutContext& dap_rawdatafi_tclMsgdap_rd_directoryMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << u32MediaId;
   oOut << szPath;
   oOut << szMask;
   oOut << u32RealResultSize;
   oOut << u16LastEntry;
   oOut << bComplete;
   oOut << szSharedMemory;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodStart::dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodStart(const dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u8OrderType = coRef.u8OrderType;
   u32MediaId = coRef.u32MediaId;
   szDevice = coRef.szDevice;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodStart& dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodStart::operator=(const dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u8OrderType = coRef.u8OrderType;
   u32MediaId = coRef.u32MediaId;
   szDevice = coRef.szDevice;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodStart::u16GetServiceID() const {return DAP_RAWDATAFI_C_U16_SERVICE_ID;}
tU16 dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodStart::u16GetFunctionID() const {return DAP_RAWDATAFI_C_U16_DAP_RD_MEDIASPACE;}
tU8 dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodStart::vDestroy()
{
   szDevice.vDestroy();
}

tU32 dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+9+szDevice.u32GetSize(u16MajorVersion);
}

tBool dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodStart::operator==(const dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (u32MediaId == rfoCmp.u32MediaId);
      bResult = bResult && (szDevice == rfoCmp.szDevice);
   return bResult;
}

fi_tclInContext& dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   if (3 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> u32MediaId;
   oIn >> szDevice;
   return oIn;
}

fi_tclOutContext& dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << u32MediaId;
   oOut << szDevice;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodResult::dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodResult(const dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u32MediaId = coRef.u32MediaId;
   szDevice = coRef.szDevice;
   u32MediaSpaceLow = coRef.u32MediaSpaceLow;
   u32MediaSpaceHigh = coRef.u32MediaSpaceHigh;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodResult& dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodResult::operator=(const dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u32MediaId = coRef.u32MediaId;
   szDevice = coRef.szDevice;
   u32MediaSpaceLow = coRef.u32MediaSpaceLow;
   u32MediaSpaceHigh = coRef.u32MediaSpaceHigh;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodResult::u16GetServiceID() const {return DAP_RAWDATAFI_C_U16_SERVICE_ID;}
tU16 dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodResult::u16GetFunctionID() const {return DAP_RAWDATAFI_C_U16_DAP_RD_MEDIASPACE;}
tU8 dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodResult::vDestroy()
{
   szDevice.vDestroy();
}

tU32 dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 17+szDevice.u32GetSize(u16MajorVersion);
}

tBool dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodResult::operator==(const dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (u32MediaId == rfoCmp.u32MediaId);
      bResult = bResult && (szDevice == rfoCmp.szDevice);
      bResult = bResult && (u32MediaSpaceLow == rfoCmp.u32MediaSpaceLow);
      bResult = bResult && (u32MediaSpaceHigh == rfoCmp.u32MediaSpaceHigh);
   return bResult;
}

fi_tclInContext& dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> u32MediaId;
   oIn >> szDevice;
   oIn >> u32MediaSpaceLow;
   oIn >> u32MediaSpaceHigh;
   return oIn;
}

fi_tclOutContext& dap_rawdatafi_tclMsgdap_rd_mediaspaceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << u32MediaId;
   oOut << szDevice;
   oOut << u32MediaSpaceLow;
   oOut << u32MediaSpaceHigh;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodStart::dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodStart(const dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u8OrderType = coRef.u8OrderType;
   u32MediaId = coRef.u32MediaId;
   szDevice = coRef.szDevice;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodStart& dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodStart::operator=(const dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u8OrderType = coRef.u8OrderType;
   u32MediaId = coRef.u32MediaId;
   szDevice = coRef.szDevice;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodStart::u16GetServiceID() const {return DAP_RAWDATAFI_C_U16_SERVICE_ID;}
tU16 dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodStart::u16GetFunctionID() const {return DAP_RAWDATAFI_C_U16_DAP_RD_FREEMEDIASPACE;}
tU8 dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodStart::vDestroy()
{
   szDevice.vDestroy();
}

tU32 dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+9+szDevice.u32GetSize(u16MajorVersion);
}

tBool dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodStart::operator==(const dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (u32MediaId == rfoCmp.u32MediaId);
      bResult = bResult && (szDevice == rfoCmp.szDevice);
   return bResult;
}

fi_tclInContext& dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   if (3 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> u32MediaId;
   oIn >> szDevice;
   return oIn;
}

fi_tclOutContext& dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   if (3 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << u32MediaId;
   oOut << szDevice;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodResult::dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodResult(const dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u32MediaId = coRef.u32MediaId;
   szDevice = coRef.szDevice;
   u32MediaSpaceLow = coRef.u32MediaSpaceLow;
   u32MediaSpaceHigh = coRef.u32MediaSpaceHigh;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodResult& dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodResult::operator=(const dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8Priority = coRef.u8Priority;
   u32DataSize = coRef.u32DataSize;
   u32MediaId = coRef.u32MediaId;
   szDevice = coRef.szDevice;
   u32MediaSpaceLow = coRef.u32MediaSpaceLow;
   u32MediaSpaceHigh = coRef.u32MediaSpaceHigh;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodResult::u16GetServiceID() const {return DAP_RAWDATAFI_C_U16_SERVICE_ID;}
tU16 dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodResult::u16GetFunctionID() const {return DAP_RAWDATAFI_C_U16_DAP_RD_FREEMEDIASPACE;}
tU8 dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodResult::vDestroy()
{
   szDevice.vDestroy();
}

tU32 dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 17+szDevice.u32GetSize(u16MajorVersion);
}

tBool dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodResult::operator==(const dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8Priority == rfoCmp.u8Priority);
      bResult = bResult && (u32DataSize == rfoCmp.u32DataSize);
      bResult = bResult && (u32MediaId == rfoCmp.u32MediaId);
      bResult = bResult && (szDevice == rfoCmp.szDevice);
      bResult = bResult && (u32MediaSpaceLow == rfoCmp.u32MediaSpaceLow);
      bResult = bResult && (u32MediaSpaceHigh == rfoCmp.u32MediaSpaceHigh);
   return bResult;
}

fi_tclInContext& dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> u8Priority;
   oIn >> u32DataSize;
   oIn >> u32MediaId;
   oIn >> szDevice;
   oIn >> u32MediaSpaceLow;
   oIn >> u32MediaSpaceHigh;
   return oIn;
}

fi_tclOutContext& dap_rawdatafi_tclMsgdap_rd_freemediaspaceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8Priority;
   oOut << u32DataSize;
   oOut << u32MediaId;
   oOut << szDevice;
   oOut << u32MediaSpaceLow;
   oOut << u32MediaSpaceHigh;
   return oOut;
}

