/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef DAP_POIFITYPES_HEADER
#define DAP_POIFITYPES_HEADER

// #include <vector>
// 


class dap_poifi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class dap_poifi_tclMsgGetPOIDataByOutlineMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgGetPOIDataByOutlineMethodStart():OrderType(),UILanguage(),POITypes() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgGetPOIDataByOutlineMethodStart& operator=(const dap_poifi_tclMsgGetPOIDataByOutlineMethodStart& coRef);
   dap_poifi_tclMsgGetPOIDataByOutlineMethodStart(const dap_poifi_tclMsgGetPOIDataByOutlineMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType OrderType;
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_b16_POIType POITypes;
   std::vector<tU16, std::allocator<tU16> > CategoryFilter;
   std::vector<fi_tcl_Outline, std::allocator<fi_tcl_Outline> > Outlines;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgGetPOIDataByOutlineMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_GETPOIDATABYOUTLINEMETHODSTART;}
};

class dap_poifi_tclMsgGetPOIDataByOutlineMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgGetPOIDataByOutlineMethodResult():UILanguage() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgGetPOIDataByOutlineMethodResult& operator=(const dap_poifi_tclMsgGetPOIDataByOutlineMethodResult& coRef);
   dap_poifi_tclMsgGetPOIDataByOutlineMethodResult(const dap_poifi_tclMsgGetPOIDataByOutlineMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   std::vector<tU32, std::allocator<tU32> > OutlineIndices;
   std::vector<tU32, std::allocator<tU32> > CountElementsPerOutline;
   std::vector<fi_tcl_UserPOIElement, std::allocator<fi_tcl_UserPOIElement> > ElementList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgGetPOIDataByOutlineMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_GETPOIDATABYOUTLINEMETHODRESULT;}
};

class dap_poifi_tclMsgGetPOIDataByOutlineMethodResultFirst : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgGetPOIDataByOutlineMethodResultFirst():UILanguage() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgGetPOIDataByOutlineMethodResultFirst& operator=(const dap_poifi_tclMsgGetPOIDataByOutlineMethodResultFirst& coRef);
   dap_poifi_tclMsgGetPOIDataByOutlineMethodResultFirst(const dap_poifi_tclMsgGetPOIDataByOutlineMethodResultFirst& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   std::vector<tU32, std::allocator<tU32> > OutlineIndices;
   std::vector<tU32, std::allocator<tU32> > CountElementsPerOutline;
   std::vector<fi_tcl_UserPOIElement, std::allocator<fi_tcl_UserPOIElement> > ElementList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgGetPOIDataByOutlineMethodResultFirst& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_GETPOIDATABYOUTLINEMETHODRESULTFIRST;}
};

class dap_poifi_tclMsgGetPOIDataByOutlineMethodResultMiddle : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgGetPOIDataByOutlineMethodResultMiddle() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgGetPOIDataByOutlineMethodResultMiddle& operator=(const dap_poifi_tclMsgGetPOIDataByOutlineMethodResultMiddle& coRef);
   dap_poifi_tclMsgGetPOIDataByOutlineMethodResultMiddle(const dap_poifi_tclMsgGetPOIDataByOutlineMethodResultMiddle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<tU32, std::allocator<tU32> > OutlineIndices;
   std::vector<tU32, std::allocator<tU32> > CountElementsPerOutline;
   std::vector<fi_tcl_UserPOIElement, std::allocator<fi_tcl_UserPOIElement> > ElementList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgGetPOIDataByOutlineMethodResultMiddle& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_GETPOIDATABYOUTLINEMETHODRESULTMIDDLE;}
};

class dap_poifi_tclMsgGetPOIDataByOutlineMethodResultLast : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgGetPOIDataByOutlineMethodResultLast() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgGetPOIDataByOutlineMethodResultLast& operator=(const dap_poifi_tclMsgGetPOIDataByOutlineMethodResultLast& coRef);
   dap_poifi_tclMsgGetPOIDataByOutlineMethodResultLast(const dap_poifi_tclMsgGetPOIDataByOutlineMethodResultLast& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<tU32, std::allocator<tU32> > OutlineIndices;
   std::vector<tU32, std::allocator<tU32> > CountElementsPerOutline;
   std::vector<fi_tcl_UserPOIElement, std::allocator<fi_tcl_UserPOIElement> > ElementList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgGetPOIDataByOutlineMethodResultLast& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_GETPOIDATABYOUTLINEMETHODRESULTLAST;}
};

class dap_poifi_tclMsgGetPOIDataByTileIDsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgGetPOIDataByTileIDsMethodStart():OrderType(),POITypes(),Handle(0),SharedMemOffset(0),SharedMemMaxSize(0),UseStreaming(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgGetPOIDataByTileIDsMethodStart& operator=(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodStart& coRef);
   dap_poifi_tclMsgGetPOIDataByTileIDsMethodStart(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType OrderType;
   fi_tcl_b16_POIType POITypes;
   std::vector<tU16, std::allocator<tU16> > CategoryFilter;
   tU16 Handle;
   tU32 SharedMemOffset;
   tU32 SharedMemMaxSize;
   tBool UseStreaming;
   std::vector<tU32, std::allocator<tU32> > TileIDs;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_GETPOIDATABYTILEIDSMETHODSTART;}
};

class dap_poifi_tclMsgGetPOIDataByTileIDsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgGetPOIDataByTileIDsMethodResult():Size(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgGetPOIDataByTileIDsMethodResult& operator=(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodResult& coRef);
   dap_poifi_tclMsgGetPOIDataByTileIDsMethodResult(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 Size;
   std::vector<fi_tcl_ResultBlocks, std::allocator<fi_tcl_ResultBlocks> > ResultBlocks;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_GETPOIDATABYTILEIDSMETHODRESULT;}
};

class dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultFirst : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultFirst():Size(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultFirst& operator=(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultFirst& coRef);
   dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultFirst(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultFirst& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 Size;
   std::vector<fi_tcl_ResultBlocks, std::allocator<fi_tcl_ResultBlocks> > ResultBlocks;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultFirst& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_GETPOIDATABYTILEIDSMETHODRESULTFIRST;}
};

class dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultMiddle : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultMiddle():Size(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultMiddle& operator=(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultMiddle& coRef);
   dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultMiddle(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultMiddle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 Size;
   std::vector<fi_tcl_ResultBlocks, std::allocator<fi_tcl_ResultBlocks> > ResultBlocks;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultMiddle& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_GETPOIDATABYTILEIDSMETHODRESULTMIDDLE;}
};

class dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultLast : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultLast():Size(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultLast& operator=(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultLast& coRef);
   dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultLast(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultLast& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 Size;
   std::vector<fi_tcl_ResultBlocks, std::allocator<fi_tcl_ResultBlocks> > ResultBlocks;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgGetPOIDataByTileIDsMethodResultLast& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_GETPOIDATABYTILEIDSMETHODRESULTLAST;}
};

class dap_poifi_tclMsgOpenFastMapChannelMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgOpenFastMapChannelMethodStart():MajorVersion(0),MinorVersion(0),ChannelName(),ChannelSize(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgOpenFastMapChannelMethodStart& operator=(const dap_poifi_tclMsgOpenFastMapChannelMethodStart& coRef);
   dap_poifi_tclMsgOpenFastMapChannelMethodStart(const dap_poifi_tclMsgOpenFastMapChannelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 MajorVersion;
   tU8 MinorVersion;
   fi_tclString ChannelName;
   tU32 ChannelSize;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgOpenFastMapChannelMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_OPENFASTMAPCHANNELMETHODSTART;}
};

class dap_poifi_tclMsgOpenFastMapChannelMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgOpenFastMapChannelMethodResult():Handle(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgOpenFastMapChannelMethodResult& operator=(const dap_poifi_tclMsgOpenFastMapChannelMethodResult& coRef);
   dap_poifi_tclMsgOpenFastMapChannelMethodResult(const dap_poifi_tclMsgOpenFastMapChannelMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 Handle;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgOpenFastMapChannelMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_OPENFASTMAPCHANNELMETHODRESULT;}
};

class dap_poifi_tclMsgCloseFastMapChannelMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgCloseFastMapChannelMethodStart():Handle(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgCloseFastMapChannelMethodStart& operator=(const dap_poifi_tclMsgCloseFastMapChannelMethodStart& coRef);
   dap_poifi_tclMsgCloseFastMapChannelMethodStart(const dap_poifi_tclMsgCloseFastMapChannelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 Handle;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgCloseFastMapChannelMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_CLOSEFASTMAPCHANNELMETHODSTART;}
};

class dap_poifi_tclMsgCloseFastMapChannelMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgCloseFastMapChannelMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgCloseFastMapChannelMethodResult& operator=(const dap_poifi_tclMsgCloseFastMapChannelMethodResult& coRef);
   dap_poifi_tclMsgCloseFastMapChannelMethodResult(const dap_poifi_tclMsgCloseFastMapChannelMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgCloseFastMapChannelMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_CLOSEFASTMAPCHANNELMETHODRESULT;}
};

class dap_poifi_tclMsgAddPOIsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgAddPOIsMethodStart():POIType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgAddPOIsMethodStart& operator=(const dap_poifi_tclMsgAddPOIsMethodStart& coRef);
   dap_poifi_tclMsgAddPOIsMethodStart(const dap_poifi_tclMsgAddPOIsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_POIType POIType;
   std::vector<fi_tcl_UserPOIElement, std::allocator<fi_tcl_UserPOIElement> > POIs;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgAddPOIsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_ADDPOISMETHODSTART;}
};

class dap_poifi_tclMsgAddPOIsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgAddPOIsMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgAddPOIsMethodResult& operator=(const dap_poifi_tclMsgAddPOIsMethodResult& coRef);
   dap_poifi_tclMsgAddPOIsMethodResult(const dap_poifi_tclMsgAddPOIsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<tU32, std::allocator<tU32> > UniqueIDs;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgAddPOIsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_ADDPOISMETHODRESULT;}
};

class dap_poifi_tclMsgDeletePOIsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgDeletePOIsMethodStart():POIType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgDeletePOIsMethodStart& operator=(const dap_poifi_tclMsgDeletePOIsMethodStart& coRef);
   dap_poifi_tclMsgDeletePOIsMethodStart(const dap_poifi_tclMsgDeletePOIsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_POIType POIType;
   std::vector<tU32, std::allocator<tU32> > UniqueIDs;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgDeletePOIsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_DELETEPOISMETHODSTART;}
};

class dap_poifi_tclMsgDeletePOIsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgDeletePOIsMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgDeletePOIsMethodResult& operator=(const dap_poifi_tclMsgDeletePOIsMethodResult& coRef);
   dap_poifi_tclMsgDeletePOIsMethodResult(const dap_poifi_tclMsgDeletePOIsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgDeletePOIsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_DELETEPOISMETHODRESULT;}
};

class dap_poifi_tclMsgDeleteAllPOIsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgDeleteAllPOIsMethodStart():POIType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgDeleteAllPOIsMethodStart& operator=(const dap_poifi_tclMsgDeleteAllPOIsMethodStart& coRef);
   dap_poifi_tclMsgDeleteAllPOIsMethodStart(const dap_poifi_tclMsgDeleteAllPOIsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b16_POIType POIType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgDeleteAllPOIsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_DELETEALLPOISMETHODSTART;}
};

class dap_poifi_tclMsgDeleteAllPOIsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgDeleteAllPOIsMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgDeleteAllPOIsMethodResult& operator=(const dap_poifi_tclMsgDeleteAllPOIsMethodResult& coRef);
   dap_poifi_tclMsgDeleteAllPOIsMethodResult(const dap_poifi_tclMsgDeleteAllPOIsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgDeleteAllPOIsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_DELETEALLPOISMETHODRESULT;}
};

class dap_poifi_tclMsgImportUPOIsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgImportUPOIsMethodStart():OrderType(),SourcePath() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgImportUPOIsMethodStart& operator=(const dap_poifi_tclMsgImportUPOIsMethodStart& coRef);
   dap_poifi_tclMsgImportUPOIsMethodStart(const dap_poifi_tclMsgImportUPOIsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType OrderType;
   fi_tclString SourcePath;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgImportUPOIsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_IMPORTUPOISMETHODSTART;}
};

class dap_poifi_tclMsgImportUPOIsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgImportUPOIsMethodResult():NumOfIgnoredFiles(0),NumOfIgnoredPOIs(0),FirstErrorFileName(),FirstErrorLineNumber(0),NumOfImportedPOIs(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgImportUPOIsMethodResult& operator=(const dap_poifi_tclMsgImportUPOIsMethodResult& coRef);
   dap_poifi_tclMsgImportUPOIsMethodResult(const dap_poifi_tclMsgImportUPOIsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 NumOfIgnoredFiles;
   tU32 NumOfIgnoredPOIs;
   fi_tclString FirstErrorFileName;
   tU32 FirstErrorLineNumber;
   tU32 NumOfImportedPOIs;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgImportUPOIsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_IMPORTUPOISMETHODRESULT;}
};

class dap_poifi_tclMsgImportUPOIsMethodAbort : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgImportUPOIsMethodAbort() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgImportUPOIsMethodAbort& operator=(const dap_poifi_tclMsgImportUPOIsMethodAbort& coRef);
   dap_poifi_tclMsgImportUPOIsMethodAbort(const dap_poifi_tclMsgImportUPOIsMethodAbort& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgImportUPOIsMethodAbort& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_IMPORTUPOISMETHODABORT;}
};

class dap_poifi_tclMsgExportUPOIsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgExportUPOIsMethodStart():OrderType(),DestPath() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgExportUPOIsMethodStart& operator=(const dap_poifi_tclMsgExportUPOIsMethodStart& coRef);
   dap_poifi_tclMsgExportUPOIsMethodStart(const dap_poifi_tclMsgExportUPOIsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType OrderType;
   fi_tclString DestPath;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgExportUPOIsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_EXPORTUPOISMETHODSTART;}
};

class dap_poifi_tclMsgExportUPOIsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgExportUPOIsMethodResult():NumOfIgnoredFiles(0),FirstErrorFileName() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgExportUPOIsMethodResult& operator=(const dap_poifi_tclMsgExportUPOIsMethodResult& coRef);
   dap_poifi_tclMsgExportUPOIsMethodResult(const dap_poifi_tclMsgExportUPOIsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 NumOfIgnoredFiles;
   fi_tclString FirstErrorFileName;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgExportUPOIsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_EXPORTUPOISMETHODRESULT;}
};

class dap_poifi_tclMsgExportUPOIsMethodAbort : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgExportUPOIsMethodAbort() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgExportUPOIsMethodAbort& operator=(const dap_poifi_tclMsgExportUPOIsMethodAbort& coRef);
   dap_poifi_tclMsgExportUPOIsMethodAbort(const dap_poifi_tclMsgExportUPOIsMethodAbort& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgExportUPOIsMethodAbort& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_EXPORTUPOISMETHODABORT;}
};

class dap_poifi_tclMsgImportPOIsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgImportPOIsMethodStart():OrderType(),SourcePath(),Dataset() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgImportPOIsMethodStart& operator=(const dap_poifi_tclMsgImportPOIsMethodStart& coRef);
   dap_poifi_tclMsgImportPOIsMethodStart(const dap_poifi_tclMsgImportPOIsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType OrderType;
   fi_tclString SourcePath;
   fi_tcl_e8_POIDataset Dataset;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgImportPOIsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_IMPORTPOISMETHODSTART;}
};

class dap_poifi_tclMsgImportPOIsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgImportPOIsMethodResult():NumOfIgnoredFiles(0),NumOfIgnoredPOIs(0),FirstErrorFileName(),FirstErrorLineNumber(0),NumOfImportedPOIs(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgImportPOIsMethodResult& operator=(const dap_poifi_tclMsgImportPOIsMethodResult& coRef);
   dap_poifi_tclMsgImportPOIsMethodResult(const dap_poifi_tclMsgImportPOIsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 NumOfIgnoredFiles;
   tU32 NumOfIgnoredPOIs;
   fi_tclString FirstErrorFileName;
   tU32 FirstErrorLineNumber;
   tU32 NumOfImportedPOIs;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgImportPOIsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_IMPORTPOISMETHODRESULT;}
};

class dap_poifi_tclMsgImportPOIsMethodAbort : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgImportPOIsMethodAbort() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgImportPOIsMethodAbort& operator=(const dap_poifi_tclMsgImportPOIsMethodAbort& coRef);
   dap_poifi_tclMsgImportPOIsMethodAbort(const dap_poifi_tclMsgImportPOIsMethodAbort& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgImportPOIsMethodAbort& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_IMPORTPOISMETHODABORT;}
};

class dap_poifi_tclMsgGetMapIdsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgGetMapIdsMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgGetMapIdsMethodStart& operator=(const dap_poifi_tclMsgGetMapIdsMethodStart& coRef);
   dap_poifi_tclMsgGetMapIdsMethodStart(const dap_poifi_tclMsgGetMapIdsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_IndexCatBrand, std::allocator<fi_tcl_IndexCatBrand> > IndexIds;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgGetMapIdsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_GETMAPIDSMETHODSTART;}
};

class dap_poifi_tclMsgGetMapIdsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgGetMapIdsMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgGetMapIdsMethodResult& operator=(const dap_poifi_tclMsgGetMapIdsMethodResult& coRef);
   dap_poifi_tclMsgGetMapIdsMethodResult(const dap_poifi_tclMsgGetMapIdsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_MapIdPair, std::allocator<fi_tcl_MapIdPair> > MapIds;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgGetMapIdsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_GETMAPIDSMETHODRESULT;}
};

class dap_poifi_tclMsgReAssignCategoryMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgReAssignCategoryMethodStart():OldSelectionPath(),NewCategory() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgReAssignCategoryMethodStart& operator=(const dap_poifi_tclMsgReAssignCategoryMethodStart& coRef);
   dap_poifi_tclMsgReAssignCategoryMethodStart(const dap_poifi_tclMsgReAssignCategoryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LocationDescription OldSelectionPath;
   fi_tcl_e16_SelectionCriterionType NewCategory;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgReAssignCategoryMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_REASSIGNCATEGORYMETHODSTART;}
};

class dap_poifi_tclMsgReAssignCategoryMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgReAssignCategoryMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgReAssignCategoryMethodResult& operator=(const dap_poifi_tclMsgReAssignCategoryMethodResult& coRef);
   dap_poifi_tclMsgReAssignCategoryMethodResult(const dap_poifi_tclMsgReAssignCategoryMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgReAssignCategoryMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_REASSIGNCATEGORYMETHODRESULT;}
};

class dap_poifi_tclMsgDeleteCategoryMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgDeleteCategoryMethodStart():SelectionPath() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgDeleteCategoryMethodStart& operator=(const dap_poifi_tclMsgDeleteCategoryMethodStart& coRef);
   dap_poifi_tclMsgDeleteCategoryMethodStart(const dap_poifi_tclMsgDeleteCategoryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_LocationDescription SelectionPath;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgDeleteCategoryMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_DELETECATEGORYMETHODSTART;}
};

class dap_poifi_tclMsgDeleteCategoryMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgDeleteCategoryMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgDeleteCategoryMethodResult& operator=(const dap_poifi_tclMsgDeleteCategoryMethodResult& coRef);
   dap_poifi_tclMsgDeleteCategoryMethodResult(const dap_poifi_tclMsgDeleteCategoryMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgDeleteCategoryMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_DELETECATEGORYMETHODRESULT;}
};

class dap_poifi_tclMsgAvailablePOITypesGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgAvailablePOITypesGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgAvailablePOITypesGet& operator=(const dap_poifi_tclMsgAvailablePOITypesGet& coRef);
   dap_poifi_tclMsgAvailablePOITypesGet(const dap_poifi_tclMsgAvailablePOITypesGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgAvailablePOITypesGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_AVAILABLEPOITYPESGET;}
};

class dap_poifi_tclMsgAvailablePOITypesUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgAvailablePOITypesUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgAvailablePOITypesUpReg& operator=(const dap_poifi_tclMsgAvailablePOITypesUpReg& coRef);
   dap_poifi_tclMsgAvailablePOITypesUpReg(const dap_poifi_tclMsgAvailablePOITypesUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgAvailablePOITypesUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_AVAILABLEPOITYPESUPREG;}
};

class dap_poifi_tclMsgAvailablePOITypesRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgAvailablePOITypesRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgAvailablePOITypesRelUpReg& operator=(const dap_poifi_tclMsgAvailablePOITypesRelUpReg& coRef);
   dap_poifi_tclMsgAvailablePOITypesRelUpReg(const dap_poifi_tclMsgAvailablePOITypesRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgAvailablePOITypesRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_AVAILABLEPOITYPESRELUPREG;}
};

class dap_poifi_tclMsgAvailablePOITypesStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgAvailablePOITypesStatus():AvailablePOITypes(),ChangedPOITypes() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgAvailablePOITypesStatus& operator=(const dap_poifi_tclMsgAvailablePOITypesStatus& coRef);
   dap_poifi_tclMsgAvailablePOITypesStatus(const dap_poifi_tclMsgAvailablePOITypesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b16_POIType AvailablePOITypes;
   fi_tcl_b16_POIType ChangedPOITypes;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgAvailablePOITypesStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_AVAILABLEPOITYPESSTATUS;}
};

class dap_poifi_tclMsgImportProgressGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgImportProgressGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgImportProgressGet& operator=(const dap_poifi_tclMsgImportProgressGet& coRef);
   dap_poifi_tclMsgImportProgressGet(const dap_poifi_tclMsgImportProgressGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgImportProgressGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_IMPORTPROGRESSGET;}
};

class dap_poifi_tclMsgImportProgressUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgImportProgressUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgImportProgressUpReg& operator=(const dap_poifi_tclMsgImportProgressUpReg& coRef);
   dap_poifi_tclMsgImportProgressUpReg(const dap_poifi_tclMsgImportProgressUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgImportProgressUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_IMPORTPROGRESSUPREG;}
};

class dap_poifi_tclMsgImportProgressRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgImportProgressRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgImportProgressRelUpReg& operator=(const dap_poifi_tclMsgImportProgressRelUpReg& coRef);
   dap_poifi_tclMsgImportProgressRelUpReg(const dap_poifi_tclMsgImportProgressRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgImportProgressRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_IMPORTPROGRESSRELUPREG;}
};

class dap_poifi_tclMsgImportProgressStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgImportProgressStatus():Progress() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgImportProgressStatus& operator=(const dap_poifi_tclMsgImportProgressStatus& coRef);
   dap_poifi_tclMsgImportProgressStatus(const dap_poifi_tclMsgImportProgressStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_u8_Percent Progress;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgImportProgressStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_IMPORTPROGRESSSTATUS;}
};

class dap_poifi_tclMsgCurrentUPOIDataSetIdGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgCurrentUPOIDataSetIdGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgCurrentUPOIDataSetIdGet& operator=(const dap_poifi_tclMsgCurrentUPOIDataSetIdGet& coRef);
   dap_poifi_tclMsgCurrentUPOIDataSetIdGet(const dap_poifi_tclMsgCurrentUPOIDataSetIdGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgCurrentUPOIDataSetIdGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_CURRENTUPOIDATASETIDGET;}
};

class dap_poifi_tclMsgCurrentUPOIDataSetIdUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgCurrentUPOIDataSetIdUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgCurrentUPOIDataSetIdUpReg& operator=(const dap_poifi_tclMsgCurrentUPOIDataSetIdUpReg& coRef);
   dap_poifi_tclMsgCurrentUPOIDataSetIdUpReg(const dap_poifi_tclMsgCurrentUPOIDataSetIdUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgCurrentUPOIDataSetIdUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_CURRENTUPOIDATASETIDUPREG;}
};

class dap_poifi_tclMsgCurrentUPOIDataSetIdRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgCurrentUPOIDataSetIdRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgCurrentUPOIDataSetIdRelUpReg& operator=(const dap_poifi_tclMsgCurrentUPOIDataSetIdRelUpReg& coRef);
   dap_poifi_tclMsgCurrentUPOIDataSetIdRelUpReg(const dap_poifi_tclMsgCurrentUPOIDataSetIdRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgCurrentUPOIDataSetIdRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_CURRENTUPOIDATASETIDRELUPREG;}
};

class dap_poifi_tclMsgCurrentUPOIDataSetIdStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_poifi_tclMsgCurrentUPOIDataSetIdStatus():DataSetId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_poifi_tclMsgCurrentUPOIDataSetIdStatus& operator=(const dap_poifi_tclMsgCurrentUPOIDataSetIdStatus& coRef);
   dap_poifi_tclMsgCurrentUPOIDataSetIdStatus(const dap_poifi_tclMsgCurrentUPOIDataSetIdStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 DataSetId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_poifi_tclMsgCurrentUPOIDataSetIdStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_poifi_tclToken::EN_MSG_CURRENTUPOIDATASETIDSTATUS;}
};


#endif
