#ifndef DAP_POIFILANGUAGE_HEADER
#define DAP_POIFILANGUAGE_HEADER

class dap_poifi_tclInContext;
class dap_poifi_tclOutContext;
class dap_poifi_tclVisitorBase;

class MY_DECL dap_poifi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  dap_poifi_tclDescription(fi_tclInContext* poIn, dap_poifi_tclVisitorBase* poVisit);
  dap_poifi_tclDescription(fi_tclOutContext* poOut, dap_poifi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(dap_poifi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ dap_poifi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  dap_poifi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<dap_poifi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<dap_poifi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline dap_poifi_tclDescription::dap_poifi_tclDescription(fi_tclInContext* poIn, dap_poifi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline dap_poifi_tclDescription::dap_poifi_tclDescription(fi_tclOutContext* poOut, dap_poifi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

