#ifndef __DAP_POIFIDEBUGVISITOR_H__
#define __DAP_POIFIDEBUGVISITOR_H__

class MY_DECL dap_poifi_tclPrintVisitor : public dap_poifi_tclVisitorBase {

private:
   /* default constructor */ dap_poifi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   dap_poifi_tclPrintVisitor(fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Reserved(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u8_Percent(fi_tcl_u8_Percent& o_u8_Percent);
   virtual tVoid vVisit_u16_IndexInReferenceList(fi_tcl_u16_IndexInReferenceList& o_u16_IndexInReferenceList);
   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& o_s32_Meter);
   virtual tVoid vVisit_s16_CentimeterSecond(fi_tcl_s16_CentimeterSecond& o_s16_CentimeterSecond);
   virtual tBool bDoExpand_FIVersion(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tBool bDoExpand_PositionWGS84(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_ISOLanguageCode(fi_tcl_e16_ISOLanguageCode& o_e16_ISOLanguageCode);
   virtual tVoid vVisit_u8_DirectionAbsolute(fi_tcl_u8_DirectionAbsolute& o_u8_DirectionAbsolute);
   virtual tVoid vVisit_e8_DapOrderType(fi_tcl_e8_DapOrderType& o_e8_DapOrderType);
   virtual tBool bDoExpand_UniqueID(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ResultBlocks(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_NavOneCellDirection(fi_tcl_e8_NavOneCellDirection& o_e8_NavOneCellDirection);
   virtual tVoid vVisit_e8_BinContainerTypes(fi_tcl_e8_BinContainerTypes& o_e8_BinContainerTypes);
   virtual tVoid vVisit_b16_PositionReliability(fi_tcl_b16_PositionReliability& o_b16_PositionReliability);
   virtual tBool bDoExpand_PositionHeadingSpeed(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u32_DataSetId(fi_tcl_u32_DataSetId& o_u32_DataSetId);
   virtual tBool bDoExpand_NavClusterDesc(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavOneCellDesc(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_SideInfo(fi_tcl_e8_SideInfo& o_e8_SideInfo);
   virtual tVoid vVisit_s32_EMU(fi_tcl_s32_EMU& o_s32_EMU);
   virtual tBool bDoExpand_NavZeroCellDesc(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_NavLocationDescType(fi_tcl_e8_NavLocationDescType& o_e8_NavLocationDescType);
   virtual tBool bDoExpand_NavLocationDesc(dap_poifi_tclSemanticDomain::tenType enSemantic);
#ifndef FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_NavLocationBinContainer(dap_poifi_tclSemanticDomain::tenType enSemantic);
#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_e8_NavIndexZFDestinationType(fi_tcl_e8_NavIndexZFDestinationType& o_e8_NavIndexZFDestinationType);
   virtual tVoid vVisit_e8_NavLocationNavDataType(fi_tcl_e8_NavLocationNavDataType& o_e8_NavLocationNavDataType);
   virtual tBool bDoExpand_NavLocationDataDesc(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavSpotDestinationOneCellProperty(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavSpotDestinationOneCellDesc(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavSpotDestinationOneCellListSet(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavStreetDestinationOneCellProperty(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavStreetDestinationOneCellDesc(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavStreetDestinationOneCellListSet(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_NavIntersectionType(fi_tcl_e8_NavIntersectionType& o_e8_NavIntersectionType);
   virtual tBool bDoExpand_NavIntersectionDestinationZeroCellProperty(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavIntersectionDestinationZeroCellDesc(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavIntersectionDestinationZeroCellListSet(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavAreaDescriptionCircle(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavAreaDescriptionPolygon(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_SelectionCriterionType(fi_tcl_e16_SelectionCriterionType& o_e16_SelectionCriterionType);
   virtual tVoid vVisit_e8_LocationDescriptionDataType(fi_tcl_e8_LocationDescriptionDataType& o_e8_LocationDescriptionDataType);
   virtual tVoid vVisit_b8_LocationDescriptorStatus(fi_tcl_b8_LocationDescriptorStatus& o_b8_LocationDescriptorStatus);
   virtual tBool bDoExpand_LocationDescriptor(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LocationDescription(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StringPosition(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StringID(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_FLIString(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_PositionStatus(fi_tcl_b8_PositionStatus& o_b8_PositionStatus);
   virtual tBool bDoExpand_ListOfPositions(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_POIType(fi_tcl_e16_POIType& o_e16_POIType);
   virtual tVoid vVisit_b16_POIType(fi_tcl_b16_POIType& o_b16_POIType);
   virtual tVoid vVisit_e8_POIDataset(fi_tcl_e8_POIDataset& o_e8_POIDataset);
   virtual tBool bDoExpand_UserPOIElement(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Outline(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_IndexCatBrand(dap_poifi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MapIdPair(dap_poifi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   fi_tclOutput* poOutput;
};


class MY_DECL dap_poifi_tclRandomInitVisitor : public dap_poifi_tclVisitorBase {
public:

   dap_poifi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_u8_Percent(fi_tcl_u8_Percent& o_u8_Percent);
   virtual tVoid vVisit_u16_IndexInReferenceList(fi_tcl_u16_IndexInReferenceList& o_u16_IndexInReferenceList);
   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& o_s32_Meter);
   virtual tVoid vVisit_s16_CentimeterSecond(fi_tcl_s16_CentimeterSecond& o_s16_CentimeterSecond);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tVoid vVisit_e16_ISOLanguageCode(fi_tcl_e16_ISOLanguageCode& o_e16_ISOLanguageCode);
   virtual tVoid vVisit_u8_DirectionAbsolute(fi_tcl_u8_DirectionAbsolute& o_u8_DirectionAbsolute);
   virtual tVoid vVisit_e8_DapOrderType(fi_tcl_e8_DapOrderType& o_e8_DapOrderType);
   virtual tVoid vVisit_e8_NavOneCellDirection(fi_tcl_e8_NavOneCellDirection& o_e8_NavOneCellDirection);
   virtual tVoid vVisit_e8_BinContainerTypes(fi_tcl_e8_BinContainerTypes& o_e8_BinContainerTypes);
   virtual tVoid vVisit_b16_PositionReliability(fi_tcl_b16_PositionReliability& o_b16_PositionReliability);
   virtual tVoid vVisit_u32_DataSetId(fi_tcl_u32_DataSetId& o_u32_DataSetId);
   virtual tVoid vVisit_e8_SideInfo(fi_tcl_e8_SideInfo& o_e8_SideInfo);
   virtual tVoid vVisit_s32_EMU(fi_tcl_s32_EMU& o_s32_EMU);
   virtual tVoid vVisit_e8_NavLocationDescType(fi_tcl_e8_NavLocationDescType& o_e8_NavLocationDescType);
#ifndef FI_S_EXTERNAL_FI
#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_e8_NavIndexZFDestinationType(fi_tcl_e8_NavIndexZFDestinationType& o_e8_NavIndexZFDestinationType);
   virtual tVoid vVisit_e8_NavLocationNavDataType(fi_tcl_e8_NavLocationNavDataType& o_e8_NavLocationNavDataType);
   virtual tVoid vVisit_e8_NavIntersectionType(fi_tcl_e8_NavIntersectionType& o_e8_NavIntersectionType);
   virtual tVoid vVisit_e16_SelectionCriterionType(fi_tcl_e16_SelectionCriterionType& o_e16_SelectionCriterionType);
   virtual tVoid vVisit_e8_LocationDescriptionDataType(fi_tcl_e8_LocationDescriptionDataType& o_e8_LocationDescriptionDataType);
   virtual tVoid vVisit_b8_LocationDescriptorStatus(fi_tcl_b8_LocationDescriptorStatus& o_b8_LocationDescriptorStatus);
   virtual tVoid vVisit_b8_PositionStatus(fi_tcl_b8_PositionStatus& o_b8_PositionStatus);
   virtual tVoid vVisit_e16_POIType(fi_tcl_e16_POIType& o_e16_POIType);
   virtual tVoid vVisit_b16_POIType(fi_tcl_b16_POIType& o_b16_POIType);
   virtual tVoid vVisit_e8_POIDataset(fi_tcl_e8_POIDataset& o_e8_POIDataset);
	tU32 u32ListSize;
};

#endif
