/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef DAP_LIFITYPES_HEADER
#define DAP_LIFITYPES_HEADER

// #include <vector>
// 


class dap_lifi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class dap_lifi_tclMsgCloseContextMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgCloseContextMethodStart():u8OrderType(),DatasetId(0),UserId() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgCloseContextMethodStart& operator=(const dap_lifi_tclMsgCloseContextMethodStart& coRef);
   dap_lifi_tclMsgCloseContextMethodStart(const dap_lifi_tclMsgCloseContextMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 DatasetId;
   fi_tcl_e8_UserID UserId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgCloseContextMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_CLOSECONTEXTMETHODSTART;}
};

class dap_lifi_tclMsgCloseContextMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgCloseContextMethodResult():UnusedUserId() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgCloseContextMethodResult& operator=(const dap_lifi_tclMsgCloseContextMethodResult& coRef);
   dap_lifi_tclMsgCloseContextMethodResult(const dap_lifi_tclMsgCloseContextMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_UserID UnusedUserId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgCloseContextMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_CLOSECONTEXTMETHODRESULT;}
};

class dap_lifi_tclMsgGetObjectsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgGetObjectsMethodStart():u8OrderType(),DatasetId(0),UserId(),UILanguage(),LocationDescription(),SelectionCriteriaMask(),GetOption() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgGetObjectsMethodStart& operator=(const dap_lifi_tclMsgGetObjectsMethodStart& coRef);
   dap_lifi_tclMsgGetObjectsMethodStart(const dap_lifi_tclMsgGetObjectsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 DatasetId;
   fi_tcl_e8_UserID UserId;
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_LocationDescription LocationDescription;
   fi_tcl_b8_SelectionCriteriaMask SelectionCriteriaMask;
   fi_tcl_b8_CriteriaGetOptions GetOption;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgGetObjectsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_GETOBJECTSMETHODSTART;}
};

class dap_lifi_tclMsgGetObjectsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgGetObjectsMethodResult():UILanguage(),InputContinuationMask() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgGetObjectsMethodResult& operator=(const dap_lifi_tclMsgGetObjectsMethodResult& coRef);
   dap_lifi_tclMsgGetObjectsMethodResult(const dap_lifi_tclMsgGetObjectsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   std::vector<fi_tcl_DAPISelectableCriterion, std::allocator<fi_tcl_DAPISelectableCriterion> > SelectionCriteriaList;
   fi_tcl_b8_InputContinuation InputContinuationMask;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgGetObjectsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_GETOBJECTSMETHODRESULT;}
};

class dap_lifi_tclMsgGetObjectDescriptionMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgGetObjectDescriptionMethodStart():u8OrderType(),DatasetId(0),UserId(),UILanguage(),RefinementCriteriaMask() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgGetObjectDescriptionMethodStart& operator=(const dap_lifi_tclMsgGetObjectDescriptionMethodStart& coRef);
   dap_lifi_tclMsgGetObjectDescriptionMethodStart(const dap_lifi_tclMsgGetObjectDescriptionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 DatasetId;
   fi_tcl_e8_UserID UserId;
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_b8_RefinementCriteriaMask RefinementCriteriaMask;
   std::vector<tU16, std::allocator<tU16> > ObjectCodeList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgGetObjectDescriptionMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_GETOBJECTDESCRIPTIONMETHODSTART;}
};

class dap_lifi_tclMsgGetObjectDescriptionMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgGetObjectDescriptionMethodResult():UILanguage() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgGetObjectDescriptionMethodResult& operator=(const dap_lifi_tclMsgGetObjectDescriptionMethodResult& coRef);
   dap_lifi_tclMsgGetObjectDescriptionMethodResult(const dap_lifi_tclMsgGetObjectDescriptionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   std::vector<fi_tcl_ObjectDescription, std::allocator<fi_tcl_ObjectDescription> > ObjectDescriptionList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgGetObjectDescriptionMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_GETOBJECTDESCRIPTIONMETHODRESULT;}
};

class dap_lifi_tclMsgGetElementNumberMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgGetElementNumberMethodStart():u8OrderType(),DatasetId(0),UserId(),UILanguage(),LocationDescription(),MaxNumberOfElements(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgGetElementNumberMethodStart& operator=(const dap_lifi_tclMsgGetElementNumberMethodStart& coRef);
   dap_lifi_tclMsgGetElementNumberMethodStart(const dap_lifi_tclMsgGetElementNumberMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 DatasetId;
   fi_tcl_e8_UserID UserId;
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_LocationDescription LocationDescription;
   std::vector<tU16, std::allocator<tU16> > FilterAttributes;
   tU32 MaxNumberOfElements;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgGetElementNumberMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_GETELEMENTNUMBERMETHODSTART;}
};

class dap_lifi_tclMsgGetElementNumberMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgGetElementNumberMethodResult():UILanguage(),NumberOfElements(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgGetElementNumberMethodResult& operator=(const dap_lifi_tclMsgGetElementNumberMethodResult& coRef);
   dap_lifi_tclMsgGetElementNumberMethodResult(const dap_lifi_tclMsgGetElementNumberMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   tU32 NumberOfElements;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgGetElementNumberMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_GETELEMENTNUMBERMETHODRESULT;}
};

class dap_lifi_tclMsgGetASFCharactersMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgGetASFCharactersMethodStart():u8OrderType(),DatasetId(0),UserId(),UILanguage(),LocationDescription(),PartialNameRotation(0),AllCharsInCountry(0),LowerCaseLetters(0),SortReferencePosition() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgGetASFCharactersMethodStart& operator=(const dap_lifi_tclMsgGetASFCharactersMethodStart& coRef);
   dap_lifi_tclMsgGetASFCharactersMethodStart(const dap_lifi_tclMsgGetASFCharactersMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 DatasetId;
   fi_tcl_e8_UserID UserId;
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_LocationDescription LocationDescription;
   std::vector<tU16, std::allocator<tU16> > AttributeCodes;
   tBool PartialNameRotation;
   tBool AllCharsInCountry;
   tBool LowerCaseLetters;
   fi_tcl_PositionWGS84 SortReferencePosition;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgGetASFCharactersMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_GETASFCHARACTERSMETHODSTART;}
};

class dap_lifi_tclMsgGetASFCharactersMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgGetASFCharactersMethodResult():UILanguage(),Status(0),RemainingEntries(0),CompletionString(),SubsequentLetters() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgGetASFCharactersMethodResult& operator=(const dap_lifi_tclMsgGetASFCharactersMethodResult& coRef);
   dap_lifi_tclMsgGetASFCharactersMethodResult(const dap_lifi_tclMsgGetASFCharactersMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   tBool Status;
   tU32 RemainingEntries;
   fi_tclString CompletionString;
   fi_tclString SubsequentLetters;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgGetASFCharactersMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_GETASFCHARACTERSMETHODRESULT;}
};

class dap_lifi_tclMsgGetEntryListMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgGetEntryListMethodStart():u8OrderType(),DatasetId(0),UserId(),UILanguage(),LocationDescription(),Status(),SortOrder(),ListOffset(0),Limit(0),SortReferencePosition(),NoMatchingChars(0),MaxRadius(),CurrentPositionInfo() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgGetEntryListMethodStart& operator=(const dap_lifi_tclMsgGetEntryListMethodStart& coRef);
   dap_lifi_tclMsgGetEntryListMethodStart(const dap_lifi_tclMsgGetEntryListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 DatasetId;
   fi_tcl_e8_UserID UserId;
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_LocationDescription LocationDescription;
   fi_tcl_b8_ListGetOptions Status;
   fi_tcl_b8_ListSortOptions SortOrder;
   tS32 ListOffset;
   tU32 Limit;
   fi_tcl_PositionWGS84 SortReferencePosition;
   std::vector<tU16, std::allocator<tU16> > FilterAttributes;
   tU32 NoMatchingChars;
   fi_tcl_s32_Meter MaxRadius;
   fi_tcl_LocationDescription CurrentPositionInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgGetEntryListMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_GETENTRYLISTMETHODSTART;}
};

class dap_lifi_tclMsgGetEntryListMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgGetEntryListMethodResult():UILanguage(),Status(),LocationDescription() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgGetEntryListMethodResult& operator=(const dap_lifi_tclMsgGetEntryListMethodResult& coRef);
   dap_lifi_tclMsgGetEntryListMethodResult(const dap_lifi_tclMsgGetEntryListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_b8_ListResultOptions Status;
   std::vector<fi_tcl_ListElement, std::allocator<fi_tcl_ListElement> > Elements;
   fi_tcl_LocationDescription LocationDescription;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgGetEntryListMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_GETENTRYLISTMETHODRESULT;}
};

class dap_lifi_tclMsgGetEntryListMethodResultFirst : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgGetEntryListMethodResultFirst():UILanguage(),Status(),LocationDescription() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgGetEntryListMethodResultFirst& operator=(const dap_lifi_tclMsgGetEntryListMethodResultFirst& coRef);
   dap_lifi_tclMsgGetEntryListMethodResultFirst(const dap_lifi_tclMsgGetEntryListMethodResultFirst& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_b8_ListResultOptions Status;
   std::vector<fi_tcl_ListElement, std::allocator<fi_tcl_ListElement> > Elements;
   fi_tcl_LocationDescription LocationDescription;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgGetEntryListMethodResultFirst& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_GETENTRYLISTMETHODRESULTFIRST;}
};

class dap_lifi_tclMsgGetEntryListMethodResultMiddle : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgGetEntryListMethodResultMiddle():UILanguage(),Status(),LocationDescription() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgGetEntryListMethodResultMiddle& operator=(const dap_lifi_tclMsgGetEntryListMethodResultMiddle& coRef);
   dap_lifi_tclMsgGetEntryListMethodResultMiddle(const dap_lifi_tclMsgGetEntryListMethodResultMiddle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_b8_ListResultOptions Status;
   std::vector<fi_tcl_ListElement, std::allocator<fi_tcl_ListElement> > Elements;
   fi_tcl_LocationDescription LocationDescription;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgGetEntryListMethodResultMiddle& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_GETENTRYLISTMETHODRESULTMIDDLE;}
};

class dap_lifi_tclMsgGetEntryListMethodResultLast : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgGetEntryListMethodResultLast():UILanguage(),Status(),LocationDescription() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgGetEntryListMethodResultLast& operator=(const dap_lifi_tclMsgGetEntryListMethodResultLast& coRef);
   dap_lifi_tclMsgGetEntryListMethodResultLast(const dap_lifi_tclMsgGetEntryListMethodResultLast& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_b8_ListResultOptions Status;
   std::vector<fi_tcl_ListElement, std::allocator<fi_tcl_ListElement> > Elements;
   fi_tcl_LocationDescription LocationDescription;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgGetEntryListMethodResultLast& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_GETENTRYLISTMETHODRESULTLAST;}
};

class dap_lifi_tclMsgReadBinaryDestinationMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgReadBinaryDestinationMethodStart():u8OrderType(),DatasetId(0),UserId(),UILanguage(),LocationDescription(),MaxNumberOfCells(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgReadBinaryDestinationMethodStart& operator=(const dap_lifi_tclMsgReadBinaryDestinationMethodStart& coRef);
   dap_lifi_tclMsgReadBinaryDestinationMethodStart(const dap_lifi_tclMsgReadBinaryDestinationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 DatasetId;
   fi_tcl_e8_UserID UserId;
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_LocationDescription LocationDescription;
   tU16 MaxNumberOfCells;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgReadBinaryDestinationMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_READBINARYDESTINATIONMETHODSTART;}
};

class dap_lifi_tclMsgReadBinaryDestinationMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgReadBinaryDestinationMethodResult():UILanguage(),Properties(),Category() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgReadBinaryDestinationMethodResult& operator=(const dap_lifi_tclMsgReadBinaryDestinationMethodResult& coRef);
   dap_lifi_tclMsgReadBinaryDestinationMethodResult(const dap_lifi_tclMsgReadBinaryDestinationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   std::vector<fi_tcl_PositionWGS84, std::allocator<fi_tcl_PositionWGS84> > ElementPositions;
   std::vector<fi_tcl_PositionWGS84, std::allocator<fi_tcl_PositionWGS84> > AccessCoordinates;
   fi_tcl_b8_NavBinProperties Properties;
   std::vector<fi_tcl_ClusterInfo, std::allocator<fi_tcl_ClusterInfo> > ClusterList;
   fi_tcl_e16_SelectionCriterionType Category;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgReadBinaryDestinationMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_READBINARYDESTINATIONMETHODRESULT;}
};

class dap_lifi_tclMsgGetObjectDetailMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgGetObjectDetailMethodStart():u8OrderType(),DatasetId(0),UserId(),UILanguage(),LocationDescription() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgGetObjectDetailMethodStart& operator=(const dap_lifi_tclMsgGetObjectDetailMethodStart& coRef);
   dap_lifi_tclMsgGetObjectDetailMethodStart(const dap_lifi_tclMsgGetObjectDetailMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 DatasetId;
   fi_tcl_e8_UserID UserId;
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_LocationDescription LocationDescription;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgGetObjectDetailMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_GETOBJECTDETAILMETHODSTART;}
};

class dap_lifi_tclMsgGetObjectDetailMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgGetObjectDetailMethodResult():UILanguage() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgGetObjectDetailMethodResult& operator=(const dap_lifi_tclMsgGetObjectDetailMethodResult& coRef);
   dap_lifi_tclMsgGetObjectDetailMethodResult(const dap_lifi_tclMsgGetObjectDetailMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   std::vector<fi_tcl_ObjectDetail, std::allocator<fi_tcl_ObjectDetail> > Information;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgGetObjectDetailMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_GETOBJECTDETAILMETHODRESULT;}
};

class dap_lifi_tclMsgResolveLocationDescriptionMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgResolveLocationDescriptionMethodStart():u8OrderType(),DatasetId(0),UserId(),UILanguage(),LocationDescription(),ResolutionType() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgResolveLocationDescriptionMethodStart& operator=(const dap_lifi_tclMsgResolveLocationDescriptionMethodStart& coRef);
   dap_lifi_tclMsgResolveLocationDescriptionMethodStart(const dap_lifi_tclMsgResolveLocationDescriptionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 DatasetId;
   fi_tcl_e8_UserID UserId;
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_LocationDescription LocationDescription;
   fi_tcl_b8_ResolutionType ResolutionType;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgResolveLocationDescriptionMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_RESOLVELOCATIONDESCRIPTIONMETHODSTART;}
};

class dap_lifi_tclMsgResolveLocationDescriptionMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgResolveLocationDescriptionMethodResult():UILanguage(),LocationDescription() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgResolveLocationDescriptionMethodResult& operator=(const dap_lifi_tclMsgResolveLocationDescriptionMethodResult& coRef);
   dap_lifi_tclMsgResolveLocationDescriptionMethodResult(const dap_lifi_tclMsgResolveLocationDescriptionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_LocationDescription LocationDescription;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgResolveLocationDescriptionMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_RESOLVELOCATIONDESCRIPTIONMETHODRESULT;}
};

class dap_lifi_tclMsgReadLanguagesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgReadLanguagesMethodStart():u8OrderType(),DatasetId(0),UserId() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgReadLanguagesMethodStart& operator=(const dap_lifi_tclMsgReadLanguagesMethodStart& coRef);
   dap_lifi_tclMsgReadLanguagesMethodStart(const dap_lifi_tclMsgReadLanguagesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 DatasetId;
   fi_tcl_e8_UserID UserId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgReadLanguagesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_READLANGUAGESMETHODSTART;}
};

class dap_lifi_tclMsgReadLanguagesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgReadLanguagesMethodResult():CurrentLanguage() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgReadLanguagesMethodResult& operator=(const dap_lifi_tclMsgReadLanguagesMethodResult& coRef);
   dap_lifi_tclMsgReadLanguagesMethodResult(const dap_lifi_tclMsgReadLanguagesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode CurrentLanguage;
   std::vector<fi_tcl_e16_ISOLanguageCode, std::allocator<fi_tcl_e16_ISOLanguageCode> > AvailableLanguages;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgReadLanguagesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_READLANGUAGESMETHODRESULT;}
};

class dap_lifi_tclMsgSetCurrentLanguageMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgSetCurrentLanguageMethodStart():u8OrderType(),DatasetId(0),UserId(),NewLanguage() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgSetCurrentLanguageMethodStart& operator=(const dap_lifi_tclMsgSetCurrentLanguageMethodStart& coRef);
   dap_lifi_tclMsgSetCurrentLanguageMethodStart(const dap_lifi_tclMsgSetCurrentLanguageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 DatasetId;
   fi_tcl_e8_UserID UserId;
   fi_tcl_e16_ISOLanguageCode NewLanguage;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgSetCurrentLanguageMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_SETCURRENTLANGUAGEMETHODSTART;}
};

class dap_lifi_tclMsgSetCurrentLanguageMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgSetCurrentLanguageMethodResult():CurrentLanguage() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgSetCurrentLanguageMethodResult& operator=(const dap_lifi_tclMsgSetCurrentLanguageMethodResult& coRef);
   dap_lifi_tclMsgSetCurrentLanguageMethodResult(const dap_lifi_tclMsgSetCurrentLanguageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode CurrentLanguage;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgSetCurrentLanguageMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_SETCURRENTLANGUAGEMETHODRESULT;}
};

class dap_lifi_tclMsgGetDataSetsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgGetDataSetsMethodStart():u8OrderType(),UnusedUserId(),UILanguage() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgGetDataSetsMethodStart& operator=(const dap_lifi_tclMsgGetDataSetsMethodStart& coRef);
   dap_lifi_tclMsgGetDataSetsMethodStart(const dap_lifi_tclMsgGetDataSetsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   fi_tcl_e8_UserID UnusedUserId;
   fi_tcl_e16_ISOLanguageCode UILanguage;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgGetDataSetsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_GETDATASETSMETHODSTART;}
};

class dap_lifi_tclMsgGetDataSetsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgGetDataSetsMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgGetDataSetsMethodResult& operator=(const dap_lifi_tclMsgGetDataSetsMethodResult& coRef);
   dap_lifi_tclMsgGetDataSetsMethodResult(const dap_lifi_tclMsgGetDataSetsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_DataSetElement, std::allocator<fi_tcl_DataSetElement> > DataSets;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgGetDataSetsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_GETDATASETSMETHODRESULT;}
};

class dap_lifi_tclMsgGetAddressFormatMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgGetAddressFormatMethodStart():u8OrderType(),DatasetId(0),UserId(),LocationDescription(),UILanguage(),CurrentPositionInfo() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgGetAddressFormatMethodStart& operator=(const dap_lifi_tclMsgGetAddressFormatMethodStart& coRef);
   dap_lifi_tclMsgGetAddressFormatMethodStart(const dap_lifi_tclMsgGetAddressFormatMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 DatasetId;
   fi_tcl_e8_UserID UserId;
   fi_tcl_LocationDescription LocationDescription;
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_LocationDescription CurrentPositionInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgGetAddressFormatMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_GETADDRESSFORMATMETHODSTART;}
};

class dap_lifi_tclMsgGetAddressFormatMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgGetAddressFormatMethodResult():UILanguage() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgGetAddressFormatMethodResult& operator=(const dap_lifi_tclMsgGetAddressFormatMethodResult& coRef);
   dap_lifi_tclMsgGetAddressFormatMethodResult(const dap_lifi_tclMsgGetAddressFormatMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_e16_SelectionCriterionType, std::allocator<fi_tcl_e16_SelectionCriterionType> > SelectionCriteriaList;
   fi_tcl_e16_ISOLanguageCode UILanguage;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgGetAddressFormatMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_GETADDRESSFORMATMETHODRESULT;}
};

class dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodStart():u8OrderType(),DatasetId(0),UserId(),UILanguage(),LocationDescription(),MaxRadius(),CurrentPositionInfo() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodStart& operator=(const dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodStart& coRef);
   dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodStart(const dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 DatasetId;
   fi_tcl_e8_UserID UserId;
   fi_tcl_e16_ISOLanguageCode UILanguage;
   fi_tcl_LocationDescription LocationDescription;
   fi_tcl_s32_Meter MaxRadius;
   fi_tcl_LocationDescription CurrentPositionInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_GETNEARBYSTATESORCOUNTRIESMETHODSTART;}
};

class dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodResult():UILanguage() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodResult& operator=(const dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodResult& coRef);
   dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodResult(const dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e16_ISOLanguageCode UILanguage;
   std::vector<fi_tcl_ListElement, std::allocator<fi_tcl_ListElement> > Elements;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_GETNEARBYSTATESORCOUNTRIESMETHODRESULT;}
};

class dap_lifi_tclMsgGetAddressFormatTableMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgGetAddressFormatTableMethodStart():u8OrderType(),DatasetId(0),UserId() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgGetAddressFormatTableMethodStart& operator=(const dap_lifi_tclMsgGetAddressFormatTableMethodStart& coRef);
   dap_lifi_tclMsgGetAddressFormatTableMethodStart(const dap_lifi_tclMsgGetAddressFormatTableMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_DapOrderType u8OrderType;
   tU32 DatasetId;
   fi_tcl_e8_UserID UserId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgGetAddressFormatTableMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_GETADDRESSFORMATTABLEMETHODSTART;}
};

class dap_lifi_tclMsgGetAddressFormatTableMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgGetAddressFormatTableMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgGetAddressFormatTableMethodResult& operator=(const dap_lifi_tclMsgGetAddressFormatTableMethodResult& coRef);
   dap_lifi_tclMsgGetAddressFormatTableMethodResult(const dap_lifi_tclMsgGetAddressFormatTableMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_AddressTemplate, std::allocator<fi_tcl_AddressTemplate> > Templates;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgGetAddressFormatTableMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_GETADDRESSFORMATTABLEMETHODRESULT;}
};

class dap_lifi_tclMsgCurrentSearchProgressStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   dap_lifi_tclMsgCurrentSearchProgressStatus():Radius(),ObjectCount(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   dap_lifi_tclMsgCurrentSearchProgressStatus& operator=(const dap_lifi_tclMsgCurrentSearchProgressStatus& coRef);
   dap_lifi_tclMsgCurrentSearchProgressStatus(const dap_lifi_tclMsgCurrentSearchProgressStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_s32_Meter Radius;
   tU32 ObjectCount;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const dap_lifi_tclMsgCurrentSearchProgressStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return dap_lifi_tclToken::EN_MSG_CURRENTSEARCHPROGRESSSTATUS;}
};


#endif
